.TH GraphicBlock 3U "30 January 1991" "Unidraw" "InterViews Reference Manual"
.SH NAME
GraphicBlock \- interactor that displays a graphic
.SH SYNOPSIS
.B #include <Unidraw/Graphic/grblock.h>
.SH DESCRIPTION
A GraphicBlock is an interactor that displays a graphic.
GraphicBlocks are useful for interactors whose appearance is most
conveniently defined with structured graphics.  The GraphicBlock will
draw its graphic in response to Draw and Redraw calls.

The graphic can be aligned with respect to the GraphicBlock's canvas.
The GraphicBlock positions its graphic so that its bounding box is
aligned with the canvas when the canvas is allocated.  On subsequent
resizes, the portion of the graphic within the canvas is aligned.
With the default alignment, for example, a graphic will be centered in
the canvas initially.  If the canvas is resized, then the part of the
graphic in the center of the canvas prior to resizing will appear in
the center of the canvas after resizing.

The graphic can be scrolled and zoomed as well.  Changing either the
\fIcurwidth/curheight\fP or the \fIwidth/height\fP members of the
GraphicBlock's perspective effectively zooms the graphic.  For
example, calling the Adjust member function with a perspective whose
\fIcurwidth\fP and \fIcurheight\fP are half that of the GraphicBlock's
canvas will enlarge the graphic by a factor of two. Zooming can be
limited to magnifications that are powers of two by specifying Binary
for the Zooming parameter.

A GraphicBlock's natural size depends on the size of the graphic it
displays and on any padding (white space surrounding the graphic)
specified.  GraphicBlocks are infinitely stretchable horizontally and
vertically by default.
.SH PUBLIC OPERATIONS
.TP
.B "GraphicBlock("
.ns
.TP
.B "    Graphic*, Coord pad = 0,"
.ns
.TP
.B "    Alignment = Center, Zooming = Continuous"
.ns
.TP
.B ")"
.ns
.TP
.B "GraphicBlock("
.ns
.TP
.B "    const char*, Graphic*, Coord pad = 0,"
.ns
.TP
.B "    Alignment = Center, Zooming = Continuous"
.ns
.TP
.B ")"
.br
Create a new GraphicBlock with the specified graphic, padding,
alignment, and zooming behavior.  You can also specify the
GraphicBlock's instance name with the second form.
.TP
.B "void Update()"
Update updates the GraphicBlock's perspective to reflect any change in
the values returned by GetGraphicBox (described below), which defines
the extremities of the scrolling area.  Update should be called after
the graphic is changed.
.TP
.B "virtual void Highlight(boolean)"
When highlighted, GraphicBlock draws itself with the foreground and
background colors of its graphic and its painter reversed.
GraphicBlock uses its output painter to fill its canvas with background
color, thus providing a background for the graphic.
.TP
.B "Graphic* GetGraphic()"
Return the graphic in the GraphicBlock, stored in the \fI_graphic\fP
protected member variable.
.TP
.B "float GetMagnification()"
.ns
.TP
.B "void SetMagnification(float)"
Get and set the magnification applied to the graphic, relative to its
magnification when the GraphicBlock was created (1x).
.SH PROTECTED OPERATIONS
.TP
.B "void Init()"
Initialize the GraphicBlock, positioning its graphic according to the
alignment specified in the constructor.  The constructor calls this
operation.  Subclasses should call Init if they should replace the
displayed graphic with another.
.TP
.B "void UpdatePerspective()"
Change the GraphicBlock's perspective to reflect the bounding box of
the graphic.  UpdatePerspective encapsulates this functionality to
facilitate redefinition of the Update function in derived classes.
.TP
.B "void GrabScroll(Event&)"
.ns
.TP
.B "void RateScroll(Event&)"
Initiate grab scrolling or rate scrolling.  Once called, GrabScroll
(RateScroll) polls the current mouse position as long as the middle
(right) button is pressed.  As GrabScroll polls, it scrolls the
GraphicBlock to follow the mouse position, making it appear as though
the user is dragging the GraphicBlock's graphic itself.  Each time
RateScroll polls the mouse, it scrolls the GraphicBlock by an amount
corresponding to the differential between the current and initial
mouse positions.  This creates the illusion of a joystick interface:
the further away the mouse is from its initial position, the greater
the scrolling increment and the faster the graphic appears to scroll;
scrolling slows down, stops, and reverses direction as the user drags
the mouse back towards and past the initial position.
.TP
.B "virtual void GetGraphicBox(Coord&, Coord&, Coord&, Coord&)"
Return the lower-left and upper-right coordinates of the total area in
which to scroll.  By default, this area is corresponds to the
graphic's bounding box.
.TP
.B "virtual void Zoom(Perspective&)"
.ns
.TP
.B "virtual void Scroll(Perspective&)"
These functions define how zooming and scrolling are inferred from the
perspective supplied to Adjust.  The default behaviors implement
standard scrolling semantics and zooming as described above.
.TP
.B "virtual float LimitMagnification(float)"
Limit the amount of magnification that can be applied to the graphic.
This function is used as a filter to convert desired magnifications
into legal ones.  By default, the argument is returned; no limits are
imposed.
.SH SEE ALSO
Graphic(3U), Interactor(3I), Perspective(3I)
