/* -*- Mode:Text -*- */
#ifndef lint
static char Rcs_Id[] =
    "$Id: sq.c,v 1.6 90/12/31 00:59:26 geoff Exp $";
#endif

/*
 * $Log:	sq.c,v $
 * Revision 1.6  90/12/31  00:59:26  geoff
 * Reformat to follow a consistent convention throughout ispell
 * 
 * Revision 1.5  89/04/28  01:16:59  geoff
 * Change Header to Id;  nobody cares about my pathnames.
 * 
 * Revision 1.4  88/11/25  19:54:17  geoff
 * Get rid of an unused array.
 * 
 * Revision 1.3  88/03/27  01:04:50  geoff
 * Fix to encode prefix sizes as a single printable (alphanumeric)
 * character, rather than using a binary byte.  This loses very little,
 * since it's not likely there are many dictionaries that make heavy use
 * of very long prefixes.  The advantage is that the output is mailable.
 * 
 * Revision 1.2  88/03/13  00:58:20  geoff
 * Add ID keywords
 * 
 */

#include <stdio.h>

/*
 * The following table encodes prefix sizes as a single character.  A
 * matching table will be found in unsq.c.
 */
static char size_encodings[] =
    {
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',	/* 00-09 */
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',	/* 10-19 */
    'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',	/* 20-29 */
    'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd',	/* 30-39 */
    'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',	/* 40-49 */
    'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x',	/* 50-59 */
    'y', 'z'						/* 60-61 */
    };

#define MAX_PREFIX	(sizeof (size_encodings) - 1)

main ()
    {
    char	word[257];
    static char	prev[257] = "";

    while (gets (word) != NULL)
	trunc (word, prev);
    exit(0);
    }

trunc (word, prev) 
    char *		word;
    char *		prev;
    {
    register char *	wordp;
    register char *	prevp;
    register int	same_count;

    wordp = word;
    prevp = prev;
    for (same_count = 0;  *wordp == *prevp++;  ++wordp, ++same_count)
	;
    if (same_count>MAX_PREFIX)
	same_count = MAX_PREFIX;
    putchar (size_encodings[same_count]);
    puts (wordp);
    strcpy (prev, word);
    }

