


JVIM(1)                  USER COMMANDS                    JVIM(1)



NAME
     jvim - Japanized Vi IMproved, a programmers text editor

SYNOPSIS
     jvim [options] [file ..]
     jvim [options] -t tag
     jvim [options] +[command] file ..
     jvim [options] -c {command} file ..
     jvim [options] -e [errorfile]

DESCRIPTION
     JVim is a text editor that is upwards compatible to  vi.  It
     can be used to edit any ASCII and Japanese(EUC or JIS) text.
     It is especially useful for editing programs.

     There are a lot of enhancements above vi: multi level  undo,
     command  line  editing,  filename  completion, on line help,
     quoting, etc.. Read difference.doc  for  a  summary  of  the
     differences between vi and Vim.

     Most often Jvim is started to edit a single  file  with  the
     command

          jvim file

     More generally JVIM is started with:

          jvim [options] [filelist]

     If the filelist is missing, the editor will  start  with  an
     empty  buffer.   Otherwise  exactly one out of the following
     four may be used to choose one or more files to be edited.

     file ..     A list of file names. The first one  (alphabeti-
                 cally)  will  be  the current file and read into
                 the buffer. The cursor will be positioned on the
                 first  line  of  the  buffer. You can get to the
                 other files with the ":next" command.

     +[num] file ..
                 Same as the above, but the cursor will be  posi-
                 tioned  on  line "num". If "num" is missing, the
                 cursor will be positioned on the last line.

     +/pat file ..
                 Same as the above, but the cursor will be  posi-
                 tioned  on  the first occurrence of "pat" in the
                 current file (see reference.doc,  section  "pat-
                 tern  searches"  for  the  available search pat-
                 terns).

     +{command} file ..



Sun Release 4.1    Last change: 28 March 1992                   1






JVIM(1)                  USER COMMANDS                    JVIM(1)



     -c {command} file ..
                 Same as the above, but {command}  will  be  exe-
                 cuted after the file has been read. {command} is
                 interpreted as an Ex command. If  the  {command}
                 contains  spaces  it  must be enclosed in double
                 quotes (this depends on the shell that is used).
                 Example: Jvim "+set si" main.c

     -t {tag}    The file to edit and the initial cursor position
                 depends  on a "tag", a sort of goto label. {tag}
                 is looked up in the tags  file,  the  associated
                 file becomes the current file and the associated
                 command is executed. Mostly this is used  for  C
                 programs.  {tag} then should be a function name.
                 The effect is  that  the  file  containing  that
                 function becomes the current file and the cursor
                 is positioned on the start of the function  (see
                 reference.doc, section "tag searches").

     -e [errorfile]
                 Start in quickFix mode. The file [errorfile]  is
                 read  and  the  first  error  is  displayed.  If
                 [errorfile] is omitted the file name is obtained
                 from   the   'errorfile'   option  (defaults  to
                 "AztecC.Err" for the Amiga,  "errors"  on  other
                 systems).  Further  errors can be jumped to with
                 the ":cn"  command.  See  reference.doc  section
                 5.5.

OPTIONS
     The options, if present,  must  precede  the  filelist.  The
     options may be given in any order.

     -r          Recovery mode. The autoscript file  is  read  to
                 recover a crashed editing session. It has almost
                 the  same   effect   as   "-s   file.vim".   See
                 reference.doc, chapter "Recovery after a crash".

     -v          View mode. The 'readonly' option  will  be  set.
                 You  can  still  edit  the  buffer,  but will be
                 prevented from accidental overwriting a file. If
                 you do want to overwrite a file, add an exclama-
                 tion mark to the Ex command, as  in  ":w!".  The
                 options chapter).

     -b          Binary. A few options will be set that makes  it
                 possible to edit a binary or executable file.

     -x          (Amiga only) Jvim is not restarted to open a new
                 window.  This option should be used when Jvim is
                 executed by a program that  will  wait  for  the
                 edit  session  to  finish (e.g. mail). The ":sh"



Sun Release 4.1    Last change: 28 March 1992                   2






JVIM(1)                  USER COMMANDS                    JVIM(1)



                 and ":!" commands will not work.

     -n          No autoscript file  will  be  written.  Recovery
                 after  a  crash will be impossible. Handy if you
                 want to edit a file on a very slow medium  (e.g.
                 floppy). Can also be done with ":set uc=0".

     -s {scriptin}
                 The script file {scriptin} is read. The  charac-
                 ters  in  the file are interpreted as if you had
                 typed them. The same can be done with  the  com-
                 mand  ":source!  {scriptin}".  If the end of the
                 file is reached before the editor exits, further
                 characters are read from the keyboard.

     -w {scriptout}
                 All the characters that you type are recorded in
                 the  file {scriptout}, until you exit JVIM. This
                 is useful if you want to create a script file to
                 be used with "jvim -s" or ":source!".

     -T terminal Tells Jvim the name  of  the  terminal  you  are
                 using. Should be a terminal known to Jvim (buil-
                 tin) or defined in the termcap file.

     -d device   Open "device" for use as a terminal. Only on the
                 Amiga. Example: "-d con:20/30/600/150".

SEE ALSO
     Vim documentation:
     reference.doc: A complete reference of Vim (long)
     reference.doc.jp: Japanese version of reference.doc
     index: Overview of all command characters (useful when  map-
     ping)
     difference.doc: Overview of the differences between  vi  and
     Vim
     unix.doc: Unix-specific comments
     vim.hlp: File used by the on-line help (short)

AUTHOR
     Most of VIM was made by Bram  Moolenaar,  and  Japanized  by
     Atsushi Nakamura.
     VIM is based on Stevie, worked on  by:  Tim  Thompson,  Tony
     Andrews and G.R. (Fred) Walter

BUGS
     Probably in VIM.  And more in JVIM.








Sun Release 4.1    Last change: 28 March 1992                   3



