/* vi:ts=4:sw=4

	jptab.h generator

*/

#define JP
#include <stdio.h>
#include "jp.h"
													/* ʸε */
char *UPSYMS = "롦ġơȡܡáʡˡСѡ֡";
													/* ʸε */
char *LOSYMS = "šǡɡޡߡ¡ݡҡӡ̡͡ء";

													/* §Ԥ */
char *PCSYMS = "ݡġšǡɡˡ͡ϡѡӡաס١";
char *PCKANA = "";				/* §Ԥ̾ */
char *PCASCI = ".,:;!?>)}]-";						/* §ԤASCIIʸ*/
													/* §(close)ε */
char *POSYMS = "ơȡʡ̡ΡСҡԡ֡ءڡ";
char *POASCI = "<({[@`";						/* §(close) */

char *SPSYMS = "";								/* 򰷤ε */
char *KJSYMS = "";							/* ε */
char *KTSYMS = "";								/* ʰε */
char *HRSYMS = "";							/* Ҥ餬ʰε */


#define JPC_NG ((char)-1)
#define JUPS 1
#define JLOS 2

struct jptab
{
	char cls1, cls2;
	int punccsym:1, puncckana:1, punccasc:1;
	int puncosym:1, puncoasc:1;
	unsigned int scase:2;
	char swap;
} jptab[128];

char *macroJPC[128];

main()
{
	int i;
	char *cp, *dp;

	printf("/*\n");
	printf("   This table is generated by jptab.c. \n");
	printf("*/\n\n");
	printf("#define JUPS 1\n");
	printf("#define JLOS 2\n\n");
	printf("#define JPCS TRUE\n");
	printf("#define JPOS TRUE\n");
	printf("#define JPCK TRUE\n");
	printf("#define JPCA TRUE\n\n");
	printf("#define JPOA TRUE\n\n");
	printf("static struct jptab\n");
	printf("{\n");
	printf("\tchar\tcls1, cls2;\n");
	printf("\tint\tpunccsym:1, puncckana:1, punccasc:1;\n");
	printf("\tint\tpuncosym:1, puncoasc:1;\n");
	printf("\tunsigned int\tscase:2;\n");
	printf("\tchar\tswap;\n");
	printf("}\t");

	for(i = 0; i < 128; i++)
	{
		jptab[i].cls1 = jptab[i].cls2 = JPC_NG;
		jptab[i].scase = 0;
		jptab[i].punccsym = jptab[i].puncckana = jptab[i].punccasc = 0;
		jptab[i].puncosym = jptab[i].puncoasc = 0;
		jptab[i].swap = i;
	}

	/* init cls1 */
	for(i = ' ' + 1; i < '\177'; i++)
		jptab[i].cls1 = JPC_KANJI;
	jptab[JP1_ALNUM & 0x7f].cls1 = JPC_ALNUM;
	jptab[JP1_HIRA  & 0x7f].cls1 = JPC_HIRA;
	jptab[JP1_KATA  & 0x7f].cls1 = JPC_KATA;
	jptab[JP1_KIGOU & 0x7f].cls1 = JPC_KIGOU;

	for(i = 0; i < 128; i++)
		macroJPC[i] = "JPTAB macro JPC_XXX ERROR";
	macroJPC[0] =         "/*Spc*/ 0";
	macroJPC[JPC_ALNUM] = "JPC_ALNUM";
	macroJPC[JPC_HIRA ] = "JPC_HIRA ";
	macroJPC[JPC_KATA ] = "JPC_KATA ";
	macroJPC[JPC_KIGOU] = "JPC_KIGOU";
	macroJPC[JPC_KANJI] = "JPC_KANJI";

	/* init cls2 */
	for(i = ' ' + 1; i < '\177'; i++)
		jptab[i].cls2 = JPC_KIGOU;
	for(cp = SPSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].cls2 = 0;
	for(cp = KJSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].cls2 = JPC_KANJI;
	for(cp = KTSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].cls2 = JPC_KATA;
	for(cp = HRSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].cls2 = JPC_HIRA;

	/* init puncsym, punckana */
	for(cp = PCSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].punccsym  = 1;
	for(cp = PCKANA; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].puncckana = 1;
	for(cp = PCASCI; *cp; cp++)  jptab[ *cp & 0x7f ].punccasc = 1;

	for(cp = POSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].puncosym  = 1;
	for(cp = POASCI; *cp; cp++)  jptab[ *cp & 0x7f ].puncoasc = 1;

	/* init scase */
	for(cp = UPSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].scase = JUPS;
	for(cp = LOSYMS; *cp; cp+=2) jptab[ *(cp + 1) & 0x7f ].scase = JLOS;

	/* init swap */
	for(cp = UPSYMS, dp = LOSYMS; *cp; cp+=2, dp+=2)
		jptab[ *(cp + 1) & 0x7f ].swap = *(dp + 1) | 0x80;
	for(cp = LOSYMS, dp = UPSYMS; *cp; cp+=2, dp+=2)
		jptab[ *(cp + 1) & 0x7f ].swap = *(dp + 1) | 0x80;

	printf("\tjptab[128] = {\n");

	for(i = 0; i < 128; i++)
    {
		printf("{");

		/* cls1 */
		printf("%9s,", jptab[i].cls1==JPC_NG ? "-1": macroJPC[jptab[i].cls1]);
		/* cls2 */
		printf("%9s,", jptab[i].cls2==JPC_NG ? "-1": macroJPC[jptab[i].cls2]);

		/* punccsym  */
		printf("%s,", jptab[i].punccsym  ? "JPCS": "   0");
		/* puncckana  */
		printf("%s,", jptab[i].puncckana ? "JPCK": "   0");
		/* punccasc  */
		printf("%s,", jptab[i].punccasc  ? "JPCA": "   0");

		/* puncosym  */
		printf("%s,", jptab[i].puncosym  ? "JPOS": "   0");
		/* puncoasc  */
		printf("%s,", jptab[i].puncoasc  ? "JPOA": "   0");

		/* scase */
		switch(jptab[i].scase)
		{
			case JUPS: printf("JUPS,");break;
			case JLOS: printf("JLOS,");break;
			default:   printf("   0,");
		}

		/* swap */
		if ((jptab[i].swap & 0x7f) > ' '&& (jptab[i].swap & 0x7f) < '\177')
			printf("/*%c%c*/", JP1_KIGOU | 0x80, jptab[i].swap | 0x80);
		else
			printf("/*%2x*/", jptab[i].swap & 0x7f);
			/*printf("      ");*/
		printf("'\\%03o' ", (jptab[i].swap | 0x80) & 0xff);

		/* */
		printf("}");

		if ( i > ' ' && i < '\177')
			printf("/*%c %c%c%c%c */ ",
							i, JP1_HIRA|0x80, i|0x80,
							   JP1_KIGOU|0x80,i|0x80);
		else
			printf("/* 0x%02x  */ ", i);

		printf(i != '\177' ? ",\n": "\n");
	}
	printf("};\n\n");
	return 0;
}


