/*///////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	conf.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	931120	extracted from onewlib.c
///////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include "onew.h"

typedef struct {
	char		*name;
	char		*kname;
	RkEngine	*rk;
	KkEngine	*kk;
} Engine;

/*
 *	known engines
 */
extern RkEngine ONEW_WnnRomkan;
extern KkEngine ONEW_WnnKanakan;
extern RkEngine ONEW_CannaRk;
extern KkEngine ONEW_CannaKanakan;

Engine Engines[] = {
	{"none", "?"},
	{"wnn",  ONEW_KK_WNN,   &ONEW_WnnRomkan, &ONEW_WnnKanakan  },
	{"canna",ONEW_KK_CANNA, &ONEW_CannaRk,   &ONEW_CannaKanakan},
	0
};

/*
 *	current engines
 */
static int RomkanX;
static int RomkanN;
RkEngine *RomkanP(){ return Engines[RomkanX].rk; }
static int KanakanX;
static int KanakanN;
KkEngine *KanakanP(){return Engines[KanakanX].kk;}

#define RK_EXIST(rk)	((rk) && (rk->rk_ready))
#define KK_EXIST(kk)	((kk) && (kk->kk_ready))

static select_engine(){
	char *engine,*name,rkname[128],kkname[128];
	int ei;

	if( (engine = getenv("ONEW_ENGINE")) == 0 )
		engine = ONEW_ENGINE;
	switch( sscanf(engine,"%[^/]/%s",rkname,kkname) ){
		case 0: strcpy(rkname,"wnn");
		case 1: strcpy(kkname,rkname);
	}
	for( ei = 1; name = Engines[ei].name; ei++ ){
		if( strcmp(rkname,name) == 0 )
			if( RK_EXIST(Engines[ei].rk) ) RomkanX  = ei;
		if( strcmp(kkname,name) == 0 )
			if( KK_EXIST(Engines[ei].kk) ) KanakanX = ei;
	}

	for( ei = 1; name = Engines[ei].name; ei++ ){
		if( RK_EXIST(Engines[ei].rk) ){
			if( RomkanP() == 0 ) RomkanX  = ei;
			RomkanN++;
		}
		if( KK_EXIST(Engines[ei].kk) ){
			if( KanakanP()== 0 ) KanakanX = ei;
			KanakanN++;
		}
	}
}
romkan_select(){
	if( RomkanX == 0 )
		select_engine();
	return RomkanX != 0;
}

int ONEW_SHOWDIC;
kanakan_select(){
	if( KanakanX == 0 )
		select_engine();
	ONEW_SHOWDIC |= getenv("ONEW_SHOWDIC") != 0;
	return KanakanX != 0;
}

static	char *kkEngineID(){ return Engines[KanakanX].kname; }
	char *rkEngineID(){ return Engines[RomkanX].kname; }

static char *next_kanakan(){
	KkEngine *kk;
	char *name;
	int ei;

	ei = KanakanX + 1;
	if( (name=Engines[ei].name) && (kk=Engines[ei].kk) && KK_EXIST(kk) )
		KanakanX = ei;
	else	for( ei = 1; name = Engines[ei].name; ei++ )
			if( (kk=Engines[ei].kk) && KK_EXIST(kk) ){
				KanakanX = ei;
				break;
			}
	return name;
}
static char *next_romkan(){
	RkEngine *rk;
	char *name;
	int ei;

	ei = RomkanX + 1;
	if( (name=Engines[ei].name) && (rk=Engines[ei].rk) && RK_EXIST(rk) )
		RomkanX = ei;
	else	for( ei = 1; name = Engines[ei].name; ei++ )
			if( (rk=Engines[ei].rk) && RK_EXIST(rk) ){
				RomkanX = ei;
				break;
			}
	return name;
}
switch_rkserv(){
	char help[128];
	char *romkan;
	int kmode;

	if( RomkanP() == 0 )
		romkan_select();
	if( RomkanN <= 1)
		return;

	kmode = ONEW_kanamode;
	if( romkan = next_romkan() ){
		Onew_RK_imode_set(0);
		Onew_RK_imode_set(kmode);
		sprintf(help,ONEW_msg_rk_engineswitch,romkan,rkEngineID());
		Onew_putmsg_retain(1,"%s %s",Onew_RK_smode(),help);
	}
}
switch_kkserv(){
	char mode[64],help[128],*kanakan;

	if( KanakanP() == 0 )
		kanakan_select();
	if( RomkanN <= 1)
		return;

	if( kanakan = next_kanakan() ){
		sprintf(mode,ONEW_mode_kanakan,kkEngineID());
		sprintf(help,ONEW_msg_kk_engineswitch,kanakan,kkEngineID());
		if( KanakanP()->kk_ready )
			(*KanakanP()->kk_ready)();
		Onew_putmsg_retain(1,"%s %s",mode,help); 
	}
}

onew_put_kanakanmode(){
	char mode[64];
	sprintf(mode,ONEW_mode_kanakan,kkEngineID());
	Onew_putmode(mode,ONEW_menu_kanakan);
}

onew_notify_kkinit(fmt,a,b,c,d,e,f,g)
	char *fmt;
	char *a,*b,*c,*d,*e,*f,*g;
{	char msg[256];

	sprintf(msg,fmt,a,b,c,d,e,f,g);
	strcat(msg,ONEW_msg_connecting);
	Onew_putmsg_sys(1,"%s",msg);
}

Onew_showrktab()
{	char path[1024],*rkname1,*rkname;

	rkname = rkname1 = next_romkan();
	if( Onew_rktab(path) )
		printf("%s:%s\n",rkname,path);

	while( (rkname = next_romkan()) != rkname1 ){
		if( Onew_rktab(path) )
			printf("%s:%s\n",rkname,path);
	};
}

#ifndef ONEW_RKTABS
#define ONEW_RKTABS "/tmp/onew_rktabs"
#endif

extern char ONEW_RKTAB_DATA[];
extern int  ONEW_RKTAB_DATA_SIZE;

Onew_extract_rktabs()
{	int ci;
	FILE *pp;
	char command[1024];
	char *rkdir = ONEW_RKTABS;

	if( 0 < ONEW_RKTAB_DATA_SIZE ){
		if( mkdir(rkdir,0700) != 0 ){
			Onew_putmsg(1,"Cannot make romkan-tables at %s",rkdir);
			return 0;
		}
		chmod(rkdir,0755);
		sprintf(command,"cd %s; uncompress | tar xf -",rkdir);
		Onew_putmsg(1,"EXTRACTING default romkan-tables into %s",rkdir);
		pp = popen(command,"w");
		for( ci = 0; ci < ONEW_RKTAB_DATA_SIZE; ci++ )
			putc(ONEW_RKTAB_DATA[ci],pp);
		pclose(pp);
		return 1;
	}
	return 0;
}

/*######################################################################*
 *	Interface Functions for ROMAJI-KANA and KANA-KANJI Engines	*
 *######################################################################*/
#define RP RomkanP()
#define IR(func)			(romkan_select() ? func : 0)
#define ONEWromkan_ready(rkpath)	IR((*RP->rk_ready)(rkpath))
#define ONEWromkan_modesw(mode)		IR((*RP->rk_modesw)(mode))
#define ONEWromkan_clear()		IR((*RP->rk_gotch)())
#define ONEWromkan_getc()		IR((*RP->rk_getc)())
#define ONEWromkan_next()		IR((*RP->rk_next)())
#define ONEWromkan_dispmode()		IR((*RP->rk_dispmode)())
#define ONEWromkan_gotch(ch)		IR((*RP->rk_gotch)(ch))

#define KP KanakanP()
#define IK(func)			(kanakan_select() ? func : 0)
#define ONEWkanakan_ready()		IK((*KP->kk_ready)())
#define ONEWkanakan(c,y)		IK((*KP->kk_kanakan)(c,y))
#define ONEWkanakan_freqsave()		IK((*KP->kk_freqsave)())
#define ONEWkanakan_kouho()		IK(  KP->kk_kouho)
#define ONEWbunsetu_next(x,cur,inc)	IK((*KP->kk_next)(x,cur,inc))
#define ONEWbunsetu_expand(x,b,c)	IK((*KP->kk_expand)(x,b,c))
#define ONEWbunsetu_shrink(x,b,c)	IK((*KP->kk_shrink)(x,b,c))
#define ONEWjisyo_touroku(a,b,c,d)	IK((*KP->kk_touroku)(a,b,c,d))
#define ONEWjisyo_hinshi(hl)		IK((*KP->kk_hinshi)(hl))

Onew_rktab(path)
	char *path;
{
	return oeiRomkanReady(path);
}

Onew_kkdic()
{
	ONEW_SHOWDIC = 1;
	kanakan_select();
	return oeiKanakanReady();
}

oeiRomkanReady(rkp)char *rkp;	{ return ONEWromkan_ready(rkp); }
oeiRomkanModesw(m) char *m;	{ return ONEWromkan_modesw(m); }
char*
oeiRomkanDispmode()		{ return ONEWromkan_dispmode(); }
oeiRomkanNext()			{ return ONEWromkan_next(); }
oeiRomkanGetc()			{ return ONEWromkan_getc(); }
oeiRomkanGotch(ch)		{ return ONEWromkan_gotch(ch); }
oeiRomkanClear()		{ return ONEWromkan_clear(); }

oeiKanakanReady()		{ return ONEWkanakan_ready(); }
oeiKanakan(c,y) char *y;	{ return ONEWkanakan(c,y); }
oeiKanakanFreqsave()		{ return ONEWkanakan_freqsave(); }
oeiBunsetu_shrink(x,k,b)char*k;	{ return ONEWbunsetu_shrink(x,k,b); }
oeiBunsetu_expand(x,k,b)char*k;	{ return ONEWbunsetu_expand(x,k,b); }
oeiBunsetu_next(x,bi,n)		{ return ONEWbunsetu_next(x,bi,n); }
oeiJisyoTouroku(a,h,y,k)char *h,*y,*k;{ return ONEWjisyo_touroku(a,h,y,k); }
oeiJisyoHinshi(h) char *h;	{ return ONEWjisyo_hinshi(h); }

