#include "onew.h"

int OM_JisyoMode;
int OM_JisyoGetYomi;
int OM_JisyoGetTsuduri;  /* touroku string input mode */
int OM_JisyoGetKanjiFlush;
int OM_JisyoMassyou;

extern Uchar ONEW_DicYomi[];

odmStart_touroku(yomi)
	char *yomi;
{
	if( yomi[0] == 0 )
		return 0;

	strcpy(ONEW_DicYomi,yomi);
	ouiDISP_KANAKANB(0,"","","");
	OM_JisyoGetTsuduri = 1;
	return 1;
}

odmAbort_touroku(){
	if( OM_JisyoGetYomi || OM_JisyoGetTsuduri || OM_JisyoGetKanjiFlush ){
		Onew_putmsg(1,ONEW_msg_tourokuABORT);
		ouiBEEP(2);
		OM_JisyoGetYomi = 0;
		OM_JisyoGetTsuduri = 0;
		OM_JisyoGetKanjiFlush = 0;
		return 1;
	}
	return 0;
}

odmJisyo_sousa(){
	int com;

	OM_JisyoMode = 1;
	Onew_putmode(ONEW_mode_jisyo,ONEW_menu_jisyo);
	OM_JisyoMode = 0;

	com = ONEW_getch0(1);
	if( com == 'a' ){
		return odmStart_touroku(ONEW_CurrentKanji);
	}
	if( com == 'd' ){
		odmJisyo_massyou();
		return 0;
	}
	return 0;
}

odmJisyo_massyou()
{
	OM_JisyoMassyou = 1;
	Onew_putmode(ONEW_mode_massyou,ONEW_menu_massyou);
	if( ONEW_getch0(1) == 'y' )
		oeiJisyoTouroku(0,0,ONEW_CurrentYomi,ONEW_CurrentKanji);
	OM_JisyoMassyou = 0;
}

odmJisyo_touroku()
{	int i,max;
	int com;
	Hinshi *hinshi;
	char hname[128],kanji[1024];

	if( oeiJisyoHinshi(&hinshi) == 0 )
		return;

	OM_JisyoGetTsuduri = 0;
	Onew_putmode(ONEW_mode_hinshi,"");

	for( max = 0; hinshi[max].h_name; max++)
		;
	i = 0;
	sprintf(kanji,"(%s)[%s]",ONEW_DicYomi,ONEW_CurrentKanji);
	for(;;){
		sprintf(hname,"<%s>",hinshi[i].h_name);
		ouiDISP_KANAKANB(1,kanji,hname,"");
/* The followings should be after above to flush jvim screen ? */
Onew_putmsg(1,"[%d/%d] %s",i+1,max,ONEW_menu_touroku);

		switch( com = getchar() ){
			case ESC_CH:
				ouiDISP_KANAKANB(0,ONEW_DicYomi,"","");
				goto exit;

			case ' ': i++; if(hinshi[i].h_name==0) i = 0; break;
			case Cntl('P'):
			case 'b': i--; if(i < 0) i = max-1; break;
			case '\r':
			case '\n': goto out;
		}
	}
out:
	ouiDISP_KANAKANB(0,ONEW_DicYomi,"","");
	oeiJisyoTouroku(1,hinshi[i].h_code,ONEW_DicYomi,ONEW_CurrentKanji);
exit:
	OM_JisyoGetTsuduri = 0;
}
