/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	Onewdic.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940127	created
///////////////////////////////////////////////////////////////////////*/
#include "onew.h"
int ONEW_MAXWORDS = 32;

typedef struct word {
 struct word	*w_prev;
	char	*w_str;
	int	 w_freq;
} Word;

static Word *word_list;
static int   word_count;

char *strpbrk();

Onew_addword(dic,word)
	char *dic;
	char *word;
{	Word *wp,*pwp,*nwp;
	char *np,*nword;
	int len;

	if( ONEW_MAXWORDS <= 0 )
		return;

	if( *word == 0 )
		return;

	if( np = strpbrk(word,"\n\r") ){
		if( np == word )
			return;
		len = np - word;
	}else	len = strlen(word);

	nword = (char*)malloc(len+1);
	strncpy(nword,word,len);
	nword[len] = 0;


	pwp = nwp = 0;
	for( wp = word_list; wp; wp = wp->w_prev ){
		if( strcmp(wp->w_str,nword) == 0 )
			return 0;
		pwp = nwp;
		nwp = wp;
	}

	if( ONEW_MAXWORDS <= word_count && pwp && nwp ){
		pwp->w_prev = 0;
		free(nwp->w_str);
	}else{
		nwp = (Word*)malloc(sizeof(Word));
		word_count++;
	}

	nwp->w_prev = word_list;
	word_list = nwp;
	nwp->w_str  = nword;
	nwp->w_freq = 0;

	return 1;
}
static Word *nth_wp(nth,wppp)
	Word ***wppp;
{	Word *wp,**wpp;
	int n;

	wp = word_list;
	wpp = &word_list;
	for( n = 0; n < nth; n++ ){
		if( wp->w_prev == 0 )
			break;
		wpp = &wp->w_prev;
		wp = wp->w_prev;
	}
	if( wppp )
		*wppp = wpp;
	return wp;
}
/* this function does not perform proper sorting  X-< */
static word_sort(nth,inc)
{	Word *dwp,*pwp,*twp;
	Word **dwpp,**pwpp;
	int nnth;

	if( (dwp = nth_wp(nth,&dwpp)) == 0 )
		return;
	dwp->w_freq += inc;

	pwpp = &word_list;
	nnth = 0;
	for( pwp = word_list; pwp; ){
		if( pwp->w_freq <= dwp->w_freq )
			break;
		pwpp = &pwp->w_prev;
		pwp = pwp->w_prev;
		nnth++;
	}
	if( pwp == 0 || pwp == dwp )
		return;

	twp = *pwpp;
	*pwpp = dwp;
	*dwpp = dwp->w_prev;
	dwp->w_prev = twp;
	return nnth;
}


static char *nth_str(nth)
{	Word *wp;

	wp = nth_wp(nth,0);
	if( wp && wp->w_str )
		return wp->w_str;
	else	return 0;
}
static char *get_nth_word(_,nth,str,len)
	char *str;
{	char *wstr;

	if( wstr = nth_str(nth) ){
		strncpy(str,wstr,len);
		return str;
	}else	return 0;
}
static word_label(label,from,to,max)
	char *label;
{
	sprintf(label,"[%d/%d]",to-1,max);
}
static word_error(){
}

Onew_getword(key)
	char *key;
{	int n;
	int mode;
	static int word_current;

	if( word_count == 0 )
		return;
	if( word_count == 1 ){
		Onew_enqstr(nth_str(0));
		return;
	}

	word_current = 0;
	mode = Onew_pushmode(ONEW_mode_sentaku);
	n = Onew_list_sentaku(word_label,word_error,get_nth_word,0,
		word_count,1,&word_current);

	Onew_popmode(mode);

	if( 0 <= n ){
		Onew_enqstr(nth_str(n));
		word_current = word_sort(n,1);
	}
}


static
ONEWkanakan_ready(){
	return 1;
}
static
ONEWkanakan_freqsave()
{
}
static char *
ONEWkanakan_kouho(ctx,i,kouho,size)
	char *kouho;
{
	strncpy(kouho,nth_str(i),size);
}
static
ONEWkanakan()
{
}
static
ONEWbunsetu_next()
{
}
static
ONEWbunsetu_expand()
{
}
static
ONEWbunsetu_shrink()
{
}
static
ONEWjisyo_touroku()
{
}
static
ONEWjisyo_hinshi()
{
}
RegisterKanakan(ONEW_OnewKanakan);

