#include <stdio.h>
#include <signal.h>
#include <setjmp.h>

static jmp_buf getch_env;

static sigtstp(){
#ifdef SIGTSTP
	longjmp(getch_env,SIGTSTP);
#endif
}

Onew_getchar(freqsave_delay,autosave_delay,autosave_func)
	int (*autosave_func)();
{	int ch;
	void (*otstp)();

#ifdef SIGTSTP
	otstp = signal(SIGTSTP,sigtstp);
#endif

	if( ch = setjmp(getch_env) ){
		switch( ch ){
#ifdef SIGTSTP
			case SIGTSTP:	ch = 'Z'-0x40; break;
#endif
			default:	ch = '@'-0x40; break;
		}
		goto out;
	}

	if( Onew_inready(stdin,freqsave_delay) == 0 ){
		Onew_KK_freqsave();

		if( autosave_delay )
			if( Onew_inready(stdin,autosave_delay) == 0 )
				(*autosave_func)();
	}

	ch = getchar();

out:
#ifdef SIGTSTP
	signal(SIGTSTP,otstp);
#endif
	return ch;
}

