#include <signal.h>
#include "stevie.h"
#include "onew.h"

#define ESCDELAY_RKON	 200*1000
#define ESCDELAY_RKOFF	 300*1000
#define DELAY_FREQSAVE	2000*1000
#define DELAY_AUTOSAVE	8000*1000
#define CHARS_AUTOSAVE	120
#define MSG_STANDOUT	1

#define is_del_ins(ch) (ch==Cntl('H')||ch==0x7F||ch==Cntl('U'))

/*######################################################################*
 *	ONEW BUILT-IN TO JSTEVIE					*
 *######################################################################*/
int ONEW_THRUSYMS_ON = 0;
int ONEW_MAXCOL = MAXMLEN;
static int IN_HENKANMODE;
static int kana_modes[8];
#define kana_mode Onew_RK_imode()

extern Uchar kanji1[];
static char *jcode(){
	if( kanji1[0xFE] == 0 ) return "SJIS";
#ifdef EUC
	return "EUC";
#else
	return "JIS";
#endif
}

static int prev_modef;
static char *prev_chelp = "";

ONEW_DISP_ROMKANMODE(cmode,chelp,modef)
	char *chelp;
{	int rkmode;

	rkmode = Onew_RK_imode();
	if(State == CMDLINE ){
		if( kana_modes[State] != rkmode ){
			kana_modes[State] = rkmode;
			goto_cmdline(0);
			flushbuf();
		}
	}else{
		if( *chelp )
		if( strcmp(prev_chelp,chelp) != 0 || prev_modef != modef ){
			Onew_putmsg(rkmode,"%s %s [%s] %s",
				cmode,chelp,jcode(),Onew_version());
		}
	}
	prev_modef = modef;
	prev_chelp = chelp;
}

ONEW_MESSAGE(so,form,a,b,c,d){
	Linebuff msg;

	if( State == CMDLINE )
		return;

	sprintf(msg,form,a,b,c,d);
	msg[MAXMLEN] = 0;

	so = so && MSG_STANDOUT;
	if( so ) toutstr(T_SO,1);
	smsg("%s",msg);
	if( so ) toutstr(T_SE,1);
	if( IN_HENKANMODE )
		windgoto(Cursrow,Onew_maxcols());
	else	windgoto(Cursrow,Curscol);
	flushbuf();

	if( ONEW_MSGHOLD ){
		static int cnt;
		printf("(%3d)\b\b\b\b\b",++cnt);
		fflush(stdout);
		Onew_msleep(ONEW_MSGHOLD);
	}
}
ONEW_BEEP(nsec){
	beep();
	flushbuf();
	sleep(nsec);
}

static CLRWINBAR(){
	prev_modef = 0;
	prev_chelp = "";
	Onew_curmsg("");
}

static int pending;
static int pending_char;

ONEW_PEEKCHAR(timeout)
	int *timeout;
{	int ch;

	if( pending ){
		ch = pending_char;
	}else
	if( 0 < Onew_inready(stdin,*timeout*1000) ){
		ch = GetChar1();
		pending_char = ch;
		pending = 1;
		*timeout = 0;
	}else{
		ch = 0;
		*timeout = -1;
	}
	return ch;
}

ONEW_GETCHAR()
{	int ch;

	if( pending ){
		ch = pending_char;
		pending_char = 0;
		pending = 0;
	}else{
		ch = GetChar1();
	}

	if( ch == EOF ){
		Onew_enqstr(":q!\n");
		ch = ESC_CH;
	}
	return ch;
}


/*######################################################################*
 *
 */
ONEW_DISP_KANAHALVES(str)
	char *str;
{
	if( State == CMDLINE )
		return	DISP_KANAHALVES_Cmdline(str);
	else	return	DISP_KANAHALVES_Insert (str);
}
static DISP_KANAHALVES_Cmdline(str)
	char *str;
{
	outchar(str[0]);
	if( str[1] ){
		outchar(str[1]);
		outchar('\b');
	}
	outchar('\b');
	flushbuf();
	return 0;
}
static DISP_KANAHALVES_Insert(str)
	char *str;
{
	inschar(str[0]);
	if( str[1] )
		inschar(str[1]);
	else	inschar(' ');
	oneleft();
	oneleft();

	updateline();
	windgoto(Cursrow,Curscol);
	flushbuf();
	if( State != REPLACE ){
		delchar(1);
		delchar(1);
	}
	return 0;
}

/*######################################################################*
 *	Display Current KanaKan Buffer
 */
ONEW_DISP_KANAKANB(so,left,current,right){
	if( State == CMDLINE )
		return DISP_KANAKANB_Cmdline(so,left,current,right);
	else	return DISP_KANAKANB_Insert (so,left,current,right);
}

static Uchar *put_textflagment(so,sos,ses,tail,str,len)
	Uchar *tail,*str;
{
	if( len ){
		strncpy(tail,str,len);
		tail += len;
		if(so) toutstr(sos,1);
		updateline();
		if(so) toutstr(ses,1);
	}
	return tail;
}
static Uchar *LEFT,*CURLINE,*RIGHT;
DISP_KANAKANB_Insert(so,left,current,right)
	Uchar *left,*current,*right;
{	Uchar *out,*tail,*inchars;
	int col,Llen,llen,clen,rlen,Rlen,tlen;

	out = CURLINE;
	Llen = LEFT?strlen(LEFT):0;
	llen = strlen(left);
	clen = strlen(current);
	rlen = strlen(right);
	Rlen = RIGHT?strlen(RIGHT):0;

	Curscol = Llen + llen + clen;
	tlen = Llen + llen + clen + rlen + Rlen;

/* sprintf(out,"%*s%s",Curscol+rlen," ",Rlen?RIGHT:(Uchar*)""); */
	for( col = 0; col < Curscol+rlen; col++ )
		out[col] = ' ';
	strcpy(&out[col],Rlen?RIGHT:(Uchar*)"");
	updateline();

	tail = out;
	tail = put_textflagment(0,    0,   0, tail,LEFT,   Llen);
	inchars = tail;
	tail = put_textflagment(so,T_US,T_UE, tail,left,   llen);
	tail = put_textflagment(so,T_SO,T_SE, tail,current,clen);
	tail = put_textflagment(so,T_US,T_UE, tail,right,  rlen);

	replace_inchars(inchars,llen+clen+rlen);
	updatescreen();

if( so )
	windgoto(Cursrow,Onew_maxcols());
else	windgoto(Cursrow,Curscol);

	flushbuf();
}

/*######################################################################*
 *	Kanakan Startup and Finalize
 */
ONEW_KANAKAN(ch){
	if( State == CMDLINE )
		return KANAKAN_Cmdline(ch);
	else	return KANAKAN_Insert(ch);
}
KANAKAN_Insert(ch){
	char com;
	Uchar leftb[4096],rightb[4096];
	int start,leng;

	if( Ninsert == 0 )
		return ch;

	LEFT = leftb;	LEFT[0] = 0;
	RIGHT= rightb;	RIGHT[0]= 0;

	leng = save_buffstat(&CURLINE,&start);
	if( leng <= 0 ){
		com = ch;
		goto exit;
	}
	strcpy(LEFT,CURLINE); LEFT[start] = 0;
	if( (start+leng) < strlen(CURLINE) )	/* RIGHT-HAND-PART EXISTS */
		strcpy(RIGHT,&CURLINE[start+leng]);

	strcpy(CURLINE,&CURLINE[start]);
	CURLINE[leng] = CURLINE[leng+1] = CURLINE[leng+2] = 0;
	/* terminate as wchar string */

	IN_HENKANMODE = 1;
	com = Onew_kanakan(ch,CURLINE);
	IN_HENKANMODE = 0;

	reset_index();
	switch(com){
		case Cntl('H'):
		case 0x7F:	com = 0; restore_buffstat();	break;
		default:	com = 0;
		case ESC_CH:	Onew_kakutei(ESC_CH);		break;
	}
exit:
	LEFT = 0;
	RIGHT = 0;
	return com;
}

ONEW_KAKUTEI(com){
	if( State == CMDLINE )
		return kakutei_cmdline();

	if( 0 < mikakutei_length() ){
		kakutei_insert();
		return 1;
	}
	return 0;
}

/*######################################################################*
 *
 */
#include <sys/ioctl.h>
static int N_SIGQUIT;
static sigquit(sign){
	char ch = ONEW_ROMKAN_TOGGLE;
	N_SIGQUIT++;
#ifdef TIOCSTI
	ioctl(0,TIOCSTI,&ch);
#endif
	signal(sign,sigquit);
}


static int sigqinit;
static set_sigqint(){
	if( sigqinit == 0 ){
		sigqinit = 1;
		signal(SIGQUIT,sigquit);
	}
}
static int last_normalch;
static int last_state;

Onew_inchar1(){
	int ch;

	if( State == INSERT || State == REPLACE ){
		if( mikakutei_length() == 0 )
			start_inchars();
	}else	clear_kakutei();

	set_sigqint();
	if( (ch = Onew_deqchar(State==NORMAL)) != EOF )
		return ch;

	if( last_state == NORMAL && State != NORMAL )
		CLRWINBAR();

	last_state = State;

	if( State == INSERT || State == REPLACE || State == CMDLINE ){
		Onew_RK_imode_set(kana_modes[State]);
		ch = Onew_romkan();
		if( ch == '\n' || ch == '\r' ){
			CLRWINBAR();
			if( State == CMDLINE )
				Onew_KK_freqsave();
		}
		kana_modes[State] = kana_mode;
		last_normalch = 0;
	}else
	if( State == NORMAL && last_normalch && strchr("ftr",last_normalch) ){
		ch = get_argchar();
		Onew_putmsg(0,"");
		CLRWINBAR();
		goto OUT;
	}else{
		ch = OnewGetchar();
		if( State == NORMAL )
			last_normalch = ch;
		else	last_normalch = 0;
	}

OUT:
	if( got_int )
		sigqinit = 0;

	if( is_del_ins(ch) )
	if( State == INSERT || State == REPLACE )
		undo_kakutei_insert();
	return ch;
}
static
get_argchar(){
	Uchar ch,*buff;
	int omode;

	if( last_normalch == 'r' ){
		State = INSERT;
		ch = Onew_inchar1();
	}else{
		omode = kana_modes[CMDLINE];
		Onew_RK_imode_setv(kana_modes[INSERT]);
		kana_modes[CMDLINE] = kana_mode;
		if( kana_mode == 0 ){	
			ONEW_DISP_ROMKANMODE(Onew_RK_smode());
			ch = OnewGetchar();

			if(ch == ONEW_ROMKAN_TOGGLE){
				Onew_RK_toggle();
				kana_modes[CMDLINE] = kana_mode;
			}else	goto GOT;
		}
		if( buff = (Uchar*)getcmdln(last_normalch) ){
			ch = buff[0];
			if( ch & 0x80 )
				Onew_enqchar(buff[1]);
		}
		GOT:
		kana_modes[INSERT] = kana_mode;
		kana_modes[CMDLINE] = omode;
	}
	State = NORMAL;
	last_normalch = 0;
	return ch;
}
int num_inchar;
ONEW_inchar(kmode)
	int kmode;
{	int ch;

	if( Changed ){
		if( CHARS_AUTOSAVE < ++num_inchar )
			do_autosave();
	}else	num_inchar = 0;

	Onew_RK_thru(kmode);
	ch = Onew_inchar1();

/*
	if( ch != ESC ){
*/
		if(kmode && ' ' <= ch || ch & 0x80)
			ch = (ch << 8) | Onew_inchar1() | 0x8080;
		got_int = FALSE;
		return ch;
/*
ISO2022-sequence come to be handled by ONEW 93.12.10
	}
	if(Onew_inready(stdin,Onew_RK_imode()?ESCDELAY_RKON:ESCDELAY_RKOFF)<=0)
		return ESC;

	Onew_enqchar(ESC);
	Onew_RK_thru(1);
	return 0;
*/
}

/*######################################################################*
 *
 */
static Uchar  cmdline_mode;
static Uchar *cmdline_buff;  /* buff ptr	*/
static Uchar**cmdline_topp;  /* ptr to peak ptr	*/
static int   *cmdline_peakp; /* peak col ptr	*/
static int    cmdline_fixed; /* fixed col	*/
#define CMD_LENG	(*cmdline_topp - cmdline_buff)
#define MIKAKUTEI_LENG	(CMD_LENG - cmdline_fixed)

Uchar *
Onew_cmdlnpeak(topp,colp) Uchar **topp; int *colp; {
	int col;

	cmdline_peakp = colp;
	cmdline_topp = topp;

	col = *colp;
	if( col < cmdline_fixed )
		cmdline_fixed = col;
	(*topp)[0] = (*topp)[1] = 0;
	if( cmdline_fixed == 0 )
		cmdline_fixed = 1;
}

KANAKAN_Cmdline(ch){
	char com;
	Uchar *top;
	int len;

	top = &cmdline_buff[cmdline_fixed-1];
	len = MIKAKUTEI_LENG;
	if( len <= 0 )
		return ch;

	com = Onew_kanakan(ch,top,0,len);
	kakutei_cmdline();
	com = 0;
	return com;
}
DISP_KANAKANB_Cmdline(so,left,cur,right)
{	Uchar *top;
	Linebuff LEFT;
	int Llen;

	*LEFT = 0;
	Llen = cmdline_fixed - 1;
	if( 0 < Llen ){
		strncpy(LEFT,cmdline_buff,Llen);
		LEFT[Llen] = 0;
	}

	goto_cmdline(1); outstr(LEFT);
	toutstr(T_US,1); outstr(left);	toutstr(T_UE,1);
	toutstr(T_SO,1); outstr(cur);	toutstr(T_SE,1);
	toutstr(T_US,1); outstr(right);
	toutstr(T_UE,1); flushbuf();

	top = &cmdline_buff[Llen];
	sprintf(top,"%s%s%s",left,cur,right);
	return 0;
}

static
kakutei_cmdline(){
	int peaki;

	if( MIKAKUTEI_LENG <= 0 )
		return 0;

	goto_cmdline(0);/* this changed the peak */

	peaki = strlen(cmdline_buff);
	cmdline_buff[peaki] = 0;
	cmdline_buff[peaki+1] = 0;
	cmdline_fixed = peaki + 1;
	*cmdline_peakp = peaki + 1;
	*cmdline_topp = &cmdline_buff[peaki];
	return 1;
}

goto_cmdline(clear){
	(*cmdline_topp)[0] = 0;
	if( clear )
		gotocmd(1,cmdline_mode);
	else{
		gotocmd(0,cmdline_mode);
		outstr(pretty(cmdline_buff,cmdline_peakp));
	}
}
extern Uchar *getcmdln1();
Uchar *
getcmdln(firstc){
	if( cmdline_buff == 0 ){
		Onew_enqchar('\n');
		cmdline_buff = getcmdln1(':');
	}
	cmdline_mode = firstc;
	return getcmdln1(firstc);
}

char *Onew_romkanmode(){
	Onew_RK_imode_set(kana_modes[State]);
	return Onew_RK_smode();
}

/*######################################################################*
 *	Handling Stevie Text Buffer
 */
typedef struct {
	char	s_line[0x8000];
	int	s_index;
	int	s_row;
	int	s_col;
} BufferStat;

static BufferStat BufS;

static save_buffstat(clinep,startp)
	Uchar **clinep;
	int *startp;
{	int start,leng;
	Uchar *curlinep;

	canincrease(128); /* expand line buffer for long kana/kan result */
	BufS.s_row   = Cursrow;
	BufS.s_col   = Curscol;
	BufS.s_index = Curschar->index;
	curlinep     = Curschar->linep->s;
	strcpy(BufS.s_line,curlinep);

	if( Insstart->linep->s == curlinep )
		start = Insstart->index;
	else	start = 0;

	*clinep = curlinep;
	*startp = start;
	leng    = BufS.s_index - *startp;
	return leng;
}
static restore_buffstat(){
	replace_inchars(BufS.s_line,strlen(BufS.s_line));
	strcpy(Curschar->linep->s,BufS.s_line);
	Curschar->index = BufS.s_index;
	updatescreen();
	Cursrow         = BufS.s_row;
	Curscol         = BufS.s_col;
	windgoto(Cursrow,Curscol);
	flushbuf();
}
static reset_index(){
	int leng ;

	leng = strlen(RIGHT);
	Curschar->index = strlen(Curschar->linep->s) - leng;
}
static mikakutei_length(){
	int leng;
	if( Insstart == 0 || Insstart->linep == 0 )
		return -1;

	if( Insstart->linep == Curschar->linep )
		leng = Curschar->index - Insstart->index;
	else	leng = Curschar->index;/* on the top of added line */
	return leng;
}

static LPTR OInsstart[80];
static OInsstartX;
static kakutei_insert(){
	if( Insstart->linep != Curschar->linep )/* on the top of added line */{
		OInsstartX = 1;
		OInsstart[OInsstartX].linep = Curschar->linep;
		OInsstart[OInsstartX].index = 0;
	}else{
		if( OInsstart[OInsstartX].linep != Insstart->linep )
			OInsstartX = 0;
		OInsstartX++;
		OInsstart[OInsstartX] = *Insstart;
	}
	*Insstart = *Curschar;
	cursupdate();
}
static clear_kakutei(){
	OInsstartX = 0;
}
static undo_kakutei_insert(){
	if( 0 < mikakutei_length() )
		return;

	if( OInsstartX ){
		*Insstart = OInsstart[OInsstartX];
		OInsstartX--;
	}
}
static Uchar *mikakutei_insptr;
static int mikakutei_ninsert;
static start_inchars(){
	mikakutei_insptr = Insptr;
	mikakutei_ninsert = Ninsert;
}
static replace_inchars(str,leng) Uchar *str; {
	if( mikakutei_insptr == 0 )
		return;

	Ninsert = mikakutei_ninsert;
	Insptr  = mikakutei_insptr;
	strncpy(Insptr,str,leng);
	Insptr += leng;
	Ninsert +=  leng;
}


static do_autosave(){
	if( Changed && (State==INSERT || State==REPLACE || State==NORMAL) ){
		Pathname path;

		sprintf(path,"%s/.onew.temp",getenv("HOME"));
		writeit_2(path, 0, 0, TRUE, FALSE);
		chmod(path,0600);
		CHANGED; /* restore cleared status of Changed (Jun Ohta) */
		windgoto(Cursrow,Curscol);
		flushbuf();
		num_inchar = 0;
	}
}

#ifndef VIA
static GetChar1(){
	return Onew_getchar(DELAY_FREQSAVE,DELAY_AUTOSAVE,do_autosave);
}
#else
#include "via+stevie.c"
#endif
