#include "textedit.h"
#include <InterViews/textbuffer.h>
#include "ktextdisplay.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define CURLN		(text->LineNumber(dot))
#define OFFSET(a)	(text->LineOffset(a))

#include "idraw.h"
#include <InterViews/cursor.h>
Idraw *IDRAW;

boolean TextEdit::OnewInsertKanji(int kanji_mode, char och, char *nch)
{	unsigned char ch,buf[1024];
	int bi;
	static int predel;
	int leng,wait_sync=0,wait_cursor=0;
	int char_attr = 0;
	boolean editing = 1;

	if( !kanji_mode ){
		*nch = och;
		return editing;
	}
	if( och & 0x80 || och == 0 || och == '\034'/* ^\ */ ){
		if( och == 0 )
			*nch = '\034';
		else	*nch = och & 0x7F;
		return editing;
	}
	if( och == 'U'-0x40 ){
		SelectLine();
		*nch = 0;
		return editing;
	}

	*nch = 0;

	put_onew(och);
	put_onew(0xFF);/* sync char */
	wait_sync = 1;

	for(;;){
		leng = get_onew(buf,80);
		if( leng == 0 && wait_sync ){
			wait_cursor = 1;
			IDRAW->SetCursor(hourglass);
			leng = get_onew(buf,7*1000);
		}
		if( leng <= 0 )
			break;

		bi = 0;
		if( (ch = buf[bi++]) != 0xFF ){
			Onew_fprintf(stdout,"??? top ???[%x]\n",ch);
			continue;
		}

		switch( ch = buf[bi++] ){
		default:
			Onew_fprintf(stdout,
			"okdraw ERROR: UNKNOWN[0x%x] from onew.\n",ch);
			break;

		case'M':Onew_fprintf(stdout,"## %s\n",&buf[bi]);
			break;

		case'C':
			display->RemoveStyle(
				CURLN,0,CURLN,OFFSET(dot)-1,
				Reversed|Underlined);
			predel = 0;
			break;

		case'D':predel += atoi((unsigned char*)buf+bi);
			break;

		case'!':
			wait_sync = 0;
			break;

		case'A':
			ch = buf[bi++];
			if( ch == '+' )
				switch( buf[bi] ){
				    case 'B': char_attr |= Boldface; break;
				    case 'R': char_attr |= Reversed; break;
				    case 'U': char_attr |= Underlined; break;
				}
			else	switch( buf[bi] ){
				    case 'B': char_attr &= ~Boldface; break;
				    case 'R': char_attr &= ~Reversed; break;
				    case 'U': char_attr &= ~Underlined; break;
				}
			break;

		case'I':
			if( predel ){
				BackwardCharacter(predel);
				DeleteText(predel);
				predel = 0;
			}

			for( int di = bi; di < leng; di++ ){ unsigned char ch;
			switch( ch = buf[di] ){
				case '\r':
				case '\n':
					InsertCharacter('\n');
					break;
				default:
				if( ch <= ' ' || ch == 0x7F ){
					if( HandleKey(ch|0x80) == false ){
						editing = false;
						goto Break;
					}
					break;
				}
				if( ch & 0x80 ){
					char bytes[2];
					bytes[0] = 0x7F & ch;
					bytes[1] = 0x7F & buf[++di];
					InsertText(bytes,2);
				}else{
					InsertText(&ch,1);
				}
				break;
			}}
			if( char_attr )
				display->AddStyle(
					CURLN,OFFSET(dot-(leng-bi)),
					CURLN,OFFSET(dot)-1,char_attr);
			break;
		}
	} Break:;

	if( wait_cursor )
		IDRAW->SetCursor(defaultCursor);

	return editing;
}
