/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1993 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
///////////////////////////////////////////////////////////////////////*/

#define LINESIZE	1024
typedef unsigned char Uchar;
typedef Uchar Linebuff[LINESIZE];
typedef char Mssgbuff[LINESIZE];
typedef	char Pathname[LINESIZE];

#define Cntl(ch)	((ch)-0x40)
#define ESC_CH		0x1B
#define DEL_CH		0x7F
#define BS_CH		Cntl('H')
#define STD_HENKAN	' '

#define OC_TIMEOUT	0xFF000001
#define OC_CHARSET	0xFF000002

extern int ONEW_DEBUG;
extern int ONEW_IN_ISO2022;
extern int ONEW_INCHAR_WIDTH;

extern int ONEW_2BYTES_ONLY;
extern int ONEW_THRUSYMS_ON;
extern int ONEW_THRU_NEXTCH;
extern int ONEW_I_THRU_NEXTCH;
extern int ONEW_I_SYNC_CHAR;
extern int ONEW_THRUSYMS_SETUP;

extern int ONEW_SHOWDIC;	/* inform the opened/failed dic. */
extern int ONEW_MSGHOLD;	/* message hold (milli seconds) */
extern int ONEW_MAXWORDS;

extern int ONEW_ROMKAN_TOGGLE;
extern int ONEW_KANAKAN_TOGGLE;
extern int ONEW_KANA_TOGGLE;
extern int ONEW_KK_OPDICT;

extern int OM_JisyoGetYomi;
extern int ONEW_HENKAN_START;
extern int ONEW_getch_asis;
extern int ONEW_select_mode;
extern int ONEW_kanakan_mode;

extern char *getenv();
extern char *Onew_RK_smode();
extern Uchar *ToLocalString();


#define ONEW_CONT	 0
#define ONEW_EXIT	(-1)
#define ONEW_LOOP	(-2)


/*
 *	server -> client
 */
#define SC_INPUT	'I'
#define SC_CHATTR	'A'	/* [-]{R,U,B} */
#define SC_DELETE	'D'
#define SC_CONFIRM	'C'
#define SC_SYNC		'!'
#define SC_MESSAGE	'M'
#define SC_RKSTAT	'R'

#define S_INPUT		"I"
#define S_CHATTR	"A"	/* [-]{R,U,B} */
#define S_DELETE	"D"
#define S_CONFIRM	"C"
#define S_SYNC		"!"
#define S_MESSAGE	"M"
#define S_RKSTAT	"R"

/*
 *	client -> server
 */
#define CC_SYNC		0xFF

#define CC_COMMAND	0xFE
#define	CCC_VERSION2	'2'
#define CCC_SYM_JIS	'J'
#define CCC_SYM_ASCII	'A'

#define CC_XCOMMAND	Cntl('X')



/*
 *	ROMKAN MODE
 */
extern int ONEW_kanamode;
extern int ONEW_NN_THRU;

#define KATAKANA	0x000001	
#define NOTKANA		0x000002	
#define ZENKAKU		0x000004
#define KF_2BINPUT	0x000008
#define KF_THRUSYMS	0x000010
#define KF_NN_THRU	0x000020
#define KF_NEXTCHAR	0x000040
#define KF_SELECT	0x000080
#define KF_KANAKAN	0x000100
#define KF_JISYO	0x000200
#define KF_GETYOMI	0x000400
#define KF_GETTSUDURI	0x000800
#define KF_MASSYOU	0x001000
#define KF_SYSMODE	0x010000

#define KF_KEISEN_A	0x100000 /* by M.Kawafuji */
#define KF_KEISEN_B	0x200000 /* by M.Kawafuji */

#define RK_ROMHIRA	(ZENKAKU)
#define RK_ROMKATA	(ZENKAKU|KATAKANA)
#define RK_ZENKAKU	(ZENKAKU|NOTKANA)
#define RK_THROUGH	0


/*
 *	romkana/kanakan engine register
 */
typedef struct {
	char	*h_code;
	char	*h_name;
	int	 h_last_used;
} Hinshi;

typedef int (*IFUNC)();
typedef char *(*SFUNC)();
typedef struct {
	IFUNC	rk_ready;
	IFUNC	rk_clear;
	IFUNC	rk_modesw;
	SFUNC	rk_dispmode;
	IFUNC	rk_getc;
	IFUNC	rk_next;
	IFUNC	rk_gotch;
} RkEngine;
typedef struct {
	IFUNC	kk_ready;
	IFUNC	kk_kanakan;
	IFUNC	kk_freqsave;
	SFUNC	kk_kouho;	/* should be (wchar *) ??? */
	IFUNC	kk_next;
	IFUNC	kk_expand;
	IFUNC	kk_shrink;
	IFUNC	kk_touroku;
	IFUNC	kk_hinshi;
} KkEngine;

#define RegisterRomkan(table)	\
RkEngine table = {		\
	ONEWromkan_ready,	\
	ONEWromkan_clear,	\
	ONEWromkan_modesw,	\
	ONEWromkan_dispmode,	\
	ONEWromkan_getc,	\
	ONEWromkan_next,	\
	ONEWromkan_gotch	\
}

#define RegisterKanakan(table)	\
KkEngine table = {		\
	ONEWkanakan_ready,	\
	ONEWkanakan,		\
	ONEWkanakan_freqsave,	\
(SFUNC)	ONEWkanakan_kouho,	\
	ONEWbunsetu_next,	\
	ONEWbunsetu_expand,	\
	ONEWbunsetu_shrink,	\
	ONEWjisyo_touroku,	\
	ONEWjisyo_hinshi	\
}


/*
 *	string constants in EUC
 */
#define Xchar	extern char

Xchar	*ONEW_menu_roman;
Xchar	*ONEW_menu_romkana;
Xchar	*ONEW_menu_thru1;
Xchar	*ONEW_menu_thruON;
Xchar	*ONEW_menu_thruOFF;
Xchar	*ONEW_menu_thruSET;
Xchar	*ONEW_menu_modeswitch;
Xchar	*ONEW_mode_modeswitch;
Xchar	*ONEW_menu_zenkaku1;
Xchar	*ONEW_mode_zenkaku1;
Xchar	*ONEW_menu_kanakan;
Xchar	*ONEW_mode_Cromhira;
Xchar	*ONEW_mode_Cromkata;
Xchar	*ONEW_mode_CromhiraNN;
Xchar	*ONEW_mode_CromkataNN;
Xchar	*ONEW_mode_2Bchar;
Xchar	*ONEW_mode_romzen;
Xchar	*ONEW_mode_kuten;
Xchar	*ONEW_mode_kkinit;
Xchar	*ONEW_mode_kanakan;
Xchar	*ONEW_mode_ichiran;
Xchar	*ONEW_mode_sentaku;

Xchar	*ONEW_msg_kk_engineswitch;
Xchar	*ONEW_msg_rk_engineswitch;
Xchar	*ONEW_menu_jiscode;
Xchar	*ONEW_msg_missingromkan;
Xchar	*ONEW_msg_connecting;
Xchar	*ONEW_msg_connectfail;
Xchar	*ONEW_msg_dicfail;
Xchar	*ONEW_msg_cantsavehind;
Xchar	*ONEW_msg_cantdelete;
Xchar	*ONEW_msg_unsupported;

Xchar	*ONEW_mode_jisyo;
Xchar	*ONEW_menu_jisyo;
Xchar	*ONEW_mode_touroku_yomi;
Xchar	*ONEW_mode_touroku_kanji;
Xchar	*ONEW_msg_tourokuOK;
Xchar	*ONEW_msg_tourokuERROR;
Xchar	*ONEW_msg_tourokuABORT;
Xchar	*ONEW_mode_hinshi;
Xchar	*ONEW_menu_touroku;
Xchar	*ONEW_menu_massyou;
Xchar	*ONEW_mode_massyou;
Xchar	*ONEW_msg_massyouOK;

Xchar	ONEW_K_NU[];
Xchar	ONEW_K_NA[];
Xchar	ONEW_K_A[];
Xchar	ONEW_KK_WNN[];
Xchar	ONEW_KK_CANNA[];
Xchar	ONEW_ASCII_TO_JIS[];

Xchar	*ONEW_KOUHO_LABEL;

/*
 *
 */
Xchar ONEW_CurrentYomi[];
Xchar ONEW_CurrentKanji[];

/*
 *
 */
char *oeiRomkanDispmode();
char *rkEngineID();

/*
 *	JVIM cursor key codes
 */
#define JVIM_UARROW	0xffffff80
#define JVIM_DARROW	0xffffff81
#define JVIM_LARROW	0xffffff82
#define JVIM_RARROW	0xffffff83
#define JVIM_HENKAN	0xffffff9f

