/*
 *	codes from COSMOS system
 *		Mar.1991	Yutaka Satou <ysato@etl.go.jp>
 */
char *getenv();
#include <ctype.h>
#include <stdio.h>
#include "onew.h"

char *Onew_env_substitute(istr,ostr)
	char *istr,*ostr;
{	register char *sp,*tp,*np,*op;
	char name[1000],*body;
	char *rstr = istr;

	op = ostr;
	for( sp = istr; *sp; sp++ ){
		if( *sp == '$' ){
			np = name;
			for( tp = sp+1; *tp; tp++ ){
				if( !isalnum(*tp) && *tp != '_' )
					break;
				*np++ = *tp;
			}
			*np = 0;
			if( body = getenv(name) ){
				rstr = ostr;
				strcpy(op,body);
				op += strlen(op);
				sp = tp;
			}
		}
		*op++ = *sp;
	}
	*op = 0;
	if( rstr == ostr ){
		char buf[10000];
		strcpy(buf,ostr);
		Onew_env_substitute(buf,ostr);
	}
	return rstr;
}

Onew_searchPath(file,name,path)
	char *file,*name,*path;
{	char xpath[10000],*sp,*dp;
	int fd;

	Onew_env_substitute(path,xpath);
	sp = xpath;

	while( *sp ){
		dp = file;
		for( ; *sp && *sp != ':'; sp++ )
			*dp++ = *sp;
		*dp++ = '/';
		strcpy(dp,name);
		if( 0 <= (fd = open(file,0)) )
			return fd;

		if( *sp == ':' )
			sp++;
		else	break;
	}
	return -1;
}

Onew_fp_input_ready( fp, wait_usec )
	FILE *fp;
{
	if( fp && Onew_readycc(fp) )
		return 1;

	if( wait_usec < 0 )
		return 0;

	return Onew_fd_input_ready(fileno(fp), wait_usec);
}

Onew_msleep(msec)
{
/*
	usleep(msec*1000);
*/
	sleep(msec/1000);
}

static int (*message)();
Onew_message(fmt,a,b,c,d,e,f,g)
	char *fmt;
{
	if( message )
		(*message)(fmt,a,b,c,d,e,f,g);
	else	fprintf(stderr,fmt,a,b,c,d,e,f,g);
}
onew_messagefunc(func)
	int (*func)();
{
	message = func;
}

static FILE *LOG;
Onew_dbglog(fmt,a,b,c,d,e,f,g)
	char *fmt;
{	char *logfile;

	if( LOG == (FILE*)-1 )
		return;
	if( LOG == 0 ){
		if((logfile = getenv("ONEW_DBGLOG")) == 0
		|| (LOG = fopen(logfile,"w")) == NULL){
			LOG = (FILE*)-1;
			return;
		}
	}
	fprintf(LOG,fmt,a,b,c,d,e,f,g);
	fflush(LOG);
}


Onew_non_ascii(str)
	char *str;
{	char *s;

	for(s = str; *s; s++)
		if( *s & 0x80 )
			return 1;
	return 0;
}


Onew_toupper(ch){
	return (ch&0x7F)==ch ? toupper(ch) : ch;
}



/*
 *	use Linebuff as a queue
 */
static strQovf(len){
	if( (sizeof(Linebuff)-1) <= len ){
		/*ouiMESSAGE(1,"input buffer overflow!! (%d)",len);*/
		/*ouiBEEP(5);*/
		fprintf(stderr,"\nONEW: strQ buffer overflow!! (%d)\n",len);
		return 1;
	}
	return 0;
}
strQenq(Q,c)
	Uchar *Q,c;
{	int len;

	if( c == 0 ) c = 0xFF;
	if( strQovf(len=strlen(Q)) )
		return;
	Q[len] = c;
	Q[len+1] = 0;
}
strQins(Q,c)
	Uchar *Q,c;
{	Linebuff buff;
	int len;

	if( c == 0 ) c = 0xFF;
	if( strQovf(len=strlen(Q)) )
		return;
	strcpy(buff,Q);
	Q[0] = c;
	strcpy(&Q[1],buff);
}
strQdeq(Q)
	Uchar *Q;
{	int i,c;

	if( c = Q[0] ){
		strcpy(Q,Q+1);
		if( c == 0xFF ) c = 0;
		return c;
	}
	return EOF;
}
strQclr(Q)
	Uchar *Q;
{
	Q[0] = 0;
}

/*
 *	array mapped strings
 */
strMAPset(syms,syma,envn,defv,flag)
	char *syms,*syma,*envn,*defv;
	int *flag;
{	int  ch;
	char chs[2];
	char rexp[1024];

	if( syms == 0 ){
		if( syms = getenv(envn) ){
			if(flag) *flag = 1;
		}else	syms = defv;
	}

	if( *syms == '[' )
		re_comp(syms);
	else{
		sprintf(rexp,"[%s]",syms);
		re_comp(rexp);
	}
	chs[1] = 0;
	for(ch = 1; ch < 128; ch++){
		chs[0] = ch;
		if( re_exec(chs) == 1 )
			syma[ch] = 1;
		else	syma[ch] = 0;
	}
}
char *strMAPget(syms,syma)
	char *syms,*syma;
{	int ch;
	char *chp;

	chp = syms;
	for(ch = 1; ch < 128; ch++){
		if( syma[ch] ){
			if( 0x20 <= ch )
				*chp++ = ch;
			else{
				*chp++ = '^';
				*chp++ = ch + 0x40;
			}
		}
	}
	*chp = 0;
	return syms;
}
