/*
 *	A simple example of builtin onew
 *		Nov.3 1993 <ysato@etl.go.jp>
 */
#include <stdio.h>
#include <signal.h>

#define ESC	033
#define SPACE	' '
#define NL	'\n'
#define BS	'\b'
#define DEL	0177
#define KILL	('U'-0x40)

static int TTYIN;

main(ac,av){
	TTYIN = isatty(0);

	if( TTYIN ){
		Onew_ttyIcanon(0);
		setbuf(stdin,NULL);
		setbuf(stdout,NULL);
		signal(SIGINT,SIG_IGN);
		onew_builtin();
		Onew_ttyIcanon(1);
	}else	onew_builtin();
}

/********************************************************
 *							*
 ********************************************************/
static char KAKUTEI[1024];
static char YOMI[1024];
static char KANJI[1024];
static int  YOMI_LEN;

onew_builtin(){
	Onew_RK_cmode_set('h');

	KAKUTEI[0] = 0;
	YOMI[0] = 0;
	YOMI_LEN = 0;
	return onew_getline();
}

static int disp_half;
onew_getline(){
	int ch;

	while( (ch = Onew_romkan()) != EOF ){
		if( ch == ESC )
			break;

		disp_half = 0;
		printf("%c",ch);
		switch( ch ){
			case DEL: case BS:
					back_char(); break;
			case KILL:	kill_line(); break;
			case NL:	goto exit;
			default:	YOMI[YOMI_LEN++] = ch;
					YOMI[YOMI_LEN] = 0;
					break;
		}
	}
exit:	return ch;
}

/********************************************************
 *	INPUT AND ROMAJI KANA TRANSLATION		*
 ********************************************************/
static char *Cmode;
ONEW_DISP_ROMKANMODE(mode,help,imode)
	char *mode;
{
	Cmode = mode;
	disp_mode();
}
static disp_mode(){
	int i,len;

	len = strlen(Cmode);
	if( disp_half )
		Onew_tputs("nd",stdout);
	else	printf(" ");
	printf("%s",Cmode);
	len += 1;

	Onew_tputs("cd",stdout);
	for( i = 0; i < len; i++ )
		printf("\b");
	fflush(stdout);
}
ONEW_DISP_KANAHALF(ch)
{
	disp_half = 1;
	printf("%c\b",ch);
}
/********************************************************
 *	KANA KANJI TRANSLATION				*
 ********************************************************/
ONEW_KANAKAN(startch)
{	int endch;

	YOMI[YOMI_LEN] = 0;
	endch = Onew_kanakan(startch,YOMI,0,YOMI_LEN);

	if( endch == BS || endch == DEL ){
		printf("\r%s%s",KAKUTEI,YOMI);
		return 0;
	}

	Onew_kakutei(endch);
	if( startch == SPACE )
		return 0;
	if( endch == NL )
		return 0;
	return startch;
}
ONEW_DISP_KANAKANB(so,left,cur,right)
	char *left,*cur,*right;
{
	sprintf(KANJI,"%s%s%s",left,cur,right);
	printf("\r%s",KAKUTEI);
	if(so)	disp_bunsetsu(left,cur,right);
	else	printf("%s",KANJI);
	disp_mode();
}
ONEW_KAKUTEI(ch)
{
	if( 0 < YOMI_LEN ){
		if( KANJI[0] )
			strcat(KAKUTEI,KANJI);
		else	strcat(KAKUTEI,YOMI);
		KANJI[0] = 0;
		YOMI_LEN = 0;
		YOMI[0] = 0;
		return 1;
	}
	return 0;
}
/********************************************************
 *	MESSAGES					*
 ********************************************************/
ONEW_MESSAGE_COLS()
{
	return Onew_tgetnum("co") - strlen(KAKUTEI) - YOMI_LEN - 2;
}
ONEW_MESSAGE(so,fmt,a,b,c,d,e,f,g)
{	char msg[1024];
	int len,i;

	sprintf(msg,fmt,a,b,c,d,e,f,g);
	printf("%s",msg);
	len = strlen(msg);
	for( i = 0; i < len; i++ )
		printf("\b");
}

/********************************************************
 *	LINE EDITOR					*
 ********************************************************/
static back_char(){
	int len;
	if( 0 < YOMI_LEN ){
		YOMI_LEN -= 1;
		if( 0x80 & YOMI[YOMI_LEN] )
			YOMI_LEN -= 1;
		YOMI[YOMI_LEN] = 0;
		printf("\b \b");
		return 1;
	}else
	if( len = strlen(KAKUTEI) ){
		len--;
		if( 0x80 & KAKUTEI[len] )
			len--;
		KAKUTEI[len] = 0;
		printf("\b \b");
		return 1;
	}
	return 0;
}
static kill_line(){
	YOMI_LEN = 0;
	YOMI[0] = 0;
	KAKUTEI[0] = 0;
	printf("\r");
	Onew_tputs("cd",stdout);
}

/********************************************************
 *	TERMINAL CAPABILITY				*
 ********************************************************/
disp_bunsetsu(left,cur,right)
	char *left,*cur,*right;
{
	if( *left ){
		Onew_tputs("us",stdout);
		printf("%s",left);
		Onew_tputs("ue",stdout);
	}
	Onew_tputs("so",stdout);
	printf("%s",cur);
	Onew_tputs("se",stdout);
	if( *right ){
		Onew_tputs("us",stdout);
		printf("%s",right);
		Onew_tputs("ue",stdout);
	}
}
