/*
 *	REGULAR EXPRESSION
 */
#include "sys.h"

#if defined(solaris) \
 || defined(nec_ews) \
 || defined(AUX3)

#if !defined(AUX3)
# include <libgen.h>
#endif

static char *REXP;
re_comp(rexp)
	char *rexp;
{
	if( REXP )
		free(REXP);
	REXP = regcmp(rexp, 0);
	return 0;
}

re_exec(pattern)
	char *pattern;
{
	if( REXP == 0 )
		return 0;

	if( regex(REXP, pattern, 0) == 0 )
		return 0;
	else	return 1;
}

#else
#if defined(hpux) || defined(bsdi)

#ifdef bsdi
#include <stdio.h>
#include <sys/types.h>
#endif
#include <regex.h>

static regex_t REXP;
re_comp(s)
	char *s;
{
	if( *(int*)&REXP != 0 )
		regfree(&REXP);
	regcomp(&REXP, s, REG_NOSUB);
	return 0;
}
re_exec(s)
	char *s;
{
	if(s == 0) return 0;
	return regexec(&REXP,s,(size_t)0,NULL,0) == 0;
}

#else
static int dummy;
#endif
#endif
