/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1993 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	SJIS.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	930923	extracted from codeconv.c of cosmos
///////////////////////////////////////////////////////////////////////*/
#include "jiscode.h"

int TREAT_SJIS = 1;

unsigned char *
SJIS_TO_JIS1(HI,LO,JCODE)
	register unsigned char HI,LO,*JCODE;
{
	HI -= (HI <= 0x9F) ? 0x71 : 0xB1;
	HI = (HI << 1) + 1;
	if( 0x7F < LO )
		LO--;
	if( 0x9E <= LO ){
		LO -= 0x7D;
		HI++;
	}else	LO -= 0x1F;
	JCODE[0] = HI;
	JCODE[1] = LO;
	return JCODE;
}
unsigned char *
JIS_TO_SJIS1(HI,LO,SJCODE)
	register unsigned char HI,LO,*SJCODE;
{
	if( HI & 1 )
		LO += 0x1F;
	else	LO += 0x7D;
	if( 0x7F <= LO )
		LO++;

	HI = ((HI - 0x21) >> 1) + 0x81;
	if( 0x9F < HI )
		HI += 0x40;
	SJCODE[0] = HI;
	SJCODE[1] = LO;
	return SJCODE;
}

unsigned char *
SJIS_TO_EUC1(HI,LO,EUC)
	unsigned char HI,LO,*EUC;
{
	SJIS_TO_JIS1(HI,LO,EUC);
	EUC[0] |= 0x80;
	EUC[1] |= 0x80;
	return EUC;
}

unsigned char *
SJIS_TO_EUC(src,dst)
	unsigned char *src,*dst;
{	register unsigned char hi,lo,*sp,*dp;
	register int in_sjis = 0;

	for(sp=src, dp=dst; hi = sp[0]; ){
		lo = sp[1];
		if( TREAT_SJIS && IS_SJIS(hi,lo,in_sjis) ){
			SJIS_TO_JIS1(hi,lo,dp);
			dp[0] |= 0x80;
			dp[1] |= 0x80;
			dp += 2;
			sp += 2;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

unsigned char *
EUC_TO_SJIS(src,dst)
	unsigned char *src,*dst;
{	register unsigned char *sp,*dp;

	for(sp=src, dp=dst; *sp; ){
		if( *sp & 0x80 ){
			if( sp[1] && (sp[1] & 0x80) ){
				JIS_TO_SJIS1(sp[0]&0x7F,sp[1]&0x7F,dp);
				dp += 2; sp += 2;
			}else	sp++;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

#define Strcpy(a,b)	(strcpy(a,b),&a[strlen(a)])

unsigned char *
EUC_TO_JIS(src,dst,toK,toA)
	unsigned char *src,*dst;
	char *toK,*toA;
{	register unsigned char kana_mode = 0;
	register unsigned char cch;
	register unsigned char *sp = src;
	register unsigned char *dp = dst;

	while( cch = *sp++ ){
		if(cch & 0x80){
			if(!kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toK);
			}
			if( *sp & 0x80 ){
				*dp++ = cch & ~0x80;
				*dp++ = *sp++ & ~0x80;
			}
		}else{
			if(kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toA);
			}
			*dp++ = cch;
		}
	}
	if(kana_mode)
		dp = Strcpy(dp,toA);

	if(dp)	*dp = 0;
	return dst;
}

unsigned char*
TO_EUC(jis,euc)
	unsigned char *jis,*euc;
{	register unsigned char *s,*d,c,jis_stat;
	register to1B,to2B;
	register int in_sjis = 0;
	static int nje;

	nje++;
	s = jis;
	d = euc;
	jis_stat = 0;
	to2B = TO_2BCODE;
	to1B = TO_1BCODE;

	while( c = *s++ ){
		if(c == ESC){
			if(*s == to2B){
				if((s[1] == 'B') || (s[1] == '@')){
					jis_stat = 0x80; s += 2;
					continue;
				}
			}else
			if(*s == to1B){
				if((s[1]=='B') || (s[1]=='J') || (s[1]=='H')){
					jis_stat = 0; s += 2;
					continue;
				}
			}
		}
		if( IS_SJIS(c,*s,in_sjis) ){
			SJIS_TO_EUC1(c,*s,d);
			d += 2;
			s++;
		}else
		if(jis_stat && (0x20 < c))
			*d++ = jis_stat | c;
		else	*d++ = c;
	}
	*d = 0;
	return euc;
}

TO_SJIS(any,sjis)
	unsigned char *any,*sjis;
{	char *euc;

	euc = (char*)malloc(strlen(any)+1);
	TO_EUC(any,euc);
	EUC_TO_SJIS(euc,sjis);
	free(euc);
}

TO_JIS(any,jis)
	unsigned char *any,*jis;
{	char *euc;

	euc = (char*)malloc(strlen(any)+1);
	TO_EUC(any,euc);
	EUC_TO_JIS(euc,jis,TO_KANJI,TO_ASCII);
	free(euc);
}

