# Configuration file for ServiceMail
# The root directory for the ServiceMail installation
#if you want to use a different compiler from cc, put that here
CC=cc

# If you don't like $(HOME) put your choice here.
TOPDIR=/expdist/smtest

# Where the binaries go
BINDIR=$(TOPDIR)/bin

# Where tmpfiles live
TMPDIR=/tmp

# The mailer to use. Metamail's splitmail is probably best.
# Sendmail will work, but may truncate large messages
MAILER=/usr/local/bin/splitmail -d -s %d
#MAILER=/usr/lib/sendmail -t

# By default, Mesh is wired into the .forward file of the
# services user. If you don't want this, e.g. you want to
# use aliases instead, comment this out. Note that
# if neither aliases nor forward are used, there is no way
# for mail to get to mesh and therefore Servicemail won't WORK.
FORWARD=forward

# Mesh can be wired into /etc/aliases as well as .forward. In
# order to enable alias redirection, 
# we have /etc/aliases contain a pointer to files which really
# contain the alias. If you intend to use aliases, define the
# directory and aliases below.  
#ALSDIR=$(TOPDIR)/aliases

# Source placement is pretty much hardwired into the distribution.
# I.e. the distribution gets unpacked that way. If you choose
# to move it, you'll need to do so by hand and rewrite these
# variables to reflect that. It is assumed that all the C sources
# live in subdirectories of sources.
# Where sources go
SRCDIR=$(TOPDIR)/src
# Where the servicemail Tcl scripts go
SERVSRC=$(TOPDIR)/src/services 

# ServiceMail uses John Osterhout's Tcl package. If you have
# installed this already, change TCLLIBDIR to the directory
# where libtcl.a lives and comment out the two lines afterwards.
TCLLIBDIR=$(SRCDIR)/mesh/tcl
TCLSRCDIR=$(SRCDIR)/mesh/tcl
TCLBUILD=$(TCLLIBDIR)/libtcl.a

# This version of ServiceMail includes support for transaction
# logging. Logging is accomplished via syslog(3).
# To enable it, uncomment the next two lines. If you 
# don't like local6 as the default facility substitute
# something else for FACILITY. 
#MFLAGS=-DUSESYSLOG
#FACILITY=LOG_LOCAL6 


# A. To enable the queueing and job control mechanism, uncomment the next 
# group of lines down to B) below. Then save and quit.
# Queueing configuration
# directory to which incoming mail is to be spooled
#SPOOLDIR=/usr/spool/servicemail

# directory where messages from diverted services are to be spooled
# SVCDIVERTDIR=$(SPOOLDIR)/svc

# directory where messages from diverted mailboxes are to be spooled
# MBXDIVERTDIR=$(SPOOLDIR)/mbx

# Flags for the dispatcher. RTFM dspd(1) for more details. Otherwise,
# just take my word for it.
# DSPDFLAGS=-b -q10 -s10 -e $(BINDIR)/mesh 
#just uncomment this stuff
#TARGETS=pdinq requeue dspd shell mesh $(FORWARD)
#FIRSTPROG=pdinq

# On later Sun systems, fork() is implemented with copy-on-write, so
# fork(2) should be similar in speed to vfork(2). If this is not
# the case on your system, you should uncomment USEVFORK.
# If your vfork() needs vfork.h to be included, uncomment USEVFORKH
# as well
#USEVFORK=-DUSEVFORK
#USEVFORKH=-DUSEVFORKH

# On Sun systems, wait3 will not be interrupted by a SIGALRM.
# If this is not the case on your system, uncomment NOSIGINTERRUPT.
# Otherwise, leave it be.
#NOSIGINTERRUPT=-DNOSIGINTERRUPT
# B. and comment out these
FIRSTPROG=mesh 
TARGETS=mesh $(FORWARD) shell
#------ End of configuration----
