/*Copyright (c)  1993 Enterprise Integration Technologies Corporation

Permission to use, copy, modify, distribute, and sell this software and
its documentation for any purpose is hereby granted without fee, provided
that (i) the above copyright notices and this permission notice appear in
all copies of the software and related documentation, and (ii) the name of
Enterprise Integration Technologies Corporation may not be used in any
advertising or publicity relating to the software without the specific,
prior written permission of Enterprise Integration Technologies Corporation.

THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.

IN NO EVENT SHALL ENTERPRISE INTEGRATION TECHNOLOGIES CORPORATION  BE
LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF
ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY
THEORY OF LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <fcntl.h>
#include "errors.h"

/*Site configuration stuff....(for building).*/
#ifdef USEVFORKH
#include <vfork.h>
#endif

#define USESIGINTERRUPT

#ifdef NOSIGINTERRUPT
#undef USESIGINTERRUPT
#endif

#define NAMELEN 20        
/*You shouldn't have to edit anything past this line*/

#define PIDFILE ".dsp.pid"
#define MESH_PATH "mesh"
#define DOWNHEAP k=1;\
        while(k<=(size/2))\
        {\
           j=k+k;\
           if(j<size && (nicecmp(msgplist[j],msgplist[j+1])<0)) j++;\
           if(nicecmp(new,msgplist[j])>=0) break;\
           msgplist[k]=msgplist[j]; k=j;\
        }\
        msgplist[k]=new;

#define MAX_MESHES 20
#define QUEUESIZE 1000
static int sleepwhenempty=300;
static int queuetime=300;
static int killtime=600;
static time_t nextscanat;
static int maxmeshes=5;
static int meshes=0;
static int halt=0;
static int rund=0;
static int queuesize=1000;
static int prival=1;
static int timeval=0;
static int facility=LOG_LOCAL6;
static int logfac=6;
static int nounlink=0;
static int totalmsgs;
static uid_t uid;
static gid_t gid;
static char spooldir[MAXPATHLEN]; /*If you don't have this, take a guess...*/
static char executable[MAXPATHLEN];
extern char *optarg;

int readok();
int sigbogo();
int sighalt();
int procwait();

struct errinfo
{
  char *msg;
  int level;
  int status;
};

struct errinfo err[]={
  {"Unable to stat: ",LOG_ALERT,SYSTEM},
  {"Unable to open directory for reading: ",LOG_EMERG,FATAL|SYSTEM},
  {"Unable to fork() or vfork() ",LOG_ALERT,SYSTEM},
  {"Unable to exec() ",LOG_EMERG,SYSTEM},
  {"Unable to kill timed-out processing of: ",LOG_EMERG,SYSTEM},
  {"Unable to remove: ",LOG_EMERG,SYSTEM},
  {"File remained after processing. Erased: ",LOG_INFO,NULL},
  {"File remained after processing. Could not remove: ",LOG_EMERG,SYSTEM},
  {"Error during wait3() for processes. ",LOG_ALERT,SYSTEM},
  {"Error creating PID record. Job control will not work. ",LOG_ALERT,SYSTEM},
  {"Error deleting PID record. ",LOG_EMERG,SYSTEM}
};

struct dirdat {
  char d_name[NAMELEN];
  struct stat buf;
} *msgplist[QUEUESIZE];

struct {
  pid_t pid;
  char d_name[NAMELEN];
  time_t starttime;
} procdata[MAX_MESHES];
