# ftp servicemail gateway
#
# 16-Sept-92 weber@eitech.com
#
# This service retrieves a file from an anonymous ftp site.
#

proc ftp {switches envelope inputs} {
  set site [getfield $switches site]
# should this be the requestor instead of the services account?
  set user "[exec whoami]@[exec hostname]"
  set dir  [getfield $switches directory]
  set file [getfield $switches name]
  set mode [getfield $switches mode]
  puts stdout "$site $user $file"
  set fid [open "|ftp -n" w]
  puts $fid "open $site"
  puts $fid "user anonymous $user"
  if {$dir != ""} {puts $fid "cd $dir"}
  if {$mode != ""} {puts $fid "type $mode"}
  puts $fid "get $file $file"
  puts $fid "quit"
  if {[catch "close $fid" ftpout] || ![file exists $file]} {
    setfield response STRING "Sorry, ftp didn't work.\n$ftpout"
    setfield response DESCRIPTION "error return from anon-ftp"
  } {
    setfield response FILE $file
    setfield response DESCRIPTION "the file you requested of anon-ftp"
    setmimetype response
  }
  return [mailout [turnaround $envelope] $response]
}

proc setmimetype {objectname} {
    # set up filename as call-by-name
    upvar $objectname object
    set filename [getfield $object FILE]
    case $filename {
	*.ps { setfield object TYPE application; setfield object SUBTYPE postscript }
	*.tex { setfield object TYPE text; setfield object SUBTYPE x-latex }
	*.c { setfield object TYPE application; setfield object SUBTYPE x-c }
	*.sh { setfield object TYPE application; setfield object SUBTYPE x-sh }
	*.tar.Z { setfield object TYPE application
		  setfield object SUBTYPE octet-stream
		  setfield params name $filename
		  setfield params type tar
		  setfield params conversions compress
		  setfield object PARAMS $params
		}
	*.tar { setfield object TYPE application
		  setfield object SUBTYPE octet-stream
		  setfield params name $filename
		  setfield params type tar
		  setfield object PARAMS $params
		}
    }
}
