##---------------------------------------------------------------------------##
##  File:
##	@(#)  mhexternal.pl 1.9 96/12/26 @(#)
##  Author:
##      Earl Hood       ehood@medusa.acs.uci.edu
##  Description:
##	Library defines a routine for MHonArc to filter content-types
##	that cannot be directly filtered into HTML, but a linked to an
##	external file.
##
##	Filter routine can be registered with the following:
##
##		<MIMEFILTERS>
##		*/*:m2h_external'filter:mhexternal.pl
##		</MIMEFILTERS>
##
##	Where '*/*' represents various content-types.  See code below for
##	all types supported.
##
##---------------------------------------------------------------------------##
##    MHonArc -- Internet mail-to-HTML converter
##    Copyright (C) 1995,1996	Earl Hood, ehood@medusa.acs.uci.edu
##
##    This program is free software; you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation; either version 2 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##---------------------------------------------------------------------------##

package m2h_external;

%ExtCnt = ();	# Array of filename counters for generated files

##---------------------------------------------------------------------------
##	All that should be required is to add to, or edit, the %CTExt and
##	%CTType arrays for new, or changed, application suptypes.

$UnknownExt	= 'xxx';
$UnknownType	= 'Unrecognized Data';

%CTExt = (
##---------------------------------------------------------
##  Content-Type			Filename extension
##---------------------------------------------------------
    'application/mac-binhex40', 	'hqx',
    'application/octet-stream', 	'bin',
    'application/oda', 			'oda',
    'application/pdf', 			'pdf',
    'application/pgp',  		'pgp',
    'application/pgp-signature',	'pgp',
    'application/postscript', 		'ps',
    'application/rtf', 			'rtf',
    'application/vnd.ms-excel',         'xls',
    'application/vnd.ms-powerpoint',    'ppt',
    'application/x-bcpio', 		'bcpio',
    'application/x-cpio', 		'cpio',
    'application/x-csh', 		'csh',
    'application/x-dvi', 		'dvi',
    'application/x-gtar', 		'gtar',
    'application/x-hdf', 		'hdf',
    'application/x-ksh',		'ksh',
    'application/x-latex', 		'latex',
    'application/x-mif', 		'mif',
    'application/x-netcdf', 		'cdf',
    'application/x-patch',		'patch',
    'application/x-perl',		'pl',
    'application/x-script',		'script',
    'application/x-sh', 		'sh',
    'application/x-shar', 		'shar',
    'application/x-sv4cpio', 		'sv4cpio',
    'application/x-sv4crc', 		'sv4crc',
    'application/x-tar', 		'tar',
    'application/x-tcl', 		'tcl',
    'application/x-tex', 		'tex',
    'application/x-texinfo', 		'texinfo',
    'application/x-troff', 		'roff',
    'application/x-troff-man', 		'man',
    'application/x-troff-me', 		'me',
    'application/x-troff-ms', 		'ms',
    'application/x-ustar', 		'ustar',
    'application/x-wais-source', 	'src',
    'application/zip', 			'zip',
    'audio/basic', 			'snd',
    'audio/x-aiff', 			'aif',
    'audio/x-wav', 			'wav',
    'image/gif',			'gif',
    'image/ief',			'ief',
    'image/jpeg',			'jpg',
    'image/tiff',			'tif',
    'image/x-bmp',			'bmp',
    'image/x-cmu-raster',		'ras',
    'image/x-pbm',			'pbm',
    'image/x-pcx',			'pcx',
    'image/x-pgm',			'pgm',
    'image/x-pict',			'pict',
    'image/x-pnm',			'pnm',
    'image/x-portable-anymap',		'pnm',
    'image/x-portable-bitmap',		'pbm',
    'image/x-portable-graymap',		'pgm',
    'image/x-portable-pixmap',		'ppm',
    'image/x-ppm',			'ppm',
    'image/x-rgb',			'rgb',
    'image/x-xbitmap',			'xbm',
    'image/x-xbm',			'xbm',
    'image/x-xpixmap',			'xpm',
    'image/x-xpm',			'xpm',
    'image/x-xwd',			'xwd',
    'image/x-xwindowdump',		'xwd',
    'text/html',			'html',
    'text/plain',			'txt',
    'text/richtext',			'rtx',
    'text/setext',			'stx',
    'text/x-html',			'html',
    'text/x-setext',			'stx',
    'video/mpeg',			'mpg',
    'video/quicktime',			'mov',
    'video/x-msvideo',			'avi',
    'video/x-sgi-movie',		'movie',

);

%CTType = (
##---------------------------------------------------------
##  Content-Type			English name
##---------------------------------------------------------
    'application/mac-binhex40', 	'Mac BinHex file',
    'application/octet-stream', 	'Binary data',
    'application/oda', 			'ODA file',
    'application/pdf', 			'PDF file',
    'application/pgp',     		'PGP message',
    'application/pgp-signature',	'PGP signature',
    'application/postscript', 		'PostScript file',
    'application/rtf', 			'RTF file',
    'application/vnd.ms-excel',         'MS-Excel file',
    'application/vnd.ms-powerpoint',    'MS-Powerpoint file',
    'application/x-bcpio', 		'BCPIO file',
    'application/x-cpio', 		'CPIO file',
    'application/x-csh', 		'Csh script',
    'application/x-dvi', 		'TeX dvi file',
    'application/x-gtar', 		'Gtar file',
    'application/x-hdf', 		'HDF file',
    'application/x-ksh',		'Korn Shell script',
    'application/x-latex', 		'LaTex document',
    'application/x-mif', 		'Frame MIF document',
    'application/x-netcdf', 		'Cdf file',
    'application/x-patch',		'Patch file',
    'application/x-perl',		'Perl script/module',
    'application/x-script',		'A script file',
    'application/x-sh', 		'Sh script',
    'application/x-shar', 		'Shar file',
    'application/x-sv4cpio', 		'SV4Cpio file',
    'application/x-sv4crc', 		'SV4Crc file',
    'application/x-tar', 		'Tar file',
    'application/x-tcl',		'Tcl script',
    'application/x-tex', 		'TeX document',
    'application/x-texinfo', 		'TeXInfo document',
    'application/x-troff', 		'Troff document',
    'application/x-troff-man', 		'Troff manpage',
    'application/x-troff-me', 		'Troff ME',
    'application/x-troff-ms', 		'Troff MS',
    'application/x-ustar', 		'UStar file',
    'application/x-wais-source', 	'WAIS Source',
    'application/zip', 			'Zip file',
    'audio/basic', 			'Basic audio',
    'audio/x-aiff', 			'AIF audio',
    'audio/x-wav', 			'WAV audio',
    'image/gif',			'GIF image',
    'image/ief',			'IEF image',
    'image/jpeg',			'JPEG image',
    'image/tiff',			'TIFF image',
    'image/x-bmp',			'Windows bitmap',
    'image/x-cmu-raster',		'CMU raster',
    'image/x-pbm',			'Portable bitmap',
    'image/x-pcx',			'PCX image',
    'image/x-pgm',			'Portable graymap',
    'image/x-pict',			'Mac PICT image',
    'image/x-pnm',			'Portable anymap',
    'image/x-portable-anymap',		'Portable anymap',
    'image/x-portable-bitmap',		'Portable bitmap',
    'image/x-portable-graymap',		'Portable graymap',
    'image/x-portable-pixmap',		'Portable pixmap',
    'image/x-ppm',			'Portable pixmap',
    'image/x-rgb',			'RGB image',
    'image/x-xbitmap',			'X bitmap',
    'image/x-xbm',			'X bitmap',
    'image/x-xpixmap',			'X pixmap',
    'image/x-xpm',			'X pixmap',
    'image/x-xwd',			'X window dump',
    'image/x-xwindowdump',		'X window dump',
    'text/html',			'HTML document',
    'text/plain',			'Text document',
    'text/richtext',			'Richtext document',
    'text/setext',			'Setext document',
    'text/x-html',			'HTML document',
    'text/x-setext',			'Setext document',
    'video/mpeg',			'MPEG movie',
    'video/quicktime',			'QuickTime movie',
    'video/x-msvideo',			'MS video',
    'video/x-sgi-movie',		'SGI movie',

);

##---------------------------------------------------------------------------
##	Filter routine.
##
##	Argument string may contain the following values.  Each value
##	should be separated by a space:
##
##	inline  	Inline image data by default if
##			content-disposition not defined.
##
##	usename 	Use (file)name attribute for determining name
##			of derived file.  Use this option with caution
##			since it can lead to filename conflicts and
##			security problems.
##
##	ext=ext 	Use `ext' as the filename extension.
##
##	type="description"
##			Use "description" as type description of the
##			data.  The double quotes are required.
##
sub filter {
    local($header, *fields, *data, $isdecode, $args) = @_;
    local($ret,
	  $filename,
	  $name,
	  $nameparm,
	  $disp,
	  $ctype,
	  $type,
	  $ext,
	  $inline,
	  $inext,
	  $intype);

    ## Init variables
    $name	= '';
    $ctype	= '';
    $type	= '';
    $ext	= '';
    $inline	=  0;
    $inext	= '';
    $intype	= '';

    ## Get content-type
    ($ctype) = $fields{'content-type'} =~ m%^\s*([\w-\./]+)%;
    $ctype =~ tr/A-Z/a-z/;

    ## Get disposition
    ($disp, $nameparm) = &'MAILhead_get_disposition(*fields);

    ## Check if using name
    if ($args =~ /usename/i) {
	$name = $nameparm;
    } else {
	$name = '';
    }

    ## Check if inlining (images only)
    if ($disp) {
	$inline = ($disp =~ /inline/i);
    } else {
	$inline = ($args =~ /inline/i);
    }

    ## Check if extension and type description passed in
    if ($args =~ /ext=(\S+)/i) { $inext = $1; }
    if ($args =~ /type="([^"]+)"/i) { $intype = $1; }

    ## Determine default filename extension
    $ext  = $inext  || $CTExt{$ctype};
    $type = $intype || $CTType{$ctype};
    if (!$ext) {
	$ext = $UnknownExt;
	$type = "$UnknownType: $ctype";
    }
    $pre  = $ext;

    ## Write file
    $filename = &write_file(*data, $name, $pre, $ext);

    ## Create HTML markup
    if ($inline && ($ctype =~ /image/i)) {
	$ret  = "<P>" . &htmlize($fields{'content-description'}) . "</P>\n"
	    if ($fields{'content-description'});
	$ret .= qq{<P><A HREF="$filename"><IMG SRC="$filename" } .
		qq{ALT="$type"></A></P>\n};

    } else {
	$ret  = qq{<P><A HREF="$filename">} .
		(&htmlize($fields{'content-description'}) ||
		 $nameparm || $type) .
		qq{</A></P>\n};
    }
    ($ret, $filename);
}

sub write_file {
    local(*stuff, $fname, $pre, $ext) = @_;
    local($tmp, $cnt) = ('', '');

    if (!$fname) {
	if (!$ExtCnt{$ext}) { &set_cnt(); }
	$cnt = $ExtCnt{$ext}++;
	$fname = $pre . sprintf("%05d.",$cnt) . $ext;
    }

    ## $'OUTDIR is set by MHonArc that specifies destination path
    ## of filtered mail.
    ##
    $tmp = $'OUTDIR . $'DIRSEP . $fname;

    if (open(OUTFILE, "> $tmp")) {
	binmode(OUTFILE);		# For MS-DOS
	print OUTFILE $stuff;
	close(OUTFILE);
    } else {
	warn "Warning: Unable to create $tmp\n";
    }
    $fname;
}

sub set_cnt {
    local(@files) = ();
    opendir(DIR, $'OUTDIR);
    @files = sort numerically grep(/^$pre\d+\.$ext$/i, readdir(DIR));
    close(DIR);
    if (@files) {
	($ExtCnt{$ext}) = $files[$#files] =~ /(\d+)/;
	$ExtCnt{$ext}++;
    } else {
	$ExtCnt{$ext} = 0;
    }
}

sub numerically {
    ($A) = $a =~ /(\d+)/;
    ($B) = $b =~ /(\d+)/;
    $A <=> $B;
}

sub htmlize {
    local($txt) = shift;
    $txt =~ s/&/\&amp;/g;
    $txt =~ s/>/&gt;/g;
    $txt =~ s/</&lt;/g;
    $txt;
}

1;
