/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1993 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	SJIS.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	930923	extracted from codeconv.c of cosmos
///////////////////////////////////////////////////////////////////////*/
#include <string.h>
char *malloc();

/*
 *	STATUS CHANGE CODES
 */
#define ESC		'\033'
#define TO_2BCODE	'$'
#define TO_1BCODE	'('

#define TO_KANA		'\016'
#define TO_KANAOUT	'\017'

#define TO_KANJI	"\033$B"
#define TO_ASCII	"\033(B"

#define IS_SJIS_LO(lo)	((0x40<=lo)&&(lo!=0x7F)&&(lo<=0xFC))
#define IS_SJIS_HI1(hi) ((0x81<=hi)&&(hi<=0x9F))	/* 1st lev. */
#define IS_SJIS_HI2(hi) ((0xE0<=hi)&&(hi<=0xEF))	/* 2nd lev. */
#define IS_SJIS(hi,lo,in_sjis)\
	(!IS_SJIS_LO(lo) ? 0:\
	IS_SJIS_HI1(hi) ? (in_sjis = 1):\
	in_sjis && IS_SJIS_HI2(hi))

#define IS_EUC_LOS(lo)	((0x21<=lo)&&(lo<=0x7E))	/* standard */
#define IS_EUC_LOX(lo)	((0xA1<=lo)&&(lo<=0xFE))	/* extended */
#define IS_EUC_HI(hi)	((0xA1<=hi)&&(hi<=0xFE))
#define IS_EUC(hi,lo)\
	IS_EUC_HI(hi) && (IS_EUC_LOS(lo) || IS_EUC_LOX(lo))


int TREAT_SJIS = 1;

IS_SJIS_STR(str)
	unsigned char *str;
{	unsigned char *s,ch;
	int is_sjis = 0;

	s = str;
	while( ch = *s++ ){
		if( ch & 0x80 )
			if( IS_SJIS(ch,*s,is_sjis) )
				return 1;
	}
	return 0;
}

unsigned char *
SJIS_TO_JIS1(HI,LO,JCODE)
	register unsigned char HI,LO,*JCODE;
{
	HI -= (HI <= 0x9F) ? 0x71 : 0xB1;
	HI = (HI << 1) + 1;
	if( 0x7F < LO )
		LO--;
	if( 0x9E <= LO ){
		LO -= 0x7D;
		HI++;
	}else	LO -= 0x1F;
	JCODE[0] = HI;
	JCODE[1] = LO;
	return JCODE;
}
unsigned char *
JIS_TO_SJIS1(HI,LO,SJCODE)
	register unsigned char HI,LO,*SJCODE;
{
	if( HI & 1 )
		LO += 0x1F;
	else	LO += 0x7D;
	if( 0x7F <= LO )
		LO++;

	HI = (((int)HI - 0x21) >> 1) + 0x81;
	if( 0x9F < HI )
		HI += 0x40;
	SJCODE[0] = HI;
	SJCODE[1] = LO;
	return SJCODE;
}

unsigned char *
SJIS_TO_EUC1(HI,LO,EUC)
	unsigned char HI,LO,*EUC;
{
	SJIS_TO_JIS1(HI,LO,EUC);
	EUC[0] |= 0x80;
	EUC[1] |= 0x80;
	return EUC;
}

unsigned char *
SJIS_TO_EUC(src,dst)
	unsigned char *src,*dst;
{	register unsigned char hi,lo,*sp,*dp;
	register int in_sjis = 0;

	in_sjis = IS_SJIS_STR(src);
	for(sp=src, dp=dst; hi = sp[0]; ){
		lo = sp[1];
		if( TREAT_SJIS && IS_SJIS(hi,lo,in_sjis) ){
			SJIS_TO_JIS1(hi,lo,dp);
			dp[0] |= 0x80;
			dp[1] |= 0x80;
			dp += 2;
			sp += 2;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

unsigned char *
EUC_TO_SJIS(src,dst)
	unsigned char *src,*dst;
{	register unsigned char *sp,*dp;

	for(sp=src, dp=dst; *sp; ){
		if( *sp & 0x80 ){
			if( sp[1] && (sp[1] & 0x80) ){
				JIS_TO_SJIS1(sp[0]&0x7F,sp[1]&0x7F,dp);
				dp += 2; sp += 2;
			}else	sp++;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

#define Strcpy(a,b)	(strcpy((char*)a,(char*)b),&a[strlen((char*)a)])

unsigned char *
EUC_TO_JIS(src,dst,toK,toA)
	unsigned char *src,*dst;
	char *toK,*toA;
{	register unsigned char kana_mode = 0;
	register unsigned char cch;
	register unsigned char *sp = src;
	register unsigned char *dp = dst;

	while( cch = *sp++ ){
		if(cch & 0x80){
			if(!kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toK);
			}
			if( *sp & 0x80 ){
				*dp++ = cch & ~0x80;
				*dp++ = *sp++ & ~0x80;
			}
		}else{
			if(kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toA);
			}
			*dp++ = cch;
		}
	}
	if(kana_mode)
		dp = Strcpy(dp,toA);

	if(dp)	*dp = 0;
	return dst;
}

#define	IS_JIS7(c1,c2)	(0x20<(c1)&&(c1)<0x7F && 0x20<(c2)&&(c2)<0x7F)
#define SO		('N'-0x40)
#define SI		('O'-0x40)

int recover_JIS = 0;
static unsigned char *recoverJIS(src,dstp)
	unsigned char *src,**dstp;
{	unsigned char *s,*d,ch1,ch2;

	d = *dstp;
	s = src;
	while( (ch1 = s[0]) && (ch2 = s[1]) ){
		s += 2;
		if( ch1 == '(' )
		if( ch2 == 'B' || ch2 == 'J' ){
			*dstp = d;
			return s;
		}
		if( !IS_JIS7(ch1,ch2) )
			return 0;

		*d++ = 0x80 | ch1;
		*d++ = 0x80 | ch2;
	}
	return 0;
}

unsigned char*
TO_EUC(jis,euc,ctype)
	unsigned char *jis,*euc;
	char *ctype;
{	register unsigned char *s,c,jis_stat;
	register to1B,to2B;
	register int in_sjis = 0;
	unsigned char *d;
	static int nje;
	int n8bits;

	nje++;
	n8bits = 0;
	s = jis;
	d = euc;
	jis_stat = 0;
	to2B = TO_2BCODE;
	to1B = TO_1BCODE;
	in_sjis = IS_SJIS_STR(jis);

	while( c = *s++ ){
		if( c == to2B && jis_stat == 0 && recover_JIS ){
			if(*s == 'B' || *s == '@'){
				unsigned char *ts;
				if( ts = recoverJIS(s+1,&d) ){
					s = ts;
					continue;
				}
			}
		}
		if( c == ESC ){
			if(*s == to2B){
				if((s[1] == 'B') || (s[1] == '@')){
					jis_stat = 0x80; s += 2;
					continue;
				}
				jis_stat = 0;
			}else
			if(*s == to1B){
				jis_stat = 0;
				if((s[1]=='B') || (s[1]=='J') || (s[1]=='H')){
					s += 2;
					continue;
				}
			}else
			if(*s == ',') /* MULE */ {
				jis_stat = 0;
			}
		}
		if( c & 0x80 )
			n8bits++;

		if( IS_SJIS(c,*s,in_sjis) ){
			SJIS_TO_EUC1(c,*s,d);
			d += 2;
			s++;
		}else
		if( jis_stat ){
			if( c <= 0x20 || 0x7F <= c ){
				*d++ = c;
				if( c == '\n' )
					jis_stat = 0;
			}else{
				if( IS_JIS7(c,*s)){
					*d++ = jis_stat | c;
					*d++ = jis_stat | *s;
				}
				s++;
			}
		}else{
			if( n8bits == 0 && (c == SI || c == SO) ){
			}else{
				*d++ = c;
			}
		}
	}
	*d = 0;
	return euc;
}

#define non94(ch) ((ch) <= 0x20 || (ch) == 0x7F)
static is_EUC_JP(euc)
	char *euc;
{	char *cp;
	int ch1,ch2;

	for( cp = euc; ch1 = *cp & 0xFF; cp++ ){
		if( ch1 & 0x80 ){
			ch2 = cp[1] & 0xFF;
			if( (ch2 & 0x80) == 0 ){
				/*sv1log("NOT_EUC1[%x][%x]\n",ch1,ch2);*/
				return 0;
			}
			if( non94(ch1&0x7F) || non94(ch2&0x7F) ){
				/*sv1log("NOT_EUC2[%x][%x]\n",ch1,ch2);*/
				return 0;
			}
			cp++;
		}
	}
	return 1;
}

TO_SJIS(any,sjis,ctype)
	char *any,*sjis;
	char *ctype;
{	char *euc;

	euc = malloc(strlen(any)+1);
	TO_EUC(any,euc);
	if( is_EUC_JP(euc) )
		EUC_TO_SJIS(euc,sjis);
	else	strcpy(sjis,any);
	free(euc);
}

TO_JIS(any,jis,ctype)
	char *any;
	unsigned char *jis;
	char *ctype;
{	char *euc;

	euc = malloc(strlen(any)+1);
	TO_EUC(any,euc);
/*
	if( is_EUC_JP(euc) )
		EUC_TO_JIS(euc,jis,TO_KANJI,TO_ASCII);
	else	strcpy(jis,any);
*/
	is_EUC_JP(euc);
	EUC_TO_JIS(euc,jis,TO_KANJI,TO_ASCII);

	free(euc);
}
