/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	strings.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940821	extracted from DeleGate/src/misc.c
///////////////////////////////////////////////////////////////////////*/
#include <ctype.h>
#include <string.h>
extern char *strstr();
extern char *malloc();

isdigits(str)
	char *str;
{	char *sp,ch;

	if( *str == 0 )
		return 0;

	for( sp = str; ch = *sp; sp++ )
		if( !isdigit(ch) )
			return 0;
	return 1;
}
int streq(a,b)
	char *a,*b;
{
	if( a == b )
		return 1;
	if( a == 0 || b == 0 )
		return 0;
	return strcmp(a,b) == 0;
}
int strcaseeq(a,b)
	char *a,*b;
{
	return strcasecmp(a,b) == 0;
}

char *
strcasestr(s1,s2)
	char *s1,*s2;
{	char *p1;
	int len;

	if( *s2 == 0 )
		return s1;

	len = strlen(s2);
	for( p1 = s1; *p1; p1 ++ )
		if( toupper(*p1) == toupper(*s2) )
		if( strncasecmp(p1,s2,len)==0 ) 
			return p1;
	return 0;
}

int rexpmatch(rexp,str)
	char *rexp,*str;
{	char rbuf[128];
	int topx,tailx;
	char *mp;

	if( strcmp(rexp,str) == 0 )
		return 1;

	strcpy(rbuf,rexp);
	if( rbuf[0] == '*' ){
		strcpy(rbuf,rbuf+1);
		topx = 1;

if( rbuf[0] == 0 )
	return 1;

	}else	topx = 0;
	if( rbuf[strlen(rbuf)-1] == '*' ){
		rbuf[strlen(rbuf)-1] = 0;
		tailx = 1;
	}else	tailx = 0;
	if( mp = strstr(str,rbuf) ){
		if( !topx && mp != str )
			return 0;
		if( !tailx && strcmp(mp,rbuf) != 0 )
			return 0;
		return 1;
	}
	return 0;
}

int vtos(av,abuf)
	char *av[];
	char *abuf;
{	int ac;
	char *ap,*a1;

	ap = abuf;
	for(ac = 0; a1 = av[ac]; ac++){
		if( ac == 0 )
			strcpy(ap,a1);
		else{
			ap[0] = ',';
			strcpy(ap+1,a1);
		}
		ap += strlen(ap);
	}
	*ap = 0;
	return ac;
}
int stoV(abuf,mac,av,sep)
	char *abuf;
	char *av[],sep;
{	char *ap,*np;
	int ac;

	ac = 0;
	for( ap = abuf; *ap; ap = np+1 ){
		if( np = strchr(ap,sep) )
			*np = 0;
		av[ac++] = ap;
		if( np == 0 )
			break;
	}
	av[ac] = 0;
	return ac;
}
char **dupv(sv,length)
	char **sv;
{	int na,ai;
	char **dv;
	int len,lx;

	for( na = 0; sv[na]; na++)
		;
	dv = (char**)malloc(sizeof(char*)*(na+1));

	for( ai = 0; ai < na; ai++ ){
		if( length )
			len = length;
		else	len = strlen(sv[ai]) + 1;
		dv[ai] = malloc(len);
		for( lx = 0; lx < len; lx++ ) dv[ai][lx] = sv[ai][lx];
	}
	dv[ai] = 0;
	return dv;
}
char *getv(av,name)
	char *av[];
	char *name;
{	char *val,*rval;
	int ai;
	int nlen;

	if( av == 0 || name == 0 )
		return 0;

	nlen = strlen(name);
	rval = 0;
	for(ai = 0; val = av[ai]; ai++)
		if( strncmp(name,val,nlen) == 0 )
		if( val[nlen] == '=' )
			rval = val+nlen+1;
	return rval;
}
scanv(av,name,func,arg1)
	char *av[];
	char *name;
	int (*func)();
	char *arg1;
{	int ai;
	int nlen;
	char *val;
	int nhit;

	nhit = 0;
	nlen = strlen(name);
	for( ai = 0; val = av[ai]; ai++ ){
		if( strncmp(name,val,nlen) == 0 )
		if( val[nlen] == '=' ){
			(*func)(arg1,val+nlen+1);
			nhit++;
		}
	}
	return nhit;
}

char *Sprintf(s,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n)
	char *s;
	char *fmt,*a,*b,*c,*d,*e,*f,*g,*h,*i,*j,*k,*l,*m,*n;
{
	if( fmt[0]=='%' && fmt[1]=='s' && fmt[2]==0 ){
		while( *s = *a++ ){ s++; }
		return s;
	}else{
		sprintf(s,fmt,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
		return s+strlen(s);
	}
}
char *stralloc(str)
	char *str;
{
	return strcpy(malloc(strlen(str)+1),str);
}
char *Strdup(dst,src)
	char **dst,*src;
{
	if( *dst == src )
		return *dst;
	if( *dst != (char*)0 )
		free(*dst);
	return *dst = stralloc(src);
}
char *strncpy0(d,s,len)
	char *d,*s;
{
	strncpy(d,s,len);
	d[len] = 0;
	return d;
}
char *strtail(s)
	char *s;
{
	if( s[0] ){
		while( s[1] )
			s++;
	}
	return s;
}
strtailchr(str)
	char *str;
{
	if( *str == 0 )
		return 0;
	else	return str[strlen(str)-1];
}

char *awordscan(str,word)
	char *str,*word;
{	char *sp,*wp,ch;

	wp = word;
	for(sp = str; ch = *sp; sp++){
		if( !isalpha(ch) )
			break;
		*wp++ = ch;
	}
	*wp = 0;
	return sp;
}
char *intscan(str,valp)
	char *str;
	int *valp;
{	char *sp,ch,*vp,valb[256];

	vp = valb;
	for( sp = str; ch = *sp; sp++ ){
		if( !isdigit(ch) )
			break;
		*vp++ = ch;
	}
	*vp = 0;
	if( vp == valb )
		return 0;

	*valp = atoi(valb);
	return sp;
}
char *wordscan(s,d)
	char *s,*d;
{	int ch;

	for(; ch = *s; s++){
		if( ch!=' ' && ch!='\t' && ch!='\r' && ch!='\n' && ch!='\f' )
			break;
	}
	for(; ch = *s; s++){
		if( ch==' ' || ch=='\t' || ch=='\r' || ch=='\n' || ch=='\f' )
			break;
		*d++ = ch;
	} 
	*d = 0;
	return s;
}
char *linescan(s,d,size)
	char *s,*d;
{	int cc,ch;

	for(; ch = *s; s++){
		if( ch!=' ' && ch!='\t' && ch!='\r' && ch!='\n' && ch!='\f' )
			break;
	}
	for(cc = 0; (cc < size) && (ch = *s); cc++,s++){
		if( ch=='\n' || ch=='\r' && (s[1]=='\n' || s[1]==0) )
			break;
		*d++ = ch;
	} 
	*d = 0;
	return s;
}
scanwords(sp,wc,words)
	char *sp;
	char *words[];
{	int ch,wi;

	for( wi = 0; wi < wc; wi++ ){
		for(; ch = *sp; sp++ )
			if( !isspace(ch) )
				break;
		words[wi] = sp;

		for(; ch = *sp; sp++ ){
			if( isspace(ch) ){
				*sp++ = 0;
				break;
			}
		}
	}
}

scan_List(list,sep,allocm,func,a1,a2,a3)
	char *list;
	int (*func)();
	char *a1,*a2,*a3;
{	char *lp,*np;
	int rcode;
	int lev;

	if( list == 0 || *list == 0 )
		return 0;

	if( allocm != 2 )
		list = stralloc(list);
	for( lp = list; *lp; lp = np ){
		lev = 0;
		for( np = lp; *np; np++ ){
			if( *np == '{' ) lev++; else
			if( *np == '}' ) lev--; else
			if( lev == 0 && *np == sep ){
				*np++ = 0;
				break;
			}
		}
		if( rcode = (*func)(lp,a1,a2,a3) )
			return rcode;

		if( np == 0 )
			break;
	}
	if( allocm != 1 )
		free(list);
	return 0;
}
scan_ListL(list,sep,allocm,func,a1,a2,a3)
	char *list;
	int (*func)();
	char *a1,*a2,*a3;
{	int len,rcode;

	if( *list == '{' ){
		len = strlen(list);
		if( list[len-1] == '}' ){
			list[len-1] = 0;
			rcode = scan_List(list+1,sep,allocm,func,a1,a2,a3);
			list[len-1] = '}';
			return rcode;
		}
	}
	return scan_List(list,sep,allocm,func,a1,a2,a3);
}
static list1(l1,ac,av,mac)
	char *l1;
	int *ac;
	char *av[];
{
	if( mac <= *ac )
		return -1;

	strcpy(av[*ac],l1);
	*ac += 1;
	return 0;
}
scan_ListList(list,sep,a1,a2,a3)
	char *list;
	char *a1,*a2,*a3;
{	char *av[4];
	int ac;

	av[0] = a1;
	av[1] = a2;
	av[2] = a3;
	ac = 0;
	scan_List(list,sep,0,list1,&ac,av,3);
	return ac;
}
scan_commaList(list,allocm,func,a1,a2,a3)
	char *list;
	int (*func)();
	char *a1,*a2,*a3;
{
	return scan_List(list,',',allocm,func,a1,a2,a3);
}
scan_commaListL(list,allocm,func,a1,a2,a3)
	char *list;
	int (*func)();
	char *a1,*a2,*a3;
{
	return scan_ListL(list,',',allocm,func,a1,a2,a3);
}
strsubs(str,pat,subs)
	char *str,*pat,*subs;
{	char *dp,sav[1024],tmp[1024];

	while( dp = strstr(str,pat) ){
		strcpy(sav,str);
		strcpy(tmp,dp+strlen(pat));
		sprintf(dp,"%s%s",subs,tmp);
		if( strcmp(str,sav) == 0 )
			break;
	}
}
onoff_flags(flags,delta,on)
	char *flags,*delta;
{	char map[256];
	char *fp;
	int mi;

	for( mi = 1; mi < 256; mi++ )
		map[mi] = 0;

	for( fp = flags; *fp; fp++ )
		map[*fp] = on;
	for( fp = delta; *fp; fp++ )
		map[*fp] = on;

	fp = flags;
	for( mi = 1; mi < 256; mi++ )
		if( map[mi] )
			*fp++ = mi;
	*fp = 0;
}
