/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	codeconv.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951029	created
///////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include <ctype.h>

static int Enabled;
static char Charcode[128];
extern int PLAIN_TO_HTML_PRE;
extern int recover_JIS;

codeconv_set(enable,xcharcode,plain2html)
	char *xcharcode;
{
	if( enable != -1 )
		Enabled = enable;
	if( xcharcode != NULL )
		strcpy(Charcode,xcharcode);
	if( plain2html != -1 )
		PLAIN_TO_HTML_PRE = plain2html;
}
codeconv_get(ctype,xcharset,plain2html)
	char *ctype;
	char **xcharset;
	int *plain2html;
{
	if( xcharset != NULL ){
		*xcharset = 0;
		if( Enabled ){
		    switch( toupper(Charcode[0]) ){
			case 'J': *xcharset = "ISO-2022-JP"; break;
			case 'E': *xcharset = "X-EUC-JP"; break;
			case 'S': *xcharset = "X-SJIS"; break;
		    }
		}
	}
	if( plain2html != NULL )
		*plain2html = PLAIN_TO_HTML_PRE;
	return Enabled;
}
codeconv_line(src,dst,ctype,recv)
	char *src,*dst,*ctype;
{
	if( Enabled ){
		recover_JIS = recv;
		switch( toupper(Charcode[0]) ){
			case 'J': return TO_JIS(src,dst,ctype);
			case 'E': return TO_EUC(src,dst,ctype);
			case 'S': return TO_SJIS(src,dst,ctype);
		}
	}
	strcpy(dst,src);
}
