/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	file.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951029	extracted from DelaGate
///////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include <fcntl.h>
extern FILE *tmpfile();

setCloseOnExit(fd)
{
	fcntl(fd,F_SETFD,1);
}

FILE *TMPFILE(what)
	char *what;
{	FILE *fp;

	fp = tmpfile();

	if( fp != NULL ){
		setCloseOnExit(fileno(fp));
		syslog_DEBUG(">>>>TMPFILE(%s)>>>>%x[%d]\n",what,fp,fileno(fp));
	}else{
		fprintf(stderr,"%s: cannot create tmpfile.\n",what);
		syslog_ERROR(">>>>TMPFILE(%s)>>>> cannot create.\n",what);
		exit(0);
	}
	return fp;
}

FILE *NULLFP(){
	static FILE *NULLFP;
	FILE *tmp;

	if( NULLFP == NULL ){
		tmp = TMPFILE("NULLFP");
		/*close(fileno(NULLFP)); should hold to avoid reuse */
		NULLFP = fdopen(fileno(tmp),"r");
	}
	return NULLFP;
}

copyfile1(sfp,dfp)
	FILE *sfp,*dfp;
{	int buff[1024];
	int totalc,rcc;

	totalc = 0;
	for(;;){
		rcc = fread(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( fwrite(buff,1,rcc,dfp) == 0 )
			break;
	}
	fflush(dfp);
	return totalc;
}

