/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	html.c (HTML entity encoder/decoder)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941002	extracted from http.c
///////////////////////////////////////////////////////////////////////*/
#include <string.h>

int DECODE_HTML_ENTITIES = 1;
int ENCODE_HTML_ENTITIES = 0;
int PLAIN_TO_HTML_PRE = 0;

static hconv1(conv)
	char *conv;
{
	if( streq(conv,"enent") ) ENCODE_HTML_ENTITIES = 1; else
	if( streq(conv,"deent") ) DECODE_HTML_ENTITIES = 1; else
	if( streq(conv,"pre")   ) PLAIN_TO_HTML_PRE    = 1; else
	syslog_ERROR("Error: unknown HTML conversion spec: %s\n",conv);
	return 0;
}
scan_HTMLCONV(clist)
	char *clist;
{
	ENCODE_HTML_ENTITIES = 0;
	DECODE_HTML_ENTITIES = 0;
	scan_commaList(clist,0,hconv1);
	syslog_DEBUG("HTMLCONV=%s -> en=%d,de=%d\n",
		clist,ENCODE_HTML_ENTITIES,DECODE_HTML_ENTITIES);
}

static struct {
	char	*ee;
	char	 de;
} entities[] = {
	{"&lt;",	'<'},
	{"&gt;",	'>'},
	{"&amp;",	'&'},
	{"&quot;",	'"'},
	0
};

/*
 *  Decode mul-encoded entities in ISO-2022 multibyte charset text.
 */
decode_entities(src,dst)
	char *src,*dst;
{
	if( DECODE_HTML_ENTITIES == 0 ){
		strcpy(dst,src);
		return;
	}
	decodeEntities(src,dst);
}
decodeEntities(src,dst)
	char *src,*dst;
{	char *sp,*dp;
	int ei,len;
	char *ee;
	int in2byte;

	in2byte = 0;
	dp = dst;
	for( sp = src; *sp; )
	{
		if( *sp == 033 ){
			switch( sp[1] ){
				case '$': in2byte  = 1; break;
				case '(': in2byte  = 0; break;
			}
		}else
		if( in2byte && *sp == '&' ){
			for( ei = 0; ee = entities[ei].ee; ei++ ){
				len = strlen(ee);
				if( strncmp(sp,ee,len) == 0 ){
					*dp++ = entities[ei].de;
					sp += len;
					goto Next;
				}
			}
		}
		*dp++ = *sp++;
	Next:;
	}
	*dp = 0;
}

encode_entities(src,dst)
	char *src,*dst;
{
	if( ENCODE_HTML_ENTITIES == 0 ){
		strcpy(dst,src);
		return;
	}
	encodeEntities(src,dst);
}
encodeEntities(src,dst)
	char *src,*dst;
{	int in2byte;
	char *sp,*dp;
	char de;
	int ei,len;

	in2byte = 0;
	dp = dst;
	for( sp = src; *sp; sp++ ){
		if( *sp == 033 ){
			switch( sp[1] ){
				case '$': in2byte  = 1; break;
				case '(': in2byte  = 0; break;
			}
		}else
		if( !in2byte ){
			for( ei = 0; de = entities[ei].de; ei++ ){
				if( *sp == de ){
					strcpy(dp,entities[ei].ee);
					dp += strlen(dp);
					goto Next;
				}
			}
		}
		*dp++ = *sp;
	Next:;
	}
	*dp = 0;
}
