/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	mime.c (MIME header encoder/decoder)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941008	extracted from nntp.c
	950312	encode/decode parts in a multipart message
///////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
extern char *strstr();
extern char *strcasestr();
extern char *strtail();
#define strdup(str)	strcpy( malloc(strlen(str)+1), str )

extern char *malloc();
extern char *realloc();
extern char *findFieldValue();
extern FILE *TMPFILE();

#define LINESIZE	1024
#define FN_CTE		"Content-Transfer-Encoding"
#define FN_CTE_C	"Content-Transfer-Encoding:"

static int  maybe_MIME;
static int maybe_NONASCII;
static int got_EOR;

#define DEBUG	syslog_DEBUG

#define O_HEAD	1
#define O_DELIM	2
#define O_BODY	4
#define O_EOR	8
#define O_ALL	0xF
#define DELIM_ALSO(filter)	(filter & O_DELIM)
#define BODY_ALSO(filter)	(filter & O_BODY)
#define EOR_ALSO(filter)	(filter & O_EOR)

#define C_TEXT		"text/"
#define C_TEXT_PLAIN	"text/plain"
static is_text_plain(ctype)
	char *ctype;
{
	return strncasecmp(ctype,C_TEXT_PLAIN,strlen(C_TEXT_PLAIN))==0;
}
static is_text(ctype)
	char *ctype;
{
	return strncasecmp(ctype,C_TEXT,strlen(C_TEXT))==0;
}

static char *textorso[] = {
	"application/x-unknown-content-type",
	0
};
static tobe_charconv(ctype)
	char *ctype;
{	int ci;
	char *ctype1;

	if( is_text(ctype) )
		return 1;
	for( ci = 0; ctype1 = textorso[ci]; ci++ )
		if( strncasecmp(ctype,ctype1,strlen(ctype1)) == 0 )
			return 1;
	return 0;
}
static is8bitCharset(charset)
	char *charset;
{
	if( strcaseeq(charset,"x-sjis") )
		return 1;
	if( strncasecmp(charset,"x-euc-",6) == 0 )
		return 1;
	return 0;
}
static charset_namelen(name)
	char *name;
{	char *np;
	int nc;

	for( np = name; nc = *np; np++ )
		if( nc != '-' && !isalnum(nc) )
			break;
	return np - name;
}

static char *fgetsTee(buf,size,fp,cache)
	char *buf;
	FILE *fp,*cache;
{	char *rcode;

	if( rcode = fgets(buf,size,fp) ){
		if( cache != NULL )
		if( buf[0] != '.' || buf[1] != '\r' && buf[1] != '\n' )
			fputs(buf,cache);
	}
	return rcode;
}
#define MP_EOF	-1	/* real EOF */
#define MP_EOR	-2	/* .<CR><LF> */
#define MP_EOP	-3	/* --boundary-- */
#define MP_EOC	-4	/* --boundary */

static scan_boundary(hp,boundary)
	char *hp,*boundary;
{	char *bp;

	if( bp = strcasestr(hp,"boundary=") ){
		bp += strlen("boundary=");
		if( *bp == '"' )
			sscanf(bp+1,"%[^\"\r\n]",boundary);
		else	sscanf(bp,"%[^; \t\r\n]",boundary);
	}
}
static push_boundary(boundaries,boundary)
	char *boundaries[],*boundary;
{	int bi;
	for( bi = 0; boundaries[bi]; bi++);
	boundaries[bi] = strdup(boundary);
	boundaries[bi+1] = 0;
	return bi;
}
static top_boundary(boundaries)
	char *boundaries[];
{	int bi;
	for( bi = 0; boundaries[bi]; bi++);
	return bi;
}
static pop_boundary(boundaries,line)
	char *boundaries[],*line;
{	int blen,bi;
	char *b1,*tp;

	if( line[0] == '-' && line[1] == '-' ){
		for( bi = 0; b1 = boundaries[bi]; bi++ ){
			blen = strlen(b1);
			if( strncmp(line+2,b1,blen) == 0 ){
				tp = &line[2+blen];
				if( tp[0]=='-' && tp[1]=='-' ){
					free(b1);
					boundaries[bi] = 0;
					return MP_EOP;
				}else	return MP_EOC;
			}
		}
	}
	if( line[0] == '.' && (line[1] == '\r' || line[1] == '\n') )
		return MP_EOR;
	return 0;
}

replace_charset(head,charset)
	char *head,*charset;
{	char *ctp,*csp,*cst;
	char tmp[0x10000];

	if( (ctp = findFieldValue(head,"Content-Type")) == NULL )
		return 0;

	if( csp = strcasestr(ctp,"charset=") ){
		csp += strlen("charset=");
		if(*csp == '"')
			csp++;
		if( strncasecmp(csp,charset,strlen(charset)) == 0 )
			return 0;
		cst = csp + charset_namelen(csp);
		strcpy(tmp,cst);
		strcpy(csp,charset);
		strcat(csp,tmp);
	}else{
		if( (cst = strpbrk(ctp,";\r\n")) == 0 )
			return 0;
		strcpy(tmp,cst);
		sprintf(cst,"; charset=%s",charset);
		strcat(cst,tmp);
	}
	return 1;
}
replaceFieldValue(head,field,value)
	char *head,*field,*value;
{	char *esp;
	char tmp[0x10000];
	char ch,*np;

	if( (esp = findFieldValue(head,field)) == NULL )
		return 0;
	if( strncasecmp(esp,value,strlen(value)) == 0 )
		return 0;
	for( np = esp; ch = *np; np++ )
		if( ch == '\r' || ch == '\n' )
			break;
	strcpy(tmp,np);
	strcpy(esp,value);
	strcat(esp,tmp);
	return 1;
}
replaceContentType(head,type)
	char *head,*type;
{	char *ctp,*cst;
	char tmp[0x10000],*tp;

	ctp = findFieldValue(head,"Content-Type");
	if( ctp == NULL ){
		tp = strdup(head);
		sprintf(head,"Content-Type: %s\r\n%s",type,tp);
		free(tp);
		return 0;
	}
	if( (cst = strpbrk(ctp,";\r\n")) == 0 )
		return -1;
	strcpy(tmp,cst);
	strcpy(ctp,type);
	strcat(ctp,tmp);
	return 1;
}

static char *guess_charset(text)
	char *text;
{	char *sw;

	if( sw = strstr(text,"\033$") )
		if( sw[2] == '@' || sw[2] == 'B' )
			return "ISO-2022-JP";
	if( sw = strstr(text,"\033(") )
		if( sw[2] == 'J' )
			return "ISO-2022-JP";
	return 0;
}
extern int str_fromqp();
#define BASE64CH(ch) (isalpha(ch) || isdigit(ch) || ch=='+' || ch=='/' || ch=='=' )

str_from64_safe(src,leng,dst,size)
	char *src,*dst;
{	char ch;
	int sx,dx,Bx,cx,isB64,ls,ld,lb;

	Bx = -1;
	dx = 0;

	for( sx = 0; sx < leng; sx = cx ){
		isB64 = 1;
		for( cx = sx; cx < leng; ){
			ch = src[cx++];
			if( ch=='\n' || ch==0 )
				break;
			if( !BASE64CH(ch) && ch!='\r' && ch!=0 )
				isB64 = 0;
		}
		if( isB64 ){
			if( Bx == -1 )
				Bx = sx;
		}else{
			if( Bx != -1 ){
				lb = sx - Bx;
/* str_from64() before mimehead1.2.4 writes NULL at end of source string ... */
ch = src[Bx+lb];
				str_from64(&src[Bx],lb,&dst[dx],size);
src[Bx+lb] = ch;
				Bx = -1;
				ld = strlen(&dst[dx]);
				dx += ld;
				size -= ld;
			}
			ls = cx - sx;
			strncpy(&dst[dx],&src[sx],ls);
			dx += ls;
			dst[dx] = 0;
			size -= ls;
		}
	}
	if( Bx != -1 )
		str_from64(&src[Bx],leng-Bx,&dst[dx],size);
}

static decodeLine(line,dline,encoding)
	char *line,*dline,*encoding;
{	int (*conv)();
	int len;

	if( strcasecmp(encoding,"quoted-printable") == 0 )
		conv = str_fromqp;
	else
	if( strcasecmp(encoding,"base64") == 0 )
		conv = str_from64_safe;
	else	return 0;

	len = strlen(line);
	(*conv)(line,len,dline,len);

	{ /* bug of str_fromqp ? */
	unsigned char *sp;
	for( sp = (unsigned char*)dline; *sp; sp++ )
		if( *sp == 0xFF )
			strcpy((char*)sp,(char*)sp+1);
	}

	return 1;
}

static readHeader(fs,buf,size,cache,filter,ctype,boundaries,encoding,enHTML)
	FILE *fs,*cache;
	char *buf;
	char *ctype,*boundaries[],*encoding;
{	char *hp,*hs,hc;
	int rem,len;
	char cur_field[256];
	int conv_field;
	char boundary[256];
	char tmp[LINESIZE];

	maybe_MIME = 0;
	maybe_NONASCII = 0;
	got_EOR = 0;
	strcpy(ctype,C_TEXT_PLAIN);
	boundary[0] = 0;
	encoding[0] = 0;

	hp = buf;
	buf[0] = 0;
	conv_field = 0;
	cur_field[0] = 0;

	for( rem = size; LINESIZE < rem; ){
		if( fgetsTee(hp,LINESIZE,fs,cache) == NULL )
			break;
		if( got_EOR = streq(hp,".\r\n") || streq(hp,".\n") )
			break;
		if( streq(hp,"\r\n") || streq(hp,"\n") ){
			if( !DELIM_ALSO(filter) )
				*hp = 0;
			break;
		}

		if( hp[0] == ' ' || hp[0] == '\t' ){
			if( strcasecmp(cur_field,"Content-Type") == 0 ){
				scan_boundary(hp,boundary);
			}
		}else{
			sscanf(hp,"%[-a-zA-Z]",cur_field);
			conv_field = strncasecmp(hp,"Subject:",8) == 0
				  || strncasecmp(hp,"From:",5) == 0;

			if( strncasecmp(hp,"Content-Type:",13) == 0 ){
				wordscan(hp+13,ctype);
				scan_boundary(hp,boundary);
			}else
			if( strncasecmp(hp,FN_CTE_C,26)==0 )
				wordscan(hp+26,encoding);
		}

		if( enHTML && conv_field ){
			encode_entities(hp,tmp);
			strcpy(hp,tmp);
		}

		for(hs = buf; hc = *hs; hs++ ){
			if( hc == '=' && hs[1] == '?' )
				maybe_MIME = 1;
			if( hc == 033 || hc & 0x80 )
				maybe_NONASCII = 1;
			if( hc == '$' && (hs[1] == 'B' || hs[1] == '@') )
				maybe_NONASCII = 1;
			if( hc == '(' && (hs[1] == 'B' || hs[1] == 'J') )
				maybe_NONASCII = 1;
		}
		len = strlen(hp);
		rem -= len;
		hp += len;
	}
	if( boundary[0] )
		push_boundary(boundaries,boundary);
	return rem;
}

static
scan_multipart(boundaries,func,src,dst,cache,filter,arg)
	char *boundaries[];
	int (*func)();
	FILE *src,*dst,*cache;
	char *arg;
{	char line[LINESIZE];
	int rcode;
	int top;

	/* preamble */
	while( fgetsTee(line,sizeof(line),src,cache) != NULL ){
		fputs(line,dst);
		if( rcode = pop_boundary(boundaries,line) )
			break;
	}

	top = top_boundary(boundaries);

	for(;;){
		if( feof(src) )
			rcode = MP_EOF;
		if( rcode==MP_EOF || rcode==MP_EOR || rcode==MP_EOP )
			break;
		if( top != top_boundary(boundaries) )
			break;
		rcode = (*func)(boundaries,src,dst,cache,filter,arg);
	}

	/* epilogue */
	if( rcode == MP_EOP ){
		for(;;){
			if( fgetsTee(line,sizeof(line),src,cache) == NULL ){
				rcode = MP_EOF;
				break;
			}
			fputs(line,dst);
			if( streq(line,".\r\n") || streq(line,".\n") ){
				rcode = MP_EOR;
				break;
			}
		}
	}
	return rcode;
}

static char *readPart(src,cache,boundaries,line,codep,lengp)
	FILE *src,*cache;
	char *boundaries[];
	char *line;
	int *codep,*lengp;
{	int rcode;
	int leng,len1,reqsize;
	char *buff;
	int bsize;

	rcode = 0;
	leng = 0;
	bsize = 0x2000;

	buff = malloc(bsize);
	buff[0] = 0;

	for(;;){
		line[0] = 0;
		if( fgetsTee(line,LINESIZE,src,cache) == NULL ){
			DEBUG("GotEOF: length=%d\n",leng);
			rcode = MP_EOF;
			break;
		}
		len1 = strlen(line);
		reqsize = leng + len1 + 1;
		if( bsize <= reqsize ){
			while( bsize <= reqsize )
				bsize = bsize * 2;
			buff = realloc(buff,bsize);
		}
		if( rcode = pop_boundary(boundaries,line) )
			break;

		strcpy(buff+leng,line);
		leng += len1;
	}
	*lengp = leng;
	*codep = rcode;
	return buff;
}

#define JBSIZE(leng)	(leng*2+128)

static encodeBODYpart(fc,ts,boundaries,encoding,charsetp)
	FILE *fc,*ts;
	char *boundaries[],*encoding,**charsetp;
{	unsigned char line[LINESIZE];
	char endline[LINESIZE];
	char *charset = 0;
	int rcode,leng;
	char *tmpa,*tmpb,*tmpc;

	tmpa = readPart(fc,NULL,boundaries,endline,&rcode,&leng);
	tmpb = malloc(JBSIZE(leng));
	tmpc = malloc(JBSIZE(leng));

DEBUG("BODY-LENG1:%d+%d\n",strlen(tmpa),strlen(endline));

	if( !decodeLine(tmpa,tmpb,encoding) )
		strcpy(tmpb,tmpa);

	TO_JIS(tmpb,tmpc);
	if( charset == 0 ){
		if( charset = guess_charset(tmpc) )
			DEBUG("encodeBDOY[charset=%s]\n",charset);
	}
/*
	if( strcmp(tmpb,tmpc) == 0 )
		fputs(tmpa,ts);
	else	fputs(tmpc,ts);
*/
	if( tmpc[0] ){
		fputs(tmpc,ts);
		if( *strtail(tmpc) != '\n' )
			fputs("\r\n",ts);
	}

	fputs(endline,ts);
	free(tmpa);
	free(tmpb);
	free(tmpc);

	*charsetp = charset;
	return rcode;
}
static relayBODYpart(src,dst,boundaries)
	FILE *src,*dst;
	char *boundaries;
{	char *tmpa;
	char endline[LINESIZE];
	int rcode,leng;

	tmpa = readPart(src,NULL,boundaries,endline,&rcode,&leng);
	fputs(tmpa,dst);
	free(tmpa);
	fputs(endline,dst);
	return rcode;
}
static decodeBODYpart(fs,tc,cache,ctype,boundaries,encoding,decodeto,do_enHTML,endline)
	FILE *fs,*tc,*cache;
	char *ctype,*boundaries[];
	char *encoding,*decodeto;
	char *endline;
{	int rcode,leng;
	char *tmpa,*tmpb;
	int do_conv,plain2html;
	char *xcharset;

	do_conv = codeconv_get(ctype,&xcharset,&plain2html);

	*endline = 0;
	tmpa = readPart(fs,cache,boundaries,endline,&rcode,&leng);
	if( leng == 0 )
		goto EXIT;

	if( plain2html ){
		tmpa = realloc(tmpa,leng*10);
		tmpb = malloc(leng*10);
	}else	tmpb = malloc(JBSIZE(leng));

	if( encoding != NULL && decodeto != NULL ){
		DEBUG("decode: %s -> %s\n",encoding,decodeto);
		if( decodeLine(tmpa,tmpb,encoding) )
			strcpy(tmpa,tmpb);
	}
	if( do_conv ){
		codeconv_line(tmpa,tmpb,ctype,0);
		strcpy(tmpa,tmpb);
	}
	if( do_enHTML ){
		encode_entities(tmpa,tmpb);
		strcpy(tmpa,tmpb);
	}
	free(tmpb);
EXIT:
	fputs(tmpa,tc);
	if( tmpa[0] != 0 && tmpa[strlen(tmpa)-1] != '\n' ){
		DEBUG("supply missing <CR><LF> at the end of BODY part\n");
		fputs("\r\n",tc);
	}
	free(tmpa);
	return rcode;
}

decodeBODY(fs,tc,filter,encoding,decodeto,do_enHTML)
	FILE *fs,*tc;
	char *encoding,*decodeto;
{	char *boundaries[32];
	char *ctype = "text/plain";
	char endline[LINESIZE];
	int rcode;

	boundaries[0] = 0;
	rcode = decodeBODYpart(fs,tc,NULL,ctype,
			boundaries,encoding,decodeto,do_enHTML,endline);
	if( EOR_ALSO(filter) || endline[0] != '.' )
		fputs(endline,tc);
	return rcode;
}

typedef FILE *(*FFUNC)();
static FFUNC HEAD_filter;

FFUNC set_HEAD_filter(filter)
	FFUNC filter;
{	FFUNC ofilter;

	ofilter = HEAD_filter;
	HEAD_filter = filter;
	return ofilter;
}

extern FILE *NULLFP();

static
decodeMIMEpart(boundaries,fs,tc,cache,filter,enHTML)
	char *boundaries[];
	FILE *fs,*tc,*cache;
{	char head[2][0x10000];
	char ctype[128],encoding[128],*decodeto;
	int hi,nhi;
	int do_enHTML;
	int putPRE;
	int rcode;
	char endline[LINESIZE];
	int do_conv,plain2html;
	char *xcharset;
	FILE *ntc;

	do_conv = codeconv_get(NULL,&xcharset,&plain2html);
	readHeader(fs,head[0],sizeof(head[0]),
		cache,filter,ctype,boundaries,encoding,enHTML);

	if( got_EOR )
		rcode = MP_EOR;
	else	rcode = 0;

	if( HEAD_filter){
		ntc = (*HEAD_filter)(head[0],tc,cache);
		if( ntc != NULL )
			tc = ntc;
		else{
			if( EOR_ALSO(filter) )
				fputs(".\r\n",tc);
			tc = NULLFP();
		}
	}

	hi = 0;
	if( maybe_MIME ){
		nhi = (hi + 1 ) % 2;
		MIME_strHeaderDecode(head[hi],head[nhi],sizeof(head[1]));
		hi = nhi;
		maybe_NONASCII = 1;
	}

	if( !plain2html )
	if( maybe_NONASCII && do_conv ){
		nhi = (hi + 1 ) % 2;
		codeconv_line(head[hi],head[nhi],C_TEXT_PLAIN,1);
		hi = nhi;
	}

	if( strncasecmp(ctype,"multipart/",10) == 0 ){
		FILE *mtc;
		int ofilter;

		fputs(head[hi],tc);
		if( rcode == MP_EOR )
			return rcode;

		ofilter = filter;
		if( BODY_ALSO(filter) ){
			mtc = tc;
		}else{
			mtc = NULLFP();
			filter = O_ALL;
		}
		rcode = scan_multipart(boundaries,decodeMIMEpart,fs,mtc,cache,filter,enHTML);
		filter = ofilter;
		return rcode;
	}

	putPRE = 0;
	if( is_text(ctype) ){ 
		do_enHTML = 0;
		if( is_text_plain(ctype) ){
			do_enHTML = enHTML;
			if( plain2html ){
				putPRE = 1;
				/*do_enHTML = 1;*/
				replaceContentType(head[hi],"text/html");
			}
		}

		if( xcharset && is8bitCharset(xcharset)
		 || strcaseeq(encoding,"quoted-printable")
	 	 || strcaseeq(encoding,"base64") ){
			decodeto = "8bit";
			replaceFieldValue(head[hi],FN_CTE,decodeto);
			DEBUG("decodeMIME[encoding=%s]\n",decodeto);
		}else	decodeto = NULL;
		if( xcharset ){
			replace_charset(head[hi],xcharset);
			DEBUG("decodeMIME[charset=%s]\n",xcharset);
		}
	}else{
		do_enHTML = 0;
		decodeto = NULL;
	}
	fputs(head[hi],tc);

	if( rcode == MP_EOR )
		return MP_EOR;

	if( BODY_ALSO(filter) ){
		if( putPRE ) fprintf(tc,"<PRE>\n");
		rcode = decodeBODYpart(fs,tc,cache,ctype,boundaries,
				encoding,decodeto,do_enHTML,endline);
		if( putPRE ) fprintf(tc,"</PRE>\n");
	}else{
		if( fseek(fs,0,0) == -1 ){
			DEBUG("skip body from stream input.\n");
			RFC821_skipbody(fs,NULL,endline,sizeof(endline));
		}
	}

	if( EOR_ALSO(filter) || endline[0] != '.'  )
		fputs(endline,tc);

	return rcode;
	/*
	 * Result (real) Encoding and Charcode should be set in the header
	 * after this decoding...
	 */
}

static
encodeMIMEpart(boundaries,fc,ts,cache,filter)
	char *boundaries[];
	FILE *fc,*ts,*cache;
{	char head[2][0x10000];
	int hi,nhi;
	FILE *tmp;
	char *charset,ctype[128],encoding[128];
	int rcode;

	readHeader(fc,head[0],sizeof(head[0]),
		cache,filter,ctype,boundaries,encoding,0);
	if( got_EOR )
		rcode = MP_EOR;
	else	rcode = 0;

	hi = 0;
	if( maybe_NONASCII ){
		TO_JIS(head[0],head[1]);
		if( strcmp(head[0],head[1]) != 0 ){
			DEBUG("POST: code converted.\n");
		}
		MIME_strHeaderEncode(head[1],head[0],sizeof(head[0]));
	}

	if( strncasecmp(ctype,"multipart/",10) == 0 ){
		fputs(head[hi],ts);
		return scan_multipart(boundaries,encodeMIMEpart,fc,ts,cache,filter);
	}

	if( rcode == MP_EOR ){
		fputs(head[hi],ts);
	}else
	if( is_text(ctype) || tobe_charconv(ctype) ){
		tmp = TMPFILE("encodeMIMEpart");
		charset = 0;
		rcode = encodeBODYpart(fc,tmp,boundaries,encoding,&charset);
		if( charset ){
			replace_charset(head[hi],charset);
			replaceFieldValue(head[hi],FN_CTE,"7bit");
		}
		fflush(tmp);
		fseek(tmp,0,0);
		fputs(head[hi],ts);
		copyfile1(tmp,ts);
		fclose(tmp);
	}else{
		fputs(head[hi],ts);
		rcode = relayBODYpart(fc,ts,boundaries);
	}
	return rcode;
}

thruRESP(fs,tc)
	FILE *fs,*tc;
{	char line[LINESIZE];

	while( fgets(line,sizeof(line),fs) != NULL ){
		fputs(line,tc);
		if( streq(line,".\r\n") || streq(line,".\n") )
			break;
	}
}
static delWhites(str)
	char *str;
{	char ch,*sp,*dp;

	dp = str;
	for( sp = str; ch = *sp; sp++ ){
		if( ch != '\t' && ch != '\r' && ch != '\n' )
			*dp++ = ch;
	}
	*dp = 0;
}
decodeTERM1(line,xline)
	char *line,*xline;
{	char term[0x4000],xterm[0x4000],*xp,*tp,dc,*np,*ts;
	int convert;
	int do_conv,plain2html;
	char *xcharset;

	do_conv = codeconv_get(NULL,&xcharset,&plain2html);

	xp = xline;
	for( tp = line; *tp; tp = np ){
		if( np = strpbrk(tp,"\t\r\n") ){
			dc = *np;
			*np = 0;
		}
		if( *tp ){
			convert = 0;
			for( ts = tp; *ts; ts++ ){
				if( ts[0] == '=' && ts[1] == '?'
				 || ts[0] == 033 || ts[0] & 0x80 ){
					convert = 1;
					break;
				}
			}
			if( convert ){
			MIME_strHeaderDecode(tp,term,sizeof(term));
				/* remove possible white spaces
				 * insterted by MIME decoder (-_-; */
				delWhites(term);
if( plain2html )
	strcpy(xp,term);
else{
				codeconv_line(term,xterm,C_TEXT_PLAIN,0);
				strcpy(xp,xterm);
}
			}else	strcpy(xp,tp);
			xp += strlen(xp);
		}
		if( np ){
			*np++ = dc;
			*xp++ = dc;
		}else	break;
	}
	*xp = 0;
}

decodeTERM(fs,tc,enHTML)
	FILE *fs,*tc;
{	char line[0x8000],xline[0x8000];

	while( fgets(line,sizeof(line),fs) != NULL){
		if( streq(line,".\r\n") || streq(line,".\n") ){
			fputs(line,tc);
			break;
		}
		decodeTERM1(line,xline);
		fputs(xline,tc);
		DEBUG("[%d]\n%s\n%s",strcmp(line,xline),line,xline);
	}
}

withMIME()
{	char src[32],dst[32];

	strcpy(src,"\377");
	MIME_strHeaderEncode(src,dst,sizeof(dst));
	if( strcmp(src,dst) != 0 )
		return 1;
	else	return 0;
}

encodeMIME(fc,ts)
	FILE *fc,*ts;
{	char *boundaries[32];

	boundaries[0] = 0;
	encodeMIMEpart(boundaries,fc,ts,NULL,O_ALL);
}

decodeMIME(fs,tc,cache,filter,codeconv,enHTML)
	FILE *fs,*tc,*cache;
{	char *boundaries[32];
	int ssc;

	ssc = codeconv_set(codeconv,NULL,-1);
	boundaries[0] = 0;
	decodeMIMEpart(boundaries,fs,tc,cache,filter,enHTML);
	codeconv_set(ssc,NULL,-1);
}

deMime(ac,av)
	char *av[];
{
	decodeMIME(stdin,stdout,NULL,O_ALL,1,0);
}
enMime(ac,av)
	char *av[];
{
	encodeMIME(stdin,stdout);
}

