/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1992 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of ETL not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type: program/C; charset=US-ASCII
Program:      mmhencode.c (MIME header encoder/decoder interface)
Author:       Yutaka Sato <ysato@etl.go.jp>
ToDo:
 + selective encode of structured fields (-s option?)
///////////////////////////////////////////////////////////////////////*/

#include <stdio.h>

extern int MIME_SPACE_ENCODING;
int MIME_DECODE_BODY = 1;
static FILE *infile = stdin;

static scan_args(ac,av)
	char *av[];
{	int ai;
	char *arg;

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( strcmp(arg,"-s") == 0 )
			MIME_SPACE_ENCODING = 0;
		else
		if( strcmp(arg,"-h") == 0 )
			MIME_DECODE_BODY = 0;
		else
		if( strncmp(arg,"CHARCODE=",9) == 0 ){
			codeconv_set(1,arg+9,-1);
		}else
		if( strncmp(arg,"HTMLCONV=",9) == 0 ){
			scan_HTMLCONV(arg+9);
		}else
		{
			infile = fopen(arg,"r");
			if( infile == NULL ){
				fprintf(stderr,"%s: cannot open %s\n",
					av[0],arg);
				exit(-1);
			}
		}
	}
}


#ifdef LOCAL2MIME
main(ac,av)
	char *av[];
{	FILE *fp;
	char line[1024];

	ac = scan_args(ac,av);
	if( getenv("TMPTEST") ){
		printf("COMMENT: TMPTEST\n");
		fp = (FILE*)MIME_tmpHeaderEncode(infile);
		while(fgets(line,sizeof(line),fp) != NULL)
			fputs(line,stdout);
		fclose(fp);
	}else	MIME_headerEncode(infile,stdout);
	exit(0);
}
#endif

#ifdef MIME2LOCAL
main(ac,av)
	char *av[];
{
	ac = scan_args(ac,av);
	MIME_headerDecode(infile,stdout);
	exit(0);
}
#endif

#ifdef ENMIME
main(ac,av)
	char *av[];
{
	ac = scan_args(ac,av);
        encodeMIME(infile,stdout,NULL,1);
	exit(0);
}
#endif

#ifdef DEMIME
main(ac,av)
	char *av[];
{	int do_conv;

	ac = scan_args(ac,av);
	do_conv = codeconv_get(NULL,NULL,NULL);
        decodeMIME(infile,stdout,NULL,0xFF,do_conv,0);
	exit(0);
}
#endif

