/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	rfc822.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941008	extracted from nntp.c
	950312	encode/decode parts in a multipart message
	951029	extracted from mime.c of DeleGate
///////////////////////////////////////////////////////////////////////*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
extern char *strstr();

char *findFieldValue(head,field)
	char *head,*field;
{	char *nsp,*csp;
	int flen;

	flen = strlen(field);
	for( csp = head; *csp; csp = nsp ){
		if( strncasecmp(csp,field,flen) == 0 ){
			csp += flen;
			while( *csp == ' ' ) csp++;
			if( *csp == ':' ) csp++;
			while( *csp == ' ' ) csp++;
			return csp;
		}
		if( nsp = strchr(csp,'\n') )
			nsp++;
		else	return 0;
	}
	return 0;
}

char *getFieldValue(head,field,value)
	char *head,*field,*value;
{	char ch,*vp,*bp;

	if( vp = findFieldValue(head,field) ){
		bp = value;
		while( ch = *vp++ ){
			if( ch == '\r' )
				continue;

			if( ch == '\n' ){
				if( *vp == ' ' || *vp == '\t' ){
					/*vp++;*/
					continue;
				}
				break;
			}
			if( ch == '\t' )
				ch = ' ';
			*bp++ = ch;
		}
		*bp = 0;
		return value;
	}
	value[0] = 0;
	return NULL;
}

char *fgetsHeaderField(hfp,name,value,size)
	FILE *hfp;
	char *name,*value;
{	char line[256],*vp;
	int len;
	int found;
	int off;

	len = strlen(name);
	found = 0;
	value[0] = 0;

	off = ftell(hfp);
	for(;;){
		if( fgets(line,sizeof(line),hfp) == NULL )
			break;
		if( line[0] == '\r' || line[1] == '\n' )
			break;
		if( strncasecmp(line,name,len) == 0 ){
			vp = line + len;
			while( *vp == ' ' )
				vp++;
			if( *vp == ':' ){
				found++;
				vp++;
				linescan(vp,value,size);
			}
		}
	}
	fseek(hfp,off,0);

	if( found )
		return value;
	else	return NULL;
}

static strsubstr(n1,n2)
	char *n1,*n2;
{
	return strstr(n1,n2) == n1 || strstr(n2,n1) == n2;
}
int (*NNTP_nodematch)() = strsubstr;

findXref(afp,matchfunc,host,xref,size)
	FILE *afp;
	int (*matchfunc)();
	char *host,*xref;
{	char line[1024],node[256];
	char *dp,dc,*ep;
	int off,found;

	if( matchfunc == NULL )
		matchfunc = strsubstr;

	xref[0] = 0;
	off = ftell(afp);
	found = 0;

	while( fgets(line,sizeof(line),afp) != NULL ){
		if( line[0] == '\r' || line[0] == '\n' )
			break;
		if( line[0] == '.' )
		if( line[1] == '\r' || line[1] == '\n' )
			break;

		if( isspace(line[0]) )
			continue;

		if( (dp = strchr(line,':')) == 0 )
			continue;
		*dp++ = 0;
		if( strcasecmp(line,"Xref") != 0 )
			continue;

		while( *dp && isspace(*dp) )
			dp++;

		wordscan(dp,node);
		if( !(*matchfunc)(host,node) ) 
			continue;

		if( ep = strpbrk(dp,"\r\n") )
			*ep = 0; /* must treat folded line ... */

		strncpy(xref,dp,size-1);
		xref[size-1] = 0;
		found = 1;
		break;
	}
	fseek(afp,off,0);
	return found;
}

selectXref(host,xref1,xref2)
	char *host,*xref1,*xref2;
{	char *sp,*dp,*xp,name[512],host1[512],ch;
	int getit;
	int len;

	len = strlen(host);
	sp = xref1;
	dp = xref2;
	getit = 0;

	while( ch = *sp ){
		if( ch != ' ' && ch != '\t' ){
			getit = 0;
			if( strncasecmp(sp,"Xref",4) == 0 )
			if( xp = strchr(sp,':') ){
				wordscan(xp+1,host1);

				if( strncasecmp(host1,host,len) == 0 )
				if( host1[len] == 0 || host1[len] == '.' )
					getit = 1;
			}
		}
		while( ch = *sp ){
			sp++;
			if( getit )
				*dp++ = ch;
			if( ch == '\n' )
				break;
		}
	}
	*dp = 0;
}

static char *separator(field)
	char *field;
{
	if( strcasecmp(field,"To")==0 || strcasecmp(field,"Cc")==0 )
		return ", ";
	if( strcasecmp(field,"Received") == 0 )
		return "; ";
	return " ";
}

RFC821_skipheader(afp,out,field)
	FILE *afp,*out;
	char *field;
{	char line[1024],*lp,*dp,selected[1024];
	int flen,rcode,nputs;

	rcode = EOF;
	selected[0] = 0;
	nputs = 0;
	flen = strlen(field);

	while( fgets(line,sizeof(line),afp) != NULL ){
		if( line[0] == '\r' || line[0] == '\n' ){
			rcode = 0;
			break;
		}
		if( line[0] == '.' )
		if( line[1] == '\r' || line[1] == '\n' )
			break;

		if( out != NULL ){
		    if( field == NULL )
			fputs(line,out);
		    else{
			if( selected[0] == 0 ){
				if( line[flen] != ':' )
					continue;
				if( strncasecmp(line,field,flen) != 0 )
					continue;
				for( lp = line+flen+1; *lp; lp++ )
					if( !isspace(*lp) )
						break;
				if( nputs++ != 0 )
					fputs(separator(field),out);
				if( dp = strpbrk(line,"\r\n\f") )
					*dp = 0;
				fputs(lp,out);
			}else{
				if( isspace(line[0]) ){
					fputs(" ",out);
					fputs(line+1,out);
				}else	selected[0] = 0;
			}
		    }
		}
	}
	return rcode;
}
RFC821_skipbody(afp,out,line,size)
	FILE *afp,*out;
	char *line;
{	char linebuf[1024];
	int rcc;

	if( line == NULL ){
		line = linebuf;
		size = sizeof(linebuf);
	}
	*line = 0;
	rcc = 0;
	while( fgets(line,size,afp) != NULL ){
		if( line[0] == '.' )
		if( line[1] == '\r' || line[1] == '\n' )
			break;

		rcc += strlen(line);
		if( out != NULL )
			fputs(line,out);
	}
	return rcc;
}
