/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : Article select routine
 *  File        : article.c
 *  Version     : 1.19
 *  First Edit  : 1991-07/14
 *  Last  Edit  : 1995-07/17
 *  Author      : MSR24  
 *
 */

#include	"compat.h"
#include	"nntplib.h"
#include	"mnews.h"
#include	"kanjilib.h"
#include	"termlib.h"
#include	"group.h"
#include	"article.h"
#include	"pager.h"
#include	"mark.h"
#include	"ucbmail.h"
#include	"mailsend.h"
#include	"newspost.h"

static void	news_redraw_article();	/* ̺		*/
static int	news_read();		/* 			*/
static int	news_extract();		/* 			*/
static void	news_mark();		/* ޡ¸(̴ؿ)	*/
static void	news_unmark();		/* ޡ		*/
static void	news_xref_mark();	/* ޡ¸(̴ؿ)	*/
static int	news_refer();		/* ե󥹵		*/
static int	news_find();		/* Message-ID 		*/
static int	news_prev_article();	/* εֹ		*/
static int	news_next_article();	/* εֹ		*/
static int	news_prev_unread_article();
					/* ̤ɵֹ		*/
static int	news_next_unread_article();
					/* ̤ɵֹ		*/
static int	news_prev_unread_article2();
					/* ̤ɵֹ(ޡ)	*/
static int	news_next_unread_article2();
					/* ̤ɵֹ(ޡ)	*/
static int	news_get_list();	/* ̤ɵꥹȼ		*/
static int	news_get_field();	/* إå		*/
static int	pipe_article();		/* ѥ׼¹(̴ؿ)	*/
static int	sort_subject();		/* Subject 		*/
static int	sort_reference();	/* Reference 		*/
static int	sort_date();		/* Date 			*/
static int	make_thread();		/* åɺ			*/
static int	compare_date();		/* 			*/

static int	(*sort_article_func[])() = {
  sort_subject,
#ifdef	REF_SORT
  sort_reference,
  sort_date,
#endif	/* REF_SORT */
  NULL,
};
static int	news_article_number;		/* 򤵤Ƥ뵭	*/

ARTICLE_LIST	*article_list = NULL;		/* ꥹ		*/
ARTICLE_LIST	*sort_list = NULL;		/* ꥹ()	*/
#ifdef	REF_SORT
MESSAGE_LIST	*message_list = NULL;		/* åꥹ	*/
#endif	/* REF_SORT */

static int	top_position;			/* ɽϰ		*/
static char	base_message[SMALL_BUFF];	/* ١å ID	*/
static char	refer_message[SMALL_BUFF];	/* ȥå ID	*/

/*
 * إץå
 */

static char	*news_article_jmessage[] = {
  "˥塼⡼\n\n",
  "\tk ޤ ^P     ε˰ưޤ\n",
  "\tj ޤ ^N     ε˰ưޤ\n",
  "\tSPACE, i ޤ .\n",
  "\t                򻲾Ȥޤ\n",
  "\tv ޤ V      ƤΥإåȤȤ˵򻲾Ȥޤ\n",
#ifdef	MIME
  "\t                ('V'  MIME ǥб)\n",
#endif	/* MIME */
  "\tp               ̤ɵ򻲾Ȥޤ\n",
  "\tn               ̤ɵ򻲾Ȥޤ\n",
  "\tP               ε򻲾Ȥޤ\n",
  "\tN               ε򻲾Ȥޤ\n",
  "\t^U ޤ ^B    ̤ε˰ưޤ\n",
  "\t^D, ^F ޤ ^V\n",
  "\t                ̤ε˰ưޤ\n",
  "\t<               Ƭε˰ưޤ\n",
  "\t>               Ǹε˰ưޤ\n",
  "\tD               ɥޡ̤ɵذưޤ\n",
  "\td               ɥޡ̤ɵذưޤ\n",
  "\tU               ɥޡεذưޤ\n",
  "\tu               ɥޡεذưޤ\n",
  "\ts               ɥ֤ޤ\n",
  "\t                (ե̾ϤƲե뤬¸ߤ\n",
  "\t                 Y:ڥ N: O:񤭤ǲ)\n",
  "\tc               ɥޡޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
#ifndef	SMALL
  "\t*               Message-ID ε򻲾Ȥޤ\n",
#endif	/* !SMALL */
  "\t^               ե󥹤򻲾Ȥޤ\n",
  "\tTAB             ε˥פޤ\n",
  "\t                (ֹϤƲ)\n",
#ifdef	MAILSEND
  "\tm               ˥᡼Фޤ\n",
  "\tr               ֿޤ\n",
  "\tR               Ѥֿޤ\n",
#endif	/* MAILSEND */
#ifdef	NEWSPOST
  "\ta               ˵ݥȤޤ\n",
  "\tf               ˥եޤ\n",
  "\tF               Ѥƥեޤ\n",
  "\tC               򥭥󥻥뤷ޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
#endif	/* NEWSPOST */
  "\tM               ޥޡ/εذưޤ\n",
#ifndef	SMALL
  "\tK               Ʊ쥵֥Ȥεɥޡޤ\n",
#endif	/* !SMALL */
#ifdef  MH
  "\tO                MH ե˥֤ޤ\n",
  "\t                (MH ե̾ϤƲ)\n",
#endif  /* MH */
#ifndef	SMALL
  "\tG               ˥塼롼פηϤɽޤ\n",
#endif	/* !SMALL */
  "\tl               /󥻥뤵줿ɽ⡼ɤؤޤ\n",
  "\tt               åɥ⡼ɤؤޤ\n",
#ifdef	REF_SORT
  "\tT               ˡؤޤ\n",
#endif	/* REF_SORT */
  "\to, q ޤ RETURN\n",
  "\t                ⡼ɤȴޤ\n",
  NULL,
};

static char	*news_article_message[] = {
#ifndef	SMALL
  "NEWS ARTICLE SELECT MODE\n\n",
  "\tk or ^P      previous article.\n",
  "\tj or ^N      next article.\n",
  "\tSPACE, i or .\n",
  "\t             read article.\n",
  "\tv or V       read article with all header.\n",
#ifdef	MIME
  "\t             ('V' decode MIME header.)\n",
#endif	/* MIME */
  "\tp            read previous unread article.\n",
  "\tn            read next unread article.\n",
  "\tP            read previous article.\n",
  "\tN            read next article.\n",
  "\t^U or ^B     previous page article.\n",
  "\t^D, ^F or ^V next page article.\n",
  "\t<            top article.\n",
  "\t>            last article.\n",
  "\tD            mark as read and move to previous unread.\n",
  "\td            mark as read and move to next unread.\n",
  "\tU            clear read mark and move to previous.\n",
  "\tu            clear read mark and move to next.\n",
  "\ts            save article.\n",
  "\t             (Please input file name.If file exists, please select\n",
  "\t              Y:Append N:Abort or O:Overwrite.)\n",
  "\tc            mark all article as read.\n",
  "\t             (Please make sure Y/N.)\n",
#ifndef	SMALL
  "\t*            read Message-ID article.\n",
#endif	/* !SMALL */
  "\t^            read referece article.\n",
  "\tTAB          jump to specified article.\n",
  "\t             (Please input article number.)\n",
#ifdef	MAILSEND
  "\tm            mail.\n",
  "\tr            reply.\n",
  "\tR            reply with original article.\n",
#endif	/* MAILSEND */
#ifdef	NEWSPOST
  "\ta            post new article.\n",
  "\tf            follow.\n",
  "\tF            follow with original article.\n",
  "\tC            cancel article.\n",
  "\t             (Please make sure Y/N.)\n",
#endif	/* NEWSPOST */
  "\tM            toggle multi mark and move to next.\n",
  "\tK            mark same subject as read.\n",
#ifdef  MH
  "\tO            save article in MH folder.\n",
  "\t             (Please Input MH folder name.)\n",
#endif  /* MH */
  "\tG            print news group description.\n",
  "\tl            toggle print read/cancel article.\n",
  "\tt            toggle thread mode.\n",
#ifdef	REF_SORT
  "\tT            change sort rule.\n",
#endif	/* REF_SORT */
  "\to, q or return\n",
  "\t             exit from article select mode.\n",
#endif	/* !SMALL */
  NULL,
};

/*
 * ̺
 */

static void	news_redraw_article(current_article)
     int	current_article;
{
  register int	i;
  char		buff[SMALL_BUFF];
  char		jname[SMALL_BUFF];

  i = top_position;
  top_position = get_top_position(top_position, current_article,
				  news_article_number, news_thread_mode,
				  buff);
  if (i == top_position) {
    return;
  }
  print_title();
#ifdef	COLOR
  if (wide_mode) {
    term_attrib(color_code[HEADER_COLOR]);
  } else {
    term_attrib(color_code[CATEGORY_COLOR]);
  }
#else	/* !COLOR */
  if (wide_mode) {
    term_attrib(REVERSE_ATTRIB);
  }
#endif	/* !COLOR */
  strcpy(jname, select_name);
#ifdef	JNAMES
  get_jname(NEWS_JN_DOMAIN, jname, 40);
#endif	/* JNAMES */
  print_full_line(japanese ?
		  "˥塼롼:%-40.40s       :%s" :
		  "News group:%-40.40s         Position:%s",
		  jname, buff);
  print_articles(top_position, news_article_number, news_get_field,
		 "CANCEL/LOST");
  print_mode_line(japanese ?
		  "?:إ j,^N: k,^P: SPACE,i,.: l:ɽ⡼ o,q: Q:λ" :
		  "?:Help j,^N:next k,^P:previous SPACE,i,.:read l:print mode o,q:return Q:exit");
}

/*
 * 
 */

int	news_select_article()
{
  register int	current_group;		/* Υ롼ֹ		*/
  int		current_article;	/* εֹ		*/
  char		buff1[BUFF_SIZE];
  int		loop;
  int		status;
  int		key;
  register int	i, j;

  current_group = -1;
  jump_name[0] = '\0';
  top_position = -1;
  for (i = 0; i < group_number; i++) {
    if (!strcmp(select_name, news_group[i].group_name)) {
      current_group = i;
      break;
    }
  }
  if (current_group < 0) {
    print_fatal("Unexpected group selected.");
    return(0);
  }
  if (news_group[current_group].max_article == 0) {
    return(0);
  }
  if (nntp_group(select_name)) {
    return(0);
  }
  if ((news_group[current_group].max_article
       - news_group[current_group].min_article) > CONFIRM_NUMBER) {
    confirm_article(news_group[current_group].group_name,
		    &news_group[current_group].min_article,
		    &news_group[current_group].max_article);
  }
  status = news_get_list(current_group);
  if (news_group[current_group].min_article > 1) {
    news_add_mark(current_group, 1,
		  news_group[current_group].min_article - 1);
  }
  if (status < 0) {
    return(0);
  } else if (!status) {
    /*
     * ǽ̤ɵޤǥȤʤ
     */

    current_article = news_next_unread_article2(current_group, 0);
  } else {
    current_article = 0;
  }

  loop = 1;
  status = 0;
  while (loop) {
    news_redraw_article(current_article);
    term_locate(11, head_lines + current_article - top_position);
    key = get_key(NEWS_MODE_MASK | GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
    switch (key) {
    case 0x0c:		/* ^L 		*/
      term_init(2);
      top_position = -1;
      break;
    case 0x0e:		/* ^N ư	*/
    case 'j':
      current_article = news_next_article(current_article);
      break;
    case 0x10:		/* ^P ư	*/
    case 'k':
      current_article = news_prev_article(current_article);
      break;
    case '\015':	/* RETURN		*/
    case '\n':
    case 'o':
    case 'q':
      loop = 0;
      break;
    case 0x02:		/* ^B 			*/
    case 0x15:		/* ^U ڡ		*/
      if ((current_article -= (term_lines - mode_lines)) < 0) {
	current_article = 0;
      }
      break;
    case 0x04:		/* ^D			*/
    case 0x06:		/* ^F			*/
    case 0x16:		/* ^V ڡ		*/
      if ((current_article += (term_lines - mode_lines))
	  >= news_article_number) {
	if (news_article_number > 0) {
	  current_article = news_article_number - 1;
	} else {
	  current_article = 0;
	}
      }
      break;
    case '<':		/* ǽε		*/
      current_article = 0;
      break;
    case '>':		/* Ǹε		*/
      if (news_article_number > 0) {
	current_article = news_article_number - 1;
      } else {
	current_article = 0;
      }
      break;
    case '?':		/* إ		*/
      help(news_article_jmessage, news_article_message,
	   GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
      top_position = -1;
      break;
    case 'Q':		/* λ			*/
      loop = 0;
      status = 1;
      break;
    case 'l':		/* ɵѥå/	*/
    case 't':		/* åɥ	*/
    case 'T':		/* åɥ롼	*/
      if (!change_sort_rule(current_group, &news_article_number,
			    &current_article,
			    &news_article_mask, &news_thread_mode,
			    news_get_list, key)) {
	top_position = -1;
      }
      break;
#ifdef	NEWSPOST
    case 'a':		/* ˥塼		*/
      if ((news_group[current_group].group_mode == (short)POST_ENABLE) ||
	  (news_group[current_group].group_mode == (short)POST_MODERATED)) {
	news_post(select_name);
	top_position = -1;
      }
      break;
#endif	/* NEWSPOST */
    default:

      /*
       * 鲼νϸܤޤ
       */

      last_key = key;
      while (last_key) {
	key = last_key;
	last_key = 0;
	switch (key) {
	case 'p':		/* ̤ɵ	*/
	case 'P':		/* ε		*/
	  j = current_article;
	  if (news_article_number > 0) {
	    status = current_article;
	    current_article = news_prev_article(current_article);
	    if (key == 'p') {
	      current_article = news_prev_unread_article2(current_group,
							  current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      status = (status == current_article);
	    }
	  } else {
	    status = 1;
	  }
	  if (status) {
	    i = current_group;
	    while (1) {
	      if (--i < 0) {
		i = current_group;
		break;
	      }
	      if ((group_list[i].unread_article > 0) &&
		  ((!group_list[i].unsubscribe) || (!group_mask))) {
		break;
	      }
	    }
	    if (current_group != i) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"̤(%d)롼(%s)򻲾Ȥޤ?",
				"Read previous unread(%d) group(%s)?",
				group_list[i].unread_article,
				news_group[i].group_name)) {
	      case 1:
		news_count_unread(current_group);
		loop = 0;
		last_key = 0;
		if ((group_list[i].unread_article > 0) &&
		    (news_group[i].group_mode <= (short)POST_UNKNOWN)) {
		  strcpy(jump_name, news_group[i].group_name);
		  return(1);
		}
		break;
	      case 2:
		news_count_unread(current_group);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
	case 'n':		/* ̤ɵ	*/
	case 'N':		/* ε		*/
	  j = current_article;
	  if (news_article_number > 0) {
	    current_article = news_next_article(current_article);
	    if (key == 'n') {
	      current_article = news_next_unread_article2(current_group,
							  current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      status = (current_article == j);
	    }
	  } else {
	    status = 1;
	  }
	  if (status) {
	    i = current_group;
	    while (1) {
	      if (gnus_mode) {
		i = gnus_next_group(i);
		if (i < 0) {
		  i = current_group;
		  break;
		}
	      } else {
		if (++i >= group_number) {
		  i = current_group;
		  break;
		}
	      }
	      if ((group_list[i].unread_article > 0) &&
		  ((!group_list[i].unsubscribe) || (!group_mask))) {
		break;
	      }
	    }
	    if (current_group != i) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"̤(%d)롼(%s)򻲾Ȥޤ?",
				"Read next unread(%d) group(%s)?",
				group_list[i].unread_article,
				news_group[i].group_name)) {
	      case 1:
		news_count_unread(current_group);
		loop = 0;
		last_key = 0;
		if ((group_list[i].unread_article > 0) &&
		    (news_group[i].group_mode <= (short)POST_UNKNOWN)) {
		  strcpy(jump_name, news_group[i].group_name);
		  return(1);
		}
		break;
	      case 2:
		news_count_unread(current_group);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
#ifndef	SMALL
	case 'G':		/* ɽ		*/
	  if (!nntp_description(news_group[current_group].group_name, buff1)) {
	    print_mode_line(buff1);
	  } else {
	    print_mode_line(japanese ? "ϤĤޤǤ" :
			    "Description not found.");
	  }
	  break;
#endif	/* !SMALL */
	default:
	  break;
	}
	if (news_article_number > 0) {
	  i = 1;
	  switch (key) {
	  case 'V':		/* 		*/
	    i = 3;
	    /* break  */
	  case 'v':
	    i--;
	    key = ' ';
	    /* break  */
	  case ' ':
	  case 'p':
	  case 'n':
	  case 'P':
	  case 'N':
	  case 'i':
	  case '.':
	    if (!news_read(article_list[current_article].real_number,
				   i)) {
	      if ((last_key == 'U') || (last_key == 'u')) {
		news_unmark(current_group, current_article);
		if (last_key == 'U') {
		  last_key = 'P';
		} else {
		  last_key = 'N';
		}
	      } else {
		news_mark(current_group, current_article, READ_MARK);
		if (last_key == 'D') {
		  last_key = 'p';
		} else if (last_key == 'd') {
		  last_key = 'n';
		}
	      }
	      switch (last_key) {
	      case 'D':
		last_key = 'p';
		break;
	      case 'd':
		last_key = 'n';
		break;
	      case 'U':
		break;
	      case 'u':
		last_key = 'P';
		break;
	      }
	      if (article_list[current_article].mark & CANCEL_MARK) {
		switch (key) {
		case 'p':
		case 'P':
		case 'n':
		case 'N':
		  last_key = key;
		  break;
		default:
		  last_key = 'n';
		}
	      }
	    }
	    if (pager_mode) {
	      switch (key) {
	      case 'p':
		current_article = news_prev_unread_article2(current_group,
							    current_article);
		break;
	      case 'n':
	      case ' ':
		current_article = news_next_unread_article2(current_group,
							    current_article);
		break;
	      case 'P':
		current_article = news_prev_article(current_article);
		break;
	      case 'N':
		current_article = news_next_article(current_article);
		break;
	      default:
		break;
	      }
	    }
	    if (last_key == ' ') {
	      last_key = 'n';
	    }
	    top_position = -1;
	    break;
	  case 'D':		/* ޡư	*/
	  case 'd':		/* ޡư	*/
	    news_mark(current_group, current_article, READ_MARK);
	    toggle_mark(top_position, current_article, 0);
	    if (key == 'D') {
	      current_article = news_prev_unread_article(current_article);
	    } else {
	      current_article = news_next_unread_article(current_article);
	    }
	    break;
	  case 'U':		/* ޡư	*/
	  case 'u':		/* ޡư	*/
	    news_unmark(current_group, current_article);
	    toggle_mark(top_position, current_article, 0);
	    if (key == 'U') {
	      current_article = news_prev_article(current_article);
	    } else {
	      current_article = news_next_article(current_article);
	    }
	    break;
	  case 'c':		/* ޡ		*/
	    if (yes_or_no(NORMAL_YN_MODE,
			  "ƥޡƤǤ?",
			  "Mark all articles.Are you sure?")) {
	      for (i = 0; i < news_article_number; i++) {
		article_list[i].mark |= READ_MARK;
	      }
	      news_fill_mark(current_group);
	    }
	    top_position = -1;
	    break;
	  case 's':		/* 		*/
	    if (!multi_save(current_article, news_extract)) {
	      multi_add_mark(news_article_number, current_group,
			     current_article, READ_MARK, news_mark);
	    }
	    top_position = -1;
	    break;
#ifdef	MH
	  case 'O':		/* եص */
	    if (!save_mh_folder(current_article, news_extract)) {
	      multi_add_mark(news_article_number, current_group,
			     current_article, READ_MARK, news_mark);
	    }
	    top_position = -1;
	    break;
#endif	/* MH */
#ifndef	SMALL
	  case '/':		/* 		*/
	    search_subjects(0, news_article_number, &current_article, 
			    news_get_field);
	    break;
	  case '\\':		/* 		*/
	    search_subjects(1, news_article_number, &current_article, 
			    news_get_field);
	    break;
	  case '|':		/* ѥ׼¹		*/
	    if (!multi_pipe(current_article, news_extract)) {
	      multi_add_mark(news_article_number, current_group,
			     current_article, READ_MARK, news_mark);
	    }
	    top_position = -1;
	    break;
	  case '*':
	    buff1[0] = '\0';
	    input_line(INPUT_SPCCUT_MASK, "Message-IDϤƲ:",
		       "Input Message-ID:", buff1);
	    news_find(buff1);
	    top_position = -1;
	    break;
#endif	/* !SMALL */
	  case '\t':		/* TAB 국إ	*/
	    buff1[0] = '\0';
	    input_line(INPUT_SPCCUT_MASK, "ֹϤƲ:",
		       "Input article number:", buff1);
	    if ((j = atoi(buff1)) > 0) {
	      for (i = 0; i < news_article_number; i++) {
		if (article_list[i].real_number == j) {
		  current_article = i;
		  break;
		}
	      }
	    }
	    top_position = -1;
	    break;
#ifdef	MAILSEND
	  case 'r':		/* ᡼ֿ		*/
	    create_temp_name(buff1, "NR");
	    if (!news_extract(article_list[current_article].real_number,
				 buff1)) {
	      mail_reply(buff1, 0, "");
	      funlink2(buff1);
	    }
	    top_position = -1;
	    break;
	  case 'R':		/* ᡼ֿ		*/
	    create_temp_name(buff1, "NR");
	    if (!multi_extract(current_article, buff1, news_extract)) {
	      if (!mail_reply(buff1, REPLY_QUOTE_MASK, "")) {
		multi_add_mark(news_article_number, current_group,
			       current_article, READ_MARK, news_mark);
	      }
	      funlink2(buff1);
	    }
	    top_position = -1;
	    break;
#endif	/* MAILSEND */
#ifdef	NEWSPOST
	  case 'f':		/* ˥塼ե	*/
	    if ((news_group[current_group].group_mode == (short)POST_ENABLE) ||
		(news_group[current_group].group_mode ==
		 (short)POST_MODERATED)) {
	      create_temp_name(buff1, "NF");
	      if (!news_extract(article_list[current_article].real_number,
				   buff1)) {
		news_follow(buff1, 0);
		funlink2(buff1);
	      }
	      top_position = -1;
	    }
	    break;
	  case 'F':		/* ˥塼ե	*/
	    if ((news_group[current_group].group_mode == (short)POST_ENABLE) ||
		(news_group[current_group].group_mode ==
		 (short)POST_MODERATED)) {
	      create_temp_name(buff1, "NF");
	      if (!multi_extract(current_article, buff1, news_extract)) {
		if (!news_follow(buff1, FOLLOW_QUOTE_MASK)) {
		  multi_add_mark(news_article_number, current_group,
				 current_article, READ_MARK, news_mark);
		}
		funlink2(buff1);
	      }
	      top_position = -1;
	    }
	    break;
	  case 'C':		/* 󥻥		*/
	    if ((news_group[current_group].group_mode == (short)POST_ENABLE) ||
		(news_group[current_group].group_mode ==
		 (short)POST_MODERATED)) {
	      if (!news_cancel(article_list[current_article].real_number)) {
		article_list[current_article].mark |= CANCEL_MARK;
	      }
	      top_position = -1;
	    }
	    break;
#endif	/* NEWSPOST */
	  case '^':		/* ե󥹵	*/
	    news_refer(article_list[current_article].real_number);
	    top_position = -1;
	    if (last_key != '^') {
	      last_key = 0;
	    }
	    break;
	  case 'M':		/* ޥޡ/	*/
	    multi_mark(top_position, current_article);
	    current_article = news_next_article(current_article);
	    break;
#ifndef	SMALL
	  case 'K':		/* ƱSubjectޡư*/
	    kill_subjects(current_group, current_article, news_article_number,
			  news_get_field, news_add_mark);
	    current_article = news_next_unread_article2(current_group,
							current_article);
	    top_position = -1;
	    break;
#endif	/* !SMALL */
	  default:
	    break;
	  }
	}
	switch (last_key) {
	case ' ':
	case 'p':
	case 'n':
	case 'P':
	case 'N':
	case 'v':
	case 'V':
	case 'r':
	case 'R':
	case 'f':
	case 'F':
	case '^':
	  break;
	default:
	  last_key = 0;
	}
      }
      break;
    }
  }
  news_count_unread(current_group);
  return(status);
}

/*
 * 
 */

static int	news_read(real_number, mode)
     int	real_number;
     int	mode;
{
  FILE		*fp;
  char		tmp_file1[PATH_BUFF];
  char		tmp_file2[PATH_BUFF];
  char		buff[BUFF_SIZE];
  static struct cpy_hdr	xref_fields[] = {
    {XREF_FIELD,	NULL,	sizeof(buff)},
  };
  int		status;

  create_temp_name(tmp_file1, "NC");
  create_temp_name(tmp_file2, "NV");
  status = news_extract(real_number, tmp_file1);
  if (status) {
    if (status < 0) {
      return(0);
    }
    return(1);
  }
  sprintf(buff, "%d", real_number);
  status = exec_pager(tmp_file1, tmp_file2, mode, buff);

  /*
   * ݥȻ̤ɽ
   * ν⸫ܤޤ
   */

  if (!status) {
    if (fp = fopen(tmp_file1, "r")) {
      xref_fields[0].field_buff = buff;
      copy_fields(fp, xref_fields, sizeof(xref_fields)/sizeof(struct cpy_hdr),
		  CF_CLR_MASK | CF_GET_MASK);
      fclose(fp);
      if (buff[0]) {
	news_xref_mark(buff);
      }
    }
  }
  funlink2(tmp_file1);
  return(status);
}

/*
 * 
 */

static int	news_extract(real_number, tmp_file)
     int	real_number;
     char	*tmp_file;
{
  FILE	*fp;
  int	status;

  if ((fp = fopen2(tmp_file, "a")) == (FILE*)NULL) {
    print_fatal("Can't open extract file.");
    return(1);
  }
  status = nntp_article(real_number, fp);
  fclose(fp);
  if (status) {
    funlink2(tmp_file);
    return(status);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  return(0);
}

/*
 * ޡɲ(̴ؿ)
 */

static void	news_mark(current_group, current_article, mark)
     int	current_group;
     int	current_article;
     int	mark;		/* ̤Ѥ I/F Τɬ	*/
{
  char			buff[BUFF_SIZE];
  static struct cpy_hdr	xref_fields[] = {
    {XREF_FIELD,	NULL,	sizeof(buff)},
  };

  if (cross_mark_mode) {
    xref_fields[0].field_buff = buff;
    if (!nntp_copy_fields(article_list[current_article].real_number,
			  xref_fields,
			  sizeof(xref_fields)/sizeof(struct cpy_hdr),
			  CF_CLR_MASK | CF_GET_MASK)) {
      news_xref_mark(buff);
    }
  }
  news_add_mark(current_group,
		article_list[current_article].real_number,
		article_list[current_article].real_number);
  article_list[current_article].mark |= READ_MARK;
}

/*
 * ޡ
 */

static void	news_unmark(current_group, current_article)
     int	current_group;
     int	current_article;
{
  article_list[current_article].mark &= ~READ_MARK;
  news_delete_mark(current_group,
		   article_list[current_article].real_number,
		   article_list[current_article].real_number);
}

/*
 * ޡɲ(̴ؿ)
 */

static void	news_xref_mark(ptr1)
     char	*ptr1;
{
  char		*ptr2;
  register int	i, j;

  /*
   * ޥ̾򥹥å
   */
  
  while ((*ptr1 != ' ') && (*ptr1 != '\t') && (*ptr1 != '\0')) {
    ptr1++;
  }
  while (*ptr1) {
    while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
      ptr1++;
    }
    ptr2 = ptr1;
    while (*ptr1) {
      if (*ptr1 == ':') {
	*ptr1++ = '\0';
	j = atoi(ptr1);
	while (isdigit(*ptr1)) {
	  ptr1++;
	}
	if (j > 0) {
	  for (i = 0; i < group_number; i++) {
	    if (!strcmp(news_group[i].group_name, ptr2)) {
	      news_add_mark(i, j, j);
	      news_count_unread(i);
	      break;
	    }
	  }
	}
	break;
      } else {
	ptr1++;
      }
    }
  }
}

/*
 * ե󥹵
 */

static int	news_refer(real_number)
     int	real_number;
{
  FILE			*fp;
  static char		buff1[SMALL_BUFF];
  static char		buff2[BUFF_SIZE];
  char			tmp_file1[PATH_BUFF];
  char			tmp_file2[PATH_BUFF];
  char			*ptr1, *ptr2;
  static struct cpy_hdr	refer_fields[] = {
    {MESSAGE_FIELD,	buff1,	sizeof(buff1)},
    {REFERENCE_FIELD,	buff2,	sizeof(buff2)},
  };
  int			status;

  if (nntp_copy_fields(real_number, refer_fields,
		       sizeof(refer_fields)/sizeof(struct cpy_hdr),
		       CF_CLR_MASK | CF_GET_MASK)) {
    return(1);
  }
  if (strcmp(buff1, base_message) || (!refer_message[0])) {
    strcpy(base_message, buff1);
    refer_message[0] = '\0';
  }

  ptr1 = buff2;
  if (refer_message[0]) {
    if (ptr2 = strindex(ptr1, refer_message)) {
      *ptr2 = '\0';	/* ˻Ȥ Reference ΤƤ */
      if (ptr1 == ptr2) {
	base_message[0] = '\0';
	return(1);
      }
    } else {
      base_message[0] = '\0';
      return(1);
    }
  }
  ptr2 = ptr1;

  /*
   *  Reference õ
   */

  while (*ptr1) {
    while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
      ptr1++;
    }
    if (*ptr1) {
      ptr2 = ptr1;
      while (*ptr1) {
	if (*ptr1++ == '>') {
	  break;
	}
      }
    }
  }
  ptr1 = refer_message;
  while (*ptr2) {
    if (*ptr2 == '>') {
      *ptr1++ = *ptr2++;
      break;
    }
    *ptr1++ = *ptr2++;
  }
  *ptr1 = '\0';

  if (!refer_message[0]) {
    return(1);
  }
  create_temp_name(tmp_file1, "NC");
  create_temp_name(tmp_file2, "NV");
  if ((fp = fopen2(tmp_file1, "w")) == (FILE*)NULL) {
    print_fatal("Can't open reference file.");
    return(1);
  }
  status = nntp_article2(refer_message, fp);
  fclose(fp);
  if (status) {
    funlink2(tmp_file1);
    return(status);
  }
  chmod(tmp_file1, S_IREAD | S_IWRITE);
  status = exec_pager(tmp_file1, tmp_file2, 2, refer_message);
  funlink2(tmp_file1);
  return(status);
}

#ifndef	SMALL
/*
 * Message-ID 
 */

static int	news_find(message_id)
     char	*message_id;
{
  FILE	*fp;
  char	tmp_file1[PATH_BUFF];
  char	tmp_file2[PATH_BUFF];
  int	status;

  create_temp_name(tmp_file1, "NC");
  create_temp_name(tmp_file2, "NV");
  if ((fp = fopen2(tmp_file1, "w")) == (FILE*)NULL) {
    print_fatal("Can't open reference file.");
    return(1);
  }
  status = nntp_article2(message_id, fp);
  fclose(fp);
  if (status) {
    funlink2(tmp_file1);
    return(status);
  }
  chmod(tmp_file1, S_IREAD | S_IWRITE);
  status = exec_pager(tmp_file1, tmp_file2, 2, message_id);
  funlink2(tmp_file1);
  return(status);
}
#endif	/* !SMALL */

/*
 * ̤ɵֹ
 */

static int	news_prev_unread_article(current_article)
     int	current_article;
{
  while (current_article > 0) {
    if (!(article_list[--current_article].mark & READ_MARK)) {
      break;
    }
  }
  return(current_article);
}

/*
 * ̤ɵֹ
 */

static int	news_next_unread_article(current_article)
     int	current_article;
{
  while (current_article < (news_article_number - 1)) {
    if (!(article_list[++current_article].mark & READ_MARK)) {
      break;
    }
  }
  return(current_article);
}

/*
 * εֹ
 */

static int	news_prev_article(current_article)
     int	current_article;
{
  if (--current_article < 0) {
    current_article = 0;
  }
  return(current_article);
}

/*
 * εֹ
 */

static int	news_next_article(current_article)
     int	current_article;
{
  if (++current_article >= news_article_number) {
    if (news_article_number > 0) {
      current_article = news_article_number - 1;
    } else {
      current_article = 0;
    }
  }
  return(current_article);
}

/*
 * ̤ɵֹ(󥻥뵭ϼưޡ)
 */

static int	news_prev_unread_article2(current_group, current_article)
     int	current_group;
     int	current_article;
{
  register int	current_article2, current_article3;
  int		current_article4;

  current_article2 = current_article;
  if (news_article_number > 0) {
    while (1) {
      if (article_list[current_article].mark & READ_MARK) {
	if (!current_article) {
	  break;
	}
	current_article = news_prev_unread_article(current_article);
      } else {
	if (article_list[current_article].mark & UNFETCH_MARK) {
	  news_get_field(current_article);
	}
	if (!(article_list[current_article].mark & CANCEL_MARK)) {
	  break;
	}
	article_list[current_article].mark |= READ_MARK;
      }
    }
    if (article_list[current_article].mark & READ_MARK) {
      current_article3 = current_article;
    } else {
      current_article3 = current_article + 1;
    }
    if (current_article3 <= current_article2) {
      if (news_thread_mode) {
	while (current_article3 <= current_article2) {
	  current_article4 = current_article3;
	  while (current_article3 < current_article2) {
	    if (article_list[current_article3].real_number + 1
		!= article_list[current_article3 + 1].real_number) {
	      break;
	    }
	    current_article3++;
	  }
	  news_add_mark(current_group,
			article_list[current_article4].real_number,
			article_list[current_article3++].real_number);
	}
      } else {
	news_add_mark(current_group,
		      article_list[current_article3].real_number,
		      article_list[current_article2].real_number);
      }
    }
  } else {
    news_add_mark(current_group,
		  news_group[current_group].min_article,
		  news_group[current_group].max_article);
  }
  return(current_article);
}

/*
 * ̤ɵֹ(󥻥뵭ϼưޡ)
 */

static int	news_next_unread_article2(current_group, current_article)
     int	current_group;
     int	current_article;
{
  register int	current_article2, current_article3;
  int		current_article4;

  current_article2 = current_article;
  if (news_article_number > 0) {
    while (1) {
      if (article_list[current_article].mark & READ_MARK) {
	if (current_article >= news_article_number - 1) {
	  break;
	}
	current_article = news_next_unread_article(current_article);
      } else {
	if (article_list[current_article].mark & UNFETCH_MARK) {
	  news_get_field(current_article);
	}
	if (!(article_list[current_article].mark & CANCEL_MARK)) {
	  break;
	}
	article_list[current_article].mark |= READ_MARK;
      }
    }
    if (article_list[current_article].mark & READ_MARK) {
      current_article3 = current_article;
    } else {
      current_article3 = current_article - 1;
    }
    if (current_article3 >= current_article2) {
      if (news_thread_mode) {
	while (current_article2 <= current_article3) {
	  current_article4 = current_article2;
	  while (current_article2 < current_article3) {
	    if (article_list[current_article2].real_number + 1
		!= article_list[current_article2 + 1].real_number) {
	      break;
	    }
	    current_article2++;
	  }
	  news_add_mark(current_group,
			article_list[current_article4].real_number,
			article_list[current_article2++].real_number);
	}
      } else {
	news_add_mark(current_group,
		      article_list[current_article2].real_number,
		      article_list[current_article3].real_number);
      }
    }
  } else {
    news_add_mark(current_group,
		  news_group[current_group].min_article,
		  news_group[current_group].max_article);
  }
  return(current_article);
}

/*
 * ̤ɵꥹȼ
 */

static int	news_get_list(current_group)
     int	current_group;
{
  MARK_LIST	*mark_ptr;
  int		min_number;
  register int	i, j;

  min_number = news_group[current_group].min_article;
  news_article_number = news_group[current_group].max_article
    - min_number + 1;
  multi_number = 0;
  base_message[0] = refer_message[0] = '\0';
  if (news_article_number <= 0) {
    news_article_number = 0;
    return(1);
#ifdef	NEWS_MAX_ARTICLE
  } else if (news_article_number > NEWS_MAX_ARTICLE) {
    news_article_number = NEWS_MAX_ARTICLE;
    min_number = news_group[current_group].max_article
      - news_article_number + 1;
#endif	/* NEWS_MAX_ARTICLE */
  }
  if (article_list) {
    free(article_list);
  }
  if (!(article_list = (ARTICLE_LIST*)
	malloc(sizeof(ARTICLE_LIST) * news_article_number))) {
    print_fatal("Can't allocate memory for article struct.");
    news_article_number = 0;
    return(1);
  }
  for (i = 0; i < news_article_number; i++) {
    article_list[i].real_number = min_number + i;
    article_list[i].mark = UNFETCH_MARK;	/* إå̤	*/
  }

  /*	ɥޡ		*/

  mark_ptr = group_list[current_group].mark_ptr;
  while (mark_ptr) {
    if ((mark_ptr->end_number >= news_group[current_group].min_article) &&
	(mark_ptr->start_number <= news_group[current_group].max_article)) {
      for (i = mark_ptr->start_number; i <= mark_ptr->end_number; i++) {
	j = i - min_number;
	if ((j >= 0) && (j < news_article_number)) {
	  article_list[j].mark |= READ_MARK;
	}
      }
    }
    mark_ptr = mark_ptr->next_ptr;
  }

  /*	Ƚ	*/

#ifdef	REF_SORT
  if (message_list) {
    print_fatal("Unexpected message list allocation found.");
    free(message_list);
    message_list = NULL;
  }
  if (news_article_number && (sort_rule == 1)) {
    message_list = (MESSAGE_LIST*)malloc(sizeof(MESSAGE_LIST)
					 * news_article_number);
  }
#endif	/* REF_SORT */
  if (sort_articles(current_group, &news_article_number,
		    news_thread_mode, news_article_mask,
		    news_get_field, news_add_mark) < 0) {
    return(-1);
  }

  /*	ѥå	*/

  if (news_article_mask) {
    pack_articles(current_group, &news_article_number,
		  news_get_field, news_add_mark);
  }
  return(0);
}

/*
 * إå
 */

static int	news_get_field(current_article)
     int	current_article;		/*	ֹ̤	*/
{
  static char		from_buff[BUFF_SIZE];
  static char		date_buff[MAX_FIELD_LEN];
  static char		subject_buff[BUFF_SIZE];
  static char		x_nsubj_buff[MAX_FIELD_LEN];
  static char		line_buff[MAX_FIELD_LEN];
#ifdef	REF_SORT
  static char		message_buff[MAX_FIELD_LEN];
  static char		reference_buff[BUFF_SIZE];
#endif	/* REF_SORT */
  static struct cpy_hdr	news_fields[] = {
    {FROM_FIELD,	from_buff,	sizeof(from_buff)},
    {DATE_FIELD,	date_buff,	sizeof(date_buff)},
    {SUBJECT_FIELD,	subject_buff,	sizeof(subject_buff)},
    {X_NSUBJ_FIELD,	x_nsubj_buff,	sizeof(x_nsubj_buff)},
    {LINE_FIELD,	line_buff,	sizeof(line_buff)},
#ifdef	REF_SORT
    {MESSAGE_FIELD,	message_buff,	sizeof(message_buff)},
    {REFERENCE_FIELD,	reference_buff,	sizeof(reference_buff)},
#endif	/* REF_SORT */
  };
#ifdef	REF_SORT
  char			*ptr;
#else	/* !REF_SORT */
  short			year;
#endif	/* !REF_SORT */
  short			day, hour, minute, second;

  if ((current_article < 0) || (current_article >= news_article_number)) {
    return(1);
  }
  article_list[current_article].mark &= ~UNFETCH_MARK;
  if (nntp_copy_fields(article_list[current_article].real_number, news_fields,
		       sizeof(news_fields)/sizeof(struct cpy_hdr),
		       CF_CLR_MASK | CF_GET_MASK | CF_SPC_MASK) < 0) {
    article_list[current_article].mark |= CANCEL_MARK;
    return(-1);
  }
  get_real_adrs(from_buff, article_list[current_article].from);
  if (x_nsubj_mode && x_nsubj_buff[0]) {
    recover_jis(subject_buff, x_nsubj_buff);
  }
  mime_decode_func(from_buff, subject_buff, default_code);
  euc_tab_strncpy(article_list[current_article].subject, from_buff,
		  MAX_SUBJECT_LEN - 1);
  article_list[current_article].lines = atoi(line_buff);
#ifdef	REF_SORT
  convert_article_date(date_buff, &article_list[current_article].year,
		       &article_list[current_article].month,
		       &article_list[current_article].date, &day, &hour,
		       &minute, &second, from_buff);
  if (message_list) {
    strncpy(message_list[current_article].msg_id, message_buff,
	    MAX_FIELD_LEN - 1);
    message_list[current_article].msg_id[MAX_FIELD_LEN - 1] = '\0';
    if (ptr = strrchr(reference_buff, '<')) {
      strncpy(message_list[current_article].ref_id, ptr,
	      MAX_FIELD_LEN - 1);
      message_list[current_article].ref_id[MAX_FIELD_LEN - 1] = '\0';
      if (ptr = strchr(message_list[current_article].ref_id, '>')) {
	*(ptr + 1) = '\0';
      }
    } else {
      message_list[current_article].ref_id[0] = '\0';
    }
  }
#else	/* !REF_SORT */
  convert_article_date(date_buff, &year, &article_list[current_article].month,
		       &article_list[current_article].date, &day, &hour,
		       &minute, &second, from_buff);
#endif /* REF_SORT */
  return(0);
}

#ifndef	SMALL
/*
 * ֥ȸ(ʣ)
 */

int	search_subjects(mode, max_number, current_ptr, retrieve)
     int	mode;
     int	max_number;
     int	*current_ptr;
     void	(*retrieve)();
{
  register int	current_article;
  char		*str;

  if (str = input_search_string(mode)) {
    if (mode) {
      for (current_article = *current_ptr - 1; current_article >= 0;
	   current_article--) {
	if (search_subject(current_article, str, retrieve)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *current_ptr = current_article;
	  return(0);
	}
      }
    } else {
      for (current_article = *current_ptr + 1; current_article < max_number;
	   current_article++) {
	if (search_subject(current_article, str, retrieve)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *current_ptr = current_article;
	  return(0);
	}
      }
    }
    print_mode_line(japanese ? "ĤޤǤ" : "Search failed.");
    return(1);
  }
  return(0);
}

/*
 * ֥ȸ(ñ)
 */

int	search_subject(current_article, str, retrieve)
     int	current_article;
     char	*str;
     void	(*retrieve)();
{
  if (article_list[current_article].mark & UNFETCH_MARK) {
    if (retrieve) {
      retrieve(current_article);
    }
  }
  if (article_list[current_article].mark & CANCEL_MARK) {
    return(0);
  }
  if (strindex(article_list[current_article].from, str)) {
    return(1);
  }
  if (strindex(article_list[current_article].subject, str)) {
    return(1);
  }
  return(0);
}

/*
 * Ʊ쥵֥ȥޡ
 */

void	kill_subjects(current_group, current_article, max_article,
		      retrieve, mark)
     int	current_group;
     int	current_article;
     int	max_article;
     void	(*retrieve)();
     void	(*mark)();
{
  char		*ptr1, *ptr2;
  register int	i;

  ptr1 = article_list[current_article].subject;
  if (!*ptr1) {
    return;
  }
  if ((*ptr1 == ' ') && 
      ((*(ptr1 + 1) == ' ') || (*(ptr1 + 1) == THREAD_CHAR))) {
    ptr1 += 2;
    while (*ptr1 == THREAD_CHAR) {
      ptr1++;
    }
    if (*ptr1 == ' ') {
      ptr1++;
    }
    if (*ptr1 == ' ') {
      ptr1++;
    }
  } else if (!strncmp(ptr1, REPLY_SUBJECT, sizeof(REPLY_SUBJECT) - 1)) {
    ptr1 += 4;
  }
  for (i = current_article; i < max_article; i++) {
    if (article_list[i].mark & UNFETCH_MARK) {
      if (retrieve) {
	retrieve(i);
      }
    }
    if (!(article_list[i].mark & CANCEL_MARK)) {
      ptr2 = article_list[i].subject;
      if ((*ptr2 == ' ') && 
	  ((*(ptr2 + 1) == ' ') || (*(ptr2 + 1) == THREAD_CHAR))) {
	ptr2 += 2;
	while (*ptr2 == THREAD_CHAR) {
	  ptr2++;
	}
	if (*ptr2 == ' ') {
	  ptr2++;
	}
	if (*ptr2 == ' ') {
	  ptr2++;
	}
      } else if (!strncmp(ptr2, REPLY_SUBJECT, sizeof(REPLY_SUBJECT) - 1)) {
	ptr2 += 4;
      }
      if (!strcmp(ptr1, ptr2)) {
	article_list[i].mark |= READ_MARK;
	if (mark) {
	  mark(current_group, article_list[i].real_number,
	       article_list[i].real_number);
	}
      }
    }
  }
}
#endif	/* !SMALL */

/*
 * ޥޡ/
 */

void	multi_mark(top_position, current_article)
     int	top_position;
     int	current_article;
{
  int	i, j;

  if (!(article_list[current_article].mark & CANCEL_MARK)) {
    if ((article_list[current_article].mark & MULTI_MARK) ||
	(multi_number < MAX_MULTI_NUMBER)) {
      toggle_mark(top_position, current_article, MULTI_MARK);
      if (article_list[current_article].mark & MULTI_MARK) {
	multi_list[multi_number++] = current_article;
      } else {
	for (i = 0; i < multi_number; i++) {
	  if (multi_list[i] == current_article) {
	    multi_number--;
	    for (j = i; j < multi_number; j++) {
	      multi_list[j] = multi_list[j + 1];
	    }
	    break;
	  }
	}
      }
    }
  }
}

/*
 * ޥޡ
 */

void	multi_clear(max_article)
     int	max_article;
{
  int	i;

  multi_number = 0;
  if (article_list) {
    for (i = 0; i < max_article; i++) {
      article_list[i].mark &= ~MULTI_MARK;
    }
  }
}

/*
 * ʣޡޥޡõ
 */

void	multi_add_mark(max_article, current_group, current_article,
		       mark, add_mark)
     int	max_article;
     int	current_group;
     int	current_article;
     int	mark;
     int	(*add_mark)();
{
  register int	i;

  if (article_list) {
    if (multi_number) {
      for (i = 0; i < max_article; i++) {
	if (article_list[i].mark & MULTI_MARK) {
	  if (current_group >= 0) {
	    add_mark(current_group, i, mark);
	  } else {
	    add_mark(i, mark);
	  }
	}
      }
    } else {
      if (current_group >= 0) {
	add_mark(current_group, current_article, mark);
      } else {
	add_mark(current_article, mark);
      }
    }
  }
  multi_clear(max_article);
}

#if	defined(NEWSPOST) || defined(MAILSEND)
/*
 * ʣ
 */

int	multi_extract(current_article, tmp_file, extract)
     int	current_article;
     char	*tmp_file;
     int	(*extract)();
{
  FILE		*fp;
  register int	i, j;

  j = 0;
  for (i = 0; i < multi_number; i++) {
    if (j) {
      fclose2(tmp_file);
    }
    if (extract(article_list[multi_list[i]].real_number, tmp_file)) {
      return(1);
    }
    if ((fp = fopen(tmp_file, "a")) == (FILE*)NULL) {
      funlink2(tmp_file);
      return(1);
    }
    fprintf(fp, "%s", MULTI_END_MARK);
    fclose(fp);
    j = 1;
  }
  if (!j) {
    if (extract(article_list[current_article].real_number, tmp_file)) {
      return(1);
    }
  }
  return(0);
}
#endif	/* NEWSPOST || MAILSEND */

/*
 * ɽ
 */

void	print_articles(top_position, max_article, retrieve, lost_message)
     int	top_position;
     int	max_article;
     int	(*retrieve)();
     char	*lost_message;
{
  register int	i, j, k, l;
  char		buff[BUFF_SIZE];
#ifdef	JNAMES
  char		jfrom[BUFF_SIZE];
#endif	/* JNAMES */

  if (!wide_mode) {
    term_locate(0, 2);
    term_attrib(RESET_ATTRIB);
#ifdef	COLOR
    term_attrib(color_code[HEADER_COLOR]);
#else	/* !COLOR */
    term_attrib(REVERSE_ATTRIB);
#endif	/* !COLOR */
    if (max_article > 0) {
      i = j = article_list[0].real_number;
      for (k = 0; k < max_article; k++) {
	if (i > article_list[k].real_number) {
	  i = article_list[k].real_number;
	}
	if (j < article_list[k].real_number) {
	  j = article_list[k].real_number;
	}
      }
    } else {
      i = j = 0;
    }
    switch (article_format) {
    case 0:
      print_full_line(japanese ?
		      "ޡ ֹ   Կ п       ֥̾ [%-8.8s] (%d-%d)" :
		      "Mark   No.  Date  Line From         Subject        [%-8.8s] (%d-%d)",
		      newmail_string[check_new_mail()], i, j);
      break;
    case 1:
      print_full_line(japanese ?
		      "ޡ ֹ п       ֥̾ [%-8.8s] (%d-%d)" :
		      "Mark   No.  From         Subject        [%-8.8s] (%d-%d)",
		      newmail_string[check_new_mail()], i, j);
      break;
    case 2:
      print_full_line(japanese ?
		      "ޡ ֹ ֥̾ [%-8.8s] (%d-%d)" :
		      "Mark   No.  Subject        [%-8.8s] (%d-%d)",
		      newmail_string[check_new_mail()], i, j);
      break;
    default:
      break;
    }
  }
  term_attrib(RESET_ATTRIB);
  switch (article_format) {
  case 0:
    l = term_columns - 36;
    break;
  case 1:
    l = term_columns - 25;
    break;
  case 2:
  default:
    l = term_columns - 12;
    break;
  }
  for (i = 0, j = top_position; i < term_lines - mode_lines; i++, j++) {
    if (j >= max_article) {
      break;
    }
    if (article_list[j].mark & UNFETCH_MARK) {
      if (retrieve) {
	retrieve(j);
      }
    }
    toggle_mark(top_position, j, 0);
    if (!(article_list[j].mark & UNFETCH_MARK)) {
#ifdef	COLOR
      term_attrib(color_code[NUMBER_COLOR]);
#endif	/* COLOR */
      cprintf("%6d ", article_list[j].real_number);
      if (article_list[j].mark & CANCEL_MARK) {
#ifdef	COLOR
	term_attrib(color_code[LOST_COLOR]);
#endif	/* COLOR */
	cprintf("           %s\n", lost_message);
      } else {
#ifdef	JNAMES
	strcpy(buff, article_list[j].from);
	get_jadrs(jfrom, buff);
	euc_strncpy2(buff, jfrom, 12);
#else	/* !JNAMES */
	sprintf(buff, "%-12.12s", article_list[j].from);
#endif	/* JNAMES */
	switch (article_format) {
	case 0:
#ifdef	COLOR
	  term_attrib(color_code[DATE_COLOR]);
#endif	/* COLOR */
	  cprintf("%02d/%02d", (int)article_list[j].month,
		  (int)article_list[j].date);
#ifdef	COLOR
	  term_attrib(color_code[LINE_COLOR]);
#endif	/* COLOR */
	  cprintf("%5d ", (int)article_list[j].lines);
	  /* break  */
	case 1:
#ifdef	COLOR
	  term_attrib(color_code[FROM_COLOR]);
#endif	/* COLOR */
	  euc_printf("%s ", buff);
	  break;
	case 2:
	default:
	  break;
	}
#ifdef	COLOR
	if (article_list[j].mark & THREAD_MARK) {
	  term_attrib(color_code[THREAD_COLOR]);
	} else {
	  term_attrib(color_code[SUBJECT_COLOR]);
	}
#endif	/* COLOR */
	euc_strncpy(buff, article_list[j].subject, l);
	euc_printf("%s", buff);
      }
    }
  }
  term_attrib(RESET_ATTRIB);
}

/*
 * ޡȿž/ɽ
 */

void	toggle_mark(top_position, current_article, mark)
     int	top_position;
     int	current_article;
     int	mark;
{
  static char	mark_buff[8];
  char		*ptr;
  register int	m;

  m = (article_list[current_article].mark ^= mark);
  term_locate(0, head_lines + current_article - top_position);
  ptr = mark_buff;
#ifdef	COLOR
  term_attrib(color_code[MARK_COLOR]);
#endif	/* COLOR */
  if (m & MULTI_MARK) {
    *ptr++ = 'M';
  } else {
    *ptr++ = ' ';
  }
  if (m & READ_MARK) {
    *ptr++ = 'R';
  } else {
    *ptr++ = ' ';
  }
  if (m & DELETE_MARK) {
    *ptr++ = 'D';
  } else {
    *ptr++ = ' ';
  }
  if (m & FORWARD_MARK) {
    *ptr++ = 'F';
  } else {
    *ptr++ = ' ';
  }
  if (m & ANSWER_MARK) {
    *ptr++ = 'A';
  } else {
    *ptr++ = ' ';
  }
  *ptr = '\0';
  cprintf(mark_buff);
#ifdef	COLOR
  term_attrib(RESET_ATTRIB);
#endif	/* COLOR */
}

/*
 * ʣ
 */

int	multi_save(current_article, extract)
     int	current_article;
     int	(*extract)();
{
  char	file_name[PATH_BUFF];
  int	i, j;
  int	status;
#ifdef	MSDOS
  char	*ptr;
#endif	/* MSDOS */

#ifdef	MSDOS
  sprintf(file_name, "%s%c", save_dir, SLASH_CHAR);
  ptr = file_name;
  while (*ptr) {
    ptr++;
  }
  strcpy(ptr, select_name);
  while (*ptr) {
    if (*ptr == NEWS_GROUP_SEPARATER) {
      *ptr++ = SLASH_CHAR;
    } else {
      ptr++;
    }
  }
#else	/* !MSDOS */
  sprintf(file_name, "%s%c%s", save_dir, SLASH_CHAR, select_name);
#endif	/* !MSDOS */
  input_line(INPUT_EXPAND_MASK | INPUT_COMP_MASK,
	     "ե̾ϤƲ:", "Input file name:", file_name);
  if (!file_name[0]) {
    return(1);
  }
  status = 0;
  print_mode_line(japanese ? "Ǥ" : "Saving.");
  if (multi_number) {
    j = strlen(file_name);
    for (i = 0; i < multi_number; i++) {
      sprintf(&file_name[j], "%02d", i + 1);
      if (save_article(article_list[multi_list[i]].real_number, extract,
		       file_name)) {
	status = 1;
      }
    }
  } else {
    status = save_article(article_list[current_article].real_number, extract,
			  file_name);
  }
  if (status) {
    print_mode_line(japanese ? "֤ǤޤǤ" :
		    "Save article failed.");
    term_bell();
    sleep(ERROR_SLEEP);
  }
  return(status);
}

/*
 * (̴ؿ)
 */

int	save_article(real_number, extract, file_name)
     int	real_number;
     int	(*extract)();
     char	*file_name;
{
  struct stat	stat_buff;
  struct tm	*tm;
  FILE		*fp1;
  FILE		*fp2;
  char		tmp_file[PATH_BUFF];
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  int		status;
  time_t	now_time;

  create_temp_name(tmp_file, "AS");
  if (!stat(file_name, &stat_buff)) {
    switch (yes_or_no(FILE_YN_MODE,
		      "ե뤬¸ߤޤڥɤޤ?",
		      "File exists.Append?")) {
    case 2:
      unlink(file_name);
      break;
    case 1:
      break;
    case 0:
    default:
      return(0);
      /* break; */
    }
  }
  status = 1;
  if (!extract(real_number, tmp_file)) {
    if (fp1 = fopen(tmp_file, "r")) {
      if (fp2 = fopen(file_name, "a")) {
	if (unixfrom_mode) {
	  buff2[0] = '\0';
	  while (fgets(buff1, sizeof(buff1), fp1)) {
	    if (status == 1) {
	      status = 2;
	      if (!strncmp(buff1, UCBMAIL_SEPARATER,
			   sizeof(UCBMAIL_SEPARATER) - 1)) {
		break;
	      }
	    }
	    copy_field(buff1, buff2, FROM_FIELD);
	    if ((!buff1[0]) || (buff1[0] == '\n')) {
	      break;
	    }
	  }
	  fseek(fp1, 0L, 0);
	  if (buff2[0]) {
	    get_real_adrs(buff2, buff1);
	    now_time = time(NULL);
	    tm = localtime(&now_time);
	    fprintf(fp2, "%s%s %s %s %2d %02d:%02d:%02d 19%d\n",
		    UCBMAIL_SEPARATER, buff1, day_string[tm->tm_wday + 1],
		    month_string[tm->tm_mon + 1], tm->tm_mday, tm->tm_hour,
		    tm->tm_min, tm->tm_sec, tm->tm_year);
	  }
	}
	while (fgets(buff1, sizeof(buff1), fp1)) {
	  switch (save_code) {
	  case JIS_CODE:
	    to_jis(buff2, buff1, default_code);
	    break;
	  case SJIS_CODE:
	    to_sjis(buff2, buff1, default_code);
	    break;
	  case EUC_CODE:
	    to_euc(buff2, buff1, default_code);
	    break;
	  default:
	    strcpy(buff2, buff1);
	    break;
	  }
	  if (unixfrom_mode && (!strncmp(buff2, UCBMAIL_SEPARATER,
					 sizeof(UCBMAIL_SEPARATER) - 1))) {
	    fputc('>', fp2);
	  }
	  fputs(buff2, fp2);
	}
	if (unixfrom_mode) {
	  fputc('\n', fp2);
	}
	status = fclose(fp2);
      }
      fclose(fp1);
    }
  }
  funlink2(tmp_file);
  return(status);
}

#ifndef	SMALL
/*
 * ʣѥ׼¹
 */

int	multi_pipe(current_article, extract)
     int	current_article;
     int	(*extract)();
{
  FILE	*fp;
  char	tmp_file[PATH_BUFF];
  char	buff[BUFF_SIZE];
  char	*ptr;
  int	i;
  int	status;

  buff[0] = '\0';
  input_line(0, "ѥץޥɤϤƲ:|",
	     "Input pipe command:|", buff);
  ptr = buff;
  while ((*ptr == ' ') || (*ptr == '\t')) {
    ptr++;
  }
  if (!(*ptr)) {
    return(1);
  }
  print_mode_line(japanese ? "ѥ׽¹Ǥ" :
		  "Executing pipe command.");
  create_temp_name(tmp_file, "AP");
  status = 0;
  signal(SIGPIPE, pipe_error);
  term_init(1);
  if (fp = popen(ptr, "w")) {
    if (multi_number) {
      for (i = 0; i < multi_number; i++) {
	if (pipe_article(fp, article_list[multi_list[i]].real_number,
			 extract, tmp_file)) {
	  status = 1;
	}
      }
    } else {
      status = pipe_article(fp, article_list[current_article].real_number,
			    extract, tmp_file);
    }
    if (pclose(fp)) {
      status = 1;
    }
    term_init(2);
  } else {
    term_init(2);
    print_fatal("Can't execute pipe command.");
  }
  signal(SIGPIPE, SIG_IGN);
  if (status) {
    print_mode_line(japanese ? "ѥ׽˼Ԥޤ" :
		    "Pipe command error.");
    term_bell();
    sleep(ERROR_SLEEP);
    return(1);
  }
  return(0);
}

/*
 * ѥ׼¹(̴ؿ)
 */

static int	pipe_article(fp1, real_number, extract, tmp_file)
     FILE	*fp1;
     int	real_number;
     int	(*extract)();
     char	*tmp_file;
{
  FILE	*fp2;
  char	buff1[BUFF_SIZE];
  char	buff2[BUFF_SIZE];
  int	status;

  if (extract(real_number, tmp_file)) {
    funlink2(tmp_file);
    return(1);
  }
  status = 1;
  if (fp2 = fopen(tmp_file, "r")) {
    while (fgets(buff1, sizeof(buff1), fp2)) {
      switch (pipe_code) {
      case JIS_CODE:
	to_jis(buff2, buff1, default_code);
	break;
      case SJIS_CODE:
	to_sjis(buff2, buff1, default_code);
	break;
      case EUC_CODE:
	to_euc(buff2, buff1, default_code);
	break;
      default:
	strcpy(buff2, buff1);
	break;
      }
      if (fputs(buff2, fp1) == EOF) {
	status = 1;
      }
    }
    fclose(fp2);
    status = 0;
  }
  funlink2(tmp_file);
  return(status);
}
#endif	/* !SMALL */

#ifdef	XOVER
int	xover_copy_field(ptr1)
     char	*ptr1;
{
  char		buff[BUFF_SIZE];
  char		*ptr2;
  register int	current_article;
#ifndef	REF_SORT
  short		year;
#endif	/* !REF_SORT */
  short		day, hour, minute, second;

  current_article = atoi(ptr1) - article_list[0].real_number;
  if ((current_article < 0) || (current_article >= news_article_number)) {
    return(1);
  }
  while (isdigit(*ptr1)) {
    ptr1++;
  }
  if (*ptr1 == '\t') {
    ptr1++;
  } else {
    return(1);
  }
  ptr2 = ptr1;
  while (*ptr2) {
    if (*ptr2 == '\t') {
      *ptr2++ = '\0';
      break;
    }
    ptr2++;
  }
  mime_decode_func(buff, ptr1, default_code);
  euc_tab_strncpy(article_list[current_article].subject, buff,
		  MAX_SUBJECT_LEN - 1);
  ptr1 = ptr2;
  while (*ptr2) {
    if (*ptr2 == '\t') {
      *ptr2++ = '\0';
      break;
    }
    ptr2++;
  }
  get_real_adrs(ptr1, article_list[current_article].from);
  ptr1 = ptr2;
  while (*ptr2) {
    if (*ptr2 == '\t') {
      *ptr2++ = '\0';
      break;
    }
    ptr2++;
  }
#ifdef	REF_SORT
  convert_article_date(ptr1,
		       &article_list[current_article].year, 
		       &article_list[current_article].month,
		       &article_list[current_article].date,
		       &day, &hour,&minute, &second, buff);
#else	/* !REF_SORT */
  convert_article_date(ptr1,
		       &article_list[current_article].month,
		       &article_list[current_article].date,
		       &day, &hour,&minute, &second, buff);
#endif	/* !REF_SORT */
  ptr1 = ptr2;
  while (*ptr2) {
    if (*ptr2 == '\t') {
      *ptr2++ = '\0';
      break;
    }
    ptr2++;
  }
#ifdef	REF_SORT
  if (message_list) {
    strcpy(message_list[current_article].msg_id, ptr1);
  }
#endif	/* REF_SORT */
  ptr1 = ptr2;
  while (*ptr2) {
    if (*ptr2 == '\t') {
      *ptr2++ = '\0';
      break;
    }
    ptr2++;
  }
#ifdef	REF_SORT
  if (message_list) {
    strcpy(message_list[current_article].ref_id, ptr1);
  }
#endif	/* REF_SORT */
  ptr1 = ptr2;
  while (isdigit(*ptr1)) {
    ptr1++;
  }
  if (*ptr1 == '\t') {
    ptr1++;
  } else {
    return(1);
  }
  article_list[current_article].lines = atoi(ptr1);
  article_list[current_article].mark &= ~UNFETCH_MARK;
  return(0);
}
#endif	/* XOVER */

/*
 * 
 */

int	sort_articles(current_group, article_ptr, thread_mode, article_mask,
		      retrieve, mark)
     int	current_group;
     int	*article_ptr;
     short	thread_mode;
     short	article_mask;
     int	(*retrieve)();
     void	(*mark)();
{
  char		buff[BUFF_SIZE];
  int		article_number;
  int		min_number;
  int		status;
  register int	i, j;

  article_number = *article_ptr;
  if ((!thread_mode) || (!article_number)) {
    status = 1;
    goto sort_end;
  }

  min_number = article_number - 1;
  for (i = 0; i < article_number; i++) {
    if (!(article_list[i].mark & READ_MARK)) {
      min_number = i;
      break;
    }
  }
  if (min_number > (article_number - term_lines)) {
    if ((min_number = article_number - term_lines) < 0) {
      min_number = 0;
    }
  }
  if ((article_number - min_number) > MAX_THREAD_SEARCH) {
#ifdef	notdef
    sprintf(buff, "%d", article_number - min_number);
#else	/* !notdef */
    sprintf(buff, "%d", MAX_THREAD_SEARCH);
#endif	/* !notdef */
    print_title();
    input_line(INPUT_SPCCUT_MASK, "Ȥ뵭ϤƲ:",
	       "Input how many articles sort:", buff);
    if (buff[0]) {
      i = atoi(buff);
      if (i <= 0) {
	status = 1;
	goto sort_end;
      } else if (i >= article_number) {
	min_number = 0;
      } else {
	min_number = article_number - i;
      }
    } else {
      status = -1;
      goto sort_end;
    }
  }

  /*
   * Ȥ뵭
   */
  
  print_mode_line(japanese ? "Ǥ" : "Sorting.");
  if (sort_list = (ARTICLE_LIST*)
      malloc(sizeof(ARTICLE_LIST) * article_number)) {
    if (min_number > 0) {
      bcopy(article_list, sort_list, sizeof(ARTICLE_LIST) * min_number);
    }
#ifdef	XOVER
    if (xover_mode && (mark == news_add_mark)) {
      if (!nntp_xover(article_list[min_number].real_number,
		      article_list[article_number - 1].real_number)) {
	for (i = min_number; i < article_number; i++) {
	  if (article_list[i].mark & UNFETCH_MARK) {
	    article_list[i].mark &= ~UNFETCH_MARK;
	    article_list[i].mark |= CANCEL_MARK;
	    if (mark) {
	      mark(current_group, article_list[i].real_number,
		   article_list[i].real_number);
	    }
	  }
	}
      }
    } else {
#else	/* !XOVER */
    {
#endif	/* !XOVER */
      if (article_mask) {
	for (i = min_number; i < article_number; i++) {
	  if (!(article_list[i].mark & READ_MARK)) {
	    if (retrieve) {
	      if (retrieve(i) < 0) {
		if (mark) {
		  mark(current_group, article_list[i].real_number,
		       article_list[i].real_number);
		}
	      }
	    }
	  }
	}
      } else {
	for (i = min_number; i < article_number; i++) {
	  if (retrieve) {
	    if (retrieve(i) < 0) {
	      if (mark) {
		mark(current_group, article_list[i].real_number,
		     article_list[i].real_number);
	      }
	    }
	  }
	}
      }
    }

    /*
     * Ƚᥤ
     */

    sort_article_func[sort_rule](&article_number, min_number);
  
    /*
     * ȸ
     */

    if (article_number - min_number) {
      bcopy(&sort_list[min_number], &article_list[min_number],
	    (article_number - min_number) * sizeof(ARTICLE_LIST));
    }
    free(sort_list);
    for (j = min_number; j < article_number; j++) {
      article_list[j].mark &=~ SORT_MARK;
    }
  }
  *article_ptr = article_number;
  status = 0;
 sort_end:
#ifdef	REF_SORT
  if (message_list) {
    free(message_list);
    message_list = NULL;
  }
#endif	/* REF_SORT */
  return(status);
}

/*
 * ѥå
 */

int	pack_articles(current_group, article_ptr, retrieve, mark)
     int	current_group;
     int	*article_ptr;
     int	(*retrieve)();
     void	(*mark)();
{
  int		article_number;
  register int	i, j, k;

  article_number = *article_ptr;
  for (i = 0; i < article_number; i++) {
    if ((article_list[i].mark & UNFETCH_MARK) &&
	(!(article_list[i].mark & (READ_MARK | CANCEL_MARK)))) {
      if (retrieve) {
	if (retrieve(i) < 0) {
	  if (mark) {
	    mark(current_group, article_list[i].real_number,
		 article_list[i].real_number);
	  }
	}
      } else {
	print_fatal("Unexpected unfetched article-%d.", i);
      }
    }
  }
  i = j = 0;
  while (j < article_number) {
    k = j;
    if (!(article_list[j].mark & (READ_MARK | CANCEL_MARK))) {
      while (!(article_list[j].mark & (READ_MARK | CANCEL_MARK))) {
	if (++j >= article_number) {
	  break;
	}
      }
#ifdef	DEBUG
      print_fatal("ARTICLE=%d(%d)->%d(%d)", j, article_list[j].real_number,
		  i, article_list[i].real_number);
#endif	/* DEBUG */
      if (i != k) {
	bcopy(&article_list[k], &article_list[i],
	      (j - k) * sizeof(struct article_struct));
      }
      i += (j - k);
    } else {
      j++;
    }
  }
  *article_ptr = i;
  return(0);
}

/*
 * Subject 
 */

static int	sort_subject(article_ptr, min_number)
     int	*article_ptr;
     int	min_number;
{
  char		buff[BUFF_SIZE];
  int		article_number;
  register int	i, j, k, l;

  /*
   *  Subject εޤȤ
   */
  
  article_number = *article_ptr;
  i = min_number;
  
  for (j = min_number; j < article_number; j++) {
    if ((!(article_list[j].mark & CANCEL_MARK)) &&
	(strncmp(article_list[j].subject, REPLY_SUBJECT,
		 sizeof(REPLY_SUBJECT) - 1))) {
      article_list[j].mark |= SORT_MARK;
      bcopy(&article_list[j], &sort_list[i++], sizeof(ARTICLE_LIST));
      article_list[j].mark |= CANCEL_MARK;
      strcpy(buff, REPLY_SUBJECT);
      strcpy(&buff[sizeof(REPLY_SUBJECT) - 1], article_list[j].subject);
      for (k = min_number; k < article_number; k++) {
	if ((!(article_list[k].mark & CANCEL_MARK)) &&
	    (!strcmp(buff, article_list[k].subject))) {
	  strncpy(article_list[k].subject, THREAD_SUBJECT1, 3);
	  article_list[k].mark |= THREAD_MARK;
	  bcopy(&article_list[k], &sort_list[i++], sizeof(ARTICLE_LIST));
	  article_list[k].mark |= CANCEL_MARK;
	}
      }
    }
  }
  
  /*
   *  Subject ǤϤʤեεޤȤ
   */
  
  for (j = min_number; j < article_number; j++) {
    if ((!(article_list[j].mark & CANCEL_MARK)) &&
	(!strncmp(article_list[j].subject, REPLY_SUBJECT,
		  sizeof(REPLY_SUBJECT) - 1))) {
      k = article_list[j].real_number;
      for (l = min_number; l < i; l++) {
	if ((sort_list[l].mark & SORT_MARK) &&
	    (sort_list[l].real_number > k)) {
	  bcopy(&sort_list[l], &sort_list[l + 1],
		sizeof(ARTICLE_LIST) * (i - l));
	  break;
	}
      }
      article_list[j].mark |= SORT_MARK;
      bcopy(&article_list[j], &sort_list[l++], sizeof(ARTICLE_LIST));
      i++;
      article_list[j].mark |= CANCEL_MARK;
      for (k = min_number; k < article_number; k++) {
	if ((!(article_list[k].mark & CANCEL_MARK)) &&
	    (!strcmp(article_list[j].subject,
		     article_list[k].subject))) {
	  strncpy(article_list[k].subject, THREAD_SUBJECT2, 3);
	  if (l < i) {
	    bcopy(&sort_list[l], &sort_list[l + 1],
		  sizeof(ARTICLE_LIST) * (i - l));
	  }
	  article_list[k].mark |= THREAD_MARK;
	  bcopy(&article_list[k], &sort_list[l++], sizeof(ARTICLE_LIST));
	  i++;
	  article_list[k].mark |= CANCEL_MARK;
	}
      }
    }
  }
  
  /*
   * 嵭ʳε¤٤
   */
  
  for (j = min_number; j < article_number; j++) {
    if (!(article_list[j].mark & CANCEL_MARK)) {
      k = article_list[j].real_number;
      for (l = min_number; l < i; l++) {
	if ((sort_list[l].mark & SORT_MARK) &&
	    (sort_list[l].real_number > k)) {
	  bcopy(&sort_list[l], &sort_list[l + 1],
		sizeof(ARTICLE_LIST) * (i - l));
	  break;
	}
      }
      bcopy(&article_list[j], &sort_list[l++], sizeof(ARTICLE_LIST));
      i++;
    }
  }
  *article_ptr = i;
  return(0);
}

#ifdef	REF_SORT
/*
 * Reference 
 */

static int	sort_reference(article_ptr, min_number)
     int	*article_ptr;
     int	min_number;
{
  int		article_number;
  int		index;
  register int	i;

  article_number = *article_ptr;
  if (!message_list) {
    bcopy(article_list, sort_list, sizeof(ARTICLE_LIST) * article_number);
    return(1);
  }
  index = min_number;
  for (i = min_number; i < article_number; i++) {
    make_thread(0, &index, i, NULL, min_number, article_number);
  }
  *article_ptr = index;
  return(0);
}

/*
 * Date 
 */

static int	sort_date(article_ptr, min_number)
     int	*article_ptr;
     int	min_number;
{
  int		article_number;
  register int	i, j;

  article_number = *article_ptr;
  bcopy(article_list, sort_list, sizeof(ARTICLE_LIST) * article_number);
  if ((article_number - min_number) > 0) {
    qsort(&sort_list[min_number], article_number - min_number,
	  sizeof(ARTICLE_LIST), compare_date);
  }
  i = min_number;
  for (j = min_number; j < article_number; j++) {
    if (!(article_list[j].mark & CANCEL_MARK)) {
      i++;
    }
  }
  *article_ptr = i;
  return(0);
}

/*
 * åɺ
 */

static int	make_thread(level, index_ptr, current_article, message_id,
			    min_number, max_article)
     int	level;
     int	*index_ptr;
     int	current_article;
     char	*message_id;
     int	min_number;
     int	max_article;
{
  int		index;
  register int	i;

  if (article_list[current_article].mark & CANCEL_MARK) {
    return(1);
  }
  index = *index_ptr;
  if (message_id) {
    if (!strcmp(message_id, message_list[current_article].ref_id)) {
      bcopy(&article_list[current_article], &sort_list[index],
	    sizeof(ARTICLE_LIST));
      article_list[current_article].mark |= CANCEL_MARK;
      for (i = 0; i <= level; i++) {
	sort_list[index].subject[i] = (i < 2 ? ' ' : THREAD_CHAR);
      }
      strcpy(&sort_list[index].subject[i], THREAD_SUBJECT3);
      if (strncmp(article_list[current_article].subject, REPLY_SUBJECT,
		  sizeof(REPLY_SUBJECT) - 1)) {
	euc_strncpy(&sort_list[index].subject[i + sizeof(THREAD_SUBJECT3) - 1],
		    article_list[current_article].subject,
		    MAX_SUBJECT_LEN - (i + sizeof(THREAD_SUBJECT3) - 1) - 1);
      } else {
	sort_list[index].mark |= THREAD_MARK;
	euc_strncpy(&sort_list[index].subject[i + sizeof(THREAD_SUBJECT3) - 1],
		    &article_list[current_article].subject[4],
		    MAX_SUBJECT_LEN - (i + sizeof(THREAD_SUBJECT3) - 1) - 1);
      }
      index++;
      message_id = message_list[current_article].msg_id;
      if (message_id[0]) {
	for (i = min_number; i < max_article; i++) {
	  if (!(article_list[i].mark & CANCEL_MARK)) {
	    if ((i != current_article) &&
		(!strcmp(message_id, message_list[i].ref_id))) {
	      i = -1;
	      break;
	    }
	  }
	}
      } else {
	i = 0;
      }
      if (i < 0) {
	for (i = min_number; i < max_article; i++) {
	  make_thread(level + 1, &index, i, message_id,
		      min_number, max_article);
	}
      }
    }
  } else if (message_list[current_article].msg_id[0]) {
    if (message_list[current_article].ref_id[0]) {
      for (i = min_number; i < max_article; i++) {
	if (!(article_list[i].mark & CANCEL_MARK)) {
	  if ((i != current_article) &&
	      (!strcmp(message_list[current_article].ref_id,
		       message_list[i].msg_id))) {
	    i = -1;
	    break;
	  }
	}
      }
    } else {
      i = 0;
    }
    if (i >= 0) {
      bcopy(&article_list[current_article], &sort_list[index++],
	    sizeof(ARTICLE_LIST));
      article_list[current_article].mark |= CANCEL_MARK;
      for (i = min_number; i < max_article; i++) {
	make_thread(level + 1, &index, i,
		    message_list[current_article].msg_id,
		    min_number, max_article);
      }
    }
  } else {
    bcopy(&article_list[current_article], &sort_list[index++],
	  sizeof(ARTICLE_LIST));
    article_list[current_article].mark |= CANCEL_MARK;
  }
  *index_ptr = index;
  return(0);
}

/*
 * 
 */

static int	compare_date(article_ptr1, article_ptr2)
     ARTICLE_LIST	*article_ptr1;
     ARTICLE_LIST	*article_ptr2;
{
  if (article_ptr1 == article_ptr2) {
    return(0);
  }
  if (article_ptr1->mark & CANCEL_MARK) {
    if (article_ptr2->mark & CANCEL_MARK) {
      return(0);
    } else {
      return(1);
    }
  } else if (article_ptr2->mark & CANCEL_MARK) {
    return(-1);
  }
#ifdef	REF_SORT
  if (article_ptr1->year != article_ptr2->year) {
    return(article_ptr1->year < article_ptr2->year ? -1 : 1);
  }
#endif	/* REF_SORT */
  if (article_ptr1->month != article_ptr2->month) {
    return(article_ptr1->month < article_ptr2->month ? -1 : 1);
  }
  if (article_ptr1->date != article_ptr2->date) {
    return(article_ptr1->date < article_ptr2->date ? -1 : 1);
  }
  return(article_ptr1->real_number < article_ptr2->real_number ? -1 : 1);
}
#endif	/* REF_SORT */

/*
 * ѥå/ˡ
 */

int	change_sort_rule(current_group, article_ptr, current_ptr,
			 mask_ptr, thread_ptr, get_list, key)
     int	current_group;
     int	*article_ptr;
     int	*current_ptr;
     short	*mask_ptr;
     short	*thread_ptr;
     int	(*get_list)();
     int	key;
{
  int		current_article;
  register int	i, j;

  current_article = *current_ptr;
  if (key == 'l') {
    *mask_ptr = !*mask_ptr;
  } else {
    if (key == 't') {
      *thread_ptr = !*thread_ptr;
    } else {
#ifdef	REF_SORT
      if (++sort_rule > 2) {
	sort_rule = 0;
      }
      *thread_ptr = 1;
#else	/* !REF_SORT */
      return(1);
#endif	/* !REF_SORT */
    }
  }
  if (*article_ptr > 0) {
    j = article_list[current_article].real_number;
  } else {
    j = 0;
  }

  /*
   * get_list  *article_ptr ѲΤ
   */

  if (current_group >= 0) {
    get_list(current_group);
  } else {
    get_list();
  }
  current_article = 0;
  for (i = 0; i < *article_ptr; i++) {
    if (!(article_list[i].mark & CANCEL_MARK)) {
      current_article = i;
      if (article_list[i].real_number >= j) {
	break;
      }
    }
  }
  *current_ptr = current_article;
  return(0);
}

/*
 * ȥե̾
 */

void	create_temp_name(ptr1, ptr2)
     char	*ptr1;
     char	*ptr2;
{
  sprintf(ptr1, "%s%cmnews_%s.%d", tmp_dir, SLASH_CHAR, ptr2, getpid());
}
