/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : Configuration routine
 *  File        : config.c
 *  Version     : 1.19
 *  First Edit  : 1992-08/03
 *  Last  Edit  : 1995-06/15
 *  Author      : MSR24  
 *
 */

/*			*/

typedef enum {
  ASCII_CODE,
  JIS_CODE,
  SJIS_CODE,
  EUC_CODE,
  UNKNOWN_CODE,
} KANJICODE;

#ifndef	BUFF_SIZE
#define BUFF_SIZE	256
#endif	/* !BUFF_SIZE */
#ifndef	SMALL_BUFF
#define SMALL_BUFF	64
#endif	/* !SMALL_BUFF */
#ifndef	MESSAGE_FIELD
#define	MESSAGE_FIELD	"Message-ID:"
#endif	/* !MESSAGE_FIELD */

#include	"compat.h"
#include	"termlib.h"
#include	"site_dep.h"
#ifndef	MSDOS
#include	"inst_inf.h"
#endif	/* MSDOS */
#include	"config.h"

#ifndef	MSDOS
extern struct passwd	*passwd;	/* ѥɥȥ		*/
#endif	/* !MSDOS */
extern KANJICODE	print_code;	/* ɽ		*/
#ifdef	NSPL
extern char		news_spool[];	/* ˥塼ס		*/
extern char		news_lib[];	/* ˥塼饤֥		*/
#endif	/* NSPL */
extern char		nntp_server[];	/* NNTP ̾		*/
extern char		server_file[];	/* ǥեȥлե	*/
extern char		ignore_groups[];/* ̵뤹˥塼롼׷	*/
extern short		ignore_mode;	/* ̵뤹⡼		*/
#ifdef	XOVER
extern short		xover_mode;	/* XOVER ͭå		*/
#endif	/* XOVER */

#ifdef	MIME
extern int	mime_encode_jis();	/* MIME 󥳡(JIS ) */
extern int	mime_decode_euc();	/* MIME ǥ(EUC ) */
#endif	/* MIME */
extern int	to_euc();
extern int	to_jis();

short	japanese = JAPANESE;		/* ܸ⡼ɥե饰		*/
short	gnus_mode = GNUS_MODE;		/* GNUS 饤⡼		*/
short	group_mask = GROUP_MASK;	/* 롼ץޥ⡼		*/
short	news_article_mask = NEWS_ARTICLE_MASK;
					/* ˥塼ޥ⡼	*/
short	mail_article_mask = MAIL_ARTICLE_MASK;
					/* ᡼뵭ޥ⡼	*/
short	news_thread_mode = NEWS_THREAD_MODE;	
					/* ˥塼åɥ⡼	*/
short	mail_thread_mode = MAIL_THREAD_MODE;
					/* ᡼륹åɥ⡼		*/
short	mime_format = MIME_FORMAT;	/* MIME եޥåȽ	*/
short	article_format = ARTICLE_FORMAT;/* եޥå		*/
#ifdef	REF_SORT
short	sort_rule = SORT_RULE;		/* ˡ			*/
#else	/* !REF_SORT */
short	sort_rule = 0;			/* ˡ			*/
#endif	/* !REF_SORT */
short	nspl_mode = NSPL_MODE;		/* NSPL ѥ⡼		*/
#ifdef	UCBMAIL
short	ucbmail_mode = UCBMAIL_MODE;	/* UCB-mail ⡼ɥե饰	*/
#endif	/* UCBMAIL */
#ifdef	RMAIL
short	rmail_mode = RMAIL_MODE;	/* RMAIL ⡼ɥե饰		*/
#endif	/* RMAIL */
#ifdef	MH
short	mh_mode = MH_MODE;		/* MH ⡼ɥե饰		*/
short	mh_mark_mode = MH_MARK_MODE;	/* MH ޡ⡼		*/
short	mh_select_mode = MH_SELECT_MODE;/* MH ư⡼		*/
#endif	/* MH */
#ifdef	BOARD
short	board_mode = BOARD_MODE;	/* BOARD ⡼ɥե饰		*/
#endif	/* BOARD */
short	pager_mode = PAGER_MODE;	/* ڡ㡼⡼		*/
short	quiet_mode = QUIET_MODE;	/* ٹɽ⡼		*/
short	mail_mode = MAIL_MODE;		/* ᡼뻲ѥ⡼		*/
short	error_mode = ERROR_MODE;	/* 顼⡼		*/
short	cross_mark_mode = CROSS_MARK_MODE;/* ݥȻޡ⡼	*/
int	default_code = (int)DEFAULT_CODE;/* Ƚǽδ	*/
#if	defined(NEWSPOST) || defined(MAILSEND)
int	edit_code = (int)EDIT_CODE;	/* ǥ		*/
short	auto_sig_mode = AUTO_SIG_MODE;	/* .signature ưղå⡼	*/
#endif	/* NEWSPOST || MAILSEND */
short	wide_mode = WIDE_MODE;		/* 磻ɥ⡼			*/
short	bell_mode = BELL_MODE;		/* ᡼Υ٥벻⡼	*/
short	x_nsubj_mode = X_NSUBJ_MODE;	/* X-Nsubject: ⡼		*/
short	x_nsubj_org  = X_NSUBJ_MODE;	/* X-Nsubject: ꥸʥ⡼	*/
int	save_code = (int)SAVE_CODE;	/* ִ		*/
int	input_code = (int)INPUT_CODE;	/* 1 ϴ		*/
#ifdef	FCC
int	fcc_code  = (int)FCC_CODE;	/* Fcc: ¸		*/
#endif	/* FCC */
#ifdef	MAILSEND
short	add_cc_mode = ADD_CC_MODE;	/* Cc: ղå⡼		*/
short	mh_alias_mode = MH_ALIAS_MODE;	/* MH ꥢ⡼		*/
#endif	/* MAILSEND */
#ifdef	NEWSPOST
short	add_lines_mode = ADD_LINES_MODE;/* Lines: ղå⡼		*/
short	inews_sig_mode = INEWS_SIG_MODE;/* inews  .signature ⡼	*/
#endif	/* NEWSPOST */
short	jst_mode = JST_MODE;		/* ܻѴ⡼		*/
short	dnas_mode = DNAS_MODE;		/* DNAS б⡼		*/
short	unixfrom_mode = UNIXFROM_MODE;	/* UNIX-From ⡼		*/
short	color_mode = COLOR_MODE;	/* 顼⡼			*/
#if	defined(MH) || defined(RMAIL) || defined(UCBMAIL)
short	auto_inc_mode = AUTO_INC_MODE;	/* ư⡼		*/
#endif	/* MH || RMAIL || UCBMAIL */
#ifndef	SMALL
int	pipe_code = (int)PIPE_CODE;	/* ѥ״		*/
#endif	/* !SMALL */
#ifndef	PAGER
int	last_key = 0;			/* ǸϤ		*/
char	guide_message[SMALL_BUFF];	/* ɥå		*/
#endif	/* !PAGER */
short	color_code[] = {		/* 顼			*/
  TITLE_COLOR_CODE,
  HEADER_COLOR_CODE,
  GUIDE_COLOR_CODE,
  ERROR_COLOR_CODE,
  CATEGORY_COLOR_CODE,
  MARK_COLOR_CODE,
  NUMBER_COLOR_CODE,
  FROM_COLOR_CODE,
  DATE_COLOR_CODE,
  LINE_COLOR_CODE,
  SUBJECT_COLOR_CODE,
  THREAD_COLOR_CODE,
  LOST_COLOR_CODE,
};

#ifdef	JNAMES
char	*jnames_file = JNAMES_DB;	/* JNAMES ǡե	*/
#endif	/* JNAMES */
#ifdef	MAILSEND
char	*send_command = SEND_COMMAND;	/* ᡼ޥ		*/
#endif	/* MAILSEND */
#ifdef	NEWSPOST
char	*post_command = POST_COMMAND;	/* ˥塼ƥޥ		*/
#endif	/* NEWSPOST */
#ifdef	YOUBIN
char	*mail_server_file = MAIL_SERVER_FILE;	/* ͹إХե	*/
#endif	/* YOUBIN */
char	user_name[SMALL_BUFF];		/* 桼̾			*/
char	user_gecos[SMALL_BUFF];		/* 桼			*/
char	home_dir[PATH_BUFF];		/* ۡǥ쥯ȥ		*/
char	dot_dir[PATH_BUFF];		/* ɥåȥǥ쥯ȥ		*/
char	domain_name[SMALL_BUFF];	/* ɥᥤ̾			*/
#ifdef	RESOLVE
struct hostent	*host_ent;		/* ۥȾΥȥ		*/
#endif	/* RESOLVE */
#if	defined(NEWSPOST) || defined(MAILSEND)
char	edit_command[PATH_BUFF];	/* ǥޥ		*/
#endif	/* NEWSPOST || MAILSEND */
#ifdef	NEWSPOST
char	organization[BUFF_SIZE];	/* °				*/
#endif	/* NEWSPOST */
char	mark_file[PATH_BUFF];		/* ޡե		*/
char	tmp_dir[PATH_BUFF];		/* ȥǥ쥯ȥ		*/
char	save_dir[PATH_BUFF];		/* ֥ǥ쥯ȥ	*/
char	pager[PATH_BUFF];		/* ڡ㡼			*/
#ifdef	UCBMAIL
char	ucbmail_mbox[PATH_BUFF];	/* UCB-mail ѥ᡼ܥå	*/
#endif	/* UCBMAIL */
#ifdef	RMAIL
char	rmail_mbox[PATH_BUFF];		/* RMAIL ѥ᡼ܥå	*/
#endif	/*RMAIL */
#ifdef	MH
char	mh_command_path[PATH_BUFF] = MH_COMMAND_PATH;
					/* MH ޥɥѥ		*/
#endif	/* MH */
#if	defined(MH) || defined(RMAIL) || defined(UCBMAIL)
char	*mail_spool = MAIL_SPOOL;	/* MAIL סѥ		*/
char	auto_inc_folder[SMALL_BUFF];	/* ưߥե		*/
#endif	/* MH || RMAIL || UCBMAIL */
#ifdef	BOARD
char	*board_spool = BOARD_SPOOL;	/* BOARD סѥ		*/
#endif	/* BOARD */
#ifdef	FCC
char	mail_fcc_field[PATH_BUFF] = "";/* ᡼   Fcc: ե	*/
char	news_fcc_field[PATH_BUFF] = "";/* ˥塼 Fcc: ե	*/
#endif	/* FCC */
#ifdef	MAILSEND
char	mail_field[BUFF_SIZE] = "";	/* ᡼뼫ưե	*/
char	reply_message[BUFF_SIZE] = "";
					/* ץ饤å		*/
#ifndef	SMALL
char	send_filter[PATH_BUFF] = SEND_FILTER;
					/* ᡼ե륿		*/
#endif	/* !SMALL */
#endif	/* MAILSEND */
#ifdef	NEWSPOST
char	news_field[BUFF_SIZE] = "";	/* ˥塼ưե	*/
#ifndef	SMALL
char	post_filter[PATH_BUFF] = POST_FILTER;
					/* ˥塼ƥե륿		*/
#endif	/* !SMALL */
#endif	/* NEWSPOST */
#if	defined(NEWSPOST) || defined(MAILSEND)
char	follow_message[BUFF_SIZE] = "";
					/* եå		*/
char	reply_indicator[BUFF_SIZE] = REPLY_INDICATOR;
					/* 󥸥			*/
#endif	/* NEWSPOST || MAILSEND */

#ifndef	MSDOS
char	*cons_opt     = CONS_OPT;	/* åȹץ	*/
char	*conf_opt     = CONF_OPT;	/* åꥪץ	*/
char	*arch_opt     = ARCH_OPT;	/* ƥ㥪ץ	*/
char	*install_host = INSTALL_HOST;	/* 󥹥ȡۥ̾		*/
char	*install_user = INSTALL_USER;	/* 󥹥ȡ桼̾		*/
char	*install_date = INSTALL_DATE;	/* 󥹥ȡ		*/
#endif	/* !MSDOS */

int	mime_form_char;			/* MIME եޥåȥ⡼ʸ	*/
int	(*mime_encode_func)();		/* MIME 󥳡ɴؿ		*/
int	(*mime_decode_func)();		/* MIME ǥɴؿ		*/

static struct parameter	{
  char		*name;
  int		type;
  CASTPTR	variable;
} parameter[] = {
  {"gnus_mode",		PARAM_SW_TYPE,		(CASTPTR)&gnus_mode},
  {"group_mask",	PARAM_SW_TYPE,		(CASTPTR)&group_mask},
  {"article_mask",	PARAM_SW_TYPE,		(CASTPTR)&news_article_mask},
  {"news_article_mask",	PARAM_SW_TYPE,		(CASTPTR)&news_article_mask},
  {"mail_article_mask",	PARAM_SW_TYPE,		(CASTPTR)&mail_article_mask},
  {"thread_mode",	PARAM_SW_TYPE,		(CASTPTR)&news_thread_mode},
  {"news_thread_mode",	PARAM_SW_TYPE,		(CASTPTR)&news_thread_mode},
  {"mail_thread_mode",	PARAM_SW_TYPE,		(CASTPTR)&mail_thread_mode},
  {"mail_mode",		PARAM_SW_TYPE,		(CASTPTR)&mail_mode},
  {"error_mode",	PARAM_SW_TYPE,		(CASTPTR)&error_mode},
  {"cross_mark_mode",	PARAM_SW_TYPE,		(CASTPTR)&cross_mark_mode},
  {"quiet_mode",	PARAM_SW_TYPE,		(CASTPTR)&quiet_mode},
  {"japanese_mode",	PARAM_SW_TYPE,		(CASTPTR)&japanese},
  {"pager_mode",	PARAM_SW_TYPE,		(CASTPTR)&pager_mode},
  {"nspl_mode", 	PARAM_SW_TYPE,		(CASTPTR)&nspl_mode},
  {"wide_mode",		PARAM_SW_TYPE,		(CASTPTR)&wide_mode},
  {"bell_mode",		PARAM_SW_TYPE,		(CASTPTR)&bell_mode},
  {"x_nsubj_mode",	PARAM_SW_TYPE,		(CASTPTR)&x_nsubj_org},
  {"jst_mode",		PARAM_SW_TYPE,		(CASTPTR)&jst_mode},
  {"dnas_mode",		PARAM_SW_TYPE,		(CASTPTR)&dnas_mode},
  {"unixfrom_mode",	PARAM_SW_TYPE,		(CASTPTR)&unixfrom_mode},
  {"color_mode",	PARAM_SW_TYPE,		(CASTPTR)&color_mode},
#ifdef	XOVER
  {"xover_mode",	PARAM_SW_TYPE,		(CASTPTR)&xover_mode},
#endif	/* XOVER */
  {"print_code", 	PARAM_CODE_TYPE,	(CASTPTR)&print_code},
  {"save_code", 	PARAM_CODE_TYPE,	(CASTPTR)&save_code},
  {"input_code", 	PARAM_CODE_TYPE,	(CASTPTR)&input_code},
  {"default_code", 	PARAM_CODE_TYPE,	(CASTPTR)&default_code},
#ifdef	UCBMAIL
  {"ucbmail_mode",	PARAM_SW_TYPE,		(CASTPTR)&ucbmail_mode},
  {"ucbmail_mbox",	PARAM_FILE1_TYPE,	(CASTPTR)ucbmail_mbox},
#endif	/* UCBMAIL */
#ifdef	RMAIL
  {"rmail_mode",	PARAM_SW_TYPE,		(CASTPTR)&rmail_mode},
  {"rmail_mbox",	PARAM_FILE1_TYPE,	(CASTPTR)rmail_mbox},
#endif	/*RMAIL */
#ifdef	MH
  {"mh_mode",		PARAM_SW_TYPE,		(CASTPTR)&mh_mode},
  {"mh_mark_mode",	PARAM_SW_TYPE,		(CASTPTR)&mh_mark_mode},
  {"mh_select_mode",	PARAM_SW_TYPE,		(CASTPTR)&mh_select_mode},
#endif	/* MH */
#ifdef	BOARD
  {"board_mode",	PARAM_SW_TYPE,		(CASTPTR)&board_mode},
#endif	/* BOARD */
#if	defined(NEWSPOST) || defined(MAILSEND)
  {"edit_code", 	PARAM_CODE_TYPE,	(CASTPTR)&edit_code},
  {"auto_sig_mode",	PARAM_SW_TYPE,		(CASTPTR)&auto_sig_mode},
  {"edit_command",	PARAM_FILE2_TYPE,	(CASTPTR)edit_command},
#endif	/* NEWSPOST || MAILSEND */
#ifdef	MAILSEND
  {"add_cc_mode",	PARAM_SW_TYPE,		(CASTPTR)&add_cc_mode},
  {"mh_alias_mode",	PARAM_SW_TYPE,		(CASTPTR)&mh_alias_mode},
  {"mail_field",	PARAM_STRING_TYPE,	(CASTPTR)mail_field},
  {"reply_message",	PARAM_FORMAT_TYPE,	(CASTPTR)reply_message},
#ifndef	SMALL
  {"send_filter",	PARAM_FILE2_TYPE,	(CASTPTR)send_filter},
#endif	/* !SMALL */
#endif	/* MAILSEND */
#ifdef	NEWSPOST
  {"inews_sig_mode",	PARAM_SW_TYPE,		(CASTPTR)&inews_sig_mode},
  {"add_lines_mode",	PARAM_SW_TYPE,		(CASTPTR)&add_lines_mode},
  {"news_field",	PARAM_STRING_TYPE,	(CASTPTR)news_field},
#ifndef	SMALL
  {"post_filter",	PARAM_FILE2_TYPE,	(CASTPTR)post_filter},
#endif	/* !SMALL */
#endif	/* NEWSPOST */
#ifndef	SMALL
  {"pipe_code", 	PARAM_CODE_TYPE,	(CASTPTR)&pipe_code},
#endif	/* !SMALL */
  {"pager_command",	PARAM_FILE2_TYPE,	(CASTPTR)pager},
#if	defined(NEWSPOST) || defined(MAILSEND)
  {"follow_message",	PARAM_FORMAT_TYPE,	(CASTPTR)follow_message},
#ifdef	notdef
  {"indicater",		99,			(CASTPTR)reply_indicator},
#endif	/* notdef */
  {"indicator",		PARAM_FORMAT_TYPE,	(CASTPTR)reply_indicator},
#endif	/* NEWSPOST || MAILSEND */
  {"tmp_dir",		PARAM_FILE1_TYPE,	(CASTPTR)tmp_dir},
  {"save_dir",		PARAM_STRING_TYPE,	(CASTPTR)save_dir},
						/* ~/ ŸʤǤ */
#ifdef	FCC
  {"fcc_code", 		PARAM_CODE_TYPE,	(CASTPTR)&fcc_code},
  {"fcc_field",		PARAM_STRING_TYPE,	(CASTPTR)mail_fcc_field},
  {"mail_fcc_field",	PARAM_STRING_TYPE,	(CASTPTR)mail_fcc_field},
  {"news_fcc_field",	PARAM_STRING_TYPE,	(CASTPTR)news_fcc_field},
#endif	/* FCC */
#if	defined(MH) || defined(RMAIL) || defined(UCBMAIL)
  {"auto_inc_mode",	PARAM_SW_TYPE,		(CASTPTR)&auto_inc_mode},
  {"auto_inc_folder",	PARAM_STRING_TYPE,	(CASTPTR)auto_inc_folder},
#endif	/* MH || RMAIL || UCBMAIL */
  {"article_format",	PARAM_NUMBER_TYPE,	(CASTPTR)&article_format},
  {"mime_format",	PARAM_NUMBER_TYPE,	(CASTPTR)&mime_format},
#ifdef	REF_SORT
  {"sort_rule",		PARAM_NUMBER_TYPE,	(CASTPTR)&sort_rule},
#endif	/* REF_SORT */
  {"ignore_groups",	PARAM_GROUP1_TYPE,	(CASTPTR)ignore_groups},
  {"read_groups",	PARAM_GROUP2_TYPE,	(CASTPTR)ignore_groups},
#ifdef	COLOR
  {"color_code",	PARAM_COLOR_TYPE,	(CASTPTR)color_code},
#endif	/* COLOR */
};
#ifndef	MSDOS
static char	delete_char[] = {	/* Gecos ˻ѤȤޤʸ	*/
  ',', '<', '>', '(', ')'
  };
#endif	/* !MSDOS */
static char	*kanji_string = "";
#ifdef	SJIS_SRC
static char	*kanji_code = "\212\277\216\232";
#else	/* !SJIS_SRC */
static char	*kanji_code = "\264\301\273\372";
#endif	/* !SJIS_SRC */

static int	read_config_file();	/* եեΥ꡼	*/
static void	get_organ_file();	/* °եΥ꡼		*/
static void	get_file_env();		/* ե̾δĶ		*/

/*
 * ˥塼ե졼
 */

int	news_config()
{
  char		*env_ptr;
#if	defined(ADD_HOSTNAME) || defined(RESOLVE)
  char		localhost[SMALL_BUFF];
#endif	/* ADD_HOSTNAME || RESOLVE */
#ifndef	DOMAIN_NAME
  FILE		*fp;
  char		*ptr;
#endif	/* !DOMAIN_NAME */
  char		buff[BUFF_SIZE];

#ifdef	NSPL
  if (env_ptr = (char*)getenv(NEWS_SPOOL_ENV)) {
    strcpy(news_spool, env_ptr);
  } else {
    strcpy(news_spool, NEWS_SPOOL);
  }
  if (env_ptr = (char*)getenv(NEWS_LIB_ENV)) {
    strcpy(news_lib, env_ptr);
  } else {
    strcpy(news_lib, NEWS_LIB);
  }
#endif	/* NSPL */
  strcpy(server_file, SERVER_FILE);

  /*
   * ɥᥤ̾
   */

#ifndef	RESOLVE
#ifdef	DOMAIN_NAME
  strcpy(buff, DOMAIN_NAME);
#else	/* !DOMAIN_NAME */
  buff[0] = '\0';
  if (fp = fopen(DOMAIN_FILE, "r")) {
    if (fgets(buff, sizeof(buff), fp)) {
      ptr = buff;
      while (*ptr) {
	if (*ptr == '\n') {
	  *ptr = '\0';
	  break;
	}
	ptr++;
      }
    }
    fclose(fp);
  }
#endif	/* !DOMAIN_NAME */
  if (env_ptr = (char*)getenv(DOMAIN_ENV)) {
    strcpy(buff, env_ptr);
  }
  if (!strlen(buff)) {
    fprintf(stderr,
	    "Instllation problem,default-domain name is not configured.\n");
    return(1);
  }
#endif	/* !RESOLVE */
#if	defined(ADD_HOSTNAME) || defined(RESOLVE)
  if (gethostname(localhost, sizeof(localhost))) {
    fprintf(stderr, "Can't get server host entry.\n");
    localhost[0] = '\0';
    return(1);
  }
#ifdef	RESOLVE
  if (host_ent = gethostbyname(localhost)) {
    sprintf(domain_name, "%s.", host_ent->h_name);
  } else {
    fprintf(stderr, "Can't get local host entry.\n");
    return(1);
  }
#else	/* !RESOLVE */
  sprintf(domain_name, "%s.", localhost);
  strcat(domain_name, buff);
#endif	/* !RESOLVE */
#else	/* !(ADD_HOSTNAME || RESOLVE) */
  strcpy(domain_name, buff);
#endif	/* !(ADD_HOSTNAME || RESOLVE) */

  return(0);
}

/*
 * Ķե졼
 */

int	env_config()
{
  int		i;
  char		*env_ptr;
  char		*ptr;

  if (strcmp(kanji_code, kanji_string)) {
    fprintf(stderr,
	    "Instllation problem,source kanji code mismatch.\n");
    return(1);
  }

  print_code = PRINT_CODE;
  if (env_ptr = (char*)getenv(HOME_ENV)) {
    strcpy(home_dir, env_ptr);
  } else {
#ifdef	MSDOS
    fprintf(stderr, "Can't get %s environment.\n", HOME_ENV);
    exit(1);
#else	/* !MSDOS */
    strcpy(home_dir, passwd->pw_dir);
#endif	/* !MSDOS */
  }
  if (env_ptr = (char*)getenv(DOTDIR_ENV)) {
    strcpy(dot_dir, env_ptr);
  } else {
    strcpy(dot_dir, home_dir);
  }
  if (env_ptr = (char*)getenv(USER_ENV)) {
    strcpy(user_name, env_ptr);
  } else {
#ifdef	MSDOS
    fprintf(stderr, "Can't get %s environment.\n", USER_ENV);
    exit(1);
#else	/* !MSDOS */
    strcpy(user_name, passwd->pw_name);
#endif	/* !MSDOS */
  }
  if (env_ptr = (char*)getenv(PAGER_ENV)) {
    strcpy(pager, env_ptr);
  } else {
    strcpy(pager, EXT_PAGER);
  }
#if	defined(NEWSPOST) || defined(MAILSEND)
  if (env_ptr = (char*)getenv(NAME_ENV)) {
    strcpy(user_gecos, env_ptr);
  } else {
#ifdef	MSDOS
    fprintf(stderr, "Can't get %s environment.\n", NAME_ENV);
    exit(1);
#else	/* !MSDOS */
    ptr = user_gecos;
    env_ptr = passwd->pw_gecos;
    if (*env_ptr == '*') {
      env_ptr++;
    }
    while (*env_ptr) {
      if (*env_ptr == '&') {
	strcpy(ptr, user_name);
	if (islower(*ptr)) {
	  *ptr = toupper(*ptr);
	}
	while (*ptr) {
	  ptr++;
	}
      } else {
	*ptr = *env_ptr;
	for (i = 0; i < sizeof(delete_char); i++) {
	  if (*ptr == delete_char[i]) {
	    *ptr = '\0';
	    break;
	  }
	}
	ptr++;
      }
      env_ptr++;
    }
    *ptr = '\0';
#endif	/* !MSDOS */
  }
  if (env_ptr = (char*)getenv(EDITOR_ENV)) {
    strcpy(edit_command, env_ptr);
  } else {
    strcpy(edit_command, EDITOR_COMMAND);
  }
#endif	/* NEWSPOST || MAILSEND */
#ifdef	NEWSPOST
  if (env_ptr = (char*)getenv(ORGANIZATION_ENV)) {
    strcpy(organization, env_ptr);
  } else {
    organization[0] = '\0';
  }
  get_organ_file();
#endif	/* NEWSPOST */
  if (!(env_ptr = (char*)getenv(MNEWSRC_ENV))) {
    env_ptr = (char*)getenv(NEWSRC_ENV);
  }
  if (env_ptr) {
    if (*env_ptr == SLASH_CHAR) {
      strcpy(mark_file, env_ptr);
    } else {
      sprintf(mark_file, "%s%c%s", dot_dir, SLASH_CHAR, env_ptr);
    }
  } else {
    sprintf(mark_file, "%s%c%s", dot_dir, SLASH_CHAR, MARK_FILE);
  }
  get_file_env(tmp_dir, TMPDIR_ENV, TMP_DIR, 1);
  get_file_env(save_dir, SAVEDIR_ENV, SAVE_DIR, 0);
#ifdef	UCBMAIL
  get_file_env(ucbmail_mbox, MBOX_ENV, MBOX_FILE, 1);
#endif	/* UCBMAIL */
#ifdef	RMAIL
  get_file_env(rmail_mbox, RMAIL_ENV, RMAIL_FILE, 1);
#endif	/*RMAIL */

#ifdef	IGNORE_GROUPS
  ptr = IGNORE_GROUPS;
#else	/* !IGNORE_GROUPS */
#ifdef	READ_GROUPS
  ptr = READ_GROUPS;
  ignore_mode = 1;
#endif	/* READ_GROUPS */
#endif	/* !IGNORE_GROUPS */
#if	defined(IGNORE_GROUPS) || defined(READ_GROUPS)
  env_ptr = ignore_groups;
  while (*ptr) {
    while (*ptr > ' ') {
      *env_ptr++ = *ptr++;
    }
    *env_ptr++ = '\0';	/* SEPARATER */
    while (*ptr && (*ptr <= ' ')) {
      ptr++;
    }
  }
  *env_ptr = '\0';		/* END MARK */
#endif	/* IGNORE_GROUPS || READ_GROUPS */

  i = read_config_file();
  x_nsubj_mode = x_nsubj_org;
#ifndef	PAGER
  pager_mode = 1;
#endif	/* !PAGER */
  return(i ? -1 : 0);
}

static int	read_config_file()
{
  FILE		*fp;
  char		buff[BUFF_SIZE];
  char		*ptr, *ptr2;
  int		line;
  int		status;
  register int	i, j;
#ifdef	COLOR
  int		k;
#endif	/* COLOR */

  line = status = 0;
  fp = NULL;
  sprintf(buff, "%s%c%s-%s", dot_dir, SLASH_CHAR, CONFIG_FILE, nntp_server);
  fp = fopen(buff, "r");
  if (!fp) {
    sprintf(buff, "%s%c%s", dot_dir, SLASH_CHAR, CONFIG_FILE);
    fp = fopen(buff, "r");
  }
  if (fp) {
    while (fgets(buff, sizeof(buff), fp)) {
      line++;
      ptr = buff;
      while (*ptr) {
	if (*ptr == '\n') {
	  *ptr = '\0';
	  break;
	}
	ptr++;
      }
      ptr = buff;
      while ((*ptr == '\t') || (*ptr == ' ')) {
	ptr++;
      }
      if ((*ptr == '#') || (*ptr == '\0')) {
	continue;
      }
      for (i = 0; i < sizeof(parameter) / sizeof(struct parameter); i++) {
	if (!strncasecmp(ptr, parameter[i].name, strlen(parameter[i].name))) {
	  ptr += strlen(parameter[i].name);
	  if (*ptr++ == ':') {
	    while ((*ptr == ' ') || (*ptr == '\t')) {
	      ptr++;
	    }
	    if (((int)strlen(ptr) >= (PATH_BUFF - 1)) &&
		((parameter[i].type == 4) || (parameter[i].type == 5))) {
	      fprintf(stderr, "Line %3d : Too long parameter data.\n", line);
	      status = 1;
	      break;
	    } else {
	      switch (parameter[i].type) {
	      case PARAM_SW_TYPE:	/* ON/OFF 		*/
		if (!strncasecmp(ptr, "on", 2)) {
		  *(short*)parameter[i].variable = 1;
		} else if (!strncasecmp(ptr, "off", 3)) {
		  *(short*)parameter[i].variable = 0;
		} else {
		  fprintf(stderr,
			  "Line %3d : Illegal parameter data.\n", line);
		  status = 1;
		}
		break;
	      case PARAM_CODE_TYPE:	/* ɻ	*/
		switch (*ptr) {
		case 'e':
		case 'E':
		  *(int*)parameter[i].variable = (CASTPTR)EUC_CODE;
		  break;
		case 'j':
		case 'J':
		  *(int*)parameter[i].variable = (CASTPTR)JIS_CODE;
		  break;
		case 's':
		case 'S':
		  *(int*)parameter[i].variable = (CASTPTR)SJIS_CODE;
		  break;
		case 'a':
		case 'A':
		  *(int*)parameter[i].variable = (CASTPTR)ASCII_CODE;
		  break;
		default:
		  fprintf(stderr,
			  "Line %3d : Illegal kanji code specified.\n",
			  line);
		  status = 1;
		  break;
		}
		break;
	      case PARAM_STRING_TYPE:	/* ñʸ		*/
		to_euc((char*)parameter[i].variable, ptr, default_code);
		ptr = (char*)parameter[i].variable;
		while (*ptr) {
		  if (*ptr == '%') {
		    ptr++;
		    if (*ptr != '%') {
		      fprintf(stderr, "Line %3d : Message too complex.\n", line);
		      *(char*)parameter[i].variable = '\0';
		      status = 1;
		      break;
		    } else {
		      ptr++;
		      continue;
		    }
		  }
		  if (*ptr == '\\') {
		    switch (*(ptr + 1)) {
		    case 'n':
		      *ptr++ = '\n';
		      strcpy(ptr, ptr + 1);
		      break;
		    case 't':
		      *ptr++ = '\t';
		      strcpy(ptr, ptr + 1);
		      break;
		    default:
		      ptr += 2;
		      break;
		    }
		  } else {
		    ptr++;
		  }
		}
		break;
#ifdef	notdef
	      case 99:	/* Ѥڥߥθߴݻ	*/
		fprintf(stderr,
			"Line %3d : Notice : Sorry, please fix your setup file.(indicater -> indicator)\n",
			line);
		sleep(1);
#endif	/* notdef */
	      case PARAM_FORMAT_TYPE:	/* üեޥåʸ	*/
		to_euc((char*)parameter[i].variable, ptr, default_code);
		break;
	      case PARAM_FILE1_TYPE:	/* ե/ǥ쥯ȥ̾(HOME)*/
		if (*ptr == SLASH_CHAR) {
		  strcpy((char*)parameter[i].variable, ptr);
		} else if (!strncmp(ptr, "~/", 2)) {
		  sprintf((char*)parameter[i].variable, "%s%c%s", home_dir,
			  SLASH_CHAR, ptr + 2);
		} else {
#ifdef	MSDOS
		  strcpy((char*)parameter[i].variable, ptr);
#else	/* !MSDOS */
		  sprintf((char*)parameter[i].variable, "%s%c%s", home_dir,
			  SLASH_CHAR, ptr);
#endif	/* !MSDOS */
		}
		break;
	      case PARAM_FILE2_TYPE:	/* ե̾/ǥ쥯ȥ̾(PATH)*/
		strcpy((char*)parameter[i].variable, ptr);
		break;
	      case PARAM_NUMBER_TYPE:	/* 			*/
		j = atoi(ptr);
		if ((j >= 0) && (j < 3)) {
		  *(short*)parameter[i].variable = atoi(ptr);
		} else {
		  fprintf(stderr,
			  "Line %3d : Illegal parameter data.\n", line);
		  status = 1;
		}
		break;
	      case PARAM_GROUP1_TYPE:	/* ̵뤹˥塼롼׷	*/
		ignore_mode = -1;
	      case PARAM_GROUP2_TYPE:	/* ̵뤷ʤ˥塼롼׷	*/
		ignore_mode++;
		ptr2 = (char*)parameter[i].variable;
		while (*ptr) {
		  while (*ptr > ' ') {
		    *ptr2++ = *ptr++;
		  }
		  *ptr2++ = '\0';	/* SEPARATER */
		  while (*ptr && (*ptr <= ' ')) {
		    ptr++;
		  }
		}
		*ptr2 = '\0';		/* END MARK */
		break;
#ifdef	COLOR
	      case PARAM_COLOR_TYPE:	/* 顼		*/
		for (j = 0; j < (sizeof(color_code) / sizeof(short)); j++) {
		  while (*ptr && (*ptr <= ' ')) {
		    ptr++;
		  }
		  if (isdigit(*ptr)) {
		    k = *ptr++ - '0';
		    if (j < 4) {
		      if (k < 8) {
			color_code[j] = BG_BLACK_ATTRIB + k;
		      } else {
			color_code[j] = REVERSE_ATTRIB;
		      }
		    } else {
		      if (k < 8) {
			color_code[j] = FG_BLACK_ATTRIB + k;
		      } else {
			color_code[j] = RESET_ATTRIB;
		      }
		    }
		  } else {
		    status = 1;
		  }
		  if (status) {
		    fprintf(stderr,
			    "Line %3d : Illegal color code specified.\n",
			    line);
		    break;
		  }
		}
		break;
#endif	/* COLOR */
	      default:
		break;
	      }
	      i = -1;
	    }
	  } else {
	    fprintf(stderr, "Line %3d : Syntax error.\n", line);
	    status = 1;
	  }
	  break;
	}
      }
      if (i >= 0) {
	fprintf(stderr, "Line %3d : Illegal or restricted parameter name.\n",
		line);
	status = 1;
      }
    }
    fclose(fp);
  }
  if (article_format > 2) {
    article_format = 0;
  }
  return(status);
}

#ifdef	NEWSPOST
/*
 * °եΥ꡼
 */

static void	get_organ_file()
{
  FILE		*fp;
  char		organ_file[PATH_BUFF];
  char		*ptr;
  int		code;

  if (organization[0]) {
    switch (organization[0]) {
    case '~':
      sprintf(organ_file, "%s%s", dot_dir, &organization[1]);
      break;
    case SLASH_CHAR:
      strcpy(organ_file, organization);
      break;
    default:
#ifdef	MSDOS
      strcpy(organ_file, organization);
#else	/* !MSDOS */
      sprintf(organ_file, "%s%c%s", dot_dir, SLASH_CHAR, organization);
#endif	/* !MSDOS */
      break;
    }
  } else {
    strcpy(organ_file, ORGAN_FILE);
  }
  if (fp = fopen(organ_file, "r")) {
    ptr = organization;
    while (1) {
      code = getc(fp);
      if ((code == '\n') || (code == EOF) || (!code)) {
	break;
      }
      *ptr++ = code;
    }
    *ptr = '\0';
    fclose(fp);
  }
}
#endif	/* NEWSPOST */

/*
 * ե̾δĶ
 */

static void	get_file_env(ptr, env, value, mode)
     char	*ptr;
     char	*env;
     char	*value;
     int	mode;	/* 0:~/ Ÿʤ 0ʳ:~/ Ÿ */
{
  char	*env_ptr;

  if (env_ptr = (char*)getenv(env)) {
    value = env_ptr;
  }
  if (*value == SLASH_CHAR) {
    strcpy(ptr, value);
  } else if (!strncmp(value, "~/", 2)) {
    if (mode) {
      sprintf(ptr, "%s%c%s", home_dir, SLASH_CHAR, value + 2);
    } else {
      strcpy(ptr, value);
    }
  } else {
#ifdef	MSDOS
    strcpy(ptr, value);
#else	/* !MSDOS */
    sprintf(ptr, "%s%c%s", home_dir, SLASH_CHAR, value);
#endif	/* !MSDOS */
  }
}

/*
 * ߡ⥸塼뷲
 */

#ifndef	NEWSPOST
int	news_post()
{
  return(1);
}

int	news_follow()
{
}

int	news_cancel()
{
}
#endif	/* !NEWSPOST */

#ifndef	MAILSEND
int	mail_send()
{
  return(1);
}

int	mail_reply()
{
  return(1);
}

int	mail_forward()
{
  return(1);
}
#endif	/* !MAILSEND */

#ifndef	JNAMES
int	jnOpen()
{
  return(-2);
}

int	jnClose()
{
  return(0);
}

unsigned char	*jnFetch()
{
  return(NULL);
}
#endif	/* !JNAMES */

#ifndef	MH
int	mh_init()
{
  return(0);
}

int	mh_menu()
{
  return(0);
}

int	save_mh_folder()
{
  return(1);
}
#endif	/* !MH */

#ifndef	UCBMAIL
int	ucbmail_init()
{
  return(0);
}

int	ucbmail_menu()
{
  return(0);
}
#endif	/* !UCBMAIL */

#ifndef	RMAIL
int	rmail_init()
{
  return(0);
}

int	rmail_menu()
{
  return(0);
}
#endif	/* !RMAIL */

#ifndef	BOARD
int	board_init()
{
  return(0);
}

int	board_menu()
{
  return(0);
}
#endif	/* !BOARD */

#ifndef	PAGER
int	view_file()
{
  return(1);
}
#endif	/* !PAGER */

#ifndef	FCC
int	fcc_save()
{
  return(1);
}
#endif	/* FCC */

/*
 * MIME 󥳡/ǥɴؿϿ
 */

void	set_mime_decode_func()
{
  static char	mime_char[] = "-mM";

#ifdef	MIME
  if (mime_format == 2) {
    mime_encode_func = mime_encode_jis;
  } else {
#ifdef	EUC_SPOOL
    mime_encode_func = (int (*)())to_euc;
#else	/* !EUC_SPOOL */
    mime_encode_func = (int (*)())to_jis;
#endif	/* !EUC_SPOOL */
  }
  if (mime_format) {
    mime_decode_func = mime_decode_euc;
  } else {
    mime_decode_func = (int (*)())to_euc;
  }
#else	/* !MIME */
#ifdef	EUC_SPOOL
  mime_encode_func = (int (*)())to_euc;
#else	/* !EUC_SPOOL */
  mime_encode_func = (int (*)())to_jis;
#endif	/* !EUC_SPOOL */
  mime_decode_func = (int (*)())to_euc;
#endif	/* !MIME */
  mime_form_char = (int)mime_char[mime_format];
}

/*
 * Υ⡼ɥ顼
 */

void	setup_mono()
{
  register int	i;

  for (i = 0; i < (sizeof(color_code) / sizeof(short)); i++) {
    color_code[i] = (i < 4) ? REVERSE_ATTRIB : RESET_ATTRIB;
  }
}

/*
 * Message-ID 
 * <YYMMDDhhmmss.MCNTpid@host.domain>
 */

#if	defined(MAILSEND) || defined(NEWSPOST)
#ifdef	ADD_MESSAGE_ID
void	create_msg_id(ptr)
     char	*ptr;
{
  static int	cnt = 0;
  struct tm	*tm;
  time_t	now_time;
  char		buff[SMALL_BUFF];

  now_time = time(NULL);
  tm = localtime(&now_time);
  strcpy(buff, domain_name);
#ifndef	ADD_HOSTNAME
  if (gethostname(buff, sizeof(buff))) {
    print_fatal("Can't get server host entry.");
  } else {
    strcat(buff, ".");
    strcat(buff, domain_name);
  }
#endif	/* !ADD_HOSTNAME */
  sprintf(ptr, "%s <%02d%02d%02d%02d%02d%02d.M%02d%05d@%s>\n",
	  MESSAGE_FIELD, tm->tm_year % 100, tm->tm_mon + 1, tm->tm_mday,
	  tm->tm_hour, tm->tm_min, tm->tm_sec, ++cnt % 100, getpid(), buff);
}
#endif	/* ADD_MESSAGE_ID */
#endif	/* MAILSEND || NEWSPOST */
