/*
 *
 *  Ѵ饤֥
 *
 *  Copyright 1990-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Kanji Convert Library
 *  Sub system  : library define
 *  File        : kanjilib.h
 *  Version     : 2.06
 *  First Edit  : 1990-11/01
 *  Last  Edit  : 1995-06/14
 *  Author      : MSR24  
 *
 */

/*
 * 
 */

typedef enum {
  ASCII_CODE,
  JIS_CODE,
  SJIS_CODE,
  EUC_CODE,
  UNKNOWN_CODE,
} KANJICODE;

/*
 * ʸå
 */

typedef enum {
  ROMAN_CHAR = 0,
  KANA_CHAR,
  KANJI_CHAR,
  HOJO_CHAR,
} CHARSET;

#ifndef	BUFF_SIZE
#define BUFF_SIZE	1024
#endif	/* BUFF_SIZE */

#define	ESC_CODE	'\033'

/*
 * JIS ؼ
 */

#define	JIS_IN1		"\033$@"	/* JIS X0208-1978 */
#define	JIS_IN2		"\033$B"	/* JIS X0208-1983 */
#define	JIS_IN3		"\033$(B"	/* JIS X0208-1983 */
#define	JIS_X0201	"\033(I"	/* JIS X0201() */
#define	JIS_X0212	"\033$(D"	/* JIS X0212-1990() */
#define	JIS_IN		JIS_IN2

/*
 * JIS ޻ؼ
 */

#define	JIS_OUT1	"\033(J"	/* JIS X0201-1976 (left-hand part) */
#define	JIS_OUT2	"\033(B"	/* ASCII */
#define	JIS_OUT3	"\033(H"	/* ̤ */
#define	JIS_OUT		JIS_OUT2

/*
 * ESC  JIS ؼ/޻ؼ
 */

#define	DJIS_IN1	"$@"		/* JIS X0208-1978	*/
#define	DJIS_IN2	"$B"		/* JIS X0208-1983	*/
#define	DJIS_IN3	"$(B"		/* JIS X0208-1983	*/
#define	DJIS_X0201	"(I"		/* JIS X0201()	*/
#define	DJIS_X0212	"$(D"		/* JIS X0212-1990() */
#define	DJIS_OUT1	"(J"		/* JIS X0201-1976 (left-hand part) */
#define	DJIS_OUT2	"(B"		/* ASCII */
#define	DJIS_OUT3	"(H"		/* ̤ */

/*
 * EUC ɥå
 */

#define	EUC_SS2		0x8e		/* JIS X0201()	*/
#define	EUC_SS3		0x8f		/* JIS X0212()	*/

extern KANJICODE	print_code;		/* ɽ	*/
extern char		*kanji_code_string[];	/* ̾		*/
extern char		jis_in[];		/* ؼ	*/
extern char		jis_out[];		/* ޻ؼ	*/
extern int		jis_in_len;
extern int		jis_out_len;

extern void	jis_mode();		/* 饤֥		*/
extern void	jis_to_sjis();		/* JISSJIS Ѵ		*/
extern void	jis_to_euc();		/* JISEUC Ѵ		*/
extern void	euc_to_jis();		/* EUCJIS Ѵ		*/
extern void	euc_to_sjis();		/* EUCSJIS Ѵ		*/
extern void	sjis_to_jis();		/* SJISJIS Ѵ		*/
extern void	sjis_to_euc();		/* SJISEUC Ѵ		*/
extern void	jis_to_jis();		/* JISJIS Ѵ(ESC)	*/
extern int	jis_strncpy();		/* JIS ʸ󥳥ԡ() */
extern int	euc_strncpy();		/* EUC ʸ󥳥ԡ() */
extern int	sjis_strncpy();		/* SJIS ʸ󥳥ԡ()*/
extern int	jis_strncpy2();		/* JIS ʸ󥳥ԡ() */
extern int	euc_strncpy2();		/* EUC ʸ󥳥ԡ() */
extern int	sjis_strncpy2();	/* SJIS ʸ󥳥ԡ()*/
#if	defined(__STDC__) && !defined(DONT_HAVE_DOPRNT)
extern void	jis_printf(char*, ...);	/* JIS ʸɽ		*/
extern void	euc_printf(char*, ...);	/* EUC ʸɽ		*/
extern void	sjis_printf(char*, ...);/* SJIS ʸɽ		*/
extern void	jis_fprintf(FILE*, char*, ...);
					/* JIS ʸ		*/
extern void	euc_fprintf(FILE*, char*, ...);
					/* EUC ʸ		*/
extern void	sjis_fprintf(FILE*, char*, ...);
					/* SJIS ʸ		*/
#else	/* !__STDC__ && !DONT_HAVE_DOPRNT) */
extern void	jis_printf();		/* JIS ʸɽ		*/
extern void	euc_printf();		/* EUC ʸɽ		*/
extern void	sjis_printf();		/* SJIS ʸɽ		*/
extern void	jis_fprintf();		/* JIS ʸ		*/
extern void	euc_fprintf();		/* EUC ʸ		*/
extern void	sjis_fprintf();		/* SJIS ʸ		*/
#endif	/* !__STDC__ && !DONT_HAVE_DOPRNT) */
extern KANJICODE discriminate_code();	/* Ƚ		*/
extern KANJICODE discriminate_code2();	/* Ƚ		*/
extern KANJICODE to_sjis();		/* ưȽ̢SJIS ʸѴ	*/
extern KANJICODE to_euc();		/* ưȽ̢EUC ʸѴ	*/
extern KANJICODE to_jis();		/* ưȽ̢JIS ʸѴ	*/
extern int	kanji_strncpy();	/* ʸ󥳥ԡ()	*/
extern int	kanji_strcpy2();	/* ʸ󥳥ԡ()	*/
extern int	kanji_strncpy2();	/* ʸ󥳥ԡ(PAD)	*/
extern int	kanji_strlen();		/* ʸ󥫥		*/
#if	defined(__STDC__) && !defined(DONT_HAVE_DOPRNT)
extern void	kanji_printf(int,char*, ...);
					/* ʸɽ		*/
extern void	kanji_fprintf(int,FILE*, char*, ...);
					/* ʸ		*/
#else	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
extern void	kanji_printf();		/* ʸɽ		*/
extern void	kanji_fprintf();	/* ʸ		*/
#endif	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
#ifdef	MNEWS
void		recover_jis();		/* ESC  JIS ʸ	*/
#endif	/* MNEWS */
