/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : Mail send routine
 *  File        : mailsend.c
 *  Version     : 1.19
 *  First Edit  : 1992-07/29
 *  Last  Edit  : 1995-07/17
 *  Author      : MSR24  
 *
 */

#ifdef	MAILSEND
#include	"compat.h"
#include	"nntplib.h"
#include	"mnews.h"
#include	"article.h"
#include	"kanjilib.h"
#include	"termlib.h"
#include	"mailsend.h"
#include	"mh.h"
#include	"pager.h"
#include	"fcc.h"
#include	"mime.h"

static int	exec_send();		/* ᡼(̴ؿ)		*/
static int	expand_field();		/* ꥢŸ(̴ؿ)	*/
static int	ucbmail_expand_alias();	/* ꥢŸ(̴ؿ)	*/
#ifdef	notdef
static int	mh_expand_alias();	/* ꥢŸ(̴ؿ)	*/
#endif	/* notdef */

/*
 * ᡼
 */

int	mail_send(adrs, folder)
     char	*adrs;
     char	*folder;
{
  FILE	*fp;
  char	tmp_file[PATH_BUFF];
  char	backup_file[PATH_BUFF];
  char	to_buff[MAX_FIELD_LEN];
  char	cc_buff[MAX_FIELD_LEN];
  char	subject_buff[MAX_FIELD_LEN];
  int	first;
  int	status;

#ifdef	SEND_CONFIRM
  if (!yes_or_no(NORMAL_YN_MODE, "ȯޤ?",
		 "Send new article.Are you sure?")) {
    return(1);
  }
#endif	/* SEND_CONFIRM */
  strcpy(to_buff, adrs);
  input_line(INPUT_SPCCUT_MASK, "簸(to)ϤƲ:",
	     "Input recipient(to) address:", to_buff);
  if (!to_buff[0]) {
    return(1);
  }
  if (add_cc_mode) {
    sprintf(cc_buff, "%s@%s", user_name, domain_name);
  } else {
    cc_buff[0] = '\0';
  }
  input_line(INPUT_SPCCUT_MASK, "ԡ(cc)ϤƲ:",
	     "Input carbon copy(cc) address:", cc_buff);
  subject_buff[0] = '\0';
  input_line(0, "̾(subject)ϤƲ:",
	     "Input subject:", subject_buff);
  sprintf(tmp_file, "%s%c%s", dot_dir, SLASH_CHAR, MESSAGE_FILE);
  create_backup_name(backup_file, tmp_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  rename(tmp_file, backup_file);
  if ((fp = fopen(tmp_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open mail write file.");
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  if (mail_field[0]) {
    edit_fprintf(fp, "%s\n", mail_field);
  }
  fprintf(fp, "%s %s\n", TO_FIELD, to_buff);
  fprintf(fp, "%s %s\n", CC_FIELD, cc_buff);
  fprintf(fp, "%s \n", BCC_FIELD);
  edit_fprintf(fp, "%s %s\n", SUBJECT_FIELD, subject_buff);
  if (x_nsubj_mode) {
    if (discriminate_code(subject_buff) != ASCII_CODE) {
      fprintf(fp, "%s %s\n", X_NSUBJ_FIELD, subject_buff);
    } else {
      fprintf(fp, "%s \n", X_NSUBJ_FIELD);
    }
  }
#ifdef	FCC
  if (mail_fcc_field[0]) {
    edit_fprintf(fp, "%s %s\n", FCC_FIELD, mail_fcc_field);
  }
#endif	/* FCC */
  fprintf(fp, "%s\n", TEXT_SEPARATER);
  fclose(fp);
  first = 1;
 EDIT:
  if (!exec_editor(tmp_file, first)) {
    first = 0;
    while (1) {
      if ((status = exec_send(tmp_file, folder)) != -3) {
	break;
      }
    }
    if (status) {
      if (status > 0) {
	print_mode_line(japanese ? "᡼˼Ԥޤ" :
			"Send mail failed.");
	term_bell();
	sleep(ERROR_SLEEP);
      } else if (status == -2) {
	goto EDIT;
      }
      return(1);
    }
    return(0);
  }
  return(1);
}

/*
 * ᡼ֿ
 */

int	mail_reply(base_file, mask, folder, adrs)
     char	*base_file;
     int	mask;
     char	*folder;
     char	*adrs;
{
  FILE			*fp1, *fp2;
  char			tmp_file[PATH_BUFF];
  char			backup_file[PATH_BUFF];
  char			buff1[BUFF_SIZE];
  char			buff2[BUFF_SIZE];
  static char		from_buff[MAX_FIELD_LEN];
  static char		date_buff[MAX_FIELD_LEN];
  static char		message_buff[MAX_FIELD_LEN];
  static char		subject_buff[MAX_FIELD_LEN];
  static char		to_buff[MAX_FIELD_LEN * 5];
  static char		cc_buff[MAX_FIELD_LEN * 5];
  static char		group_buff[MAX_FIELD_LEN];
  static char		app_buff[MAX_FIELD_LEN * 5];
  static char		reply_buff[MAX_FIELD_LEN];
  static char		x_nsubj_buff[MAX_FIELD_LEN];
  static struct cpy_hdr	reply_fields[] = {
    {FROM_FIELD,	from_buff,	sizeof(from_buff)},
    {DATE_FIELD,	date_buff,	sizeof(date_buff)},
    {MESSAGE_FIELD,	message_buff,	sizeof(message_buff)},
    {SUBJECT_FIELD,	subject_buff,	sizeof(subject_buff)},
    {TO_FIELD,		to_buff,	sizeof(to_buff)},
    {CC_FIELD,		cc_buff,	sizeof(cc_buff)},
    {GROUP_FIELD,	group_buff,	sizeof(group_buff)},
    {APP_TO_FIELD,	app_buff,	sizeof(app_buff)},
    {REPLY_FIELD,	reply_buff,	sizeof(reply_buff)},
    {X_NSUBJ_FIELD,	x_nsubj_buff,	sizeof(x_nsubj_buff)},
  };
  char			*ptr1, *ptr2;
  int			first;
  int			status;
  int			length;

#ifdef	SEND_CONFIRM
  if (!yes_or_no(NORMAL_YN_MODE, "ֿޤ?",
		 "Send reply article.Are you sure?")) {
    return(1);
  }
#endif	/* SEND_CONFIRM */
  print_mode_line(japanese ? "ѴǤ" : "Converting.");
  if ((fp1 = fopen(base_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't open mail read file.");
    return(1);
  }
  sprintf(tmp_file, "%s%c%s", dot_dir, SLASH_CHAR, MESSAGE_FILE);
  create_backup_name(backup_file, tmp_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  rename(tmp_file, backup_file);
  if ((fp2 = fopen(tmp_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open mail write file.");
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  if (mail_field[0]) {
    edit_fprintf(fp2, "%s\n", mail_field);
  }
  copy_fields(fp1, reply_fields,
	      sizeof(reply_fields)/sizeof(struct cpy_hdr),
	      CF_CLR_MASK | CF_GET_MASK | CF_ADD_MASK | CF_SPC_MASK);
  if (!to_buff[0]) {
    strcpy(to_buff, app_buff);
  }
  if (!reply_buff[0]) {
    strcpy(reply_buff, from_buff);
  }
  ptr1 = reply_buff;
  ptr2 = buff1;
  while (*ptr1) {
    if (ptr2 != buff1) {
      *ptr2++ = ',';
      *ptr2++ = ' ';
    }
    ptr1 = get_real_adrs(ptr1, ptr2);
    while (*ptr2) {
      ptr2++;
    }
  }
  strcpy(reply_buff, buff1);
  sprintf(buff2, "%s@%s", user_name, domain_name);
  ptr1 = to_buff;
  if (mask & FOLLOW_BOARD_MASK) {	/* ܡɥե⡼ */
    fprintf(fp2, "%s %s\n", TO_FIELD, adrs);
    fprintf(fp2, "%s ", CC_FIELD);
  } else if (mask & REPLY_BOARD_MASK) {	/* ܡɥץ饤⡼	*/
    fprintf(fp2, "%s %s\n", TO_FIELD, reply_buff);
    fprintf(fp2, "%s ", CC_FIELD);
    if (add_cc_mode) {
      fprintf(fp2, "%s", buff2);
    }
  } else {				/* ̾Υץ饤⡼	*/
    fprintf(fp2, "%s %s\n", TO_FIELD, reply_buff);
    length = fprintf(fp2, "%s ", CC_FIELD);
    status = 0;
    first = -1;
    while (status < 3) {
      ptr2 = get_real_adrs(ptr1, buff1);
      ptr1 = buff1;
      
      /*
       * Cc: ʬ To: ʤ Cc: ˲äΤФ
       */
      
      if (*ptr1) {
	if ((strcmp(ptr1, buff2) && strcmp(ptr1, user_name) &&
	     strcmp(ptr1, reply_buff)) || (status > 1)) {
	  if (first == -1) {
	    first++;
	  } else {
	    if ((length + (int)strlen(ptr1)) >= MAX_FIELD_COLUMN) {
	      if (++first % 4) {
		fprintf(fp2, ",\n\t");
		length = 8;		/* TAB column */
	      } else {
		fputc('\n', fp2);
		length = fprintf(fp2, "%s ", CC_FIELD);
	      }
	    } else {
	      length += fprintf(fp2, ", ");
	    }
	  }
	  length += fprintf(fp2, "%s", ptr1);
	}
      }
      ptr1 = ptr2;
      if (!(*ptr1)) {
	switch (status++) {
	case 0:		/* Cc: ɥ쥹 Cc: եɤ­ */
	  ptr1 = cc_buff;
	  break;
	case 1:		/* ʬΥɥ쥹 Cc: եɤκǸ­ */
	  if (add_cc_mode) {
	    ptr1 = buff2;
	  }
	  break;
	default:
	  break;
	}
      }
    }
  }
  fprintf(fp2, "\n%s \n", BCC_FIELD);
  strcpy(buff1, subject_buff);
  mime_decode_func(subject_buff, buff1, default_code);
  if (strncasecmp(subject_buff, REPLY_SUBJECT, sizeof(REPLY_SUBJECT) - 1)) {
    edit_fprintf(fp2, "%s %s%s\n", SUBJECT_FIELD, REPLY_SUBJECT, subject_buff);
  } else {
    edit_fprintf(fp2, "%s %s\n", SUBJECT_FIELD, subject_buff);
  }
  if (x_nsubj_mode) {
    if (x_nsubj_buff[0]) {
      recover_jis(subject_buff, x_nsubj_buff);
    } else {
      subject_buff[0] = '\0';
    }
    if (strncasecmp(subject_buff, REPLY_SUBJECT, sizeof(REPLY_SUBJECT) - 1)
	&& subject_buff[0]) {
      edit_fprintf(fp2, "%s %s%s\n", X_NSUBJ_FIELD, REPLY_SUBJECT,
		   subject_buff);
    } else {
      edit_fprintf(fp2, "%s %s\n", X_NSUBJ_FIELD, subject_buff);
    }
  }
  if (message_buff[0]) {
    fprintf(fp2, "%s %s%s.\n\t%s\n", IN_REPLY_FIELD, REPLY_MESSAGE,
	    date_buff, message_buff);
  }
#ifdef	FCC
  if (mail_fcc_field[0]) {
    fprintf(fp2, "%s %s\n", FCC_FIELD, mail_fcc_field);
  }
#endif	/* FCC */
  fprintf(fp2, "%s\n", TEXT_SEPARATER);
  if (mask & REPLY_QUOTE_MASK) {	/* 	*/
    fseek(fp1, 0L, 0);
    while (1) {
      copy_fields(fp1, reply_fields,
		  sizeof(reply_fields)/sizeof(struct cpy_hdr),
		  CF_CLR_MASK | CF_GET_MASK | CF_ADD_MASK | CF_SPC_MASK);
      if (feof(fp1)) {
	break;
      }
      ptr1 = NULL;
      if (group_buff[0]) {
	if (follow_message[0]) {
	  ptr1 = follow_message;
	}
      } else {
	if (reply_message[0]) {
	  ptr1 = reply_message;
	}
      }
      if (!ptr1) {
	ptr1 = (japanese ? "%Iεˤ\n%F{,}Ͻ񤭤ޤ\n" :
		"In article %I\n%F writes:\n");
      }
      field_fprintf(fp2, ptr1,
		    from_buff, subject_buff, message_buff,
		    group_buff, date_buff);
      fprintf(fp2, "\n");
      while (fgets(buff1, sizeof(buff1), fp1)) {
	if (!strcmp(buff1, MULTI_END_MARK)) {
	  fprintf(fp2, "\n");
	  break;
	}
	field_fprintf(fp2, reply_indicator,
		      from_buff, subject_buff, message_buff,
		      group_buff, date_buff);
	to_euc(buff2, buff1, default_code);
	edit_fprintf(fp2, "%s", buff2);
      }
      if (feof(fp1)) {
	break;
      }
    }
  }
  fclose(fp1);
  fclose(fp2);
  first = 1;
 EDIT:
  if (!exec_editor(tmp_file, first)) {
    first = 0;
    while (1) {
      if ((status = exec_send(tmp_file, folder)) != -3) {
	break;
      }
    }
    if (status) {
      if (status > 0) {
	print_mode_line(japanese ? "᡼ֿ˼Ԥޤ" :
			"Send reply mail failed.");
	term_bell();
	sleep(ERROR_SLEEP);
      } else if (status == -2) {
	goto EDIT;
      }
      return(1);
    }
    return(0);
  }
  return(1);
}

/*
 * ᡼ž
 */

int	mail_forward(base_file, folder)
     char	*base_file;
     char	*folder;
{
  FILE			*fp1, *fp2;
  char			tmp_file[PATH_BUFF];
  char			backup_file[PATH_BUFF];
  char			buff1[BUFF_SIZE];
  char			buff2[BUFF_SIZE];
  static char		to_buff[MAX_FIELD_LEN];
  static char		cc_buff[MAX_FIELD_LEN];
  static char		from_buff[MAX_FIELD_LEN];
  static char		subject_buff[MAX_FIELD_LEN];
  static char		x_nsubj_buff[MAX_FIELD_LEN];
  static struct cpy_hdr	forward_fields[] = {
    {FROM_FIELD,	from_buff,	sizeof(from_buff)},
    {SUBJECT_FIELD,	subject_buff,	sizeof(subject_buff)},
    {X_NSUBJ_FIELD,	x_nsubj_buff,	sizeof(x_nsubj_buff)},
  };
  int			status;

#ifdef	SEND_CONFIRM
  if (!yes_or_no(NORMAL_YN_MODE, "žޤ?",
		 "Forward article.Are you sure?")) {
    return(1);
  }
#endif	/* SEND_CONFIRM */
  to_buff[0] = cc_buff[0] = '\0';
  input_line(INPUT_SPCCUT_MASK, "簸(to)ϤƲ:",
	     "Input recipient(to) address:", to_buff);
  if (!to_buff[0]) {
    return(1);
  }
  input_line(INPUT_SPCCUT_MASK, "ԡ(cc)ϤƲ:",
	     "Input carbon copy(cc) address:", cc_buff);
  print_mode_line(japanese ? "ѴǤ" : "Converting.");
  if ((fp1 = fopen(base_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't open mail read file.");
    return(1);
  }
  sprintf(tmp_file, "%s%c%s", dot_dir, SLASH_CHAR, MESSAGE_FILE);
  create_backup_name(backup_file, tmp_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  rename(tmp_file, backup_file);
  if ((fp2 = fopen(tmp_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open mail write file.");
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  if (mail_field[0]) {
    fprintf(fp2, "%s\n", mail_field);
  }
  copy_fields(fp1, forward_fields,
	       sizeof(forward_fields)/sizeof(struct cpy_hdr),
	       CF_CLR_MASK | CF_GET_MASK);
  fprintf(fp2, "%s %s\n", TO_FIELD, to_buff);
  fprintf(fp2, "%s %s\n", CC_FIELD, cc_buff);
  fprintf(fp2, "%s \n", BCC_FIELD);
  get_real_adrs(from_buff, buff1);
  mime_decode_func(buff2, subject_buff, default_code);
  edit_fprintf(fp2, "%s [%s: %s]\n", SUBJECT_FIELD, buff1, buff2);
  if (x_nsubj_mode && x_nsubj_buff[0]) {
    recover_jis(subject_buff, x_nsubj_buff);
    to_euc(buff2, subject_buff, default_code);
    edit_fprintf(fp2, "%s [%s: %s]\n", X_NSUBJ_FIELD, buff1, buff2);
  }
#ifdef	FCC
  if (mail_fcc_field[0]) {
    fprintf(fp2, "%s %s\n", FCC_FIELD, mail_fcc_field);
  }
#endif	/* FCC */
  fprintf(fp2, "%s\n", TEXT_SEPARATER);
  fprintf(fp2, "%s\n\n", FORWARD_BEGIN_MESSAGE);
  fseek(fp1, 0L, 0);
  while (fgets(buff1, sizeof(buff1), fp1)) {
    to_euc(buff2, buff1, default_code);
    edit_fprintf(fp2, "%s", buff2);
  }
  fprintf(fp2, "\n%s\n", FORWARD_END_MESSAGE);
  fclose(fp1);
  fclose(fp2);
 EDIT:
  if (!exec_editor(tmp_file, 0)) {
    while (1) {
      if ((status = exec_send(tmp_file, folder)) != -3) {
	break;
      }
    }
    if (status) {
      if (status > 0) {
	print_mode_line(japanese ? "᡼ž˼Ԥޤ" :
			"Forward mail failed.");
	term_bell();
	sleep(ERROR_SLEEP);
      } else if (status == -2) {
	goto EDIT;
      }
      return(1);
    }
    return(0);
  }
  return(1);
}

/*
 * ᡼(̴ؿ)
 */

static int	exec_send(base_file, folder)
     char	*base_file;
     char	*folder;
{
  static char	from_buff[MAX_FIELD_LEN];
  static char	date_buff[MAX_FIELD_LEN];
#ifdef	FCC
  static char	fcc_buff[MAX_FIELD_LEN];
#endif	/* FCC */
  char		tmp_file1[PATH_BUFF];
  char		tmp_file2[PATH_BUFF];
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		buff3[BUFF_SIZE];
  char		buff4[BUFF_SIZE];
  char		field[SMALL_BUFF];
  FILE		*fp1, *fp2;
  static struct cpy_hdr send_fields[] = {
    {FROM_FIELD,	from_buff,	SF_FROM_MASK},
    {DATE_FIELD,	date_buff,	SF_ETC_MASK},
    {SUBJECT_FIELD,	NULL,		SF_SUBJ_MASK},
    {TO_FIELD,		NULL,		SF_TO_MASK | SF_EXPAND_MASK},
    {CC_FIELD,		NULL,		SF_CC_MASK | SF_EXPAND_MASK},
    {BCC_FIELD,		NULL,		SF_BCC_MASK | SF_EXPAND_MASK},
    {X_NSUBJ_FIELD,	NULL,		SF_THROUGH_MASK},
#ifdef	FCC
    {FCC_FIELD,		fcc_buff,	SF_DELETE_MASK},
#endif	/* FCC */
#ifdef	MIME
    {MIME_VER_FIELD,	NULL,		SF_MIME_MASK},
    {CONTENT_FIELD,	NULL,		SF_CONTENT_MASK},
#endif	/* MIME */
  };
  char		*ptr1, *ptr2, *ptr3, *last;
  int		status1, status2, status3, status4;
  long		length, position;
  register int	i;
  
  if ((fp1 = fopen(base_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't open mail read file.");
    return(1);
  }
  create_temp_name(tmp_file1, "SS");
  if ((fp2 = fopen2(tmp_file1, "w")) == (FILE*)NULL) {
    print_fatal("Can't open mail write file.");
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file1, S_IREAD | S_IWRITE);
  
  /*
   * إå
   */
  
  status1 = status2 = status3 = status4 = 0;
  length = 0L;
  for (i = 0; i < sizeof(send_fields)/sizeof(struct cpy_hdr); i++) {
    if (send_fields[i].field_buff) {
      send_fields[i].field_buff[0] = '\0';
    }
  }
  last = NULL;
  while (fgets2(buff1, sizeof(buff1), fp1)) {
    if ((!*buff1) || (*buff1 == '\n')) {
      break;
    }
    if ((*buff1 == ' ') || (*buff1 == '\t')) {
      if (last && status4) {
	if ((strlen(buff2) + strlen(buff1)) < sizeof(buff2)) {
	  *last++ = '\n';
	  strcpy(last, buff1);
	  while (*last) {
	    if (*last == '\n') {
	      *last = '\0';
	      break;
	    }
	    last++;
	  }
	} else {
	  print_mode_line(japanese ?
			  "ٹ : %s եɤСեޤ" :
			  "Warning : %s field overflow.", field);
	  term_bell();
	  sleep(ERROR_SLEEP);
	  status4 = 0;
	}
	continue;
      } else {
	continue;
      }
    } else {
      if (last) {
	if (status3) {
	  if (status3 & SF_DELETE_MASK) {
	    status2 |= status3;
	  } else {
	    status3 |= SF_DELETE_MASK;
	    ptr1 = buff2;
	    while (*ptr1) {
	      if ((*ptr1 != ' ') && (*ptr1 != '\t') && (*ptr1 != '\n')) {
		status3 &= ~SF_DELETE_MASK;
		break;
	      }
	      ptr1++;
	    }
	  }
	}
	if (!(status3 & SF_DELETE_MASK)) {
	  status2 |= status3;
	  if (status3 & SF_EXPAND_MASK) {
	    if (expand_field(fp2, field, buff2)) {	/* ꥢŸ */
	      print_mode_line(japanese ?
			      "ٹ : ꥢŸ˼Ԥޤ" :
			      "Warning : alias expand failed.");
	      term_bell();
	      sleep(ERROR_SLEEP);
	    }
	  } else {
	    ptr1 = buff2;
	    while (1) {
	      ptr2 = buff3;
	      if (*field) {
		sprintf(ptr2, "%s ", field);
		while (*ptr2) {
		  ptr2++;
		}
		*field = '\0';
	      }
	      while (*ptr1) {
		if (*ptr1 == '\n') {
		  ptr1++;
		  break;
		}
		*ptr2++ = *ptr1++;
	      }
	      *ptr2 = '\0';
	      if (status3 & SF_THROUGH_MASK) {
		to_jis(buff4, buff3, default_code);
	      } else {
		mime_encode_func(buff4, buff3, default_code);
	      }
	      fputs(buff4, fp2);
	      fputc('\n', fp2);
	      if (!*ptr1) {
		break;
	      }
	    }
	  }
	}
	status3 = 0;
      }
    }
    if (!strncmp(buff1, TEXT_SEPARATER, sizeof(TEXT_SEPARATER) - 1)) {
      if (!(status2 & SF_FROM_MASK)) {	/* From: եɤ */

	/*
	 *  Fcc: Ѥ˻Ѥ뤿˰ö from_buff Ÿ
	 */

	sprintf(from_buff, "%s@%s", user_name, domain_name);
	if (user_gecos[0]) {
	  length += (long)fprintf(fp2, "%s %s (%s)\n", FROM_FIELD,
				  from_buff, user_gecos);
	} else {
	  length += (long)fprintf(fp2, "%s %s\n", FROM_FIELD, from_buff);
	}
      }
#ifdef	MIME
      if (mime_format == 2) {		/* MIME Ϣեɤ */
	position = ftell(fp1);
	status3 = 0;
	while (fgets(buff1, sizeof(buff1), fp1)) {
	  if (discriminate_code(buff1) != ASCII_CODE) {
	    status3 = 1;
	    break;
	  }
	}
	fseek(fp1, position, 0);
	if (!(status2 & SF_MIME_MASK)) {
	  length += (long)fprintf(fp2, "%s %s\n", MIME_VER_FIELD,
				  MIME_VERSION);
	}
	if (!(status2 & SF_CONTENT_MASK)) {
	  length += (long)fprintf(fp2, "%s %s/%s; %s=%s\n", CONTENT_FIELD,
				  MIME_TYPE_TEXT,
				  MIME_SUBTYPE_PLAIN, MIME_CHARSET,
				  status3 ? MIME_CHARSET_ISO2022_1 :
				  MIME_CHARSET_ASCII);
	}
      }
#endif	/* MIME */
#ifdef	ADD_MESSAGE_ID
      create_msg_id(buff1);
      fputs(buff1, fp2);
#endif	/* ADD_MESSAGE_ID */
#ifndef	DONT_ADD_XFIELD
      length += (long)fprintf(fp2, "%s %s [version %s] %s\n",
			      X_MAILER_FIELD, READER_NAME,
			      MNEWS_VERSION, MNEWS_DATE);
#endif	/* !DONT_ADD_XFIELD */
      fputc('\n', fp2);
      status1 = 1;
      break;
    } else {
      last = NULL;
      ptr1 = buff1;
      ptr2 = field;
      status4 = 1;
      while (*ptr1) {
	if (*ptr1 == ':') {
	  *ptr2++ = *ptr1++;
	  last = buff2;
	  break;
	}
	*ptr2++ = *ptr1++;
      }
      *ptr2 = '\0';
      if (last) {
	while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
	  ptr1++;
	}
	while (*ptr1) {
	  if (*ptr1 == '\n') {
	    break;
	  }
	  *last++ = *ptr1++;
	}
	*last = '\0';
	for (i = 0; i < sizeof(send_fields)/sizeof(struct cpy_hdr); i++) {
	  if (!strncmp(send_fields[i].field_name, field,
		       strlen(send_fields[i].field_name))) {
	    if (send_fields[i].field_buff ) {
	      strcpy(send_fields[i].field_buff, buff2);
	    }
	    status3 = send_fields[i].buff_size;
	    break;
	  }
	}
      }
    }
  }

  if ((!status1) || (!(status2 & (SF_TO_MASK | SF_CC_MASK | SF_BCC_MASK)))) {
    fclose(fp1);
    funlink2(tmp_file1);
    return(1);
  }
  
  /*
   * ʸδѴ
   */
  
  while (fgets2(buff1, sizeof(buff1), fp1)) {
#ifdef	EUC_SPOOL
    to_euc(buff2, buff1, default_code);
#else	/* !EUC_SPOOL */
    to_jis(buff2, buff1, default_code);
#endif	/* !EUC_SPOOL */
    fputs(buff2, fp2);
    length += (long)strlen(buff2);
  }
  fclose(fp1);
  
  /*
   * .signature ղ
   */
  
  sprintf(tmp_file2, "%s%c%s", dot_dir, SLASH_CHAR, SIGNATURE_FILE);
  ptr3 = tmp_file2;
  while (*ptr3) {
    ptr3++;
  }
  *ptr3 = '=';
  ptr1 = ptr2 = ptr3 + 1;
  strcpy(ptr2, folder);
  while (*ptr2) {
    if (*ptr2 == FOLDER_SEPARATER) {
      *ptr2 = NEWS_GROUP_SEPARATER;
    }
    ptr2++;
  }
  fp1 = NULL;
  while (*ptr1) {
    if (fp1 = fopen(tmp_file2, "r")) {
      break;
    } else {
      if (ptr2 = strrchr(ptr1, NEWS_GROUP_SEPARATER)) {
	*ptr2 = '\0';
      } else {
	*ptr1 = '\0';
      }
    }
  }
  if (!fp1) {
    *ptr3 = '\0';
    fp1 = fopen(tmp_file2, "r");
  }
  if (fp1) {
    if (auto_sig_mode) {
      status1 = 1;
    } else {
      status1 = yes_or_no(NORMAL_YN_MODE, "signature%s եĤޤ?",
			 "Add signature%s file.Are you sure?", ptr3);
    }
    if (status1) {
      while (fgets2(buff1, sizeof(buff1), fp1)) {
#ifdef	EUC_SPOOL
	to_euc(buff2, buff1, default_code);
#else	/* !EUC_SPOOL */
	to_jis(buff2, buff1, default_code);
#endif	/* !EUC_SPOOL */
	fputs(buff2, fp2);
	length += (long)strlen(buff2);
      }
    }
    fclose(fp1);
  }
  fclose(fp2);
  
  /*
   * 桼ե륿¹
   */

#ifndef	SMALL
  if (*send_filter) {
    create_temp_name(tmp_file2, "SU");
    sprintf(buff1, "%s < %s > %s", send_filter, tmp_file1, tmp_file2);
    if (system(buff1)) {
      print_fatal("Send filter error.");
      unlink(tmp_file2);
    } else {
      chmod(tmp_file2, S_IREAD | S_IWRITE);
#ifdef	MSDOS
      unlink(tmp_file1);
#endif	/* MSDOS */
      rename(tmp_file2, tmp_file1);
    }
  }
#endif	/* !SMALL */

  /*
   * ľεɽ
   */

#ifdef	MAX_SEND_SIZE
  if (length >= (long)MAX_SEND_SIZE) {
    funlink2(tmp_file1);
    print_mode_line(japanese ? "¿᤮ޤ" :
		    "Too large article.");
    term_bell();
    sleep(ERROR_SLEEP);
    return(-2);
  }
#endif	/* MAX_SEND_SIZE */
#ifdef	CONFIRM_FIELD
  term_clear_all();
  if (fp1 = fopen(tmp_file1, "r")) {
    while (fgets(buff1, sizeof(buff1), fp1)) {
      if ((!buff1[0]) || (buff1[0] == '\n')) {
	break;
      }
#ifdef	EUC_SPOOL
      euc_printf("%s\r", buff1);
#else	/* !EUC_SPOOL */
      jis_printf("%s\r", buff1);
#endif	/* !EUC_SPOOL */
    }
    fclose(fp1);
  }
#else	/* !CONFIRM_FIELD */
  create_temp_name(tmp_file2, "SV");
  exec_pager(tmp_file1, tmp_file2, 0, "CONFIRM");
  last_key = 0;
#endif	/* !CONFIRM_FIELD */

  /*
   * ᡼顼¹
   */

  switch (yes_or_no(SEND_YN_MODE, "ƤǤ?",
		    "Send article.Are you sure?")) {
  case 1:
    break;
  case 3:
    funlink2(tmp_file1);
    return(-3);
  case 2:
    funlink2(tmp_file1);
    return(-2);
  case 0:
  default:
    funlink2(tmp_file1);
    return(-1);
  }
#ifdef	FCC
  if (fcc_buff[0]) {
    if (fcc_save(tmp_file1, from_buff, date_buff, fcc_buff)) {
      if (yes_or_no(NORMAL_YN_MODE,
		    "FCC ե뤬֤ǤޤǤԽޤ?",
		    "Failed for FCC file save.Edit Again?")) {
	funlink2(tmp_file1);
	return(-2);
      }
    }
  }
#endif	/* FCC */
  print_mode_line(japanese ? "Ǥ" : "Sending.");
  status1 = 1;
  signal(SIGPIPE, pipe_error);
  if (fp1 = fopen(tmp_file1, "r")) {
#ifdef	MSDOS
    strcpy(buff1, send_command);
#else	/* !MSDOS */
    sprintf(buff1, "%s > /dev/null 2>&1", send_command);
#endif	/* !MSDOS */
    if (fp2 = popen(buff1, "w")) {
      status1 = 0;
      while (fgets(buff1, sizeof(buff1), fp1)) {
	if (fputs(buff1, fp2) == EOF) {
	  status1 = 1;
	}
      }
      if (pclose(fp2)) {
	status1 = 1;
      }
    } else {
      print_fatal("Can't execute send command.");
    }
    fclose(fp1);
  }
  signal(SIGPIPE, SIG_IGN);
  if (status1) {
    sprintf(tmp_file2, "%s%c%s", dot_dir, SLASH_CHAR, DEAD_FILE);
    if (fp1 = fopen(tmp_file1, "r")) {
      if (fp2 = fopen(tmp_file2, "w")) {
	chmod(tmp_file2, S_IREAD | S_IWRITE);
	while (fgets(buff1, sizeof(buff1), fp1)) {
	  fputs(buff1, fp2);
	}
	fclose(fp2);
      }
      fclose(fp1);
    }
    funlink2(tmp_file1);
    return(1);
  }
  funlink2(tmp_file1);
  return(0);
}

/*
 * ꥢŸ(̴ؿ)
 */

static int	expand_field(fp1, field, ptr1)
     FILE	*fp1;
     char	*field;
     char	*ptr1;
{
  FILE	*fp2;
  char	recipient[BUFF_SIZE];
  char	alias[BUFF_SIZE];
  char	buff[BUFF_SIZE];
  char	*ptr2, *ptr3, *ptr4;
  int	status;
  int	length;
  int	first;

  fp2 = NULL;
  if (!mh_alias_mode) {
    sprintf(buff, "%s%c%s", home_dir, SLASH_CHAR, MAILRC_FILE);
    fp2 = fopen(buff, "r");
  }
  length = fprintf2(fp1, "%s ", field);
  status = 0;
  first = 1;
  while (*ptr1) {
    while ((*ptr1 == ',') || (*ptr1 == '\t') || (*ptr1 == ' ')) {
      ptr1++;
    }
#ifdef	notdef
    ptr2 = alias;
    while (*ptr1) {
      if ((*ptr1 != ',') && (*ptr1 != ' ') && (*ptr1 != '\t')) {
	*ptr2++ = *ptr1++;
      } else {
	ptr1++;
	break;
      }
    }
    *ptr2 = '\0';
#else	/* !notdef */
    ptr1 = get_real_adrs(ptr1, alias);
#endif	/* !notdef */
    if (mh_alias_mode) {
#ifdef	MH
      if (mh_expand_alias(recipient, alias, sizeof(recipient))) {
	status = 1;
	break;
      }
#else	/* !MH */
      strcpy(recipient, alias);
#endif	/* !MH */
    } else {
      if (ucbmail_expand_alias(fp2, recipient, alias, sizeof(recipient))) {
	status = 1;
	break;
      }
    }
    ptr2 = recipient;
    while (*ptr2) {
      ptr3 = ptr2;
#ifdef	notdef
      while (*ptr2 && (*ptr2 != ',') && (*ptr2 != ' ') && (*ptr2 != '\t')) {
	ptr2++;
      }
#else	/* !notdef */
      ptr2 = get_real_adrs(ptr2, buff);
      ptr4 = ptr3;
      while (ptr4 != ptr2) {
	if (*ptr4 == ',') {
	  *ptr4 = '\0';
	  break;
	}
	ptr4++;
      }
#endif	/* !notdef */
      while ((*ptr2 == ',') || (*ptr2 == ' ') || (*ptr2 == '\t')) {
	*ptr2++ = '\0';
      }
      if (first) {
	first = 0;
      } else {
	if ((length + (int)strlen(ptr3)) >= MAX_FIELD_COLUMN) {
	  fprintf(fp1, ",\n\t");
	  length = 8;		/* TAB column */
	} else {
	  length += fprintf2(fp1, ", ");
	}
      }
      length += fprintf2(fp1, "%s", ptr3);
    }
  }
  fprintf(fp1, "\n");
  if (fp2) {
    fclose(fp2);
  }
  return(status);
}

/*
 * UCB-mail .mailrc ѥꥢŸ(̴ؿ)
 * alias ¿ŸϺƵƤӤ롣
 */

static int	ucbmail_expand_alias(fp, recipient, alias, number)
     FILE	*fp;
     char	*recipient;
     char	*alias;
     int	number;
{
  static int	level = 0;		/* alias level */
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		buff3[BUFF_SIZE];
  char		*ptr1, *ptr2, *ptr3;
  int		next_flag;
  int		quote;

  if ((number <= 0) || (level >= 15)) {
    return(1);		/* alias loop or too long alias list */
  }
  strcpy(recipient, alias);
  if (!fp) {
    return(0);
  }
  level++;
  next_flag = 0;
  fseek(fp, 0L, 0);
  while (fgets(buff1, sizeof(buff1), fp)) {
    ptr1 = buff1;
    while (*ptr1) {
      if (*ptr1 == '\n') {
	*ptr1 = '\0';
	break;
      }
      ptr1++;
    }
    ptr1 = buff1;
    while ((*ptr1 == '\t') || (*ptr1 == ' ')) {
      ptr1++;
    }
    ptr2 = ptr1;
    if (!strncasecmp(ptr1, ALIAS_PARAM1, sizeof(ALIAS_PARAM1) - 1)) {
      ptr1 += (sizeof(ALIAS_PARAM1) - 1);
    } else if (!strncasecmp(ptr1, ALIAS_PARAM2, sizeof(ALIAS_PARAM2) - 1)) {
      ptr1 += (sizeof(ALIAS_PARAM2) - 1);
    }
    if (ptr1 != ptr2) {
      while ((*ptr1 == '\t') || (*ptr1 == ' ')) {
	ptr1++;
      }
      if (!strncasecmp(ptr1, alias, strlen(alias))) {
	ptr1 += strlen(alias);
	if ((*ptr1 == '\t') || (*ptr1 == ' ')) {
	  while ((*ptr1 == '\t') || (*ptr1 == ' ')) {
	    ptr1++;
	  }
	  ptr2 = buff3;
	  while (*ptr1) {
	    switch (quote = *ptr1) {
	    case '\t':
	    case ' ':
	    case ',':
	    case '\n':
	    case '\\':
	      ptr1++;
	      next_flag = 1;
	      if (quote == '\\') {
		if (fgets(buff1, sizeof(buff1), fp)) {
		  ptr1 = buff1;
		} else {
		  while (*ptr1) {
		    ptr1++;
		  }
		}
	      }
	      break;
	    default:
	      if (next_flag) {
		if (ptr2 != buff3) {
		  *ptr2++ = ',';
		}
		next_flag = 0;
	      }
	      if ((quote != '\'') && (quote != '\"')) {
		*ptr2++ = *ptr1++;
	      } else {
		ptr1++;
		ptr3 = buff2;
		while (*ptr1) {
		  if ((*ptr1 == quote) || (*ptr1 == '\n')) {
		    ptr1++;
		    break;
		  }
		  *ptr3++ = *ptr1++;
		}
		*ptr3 = '\0';
#ifdef	ONLY_REAL_ALIAS
		get_real_adrs(buff2, ptr2);
#else	/* !ONLY_REAL_ALIAS */
		strcpy(ptr2, buff2);
#endif	/* !ONLY_REAL_ALIAS */
		while (*ptr2) {
		  ptr2++;
		}
	      }
	      break;
	    }
	  }
	  *ptr2 = '\0';

	  /*
	   * alias ¿Ÿå
	   */

	  ptr2 = buff3;
	  while (*ptr2) {
	    while ((*ptr2 == ',') || (*ptr2 == ' ') || (*ptr2 == '\t')) {
	      ptr2++;
	    }
#ifdef	ALLOW_ADRS_COMMENT
	    ptr3 = ptr2;
#endif	/* ALLOW_ADRS_COMMENT */
	    ptr2 = get_real_adrs(ptr2, buff2);
	    if (ucbmail_expand_alias(fp, recipient, buff2, number)) {
	      level--;
	      return(1);
	    } else {
#ifdef	ALLOW_ADRS_COMMENT
	      strcpy(recipient, ptr3);
#endif	/* ALLOW_ADRS_COMMENT */
	      while (*recipient) {
		recipient++;
		number--;
	      }
	    }
	    if (*ptr2) {
	      *recipient++ = ',';
	      *recipient++ = ' ';
	      number -= 2;
	    }
	    *recipient = '\0';
	  }
	  break;
	}
      }
    }
  }
  level--;
  return(0);
}

#ifdef	notdef
/*
 * MH -alias mh_alias ѥꥢŸ(̴ؿ)
 * alias ¿ŸϺƵƤӤ롣
 */

static int	mh_expand_alias(fp, recipient, alias, number)
     FILE	*fp;
     char	*recipient;
     char	*alias;
     int	number;
{
  static int	level = 0;		/* alias level */
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		buff3[BUFF_SIZE];
  char		*ptr1, *ptr2, *ptr3;
  int		next, match, first;
  int		status;
  unsigned long	position;

  if ((number <= 0) || (level >= 15)) {
    return(1);		/* alias loop or too long alias list */
  }
  if (alias) {
    strcpy(recipient, alias);
  } else {
    *recipient = '\0';
  }
  if (!fp) {
    return(0);
  }
  level++;
  status = 0;
  while (fgets(buff1, sizeof(buff1), fp)) {
    next = 0;
    ptr1 = buff1;
    while (*ptr1) {
      if ((*ptr1 == '\\') && (*(ptr1 + 1) == '\n')) {
	*ptr1 = '\0';
	next = 1;
	break;
      }
      if (*ptr1 == '\n') {
	*ptr1 = '\0';
	break;
      }
      ptr1++;
    }
    ptr1 = buff1;
    if ((!*ptr1) || (*ptr1 == '#')) {
      continue;
    }
    if ((*ptr1 == '\t') || (*ptr1 == ' ')) {
      continue;
    }
    match = 0;
    if (!alias) {
      ptr3 = ptr1;
      while (*ptr1) {
	if ((*ptr1 == '\t') || (*ptr1 == ' ')) {
	  continue;
	} else if (*ptr1 == ':') {
	  *ptr1++ = '\0';
	  alias = ptr3;
	  printf("%s: ", ptr3);
	  match = 1;
	  break;
	}
	ptr1++;
      }
    } if (!strncasecmp(ptr1, alias, strlen(alias))) {
      ptr1 += strlen(alias);
      if (*ptr1 == ':') {
	ptr1++;
	match = 2;
      }
    }
    if (match) {
      status = 0;
      first = 1;
      while (*ptr1) {
	if ((*ptr1 == '\t') || (*ptr1 == ' ')) {
	  ptr1++;
	} else {
	  ptr2 = ptr1;
	  ptr1 = get_real_adrs(ptr1, buff2);
	  if (first) {
	    first = 0;
	  } else {
	    *recipient++ = ',';
	    *recipient++ = ' ';
	    number -= 2;
	  }
	  *recipient = '\0';
	  
	  /*
	   * alias ¿Ÿå
	   */
	  
	  position = ftell(fp);
	  if (match == 1) {
	    strcpy(recipient, ptr2);
	  } else if (mh_expand_alias(fp, recipient, buff2, number)) {
	    status = 1;
	    strcpy(recipient, ptr2);
	  }
	  fseek(fp, position, 0);
	  while (*recipient) {
	    *recipient++;
	    number--;
	  }
	}
	if ((!*ptr1) && next) {
	  next = 0;
	  if (fgets(buff1, sizeof(buff1), fp)) {
	    ptr1 = buff1;
	    while (*ptr1) {
	      if ((*ptr1 == '\\') && (*(ptr1 + 1) == '\n')) {
		*ptr1 = '\0';
		next = 1;
		break;
	      }
	      if (*ptr1 == '\n') {
		*ptr1 = '\0';
		break;
	      }
	      ptr1++;
	    }
	    ptr1 = buff1;
	  } else {
	    break;
	  }
	}
      }
      break;
    }
  }
  level--;
  return(status);
}
#endif	/* notdef */
#endif	/* MAILSEND */
