/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : MH support routine
 *  File        : mh.c
 *  Version     : 1.19
 *  First Edit  : 1992-07/16
 *  Last  Edit  : 1995-07/17
 *  Author      : MSR24  
 *
 */

#ifdef	MH
#include	"compat.h"
#include	"nntplib.h"
#include	"mnews.h"
#include	"kanjilib.h"
#include	"termlib.h"
#include	"group.h"
#include	"article.h"
#include	"mh.h"
#include	"pager.h"
#include	"mailsend.h"

static int	mh_select_folder();	/* ե			*/
static void	mh_redraw_folder();	/* ե̺	*/
static int	mh_select_article();	/* 			*/
static void	mh_redraw_article();	/* ̺		*/
static int	mh_prev_folder();	/* Υեֹ		*/
static int	mh_next_folder();	/* Υեֹ		*/
static int	mh_prev_unread_article();
					/* εֹ		*/
static int	mh_next_unread_article();
					/* εֹ		*/
static int	mh_prev_article();	/* εֹ		*/
static int	mh_next_article();	/* εֹ		*/
static int	mh_read();		/* 			*/
static int	mh_extract();		/* 			*/
static void	mh_mark();		/* ޡ¸		*/
static void	mh_unmark();		/* ޡ		*/
static void	mh_save_current();	/* Ȱ¸		*/
static void	mh_pick();		/* ԥå			*/
static void	mh_count();		/* 		*/
static int	mh_trans_current();	/* ȵֹѴ		*/
static void	mh_search_all_folder();	/* ե		*/
static void	mh_search_folder();	/* ե			*/
static void	mh_match_folder();	/* եȹ			*/
static int	mh_get_list();		/* ꥹȼ		*/
static int	mh_get_field();		/* إå		*/
static int	mh_create_folder();	/* ե			*/
static int	mh_delete_folder();	/* ե			*/
static int	mh_adjust_folder();	/* ե		*/
static int	mh_read_field();	/* եɼ		*/
static int	mh_exec_command();	/* MH ޥɼ¹		*/
static int	mh_search_name();	/* ե̾		*/

/*
 * MH եꥹ
 */

static int	mh_folder_number;	/* MH ե		*/
static int	mh_select_number;	/* 򤵤Ƥե	*/
static int	mh_alloc_number;	/* MH ե		*/
static char	mh_path[PATH_BUFF];
static char	mh_unseen_seq[SMALL_BUFF];
static struct mh_folder	*mh_folder = NULL;
static struct mh_folder	*mh_selected_folder = NULL;
static int	top_position;		/* ɽϰ		*/
static int	mh_article_number;	/* MH 		*/

/*
 * MH إץå
 */

static char	*mh_folder_jmessage[] = {
  "MH ƥ/ե⡼\n\n",
  "\tk, ^P ޤ p  Υե˰ưޤ\n",
  "\tj, ^N ޤ n  Υե˰ưޤ\n",
  "\ti ޤ SPACE  ե򤷤ޤ\n",
  "\t^U ޤ ^B    ̤Υե˰ưޤ\n",
  "\t^D, ^F ޤ ^V\n",
  "\t                ̤Υե˰ưޤ\n",
  "\t<               ƬΥե˰ưޤ\n",
  "\t>               ǸΥե˰ưޤ\n",
  "\to, q ޤ RETURN\n",
  "\t                ƥ/եȴޤ\n",
#ifndef	SMALL
  "\t/               ե̾ޤ\n",
  "\t                (ʸϤƲ)\n",
  "\t\\               ե̾ޤ\n",
  "\t                (ʸϤƲ)\n",
#endif	/* !SMALL */
  "\tTAB             Υեƥޤϥե˥פޤ\n",
  "\t                (ƥޤϥե̾ϤƲ)\n",
#ifdef	MAILSEND
  "\tm               ˥᡼Фޤ\n",
#endif	/* MAILSEND */
  "\tG               ˥塼롼/եɽؤޤ\n",
  "\t                (ȥåץեƥΤͭ)\n",
  "\tC               ˥եޤ\n",
  "\t                (ե̾ϤƲ)\n",
  "\tDEL ޤ BS   եޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  NULL,
};

static char	*mh_article_jmessage[] = {
  "MH ⡼\n\n",
  "\tk ޤ ^P     ε˰ưޤ\n",
  "\tj ޤ ^N     ε˰ưޤ\n",
  "\tSPACE, i ޤ .\n",
  "\t                򻲾Ȥޤ\n",
  "\tv ޤ V      ƤΥإåȤȤ˵򻲾Ȥޤ\n",
#ifdef	MIME
  "\t                ('V'  MIME ǥб)\n",
#endif	/* MIME */
  "\tp               ̤ɵ򻲾Ȥޤ\n",
  "\tn               ̤ɵ򻲾Ȥޤ\n",
  "\tP               ε򻲾Ȥޤ\n",
  "\tN               ε򻲾Ȥޤ\n",
  "\t^U ޤ ^B    ̤ε˰ưޤ\n",
  "\t^D, ^F ޤ ^V\n",
  "\t                ̤ε˰ưޤ\n",
  "\t<               Ƭε˰ưޤ\n",
  "\t>               Ǹε˰ưޤ\n",
  "\tD               ޡεذưޤ\n",
  "\td               ޡεذưޤ\n",
  "\tU               ޡεذưޤ\n",
  "\tu               ޡεذưޤ\n",
  "\ts               򥻡֤ޤ\n",
  "\t                (ե̾ϤƲե뤬¸ߤ\n",
  "\t                 Y:ڥ N: O:񤭤ǲ)\n",
  "\tc               ޡޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\tTAB             ε˥פޤ\n",
  "\t                (ֹϤƲ)\n",
#ifdef	MAILSEND
  "\tm               ˥᡼Фޤ\n",
  "\tr               ֿޤ\n",
  "\tR               Ѥֿޤ\n",
  "\tf               žޤ\n",
#endif	/* MAILSEND */
  "\tM               ޥޡ/εذưޤ\n",
  "\tC               ޡεذưޤ\n",
  "\t^               ޡ줿̤Υե˰ưޤ\n",
  "\t                (ưե̾Ƥޤ)\n",
  "\tDEL ޤ BS   ޡ줿ޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\tI               ᡼ߤޤ\n",
#ifndef	SMALL
  "\tL               UCB-mail ޤϥѥåεեߤޤ\n",
  "\t                (ե̾ϤƲ)\n",
#endif	/* !SMALL */
  "\t#               η֤Ĥޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\t$               ԥåƺޡޤ\n",
  "\t                (ԥåѥϤƲ)\n",
  "\t%               ˥Ȥޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\tl               /줿ɽ⡼ɤؤޤ\n",
  "\tt               åɥ⡼ɤؤޤ\n",
#ifdef	REF_SORT
  "\tT               ˡؤޤ\n",
#endif	/* REF_SORT */
  "\to, q ޤ RETURN\n",
  "\t                ⡼ɤȴޤ\n",
  NULL,
};

static char	*mh_folder_message[] = {
#ifndef	SMALL
  "MH CATEGORY/FOLDER SELECT MODE\n\n",
  "\tk, ^P or p   previous folder.\n",
  "\tj, ^N or n   next folder.\n",
  "\ti or SPACE   select folder.\n",
  "\t^U or ^B     previous page folder.\n",
  "\t^D, ^F or ^V next page folder.\n",
  "\t<            top folder.\n",
  "\t>            last folder.\n",
  "\to, q or RETURN\n",
  "\t             exit from category/folder.\n",
  "\t/            forward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\t\\            backward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\tTAB          jump to specified category/folder.\n",
  "\t             (Please input category/folder name.)\n",
#ifdef	MAILSEND
  "\tm            mail.\n",
#endif	/* MAILSEND */
  "\tG            toggle news(board) group/folder print mode.\n",
  "\t             (When top folder only)\n",
  "\tC            create new folder.\n",
  "\t             (Please input folder name.)\n",
  "\tDEL or BS    delete folder.\n",
  "\t             (Please make sure Y/N.)\n",
#endif	/* !SMALL */
  NULL,
};

static char	*mh_article_message[] = {
#ifndef	SMALL
  "MH ARTICLE SELECT MODE\n\n",
  "\tk or ^P      previous article.\n",
  "\tj or ^N      next article.\n",
  "\tSPACE, i or .\n",
  "\t             read article.\n",
  "\tv or V       read article with all header.\n",
#ifdef	MIME
  "\t             ('V' decode MIME header.)\n",
#endif	/* MIME */
  "\tp            read previous unread article.\n",
  "\tn            read next unread article.\n",
  "\tP            read previous article.\n",
  "\tN            read next article.\n",
  "\t^U or ^B     previous page article.\n",
  "\t^D, ^F or ^V next page article.\n",
  "\t<            top article.\n",
  "\t>            last article.\n",
  "\tD            mark for delete and move to previous.\n",
  "\td            mark for delete and move to next.\n",
  "\tU            clear delete mark and move to previous.\n",
  "\tu            clear delete mark and move to next.\n",
  "\ts            save article.\n",
  "\t             (Please input file name.If file exists, please select\n",
  "\t              Y:Append N:Abort or O:Overwrite.)\n",
  "\tc            mark all article for delete.\n",
  "\t             (Please make sure Y/N.)\n",
  "\tTAB          jump to specified article.\n",
  "\t             (Please input article number.)\n",
#ifdef	MAILSEND
  "\tm            mail.\n",
  "\tr            reply.\n",
  "\tR            reply with original article.\n",
  "\tf            forward.\n",
#endif	/* MAILSEND */
  "\tM            toggle multi mark and move to next.\n",
  "\tC            clear all mark and move to next.\n",
  "\t^            refile delete marked article.\n",
  "\t             (Please input folder name.)\n",
  "\tDEL or BS    remove delete marked article.\n",
  "\t             (Please make sure Y/N.)\n",
  "\tI            include new mail.\n",
  "\tL            include UCB-mail or pack format article file.\n",
  "\t             (Please input file name.)\n",
  "\t#            pack articles.\n",
  "\t             (Please make sure Y/N.)\n",
  "\t$            pick articles and mark for delete.\n",
  "\t             (Please input pick pattern.)\n",
  "\t%            sort article by date.\n",
  "\t             (Please make sure Y/N.)\n",
  "\tl            toggle print read/delete article.\n",
  "\tt            toggle thread mode.\n",
#ifdef	REF_SORT
  "\tT            change sort rule.\n",
#endif	/* REF_SORT */
  "\to, q or return\n",
  "\t             exit from article select mode.\n",
#endif	/* !SMALL */
  NULL,
};

/*
 * MH ⡼ɽ
 */

int	mh_init()
{
  struct stat	stat_buff;
  char		buff[BUFF_SIZE];

  if (!mh_mode) {
    return(0);
  }
  sprintf(mh_path, "%s%c%s", home_dir, SLASH_CHAR, MH_DEFAULT_PATH);
  sprintf(buff, "%s%c%s", home_dir, SLASH_CHAR, MH_INIT_FILE);
  mh_read_field(buff, mh_unseen_seq, MH_UNSEEN_FIELD);
  if (mh_read_field(buff, mh_path, MH_PATH_FIELD)) {
#ifdef	MSDOS
    if ((mh_path[0] != SLASH_CHAR) &&
	((!isalpha(mh_path[0])) || (mh_path[1] != ':'))) {
#else	/* !MSDOS */
    if (mh_path[0] != SLASH_CHAR) {
#endif	/* !MSDOS */
      strcpy(buff, mh_path);
      sprintf(mh_path, "%s%c%s", home_dir, SLASH_CHAR, buff);
    }
  }
  if ((!stat(mh_path, &stat_buff)) && (stat_buff.st_mode & S_IFDIR)) {
    return(1);
  }
  return(0);
}

/*
 * MH ˥塼
 */

int	mh_menu()
{
  char		buff[BUFF_SIZE];
  int		status;

  while (1) {
    print_mode_line(japanese ? "Ǥ" : "Searching.");
    if ((!select_name[0]) && (!jump_name[0])) {
      mh_search_all_folder();
      if (mh_select_mode) {
	sprintf(buff, "%s%c%s", mh_path, SLASH_CHAR, MH_CONTEXT_FILE);
	mh_read_field(buff, jump_name, MH_CONTEXT_FIELD);
      }
      if (auto_inc_mode && auto_inc_folder[0] && check_new_mail()) {
	strcpy(jump_name, auto_inc_folder);
      }
    }
    mh_match_folder(select_name);
    status = mh_select_folder();
    if (select_name[0] || (!jump_name[0])) {
      break;
    }
  }
  return(status);
}

/*
 * ե̺
 */

static void	mh_redraw_folder(current_folder)
     int	current_folder;
{
  register int	i, j;
  char		buff[SMALL_BUFF];
  char		jname[SMALL_BUFF];

  i = top_position;
  top_position = get_top_position(top_position, current_folder,
				  mh_select_number, mail_thread_mode,
				  buff);
  if (i == top_position) {
    return;
  }
  print_title();
  if (wide_mode) {
    term_attrib(color_code[HEADER_COLOR]);
  } else {
    term_attrib(color_code[CATEGORY_COLOR]);
  }
  strcpy(jname, select_name);
#ifdef	JNAMES
  get_jname(MH_JN_DOMAIN, jname, 40);
#endif	/* JNAMES */
  print_full_line(japanese ?
		  "եƥ:%-40.40s       :%s" :
		  "Folder category:%-40.40s    Position:%s",
		  jname, buff);
  if (!wide_mode) {
    term_locate(0, 2);
    term_attrib(RESET_ATTRIB);
    term_attrib(color_code[HEADER_COLOR]);
    print_full_line(japanese ?
		    "      Ǿ    ե̾                       [%-8.8s]" :
		    "  Max     Min     Folder name                      [%-8.8s]",
		    newmail_string[check_new_mail()]);
  }
  term_attrib(RESET_ATTRIB);
  for (i = 0, j = top_position; i < term_lines - mode_lines; i++, j++) {
    if (j >= mh_select_number) {
      break;
    }
    term_locate(0, head_lines + i);
#ifdef	COLOR
    term_attrib(color_code[NUMBER_COLOR]);
#endif	/* COLOR */
    if (mh_selected_folder[j].max_article >= 0) {
      cprintf(" %6d  %6d", mh_selected_folder[j].max_article,
	      mh_selected_folder[j].min_article);
    } else {
      cprintf("               ");
    }
    strcpy(buff, mh_selected_folder[j].folder_name);
#ifdef	JNAMES
    get_jname(MH_JN_DOMAIN, buff, term_columns - 24);
#else	/* !JNAMES */
    buff[term_columns - 24] = '\0';
#endif	/* !JNAMES */
#ifdef	COLOR
    term_attrib(color_code[CATEGORY_COLOR]);
#endif	/* COLOR */
    kanji_printf(EUC_CODE, "   %s", buff);
  }
  term_attrib(RESET_ATTRIB);
  print_mode_line(japanese ?
		  "?:إ j,n,^N: k,p,^P: SPACE,i: o,q,RETURN: Q:λ" :
		  "?:Help j,n,^N:next k,p,^P:previous SPACE,i:select o,q,RETURN:return Q:exit");
}

/*
 * ե
 */

static int	mh_select_folder()
{
  /* ѿϺƵΤ static ˤʤ */

  int		current_folder;		/* Υեֹ		*/
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  int		loop;
  int		status;
  int		key;
  register int	i;

  top_position = -1;
  current_folder = 0;

  loop = 1;
  while (loop) {
    if (jump_name[0]) {
      key = 0;
      current_folder = -1;
      for (i = 0; i < mh_select_number; i++) {
	if (!strncmp(mh_selected_folder[i].folder_name, jump_name,
		     strlen(mh_selected_folder[i].folder_name))) {
	  current_folder = i;
	  key = ' ';
	}
      }
      if (current_folder < 0) {
	for (i = 0; i < mh_select_number; i++) {
	  if (!strncmp(mh_selected_folder[i].folder_name, jump_name,
		       strlen(jump_name))) {
	    if (current_folder < 0) {
	      current_folder = i;
	      key = ' ';
	    } else {
	      key = 0;
	    }
	  }
	}
      }
      if (current_folder < 0) {
	current_folder = 0;
      }
      if (!key) {
	jump_name[0] = '\0';
	continue;
      }
    } else {
      mh_redraw_folder(current_folder);
      term_locate(16, head_lines + current_folder - top_position);
      key = get_key(GLOBAL_MODE_MASK | GROUP_MODE_MASK);
    }
    switch (key) {
    case 0x0c:		/* ^L 		*/
      term_init(2);
      top_position = -1;
      break;
    case 0x0e:		/* ^N եư	*/
    case 'j':
    case 'n':
      current_folder = mh_next_folder(current_folder);
      break;
    case 0x10:		/* ^P եư	*/
    case 'k':
    case 'p':
      current_folder = mh_prev_folder(current_folder);
      break;
    case 'o':
    case 'q':
    case '\015':	/* RETURN		*/
    case '\n':
      loop = 0;
      break;
    case 0x02:		/* ^B			*/
    case 0x15:		/* ^U ڡ		*/
      if ((current_folder -= (term_lines - mode_lines)) < 0) {
	current_folder = 0;
      }
      break;
    case 0x04:		/* ^D			*/
    case 0x06:		/* ^F			*/
    case 0x16:		/* ^V ڡ		*/
      if ((current_folder += (term_lines - mode_lines)) >= mh_select_number) {
	if (mh_select_number > 0) {
	  current_folder = mh_select_number - 1;
	} else {
	  current_folder = 0;
	}
      }
      break;
    case '<':		/* ǽΥե	*/
      current_folder = 0;
      break;
    case '>':		/* ǸΥե	*/
      if (mh_select_number > 0) {
	current_folder = mh_select_number - 1;
      } else {
	current_folder = 0;
      }
      break;
    case '\t':		/* TAB ꥫƥ/եإ	*/
      strcpy(buff1, mh_path);
      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
		 "եƥޤϥե̾ϤƲ:",
		 "Input folder category or folder group name:", buff1);
      if (buff1[0]) {
	strcpy(jump_name, buff1);
	return(1);
      } else {
	top_position = -1;
      }
      break;
    case '?':		/* إ		*/
      help(mh_folder_jmessage, mh_folder_message,
	   GLOBAL_MODE_MASK | GROUP_MODE_MASK);
      top_position = -1;
      break;
    case 'Q':		/* λ			*/
      return(1);
      /* break; */
    case 'G':		/* ɽ⡼/	*/
      if (!select_name[0]) {
	gnus_mode = !gnus_mode;
	mh_match_folder(select_name);
	current_folder = 0;
	top_position = -1;
      }
      break;
    case 'C':		/* ե		*/
      strcpy(buff1, mh_path);
      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
		 "ե̾ϤƲ:",
		 "Input new folder name:", buff1);
      if (buff1[0]) {
	if (!mh_create_folder(buff1)) {
	  if (mh_select_number > 0) {
	    strcpy(buff1, mh_selected_folder[current_folder].folder_name);
	    mh_search_all_folder();
	    mh_match_folder(select_name);
	    current_folder = mh_adjust_folder(buff1);
	  } else {
	    mh_search_all_folder();
	    mh_match_folder(select_name);
	    current_folder = 0;
	  }
	}
      }
      top_position = -1;
      break;
    default:
      if (mh_select_number > 0) {
	switch (key) {
	case ' ':
	case 'i':		/* ե		*/
	  strcpy(buff1, mh_selected_folder[current_folder].folder_name);
	  strcpy(buff2, select_name);
	  strcpy(select_name,
		 mh_selected_folder[current_folder].folder_name);
	  if (mh_selected_folder[current_folder].max_article < 0) {
	    status = mh_menu();
	  } else {
	    status = mh_select_article(auto_inc_mode &&
				       ((!auto_inc_folder[0]) ||
					(!strcmp(auto_inc_folder,
		 mh_selected_folder[current_folder].folder_name))));
	  }
	  strcpy(select_name, buff2);
	  if (status) {
	    return(1);
	  }
	  mh_match_folder(select_name);
	  current_folder = mh_adjust_folder(buff1);
	  top_position = -1;
	  break;
#ifndef	SMALL
	case '/':		/* 		*/
	  mh_search_name(0, mh_folder_number, &current_folder);
	  break;
	case '\\':		/* 		*/
	  mh_search_name(1, mh_folder_number, &current_folder);
	  break;
#endif	/* !SMALL */
	case 0x7f:		/* ե		*/
	case 0x08:
	  if (mh_selected_folder[current_folder].max_article) {
	    print_mode_line(japanese ?
			    "ե(%s)϶ǤϤޤ" :
			    "Folder(%s) does not empty.",
			    mh_selected_folder[current_folder].folder_name);
	    term_bell();
	    sleep(ERROR_SLEEP);
	  } else if (!strcmp(mh_selected_folder[current_folder].folder_name,
			     select_name)) {
	    print_mode_line(japanese ?
			    "ƥեƥ˰ưƺƲ" :
			    "Please move to parent folder category and delete.",
			    mh_selected_folder[current_folder].folder_name);
	    term_bell();
	    sleep(ERROR_SLEEP);
	  } else {
	    if (yes_or_no(CARE_YN_MODE, "ե(%s)ޤ?",
			  "Delete folder(%s)?",
			  mh_selected_folder[current_folder].folder_name)) {
	      if (!mh_delete_folder(mh_selected_folder[current_folder].folder_name)) {
		strcpy(buff1, mh_selected_folder[current_folder].folder_name);
		mh_search_all_folder();
		mh_match_folder(select_name);
		current_folder = mh_adjust_folder(buff1);
	      }
	    }
	  }
	  top_position = -1;
	  break;
	default:
	  break;
	}
      }
      break;
    }
  }
  return(0);
}

/*
 * ̺
 */

static void	mh_redraw_article(current_article)
     int	current_article;
{
  register int	i;
  char		buff[SMALL_BUFF];
  char		jname[SMALL_BUFF];

  i = top_position;
  top_position = get_top_position(top_position, current_article,
				  mh_article_number, mail_thread_mode,
				  buff);
  if (i == top_position) {
    return;
  }
  print_title();
  if (wide_mode) {
    term_attrib(color_code[HEADER_COLOR]);
  } else {
    term_attrib(color_code[CATEGORY_COLOR]);
  }
  strcpy(jname, select_name);
#ifdef	JNAMES
  get_jname(MH_JN_DOMAIN, jname, 48);
#endif	/* JNAMES */
  print_full_line(japanese ?
		  "ե:%-48.48s       :%s" :
		  "Folder:%-48.48s     Position:%s",
		  jname, buff);
  print_articles(top_position, mh_article_number, mh_get_field, "REMOVED");
  print_mode_line(japanese ?
		  "?:إ j,^N: k,^P: SPACE,i,.: o,q: Q:λ" :
		  "?:Help j,^N:next k,^P:previous SPACE,i,.:read o,q:return Q:exit");
}

/*
 * 
 */

static int	mh_select_article(auto_flag)
     int	auto_flag;
{
  register int	current_folder;		/* Υեֹ		*/
  int		current_article;	/* εֹ		*/
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr;
  int		loop;
  int		status;
  int		key;
  register int	i, j;

  current_folder = -1;
  jump_name[0] = '\0';
  for (i = 0; i < mh_folder_number; i++) {
    if (!strcmp(select_name, mh_folder[i].folder_name)) {
      current_folder = i;
      break;
    }
  }
  if (current_folder < 0) {
    print_fatal("Unexpected folder selected.");
    return(0);
  }
  print_mode_line(japanese ? "Ǥ" : "Searching.");
  if (auto_flag) {
    if (check_new_mail()) {	/* ưǽ		*/
      mh_exec_command(MH_INC_COMMAND, mh_folder[current_folder].folder_name,
		      NULL);
      mh_count(current_folder, 0);
    }
  }
  if (mh_get_list(current_folder) < 0) {
    return(0);
  }
  current_article =
    mh_trans_current(mh_folder[current_folder].current_article);
  top_position = -1;
  loop = 1;
  status = 0;
  while (loop) {
    mh_redraw_article(current_article);
    term_locate(11, head_lines + current_article - top_position);
    key = get_key(GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
    switch (key) {
    case 0x0c:		/* ^L 		*/
      term_init(2);
      top_position = -1;
      break;
    case 0x0e:		/* ^N ư	*/
    case 'j':
      current_article = mh_next_article(current_article);
      break;
    case 0x10:		/* ^P ư	*/
    case 'k':
      current_article = mh_prev_article(current_article);
      break;
    case '\015':	/* RETURN		*/
    case '\n':
    case 'o':
    case 'q':
      loop = 0;
      break;
    case 0x02:		/* ^B 			*/
    case 0x15:		/* ^U ڡ		*/
      if ((current_article -= (term_lines - mode_lines)) < 0) {
	current_article = 0;
      }
      break;
    case 0x04:		/* ^D			*/
    case 0x06:		/* ^F			*/
    case 0x16:		/* ^V ڡ		*/
      if ((current_article += (term_lines - mode_lines)) >= mh_article_number) {
	if (mh_article_number > 0) {
	  current_article = mh_article_number - 1;
	} else {
	  current_article = 0;
	}
      }
      break;
    case '<':		/* ǽε		*/
      current_article = 0;
      break;
    case '>':		/* Ǹε		*/
      if (mh_article_number > 0) {
	current_article = mh_article_number - 1;
      } else {
	current_article = 0;
      }
      break;
#ifndef	SMALL
    case 'L':		/* ե	*/
      buff1[0] = '\0';
      input_line(INPUT_EXPAND_MASK | INPUT_COMP_MASK,
		 "ե̾ϤƲ:",
		 "Input file name:", buff1);
      if (buff1[0]) {
#ifdef	MSDOS
	sprintf(buff2, "%s -file \'%s\' \'+%s\' > NUL",
		MH_INC_COMMAND, buff1,
		mh_folder[current_folder].folder_name);
#else	/* !MSDOS */
	sprintf(buff2, "exec %s%c%s -file \'%s\' \'+%s\' > /dev/null 2>&1",
		mh_command_path, SLASH_CHAR, MH_INC_COMMAND,
		buff1, mh_folder[current_folder].folder_name);
#endif	/* !MSDOS */
	if (system(buff2)) {
	  print_fatal("Can't execute inc command.");
	}
      }
      /* break 	*/
#endif	/* !SMALL */
    case 'I':		/* 嵭	*/
      mh_save_current(current_folder);
      if (key == 'I') {
	if (auto_inc_mode && auto_inc_folder[0]) {
	  if (check_new_mail()) {
	    strcpy(jump_name, auto_inc_folder);
	    return(1);
	  }
	  break;
	}
	mh_exec_command(MH_INC_COMMAND,
			mh_folder[current_folder].folder_name, NULL);
      }
      mh_count(current_folder, 0);
      mh_get_list(current_folder);
      current_article =
	mh_trans_current(mh_folder[current_folder].current_article);
      top_position = -1;
      break;
    case '?':		/* إ		*/
      help(mh_article_jmessage, mh_article_message,
	   GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
      top_position = -1;
      break;
    case 'Q':		/* λ			*/
      loop = 0;
      status = 1;
      break;
    case 'l':		/* ɵѥå/	*/
    case 't':		/* åɥ	*/
    case 'T':		/* åɥ롼	*/
      if (!change_sort_rule(current_folder, &mh_article_number,
			    &current_article,
			    &mail_article_mask, &mail_thread_mode,
			    mh_get_list, key)) {
	top_position = -1;
      }
      break;
    default:
      last_key = key;
      while (last_key) {
	key = last_key;
	last_key = 0;
	switch (key) {
	case 'p':		/* ̤ɵ	*/
	case 'P':		/* ε		*/
	  j = current_article;
	  if (mh_article_number > 0) {
	    if (key == 'p') {
	      current_article = mh_prev_unread_article(current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      current_article = mh_prev_article(current_article);
	      status = (current_article == j);
	    }
	  } else {
	    status = 1;
	  }
	  if (status) {
	    i = current_folder - 1;
	    if (i >= 0) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"Υե(%s)򻲾Ȥޤ?",
				"Read previous folder(%s)?",
				mh_folder[i].folder_name)) {
	      case 1:
		mh_save_current(current_folder);
		strcpy(jump_name, mh_folder[i].folder_name);
		return(1);
		/* break; */
	      case 2:
		mh_save_current(current_folder);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
	case 'n':		/* ̤ɵ	*/
	case 'N':		/* ε		*/
	  j = current_article;
	  if (mh_article_number > 0) {
	    if (key == 'n') {
	      current_article = mh_next_unread_article(current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      current_article = mh_next_article(current_article);
	      status = (current_article == j);
	    }
	  } else {
	    status = 1;
	  }
	  if (status) {
	    i = current_folder + 1;
	    if (i < mh_folder_number) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"Υե(%s)򻲾Ȥޤ?",
				"Read next folder(%s)?",
				mh_folder[i].folder_name)) {
	      case 1:
		mh_save_current(current_folder);
		strcpy(jump_name, mh_folder[i].folder_name);
		return(1);
		/* break; */
	      case 2:
		mh_save_current(current_folder);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
	default:
	  break;
	}
	if (mh_article_number > 0) {
	  i = 1;
	  switch (key) {
	  case 'V':		/* 		*/
	    i = 3;
	    /* break  */
	  case 'v':
	    i--;
	    key = ' ';
	    /* break  */
	  case ' ':
	  case 'p':
	  case 'n':
	  case 'P':
	  case 'N':
	  case 'i':
	  case '.':
	    if (!mh_read(article_list[current_article].real_number, i)) {
	      mh_mark(current_folder, current_article, READ_MARK);
	      mh_folder[current_folder].current_article = current_article;
	      if ((last_key == 'D') || (last_key == 'd')) {
		if (!(article_list[current_article].mark & CANCEL_MARK)) {
		  article_list[current_article].mark |= DELETE_MARK;
		}
		if (last_key == 'D') {
		  last_key = 'p';
		} else {
		  last_key = 'n';
		}
	      } else if ((last_key == 'U') || (last_key == 'u')) {
		if (!(article_list[current_article].mark & CANCEL_MARK)) {
		  article_list[current_article].mark &= ~DELETE_MARK;
		}
		if (last_key == 'U') {
		  last_key = 'p';
		} else {
		  last_key = 'n';
		}
	      }
	    }
	    if (pager_mode) {
	      switch (key) {
	      case 'p':
		current_article = mh_prev_unread_article(current_article);
		break;
	      case 'n':
	      case ' ':
		current_article = mh_next_unread_article(current_article);
		break;
	      case 'P':
		current_article = mh_prev_article(current_article);
		break;
	      case 'N':
		current_article = mh_next_article(current_article);
		break;
	      default:
		break;
	      }
	    }
	    if (last_key == ' ') {
	      last_key = 'n';
	    }
	    top_position = -1;
	    break;
	  case 'D':		/* ޡư	*/
	  case 'd':		/* ޡư	*/
	    if (!(article_list[current_article].mark & CANCEL_MARK)) {
	      article_list[current_article].mark |= DELETE_MARK;
	      toggle_mark(top_position, current_article, 0);
	    }
	    if (key == 'D') {
	      current_article = mh_prev_article(current_article);
	    } else {
	      current_article = mh_next_article(current_article);
	    }
	    break;
	  case 'U':		/* ޡư	*/
	  case 'u':		/* ޡư	*/
	    article_list[current_article].mark &= ~DELETE_MARK;
	    toggle_mark(top_position, current_article, 0);
	    if (key == 'U') {
	      current_article = mh_prev_article(current_article);
	    } else {
	      current_article = mh_next_article(current_article);
	    }
	    break;
	  case 'c':		/* ޡ		*/
	    if (yes_or_no(NORMAL_YN_MODE,
			  "ƥޡƤǤ?",
			  "Mark all articles.Are you sure?")) {
	      for (i = 0; i < mh_article_number; i++) {
		article_list[i].mark |= DELETE_MARK;
	      }
	    }
	    top_position = -1;
	    status = 0;
	    break;
	  case '^':		/* ޡե	*/
	    j = 0;
	    for (i = 0; i < mh_article_number; i++) {
	      if ((article_list[i].mark & DELETE_MARK)
		  && !(article_list[i].mark & CANCEL_MARK)) {
		j = 1;
	      }
	    }
	    if (j) {
	      strcpy(buff1, mh_path);
	      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
			 "ưե̾ϤƲ:",
			 "Input destination folder name:", buff1);
	      if (buff1[0]) {
		j = 0;
		for (i = 0; i < mh_folder_number; i++) {
		  if (!strcmp(mh_folder[i].folder_name, buff1)) {
		    status = i;
		    j = 1;
		    break;
		  }
		}
		if (!j) {
		  if (yes_or_no(NORMAL_YN_MODE,
				"ե(%s)򿷵ޤ?",
				"Create folder(%s).Are you sure?",
				buff1)) {
		    if (!mh_create_folder(buff1)) {
		      j = 1;
		      status = -1;
		    }
		  }
		}
		if (j) {
		  if (current_folder == status) {
		    print_mode_line(japanese ?
				    "ưȰư褬ƱեǤ" :
				    "Source and destination folders are identical.");
		    term_bell();
		    sleep(ERROR_SLEEP);
		  } else {
		    print_mode_line(japanese ? "եǤ" :
				    "Refiling.");
		    mh_save_current(current_folder);
		    i = 0;
		    while (1) {
		      j = 0;
#ifdef	MSDOS
		      sprintf(buff2, "%s -src \'%s\' \'+%s\' ",
			      MH_REFILE_COMMAND,
			      mh_folder[current_folder].folder_name,
			      buff1);
#else	/* !MSDOS */
		      sprintf(buff2, "exec %s%c%s -src \'%s\' \'+%s\' ",
			      mh_command_path, SLASH_CHAR, MH_REFILE_COMMAND,
			      mh_folder[current_folder].folder_name,
			      buff1);
#endif	/* !MSDOS */
		      for (; i < mh_article_number; i++) {
			if ((article_list[i].mark & DELETE_MARK)
			    && !(article_list[i].mark & CANCEL_MARK)) {
			  ptr = buff2;
			  while (*ptr) {
			    ptr++;
			  }
			  j = 1;
			  sprintf(ptr, "%d ", article_list[i].real_number);
			  if (strlen(buff2) >= sizeof(buff2) - 32) {
			    i++;
			    break;
			  }
			}
		      }
		      if (j) {
#ifdef	MSDOS
			strcat(buff2, " > NUL");
#else	/* !MSDOS */
			strcat(buff2, " > /dev/null 2>&1");
#endif	/* !MSDOS */
#ifdef	DEBUG
			printf("EXEC \"%s\"", buff2);
			sleep(10);
#else	/* !DEBUG */
			if (system(buff2)) {
			  print_fatal("Can't execute refile command.");
			}
#endif	/* !DEBUG */
		      } else {
			break;
		      }
		    }
		    strcpy(buff1, mh_folder[current_folder].folder_name);
		    mh_search_all_folder();
		    current_folder = 0;
		    for (i = 0; i < mh_folder_number; i++) {
		      if (!strcmp(mh_folder[i].folder_name, buff1)) {
			current_folder = i;
			break;
		      }
		    }
		    mh_get_list(current_folder);
		    current_article =
		      mh_trans_current(mh_folder[current_folder].current_article);
		  }
		}
	      }
	      status = 0;
	      top_position = -1;
	    }
	    break;
	  case '%':		/* 		*/
	    if (yes_or_no(NORMAL_YN_MODE, "򥽡ȤƤǤ?",
			  "Sort articles.Are you sure?")) {
	      print_mode_line(japanese ? "Ǥ" :
			      "Sorting.");
	      mh_save_current(current_folder);
	      mh_exec_command(MH_SORTM_COMMAND,
			      mh_folder[current_folder].folder_name, NULL);
	      mh_count(current_folder, 0);
	      mh_get_list(current_folder);
	      current_article =
		mh_trans_current(mh_folder[current_folder].current_article);
	    }
	    status = 0;
	    top_position = -1;
	    break;
	  case 0x7f:		/* ޡ	*/
	  case 0x08:
	    j = 0;
	    for (i = 0; i < mh_article_number; i++) {
	      if ((article_list[i].mark & DELETE_MARK)
		  && !(article_list[i].mark & CANCEL_MARK)) {
		j = 1;
	      }
	    }
	    if (j) {
	      if (yes_or_no(CARE_YN_MODE,
			    "ޡ줿ƺƤǤ?",
			    "Delete all marked articles.Are you sure?")) {
		print_mode_line(japanese ? "Ǥ" :
				"Removing.");
		mh_save_current(current_folder);
		i = 0;
		while (1) {
		  j = 0;
#ifdef	MSDOS
		  sprintf(buff1, "%s \'+%s\' ", MH_RMM_COMMAND,
			  mh_folder[current_folder].folder_name);
#else	/* !MSDOS */
		  sprintf(buff1, "exec %s%c%s \'+%s\' ", mh_command_path,
			  SLASH_CHAR, MH_RMM_COMMAND,
			  mh_folder[current_folder].folder_name);
#endif	/* !MSDOS */
		  for (; i < mh_article_number; i++) {
		    if ((article_list[i].mark & DELETE_MARK)
			&& !(article_list[i].mark & CANCEL_MARK)) {
		      ptr = buff1;
		      while (*ptr) {
			ptr++;
		      }
		      j = 1;
		      sprintf(ptr, "%d ", article_list[i].real_number);
		      if (strlen(buff1) >= sizeof(buff1) - 32) {
			i++;
			break;
		      }
		    }
		  }
		  if (j) {
#ifdef	MSDOS
		    strcat(buff1, " > NUL");
#else	/* !MSDOS */
		    strcat(buff1, " > /dev/null 2>&1");
#endif	/* !MSDOS */
#ifdef	DEBUG
		    printf("EXEC \"%s\"", buff1);
		    sleep(10);
#else	/* !DEBUG */
		    if (system(buff1)) {
		      print_fatal("Can't execute rmm command.");
		    }
#endif	/* !DEBUG */
		  } else {
		    break;
		  }
		}
		mh_count(current_folder, 0);
		mh_get_list(current_folder);
		current_article =
		  mh_trans_current(mh_folder[current_folder].current_article);
	      }
	      status = 0;
	      top_position = -1;
	    }
	    break;
	  case '#':		/* ѥå		*/
	    if (yes_or_no(NORMAL_YN_MODE, "ѥåƤǤ?",
			  "Pack articles.Are you sure?")) {
	      print_mode_line(japanese ? "ѥåǤ" :
			      "Packing.");
	      mh_exec_command(MH_FOLDER_COMMAND,
			      mh_folder[current_folder].folder_name, "-pack");
	      mh_count(current_folder, 0);
	      mh_get_list(current_folder);
	      current_article = mh_folder[current_folder].current_article;
	      if (current_article >= mh_article_number) {
		if ((current_article = mh_article_number - 1) < 0) {
		  current_article = 0;
		}
	      }
	    }
	    status = 0;
	    top_position = -1;
	    break;
	  case '$':		/* ԥå		*/
	    buff1[0] = '\0';
	    input_line(0, "ԥåѥϤƲ:",
		       "Input pick pattern:", buff1);
	    if (buff1[0]) {
	      mh_pick(current_folder, buff1);
	    }
	    status = 0;
	    top_position = -1;
	    break;
	  case 's':		/* 		*/
	    if (!multi_save(current_article, mh_extract)) {
	      multi_add_mark(mh_article_number, current_folder,
			     current_article, READ_MARK, mh_mark);
	    }
	    top_position = -1;
	    break;
#ifndef	SMALL
	  case '/':		/* 		*/
	    search_subjects(0, mh_article_number, &current_article,
			    mh_get_field);
	    break;
	  case '\\':		/* 		*/
	    search_subjects(1, mh_article_number, &current_article,
			    mh_get_field);
	    break;
	  case '|':		/* ѥ׼¹		*/
	    if (!multi_pipe(current_article, mh_extract)) {
	      multi_add_mark(mh_article_number, current_folder,
			     current_article, READ_MARK, mh_mark);
	    }
	    top_position = -1;
	    break;
#endif	/* !SMALL */
	  case '\t':		/* TAB 국إ	*/
	    buff1[0] = '\0';
	    input_line(INPUT_SPCCUT_MASK, "ֹϤƲ:",
		       "Input article number:", buff1);
	    if ((j = atoi(buff1)) > 0) {
	      for (i = 0; i < mh_article_number; i++) {
		if (article_list[i].real_number == j) {
		  current_article = i;
		  break;
		}
	      }
	    }
	    top_position = -1;
	    break;
#ifdef	MAILSEND
	  case 'r':		/* ᡼ֿ		*/
	    sprintf(buff1, "%s%c%s%c%d", mh_path, SLASH_CHAR, select_name,
		    SLASH_CHAR, article_list[current_article].real_number);
	    if (!mail_reply(buff1, 0, select_name)) {
	      mh_mark(current_folder, current_article, ANSWER_MARK);
	    }
	    top_position = -1;
	    break;
	  case 'R':		/* ᡼ֿ		*/
	    create_temp_name(buff1, "MR");
	    if (!multi_extract(current_article, buff1, mh_extract)) {
	      if (!mail_reply(buff1, REPLY_QUOTE_MASK, select_name)) {
		multi_add_mark(mh_article_number, current_folder,
			       current_article, ANSWER_MARK, mh_mark);
	      }
	      funlink2(buff1);
	    }
	    top_position = -1;
	    break;
	  case 'f':		/* ᡼ž		*/
	    sprintf(buff1, "%s%c%s%c%d", mh_path, SLASH_CHAR, select_name,
		    SLASH_CHAR, article_list[current_article].real_number);
	    if (!mail_forward(buff1, select_name)) {
	      mh_mark(current_folder, current_article, FORWARD_MARK);
	    }
	    top_position = -1;
	    break;
#endif	/* MAILSEND */
	  case 'C':		/* ޡ		*/
	    mh_unmark(current_folder, current_article,
		      READ_MARK | FORWARD_MARK | ANSWER_MARK);
	    toggle_mark(top_position, current_article, 0);
	    current_article = mh_next_article(current_article);
	    break;
	  case 'M':		/* ޥޡ/	*/
	    multi_mark(top_position, current_article);
	    current_article = mh_next_article(current_article);
	    break;
	  default:
	    break;
	  }
	}
	switch (last_key) {
	case 'f':
	  print_title();
	case ' ':
	case 'p':
	case 'n':
	case 'P':
	case 'N':
	case 'v':
	case 'V':
	case 'r':
	case 'R':
	  break;
	default:
	  last_key = 0;
	}
      }
      break;
    }
  }
  mh_save_current(current_folder);
  return(status);
}

/*
 * Υեֹ
 */

static int	mh_prev_folder(current_folder)
     int	current_folder;
{
  if (--current_folder < 0) {
    current_folder = 0;
  }
  return(current_folder);
}

/*
 * Υեֹ
 */

static int	mh_next_folder(current_folder)
     int	current_folder;
{
  if (++current_folder >= mh_select_number) {
    if (mh_select_number > 0) {
      current_folder = mh_select_number - 1;
    } else {
      current_folder = 0;
    }
  }
  return(current_folder);
}

/*
 * ̤ɵֹ
 */

static int	mh_prev_unread_article(current_article)
     int	current_article;
{
  while (current_article > 0) {
    if (!(article_list[--current_article].mark & (READ_MARK | CANCEL_MARK))) {
      break;
    }
  }
  return(current_article);
}

/*
 * ̤ɵֹ
 */

static int	mh_next_unread_article(current_article)
     int	current_article;
{
  while (current_article < (mh_article_number - 1)) {
    if (!(article_list[++current_article].mark & (READ_MARK | CANCEL_MARK))) {
      break;
    }
  }
  return(current_article);
}

/*
 * εֹ
 */

static int	mh_prev_article(current_article)
     int	current_article;
{
  if (--current_article < 0) {
    current_article = 0;
  }
  return(current_article);
}

/*
 * Υե
 */

static int	mh_next_article(current_article)
     int	current_article;
{
  if (++current_article >= mh_article_number) {
    if (mh_article_number > 0) {
      current_article = mh_article_number - 1;
    } else {
      current_article = 0;
    }
  }
  return(current_article);
}

/*
 * 
 */

static int	mh_read(real_number, mode)
     int	real_number;
     int	mode;
{
  char	mh_file[PATH_BUFF];
  char	tmp_file[PATH_BUFF];
  char	buff[SMALL_BUFF];

  sprintf(mh_file, "%s%c%s%c%d", mh_path, SLASH_CHAR, select_name,
	  SLASH_CHAR, real_number);
  create_temp_name(tmp_file, "MV");
  sprintf(buff, "%d", real_number);
  if (exec_pager(mh_file, tmp_file, mode, buff)) {
    return(1);
  }
  return(0);
}

/*
 * 
 */

static int	mh_extract(real_number, tmp_file)
     int	real_number;
     char	*tmp_file;
{
  FILE	*fp1, *fp2;
  char	mh_file[PATH_BUFF];
  char	buff[BUFF_SIZE];
  int	status;

  sprintf(mh_file, "%s%c%s%c%d", mh_path, SLASH_CHAR, select_name,
	  SLASH_CHAR, real_number);
  if ((fp1 = fopen(mh_file, "r")) == (FILE*)NULL) {
    return(1);
  }
  if ((fp2 = fopen2(tmp_file, "a")) == (FILE*)NULL) {
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  status = 0;
  while (fgets(buff, sizeof(buff), fp1)) {
    if (fputs(buff, fp2) == EOF) {
      status = 1;
    }
  }
  fclose(fp1);
  fclose(fp2);
  if (status) {
    funlink2(tmp_file);
    return(status);
  }
  return(0);
}

/*
 * ޡ¸
 */

static void	mh_mark(current_folder, current_article, mark)
     int	current_folder;
     int	current_article;
     int	mark;
{
  char	mh_file[PATH_BUFF];
  char	tmp_file[PATH_BUFF];
  char	buff[BUFF_SIZE];
  FILE	*fp1;
  FILE	*fp2;

  mark &= (READ_MARK | FORWARD_MARK | ANSWER_MARK);
  if (mark & READ_MARK) {
    if (article_list[current_article].mark & READ_MARK) {
      mark &= ~READ_MARK;
    } else if (mh_unseen_seq[0]) {
#ifdef	MSDOS
      sprintf(buff, "%s +%s -sequence %s -delete %d > NUL",
	      MH_MARK_COMMAND, mh_folder[current_folder].folder_name,
	      mh_unseen_seq, article_list[current_article].real_number);
#else	/* !MSDOS */
      sprintf(buff, "%s/%s +%s -sequence %s -delete %d > /dev/null 2>&1",
	      mh_command_path, MH_MARK_COMMAND,
	      mh_folder[current_folder].folder_name,
	      mh_unseen_seq, article_list[current_article].real_number);
#endif	/* !MSDOS */
      if (system(buff)) {
	print_fatal("Can't execute mark command.");
      }
      article_list[current_article].mark |= READ_MARK;
      mark &= ~READ_MARK;
    }
  }
  if (!mh_mark_mode) {
    article_list[current_article].mark |= mark;
    return;
  }
  if (mark & FORWARD_MARK) {
    if (article_list[current_article].mark & FORWARD_MARK) {
      mark &= ~FORWARD_MARK;
    }
  }
  if (mark & ANSWER_MARK) {
    if (article_list[current_article].mark & ANSWER_MARK) {
      mark &= ~ANSWER_MARK;
    }
  }
  if (!mark) {
    return;
  }
  sprintf(mh_file, "%s%c%s%c%d", mh_path, SLASH_CHAR, select_name, SLASH_CHAR,
	  article_list[current_article].real_number);
  create_backup_name(tmp_file, mh_file);
#ifdef	MSDOS
  unlink(tmp_file);
#endif	/* MSDOS */
  if (rename(mh_file, tmp_file)) {
    if (errno != ENOENT) {
      print_fatal("Can't rename mh article.");
    }
    return;
  }
  if ((fp1 = fopen(tmp_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't open mh read article.");
    return;
  }
  if ((fp2 = fopen(mh_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open mh write article.");
    fclose(fp1);
#ifdef	MSDOS
    unlink(mh_file);
#endif	/* MSDOS */
    rename(tmp_file, mh_file);
    return;
  }
  chmod(mh_file, S_IREAD | S_IWRITE);
  article_list[current_article].mark |= mark;
  if (mark & READ_MARK) {
    fprintf(fp2, "%s \n", MH_READ_FIELD);
  }
  if (mark & FORWARD_MARK) {
    fprintf(fp2, "%s \n", MH_FORWARD_FIELD);
  }
  if (mark & ANSWER_MARK) {
    fprintf(fp2, "%s \n", MH_REPLY_FIELD);
  }
  while (fgets(buff, sizeof(buff), fp1)) {
    fputs(buff, fp2);
  }
  fclose(fp1);
  fclose(fp2);
  unlink(tmp_file);
}

/*
 * ޡ
 */

static void	mh_unmark(current_folder, current_article, mark)
     int	current_folder;
     int	current_article;
     int	mark;
{
  char	mh_file[PATH_BUFF];
  char	tmp_file[PATH_BUFF];
  char	dummy_buff[MAX_FIELD_LEN];
  char	buff[BUFF_SIZE];
  FILE	*fp1;
  FILE	*fp2;

  mark &= (READ_MARK | FORWARD_MARK | ANSWER_MARK);
  if (mark & READ_MARK) {
    if (!(article_list[current_article].mark & READ_MARK)) {
      mark &= ~READ_MARK;
    } else if (mh_unseen_seq[0]) {
#ifdef	MSDOS
      sprintf(buff, "%s +%s -sequence %s -add %d > NUL",
	      MH_MARK_COMMAND, mh_folder[current_folder].folder_name,
	      mh_unseen_seq, article_list[current_article].real_number);
#else	/* !MSDOS */
      sprintf(buff, "%s/%s +%s -sequence %s -add %d > /dev/null 2>&1",
	      mh_command_path, MH_MARK_COMMAND,
	      mh_folder[current_folder].folder_name,
	      mh_unseen_seq, article_list[current_article].real_number);
#endif	/* !MSDOS */
      if (system(buff)) {
	print_fatal("Can't execute mark command.");
      }
    }
  }
  if (!mh_mark_mode) {
    article_list[current_article].mark &= ~mark;
    return;
  }
  if (mark & FORWARD_MARK) {
    if (!(article_list[current_article].mark & FORWARD_MARK)) {
      mark &= ~FORWARD_MARK;
    }
  }
  if (mark & ANSWER_MARK) {
    if (!(article_list[current_article].mark & ANSWER_MARK)) {
      mark &= ~ANSWER_MARK;
    }
  }
  if (!mark) {
    return;
  }
  sprintf(mh_file, "%s%c%s%c%d", mh_path, SLASH_CHAR, select_name, SLASH_CHAR,
	  article_list[current_article].real_number);
  create_backup_name(tmp_file, mh_file);
  if (rename(mh_file, tmp_file)) {
    if (errno != ENOENT) {
      print_fatal("Can't rename mh article.");
    }
    return;
  }
  if ((fp1 = fopen(tmp_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't open mh read article.");
    return;
  }
  if ((fp2 = fopen(mh_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open mh write article.");
    fclose(fp1);
    rename(tmp_file, mh_file);
    return;
  }
  chmod(mh_file, S_IREAD | S_IWRITE);
  article_list[current_article].mark &= ~mark;
  while (fgets(buff, sizeof(buff), fp1)) {
    if ((!buff[0]) || (buff[0] == 'n')) {
      mark = 0;
    }
    if (copy_field(buff, dummy_buff, MH_READ_FIELD)) {
      if (mark & READ_MARK) {
	continue;
      }
    } else if (copy_field(buff, dummy_buff, MH_FORWARD_FIELD)) {
      if (mark & FORWARD_MARK) {
	continue;
      }
    } else if (copy_field(buff, dummy_buff, MH_REPLY_FIELD)) {
      if (mark & ANSWER_MARK) {
	continue;
      }
    }
    fputs(buff, fp2);
  }
  fclose(fp1);
  fclose(fp2);
  unlink(tmp_file);
}

/*
 * ȵ¸
 */

static void	mh_save_current(current_folder)
     int	current_folder;
{
  char	buff[BUFF_SIZE];

  if ((current_folder < 0) || (current_folder >= mh_folder_number)) {
    return;
  }
  if (mh_article_number <= mh_folder[current_folder].current_article) {
    return;
  }
  mh_folder[current_folder].current_article =
    article_list[mh_folder[current_folder].current_article].real_number;
  sprintf(buff, "%d", mh_folder[current_folder].current_article);
  mh_exec_command(MH_FOLDER_COMMAND, mh_folder[current_folder].folder_name,
		  buff);
}

/*
 * ԥå
 */

static void	mh_pick(current_folder, pattern)
     int	current_folder;
     char	*pattern;
{
  FILE	*fp;
  char	buff[BUFF_SIZE];
  int	i, j;

  print_mode_line(japanese ? "ԥåǤ" : "Picking.");
#ifdef	MSDOS
  sprintf(buff, "%s \'+%s\' %s", MH_PICK_COMMAND,
	  mh_folder[current_folder].folder_name, pattern);
#else	/* !MSDOS */
  sprintf(buff, "exec %s%c%s \'+%s\' %s 2> /dev/null", mh_command_path,
	  SLASH_CHAR, MH_PICK_COMMAND,
	  mh_folder[current_folder].folder_name, pattern);
#endif	/* !MSDOS */
  if (fp = popen(buff, "r")) {
    while (fgets(buff, sizeof(buff), fp)) {
      if ((j = atoi(buff)) > 0) {
	for (i = 0; i < mh_article_number; i++) {
	  if (article_list[i].real_number == j) {
	    article_list[i].mark |= DELETE_MARK;
	    break;
	  }
	}
      }
    }
    pclose(fp);
  } else {
    print_fatal("Can't execute pick command.");
  }
}

/*
 * 
 */

static void	mh_count(current_folder, mode)
     int	current_folder;
     int	mode;	/* 0:Ƶʤ 0ʳ:Ƶ */
{
  /* ѿϺƵΤ static ˤʤ */

  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		buff3[BUFF_SIZE];
  char		*ptr, *ptr2;
  struct stat	stat_buff;
#ifdef	HAVE_FILES
  FILES_STRUCT	dp;
#else	/* !HAVE_FILES */
  DIR_PTR	*dp;
  DIR		*dir_ptr;
#endif	/* !HAVE_FILES */
  int		current_article;
  int		top_flag;
  register int	max_number;
  register int	min_number;
  register int	i, j;

  current_article = max_number = min_number = 0;
  if (mh_folder[current_folder].folder_name[0]) {
    top_flag = 0;
    sprintf(buff1, "%s%c%s", mh_path, SLASH_CHAR,
	    mh_folder[current_folder].folder_name);
  } else {
    top_flag = 1;
    strcpy(buff1, mh_path);
    current_article = -1;
  }
  sprintf(buff2, "%s%c%s", buff1, SLASH_CHAR, MH_SEQ_FILE);
  if (mh_folder[current_folder].folder_name[0] &&
      mh_read_field(buff2, buff3, MH_CURRENT_FIELD)) {
    i = atoi(buff3);
  } else {
    i = current_article;
  }
  strcpy(buff2, buff1);
  ptr = buff2;
  while (*ptr) {
    ptr++;
  }
  *ptr++ = SLASH_CHAR;
#ifdef	HAVE_FILES
  sprintf(buff3, "%s%c*.*", buff1, SLASH_CHAR);
  if (!dos_files(buff3, &dp, FILE_ATTR | DIR_ATTR)) {
    current_article = i;
    do {
#ifdef	__TURBOC__
      strcpy(ptr, dp.ff_name);
#else	/* !__TURBOC__ */
      strcpy(ptr, dp.name);
#endif	/* !__TURBOC__ */
#else	/* !HAVE_FILES */
  if (dir_ptr = opendir(buff1)) {
    current_article = i;
    while (dp = readdir(dir_ptr)) {
      strcpy(ptr, dp->d_name);
#endif	/* !HAVE_FILES */
      ptr2 = ptr;
      i = 0;
      while (1) {
	j = *ptr2++ - '0';
	if ((j >= 0) && (j < 10)) {
	  i = i * 10 + j;
	} else {
	  ptr2--;
	  break;
	}
      }
      if (!(*ptr2) && i) {
	if ((min_number > i) || (min_number == 0)) {
	  min_number = i;
	}
	if (max_number < i) {
	  max_number = i;
	}
	i = top_flag;
      } else {
	i = 1;
      }
      if (i) {
	if (!stat(buff2, &stat_buff)) {
	  if (stat_buff.st_mode & S_IFDIR) {
	    if (strcmp(ptr, ".") && strcmp(ptr, "..") && mode) {
	      if (current_article >= 0) {
		sprintf(buff3, "%s%c%s", mh_folder[current_folder].folder_name,
			SLASH_CHAR, ptr);
	      } else {
		strcpy(buff3, ptr);
	      }
	      mh_search_folder(buff3);
	    }
	  }
	}
      }
#ifdef	HAVE_FILES
    } while (!dos_nfiles(&dp));
#else	/* !HAVE_FILES */
    }
    closedir(dir_ptr);
#endif	/* !HAVE_FILES */
  }
  if (current_article >= 0) {
    mh_folder[current_folder].min_article = min_number;
    mh_folder[current_folder].max_article = max_number;
    mh_folder[current_folder].current_article = current_article;
  }
}

/*
 * ȵֹѴ
 */

static int	mh_trans_current(real_number)
     int	real_number;
{
  register int	current_article;
  register int	i;

  current_article = 0;
  for (i = 0; i < mh_article_number; i++) {
    current_article = i;
    if (article_list[current_article].real_number >= real_number) {
      break;
    }
  }
  return(current_article);
}

/*
 * ե
 */

static void	mh_search_all_folder()
{
  char		*ptr;
  register int	i;

  mh_folder_number = mh_alloc_number = 0;
  if (mh_folder) {
    free(mh_folder);
    mh_folder = NULL;
  }
  mh_search_folder("");
  if (mh_folder_number > 0) {
    for (i = 0; i < mh_folder_number; i++) {	/* 	*/
      ptr = mh_folder[i].folder_name;
      while (*ptr) {
	if (*ptr == FOLDER_SEPARATER) {
	  *ptr++ = ' ';
	} else {
	  ptr++;
	}
      }
    }
    qsort(mh_folder, mh_folder_number, sizeof(struct mh_folder),
	  (int (*)())strcmp);
    for (i = 0; i < mh_folder_number; i++) {	/* θ	*/
      ptr = mh_folder[i].folder_name;
      while (*ptr) {
	if (*ptr == ' ') {
	  *ptr++ = FOLDER_SEPARATER;
	} else {
	  ptr++;
	}
      }
    }
  }
}

/*
 * ե
 */

static void	mh_search_folder(folder_name)
     char	*folder_name;
{
  struct mh_folder	*mh_alloc_ptr;

  if (mh_alloc_number <= mh_folder_number) {
    if (mh_folder) {
      mh_alloc_ptr = (struct mh_folder*)
	realloc(mh_folder, (mh_alloc_number + MH_ALLOC_COUNT)
		* sizeof(struct mh_folder));
    } else {
      mh_alloc_ptr = (struct mh_folder*)
	malloc((mh_alloc_number + MH_ALLOC_COUNT)
	       * sizeof(struct mh_folder));
    }
    if (!mh_alloc_ptr) {
      print_fatal("Can't allocate memory for mh folder.");
      return;
    }
    mh_folder = mh_alloc_ptr;
    mh_alloc_number += MH_ALLOC_COUNT;
  }
  if (*folder_name) {
    strcpy(mh_folder[mh_folder_number].folder_name, folder_name);
    mh_count(mh_folder_number++, 1);
  } else {
    mh_folder[0].folder_name[0] = '\0';
    mh_count(0, 1);
  }
}

/*
 * ޥå륰롼׸
 */

static void	mh_match_folder(folder_name)
     char	*folder_name;
{
  int		length1, length2;
  register int	i, j, k, l;
  int		max, min;
  int		match;
  char		*ptr;

  mh_select_number = 0;
  if (mh_selected_folder) {
    free(mh_selected_folder);
    mh_selected_folder = NULL;
  }
  if (!mh_select_number) {
    if (!(mh_selected_folder = (struct mh_folder*)
	  malloc(mh_folder_number * sizeof(struct mh_folder)))) {
      print_fatal("Can't allocate memory for mh select folder.");
      return;
    }
  }
  if (gnus_mode) {
    for (i = 0; i < mh_folder_number; i++) {
      strcpy(mh_selected_folder[mh_select_number].folder_name,
	     mh_folder[i].folder_name);
      mh_selected_folder[mh_select_number].max_article = mh_folder[i].max_article;
      mh_selected_folder[mh_select_number].min_article = mh_folder[i].min_article;
      mh_select_number++;
    }
  } else {

    /*
     * (vin like)⡼ɤν
     * 鲼ν mnews ܤ򤬺ʬǤ
     * νñǤͤºɤޤ
     */

    j = l = 0;
    length1 = strlen(folder_name);
    for (i = 0; i < mh_folder_number; i++) {
      if ((!strncmp(mh_folder[i].folder_name, folder_name, length1)) &&
	  ((!folder_name[0]) ||
	   (!mh_folder[i].folder_name[length1]) ||
	   (mh_folder[i].folder_name[length1] == FOLDER_SEPARATER))) {
	match = 1;
	ptr = &mh_folder[i].folder_name[length1];
	if (*ptr) {
	  k = 0;
	  if (*ptr == FOLDER_SEPARATER) {
	    ptr++;
	    k++;
	  }
	  while (*ptr) {
	    if (*ptr == FOLDER_SEPARATER) {
	      break;
	    }
	    ptr++;
	    k++;
	  }
	  k += length1;
	  for (; j < i; j++) {
	    if (!strncmp(mh_folder[i].folder_name, mh_folder[j].folder_name,
			 k)) {
	      match = 0;
	      break;
	    }
	  }
	} else {
	  k = length1;
	}
	if (match) {
	  max = min = -1;
	  length2 = k;
	  k = 0;
	  for (; l < mh_folder_number; l++) {
	    if ((!strncmp(mh_folder[i].folder_name, mh_folder[l].folder_name,
			  length2)) &&
		((!mh_folder[l].folder_name[length2]) ||
		 (mh_folder[l].folder_name[length2] == FOLDER_SEPARATER))) {
	      if (length2 == strlen(mh_folder[l].folder_name)) {
		if (l + 1 >= mh_folder_number) {
		  k++;
		} else if ((strncmp(mh_folder[l].folder_name,
				    mh_folder[l + 1].folder_name,
				    strlen(mh_folder[l].folder_name))) ||
			   (mh_folder[l + 1].folder_name[strlen(mh_folder[l].folder_name)]
			    != FOLDER_SEPARATER)) {
		  k++;
		} else if (strlen(folder_name)
			   == strlen(mh_folder[l].folder_name)) {
		  k++;
		}
		if (k == 1) {
		  max = mh_folder[l].max_article;
		  min = mh_folder[l].min_article;
		  break;
		}
	      }
	      k = 1;
	    } else if (k) {
	      break;
	    }
	  }
#ifdef	DEBUG
	  printf("MATCH %04d:%s\n", i, mh_folder[i].folder_name);
#endif	/* DEBUG */
	  strcpy(mh_selected_folder[mh_select_number].folder_name,
		 mh_folder[i].folder_name);
	  mh_selected_folder[mh_select_number].folder_name[length2] = '\0';
	  mh_selected_folder[mh_select_number].max_article = max;
	  mh_selected_folder[mh_select_number].min_article = min;
	  mh_select_number++;
	}
      }
    }
  }
}

/*
 * ꥹȼ
 */

static int	mh_get_list(current_folder)
     int	current_folder;
{
  char		buff1[PATH_BUFF];
  char		buff2[BUFF_SIZE];
  int		min_number, max_number;
  char		*ptr;
  register int	i;

  min_number = mh_folder[current_folder].min_article;
  mh_article_number = mh_folder[current_folder].max_article - min_number + 1;
  multi_number = 0;
  if ((mh_article_number <= 0) || (min_number <= 0)) {
    mh_article_number = 0;
    return(0);
#ifdef	MH_MAX_ARTICLE
  } else if (mh_article_number > MH_MAX_ARTICLE) {
    mh_article_number = MH_MAX_ARTICLE;
    min_number = mh_folder[current_folder].max_article - mh_article_number + 1;
#endif	/* MH_MAX_ARTICLE */
  }
  if (article_list) {
    free(article_list);
  }
  if (!(article_list = (ARTICLE_LIST*)
	malloc(sizeof(ARTICLE_LIST) * mh_article_number))) {
    print_fatal("Can't allocate memory for mh article struct.");
    mh_article_number = 0;
    return(1);
  }
  for (i = 0; i < mh_article_number; i++) {
    article_list[i].real_number = min_number + i;
    article_list[i].mark = UNFETCH_MARK;	/* إå̤	*/
  }

  /*	ɥޡ		*/

  if (mh_unseen_seq[0]) {
    for (i = 0; i < mh_article_number; i++) {
      article_list[i].mark |= READ_MARK;	/* 		*/
    }
    sprintf(buff1, "%s%c%s%c%s", mh_path, SLASH_CHAR,
	    mh_folder[current_folder].folder_name, SLASH_CHAR, MH_SEQ_FILE);
    if (mh_read_field(buff1, buff2, mh_unseen_seq)) {
      ptr = buff2;
      if (*ptr == ':') {
	ptr++;
	while (*ptr) {
	  if ((*ptr == ' ') || (*ptr == '\t')) {
	    ptr++;
	  } else {
	    if (!(min_number = atoi(ptr))) {
	      break;
	    }
	    while (isdigit(*ptr)) {
	      ptr++;
	    }
	    if (*ptr == '-') {
	      ptr++;
	      if (!(max_number = atoi(ptr))) {
		break;
	      }
	      while (isdigit(*ptr)) {
		ptr++;
	      }
	    } else {
	      max_number = min_number;
	    }
	    for (i = 0; i < mh_article_number; i++) {
	      if ((article_list[i].real_number >= min_number) &&
		  (article_list[i].real_number <= max_number)) {
		article_list[i].mark &= ~READ_MARK;
	      }
	    }
	  }
	}
      }
    }
  }

  /*	Ƚ	*/

#ifdef	REF_SORT
  if (message_list) {
    print_fatal("Unexpected message list allocation found.");
    free(message_list);
    message_list = NULL;
  }
  if (mh_article_number && (sort_rule == 1)) {
    message_list = (MESSAGE_LIST*)malloc(sizeof(MESSAGE_LIST)
					 * mh_article_number);
  }
#endif	/* REF_SORT */
  if (sort_articles(current_folder, &mh_article_number,
		    mail_thread_mode, mail_article_mask,
		    mh_get_field, NULL) < 0) {
    return(-1);
  }

  /*	ѥå	*/

  if (mail_article_mask) {
    pack_articles(current_folder, &mh_article_number, mh_get_field, NULL);
  }
  return(0);
}

/*
 * إå
 */

static int	mh_get_field(current_article)
     int	current_article;		/*	ֹ̤	*/
{
  FILE			*fp;
  char			tmp_file[PATH_BUFF];
  static char		from_buff[BUFF_SIZE];
  static char		date_buff[MAX_FIELD_LEN];
  static char		subject_buff[BUFF_SIZE];
  static char		x_nsubj_buff[MAX_FIELD_LEN];
  static char		mh_read_buff[2];
  static char		mh_reply_buff[2];
  static char		mh_forward_buff[2];
#ifdef	REF_SORT
  static char		message_buff[MAX_FIELD_LEN];
  static char		reference_buff[BUFF_SIZE];
  static char		in_reply_buff[BUFF_SIZE];
#endif	/* REF_SORT */
  static struct cpy_hdr	mh_fields[] = {
    {FROM_FIELD,	from_buff,	sizeof(from_buff)},
    {DATE_FIELD,	date_buff,	sizeof(date_buff)},
    {SUBJECT_FIELD,	subject_buff,	sizeof(subject_buff)},
    {X_NSUBJ_FIELD,	x_nsubj_buff,	sizeof(x_nsubj_buff)},
    {MH_READ_FIELD,	mh_read_buff,	sizeof(mh_read_buff)},
    {MH_REPLY_FIELD,	mh_reply_buff,	sizeof(mh_reply_buff)},
    {MH_FORWARD_FIELD,	mh_forward_buff,sizeof(mh_forward_buff)},
#ifdef	REF_SORT
    {MESSAGE_FIELD,	message_buff,	sizeof(message_buff)},
    {REFERENCE_FIELD,	reference_buff,	sizeof(reference_buff)},
    {IN_REPLY_FIELD,	in_reply_buff,	sizeof(in_reply_buff)},
#endif	/* REF_SORT */
  };
#ifdef	REF_SORT
  char			*ptr;
#else	/* !REF_SORT */
  short			year;
#endif	/* !REF_SORT */
  short			day, hour, minute, second;

  if ((current_article < 0) || (current_article >= mh_article_number)) {
    return(1);
  }
  article_list[current_article].mark &= ~UNFETCH_MARK;
  sprintf(tmp_file, "%s%c%s%c%d", mh_path, SLASH_CHAR, select_name, SLASH_CHAR,
	  article_list[current_article].real_number);
  if (fp = fopen(tmp_file, "r")) {
    article_list[current_article].lines =
      copy_fields(fp, mh_fields, sizeof(mh_fields)/sizeof(struct cpy_hdr),
		   CF_CLR_MASK | CF_GET_MASK | CF_CNT_MASK | CF_SPC_MASK);
    fclose(fp);
  } else {
    article_list[current_article].mark |= CANCEL_MARK;
    article_list[current_article].mark &= ~READ_MARK;
    return(1);
  }
  if (mh_read_buff[0]) {
    article_list[current_article].mark |= READ_MARK;
  }
  if (mh_reply_buff[0]) {
    article_list[current_article].mark |= ANSWER_MARK;
  }
  if (mh_forward_buff[0]) {
    article_list[current_article].mark |= FORWARD_MARK;
  }
  get_real_adrs(from_buff, article_list[current_article].from, 1);
  if (x_nsubj_mode && x_nsubj_buff[0]) {
    recover_jis(subject_buff, x_nsubj_buff);
  }
  mime_decode_func(from_buff, subject_buff, default_code);
  euc_tab_strncpy(article_list[current_article].subject, from_buff,
		  MAX_SUBJECT_LEN - 1);
#ifdef	REF_SORT
  convert_article_date(date_buff, &article_list[current_article].year,
		       &article_list[current_article].month,
		       &article_list[current_article].date, &day, &hour,
		       &minute, &second, from_buff);
  if (message_list) {
    strncpy(message_list[current_article].msg_id, message_buff,
	    MAX_FIELD_LEN - 1);
    message_list[current_article].msg_id[MAX_FIELD_LEN - 1] = '\0';
    if (ptr = strrchr(reference_buff, '<')) {
      strcpy(message_list[current_article].ref_id, ptr);
    } else if (ptr = strrchr(in_reply_buff, '<')) {
      strcpy(message_list[current_article].ref_id, ptr);
    } else {
      message_list[current_article].ref_id[0] = '\0';
    }
    if (ptr = strchr(message_list[current_article].ref_id, '>')) {
      *(ptr + 1) = '\0';
    }
  }
#else	/* !REF_SORT */
  convert_article_date(date_buff, &year, &article_list[current_article].month,
		       &article_list[current_article].date, &day, &hour,
		       &minute, &second, from_buff);
#endif /* !REF_SORT */
  return(0);
}

/*
 * ե
 */

static int	mh_create_folder(folder_name)
     char	*folder_name;
{
  char	buff[BUFF_SIZE];

  sprintf(buff, "%s%c%s", mh_path, SLASH_CHAR, folder_name);
  if (!mkdir(buff, S_IREAD | S_IWRITE | S_IEXEC)) {
    return(0);
  }
  term_bell();
  print_mode_line(japanese ? "եǤޤǤ" :
		  "Can't create folder.");
  sleep(ERROR_SLEEP);
  return(1);
}

/*
 * ե
 */

static int	mh_delete_folder(folder_name)
     char	*folder_name;
{
  char	buff[BUFF_SIZE];

  sprintf(buff, "%s%c%s%c%s", mh_path, SLASH_CHAR, folder_name,
	  SLASH_CHAR, MH_SEQ_FILE);
  unlink(buff);
  sprintf(buff, "%s%c%s", mh_path, SLASH_CHAR, folder_name);
  if (!rmdir(buff)) {
    return(0);
  }
  term_bell();
  print_mode_line(japanese ? "եǤޤǤ" :
		  "Can't delete folder.");
  sleep(ERROR_SLEEP);
  return(1);
}

/*
 * ե
 */

static int	mh_adjust_folder(folder_name)
     char	*folder_name;
{
  int	current_folder;
  int	i;

  current_folder = 0;
  for (i = 0; i < mh_select_number; i++) {
    if (strcmp(mh_selected_folder[i].folder_name, folder_name) > 0) {
      break;
    }
    current_folder = i;
  }
  return(current_folder);
}

/*
 * եɼ
 */

static int	mh_read_field(filename, ptr2, field)
     char		*filename;
     unsigned char	*ptr2;
     unsigned char	*field;
{
  FILE		*fp;
  unsigned char	buff[BUFF_SIZE];
  unsigned char	*ptr1;

  if (fp = fopen(filename, "r")) {
    while (fgets2(buff, sizeof(buff), fp)) {
      if (!strncasecmp(buff, field, strlen(field))) {
	ptr1 = &buff[strlen(field)];
	while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
	  ptr1++;
	}
	strcpy((char*)ptr2, (char*)ptr1);
	while (*ptr2) {
	  if (*ptr2 == '\n') {
	    *ptr2 = '\0';
	    break;
	  }
	  ptr2++;
	}
	fclose(fp);
	return(1);
      }
    }
    fclose(fp);
  }
  return(0);
}

/*
 * MH եص
 */

int	save_mh_folder(current_article, extract)
     int	current_article;
     int	(*extract)();
{
  char		buff1[SMALL_BUFF];
  char		buff2[SMALL_BUFF];
  char		buff3[SMALL_BUFF];
  char		*ptr, *ptr2;
#ifdef	HAVE_FILES
  FILES_STRUCT	dp;
#else	/* !HAVE_FILES */
  DIR_PTR	*dp;
  DIR		*dir_ptr;
#endif	/* !HAVE_FILES */
  register int	max_number;
  register int	i, j;
  int		status;

  max_number = 0;
  strcpy(buff1, mh_path);
  input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
	     "֤ե̾ϤƲ:",
	     "Input save folder name:", buff1);
  if (!buff1[0]) {
    return(1);
  }
  sprintf(buff2, "%s%c%s", mh_path, SLASH_CHAR, buff1);
#ifdef	HAVE_FILES
  sprintf(buff3, "%s%c*.*", buff2, SLASH_CHAR);
  if (!dos_files(buff3, &dp, FILE_ATTR)) {
    ptr = buff2;
    while (*ptr) {
      *ptr++;
    }
    *ptr++ = SLASH_CHAR;
    do {
#ifdef	__TURBOC__
      strcpy(ptr, dp.ff_name);
#else	/* !__TURBOC__ */
      strcpy(ptr, dp.name);
#endif	/* !__TURBOC__ */
#else	/* !HAVE_FILES */
  if (dir_ptr = opendir(buff2)) {
    strcpy(buff3, buff2);
    ptr = buff3;
    while (*ptr) {
      *ptr++;
    }
    *ptr++ = SLASH_CHAR;
    while (dp = readdir(dir_ptr)) {
      strcpy(ptr, dp->d_name);
#endif	/* !HAVE_FILES */
      ptr2 = ptr;
      i = 0;
      while (1) {
	j = *ptr2++ - '0';
	if ((j >= 0) && (j < 10)) {
	  i = i * 10 + j;
	} else {
	  ptr2--;
	  break;
	}
      }
      if (!(*ptr2) && i) {
	if (max_number < i) {
	  max_number = i;
	}
      }
#ifdef	HAVE_FILES
    } while (!dos_nfiles(&dp));
#else	/* !HAVE_FILES */
    }
    closedir(dir_ptr);
#endif	/* !HAVE_FILES */
  } else {
    if (yes_or_no(NORMAL_YN_MODE, "ե(%s)򿷵ޤ?",
		  "Create folder(%s).Are you sure?",
		  buff1)) {
      if (mh_create_folder(buff1)) {
	return(1);
      }
    } else {
      return(1);
    }
  }
  j = unixfrom_mode;
  unixfrom_mode = 0;	/* ~/.mnews_setup ˴ؤ餺 MH եޥåȤ */
  status = 0;
  if (multi_number) {
    for (i = 0; i < multi_number; i++) {
      sprintf(buff1, "%s%c%d", buff2, SLASH_CHAR, ++max_number);
      if (save_article(article_list[multi_list[i]].real_number, extract,
		       buff1)) {
	status = 1;
      }
    }
  } else {
    sprintf(buff1, "%s%c%d", buff2, SLASH_CHAR, max_number + 1);
    status = save_article(article_list[current_article].real_number, extract,
			  buff1);
  }
  unixfrom_mode = j;
  if (status) {
    print_mode_line(japanese ? "֤ǤޤǤ" :
		    "Save article failed.");
    term_bell();
    sleep(ERROR_SLEEP);
  }
  return(status);
}

/*
 * MH ޥɼ¹
 */

static int	mh_exec_command(command, folder_name, args)
     char	*command;
     char	*folder_name;
     char	*args;
{
  char		buff[BUFF_SIZE];

  if (!args) {
    args = "";
  }
#ifdef	MSDOS
  sprintf(buff, "%s \'+%s\' %s > NUL", command, folder_name, args);
#else	/* !MSDOS */
  sprintf(buff, "exec %s%c%s \'+%s\' %s > /dev/null 2>&1", mh_command_path,
	  SLASH_CHAR, command, folder_name, args);
#endif	/* !MSDOS */
#ifdef	DEBUG
  printf("EXEC \"%s\"", buff);
  sleep(10);
#else	/* !DEBUG */
 if (system(buff)) {
    print_fatal("Can't execute %s command.", command);
    return(1);
  }
#endif	/* !DEBUG */
  return(0);
}

#ifndef	SMALL
/*
 * ե̾(ʣ)
 */

static int	mh_search_name(mode, max_number, folder_ptr)
     int	mode;
     int	max_number;
     int	*folder_ptr;
{
  register int	current_folder;
  char		*str;

  if (str = input_search_string(mode)) {
    if (mode) {
      for (current_folder = *folder_ptr - 1; current_folder >= 0;
	   current_folder--) {
	if (strindex(mh_selected_folder[current_folder].folder_name, str)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *folder_ptr = current_folder;
	  return(0);
	}
      }
    } else {
      for (current_folder = *folder_ptr + 1; current_folder < max_number;
	   current_folder++) {
	if (strindex(mh_selected_folder[current_folder].folder_name, str)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *folder_ptr = current_folder;
	  return(0);
	}
      }
    }
    print_mode_line(japanese ? "ĤޤǤ" : "Search failed.");
    return(1);
  }
  return(0);
}
#endif	/* !SMALL */

#ifdef	MAILSEND
/*
 * MH ꥢŸ
 */

int	mh_expand_alias(recipient, alias, number)
     char	*recipient;
     char	*alias;
     int	number;
{
  FILE	*fp;
  char	buff[BUFF_SIZE];
  char	*ptr1, *ptr2;
  int	status;

  strcpy(recipient, alias);
#ifdef	MSDOS
  sprintf(buff, "%s %s", MH_ALI_COMMAND, alias);
#else	/* !MSDOS */
  sprintf(buff, "exec %s%c%s %s", mh_command_path, SLASH_CHAR,
	  MH_ALI_COMMAND, alias);
#endif	/* !MSDOS */
  status = 0;
  signal(SIGPIPE, pipe_error);
  if (fp = popen(buff, "r")) {
    ptr1 = recipient;
    if (fgets(buff, sizeof(buff), fp)) {
      ptr2 = buff;
      while (*ptr2 >= ' ') {
	if (--number <= 0) {
	  status = 1;
	  break;
	}
	*ptr1++ = *ptr2++;
      }
      *ptr1 = '\0';
    } else {
      status = 1;
    }
    if (pclose(fp)) {
      status = 1;
    }
  } else {
    status = 0;
  }
  signal(SIGPIPE, SIG_IGN);
  return(status);
}
#endif	/* MAILSEND */

#ifdef	USE_MSGCHK
/*
 * MH ᡼å
 */

int	mh_chkmsg()
{
  char		buff[SMALL_BUFF];

#ifdef	MSDOS
  sprintf(buff, "%s > NUL", MH_MSGCHK_COMMAND);
#else	/* !MSDOS */
  sprintf(buff, "exec %s%c%s > /dev/null 2>&1",
	  mh_command_path, SLASH_CHAR, MH_MSGCHK_COMMAND);
#endif	/* !MSDOS */
  return(!system(buff));
}
#endif	/* USE_MSGCHK */
#endif	/* MH */
