/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : Main define
 *  File        : mnews.h
 *  Version     : 1.19
 *  First Edit  : 1991-07/25
 *  Last  Edit  : 1995-07/21
 *  Author      : MSR24  
 *
 */

#ifndef		DONT_HAVE_FTIME
#include	<sys/timeb.h>
#endif		/* DONT_HAVE_FTIME */

#define	READER_NAME	"mnews"
#define	MNEWS_VERSION	"1.19"
#define	MNEWS_DATE	"1995-07/21(Fri)"
#define	ERROR_FILE	"mnewserr"
#ifdef	MSDOS
#ifdef	X68K
#define	SIGNATURE_FILE	"_signature"
#else	/* !X68K */
#define	SIGNATURE_FILE	"_sign"
#endif	/* !X68K */
#define	MESSAGE_FILE	"_message"
#define	DEAD_FILE	"deadmail"
#else	/* !MSDOS */
#define	SIGNATURE_FILE	".signature"
#define	MESSAGE_FILE	".message"
#define	DEAD_FILE	"dead.letter"
#endif	/* !MSDOS */
#define	FROM_JN_DOMAIN	"familyname"

/*
 * ᡼ե
 */

#ifndef	FROM_FIELD
#define	FROM_FIELD	"From:"
#endif	/* !FROM_FIELD */
#ifndef	TO_FIELD
#define	TO_FIELD	"To:"
#endif	/* !TO_FIELD */
#ifndef	CC_FIELD
#define	CC_FIELD	"Cc:"
#endif	/* !CC_FIELD */
#ifndef	BCC_FIELD
#define	BCC_FIELD	"Bcc:"
#endif	/* !BCC_FIELD */
#ifndef	FCC_FIELD
#define	FCC_FIELD	"Fcc:"
#endif	/* !FCC_FIELD */
#ifndef	DATE_FIELD
#define	DATE_FIELD	"Date:"
#endif	/* !DATE_FIELD */
#ifndef	SUBJECT_FIELD
#define	SUBJECT_FIELD	"Subject:"
#endif	/* !SUBJECT_FIELD */
#ifndef	REPLY_FIELD
#define	REPLY_FIELD	"Reply-To:"
#endif	/* !REPLY_FIELD */
#ifndef	IN_REPLY_FIELD
#define	IN_REPLY_FIELD	"In-Reply-To:"
#endif	/* !IN_REPLY_FIELD */
#ifndef	APP_TO_FIELD
#define	APP_TO_FIELD	"Apparently-To:"
#endif	/* !APP_TO_FIELD */
#ifndef	LENGTH_FIELD
#define	LENGTH_FIELD	"Content-Length:"
#endif	/* !LENGTH_FIELD */

/*
 * ˥塼Ϣ
 */

#define	MAX_FROM_LEN		64	/* MAX_FIELD_LEN 꾮 */
#define	MAX_SUBJECT_LEN		128	/* MAX_FIELD_LEN 꾮 */
#define	MAX_FIELD_COLUMN	76
#define	MAX_MULTI_NUMBER	30
#define	MAX_THREAD_SEARCH	100

/*
 * ¾
 */

#ifndef	LF
#define	LF	0x0a
#endif	/* !LF */
#ifndef	BUFF_SIZE
#define	BUFF_SIZE	1024
#endif	/* !BUFF_SIZE */
#ifndef	SMALL_BUFF
#define	SMALL_BUFF	256
#endif	/* !SMALL_BUFF */
#define	REPLY_SUBJECT	"Re: "	/* ץ饤֥		*/
#define REPLY_MESSAGE	"Your message of "
#define	FORWARD_BEGIN_MESSAGE	"------- Forwarded Message"
#define	FORWARD_END_MESSAGE	"------- End of Forwarded Message"
#define	TEXT_SEPARATER	"--text follows this line--"
#define	MULTI_END_MARK	"\001\n"/* ޥΥѥ졼	 */
#define	ERROR_SLEEP	3	/* 顼ȯԤ	*/
#define	HEAD_LINES	3
#define	BOTTOM_LINES	1
#define	MODE_LINES	(HEAD_LINES + BOTTOM_LINES)
#define	MAX_MAIL_GROUP	6
#define	MAX_WRITE_FILE	4
#define	JST_OFFSET	-9

/*
 * ޡꥹȹ¤
 */

typedef	struct mark_struct	MARK_LIST;
struct mark_struct {
  MARK_LIST	*prev_ptr;
  MARK_LIST	*next_ptr;
  int		start_number;
  int		end_number;
};

/*
 * 롼״¤
 */

typedef	struct group_struct	GROUP_LIST;
struct group_struct {
  int		unread_article;
  MARK_LIST	*mark_ptr;
  short		match_flag;
  short		unsubscribe;
  short		mark_order;
};

/*
 * ̵롼״¤
 */

typedef	struct bogus_struct	BOGUS_LIST;
struct bogus_struct {
  char		group_name[MAX_GROUP_NAME];
  BOGUS_LIST	*next_ptr;
  MARK_LIST	*mark_ptr;
  short		mark_order;
  short		unsubscribe;
};

/*
 * Message-ID ¤
 */

#ifdef	REF_SORT
typedef	struct message_struct	MESSAGE_LIST;
struct message_struct {
  char		msg_id[MAX_FIELD_LEN];
  char		ref_id[MAX_FIELD_LEN];
};
#endif	/* REF_SORT */

/*
 * ¤
 */

typedef	struct article_struct	ARTICLE_LIST;
struct article_struct {
  int		real_number;
  char		from[MAX_FROM_LEN];
  char		subject[MAX_SUBJECT_LEN];
  short		mark;
#ifdef	REF_SORT
  short		year;
#endif	/* REF_SORT */
  short		month;
  short		date;
  short		lines;
};

typedef enum {
  NORMAL_YN_MODE,
  CARE_YN_MODE,
  FILE_YN_MODE,
  JUMP_YN_MODE,
  SEND_YN_MODE,
} y_n_mode;

/*
 * ޡ
 */

#define	READ_MARK	0x0001
#define	FORWARD_MARK	0x0002
#define	ANSWER_MARK	0x0004
#define	DELETE_MARK	0x0008
#define	MULTI_MARK	0x0010
#define	UNFETCH_MARK	0x0040
#define	CANCEL_MARK	0x0080
#define	SORT_MARK	0x0100
#define	THREAD_MARK	0x0200

/*
 * ϻޥ
 */

#define	GLOBAL_MODE_MASK	0x01
#define	GROUP_MODE_MASK		0x02
#define	SUBJECT_MODE_MASK	0x04
#define	LINE_MODE_MASK		0x08
#define	YN_MODE_MASK		0x10
#define	NEWS_MODE_MASK		0x20

#define	INPUT_SPCCUT_MASK	0x01
#define	INPUT_EXPAND_MASK	0x02
#define	INPUT_COMP_MASK		0x04
#define	INPUT_FOLDER_MASK	0x08
#define	INPUT_SHADOW_MASK	0x10

/*
 * 顼ǥå
 */

enum color_code {
  TITLE_COLOR,
  HEADER_COLOR,
  GUIDE_COLOR,
  ERROR_COLOR,
  CATEGORY_COLOR,
  MARK_COLOR,
  NUMBER_COLOR,
  FROM_COLOR,
  DATE_COLOR,
  LINE_COLOR,
  SUBJECT_COLOR,
  THREAD_COLOR,
  LOST_COLOR,
};

extern GROUP_LIST	*group_list;
extern BOGUS_LIST	*bogus_list;
extern ARTICLE_LIST	*article_list;
#ifndef	MSDOS
extern struct passwd	*passwd;
#endif	/* !MSDOS */

extern char	*month_string[];	/* ̾				*/
extern char	*day_string[];		/* ̾			*/
extern char	*day_jstring[];		/* ̾(ܸ)		*/
extern char	*mail_spool;		/* ᡼륹ס		*/
extern char	*jnames_file;		/* JNAMES ǡե	*/
extern char	domain_name[];		/* ɥᥤ̾			*/
extern char	user_name[];		/* 桼̾			*/
extern char	user_gecos[];		/* 桼			*/
extern char	home_dir[];		/* ۡǥ쥯ȥ		*/
extern char	dot_dir[];		/* ɥåȥǥ쥯ȥ		*/
extern char	edit_command[];		/* ǥޥ		*/
extern char	*connect_string[];	/* ³⡼ɥå		*/
extern char	*newmail_string[];	/* ᡼å		*/
extern char	*cons_opt;		/* åȹץ	*/
extern char	*conf_opt;		/* åꥪץ	*/
extern char	*arch_opt;		/* ƥ㥪ץ	*/
extern char	*install_host;		/* 󥹥ȡۥ̾		*/
extern char	*install_user;		/* 󥹥ȡ桼̾		*/
extern char	*install_date;		/* 󥹥ȡ		*/
extern char	mark_file[];		/* ޡե		*/
extern char	pager[];		/* ڡ㡼ޥ		*/
extern char	tmp_dir[];		/* ȥǥ쥯ȥ		*/
extern char	save_dir[];		/* ֥ǥ쥯ȥ	*/

extern int	multi_list[];		/* ޥե/ץ饤ꥹ*/
extern int	multi_number;		/* ޥե/ץ饤	*/
extern short	nspl_mode;		/* NSPL ѥ⡼		*/
extern short	pager_mode;		/* ڡ㡼⡼		*/
extern short	japanese;		/* ܸ⡼ɥե饰		*/
extern short	jnames;			/* JNAMES ѥե饰		*/
extern short	quiet_mode;		/* ٹɽ⡼		*/
extern short	skip_mode;		/* إååץ⡼		*/
extern short	mail_mode;		/* ᡼뻲ѥ⡼		*/
extern short	error_mode;		/* 顼⡼		*/
extern short	mh_mark_mode;		/* MH ޡ⡼		*/
extern short	color_mode;		/* 顼⡼			*/
extern short	wide_mode;		/* 磻ɥ⡼			*/
extern short	bell_mode;		/* ᡼Υ٥벻⡼	*/
extern short	x_nsubj_mode;		/* X-Nsubject: ⡼		*/
extern short	x_nsubj_org;		/* X-Nsubject: ꥸʥ⡼	*/
extern short	jst_mode;		/* ܻѴ⡼		*/
extern short	mime_format;		/* MIME եޥåȽ	*/
extern int	default_code;		/* Ƚǽδ	*/
extern int	edit_code;		/* ǥ		*/
extern int	save_code;		/* ִ		*/
extern int	input_code;		/* 1 ϴ		*/
extern int	mime_form_char;		/* MIME եޥåȥ⡼ʸ	*/
extern int	(*mime_encode_func)();	/* MIME ǥɴؿ		*/
extern int	(*mime_decode_func)();	/* MIME ǥɴؿ		*/

extern short	head_lines;		/* إå饤Կ		*/
extern short	mode_lines;		/* ⡼ɥ饤Կ		*/
extern short	color_code[];		/* 顼			*/

void		help();			/* إɽ(ˡ)	*/
void		print_title();		/* ȥɽ			*/
#if	defined(__STDC__) && !defined(DONT_HAVE_DOPRNT)
void		print_mode_line(char*, ...);
					/* ⡼ɥ饤ɽ		*/
void		print_full_line(char*, ...);
					/* 1 ԥեɽ			*/
#else	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
void		print_mode_line();	/* ⡼ɥ饤ɽ		*/
void		print_full_line();	/* 1 ԥեɽ			*/
#endif	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
void		input_line();		/* 1 			*/
char		*input_search_string();	/* ʸ		*/
#if	defined(__STDC__) && !defined(DONT_HAVE_DOPRNT)
int		yes_or_no(y_n_mode, char*, char*, ...);
					/* Y/N ϳǧ			*/
void		edit_fprintf(FILE*, char*, ...);
					/* ǥѴʸ	*/
#else	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
int		yes_or_no();		/* Y/N ϳǧ			*/
void		edit_fprintf();		/* ǥѴʸ	*/
#endif	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
void		field_fprintf();	/* եɥեޥåȽ	*/
void		suspend();		/* ڥ			*/
#if	defined(__STDC__) && !defined(DONT_HAVE_DOPRNT)
void		print_warning(char*, ...);
					/* ٹ𥨥顼ɽ		*/
void		print_fatal(char*, ...);/* ̿Ū顼ɽ		*/
#else	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
void		print_warning();	/* ٹ𥨥顼ɽ		*/
void		print_fatal();		/* ̿Ū顼ɽ		*/
#endif	/* (!__STDC__ && !DONT_HAVE_DOPRNT) */
char		*strindex();		/* ʸ󸡺			*/
int		fgets2();		/* ե뤫 1 	*/
int		convert_code();		/* Ѵ		*/
void		convert_article_date();	/* եեޥåѴ	*/
char		*next_param();		/* Υѥ᡼		*/
int		gmt_to_jst();		/* GMT ֤ JST Ѵ	*/
char		*get_real_adrs();	/* ¥ɥ쥹		*/
void		get_jadrs();		/* ܸ쥢ɥ쥹		*/
void		get_jname();		/* ܸ̾			*/
int		get_key();		/* 1 ʸ		*/
int		get_top_position();	/* ַ׻		*/
int		check_new_mail();	/* ᡼å		*/
int		exec_pager();		/* ڡ㵯ư			*/
int		exec_editor();		/* ǥư			*/
int		reopen_server();	/* NNTP к³		*/
void		set_mime_decode_func();	/* MIME ǥɴؿϿ	*/
void		pipe_error();		/* ѥץ顼ϥɥ		*/
void		force_exit();		/* λ			*/
FILE		*fopen2();		/* ե			*/
int		fclose2();		/* ե			*/
int		funlink2();		/* ե			*/
void		euc_tab_strncpy();	/* EUC ʸ󥳥ԡ		*/
void		usage();		/* إɽ			*/

int		news_config();		/* ˥塼ե졼	*/
int		env_config();		/* Ķե졼	*/
void		setup_mono();		/* Υ⡼ɥ顼	*/
void		create_msg_id();	/* Message-ID 		*/
