/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : News post routine
 *  File        : newspost.c
 *  Version     : 1.19
 *  First Edit  : 1992-08/03
 *  Last  Edit  : 1995-07/17
 *  Author      : MSR24  
 *
 */

#ifdef	NEWSPOST
#include	"compat.h"
#include	"nntplib.h"
#include	"mnews.h"
#include	"kanjilib.h"
#include	"termlib.h"
#include	"newspost.h"
#include	"group.h"
#include	"article.h"
#include	"pager.h"
#include	"fcc.h"
#include	"mailsend.h"
#include	"mime.h"

static int	exec_post();		/* ˥塼(̴ؿ)	*/

/*
 * ˥塼
 */

int	news_post(group_name)
     char	*group_name;
{
  char	tmp_file[PATH_BUFF];
  char	backup_file[PATH_BUFF];
  char	group_buff[MAX_FIELD_LEN];
  char	dist_buff[MAX_FIELD_LEN];
  char	subject_buff[MAX_FIELD_LEN];
  FILE	*fp;
  int	first;
  int	status;

#ifdef	SEND_CONFIRM
  if (!yes_or_no(NORMAL_YN_MODE, "Ƥޤ?",
		 "Post new article.Are you sure?")) {
    return(1);
  }
#endif	/* SEND_CONFIRM */
  strcpy(group_buff, group_name);
  if (!group_buff[0]) {
    input_line(INPUT_SPCCUT_MASK, "˥塼롼פϤƲ:",
	       "Input news group:", group_buff);
    if (!group_buff[0]) {
      return(1);
    }
  }
  subject_buff[0] = '\0';
  input_line(0, "̾(subject)ϤƲ:",
	     "Input subject:", subject_buff);
  if (!subject_buff[0]) {
    return(1);
  }
  dist_buff[0] = '\0';
  input_line(INPUT_SPCCUT_MASK, "ϰ(distribution)ϤƲ:",
	     "Input distribution:", dist_buff);
  sprintf(tmp_file, "%s%c%s", dot_dir, SLASH_CHAR, MESSAGE_FILE);
  create_backup_name(backup_file, tmp_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  rename(tmp_file, backup_file);
  if ((fp = fopen(tmp_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open news write file.");
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  if (news_field[0]) {
    edit_fprintf(fp, "%s\n", news_field);
  }
  fprintf(fp, "%s %s\n", GROUP_FIELD, group_buff);
  fprintf(fp, "%s %s\n", DIST_FIELD, dist_buff);
  fprintf(fp, "%s \n", FOLLOWUP_FIELD);
  edit_fprintf(fp, "%s %s\n", SUBJECT_FIELD, subject_buff);
  if (x_nsubj_mode) {
    if (discriminate_code(subject_buff) != ASCII_CODE) {
      fprintf(fp, "%s %s\n", X_NSUBJ_FIELD, subject_buff);
    } else {
      fprintf(fp, "%s \n", X_NSUBJ_FIELD);
    }
  }
#ifdef	FCC
  if (news_fcc_field[0]) {
    fprintf(fp, "%s %s\n", FCC_FIELD, news_fcc_field);
  }
#endif	/* FCC */
  fprintf(fp, "%s\n", TEXT_SEPARATER);
  fclose(fp);
  first = 1;
 EDIT:
  if (!exec_editor(tmp_file, first)) {
    first = 0;
    while (1) {
      if ((status = exec_post(tmp_file)) != -3) {
	break;
      }
    }
    if (status) {
      if (status > 0) {
	print_mode_line(japanese ? "˥塼Ƥ˼Ԥޤ" :
			"Post article failed.");
	term_bell();
	sleep(ERROR_SLEEP);
      } else if (status == -2) {
	goto EDIT;
      }
      return(1);
    }
    return(0);
  }
  return(1);
}

/*
 * ˥塼ե
 */

int	news_follow(base_file, mask)
     char	*base_file;
     int	mask;
{
  FILE			*fp1, *fp2;
  char			tmp_file[PATH_BUFF];
  char			backup_file[PATH_BUFF];
  char			buff1[BUFF_SIZE];
  char			buff2[BUFF_SIZE];
  static char		from_buff[MAX_FIELD_LEN];
  static char		date_buff[MAX_FIELD_LEN];
  static char		message_buff[MAX_FIELD_LEN];
  static char		subject_buff[MAX_FIELD_LEN];
  static char		group_buff[MAX_FIELD_LEN];
  static char		dist_buff[MAX_FIELD_LEN];
  static char		reference_buff[MAX_FIELD_LEN * 10];
  static char		followup_buff[MAX_FIELD_LEN];
  static char		x_nsubj_buff[MAX_FIELD_LEN];
  static struct cpy_hdr	follow_fields[] = {
    {FROM_FIELD,	from_buff,	sizeof(from_buff)},
    {DATE_FIELD,	date_buff,	sizeof(date_buff)},
    {MESSAGE_FIELD,	message_buff,	sizeof(message_buff)},
    {SUBJECT_FIELD,	subject_buff,	sizeof(subject_buff)},
    {GROUP_FIELD,	group_buff,	sizeof(group_buff)},
    {DIST_FIELD,	dist_buff,	sizeof(dist_buff)},
    {REFERENCE_FIELD,	reference_buff,	sizeof(reference_buff)},
    {FOLLOWUP_FIELD,	followup_buff,	sizeof(followup_buff)},
    {X_NSUBJ_FIELD,	x_nsubj_buff,	sizeof(x_nsubj_buff)},
  };
  char			*ptr1, *ptr2;
  int			first;
  int			status;

#ifdef	SEND_CONFIRM
  if (!yes_or_no(NORMAL_YN_MODE, "եޤ?",
		 "Follow article.Are you sure?")) {
    return(1);
  }
#endif	/* SEND_CONFIRM */
  print_mode_line(japanese ? "ѴǤ" : "Converting.");
  if ((fp1 = fopen(base_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't open post read file.");
    return(1);
  }
  sprintf(tmp_file, "%s%c%s", dot_dir, SLASH_CHAR, MESSAGE_FILE);
  create_backup_name(backup_file, tmp_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  rename(tmp_file, backup_file);
  if ((fp2 = fopen(tmp_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open post write file.");
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  if (news_field[0]) {
    edit_fprintf(fp2, "%s\n", news_field);
  }
  copy_fields(fp1, follow_fields,
	      sizeof(follow_fields)/sizeof(struct cpy_hdr),
	      CF_CLR_MASK | CF_GET_MASK | CF_SPC_MASK);
  if (followup_buff[0]) {
    if (!strcmp(followup_buff, POSTER)) {
      fclose(fp1);
      fclose(fp2);
      unlink(tmp_file);
      return(mail_reply(base_file, mask, ""));
    }
    fprintf(fp2, "%s %s\n", GROUP_FIELD, followup_buff);
  } else {
    fprintf(fp2, "%s %s\n", GROUP_FIELD, group_buff);
  }
  fprintf(fp2, "%s %s\n", DIST_FIELD, dist_buff);
  strcpy(buff1, subject_buff);
  mime_decode_func(subject_buff, buff1, default_code);
  if (strncasecmp(subject_buff, REPLY_SUBJECT, sizeof(REPLY_SUBJECT) - 1)) {
    edit_fprintf(fp2, "%s %s%s\n", SUBJECT_FIELD, REPLY_SUBJECT, subject_buff);
  } else {
    edit_fprintf(fp2, "%s %s\n", SUBJECT_FIELD, subject_buff);
  }
  if (x_nsubj_mode) {
    if (x_nsubj_buff[0]) {
      recover_jis(subject_buff, x_nsubj_buff);
    } else {
      subject_buff[0] = '\0';
    }
    if (strncasecmp(subject_buff, REPLY_SUBJECT, sizeof(REPLY_SUBJECT) - 1)
	&& subject_buff[0]) {
      edit_fprintf(fp2, "%s %s%s\n", X_NSUBJ_FIELD, REPLY_SUBJECT,
		   subject_buff);
    } else {
      edit_fprintf(fp2, "%s %s\n", X_NSUBJ_FIELD, subject_buff);
    }
  }

  /*
   * Reference: եɺ
   */

  ptr1 = reference_buff;
  if (!(mask & FOLLOW_QUOTE_MASK)) {
    *ptr1 = '\0';
  }
  first = status = 1;
  while (1) {
    if (!(*ptr1)) {
      if (status) {
	ptr1 = message_buff;
	status = 0;
      } else {
	break;
      }
    }
    while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
      ptr1++;
    }
    ptr2 = buff1;
    while (*ptr1) {
      if (*ptr1 == '>') {
	*ptr2++ = *ptr1++;
	break;
      } else if (*ptr1 == '\n') {
	break;
      }
      *ptr2++ = *ptr1++;
    }
    *ptr2 = '\0';
    if (first) {
      fprintf(fp2, "%s %s\n", REFERENCE_FIELD, buff1);
      first = 0;
    } else {
      fprintf(fp2, "\t%s\n", buff1);
    }
  }
#ifdef	FCC
  if (news_fcc_field[0]) {
    fprintf(fp2, "%s %s\n", FCC_FIELD, news_fcc_field);
  }
#endif	/* FCC */
  fprintf(fp2, "%s\n", TEXT_SEPARATER);
  if (mask & FOLLOW_QUOTE_MASK) {
    fseek(fp1, 0L, 0);
    ptr1 = NULL;
    while (1) {
      copy_fields(fp1, follow_fields,
		  sizeof(follow_fields)/sizeof(struct cpy_hdr),
		  CF_CLR_MASK | CF_GET_MASK | CF_SPC_MASK);
      if (feof(fp1)) {
	break;
      }
      if (follow_message[0]) {
	ptr1 = follow_message;
      } else {
	ptr1 = (japanese ? "%Iεˤ\n%F{,}Ͻ񤭤ޤ\n" :
		"In article %I\n%F writes:\n");
      }
      field_fprintf(fp2, ptr1,
		    from_buff, subject_buff, message_buff,
		    group_buff, date_buff);
      fprintf(fp2, "\n");
      while (fgets(buff1, sizeof(buff1), fp1)) {
	if (!strcmp(buff1, MULTI_END_MARK)) {
	  fprintf(fp2, "\n");
	  break;
	}
	field_fprintf(fp2, reply_indicator,
		      from_buff, subject_buff, message_buff,
		      group_buff, date_buff);
	to_euc(buff2, buff1, default_code);
	edit_fprintf(fp2, "%s", buff2);
      }
      if (feof(fp1)) {
	break;
      }
    }
  }
  fclose(fp1);
  fclose(fp2);
  first = 1;
 EDIT:
  if (!exec_editor(tmp_file, first)) {
    first = 0;
    while (1) {
      if ((status = exec_post(tmp_file)) != -3) {
	break;
      }
    }
    if (status) {
      if (status > 0) {
	print_mode_line(japanese ? "˥塼Υե˼Ԥޤ" :
			"Post follow article failed.");
	term_bell();
	sleep(ERROR_SLEEP);
      } else if (status == -2) {
	goto EDIT;
      }
      return(1);
    }
    return(0);
  }
  return(1);
}

/*
 * ˥塼󥻥
 */

int	news_cancel(article_number)
     int	article_number;
{
  FILE			*fp;
  char			buff1[SMALL_BUFF];
  char			buff2[SMALL_BUFF];
  static char		from_buff[BUFF_SIZE];
  static char		group_buff[MAX_FIELD_LEN];
  static char		dist_buff[MAX_FIELD_LEN];
  static char		message_buff[MAX_FIELD_LEN];
  char			tmp_file[PATH_BUFF];
  char			*ptr1, *ptr2;
  static struct cpy_hdr	cancel_fields[] = {
    {FROM_FIELD,	from_buff,	sizeof(from_buff)},
    {MESSAGE_FIELD,	message_buff,	sizeof(message_buff)},
    {GROUP_FIELD,	group_buff,	sizeof(group_buff)},
    {DIST_FIELD,	dist_buff,	sizeof(dist_buff)},
  };
  int			status;

  if (nntp_copy_fields(article_number, cancel_fields,
		       sizeof(cancel_fields)/sizeof(struct cpy_hdr),
		       CF_CLR_MASK | CF_GET_MASK)) {
    return(1);
  }
  get_real_adrs(from_buff, buff1);

  /*
   * ʬεĴ٤
   */

  ptr1 = from_buff;
  if (!strncmp(news_field, FROM_FIELD, sizeof(FROM_FIELD) - 1)) {
    ptr2 = &news_field[sizeof(FROM_FIELD) - 1];
    while ((*ptr2 == ' ') || (*ptr2 == '\t')) {
      ptr2++;
    }
    while (*ptr2) {
      if (!strncmp(ptr2, "\\n", 2)) {
	break;
      }
      *ptr1++ = *ptr2++;
    }
    *ptr1 = '\0';
  } else {
    if (user_gecos[0]) {
      sprintf(ptr1, "%s@%s (%s)", user_name, domain_name, user_gecos);
    } else {
      sprintf(ptr1, "%s@%s", user_name, domain_name);
    }
  }
  get_real_adrs(from_buff, buff2);
  if (strcmp(buff1, buff2)) {
    return(1);
  }
  if ((group_buff[0] == '0') || (message_buff[0] == '\0')) {
    return(1);
  }
  create_temp_name(tmp_file, "PS");
  if ((fp = fopen2(tmp_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't open news write file.");
    return(1);
  }
  fprintf(fp, "%s %s\n", FROM_FIELD, from_buff);
  fprintf(fp, "%s %s\n", GROUP_FIELD, group_buff);
  if (dist_buff[0]) {
    fprintf(fp, "%s %s\n", DIST_FIELD, dist_buff);
  }
  fprintf(fp, "%s %s %s\n", SUBJECT_FIELD, CANCEL_CONTROL, message_buff);
  fprintf(fp, "%s %s %s\n\n", CONTROL_FIELD, CANCEL_CONTROL, message_buff);
  fclose(fp);
  if (!yes_or_no(CARE_YN_MODE, "򥭥󥻥뤷ƤǤ?",
		 "Cancel article.Are you sure?")) {
    funlink2(tmp_file);
    return(1);
  }
  print_mode_line(japanese ? "󥻥Ǥ" : "Cancelling.");
#ifdef	DEBUG
  sleep(5);
  status = 0;
#else	/* !DEBUG */
  strcpy(post_program, post_command);
  status = nntp_post(tmp_file, domain_name);
#endif	/* !DEBUG */
  funlink2(tmp_file);
  if (status) {
    print_mode_line(japanese ? "˥塼Υ󥻥˼Ԥޤ" :
		    "Cancel article failed.");
    term_bell();
    sleep(ERROR_SLEEP);
    return(1);
  }
  return(0);
}

/*
 * ˥塼(̴ؿ)
 */

static int	exec_post(base_file)
     char	*base_file;
{
  static char	from_buff[MAX_FIELD_LEN];
  static char	date_buff[MAX_FIELD_LEN];
#ifdef	FCC
  static char	fcc_buff[MAX_FIELD_LEN];
#endif	/* FCC */
  static char	dist_buff[MAX_FIELD_LEN];
  static char	group_buff[MAX_FIELD_LEN];
  char		tmp_file1[PATH_BUFF];
  char		tmp_file2[PATH_BUFF];
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		buff3[BUFF_SIZE];
  char		buff4[BUFF_SIZE];
  char		field[SMALL_BUFF];
  FILE		*fp1, *fp2, *fp3;
  static struct cpy_hdr post_fields[] = {
    {FROM_FIELD,	from_buff,	PF_FROM_MASK},
    {DATE_FIELD,	date_buff,	PF_ETC_MASK},
    {SUBJECT_FIELD,	NULL,		PF_SUBJ_MASK},
    {GROUP_FIELD,	group_buff,	PF_NG_MASK},
    {DIST_FIELD,	dist_buff,	PF_ETC_MASK},
    {FOLLOWUP_FIELD,	NULL,		PF_ETC_MASK},
    {PATH_FIELD,	NULL,		PF_PATH_MASK},
    {ORGAN_FIELD,	NULL,		PF_ORGAN_MASK},
    {LINE_FIELD,	NULL,		PF_LINE_MASK},
    {X_NSUBJ_FIELD,	NULL,		PF_THROUGH_MASK},
#ifdef	FCC
    {FCC_FIELD,		fcc_buff,	PF_DELETE_MASK},
#endif	/* FCC */
#ifdef	MIME
    {MIME_VER_FIELD,	NULL,		PF_MIME_MASK},
    {CONTENT_FIELD,	NULL,		PF_CONTENT_MASK},
#endif	/* MIME */
  };
  char		*ptr1, *ptr2, *ptr3, *last;
  int		status1, status2, status3, status4;
  int		line;
  long		length, position;
  register int	i;
  
  if ((fp1 = fopen(base_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't open news read file.");
    return(1);
  }
  create_temp_name(tmp_file1, "PS");
  if ((fp2 = fopen2(tmp_file1, "w")) == (FILE*)NULL) {
    print_fatal("Can't open news write file.");
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file1, S_IREAD | S_IWRITE);
  sprintf(tmp_file2, "%s%c%s", dot_dir, SLASH_CHAR, SIGNATURE_FILE);
  ptr3 = tmp_file2;
  while (*ptr3) {
    ptr3++;
  }
  
  /*
   * إå
   */
  
  status1 = status2 = status3 = status4 = 0;
  length = 0L;
  for (i = 0; i < sizeof(post_fields)/sizeof(struct cpy_hdr); i++) {
    if (post_fields[i].field_buff) {
      post_fields[i].field_buff[0] = '\0';
    }
  }
  last = NULL;
  fp3 = NULL;
  while (fgets2(buff1, sizeof(buff1), fp1)) {
    if ((!*buff1) || (*buff1 == '\n')) {
      break;
    }
    if ((*buff1 == ' ') || (*buff1 == '\t')) {
      if (last && status4) {
	if ((strlen(buff2) + strlen(buff1)) < sizeof(buff2)) {
	  *last++ = '\n';
	  strcpy(last, buff1);
	  while (*last) {
	    if (*last == '\n') {
	      *last = '\0';
	      break;
	    }
	    last++;
	  }
	} else {
	  print_mode_line(japanese ?
			  "ٹ : %s եɤСեޤ" :
			  "Warning : %s field overflow.", field);
	  term_bell();
	  sleep(ERROR_SLEEP);
	  status4 = 0;
	}
	continue;
      } else {
	continue;
      }
    } else {
      if (last) {
	if (status3) {
	  if (status3 & PF_DELETE_MASK) {
	    status2 |= status3;
	  } else {
	    status3 |= PF_DELETE_MASK;
	    ptr1 = buff2;
	    while (*ptr1) {
	      if ((*ptr1 != ' ') && (*ptr1 != '\t') && (*ptr1 != '\n')) {
		status3 &= ~PF_DELETE_MASK;
		break;
	      }
	      ptr1++;
	    }
	  }
	}
	if (!(status3 & PF_DELETE_MASK)) {
	  status2 |= status3;
	  ptr1 = buff2;
	  while (1) {
	    ptr2 = buff3;
	    if (*field) {
	      sprintf(ptr2, "%s ", field);
	      while (*ptr2) {
		ptr2++;
	      }
	      *field = '\0';
	    }
	    while (*ptr1) {
	      if (*ptr1 == '\n') {
		ptr1++;
		break;
	      }
	      *ptr2++ = *ptr1++;
	    }
	    *ptr2 = '\0';
	    if (status3 & PF_THROUGH_MASK) {
	      to_jis(buff4, buff3, default_code);
	    } else {
	      mime_encode_func(buff4, buff3, default_code);
	    }

	    /*
	     * Newsgroups: եɤ;ʬʶ
	     * (ޥʥɤǤ)
	     */

	    if (status3 & PF_NG_MASK) {
	      if (ptr1 = strchr(buff4, ':')) {
		ptr1++;
		if ((*ptr1 == ' ') || (*ptr1 == '\t')) {
		  ptr1++;
		}
		while (*ptr1) {
		  if ((*ptr1 == ' ') || (*ptr1 == '\t')) {
		    bcopy(ptr1 + 1, ptr1, strlen(ptr1));
		  } else {
		    ptr1++;
		  }
		}
	      }
	    }
	    fputs(buff4, fp2);
	    fputc('\n', fp2);
	    if (!*ptr1) {
	      break;
	    }
	  }
	}
	status3 = 0;
      }
    }
    if (!strncmp(buff1, TEXT_SEPARATER, sizeof(TEXT_SEPARATER) - 1)) {

      /*
       * .signature ιԿ
       */

      line = 0;
      if (connect_mode && inews_sig_mode) {
			/* ³Ǥ inews ˤ궯Ūղä */
	*ptr3 = '\0';
	if (fp3 = fopen(tmp_file2, "r")) {
	  while (fgets2(buff1, sizeof(buff1), fp3)) {
	    line++;
	  }
	  fclose(fp3);
	}
	fp3 = NULL;
      } else {
	while (1) {
	  *ptr3 = '+';
	  strcpy(ptr3 + 1, group_buff);
	  if (ptr1 = strchr(ptr3, ',')) {
	    *ptr1 = '\0';
	  }
	  if (fp3 = fopen(tmp_file2, "r")) {
	    break;
	  }
	  if (ptr1 = strrchr(group_buff, NEWS_GROUP_SEPARATER)) {
	    *ptr1 = '\0';
	  } else {
	    break;
	  }
	}
	if (!fp3) {
	  *ptr3 = '-';
	  strcpy(ptr3 + 1, dist_buff);
	  if (!(fp3 = fopen(tmp_file2, "r"))) {
	    *ptr3 = '\0';
	    fp3 = fopen(tmp_file2, "r");
	  }
	}
	if (fp3) {
	  if ((!auto_sig_mode) &&
	      (!yes_or_no(NORMAL_YN_MODE, "signature%s եĤޤ?",
			  "Add signature%s file.Are you sure?", ptr3))) {
	    fclose(fp3);
	    fp3 = NULL;
	  } else {
	    while (fgets2(buff1, sizeof(buff1), fp3)) {
	      line++;
	    }
	    fclose(fp3);
	  }
	}
      }
      if (!(status2 & PF_FROM_MASK)) {	/* From: եɤ */

	/*
	 *  Fcc: Ѥ˻Ѥ뤿˰ö from_buff Ÿ
	 */

	sprintf(from_buff, "%s@%s", user_name, domain_name);
	if (user_gecos[0]) {
	  length += (long)fprintf2(fp2, "%s %s (%s)\n", FROM_FIELD,
				   from_buff, user_gecos);
	} else {
	  length += (long)fprintf2(fp2, "%s %s\n", FROM_FIELD, from_buff);
	}
      }
      if (!(status2 & PF_PATH_MASK)) {	/* Path: եɤ */
#ifdef	ADD_HOSTPATH
	gethostname(buff1, sizeof(buff1));
	length += (long)fprintf2(fp2, "%s %s!%s\n", PATH_FIELD, buff1,
				 user_name);
#else	/* !ADD_HOSTPATH */
	length += (long)fprintf2(fp2, "%s %s\n", PATH_FIELD, user_name);
#endif	/* !ADD_HOSTPATH */
      }
      if ((!(status2 & PF_ORGAN_MASK)) && organization[0]) {
				/* Organization: եɤ */
	length += (long)fprintf2(fp2, "%s %s\n", ORGAN_FIELD, organization);
      }
      status3 = 0;
      if ((!(status2 & PF_LINE_MASK)) || (mime_format == 2)) {
	position = ftell(fp1);
	while (fgets(buff1, sizeof(buff1), fp1)) {
#ifdef	MIME
	  if (discriminate_code(buff1) != ASCII_CODE) {
	    status3 = 1;
	  }
#endif	/* MIME */
	  line++;
	}
	fseek(fp1, position, 0);
      }
      if ((!(status2 & PF_LINE_MASK)) && add_lines_mode) {
					/* Lines: եɤ */
	length += (long)fprintf2(fp2, "%s %d\n", LINE_FIELD, line);
      }
#ifdef	MIME
      if (mime_format == 2) {		/* MIME Ϣեɤ */
	if (!(status2 & PF_MIME_MASK)) {
	  length += (long)fprintf2(fp2, "%s %s\n", MIME_VER_FIELD,
				   MIME_VERSION);
	}
	if (!(status2 & PF_CONTENT_MASK)) {
	  length += (long)fprintf2(fp2, "%s %s/%s; %s=%s\n", CONTENT_FIELD,
				   MIME_TYPE_TEXT,
				   MIME_SUBTYPE_PLAIN, MIME_CHARSET,
				   status3 ? MIME_CHARSET_ISO2022_1 :
				   MIME_CHARSET_ASCII);
	}
      }
#endif	/* MIME */
#ifdef	ADD_MESSAGE_ID
      create_msg_id(buff1);
      fputs(buff1, fp2);
#endif	/* ADD_MESSAGE_ID */
#ifndef	DONT_ADD_XFIELD
      length += (long)fprintf2(fp2, "%s %s [version %s] %s\n",
			       X_READER_FIELD, READER_NAME,
			       MNEWS_VERSION, MNEWS_DATE);
#endif	/* !DONT_ADD_XFIELD */
      fputc('\n', fp2);
      status1 = 1;
      break;
    } else {
      last = NULL;
      ptr1 = buff1;
      ptr2 = field;
      status4 = 1;
      while (*ptr1) {
	if (*ptr1 == ':') {
	  *ptr2++ = *ptr1++;
	  last = buff2;
	  break;
	}
	*ptr2++ = *ptr1++;
      }
      *ptr2 = '\0';
      if (last) {
	while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
	  ptr1++;
	}
	while (*ptr1) {
	  if (*ptr1 == '\n') {
	    break;
	  }
	  *last++ = *ptr1++;
	}
	*last = '\0';
	for (i = 0; i < sizeof(post_fields)/sizeof(struct cpy_hdr); i++) {
	  if (!strncmp(post_fields[i].field_name, field,
		       strlen(post_fields[i].field_name))) {
	    if (post_fields[i].field_buff) {
	      strcpy(post_fields[i].field_buff, buff2);
	    }
	    status3 = post_fields[i].buff_size;
	    break;
	  }
	}
      }
    }
  }

  if ((!status1) || ((status2 & (PF_NG_MASK | PF_SUBJ_MASK)) !=
		     (PF_NG_MASK | PF_SUBJ_MASK))) {
    fclose(fp1);
    funlink2(tmp_file1);
    return(1);
  }
  
  /*
   * ʸδѴ
   */
  
  while (fgets2(buff1, sizeof(buff1), fp1)) {
#ifdef	EUC_SPOOL
    to_euc(buff2, buff1, default_code);
#else	/* !EUC_SPOOL */
    to_jis(buff2, buff1, default_code);
#endif	/* !EUC_SPOOL */
    fputs(buff2, fp2);
    length += (long)strlen(buff2);
  }
  fclose(fp1);
  
  /*
   * .signature ղ
   */

  if (fp3) {
    if (fp3 = fopen(tmp_file2, "r")) {
      while (fgets2(buff1, sizeof(buff1), fp3)) {
#ifdef	EUC_SPOOL
	to_euc(buff2, buff1, default_code);
#else	/* !EUC_SPOOL */
	to_jis(buff2, buff1, default_code);
#endif	/* !EUC_SPOOL */
	fputs(buff2, fp2);
	length += (long)strlen(buff2);
      }
      fclose(fp3);
    }
  }
  fclose(fp2);
  
  /*
   * 桼ե륿¹
   */

#ifndef	SMALL
  if (*post_filter) {
    create_temp_name(tmp_file2, "PU");
    sprintf(buff1, "%s < %s > %s", post_filter, tmp_file1, tmp_file2);
    if (system(buff1)) {
      print_fatal("Post filter error.");
      unlink(tmp_file2);
    } else {
      chmod(tmp_file2, S_IREAD | S_IWRITE);
#ifdef	MSDOS
      unlink(tmp_file1);
#endif	/* MSDOS */
      rename(tmp_file2, tmp_file1);
    }
  }
#endif	/* !SMALL */

  /*
   * ľεɽ
   */

#ifdef	MAX_POST_SIZE
  if (length >= (long)MAX_POST_SIZE) {
    funlink2(tmp_file1);
    print_mode_line(japanese ? "¿᤮ޤ" :
		    "Too large article.");
    term_bell();
    sleep(ERROR_SLEEP);
    return(-2);
  }
#endif	/* MAX_POST_SIZE */
#ifdef	CONFIRM_FIELD
  term_clear_all();
  if (fp1 = fopen(tmp_file1, "r")) {
    while (fgets(buff1, sizeof(buff1), fp1)) {
      if ((!buff1[0]) || (buff1[0] == '\n')) {
	break;
      }
#ifdef	EUC_SPOOL
      euc_printf("%s\r", buff1);
#else	/* !EUC_SPOOL */
      jis_printf("%s\r", buff1);
#endif	/* !EUC_SPOOL */
    }
    fclose(fp1);
  }
#else	/* !CONFIRM_FIELD */
  create_temp_name(tmp_file2, "PV");
  exec_pager(tmp_file1, tmp_file2, 0, "CONFIRM");
  last_key = 0;
#endif	/* !CONFIRM_FIELD */

  /*
   * ݥȤ¹
   */
  
  switch (yes_or_no(SEND_YN_MODE, "ƤƤǤ?",
		    "Post article.Are you sure?")) {
  case 1:
    break;
  case 3:
    funlink2(tmp_file1);
    return(-3);
  case 2:
    funlink2(tmp_file1);
    return(-2);
  case 0:
  default:
    funlink2(tmp_file1);
    return(-1);
  }
#ifdef	FCC
  if (fcc_buff[0]) {
    if (fcc_save(tmp_file1, from_buff, date_buff, fcc_buff)) {
      if (yes_or_no(NORMAL_YN_MODE,
		    "FCC ե뤬֤ǤޤǤԽޤ?",
		    "Failed for FCC file save.Edit Again?")) {
	funlink2(tmp_file1);
	return(-2);
      }
    }
  }
#endif	/* FCC */
  print_mode_line(japanese ? "Ǥ" : "Posting.");
#ifdef	DEBUG
  sleep(5);
  status1 = 0;
#else	/* !DEBUG */
  strcpy(post_program, post_command);
  if (!connect_mode) {
    if (nntp_send("")) {
      reopen_server();
    }
  }
  status1 = nntp_post(tmp_file1, domain_name);
#endif	/* !DEBUG */
  if (status1) {
    print_fatal("Post article failed.");
    sprintf(tmp_file2, "%s%c%s", dot_dir, SLASH_CHAR, DEAD_FILE);
    if (fp1 = fopen(tmp_file1, "r")) {
      if (fp2 = fopen(tmp_file2, "w")) {
	chmod(tmp_file2, S_IREAD | S_IWRITE);
	while (fgets(buff1, sizeof(buff1), fp1)) {
	  fputs(buff1, fp2);
	}
	fclose(fp2);
      }
      fclose(fp1);
    }
    funlink2(tmp_file1);
    return(1);
  } else {
    funlink2(tmp_file1);
  }
  return(0);
}
#endif	/* NEWSPOST */
