/*
 *
 *  NNTP 饤֥
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : NNTP protocol library
 *  Sub system  : NNTP library
 *  File        : nntplib.c
 *  Version     : 1.94
 *  First Edit  : 1991-07/25
 *  Last  Edit  : 1995-07/18
 *  Author      : MSR24  
 *
 */

#include	"compat.h"
#include	"nntplib.h"
#ifdef	NNTP_AUTH
#include	"mnews.h"
#endif	/* NNTP_AUTH */

static int	add_group();		/* ˥塼롼Ͽ		*/
#ifdef	NG_ALLOC
static int	compare_group();	/* ˥塼롼̾	*/
#endif	/* NG_ALLOC */
static void	inews_pipe_error();	/* ѥץ顼ϥɥ		*/
static int	inn_check();		/* INN å			*/

int			group_number;	/* 롼׿			*/
int			post_enable;	/* ݥȵĥե饰		*/
char			nntp_server[SMALL_BUFF];
					/* ˥塼Хۥ̾	*/
char			post_program[PATH_BUFF] = POST_PROGRAM;
					/* ƥץ		*/
char			server_file[PATH_BUFF] = SERVER_FILE;
					/* лե		*/
char			news_spool[PATH_BUFF] = NEWS_SPOOL;
					/* ˥塼ס		*/
char			news_lib[PATH_BUFF] = NEWS_LIB;
					/* ˥塼饤֥		*/
char			ignore_groups[BUFF_SIZE] = {0, 0};
					/* ̵뤹˥塼롼׷	*/
short			ignore_mode = 0;
					/* ̵뤹⡼		*/
short			connect_mode = 0;
					/* ³ե饰		*/
#ifdef	XOVER
short			xover_mode = 1;	/* XOVER ͭå		*/
#endif	/* XOVER */
int			force_nntp = 0;	/*  NNTP ³ե饰		*/
#ifdef	LOCAL_POST
int			force_local_post = 1;
#else	/* !LOCAL_POST */
int			force_local_post = 0;
#endif	/* !LOCAL_POST */
					/*  local post ե饰	*/
#ifdef	MSDOS
static int		read_fp = -1;
static int		write_fp = -1;
#else	/* !MSDOS */
static FILE		*read_fp = NULL;
static FILE		*write_fp = NULL;
#endif	/* !MSDOS */
static char		current_group[SMALL_BUFF];
static int		too_many;
#ifdef	NG_ALLOC
struct news_group	*news_group = NULL;
char			*name_pool = NULL;
long			name_used_size = 0;
static long		name_alloc_size = 0;
static int		news_alloc_number = 0;
#else	/* !NG_ALLOC */
struct news_group	news_group[MAX_NEWS_GROUP];
#endif	/* !NG_ALLOC */

static int	get_tcp_socket();
static int	get_default_server();
static int	atoi2();

/*
 * NNTP 
 */

int	nntp_select_server(server_name)
     char	*server_name;
{
  char			buff[SMALL_BUFF];
  char			localhost[SMALL_BUFF];
  struct stat 		stat_buff;
  struct hostent	*server_entry;
  struct hostent	*local_entry;
  char			server_tname[SMALL_BUFF];
  char			local_tname[SMALL_BUFF];

#ifdef	NNTP
  strcpy(nntp_server, server_name);
  if (gethostname(localhost, sizeof(localhost))) {
    print_fatal("Can't get hostname.");
    return(1);
  }
  if ((!server_name) || (!server_name[0])) {
    if (get_default_server(server_file, server_name)) {
      sprintf(buff, "%s%c%s", news_lib, SLASH_CHAR, NEWS_ACTIVE_FILE);
      if (stat(buff, &stat_buff)) {
	print_fatal("Can't get NNTP server name.");
	return(1);
      }
      strcpy(server_name, localhost);
    }
  }
  if (!(server_entry = gethostbyname(server_name))) {
    print_fatal("Can't get server host entry.");
    return(1);
  }
  strcpy(server_tname, server_entry->h_name);
#ifdef	DONT_USE_REALNAME
  strcpy(nntp_server, server_name);
#else	/* !DONT_USE_REALNAME */
  strcpy(nntp_server, server_tname);
#endif	/* !DONT_USE_REALNAME */
  if (!(local_entry = gethostbyname(localhost))) {
    print_fatal("Can't get local host entry.");
    return(1);
  } else {
    strcpy(local_tname, local_entry->h_name);
  }
#ifdef	NSPL
  if (!force_nntp) {
    if (!strcmp(server_tname, local_tname)) {
      connect_mode = 1;		/* ʥȥ	*/
    }
  }
#endif	/* NSPL */
#else	/* !NNTP */
  strcpy(nntp_server, "LOCAL");
  connect_mode = 1;
#endif	/* !NNTP */
  return(0);
}

/*
 * NNTP ץ
 */

int	nntp_open(server_name)
     char	*server_name;
{
  char		buff[SMALL_BUFF];
  struct stat	stat_buff;
  int		sock_read, sock_write;
  int		status;

  status = 0;
#ifdef	MSDOS
  if ((write_fp != - 1) || (read_fp != - 1)) {
#else	/* !MSDOS */
  if (write_fp || read_fp) {
#endif	/* !MSDOS */
    print_fatal("NNTP server already open.");
    return(1);
  }
#ifdef	MNEWS
#ifdef	NNTP
  if (force_nntp) {
    connect_mode = 0;
  }
#endif	/* NNTP */
#else	/* !MNEWS */
  if (connect_mode) {
    print_fatal("NNTP server already open.");
    return(1);
  }
  if (nntp_select_server(server_name)) {
    return(1);
  }
#endif	/* !MNEWS */
#ifdef	NNTP_DEBUG
  if (connect_mode) {
    print_warning("Connecting to local server %s.", server_name);
  } else {
    print_warning("Connecting to NNTP server %s.", server_name);
  }
#endif	/* NNTP_DEBUG */
  signal(SIGPIPE, SIG_IGN);
  if (connect_mode) {
#ifdef	NSPL
    post_enable = 1;
    if (stat(news_lib, &stat_buff)) {
      print_fatal("Can't stat news library directory.");
      status = 1;
    } else if (stat(news_spool, &stat_buff)) {
      print_fatal("Can't stat news spool directory.");
      status = 1;
    } else {
      sprintf(buff, "%s%c%s", news_lib, SLASH_CHAR, NEWS_ACTIVE_FILE);
      if (stat(buff, &stat_buff)) {
	print_fatal("Can't stat news active file.");
	status = 1;
      }
    }
#else	/* !NSPL */
    print_fatal("NSPL mode unsupported.");
    status = 1;
#endif	/* !NSPL */
  } else {
#ifdef	NNTP
    if ((sock_read = get_tcp_socket(server_name)) < 0) {
      print_fatal("Can't connect NNTP server %s.", server_name);
      return(1);
    }
#ifdef	MSDOS
    read_fp = sock_read;
    sock_write = sock_read;
    write_fp = sock_write;
#else	/* !MSDOS */
    if (!(read_fp = fdopen(sock_read, "r"))) {
      print_fatal("Can't connect NNTP server %s.", server_name);
      return(1);
    }
    sock_write = dup(sock_read);
    if (!(write_fp = fdopen(sock_write, "w"))) {
      print_fatal("Can't connect NNTP server %s.", server_name);
      fclose(read_fp);
      read_fp = NULL;
      return(1);
    }
#endif	/* !MSDOS */
    group_number = 0;
    
    /*
     * ˥塼Ф³å
     */
    
    if (!nntp_receive(buff, sizeof(buff))) {
      switch (atoi(buff)) {
      case OPEN_RESPONSE1:
	post_enable = 1;
	break;
      case OPEN_RESPONSE2:
	post_enable = 0;
	break;
      case BUSY_RESPONSE:
	print_warning("NNTP server busy.");
#ifdef	MSDOS
	soclose(write_fp);
	read_fp = write_fp = -1;
#else	/* !MSDOS */
	if (write_fp) {
	  fclose(write_fp);
	  write_fp = NULL;
	}
	if (read_fp) {
	  fclose(read_fp);
	  read_fp = NULL;
	}
#endif	/* !MSDOS */
	return(-1);
	/* break  */
      default:
	print_fatal("Unexpected NNTP reply in connect sequence.");
	status = 1;
	break;
      }
    } else {
      status = 1;
    }
#else	/* !NNTP */
    print_fatal("NNTP mode unsupported.");
    status = 1;
#endif	/* !NNTP */
  }

  if (status) {
    nntp_close();
  } else {
#ifdef	NNTP

    /* Server check innd or not */

    if (inn_check(buff)) {
      nntp_send(READER_COMMAND);
      if (!nntp_receive(buff, sizeof(buff))) {
	switch (atoi(buff)) {
	case OPEN_RESPONSE1:
	  post_enable = 1;
	  break;
	case OPEN_RESPONSE2:
	  post_enable = 0;
	  break;
	case BUSY_RESPONSE:
	  print_warning("NNTP server busy.");
	  status = -1;
	  break;
	default:
	  print_fatal("Unexpected NNTP reply in connect sequence.");
	  status = 1;
	  break;
	}
      } else {
	status = 1;
      }
    }
#endif	/* NNTP */
  }
  return(status);
}

/*
 * NNTP 
 */

int	nntp_close()
{
  char	buff[BUFF_SIZE];
  int	status;

  status = 0;
  if (connect_mode) {
    connect_mode = 0;
    return(0);
  }
#ifdef	NNTP
#ifdef	MSDOS
  if ((write_fp == -1) || (read_fp == -1)) {
#else	/* !MSDOS */
  if ((!write_fp) || (!read_fp)) {
#endif	/* !MSDOS */
    return(1);
  }
  if (nntp_send(QUIT_COMMAND)) {
    status = 1;
  } else if (nntp_receive(buff, sizeof(buff))) {
    status = 1;
  } else {
    if (atoi(buff) != QUIT_RESPONSE) {
      print_warning("Unexpected NNTP reply in quit command.");
      status = 1;
    }
  }
#ifdef	MSDOS
  soclose(write_fp);
  read_fp = write_fp = -1;
#else	/* !MSDOS */
  if (write_fp) {
    fclose(write_fp);
    write_fp = NULL;
  }
  if (read_fp) {
    fclose(read_fp);
    read_fp = NULL;
  }
#endif	/* !MSDOS */
#endif	/* NNTP */
  return(status);
}

/*
 * NNTP 
 */

int	nntp_send(string)
     char	*string;
{
#ifdef	MSDOS
  char		buff[BUFF_SIZE];
#endif	/* MSDOS */

  if (connect_mode) {
    print_fatal("NNTP write does not need.");
    return(1);
  }
#ifdef	NNTP
#ifdef	MSDOS
  if (write_fp == -1) {
#else	/* !MSDOS */
  if (!write_fp) {
#endif	/* !MSDOS */
    print_fatal("NNTP write stream not ready.");
    return(1);
  }
#ifdef	NNTP_DEBUG
  fprintf(stderr, "SEND:%s\n", string);
#endif	/* NNTP_DEBUG */

  /*
   * DECstation Ǥ setenv PROG_ENV POSIX  compile ʤ
   * printf ͤ 0 ʤΤǤޤưޤ
   */

#ifdef	MSDOS
  sprintf(buff, "%s\r\n", string);
  if (send(write_fp, buff, strlen(buff), 0) > 0) {
    return(0);
  }
#else	/* !MSDOS */
  if (fprintf2(write_fp, "%s\r\n", string) == (strlen(string) + 2)) {
    if (!fflush(write_fp)) {
      return(0);
    }
  }
#endif	/* !MSDOS */
  print_fatal("NNTP connection closed.");
#ifdef	MSDOS
  soclose(write_fp);
  read_fp = write_fp = -1;
#else	/* !MSDOS */
  if (write_fp) {
    fclose(write_fp);
    write_fp = NULL;
  }
  if (read_fp) {
    fclose(read_fp);
    read_fp = NULL;
  }
#endif	/* !MSDOS */
#endif	/* NNTP */
  return(1);
}

/*
 * NNTP 
 */

#ifdef	MSDOS
int	nntp_receive(ptr, size)
     char	*ptr;
     int	size;
{
  static char		*ptr2;
  static char		read_buff[BUFF_SIZE];
  static int		count = 0;
  char			c;
  
  if (connect_mode) {
    print_fatal("NNTP read does not need.");
    return(1);
  }
#ifdef	NNTP
  if (read_fp == -1) {
    print_fatal("NNTP read stream not ready.");
    return(1);
  }
  while (1) {
    if (count <= 0) {
#ifdef	INETBIOS
      count = _recv(read_fp, read_buff, sizeof(read_buff), 0);
#else	/* !INETBIOS */
      count = recv(read_fp, read_buff, sizeof(read_buff), 0);
#endif	/* !INETBIOS */
      ptr2 = read_buff;
      if (count <= 0) {
	print_fatal("NNTP connection closed.");
	soclose(write_fp);
	read_fp = write_fp = -1;
	return(1);
      }
    }
    while (count--) {
      c = *ptr2++;
      if (c == '\n') {
        goto done;
      }
      if (c != '\r') {
	*ptr++ = c;
	if (--size == 0) {
	  goto done;
	}
      }
    }
  }
done:
  *ptr = '\0';
#ifdef	NNTP_DEBUG
  fprintf(stderr, "RECEIVE:%s\n", ptr);
#endif	/* NNTP_DEBUG */
#endif	/* NNTP */
  return(0);
}
#else	/* !MSDOS */

int	nntp_receive(ptr, size)
     char	*ptr;
     int	size;
{
  register char		*ptr2;
  
  if (connect_mode) {
    print_fatal("NNTP read does not need.");
    return(1);
  }
#ifdef	NNTP
  if (!read_fp) {
    print_fatal("NNTP read stream not ready.");
    return(1);
  }
  if (!fgets(ptr, size, read_fp)) {
    print_fatal("NNTP connection closed.");
    if (write_fp) {
      fclose(write_fp);
      write_fp = NULL;
    }
    if (read_fp) {
      fclose(read_fp);
      read_fp = NULL;
    }
    return(1);
  }
  if (ptr2 = strchr(ptr, '\r')) {
    *ptr2 = '\0';
  } else if (ptr2 = strchr(ptr, '\n')) {
    *ptr2 = '\0';
  }
#ifdef	NNTP_DEBUG
  fprintf(stderr, "RECEIVE:%s\n", ptr);
#endif	/* NNTP_DEBUG */
#endif	/* NNTP */
  return(0);
}
#endif	/* !MSDOS */

#ifdef	NNTP_AUTH
/*
 * NNTP Фǧ
 */

int	nntp_auth_server()
{
#ifdef	NNTP
  register FILE		*fp;
  register char		*ptr1, *ptr2;
  struct hostent	*server_entry;
  char			buff1[SMALL_BUFF];
  char			buff2[SMALL_BUFF];
  int			status;

  if ((!nntp_server) || (!nntp_server[0])) {
    return(0);
  }
  sprintf(buff1, "%s/%s", dot_dir, AUTHORITY_FILE);
  if (!(fp = fopen(buff1, "r"))) {
    strcpy(buff2, user_name);
    input_line(INPUT_SPCCUT_MASK ,"桼̾ϤƲ:",
	       "Input user name :" , buff2);
    if (!buff2[0]) {
      return(0);
    }
    sprintf(buff1, "%s USER %s", AUTH_COMMAND, buff2);
    nntp_send(buff1);
    nntp_receive(buff1, sizeof(buff1));
    switch (atoi(buff1)) {
    case AUTHCOMP_RESPONSE:
    case AUTHDONE_RESPONSE:
      return(0);
    case PASS_RESPONSE:
      break;
    default:
      return(1);
    }
    buff2[0] = '\0';
    input_line(INPUT_SPCCUT_MASK | INPUT_SHADOW_MASK,
	       "ѥɤϤƲ:",
	       "Input password :", buff2);
    sprintf(buff1, "%s PASS %s", AUTH_COMMAND, buff2);
    nntp_send(buff1);
    nntp_receive(buff1, sizeof(buff1)); 
    if (atoi(buff1) == AUTHDONE_RESPONSE) {
      return(0);			/* Authentication accepted */
    }
    return(1);
  }
  buff2[0] = '\0';
  while (fgets(buff1, sizeof(buff1), fp)) {
    ptr1 = buff1;
    while ((*ptr1 == '\t') || (*ptr1 == ' ')) {
      ptr1++;
    }
    if ((*ptr1 == '\n') || (*ptr1 == '#')) {
      continue;
    }
    if ((ptr2 = strchr(ptr1, '\n'))) {
      *ptr2 = '\0';
    }
    for (ptr2 = ptr1; *ptr2 && (*ptr2 != '\t') && (*ptr2 != ' '); ptr2++);
    if (!*ptr2) {
      continue;
    }
    *ptr2++ = '\0';
    if (!(server_entry = gethostbyname(ptr1))) {
      continue;
    }
    if (!strcmp(server_entry->h_name, nntp_server)) {
      while ((*ptr2 == '\t') || (*ptr2 == ' ')) {
        ptr2++;
      }
      if ((!*ptr2) || (*ptr2 == '#')) {
        continue;
      }
      strcpy(buff2, ptr2);
      break;
    }
  }
  fclose(fp);
  sprintf(buff1, "%s USER %s", AUTH_COMMAND, user_name);
  if (nntp_send(buff1)) {
    return(1);
  }
  if (nntp_receive(buff1, sizeof(buff1))) {
    return(1);
  }
  switch (atoi(buff1)) {
  case AUTHCOMP_RESPONSE:
  case AUTHDONE_RESPONSE:
    return(0);
  case PASS_RESPONSE:
    break;
  default:
    return(1);
  }
  sprintf(buff1, "%s PASS %s", AUTH_COMMAND, buff2);
  if (nntp_send(buff1)) {
    return(1);
  }
  if (nntp_receive(buff1, sizeof(buff1))) {
    return(1);
  }
  if (atoi(buff1) == AUTHDONE_RESPONSE) {
    return(0);				/* Authentication accepted */
  }
  return(1);
#else	/* !NNTP */
  return(0);
#endif	/* !NNTP */
}
#endif	/* NNTP_AUTH */

#ifdef	NNTP
/*
 * TCP åȼ
 */

static int	get_tcp_socket(server_name)
     char	*server_name;	/* remote host */
{
#ifndef	MSDOS
  static struct in_addr	defaddr;
#endif	/* !MSDOS */
  struct hostent	*host_ent;
  static char		host_name[SMALL_BUFF];
  static struct hostent	def;
  struct sockaddr_in	sock_in;
  struct servent	*serv_ent;
#ifdef	MSDOS
  int			port;
#endif	/* MSDOS */
  int			s;
#ifdef	h_addr
  int			x;
  register char		**pptr;
  static char		*alias_list[1];
#endif	/* h_addr */
  static unsigned char	*i_addr;

#ifdef	MSDOS
  if (serv_ent = getservbyname("nntp", "tcp")) {
    port = serv_ent->s_port;
  } else {
    port = htons(119);
  }
  if (!isdigit(*server_name)) {
    host_ent = gethostbyname(server_name);
  } else {
    print_fatal("Server name can't use IP-address.");
    return(-1);
  }
#else	/* !MSDOS */  
  if (!(serv_ent = getservbyname("nntp", "tcp"))) {
    print_fatal("NNTP/TCP Unknown service.\n");
    return(-1);
  }
  if (!isdigit(*server_name) ||
      ((defaddr.s_addr = inet_addr(server_name)) == -1)) {
						/* ̾	*/
    host_ent = gethostbyname(server_name);
  } else {					/* IP ɥ쥹	*/
    (void) strcpy(host_name, server_name);
    def.h_name      = host_name;
#ifdef	h_addr
    def.h_addr_list = alias_list;
#endif	/* h_addr */
    def.h_addr      = (char*)&defaddr;
    def.h_length    = sizeof(struct in_addr);
    def.h_addrtype  = AF_INET;
    def.h_aliases   = 0;
    host_ent        = &def;
  }
#endif	/* !MSDOS */  
  if (!host_ent) {
    print_fatal("%s: Unknown host.", server_name);
    return (-1);
  }
  
  bzero((char*)&sock_in, sizeof(sock_in));
  sock_in.sin_family = host_ent->h_addrtype;
#ifdef	MSDOS
  sock_in.sin_port = htons(port);
#else	/* MSDOS */
  sock_in.sin_port = serv_ent->s_port;
#endif	/* !MSDOS */

#ifdef	h_addr
  x = -1;
  for (pptr = host_ent->h_addr_list; pptr && *pptr; pptr++) {
    s = socket(host_ent->h_addrtype, SOCK_STREAM, 0);
    if (s < 0) {
      print_fatal("Can't open socket.");
      return(-1);
    }
    bcopy(*pptr, (char*)&sock_in.sin_addr, host_ent->h_length);
    i_addr = (unsigned char*)&sock_in.sin_addr;
    if (x < 0) {
      print_warning("Trying %d.%d.%d.%d", i_addr[0], i_addr[1], i_addr[2],
		    i_addr[3]);
    }
    x = connect(s, (struct sockaddr*)&sock_in, sizeof(sock_in));
    if (!x) {
      break;
    }
    print_warning("Connection to %d.%d.%d.%d", i_addr[0], i_addr[1], i_addr[2],
		  i_addr[3]);
    (void) close(s);
  }
  if (x < 0) {
    print_fatal("Can't connect server.");
    return(-1);
  }
#else	/* no name server */
#ifdef EXCELAN
  if ((s = socket(SOCK_STREAM,(struct sockproto*)NULL, &sock_in,
		  SO_KEEPALIVE)) < 0) {
    print_fatal("Can't open socket.");
    return(-1);
  }
  bzero((char*)&sock_in, sizeof(sock_in));
  sock_in.sin_family = AF_INET;
  sock_in.sin_port   = htons(IPPORT_NNTP);
  
  if ((sock_in.sin_addr.s_addr = rhost(&server_name)) == -1) {
    print_fatal("%s: Unknown host.", server_name);
    return(-1);
  }
  
  if (connect(s, (struct sockaddr*)&sock_in) < 0) {
    print_fatal("connect");
    (void)close(s);
    return(-1);
  }
#else /* !EXCELAN */
#ifdef	MSDOS
  if ((s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
#else	/* !MSDOS */
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
#endif	/* !MSDOS */
    print_fatal("socket");
    return(-1);
  }

#ifdef	INETBIOS
  sock_in.sin_addr.s_addr = host_ent->h_addr;
  if (connect(s, (struct sockaddr_in*)&sock_in, sizeof(sock_in)) < 0) {
#else	/* !INETBIOS */
  bcopy(host_ent->h_addr, (char*)&sock_in.sin_addr, host_ent->h_length);
  if (connect(s, (struct sockaddr*)&sock_in, sizeof(sock_in)) < 0) {
#endif	/* !INETBIOS */
    print_fatal("connect");
    (void)close(s);
    return(-1);
  }
#endif	/* !EXCELAN */
#endif	/* !h_addr */
  return(s);
}

/*
 * ǥեȤΥ̾
 */

static int	get_default_server(filename, server_name)
  char	*filename;
  char	*server_name;
{
  FILE		*fp;
  register char	*ptr1, *ptr2;
  char		buff[BUFF_SIZE];
  
  if (ptr1 = (char*)getenv("NNTPSERVER")) {
    strcpy(server_name, ptr1);
    return(0);
  }
  if (!filename) {
    return(1);
  }
  if (!*filename) {
    return(1);
  }
  if (!(fp = fopen(filename, "r"))) {
    return(1);
  }
  while (fgets(buff, sizeof(buff), fp)) {
    ptr1 = buff;
    while ((*ptr1 == '\t') || (*ptr1 == ' ')) {
      ptr1++;
    }
    ptr2 = ptr1;
    if ((*ptr1 == '\n') || (*ptr1 == '#')) {
      continue;
    }
    ptr1 = strchr(ptr1, '\n');
    if (ptr1) {
      *ptr1 = '\0';
    }
    fclose(fp);
    strcpy(server_name, ptr2);
    return(0);
  }
  fclose(fp);
  return(1);			 /* No entry */
}
#endif	/* NNTP */

/*
 * ˥塼롼ץꥹȼ
 */

int	nntp_list()
{
  char	buff[BUFF_SIZE];
  char	*ptr;
  int	first_line;
  int	status;
  FILE	*fp;
  int	i;

#ifdef	NG_ALLOC
  nntp_free();
#endif	/* NG_ALLOC */
  status = 0;
  first_line = 1;
  too_many = 0;
  group_number = 0;
  if (connect_mode) {		/*	³		*/
#ifdef	NSPL
    sprintf(buff, "%s%c%s", news_lib, SLASH_CHAR, NEWS_ACTIVE_FILE);
    if (!(fp = fopen(buff, "r"))) {
      print_fatal("Can't open news active list.");
      status = 1;
    } else {
      while (fgets(buff, sizeof(buff), fp)) {
	ptr = buff;		/*	롼׾	*/
	if (add_group(ptr)) {
	  status = 1;
	}
      }
      fclose(fp);
    }
#else	/* !NSPL */
    status = 1;
#endif	/* !NSPL */
  } else {			/*	NNTP ³		*/
#ifdef	NNTP
    if (nntp_send(LIST_COMMAND)) {
      return(1);
    }
    while (1) {
      if (nntp_receive(buff, sizeof(buff))) {
	status = 1;
	break;
      }
      ptr = buff;
      if (first_line) {		/*	ơ		*/
	if (atoi(ptr) != LIST_RESPONSE) {
	  print_fatal("Unexpected NNTP reply in list command.");
	  status = 1;
	  break;
	}
	first_line = 0;
      } else {			/*	롼׾	*/
	if ((buff[0] == NNTP_END_MARK) && (!buff[1])) {
	  break;
	}
	if (add_group(ptr)) {
	  status = 1;
	}
      }
    }
#else	/* !NNTP */
    status = 1;
#endif	/* !NNTP */
  }
  if (status) {
    group_number = 0;
#ifdef	NG_ALLOC
    nntp_free();
#endif	/* NG_ALLOC */
  } else {
#ifdef	NG_SORT
    for (i = 0; i < group_number; i++) {	/* 	*/
      ptr = news_group[i].group_name;
      while (*ptr) {
	if (*ptr == NEWS_GROUP_SEPARATER) {
	  *ptr++ = ' ';
	} else {
	  ptr++;
	}
      }
    }
#ifdef	NG_ALLOC
    qsort(news_group, group_number, sizeof(struct news_group), compare_group);
#else	/* !NG_ALLOC */
    qsort(news_group, group_number, sizeof(struct news_group),
	  (int (*)())strcmp);
#endif	/* !NG_ALLOC */
    for (i = 0; i < group_number; i++) {	/* θ	*/
      ptr = news_group[i].group_name;
      while (*ptr) {
	if (*ptr == ' ') {
	  *ptr++ = NEWS_GROUP_SEPARATER;
	} else {
	  ptr++;
	}
      }

      /*
       * ˥塼롼פʣƤΥ顼
       */

      if (i > 0) {
	if (!strcmp(news_group[i - 1].group_name, news_group[i].group_name)) {
	  print_warning("Duplicate news group %s.", news_group[i].group_name);
	  if ((group_number - i) > 0) {
	    bcopy(&news_group[i], &news_group[i - 1],
		  sizeof(struct news_group) * (group_number - i));
	  }
	  group_number--;
	  i--;
	}
      }
    }
#else	/* !NG_SORT */

    /*
     * ˥塼롼פʣƤΥ顼
     */

    for (i = 0; i < group_number - 1; i++) {
      if (!strcmp(news_group[i].group_name, news_group[i + 1].group_name)) {
	print_warning("Duplicate news group %s.", news_group[i].group_name);
	group_number--;
	if ((group_number - i) > 0) {
	  bcopy(&news_group[i + 1], &news_group[i],
		sizeof(struct news_group) * (group_number - i));
	}
	i--;
      }
    }
#endif	/* NG_SORT */
  }
  return(status);
}

/*
 * ˥塼롼ץꥹȼ
 */

#ifdef	NG_ALLOC
int	nntp_free()
{
  if (news_group) {
    large_free(news_group);
  }
  if (name_pool) {
    large_free(name_pool);
  }
  news_group = NULL;
  name_pool = NULL;
  news_alloc_number = 0;
  name_alloc_size = name_used_size = 0;
  return(0);
}
#endif	/* NG_ALLOC */

/*
 * ˥塼롼Ͽ
 */

static int	add_group(ptr)
     char	*ptr;
{
  struct news_group	*alloc_ptr;
  register unsigned int	length;
  register int		i;
  char			name_buff[MAX_GROUP_NAME];
  char			*ptr2;

  /*	˥塼롼̾	*/

  length = 0;
  ptr2 = name_buff;
  while (*ptr > ' ') {
    if (length < (sizeof(name_buff) - 1)) {
      *ptr2++ = *ptr++;
      length++;
    } else {
      *ptr2 = '\0';
      print_fatal("Too long news group name %s.", name_buff);
      return(0);
    }
  }
  *ptr2 = '\0';
  length++;

  ptr2 = ignore_groups;
  if (ignore_mode) {
    i = 0;
    while (*ptr2) {
      i = strlen(ptr2);
      if (!strncmp(name_buff, ptr2, i)) {
	i = 0;
	break;
      }
      ptr2 += (i + 1);
    }
    if (i) {
      return(0);
    }
  } else {
    while (*ptr2) {
      i = strlen(ptr2);
      if (!strncmp(name_buff, ptr2, i)) {
	return(0);
      }
      ptr2 += (i + 1);
    }
  }

#ifdef	NG_ALLOC
  /*
   * ʬ NNTP Library ǰֱʬǤ
   * ˲ɤʤȤΤǤ礦
   */

  if (group_number >= news_alloc_number) {
    if (news_group) {
      if (alloc_ptr = (struct news_group*)
	  large_realloc(news_group, (long)sizeof(struct news_group) *
			(long)(news_alloc_number + NG_ALLOC_COUNT))) {
	news_group = alloc_ptr;
      } else {
	print_fatal("Can't allocate memory for news struct.");
	return(1);
      }
    } else {
      if (!(news_group = (struct news_group*)
	    large_malloc((long)sizeof(struct news_group) *
			 (long)(news_alloc_number + NG_ALLOC_COUNT)))) {
	print_fatal("Can't allocate memory for news struct.");
	return(1);
      }
    }
    news_alloc_number += NG_ALLOC_COUNT;
  }
  alloc_ptr = &news_group[group_number];
  if (length >= (name_alloc_size - name_used_size)) {
    if (name_pool) {
      if (ptr2 = (char*)large_realloc(name_pool,
				      (long)name_alloc_size +
				      (long)NAME_ALLOC_SIZE)) {
	if (name_pool != ptr2) {
	  for (i = 0; i < group_number; i++) {
#if	defined(MSDOS) && !defined(X68K) && !defined(__GO32__)
	    news_group[i].group_name = ptr2 +
	      ((unsigned)news_group[i].group_name - (unsigned)name_pool);
#else	/* !MSDOS || X68K || __GO32__ */
	    news_group[i].group_name += (ptr2 - name_pool);
#endif	/* !MSDOS || X68K || __GO32__ */
	  }
	}
	name_pool = ptr2;
      } else {
	print_fatal("Can't allocate memory for name pool.");
	return(1);
      }
    } else {
      if (!(name_pool = (char*)large_malloc((long)name_alloc_size +
					    (long)NAME_ALLOC_SIZE))) {
	print_fatal("Can't allocate memory for name pool.");
	return(1);
      }
    }
    name_alloc_size += NAME_ALLOC_SIZE;
  }
  alloc_ptr->group_name = &name_pool[name_used_size];
  strcpy(alloc_ptr->group_name, name_buff);
  name_used_size += length;
#else	/* !NG_ALLOC */
  if (group_number >= MAX_NEWS_GROUP) {
    if (!too_many) {
      too_many = 1;
      print_fatal("Too many news group.");
    }
    return(1);
  }
  alloc_ptr = &news_group[group_number];
  strcpy(alloc_ptr->group_name, name_buff);
#endif	/* !NG_ALLOC */
  
  /*	ݴɵֹ	*/
  
  if ((alloc_ptr->max_article = atoi2(&ptr)) <= 0) {
    alloc_ptr->max_article = 0;
    alloc_ptr->min_article = 0;
    atoi2(&ptr);		/* ǾݴɵֹΤƤ */
  } else {
    
    /*	Ǿݴɵֹ	*/
    
    if ((alloc_ptr->min_article = atoi2(&ptr)) < 0) {
      alloc_ptr->max_article = 0;
      alloc_ptr->min_article = 0;
    } else if (alloc_ptr->min_article == 0) {
      alloc_ptr->min_article = 1;
    }
  }
  
  /*	⡼ (y/n/m)		*/
  
  while ((*ptr == ' ') || (*ptr == '\t') || (*ptr == '\n')) {
    ptr++;
  }
  switch (*ptr) {
  case 'y':	/* ݥȲǽ	*/
  case 'Y':
    alloc_ptr->group_mode = (short)POST_ENABLE;
    break;
  case 'n':	/* ݥԲ	*/
  case 'N':
  case 'x':	/* ݥԲ	*/
  case 'X':
  case 'j':	/* Junk		*/
  case 'J':
  case '=':	/* ꥢ	*/
    alloc_ptr->group_mode = (short)POST_DISABLE;
    break;
  case 'm':	/* ǥ졼	*/
  case 'M':
    alloc_ptr->group_mode = (short)POST_MODERATED;
    break;
  default:
    print_warning("Unexpected news group mode %s.", alloc_ptr->group_name);
    alloc_ptr->group_mode = (short)POST_UNKNOWN;
    break;
  }
  group_number++;
  return(0);
}

#ifdef	NG_ALLOC

/*
 * ˥塼롼̾
 */

static int	compare_group(ptr1, ptr2)
     struct news_group	*ptr1;
     struct news_group	*ptr2;
{
  return(strcmp(ptr1->group_name, ptr2->group_name));
}
#endif	/* NG_ALLOC */

/*
 * ˥塼롼
 */

int	nntp_group(group_name)
     char	*group_name;
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr;
  int		status;
  int		estimate_number;
  int		first_number;
  int		last_number;
  struct stat 	stat_buff;

  if (connect_mode) {		/*	³	*/
#ifdef	NSPL
    if (*group_name == NEWS_GROUP_SEPARATER) {
      sprintf(current_group, "%s%s", news_spool, group_name);
    } else {
      sprintf(current_group, "%s%c%s", news_spool, SLASH_CHAR,
	      group_name);
    }
    ptr = current_group;
    while (*ptr) {
      if (*ptr == NEWS_GROUP_SEPARATER) {
	*ptr = SLASH_CHAR;
      }
      ptr++;
    }
#ifdef	XOVER
    xover_mode = 0;
#endif	/* XOVER */
    if (stat(current_group, &stat_buff)) {
      print_fatal("Invalid news group \"%s\".", group_name);
      current_group[0] = '\0';
      return(1);
    }
#else	/* !NSPL */
    return(1);
#endif	/* !NSPL */
  } else {			/*	NNTP ³	*/
#ifdef	NNTP
    sprintf(buff1, "%s %s", GROUP_COMMAND, group_name);
    if (nntp_send(buff1)) {
      return(1);
    }
    if (nntp_receive(buff1, sizeof(buff1))) {	/*	ơ	*/
      return(1);
    }
    if (sscanf(buff1, "%d %d %d %d %s", &status, &estimate_number,
	       &first_number, &last_number, buff2) != 5) {
      print_fatal("Invalid news group \"%s\".", group_name);
      return(1);
    }
    if (status != GROUP_RESPONSE) {
      print_fatal("Unexpected NNTP reply in group command.");
      return(1);
    }
#ifdef	XOVER
    if (xover_mode) {
      xover_mode = 0;
      if (!nntp_send(XOVER_COMMAND)) {
	if (!nntp_receive(buff1, sizeof(buff1))) {
	  if (atoi(buff1) == XOVER_RESPONSE) {
	    xover_mode = 1;
	    while (!nntp_receive(buff1, sizeof(buff1))) {
	      if ((buff1[0] == NNTP_END_MARK) && (!buff1[1])) {
		break;
	      }
	    }
	  }
	}
      }
    }
#endif	/* XOVER */
#else	/* !NNTP */
    return(1);
#endif	/* !NNTP */
  }
  return(0);
}

/*
 * ˥塼(ֹ)
 */

int	nntp_article(article_number, fp1)
     int	article_number;
     FILE	*fp1;
{
  char	buff[NUMBER_BUFF];

  sprintf(buff, "%d", article_number);
  return(nntp_article2(buff, fp1));
}

/*
 * ˥塼(Message-ID )
 */

int	nntp_article2(message_id, fp1)
     CASTPTR	message_id;
     FILE	*fp1;
{
  char	buff1[BUFF_SIZE];
  char	buff2[BUFF_SIZE];
  int	article_number;
  int	first_line;
  int	status;
  FILE	*fp2;

  status = 0;
  first_line = 1;
  if (connect_mode) {		/*	³	*/
#ifdef	NSPL
    if (!current_group[0]) {
      print_fatal("News group not selected.");
      status = 1;
    } else {
      if (atoi((char*)message_id) > 0) {
	sprintf(buff1, "%s%c%s", current_group, SLASH_CHAR, message_id);
      } else {
	if ((article_number = search_article(message_id)) <= 0) {
	  return(1);
	}
	sprintf(buff1, "%s%c%d", current_group, SLASH_CHAR, article_number);
      }
      if (!(fp2 = fopen(buff1, "r"))) {
	status = -1;
      } else {
	while (fgets(buff2, sizeof(buff2), fp2)) {
	  fputs(buff2, fp1);
	}
	fclose(fp2);
      }
    }
#else	/* !NSPL */
    return(1);
#endif	/* !NSPL */
  } else {			/*	NNTP ³	*/
#ifdef	NNTP
    sprintf(buff1, "%s %s", ARTICLE_COMMAND, message_id);
    if (nntp_send(buff1)) {
      return(1);
    }
    while (1) {
      if (nntp_receive(buff2, sizeof(buff2))) {
	return(1);
      }
      if (first_line) {		/*	ơ	*/
	if (atoi(buff2) != ARTICLE_RESPONSE) {
	  
	  /*	󥻥뤵ƤʤΤå	*/
	  
	  if (atoi(buff2) != NOARTICLE_RESPONSE) {
	    print_fatal("Unexpected NNTP reply in article command.");
	    status = 1;
	    break;
	  } else {
	    status = -1;
	    break;
	  }
	}
	first_line = 0;
      } else {
	if (buff2[0] == NNTP_END_MARK) {
	  if (buff2[1]) {
	    fprintf(fp1, "%s\n", &buff2[1]);
	  } else {
	    break;
	  }
	} else {
	  fprintf(fp1, "%s\n", buff2);
	}
      }
    }
#else	/* !NNTP */
    return(1);
#endif	/* !NNTP */
  }
  return(status);
}

/*
 * ˥塼إå(ֹ)
 */

int	nntp_head(article_number, fp1)
     int	article_number;
     FILE	*fp1;
{
  char	buff[NUMBER_BUFF];

  sprintf(buff, "%d", article_number);
  return(nntp_head2(buff, fp1));
}

/*
 * ˥塼إå(Message-ID )
 */

int	nntp_head2(message_id, fp1)
     char	*message_id;
     FILE	*fp1;
{
  char	buff1[BUFF_SIZE];
  char	buff2[BUFF_SIZE];
  int	article_number;
  int	first_line;
  int	status;
  FILE	*fp2;

  status = 0;
  first_line = 1;
  if (connect_mode) {		/*	³	*/
#ifdef	NSPL
    if (!current_group[0]) {
      print_fatal("News group not selected.");
      status = 1;
    } else {
      if (atoi(message_id) > 0) {
	sprintf(buff1, "%s%c%s", current_group, SLASH_CHAR, message_id);
      } else {
	if ((article_number = search_article(message_id)) <= 0) {
	  return(1);
	}
	sprintf(buff1, "%s%c%d", current_group, SLASH_CHAR, article_number);
      }
      if (!(fp2 = fopen(buff1, "r"))) {
	status = -1;
      } else {
	while (fgets(buff2, sizeof(buff2), fp2)) {
	  if ((!buff2[0]) || (buff2[0] == '\n')) {
	    break;
	  }
	  fputs(buff2, fp1);
	}
	fclose(fp2);
      }
    }
#else	/* !NSPL */
    status = -1;
#endif	/* !NSPL */
  } else {			/*	NNTP ³	*/
#ifdef	NNTP
    sprintf(buff1, "%s %s", HEAD_COMMAND, message_id);
    if (nntp_send(buff1)) {
      return(1);
    }
    while (1) {
      if (nntp_receive(buff2, sizeof(buff2))) {
	return(1);
      }
      if (first_line) {		/*	ơ	*/
	if (atoi(buff2) != HEAD_RESPONSE) {
	  
	  /*
	   * 󥻥뤵ƤʤΤå
	   */
	  
	  if (atoi(buff2) != NOARTICLE_RESPONSE) {
	    print_fatal("Unexpected NNTP reply in head command.");
	    status = 1;
	    break;
	  } else {
	    status = -1;
	    break;
	  }
	}
	first_line = 0;
      } else {
	if (buff2[0] == NNTP_END_MARK) {
	  if (buff2[1]) {
	    fprintf(fp1, "%s\n", &buff2[1]);
	  } else {
	    break;
	  }
	} else {
	  fprintf(fp1, "%s\n", buff2);
	}
      }
    }
#else	/* !NNTP */
    status = -1;
#endif	/* !NNTP */
  }
  return(status);
}

/*
 * ˥塼եɼ(ֹ)
 */

int	nntp_copy_fields(article_number, hdr_ptr, number, mask)
     int		article_number;
     struct cpy_hdr	*hdr_ptr;
     int		number;
     int		mask;
{
  char	buff[NUMBER_BUFF];

  sprintf(buff, "%d", article_number);
  return(nntp_copy_fields2(buff, hdr_ptr, number, mask));
}

/*
 * ˥塼եɼ(Message-ID )
 */

int	nntp_copy_fields2(message_id, hdr_ptr, number, mask)
     char		*message_id;
     struct cpy_hdr	*hdr_ptr;
     int		number;
     int		mask;
{
  FILE		*fp;
  char		buff[BUFF_SIZE];
  int		article_number;
  int		status;

  if (mask & CF_CLR_MASK) {
    copy_fields(NULL, hdr_ptr, number, CF_CLR_MASK);
    mask &= !CF_CLR_MASK;
  }
  status = 0;
  if (connect_mode) {		/*	³	*/
#ifdef	NSPL
    if (!current_group[0]) {
      print_fatal("News group not selected.");
      status = 1;
    } else {
      if (atoi(message_id) > 0) {
	sprintf(buff, "%s%c%s", current_group, SLASH_CHAR, message_id);
      } else {
	if ((article_number = search_article(message_id)) <= 0) {
	  return(1);
	}
	sprintf(buff, "%s%c%d", current_group, SLASH_CHAR, article_number);
      }
      if (fp = fopen(buff, "r")) {
	copy_fields(fp, hdr_ptr, number, CF_GET_MASK | CF_SPC_MASK);
	fclose(fp);
      } else {
	status = -1;
      }
    }
#else	/* !NSPL */
    status = -1;
#endif	/* !NSPL */
  } else {			/*	NNTP ³	*/
#ifdef	NNTP
    sprintf(buff, "%s %s", HEAD_COMMAND, message_id);
    if (nntp_send(buff)) {
      return(1);
    }
    if (nntp_receive(buff, sizeof(buff))) {
      return(1);
    } else {
      switch (atoi(buff)) {
      case HEAD_RESPONSE:
	copy_fields(NULL, hdr_ptr, number, CF_GET_MASK | CF_SPC_MASK);
	break;
      case NOARTICLE_RESPONSE:	/*	󥻥	*/
	status = -1;
	break;
      default:
	print_fatal("Unexpected NNTP reply in head command.");
	status = 1;
	break;
      }
    }
#else	/* !NNTP */
    status = -1;
#endif	/* !NNTP */
  }
  return(status);
}

#ifndef	SMALL
/*
 * ˥塼ʸ(ֹ)
 */

int	nntp_body(article_number, fp)
     int	article_number;
     FILE	*fp;
{
  char	buff[NUMBER_BUFF];

  sprintf(buff, "%d", article_number);
  return(nntp_body2(buff, fp));
}

/*
 * ˥塼ʸ(Message-ID )
 */

int	nntp_body2(message_id, fp1)
     char	*message_id;
     FILE	*fp1;
{
  char	buff1[BUFF_SIZE];
  char	buff2[BUFF_SIZE];
  int	article_number;
  int	first_line;
  int	status;
  FILE	*fp2;

  status = 0;
  first_line = 1;
  if (connect_mode) {		/*	³	*/
#ifdef	NSPL
    if (!current_group[0]) {
      print_fatal("News group not selected.");
      status = 1;
    } else {
      if (atoi(message_id) > 0) {
	sprintf(buff1, "%s%c%s", current_group, SLASH_CHAR, message_id);
      } else {
	if ((article_number = search_article(message_id)) <= 0) {
	  return(1);
	}
	sprintf(buff1, "%s%c%d", current_group, SLASH_CHAR, article_number);
      }
      if (!(fp2 = fopen(buff1, "r"))) {
	status = 1;
      } else {
	while (fgets(buff2, sizeof(buff2), fp2)) {
	  if (first_line) {
	    if ((!buff2[0]) || (buff2[0] == '\n')) {
	      first_line = 0;
	    }
	  } else {
	    fputs(buff2, fp1);
	  }
	}
	fclose(fp2);
      }
    }
#else	/* !NSPL */
    status = 1;
#endif	/* !NSPL */
  } else {			/*	NNTP ³	*/
#ifdef	NNTP
    sprintf(buff1, "%s %s", BODY_COMMAND, message_id);
    if (nntp_send(buff1)) {
      return(1);
    }
    while (1) {
      if (nntp_receive(buff2, sizeof(buff2))) {
	return(1);
      }
      if (first_line) {		/*	ơ	*/
	if (atoi(buff2) != BODY_RESPONSE) {
	  
	  /*	󥻥뤵ƤʤΤå	*/
	  
	  if (atoi(buff2) != NOARTICLE_RESPONSE) {
	    print_fatal("Unexpected NNTP reply in body command.");
	    status = 1;
	    break;
	  } else {
	    status = -1;
	    break;
	  }
	}
	first_line = 0;
      } else {
	if (buff2[0] == NNTP_END_MARK) {
	  if (buff2[1]) {
	    fprintf(fp1, "%s\n", &buff2[1]);
	  } else {
	    break;
	  }
	} else {
	  fprintf(fp1, "%s\n", buff2);
	}
      }
    }
#else	/* !NNTP */
    status = 1;
#endif	/* !NNTP */
  }
  return(status);
}
#endif	/* !SMALL */

/*
 * ˥塼
 */

int	nntp_post(file_name, domain_name)
     char	*file_name;
     char	*domain_name;
{
  FILE		*fp1;
  FILE		*fp2;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr;
  int		status;

  status = 1;
  if (connect_mode || force_local_post) {/*	³	*/
#ifdef	NSPL
    signal(SIGPIPE, inews_pipe_error);
    if (fp1 = fopen(file_name, "r")) {
#ifdef MSDOS
      strcpy(buff1, post_program);
#else	/* !MSDOS */
      sprintf(buff1, "%s > /dev/null 2>&1", post_program);
#endif	/* !MSDOS */
      if (fp2 = popen(buff1, "w")) {
	status = 0;
	while (fgets(buff1, sizeof(buff1), fp1)) {
	  if (fputs(buff1, fp2) == EOF) {
	    status = 1;
	    break;
	  }
	}
	if (pclose(fp2)) {
	  status = 1;
	}
      } else {
	print_fatal("Can't execute post command.");
      }
      fclose(fp1);
    }
    signal(SIGPIPE, SIG_IGN);
#endif	/* NSPL */
  } else {				/*	NNTP ³	*/
#ifdef	NNTP
    if (post_enable) {
      if (fp1 = fopen(file_name, "r")) {
	if (!nntp_send(POST_COMMAND)) {
	  if (!nntp_receive(buff1, sizeof(buff1))) {
	    if (atoi(buff1) == POST_RESPONSE1) {
	      while (fgets(buff1, sizeof(buff1), fp1)) {
		if ((!buff1[0]) || (buff1[0] == '\n')) {
		  break;
		}
		ptr = buff1;
		while (*ptr) {
		  if (*ptr == '\n') {
		    *ptr = '\0';
		    break;
		  }
		  ptr++;
		}
		if (buff1[0] == NNTP_END_MARK) {
		  sprintf(buff2, "%c%s", NNTP_END_MARK, buff1);
		  nntp_send(buff2);
		} else {
		  nntp_send(buff1);
		}
	      }
	      nntp_send("");
	      while (fgets(buff1, sizeof(buff1), fp1)) {
		ptr = buff1;
		while (*ptr) {
		  if (*ptr == '\n') {
		    *ptr = '\0';
		    break;
		  }
		  ptr++;
		}
		if (buff1[0] == NNTP_END_MARK) {
		  sprintf(buff2, "%c%s", NNTP_END_MARK, buff1);
		  nntp_send(buff2);
		} else {
		  nntp_send(buff1);
		}
	      }
	      buff1[0] = NNTP_END_MARK;
	      buff1[1] = '\0';
	      nntp_send(buff1);
	      if (!nntp_receive(buff1, sizeof(buff1))) {
		if (atoi(buff1) == POST_RESPONSE2) {
		  status = 0;
		}
	      }
	    }
	  }
	}
	fclose(fp1);
      }
    }
#endif	/* NNTP */
  }
  return(status);
}

#ifndef	SMALL
/*
 * NNTP ϼ
 */

int	nntp_description(group_name, description)
     char	*group_name;
     char	*description;
{
  char	buff[BUFF_SIZE];
  char	*ptr;
  int	first_line;
  int	status;
  FILE	*fp;

  first_line = 1;
  status = 1;
  *description = '\0';
  if (connect_mode) {		/*	³	*/
#ifdef	NSPL
    sprintf(buff, "%s%c%s", news_lib, SLASH_CHAR, NEWS_DESCRIPTION_FILE);
    if (!(fp = fopen(buff, "r"))) {
      print_fatal("Can't open news description list.");
      status = 1;
    } else {
      while (fgets(buff, sizeof(buff), fp)) {
	if (!strncmp(buff, group_name, strlen(group_name))) {
	  ptr = &buff[strlen(group_name)];
	  if ((*ptr == ' ') || (*ptr == '\t')) {
	    while ((*ptr == ' ') || (*ptr == '\t')) {
	      ptr++;
	    }
	    while (*ptr) {
	      if ((*ptr >= ' ') || (*ptr == '\t')) {
		*description++ = *ptr++;
	      } else {
		break;
	      }
	    }
	    *description = '\0';
	    status = 0;
	    break;
	  }
	}
      }
      fclose(fp);
    }
#endif	/* NSPL */
  } else {			/*	NNTP ³	*/
#ifdef	NNTP
    if (nntp_send(DESCRIPTION_COMMAND)) {
      return(1);
    }
    while (1) {
      if (nntp_receive(buff, sizeof(buff))) {
	status = 1;
	break;
      }
      ptr = buff;
      if (first_line) {		/*	ơ		*/
	if (atoi(ptr) != LIST_RESPONSE) {
	  print_fatal("Unexpected NNTP reply in list command.");
	  status = 1;
	  break;
	}
	first_line = 0;
      } else {			/*	롼׾	*/
	if ((buff[0] == NNTP_END_MARK) && (!buff[1])) {
	  break;
	}
	if (!strncmp(buff, group_name, strlen(group_name))) {
	  ptr = &buff[strlen(group_name)];
	  if (((*ptr == ' ') || (*ptr == '\t')) && status) {
	    while ((*ptr == ' ') || (*ptr == '\t')) {
	      ptr++;
	    }
	    while (*ptr) {
	      if ((*ptr >= ' ') || (*ptr == '\t')) {
		*description++ = *ptr++;
	      } else {
		break;
	      }
	    }
	    *description = '\0';
	    status = 0;
	  }
	}
      }
    }
#endif	/* NNTP */
  }
  return(status);
}
#endif	/* !SMALL */

/*
 * եɥԡ
 */

char	*copy_field(ptr1, ptr2, field)
     char	*ptr1;
     char	*ptr2;
     char	*field;
{
  register int	i;

  if ((!ptr1) || (!ptr2)) {
    return(NULL);
  }
  i = strlen((char*)field);
  while (i-- > 0) {
    if ((*ptr1++ & 0xdf) != (*field++ & 0xdf)) {
      return(NULL);
    }
  }
  while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
    ptr1++;
  }
  strcpy((char*)ptr2, (char*)ptr1);
  while (*ptr2) {
    if (*ptr2 == '\n') {
      *ptr2 = '\0';
      break;
    }
    ptr2++;
  }
  return(ptr2);
}

/*
 * եɥԡ(NNTP ³/ե)
 */

int	copy_fields(fp, hdr_ptr1, number, mask)
     FILE		*fp;
     struct cpy_hdr	*hdr_ptr1;
     int		number;
     int		mask;	/*
				 * CF_CLR_MASK:Хåե
				 * CF_CNT_MASK:Կ
				 * CF_GET_MASK:եɼ
				 * CF_ADD_MASK:եɲ
				 */
{
  struct cpy_hdr	*hdr_ptr2;
  char			buff[BUFF_SIZE];
  char			*ptr1, *ptr2;
  register int		lines = 0;
  register int		i;

  hdr_ptr2 = hdr_ptr1;
  if (mask & CF_CLR_MASK) {
    for (i = 0; i < number; i++) {
      if (ptr1 = hdr_ptr2->field_buff) {
	*ptr1 = '\0';
      }
      hdr_ptr2++;
    }
  }
  if (!(mask & (CF_CNT_MASK | CF_GET_MASK))) {
    return(0);
  }
  ptr1 = NULL;
  while (1) {
    if (fp) {
      if (!fgets(buff, sizeof(buff), fp)) {
	break;
      }
    } else {
      if (nntp_receive(buff, sizeof(buff))) {
	break;
      }
      if ((buff[0] == NNTP_END_MARK) && (!buff[1])) {
	break;
      }
    }
    lines++;
    if ((buff[0] == ' ') || (buff[0] == '\t')) {
      if (ptr1) {
	ptr2 = buff;
	if (mask & CF_SPC_MASK) {
	  while ((*ptr2 == ' ') || (*ptr2 == '\t')) {
	    ptr2++;
	  }
	}
	if ((int)(strlen(ptr1) + strlen(ptr2)) < (hdr_ptr2->buff_size)) {
	  strcat(ptr1, ptr2);
	  ptr2 = ptr1;
	  while (*ptr2) {
	    if ((*ptr2 == '\n') && (!*(ptr2 + 1))) {
	      *ptr2 = '\0';
	      break;
	    }
	    ptr2++;
	  }
	}
      }
    } else {
      ptr1 = NULL;
      hdr_ptr2 = hdr_ptr1;
      for (i = 0; i < number; i++) {
	if (!strncasecmp(buff, hdr_ptr2->field_name,
			 strlen(hdr_ptr2->field_name))) {
	  if (ptr1 = hdr_ptr2->field_buff) {
	    ptr2 = &buff[strlen(hdr_ptr2->field_name)];
	    while ((*ptr2 == ' ') || (*ptr2 == '\t')) {
	      ptr2++;
	    }
	    if ((mask & CF_ADD_MASK) && *ptr1) {
	      if ((int)(strlen(ptr1) + strlen(ptr2) + 1) <
		  (hdr_ptr2->buff_size)) {
		strcat(ptr1, "\n");
		strcat(ptr1, ptr2);
	      }
	    } else {
	      if ((int)strlen(ptr2) < (hdr_ptr2->buff_size)) {
		strcpy(ptr1, ptr2);
	      }
	    }
	    ptr2 = ptr1;
	    while (*ptr2) {
	      if ((*ptr2 == '\n') && (!*(ptr2 + 1))) {
		*ptr2 = '\0';
		break;
	      }
	      ptr2++;
	    }
	    if (!*ptr1) {		/* եɸ */
	      *ptr1++ = ' ';
	      *ptr1 = '\0';
	    }
	  }
	  break;
	}
	hdr_ptr2++;
      }
      if ((!buff[0]) || (buff[0] == '\n')) {
	if (mask & CF_CNT_MASK) {
	  if (fp) {
	    while (fgets(buff, sizeof(buff), fp)) {
	      lines++;
	    }
	  } else {
	    while (1) {
	      if (nntp_receive(buff, sizeof(buff))) {
		break;
	      }
	      if ((buff[0] == NNTP_END_MARK) && (!buff[1])) {
		break;
	      }
	      lines++;
	    }
	  }
	}
	break;
      }
    }
  }
  return(lines);
}

/*
 * ʸͤѴ
 */

static int	atoi2(ptr)
     char	**ptr;
{
  int	n;
  char	*ptr2;
  
  ptr2 = *ptr;
  
  while ((*ptr2 == ' ') || (*ptr2 == '\t')) {
    ptr2++;
  }
  if (!isdigit(*ptr2)) {
    return(-1);
  }
  n = atoi(ptr2);
  while (isdigit(*ptr2)) {
    ptr2++;
  }
  while ((*ptr2 == ' ') || (*ptr2 == '\t')) {
    ptr2++;
  }
  *ptr = ptr2;
  return(n);
}

/*
 * 
 */

int	search_article(message_id)
     char	*message_id;
{
#ifdef	NSPL
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr1, *ptr2;
  FILE		*fp;
#ifdef	HAVE_FILES
  FILES_STRUCT	dp;
#else	/* !HAVE_FILES */
  DIR_PTR	*dp;
  DIR		*dir_ptr;
#endif	/* !HAVE_FILES */
  long		article_number;
  register int	match;
  register int	number;

  if (!current_group[0]) {
    print_fatal("News group not selected.");
    return(-1);
  }
  match = 0;
  article_number = -1;
  sprintf(buff2, "%s %s", MESSAGE_FIELD, message_id);
#ifdef	HAVE_FILES
  sprintf(buff1, "%s%c*.*", current_group, SLASH_CHAR);
  if (!dos_files(buff1, &dp, FILE_ATTR)) {
    do {
#ifdef	__TURBOC__
      number = atoi(dp.ff_name);
      sprintf(buff1, "%d", number);
      if (strcmp(buff1, dp.ff_name)) {
	continue;
      }
      sprintf(buff1, "%s%c%s", current_group, SLASH_CHAR, dp.ff_name);
#else	/* !__TURBOC__ */
      number = atoi(dp.name);
      sprintf(buff1, "%d", number);
      if (strcmp(buff1, dp.name)) {
	continue;
      }
      sprintf(buff1, "%s%c%s", current_group, SLASH_CHAR, dp.name);
#endif	/* !__TURBOC__ */
      if (!(fp = fopen(buff1, "r"))) {
	continue;
      }
      while (fgets(buff1, sizeof(buff1), fp)) {
	if ((!buff1[0]) || (buff1[0] == '\n')) {
	  break;
	}
	ptr1 = buff1;
	ptr2 = buff2;
	match = 1;
	while (*ptr2) {
	  if ((*ptr1++ & 0xdf) != (*ptr2++ & 0xdf)) {
	    match = 0;
	    break;
	  }
	}
	if (match) {
	  break;
	}
      }
      fclose(fp);
      if (match) {
	article_number = number;
	break;
      }
    } while (!dos_nfiles(&dp));
#else	/* !HAVE_FILES */
  if (dir_ptr = opendir(current_group)) {
    while (dp = readdir(dir_ptr)) {
      number = atoi(dp->d_name);
      sprintf(buff1, "%d", number);
      if (strcmp(buff1, dp->d_name)) {
	continue;
      }
      sprintf(buff1, "%s%c%s", current_group, SLASH_CHAR, dp->d_name);
      if (!(fp = fopen(buff1, "r"))) {
	continue;
      }
      while (fgets(buff1, sizeof(buff1), fp)) {
	if ((!buff1[0]) || (buff1[0] == '\n')) {
	  break;
	}
	ptr1 = buff1;
	ptr2 = buff2;
	match = 1;
	while (*ptr2) {
	  if ((*ptr1++ & 0xdf) != (*ptr2++ & 0xdf)) {
	    match = 0;
	    break;
	  }
	}
	if (match) {
	  break;
	}
      }
      fclose(fp);
      if (match) {
	article_number = number;
	break;
      }
    }
    closedir(dir_ptr);
#endif	/* !HAVE_FILES */
  }
  return(article_number);
#else	/* !NSPL */
  return(-1);
#endif	/* !NSPL */
}

/*
 * ǧ
 */

void	confirm_article(name, min_ptr, max_ptr)
    char	*name;
    int		*min_ptr;
    int		*max_ptr;
{
#ifdef	NSPL
  char			buff1[SMALL_BUFF];
  char			buff2[SMALL_BUFF];
  char			*ptr;
#ifdef	HAVE_FILES
  FILES_STRUCT		dp;
#else	/* !HAVE_FILES */
  DIR_PTR		*dp;
  DIR			*dir_ptr;
#endif	/* !HAVE_FILES */
  register int		number;
  register int		min_number;
  register int		max_number;

  if (!connect_mode) {		/*	NNTP ³	*/
    return;
  }
  sprintf(buff1, "%s%c%s", news_spool, SLASH_CHAR, name);
  ptr = buff1;
  while (*ptr) {
    if (*ptr == NEWS_GROUP_SEPARATER) {
      *ptr = SLASH_CHAR;
    }
    ptr++;
  }
  min_number = max_number = 0;
#ifdef	HAVE_FILES
  sprintf(ptr, "%c*.*", SLASH_CHAR);
  if (!dos_files(buff1, &dp, FILE_ATTR)) {
    do {
#ifdef	__TURBOC__
      number = atoi(dp.ff_name);
      sprintf(buff2, "%d", number);
      if (!strcmp(buff2, dp.ff_name)) {
#else	/* !__TURBOC__ */
      number = atoi(dp.name);
      sprintf(buff2, "%d", number);
      if (!strcmp(buff2, dp.name)) {
#endif	/* !__TURBOC__ */
	if ((min_number > number) || (!min_number)) {
	  min_number = number;
	}
	if (max_number < number) {
	  max_number = number;
	}
      }
    } while (!dos_nfiles(&dp));
#else	/* !HAVE_FILES */
  if (dir_ptr = opendir(buff1)) {
    while (dp = readdir(dir_ptr)) {
      number = atoi(dp->d_name);
      sprintf(buff2, "%d", number);
      if (!strcmp(buff2, dp->d_name)) {
	if ((min_number > number) || (!min_number)) {
	  min_number = number;
	}
	if (max_number < number) {
	  max_number = number;
	}
      }
    }
    closedir(dir_ptr);
#endif	/* !HAVE_FILES */
    if ((*min_ptr < min_number) && min_number) {
      print_warning("Min-number fixed in %s.", name);
      *min_ptr = min_number;
    }
#ifdef	notdef
    if ((*max_ptr > max_number) && max_number) {
      print_warning("Max-number fixed in %s.", name);
      *max_ptr = max_number;
    }
#endif	/* notdef */
  }
#endif	/* NSPL */
}

/*
 * ѥץ顼ϥɥ
 * (Broken Pipe)
 */

static void	inews_pipe_error()
{
  print_fatal("inews broken pipe.");
}

/*
 * INN å
 */

static int	inn_check(str1)
     char	*str1;
{
  int	length;

  length = strlen(INN_STRING);
  while (*str1) {
    if (!strncmp(str1, INN_STRING, length)) {
      return(1);
    }
    str1++;
  }
  return(0);
}

#ifdef XOVER

/*
 * إå(XOVER)
 */

int	nntp_xover(min, max)
     int	min;
     int	max;
{
  char	buff[BUFF_SIZE];
  int	first;
  int	status;

  status = 0;
  first = 1;

  if (max) {
    sprintf(buff, "%s %d-%d", XOVER_COMMAND, min, max);
  } else {
    sprintf(buff, "%s %d", XOVER_COMMAND, min);
  }

  if (nntp_send(buff)) {
    return(1);
  }
  while (1) {
    if (nntp_receive(buff, sizeof(buff))) {
      status = 1;
      break;
    }
    if (first) {		/*	ơ		*/
      if (atoi(buff) != XOVER_RESPONSE) {
	print_fatal("Unexpected NNTP reply in xover command.");
	status = 1;
	break;
      }
      first = 0;
    } else {			/*	إå		*/
      if ((buff[0] == NNTP_END_MARK) && (!buff[1])) {
	break;
      }
      if (xover_copy_field(buff)) {
	print_fatal("Unexpected xover header format.");
	status = 1;
      }
    }
  }
  return(status);
}
#endif	/* XOVER */
