/*
 *
 *  NNTP 饤֥
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : NNTP protocol library
 *  Sub system  : NNTP define
 *  File        : nntplib.h
 *  Version     : 1.94
 *  First Edit  : 1991-07/25
 *  Last  Edit  : 1995-07/13
 *  Author      : MSR24  
 *
 */

#ifdef		MSDOS
#ifdef		NNTP
#include	"inetbios.h"
#endif		/* NNTP */
#include	<sys/stat.h>
#else		/* !MSDOS */
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<netdb.h>
#endif		/* !MSDOS */

#ifdef	MNEWS
#define	NG_ALLOC
#define	NG_SORT
#endif	/* MNEWS */

#ifdef	NG_ALLOC
#define	NG_ALLOC_COUNT	256
#define	NAME_ALLOC_SIZE	1024
#else	/* !NG_ALLOC */
#ifndef	MAX_NEWS_GROUP
#define	MAX_NEWS_GROUP	2048
#endif	/* !MAX_NEWS_GROUP */
#endif	/* !NG_ALLOC */

#ifndef	MAX_FIELD_LEN
#define	MAX_FIELD_LEN	256
#endif	/* MAX_FIELD_LEN */
#ifndef	MAX_GROUP_NAME
#define	MAX_GROUP_NAME	128
#endif	/* MAX_GROUP_NAME */
#ifndef	BUFF_SIZE
#define	BUFF_SIZE	1024
#endif	/* !BUFF_SIZE */
#ifndef	SMALL_BUFF
#define	SMALL_BUFF	256
#endif	/* !SMALL_BUFF */
#define	NUMBER_BUFF	12
#ifndef	SERVER_FILE
#define	SERVER_FILE	"/usr/local/lib/default-server"
#endif	/* !SERVER_FILE */
#ifndef	POST_PROGRAM
#ifdef	LOCAL_POST
/*	NNTPlocal post. 1992/10/27, NTT	*/
#define	POST_PROGRAM	"ConvInews"
#else	/* !LOCAL_POST */
#define	POST_PROGRAM	"/usr/lib/news/inews -h"
#endif	/* !LOCAL_POST */
#endif	/* !POST_PROGRAM */
#ifdef	MSDOS
#ifdef	X68K
#define	AUTHORITY_FILE		"_newsauth"
#else	/* !X68K */
#define	AUTHORITY_FILE		"_newsaut"
#endif	/* !X68K */
#else	/* !MSDOS */
#define	AUTHORITY_FILE		".newsauth"
#endif	/* !MSDOS */

#define	INN_STRING		" INN "

/*
 * ˥塼Ķ
 */

#ifndef	NEWS_SPOOL
#define	NEWS_SPOOL		"/usr/spool/news"
#endif	/* !NEWS_SPOOL */
#ifndef	NEWS_LIB
#define	NEWS_LIB		"/usr/lib/news"
#endif	/* !NEWS_LIB */
#ifndef	NEWS_ACTIVE_FILE
#define	NEWS_ACTIVE_FILE	"active"
#endif	/* !NEWS_ACTIVE_FILE */
#ifndef	NEWS_DESCRIPTION_FILE
#define	NEWS_DESCRIPTION_FILE	"newsgroups"
#endif	/* !NEWS_DESCRIPTION_FILE */

/*
 * NNTP ޥ
 */

#define	QUIT_COMMAND		"QUIT"
#define	LIST_COMMAND		"LIST"
#define	GROUP_COMMAND		"GROUP"
#define	ARTICLE_COMMAND		"ARTICLE"
#define	HEAD_COMMAND		"HEAD"
#define	BODY_COMMAND		"BODY"
#define	NEXT_COMMAND		"NEXT"
#define	LAST_COMMAND		"LAST"
#define	POST_COMMAND		"POST"
#define	AUTH_COMMAND		"AUTHINFO"	/* INN only */

#define	DESCRIPTION_COMMAND	"LIST newsgroups"

#define	READER_COMMAND		"MODE reader"	/* INN only */

/*
 * NNTP 쥹ݥ
 */

#define	OPEN_RESPONSE1		200	/* 200 H NNTP[auth] version */
#define	OPEN_RESPONSE2		201	/* 201 H NNTP[auth] version */
#define	BUSY_RESPONSE		400	/* 400 loadav at U, try later */
#define	QUIT_RESPONSE		205	/* 205 H closing connection */
#define	LIST_RESPONSE		215	/* 215 list of newsgroup follows */
#define	GROUP_RESPONSE		211	/* 211 N F L S group selected */
#define	ARTICLE_RESPONSE	220	/* 220 N A M article retrieved */
#define	HEAD_RESPONSE		221	/* 221 N A M article retrieved */
#define	BODY_RESPONSE		222	/* 222 N A M article retrieved */
#define	NOARTICLE_RESPONSE	423	/* 423 no such article number */
#define	NEXT_RESPONSE		223	/* 223 N A article retrieved */
#define	LAST_RESPONSE		223	/* 223 N A article retrieved */
#define	POST_RESPONSE1		340	/* 340 send article to be posted */
#define	POST_RESPONSE2		240	/* 240 article post ok */

#define	AUTHDONE_RESPONSE	281	/* 281 Authentication accepted */
#define	PASS_RESPONSE		381	/* 381 PASS required */
#define	AUTHCOMP_RESPONSE	482	/* 482 Authorization already
					   completed */
#define	AUTHERR_RESPONSE	502	/* 502 Authentication error */

#define	NNTP_END_MARK		'.'
#define	CANCEL_CONTROL		"cancel"

/*
 * ˥塼롼ץѥ졼
 */

#define	NEWS_GROUP_SEPARATER	'.'


/*
 * ˥塼ե̾
 */

#define	FROM_FIELD	"From:"
#define	GROUP_FIELD	"Newsgroups:"
#define	DATE_FIELD	"Date:"
#define	SUBJECT_FIELD	"Subject:"
#define	PATH_FIELD	"Path:"
#define	MESSAGE_FIELD	"Message-ID:"
#define	DIST_FIELD	"Distribution:"
#define	FOLLOWUP_FIELD	"Followup-To:"
#define	SENDER_FIELD	"Sender:"
#define	LINE_FIELD	"Lines:"
#define	REFERENCE_FIELD	"References:"
#define	CONTROL_FIELD	"Control:"
#define	XREF_FIELD	"Xref:"
#define	PATH_FIELD	"Path:"
#define	ORGAN_FIELD	"Organization:"
#define	X_NSUBJ_FIELD	"X-Nsubject:"

#define	CF_CLR_MASK	0x01
#define	CF_CNT_MASK	0x02
#define	CF_GET_MASK	0x04
#define	CF_ADD_MASK	0x08
#define	CF_SPC_MASK	0x10

#ifdef	XOVER
#define	XOVER_COMMAND		"XOVER"
#define	XOVER_RESPONSE		224	/* 224 data follows */
#define	BAD_RESPONSE		500	/* 500 bad command */
#define	NOT_GROUP		412	/* 412 Not in a newsgroup */
#endif	/* XOVER */

enum group_mode {
  POST_ENABLE,
  POST_DISABLE,
  POST_MODERATED,
  POST_UNKNOWN
};

/*
 * 롼̾ϥȤǻѤΤǺǽΥФǤ뤳
 */

#ifdef	NG_ALLOC
struct news_group {
  char		*group_name;
  int		min_article;
  int		max_article;
  short		group_mode;
};
#else	/* !NG_ALLOC */
struct news_group {
  char		group_name[MAX_GROUP_NAME];
  int		min_article;
  int		max_article;
  short		group_mode;
};
#endif	/* !NG_ALLOC */

struct cpy_hdr {
  char	*field_name;
  char	*field_buff;
  int	buff_size;
};

#ifdef	MSDOS
#ifndef	NO_NET
struct hostent		*gethostbyname();
struct servent		*getservbyname();
#define	IPPROTO_TCP	6
#endif	/* !NO_NET */
#endif	/* MSDOS */

extern short			ignore_mode;
extern short			connect_mode;
extern short			xover_mode;
extern int			group_number;
extern int			post_enable;
extern int			force_nntp;
extern int			force_local_post;
#ifdef	NG_ALLOC
extern long			name_used_size;
extern struct news_group	*news_group;
extern char			*name_pool;
#else	/* !NG_ALLOC */
extern struct news_group	news_group[];
#endif	/* !NG_ALLOC */
extern char			nntp_server[];
extern char			post_program[];
extern char			news_spool[];
extern char			news_lib[];
extern char			ignore_groups[];

int		nntp_select_server();	/* NNTP 		*/
int		nntp_open();		/* NNTP Хץ		*/
int		nntp_close();		/* NNTP Х		*/
int		nntp_send();		/* NNTP 			*/
int		nntp_receive();		/* NNTP 			*/
int		nntp_list();		/* NNTP 롼װ	*/
#ifdef	NG_ALLOC
int		nntp_free();		/* NNTP 롼׾	*/
#endif	/* NG_ALLOC */
int		nntp_group();		/* NNTP 롼		*/
int		nntp_article();		/* NNTP 		*/
int		nntp_article2();	/* NNTP 		*/
int		nntp_head();		/* NNTP إå		*/
int		nntp_head2();		/* NNTP إå		*/
int		nntp_body();		/* NNTP ʸ		*/
int		nntp_body2();		/* NNTP ʸ		*/
int		nntp_copy_fields();	/* NNTP եɼ		*/
int		nntp_copy_fields2();	/* NNTP եɼ		*/
int		nntp_post();		/* NNTP 		*/
int		nntp_description();	/* NNTP ϼ		*/
#ifdef	NNTP_AUTH
int		nntp_auth_server();	/* NNTP Фǧ		*/
#endif	/* NNTP_AUTH */
#ifdef	XOVER
int		nntp_xover();		/* NNTP إå(XOVER)	*/
#endif	/* XOVER */
int		search_article();	/* 			*/
void		confirm_article();	/* ǧ			*/
char		*copy_field();		/* إåԡ		*/
int		copy_fields();		/* إåԡ(ʣ)	*/
