/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : RMAIL support routine
 *  File        : rmail.c
 *  Version     : 1.19
 *  First Edit  : 1992-07/23
 *  Last  Edit  : 1995-07/20
 *  Author      : MSR24  
 *
 */

#ifdef	RMAIL
#include	"compat.h"
#include	"nntplib.h"
#include	"mnews.h"
#include	"kanjilib.h"
#include	"termlib.h"
#include	"group.h"
#include	"rmail.h"
#include	"article.h"
#include	"pager.h"
#include	"mailsend.h"

static int	rmail_select_folder(); 	/* ե			*/
static void	rmail_redraw_folder();	/* ե̺	*/
static int	rmail_select_article(); /* 			*/
static void	rmail_redraw_article();	/* ̺		*/
static int	rmail_prev_folder();	/* Υեֹ		*/
static int	rmail_next_folder();	/* Υեֹ		*/
static int	rmail_prev_unread_article();
					/* εֹ		*/
static int	rmail_next_unread_article();
					/* εֹ		*/
static int	rmail_prev_article();	/* εֹ		*/
static int	rmail_next_article();	/* εֹ		*/
static void	rmail_search_folder();	/* ե		*/
static int	rmail_read();		/* 			*/
static int	rmail_extract();	/* 			*/
static void	rmail_mark();		/* ޡɲ		*/
static void	rmail_unmark();		/* ޡ		*/
static void	rmail_count();		/* 		*/
static int	rmail_get_list();	/* ꥹȼ		*/
static void	rmail_include();	/* 嵭		*/
static void	rmail_update();		/* RMAIL ե빹		*/
static int	rmail_create_folder();	/* ե			*/
static int	rmail_delete_folder();	/* ե			*/
static int	rmail_adjust_folder();	/* ե		*/
static int	rmail_search_name();	/* ե̾		*/

/*
 * RMAIL եꥹ
 */

static int	rmail_folder_number;	/* RMAIL ե		*/
static int	rmail_alloc_number;	/* RMAIL ե		*/
static char	rmail_file[PATH_BUFF];	/* RMAIL եե̾	*/
static struct rmail_folder	*rmail_folder = NULL;
static int	top_position;		/* ɽϰ		*/
static int	rmail_article_number;	/* RMAIL 		*/
static int	rmail_modify;		/* RMAIL ե饰	*/

static char	*rmail_ignore_field[] = {
  "Via:",
  "Mail-From:",
  "Origin:",
  "Status:",
  "Received:",
  "Message-ID:",
  "Summary-Line:"
  };

/*
 * RMAIL إץå
 */

static char	*rmail_folder_jmessage[] = {
  "RMAIL ե⡼\n\n",
  "\tk, ^P ޤ p  Υե˰ưޤ\n",
  "\tj, ^N ޤ n  Υե˰ưޤ\n",
  "\ti ޤ SPACE  ե򤷤ޤ\n",
  "\t^U ޤ ^B    ̤Υե˰ưޤ\n",
  "\t^D, ^F ޤ ^V\n",
  "\t                ̤Υե˰ưޤ\n",
  "\t<               ƬΥե˰ưޤ\n",
  "\t>               ǸΥե˰ưޤ\n",
  "\to, q ޤ RETURN\n",
  "\t                ե⡼ɤȴޤ\n",
#ifndef	SMALL
  "\t/               ե̾ޤ\n",
  "\t                (ʸϤƲ)\n",
  "\t\\               ե̾ޤ\n",
  "\t                (ʸϤƲ)\n",
#endif	/* !SMALL */
  "\tTAB             Υե˥פޤ\n",
  "\t                (եƥޤϥե̾ϤƲ)\n",
#ifdef	MAILSEND
  "\tm               ˥᡼Фޤ\n",
#endif	/* MAILSEND */
  "\tC               ˥եޤ\n",
  "\t                (ե̾ϤƲ)\n",
  "\tDEL ޤ BS   եޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  NULL,
  };

static char	*rmail_article_jmessage[] = {
  "RMAIL ⡼\n\n",
  "\tk ޤ ^P     ε˰ưޤ\n",
  "\tj ޤ ^N     ε˰ưޤ\n",
  "\tSPACE, i ޤ .\n",
  "\t                򻲾Ȥޤ\n",
  "\tv ޤ V      ƤΥإåȤȤ˵򻲾Ȥޤ\n",
#ifdef	MIME
  "\t                ('V'  MIME ǥб)\n",
#endif	/* MIME */
  "\tp               ̤ɵ򻲾Ȥޤ\n",
  "\tn               ̤ɵ򻲾Ȥޤ\n",
  "\tP               ε򻲾Ȥޤ\n",
  "\tN               ε򻲾Ȥޤ\n",
  "\t^U ޤ ^B    ̤ε˰ưޤ\n",
  "\t^D, ^F ޤ ^V\n",
  "\t                ̤ε˰ưޤ\n",
  "\t<               Ƭε˰ưޤ\n",
  "\t>               Ǹε˰ưޤ\n",
  "\tD               ޡεذưޤ\n",
  "\td               ޡεذưޤ\n",
  "\tU               ޡεذưޤ\n",
  "\tu               ޡεذưޤ\n",
  "\ts               򥻡֤ޤ\n",
  "\t                (ե̾ϤƲե뤬¸ߤ\n",
  "\t                 Y:ڥ N: O:񤭤ǲ)\n",
  "\tc               ޡޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\tTAB             ε˥פޤ\n",
  "\t                (ֹϤƲ)\n",
#ifdef	MAILSEND
  "\tm               ˥᡼Фޤ\n",
  "\tr               ֿޤ\n",
  "\tR               Ѥֿޤ\n",
  "\tf               žޤ\n",
#endif	/* MAILSEND */
  "\tM               ޥޡ/εذưޤ\n",
  "\tC               ޡεذưޤ\n",
  "\t^               ޡ줿̤Υե˰ưޤ\n",
  "\t                (ưե̾Ƥޤ)\n",
  "\tDEL ޤ BS   ޡ줿ޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\tI               ᡼ߤޤ\n",
#ifndef	SMALL
  "\tL               UCB-mail εեߤޤ\n",
  "\t                (ե̾ϤƲ)\n",
#endif	/* !SMALL */
  "\tl               /줿ɽ⡼ɤؤޤ\n",
  "\tt               åɥ⡼ɤؤޤ\n",
#ifdef	REF_SORT
  "\tT               ˡؤޤ\n",
#endif	/* REF_SORT */
  "\to, q ޤ RETURN\n",
  "\t                ⡼ɤȴޤ\n",
  NULL,
};

static char	*rmail_folder_message[] = {
#ifndef	SMALL
  "RMAIL FOLDER SELECT MODE\n\n",
  "\tk, ^P or p   previous folder.\n",
  "\tj, ^N or n   next folder.\n",
  "\ti or SPACE   select folder.\n",
  "\t^U or ^B     previous page folder.\n",
  "\t^D, ^F or ^V next page folder.\n",
  "\t<            top folder.\n",
  "\t>            last folder.\n",
  "\to, q or RETURN\n",
  "\t             exit from folder select mode.\n",
  "\t/            forward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\t\\            backward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\tTAB          jump to specified folder.\n",
  "\t             (Please input folder name.)\n",
#ifdef	MAILSEND
  "\tm            mail.\n",
#endif	/* MAILSEND */
  "\tC            create new folder.\n",
  "\t             (Please input folder name.)\n",
  "\tDEL or BS    delete folder.\n",
  "\t             (Please make sure Y/N.)\n",
#endif	/* !SMALL */
  NULL,
  };

static char	*rmail_article_message[] = {
#ifndef	SMALL
  "RMAIL ARTICLE SELECT MODE\n\n",
  "\tk or ^P      previous article.\n",
  "\tj or ^N      next article.\n",
  "\tSPACE, i or .\n",
  "\t             read article.\n",
  "\tv or V       read article with all header.\n",
#ifdef	MIME
  "\t             ('V' decode MIME header.)\n",
#endif	/* MIME */
  "\tp            read previous unread article.\n",
  "\tn            read next unread article.\n",
  "\tP            read previous article.\n",
  "\tN            read next article.\n",
  "\t^U or ^B     previous page article.\n",
  "\t^D, ^F or ^V next page article.\n",
  "\t<            top article.\n",
  "\t>            last article.\n",
  "\tD            mark for delete and move to previous.\n",
  "\td            mark for delete and move to next.\n",
  "\tU            clear delete mark and move to previous.\n",
  "\tu            clear delete mark and move to next.\n",
  "\ts            save article.\n",
  "\t             (Please input file name.If file exists, please select\n",
  "\t              Y:Append N:Abort or O:Overwrite.)\n",
  "\tc            mark all article for delete.\n",
  "\t             (Please make sure Y/N.)\n",
  "\tTAB          jump to specified article.\n",
  "\t             (Please input article number.)\n",
#ifdef	MAILSEND
  "\tm            mail.\n",
  "\tr            reply.\n",
  "\tR            reply with original article.\n",
  "\tf            forward.\n",
#endif	/* MAILSEND */
  "\tM            toggle multi mark and move to next.\n",
  "\tC            clear all mark and move to next.\n",
  "\t^            refile delete marked article.\n",
  "\t             (Please input folder name.)\n",
  "\tDEL or BS    remove delete marked article.\n",
  "\t             (Please make sure Y/N.)\n",
  "\tI            include new mail.\n",
  "\tL            include UCB-mail format article file.\n",
  "\t             (Please input file name.)\n",
  "\tl            toggle print read/delete article.\n",
  "\tt            toggle thread mode.\n",
#ifdef	REF_SORT
  "\tT            change sort rule.\n",
#endif	/* REF_SORT */
  "\to, q or return\n",
  "\t             exit from article select mode.\n",
#endif	/* !SMALL */
  NULL,
};

/*
 * RMAIL ⡼ɽ
 */

int	rmail_init()
{
  return(rmail_mode);
}

/*
 * RMAIL ˥塼
 */

int	rmail_menu()
{
  struct stat	stat_buff;
  int		status;

  select_name[0] = '\0';
  print_mode_line(japanese ? "Ǥ" : "Searching.");
  if ((!stat(rmail_mbox, &stat_buff)) && (stat_buff.st_mode & S_IFDIR)) {
    rmail_search_folder();
    while (1) {
      if (auto_inc_mode && auto_inc_folder[0] && check_new_mail()) {
	strcpy(jump_name, auto_inc_folder);
      }
      status = rmail_select_folder();
      if (!jump_name[0]) {
	break;
      }
    }
    return(status);
  } else {
    rmail_folder_number = 0;
    strcpy(rmail_file, rmail_mbox);
    return(rmail_select_article(auto_inc_mode));
  }
}

/*
 * ե̺
 */

static void	rmail_redraw_folder(current_folder)
     int	current_folder;
{
  register int	i, j;
  char		buff[SMALL_BUFF];
  char		jname[SMALL_BUFF];

  i = top_position;
  top_position = get_top_position(top_position, current_folder,
				  rmail_folder_number, mail_thread_mode, buff);
  if (i == top_position) {
    return;
  }
  print_title();
  if (wide_mode) {
    term_attrib(color_code[HEADER_COLOR]);
  } else {
    term_attrib(color_code[CATEGORY_COLOR]);
  }
  strcpy(jname, select_name);
#ifdef	JNAMES
  get_jname(RMAIL_JN_DOMAIN, jname, 40);
#endif	/* JNAMES */
  print_full_line(japanese ?
		  "ե:%-48.48s       :%s" :
		  "Folder:%-48.48s     Position:%s",
		  jname, buff);
  if (!wide_mode) {
    term_locate(0, 2);
    term_attrib(RESET_ATTRIB);
    term_attrib(color_code[HEADER_COLOR]);
    print_full_line(japanese ?
		    "      ̤    ե̾                       [%-8.8s]" :
		    "  Max     Unread  Folder name                      [%-8.8s]",
		    newmail_string[check_new_mail()]);
  }
  term_attrib(RESET_ATTRIB);
  for (i = 0, j = top_position; i < term_lines - mode_lines; i++, j++) {
    if (j >= rmail_folder_number) {
      break;
    }
    term_locate(0, head_lines + i);
#ifdef	COLOR
    term_attrib(color_code[NUMBER_COLOR]);
#endif	/* COLOR */
    cprintf(" %6d  %6d", rmail_folder[j].max_article,
	    rmail_folder[j].unread_article);
    strcpy(buff, rmail_folder[j].folder_name);
#ifdef	JNAMES
    get_jname(RMAIL_JN_DOMAIN, buff, term_columns - 24);
#else	/* !JNAMES */
    buff[term_columns - 24] = '\0';
#endif	/* !JNAMES */
#ifdef	COLOR
    term_attrib(color_code[CATEGORY_COLOR]);
#endif	/* COLOR */
    kanji_printf(EUC_CODE, "   %s", buff);
  }
  term_attrib(RESET_ATTRIB);
  print_mode_line(japanese ?
		  "?:إ j,n,^N: k,p,^P: SPACE,i: o,q,RETURN: Q:λ" :
		  "?:Help j,n,^N:next k,p,^P:previous SPACE,i:select o,q,RETURN:return Q:exit");
}

/*
 * ե
 */

static int	rmail_select_folder()
{
  int		current_folder;		/* Υեֹ		*/
  char		buff1[BUFF_SIZE];
  int		loop;
  int		status;
  int		key;
  register int	i;

  top_position = -1;
  current_folder = 0;

  loop = 1;
  while (loop) {
    if (jump_name[0]) {
      key = 0;
      current_folder = -1;
      for (i = 0; i < rmail_folder_number; i++) {
	if (!strcmp(rmail_folder[i].folder_name, jump_name)) {
	  current_folder = i;
	  key = ' ';
	  break;
	}
	if (!strncmp(rmail_folder[i].folder_name, jump_name,
		     strlen(jump_name))) {
	  if (current_folder < 0) {
	    current_folder = i;
	    key = ' ';
	  } else {
	    key = 0;
	  }
	}
      }
      if (current_folder < 0) {
	current_folder = 0;
      }
      jump_name[0] = '\0';
      if (!key) {
	continue;
      }
    } else {
      rmail_redraw_folder(current_folder);
      term_locate(16, head_lines + current_folder - top_position);
      key = get_key(GLOBAL_MODE_MASK | GROUP_MODE_MASK);
    }
    switch (key) {
    case 0x0c:		/* ^L 		*/
      term_init(2);
      top_position = -1;
      break;
    case 0x0e:		/* ^N եư	*/
    case 'j':
    case 'n':
      current_folder = rmail_next_folder(current_folder);
      break;
    case 0x10:		/* ^P եư	*/
    case 'k':
    case 'p':
      current_folder = rmail_prev_folder(current_folder);
      break;
    case 'o':
    case 'q':
    case '\015':	/* RETURN		*/
    case '\n':
      loop = 0;
      break;
    case 0x02:		/* ^B			*/
    case 0x15:		/* ^U ڡ		*/
      if ((current_folder -= (term_lines - mode_lines)) < 0) {
	current_folder = 0;
      }
      break;
    case 0x04:		/* ^D			*/
    case 0x06:		/* ^F			*/
    case 0x16:		/* ^V ڡ		*/
      if ((current_folder += (term_lines - mode_lines)) >=
	  rmail_folder_number) {
	if (rmail_folder_number > 0) {
	  current_folder = rmail_folder_number - 1;
	} else {
	  current_folder = 0;
	}
      }
      break;
    case '<':		/* ǽΥե	*/
      current_folder = 0;
      break;
    case '>':		/* ǸΥե	*/
      if (rmail_folder_number > 0) {
	current_folder = rmail_folder_number - 1;
      } else {
	current_folder = 0;
      }
      break;
    case '\t':		/* TAB եإ	*/
      strcpy(buff1, rmail_mbox);
      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
		 "ե̾ϤƲ:", "Input folder name:", buff1);
      if (buff1[0]) {
	strcpy(jump_name, buff1);
      }
      top_position = -1;
      break;
    case '?':		/* إ		*/
      help(rmail_folder_jmessage, rmail_folder_message,
	   GLOBAL_MODE_MASK | GROUP_MODE_MASK);
      top_position = -1;
      break;
    case 'Q':		/* λ			*/
      return(1);
      /* break; */
    case 'C':		/* ե		*/
      strcpy(buff1, rmail_mbox);
      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
		 "ե̾ϤƲ:",
		 "Input new folder name:", buff1);
      if (buff1[0]) {
	if (!rmail_create_folder(buff1)) {
	  if (rmail_folder_number > 0) {
	    strcpy(buff1, rmail_folder[current_folder].folder_name);
	    rmail_search_folder();
	    current_folder = rmail_adjust_folder(buff1);
	  } else {
	    rmail_search_folder();
	    current_folder = 0;
	  }
	}
      }
      top_position = -1;
      break;
    default:
      if (rmail_folder_number > 0) {
	switch (key) {
	case ' ':
	case 'i':		/* ե		*/
	  strcpy(buff1, select_name);
	  strcpy(select_name, rmail_folder[current_folder].folder_name);
	  sprintf(rmail_file, "%s%c%s", rmail_mbox, SLASH_CHAR,
		  rmail_folder[current_folder].folder_name);
	  status = rmail_select_article(auto_inc_mode &&
					((!auto_inc_folder[0]) ||
					 (!strcmp(auto_inc_folder,
			  rmail_folder[current_folder].folder_name))));
	  strcpy(select_name, buff1);
	  strcpy(buff1, rmail_folder[current_folder].folder_name);
	  current_folder = 0;
	  for (i = 0; i < rmail_folder_number; i++) {
	    if (!strncmp(rmail_folder[i].folder_name, buff1,
			strlen(buff1))) {
	      current_folder = i;
	      break;
	    }
	  }
	  rmail_count(current_folder);
	  if (status) {
	    return(1);
	  }
	  top_position = -1;
	  break;
#ifndef	SMALL
	case '/':		/* 		*/
	  rmail_search_name(0, rmail_folder_number, &current_folder);
	  break;
	case '\\':		/* 		*/
	  rmail_search_name(1, rmail_folder_number, &current_folder);
	  break;
#endif	/* !SMALL */
	case 0x7f:		/* ե		*/
	case 0x08:
	  if (rmail_folder[current_folder].max_article) {
	    print_mode_line(japanese ?
			    "ե(%s)϶ǤϤޤ" :
			    "Folder(%s) does not empty.",
			    rmail_folder[current_folder].folder_name);
	    term_bell();
	    sleep(ERROR_SLEEP);
	  } else {
	    if (yes_or_no(CARE_YN_MODE, "ե(%s)ޤ?",
			  "Delete folder(%s)?",
			  rmail_folder[current_folder].folder_name)) {
	      if (!rmail_delete_folder(rmail_folder[current_folder].folder_name)) {
		strcpy(buff1, rmail_folder[current_folder].folder_name);
		rmail_search_folder();
		current_folder = rmail_adjust_folder(buff1);
	      }
	    }
	  }
	  top_position = -1;
	  break;
	default:
	  break;
	}
      }
      break;
    }
  }
  return(0);
}

/*
 * ̺
 */

static void	rmail_redraw_article(current_article)
     int	current_article;
{
  register int	i;
  char		buff[SMALL_BUFF];
  char		jname[SMALL_BUFF];

  i = top_position;
  top_position = get_top_position(top_position, current_article,
				  rmail_article_number, mail_thread_mode,
				  buff);
  if (i == top_position) {
    return;
  }
  print_title();
  if (wide_mode) {
    term_attrib(color_code[HEADER_COLOR]);
  } else {
    term_attrib(color_code[CATEGORY_COLOR]);
  }
  if ((int)strlen(rmail_file) > (int)strlen(rmail_mbox)) {
    strcpy(jname, &rmail_file[strlen(rmail_mbox) + 1]);
  } else {
    strcpy(jname, rmail_file);
  }
#ifdef	JNAMES
  get_jname(RMAIL_JN_DOMAIN, jname, 42);
#endif	/* JNAMES */
  print_full_line(japanese ?
		  "᡼ե:%-42.42s       :%s" :
		  "Mail file:%-42.42s        Position:%s",
		  jname, buff);
  print_articles(top_position, rmail_article_number, NULL, "PANIC");
  print_mode_line(japanese ?
		  "?:إ j,^N: k,^P: SPACE,i,.: o,q: Q:λ" :
		  "?:Help j,^N:next k,^P:previous SPACE,i,.:read o,q:return Q:exit");
}

/*
 * 
 */

static int	rmail_select_article(auto_flag)
     int	auto_flag;
{
  register int	current_folder;		/* Υեֹ		*/
  int		current_article;	/* εֹ		*/
  char		buff[BUFF_SIZE];
  char		refile_folder[BUFF_SIZE];
  int		loop;
  int		status;
  int		key;
  register int	i, j;

  current_folder = -1;
  jump_name[0] = '\0';
  for (i = 0; i < rmail_folder_number; i++) {
    if (!strcmp(select_name, rmail_folder[i].folder_name)) {
      current_folder = i;
      break;
    }
  }
  if ((current_folder < 0) && rmail_folder_number) {
    print_fatal("Unexpected folder selected.");
    return(0);
  }
  print_mode_line(japanese ? "Ǥ" : "Searching.");
  if (auto_flag) {	/* ưǽ		*/
    if (check_new_mail()) {
      sprintf(buff, "%s%c%s", mail_spool, SLASH_CHAR, user_name);
      rmail_include(buff, 1);
    }
  }
  if (rmail_get_list() < 0) {
    return(0);
  }

  /*
   * ǽ̤ɵޤǥȤʤ
   */

  current_article = 0;
  if (rmail_article_number > 0) {
    while (1) {
      if (current_article >= rmail_article_number - 1) {
	break;
      } else if (article_list[current_article].mark & READ_MARK) {
	current_article = rmail_next_unread_article(current_article);
	continue;
      } else {
	break;
      }
    }
  }
  top_position = -1;
  loop = 1;
  status = 0;
  while (loop) {
    rmail_redraw_article(current_article);
    term_locate(11, head_lines + current_article - top_position);
    key = get_key(GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
    switch (key) {
    case 0x0c:		/* ^L 		*/
      term_init(2);
      top_position = -1;
      break;
    case 0x0e:		/* ^N ư	*/
    case 'j':
      current_article = rmail_next_article(current_article);
      break;
    case 0x10:		/* ^P ư	*/
    case 'k':
      current_article = rmail_prev_article(current_article);
      break;
    case '\015':	/* RETURN		*/
    case '\n':
    case 'o':
    case 'q':
      loop = 0;
      break;
    case 0x02:		/* ^B 			*/
    case 0x15:		/* ^U ڡ		*/
      if ((current_article -= (term_lines - mode_lines)) < 0) {
	current_article = 0;
      }
      break;
    case 0x04:		/* ^D			*/
    case 0x06:		/* ^F			*/
    case 0x16:		/* ^V ڡ		*/
      if ((current_article += (term_lines - mode_lines)) >= rmail_article_number) {
	if (rmail_article_number > 0) {
	  current_article = rmail_article_number - 1;
	} else {
	  current_article = 0;
	}
      }
      break;
    case '<':		/* ǽε		*/
      current_article = 0;
      break;
    case '>':		/* Ǹε		*/
      if (rmail_article_number > 0) {
	current_article = rmail_article_number - 1;
      } else {
	current_article = 0;
      }
      break;
#ifndef	SMALL
    case 'L':		/* ե	*/
      buff[0] = '\0';
      input_line(INPUT_EXPAND_MASK | INPUT_COMP_MASK,
		 "ե̾ϤƲ:",
		 "Input file name:", buff);
      if (!buff[0]) {
	top_position = -1;
	break;
      }
      /* break 	*/
#endif	/* !SMALL */
    case 'I':		/* 嵭	*/
      rmail_update(0, NULL);
      if (key == 'I') {
	if (auto_inc_mode && auto_inc_folder[0]) {
	  if (check_new_mail()) {
	    strcpy(jump_name, auto_inc_folder);
	    return(1);
	  }
	  break;
	}
	sprintf(buff, "%s%c%s", mail_spool, SLASH_CHAR, user_name);
	rmail_include(buff, 1);
      } else {
	rmail_include(buff, 0);
      }
      i = rmail_article_number;
      rmail_get_list();
      current_article = i;
      if (current_article >= rmail_article_number) {
	if (rmail_article_number > 0) {
	  current_article = rmail_article_number - 1;
	} else {
	  current_article = 0;
	}
      }
      top_position = -1;
      break;
    case '?':		/* إ		*/
      help(rmail_article_jmessage, rmail_article_message,
	   GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
      top_position = -1;
      break;
    case 'Q':		/* λ			*/
      loop = 0;
      status = 1;
      break;
    case 'l':		/* ɵѥå/	*/
    case 't':		/* åɥ	*/
    case 'T':		/* åɥ롼	*/
      rmail_update(0, NULL);
      if (!change_sort_rule(-1, &rmail_article_number,
			    &current_article,
			    &mail_article_mask, &mail_thread_mode,
			    rmail_get_list, key)) {
	top_position = -1;
      }
      break;
    default:
      last_key = key;
      while (last_key) {
	key = last_key;
	last_key = 0;
	switch (key) {
	case 'p':		/* ̤ɵ	*/
	case 'P':		/* ε		*/
	  j = current_article;
	  if (rmail_article_number > 0) {
	    if (key == 'p') {
	      current_article = rmail_prev_unread_article(current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      current_article = rmail_prev_article(current_article);
	      status = (current_article == j);
	    }
	  } else {
	    status = 1;
	  }
	  if (status && rmail_folder_number) {
	    i = current_folder;
	    while (1) {
	      if (--i < 0) {
		i = current_folder;
		break;
	      }
	      if (rmail_folder[i].unread_article > 0) {
		break;
	      }
	    }
	    if (i != current_folder) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"Υե(%s)򻲾Ȥޤ?",
				"Read previous folder(%s)?",
				rmail_folder[i].folder_name)) {
	      case 1:
		rmail_update(0, NULL);
		strcpy(jump_name, rmail_folder[i].folder_name);
		return(1);
		/* break; */
	      case 2:
		rmail_update(0, NULL);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
	case 'n':		/* ̤ɵ	*/
	case 'N':		/* ε		*/
	  j = current_article;
	  if (rmail_article_number > 0) {
	    if (key == 'n') {
	      current_article = rmail_next_unread_article(current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      current_article = rmail_next_article(current_article);
	      status = (current_article == j);
	    }
	  } else {
	    status = 1;
	  }
	  if (status) {
	    i = current_folder;
	    while (1) {
	      if (++i >= rmail_folder_number) {
		i = current_folder;
		break;
	      }
	      if (rmail_folder[i].unread_article > 0) {
		break;
	      }
	    }
	    if (i != current_folder) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"̤ɥե(%s)򻲾Ȥޤ?",
				"Read next unread folder(%s)?",
				rmail_folder[i].folder_name)) {
	      case 1:
		rmail_update(0, NULL);
		strcpy(jump_name, rmail_folder[i].folder_name);
		return(1);
		/* break; */
	      case 2:
		rmail_update(0, NULL);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
	default:
	  break;
	}
	if (rmail_article_number > 0) {
	  i = 1;
	  switch (key) {
	  case 'V':		/* 		*/
	    i = 3;
	    /* break  */
	  case 'v':
	    i--;
	    key = ' ';
	    /* break  */
	  case ' ':
	  case 'p':
	  case 'n':
	  case 'P':
	  case 'N':
	  case 'i':
	  case '.':
	    if (!rmail_read(article_list[current_article].real_number, i)) {
	      rmail_mark(current_article, READ_MARK);
	      if ((last_key == 'D') || (last_key == 'd')) {
		rmail_mark(current_article, DELETE_MARK);
		if (last_key == 'D') {
		  last_key = 'p';
		} else {
		  last_key = 'n';
		}
	      } else if ((last_key == 'U') || (last_key == 'u')) {
		rmail_unmark(current_article, DELETE_MARK);
		if (last_key == 'U') {
		  last_key = 'p';
		} else {
		  last_key = 'n';
		}
	      }
	    }
	    if (pager_mode) {
	      switch (key) {
	      case 'p':
		current_article = rmail_prev_unread_article(current_article);
		break;
	      case 'n':
	      case ' ':
		current_article = rmail_next_unread_article(current_article);
		break;
	      case 'P':
		current_article = rmail_prev_article(current_article);
		break;
	      case 'N':
		current_article = rmail_next_article(current_article);
		break;
	      default:
		break;
	      }
	    }
	    if (last_key == ' ') {
	      last_key = 'n';
	    }
	    top_position = -1;
	    break;
	  case 'D':		/* ޡư	*/
	  case 'd':		/* ޡư	*/
	    rmail_mark(current_article, DELETE_MARK);
	    toggle_mark(top_position, current_article, 0);
	    if (key == 'D') {
	      current_article = rmail_prev_article(current_article);
	    } else {
	      current_article = rmail_next_article(current_article);
	    }
	    break;
	  case 'U':		/* ޡư	*/
	  case 'u':		/* ޡư	*/
	    rmail_unmark(current_article, DELETE_MARK);
	    toggle_mark(top_position, current_article, 0);
	    if (key == 'U') {
	      current_article = rmail_prev_article(current_article);
	    } else {
	      current_article = rmail_next_article(current_article);
	    }
	    break;
	  case 'c':		/* ޡ		*/
	    if (yes_or_no(NORMAL_YN_MODE,
			  "ƥޡƤǤ?",
			  "Mark all articles.Are you sure?")) {
	      for (i = 0; i < rmail_article_number; i++) {
		rmail_mark(i, DELETE_MARK);
	      }
	    }
	    top_position = -1;
	    status = 0;
	    break;
	  case '^':		/* ޡե	*/
	    j = 0;
	    for (i = 0; i < rmail_article_number; i++) {
	      if (article_list[i].mark & DELETE_MARK) {
		j++;
	      }
	    }
	    if (j) {
	      strcpy(buff, rmail_mbox);
	      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
			 "ưե̾ϤƲ:",
			 "Input destination folder name:", buff);
	      if (buff[0]) {
		j = 0;
		for (i = 0; i < rmail_folder_number; i++) {
		  if (!strcmp(rmail_folder[i].folder_name, buff)) {
		    status = i;
		    j = 1;
		    break;
		  }
		}
		if (!j)  {
		  if (yes_or_no(NORMAL_YN_MODE,
				"ե(%s)򿷵ޤ?",
				"Create folder(%s).Are you sure?",
				buff)) {
		    if (!rmail_create_folder(buff)) {
		      j = 1;
		    }
		  }
		}
		if (j) {
		  sprintf(refile_folder, "%s%c%s", rmail_mbox, SLASH_CHAR,
			  buff);
		  if (!strcmp(refile_folder, rmail_file)) {
		    print_mode_line(japanese ?
				    "ưȰư褬ƱեǤ" :
				    "Source and destination folders are identical.");
		    term_bell();
		    sleep(ERROR_SLEEP);
		  } else {
		    rmail_update(0, NULL);
		    rmail_update(1, refile_folder);
		    rmail_search_folder();
		    rmail_get_list();
		    if (current_article >= rmail_article_number) {
		      if (rmail_article_number > 0) {
			current_article = rmail_article_number - 1;
		      } else {
			current_article = 0;
		      }
		    }
		  }
		}
	      }
	      status = 0;
	      top_position = -1;
	    }
	    break;
	  case 0x7f:		/* ޡ	*/
	  case 0x08:
	    j = 0;
	    for (i = 0; i < rmail_article_number; i++) {
	      if (article_list[i].mark & DELETE_MARK) {
		j++;
	      }
	    }
	    if (j) {
	      if (yes_or_no(CARE_YN_MODE,
			    "ޡ줿ƺƤǤ?",
			    "Delete all marked articles.Are you sure?")) {
		rmail_update(1, NULL);
		rmail_get_list();
		if (current_article >= rmail_article_number) {
		  if (rmail_article_number > 0) {
		    current_article = rmail_article_number - 1;
		  } else {
		    current_article = 0;
		  }
		}
	      }
	      status = 0;
	    }
	    top_position = -1;
	    break;
	  case 's':		/* 		*/
	    if (!multi_save(current_article, rmail_extract)) {
	      multi_add_mark(rmail_article_number, -1, current_article,
			     READ_MARK, rmail_mark);
	    }
	    top_position = -1;
	    break;
#ifndef	SMALL
	  case '/':		/* 		*/
	    search_subjects(0, rmail_article_number, &current_article, NULL);
	    break;
	  case '\\':		/* 		*/
	    search_subjects(1, rmail_article_number, &current_article, NULL);
	    break;
	  case '|':		/* ѥ׼¹	*/
	    if (!multi_pipe(current_article, rmail_extract)) {
	      multi_add_mark(rmail_article_number, -1, current_article,
			     READ_MARK, rmail_mark);
	    }
	    top_position = -1;
	    break;
#endif	/* !SMALL */
	  case '\t':		/* TAB 국إ	*/
	    buff[0] = '\0';
	    input_line(INPUT_SPCCUT_MASK, "ֹϤƲ:",
		       "Input article number:", buff);
	    j = atoi(buff);
	    if ((j > 0) && buff[0]) {
	      for (i = 0; i < rmail_article_number; i++) {
		if (article_list[i].real_number == j) {
		  current_article = i;
		  break;
		}
	      }
	    }
	    top_position = -1;
	    break;
#ifdef	MAILSEND
	  case 'r':		/* ᡼ֿ		*/
	    create_temp_name(buff, "RR");
	    if (!rmail_extract(article_list[current_article].real_number,
		buff)) {
	      if (!mail_reply(buff, 0, select_name)) {
		rmail_mark(current_article, ANSWER_MARK);
	      }
	      funlink2(buff);
	    }
	    top_position = -1;
	    break;
	  case 'R':		/* ᡼ֿ		*/
	    create_temp_name(buff, "RR");
	    if (!multi_extract(current_article, buff, rmail_extract)) {
	      if (!mail_reply(buff, REPLY_QUOTE_MASK, select_name)) {
		multi_add_mark(rmail_article_number, -1, current_article,
			       ANSWER_MARK, rmail_mark);
	      }
	      funlink2(buff);
	    }
	    top_position = -1;
	    break;
	  case 'f':		/* ᡼ž		*/
	    create_temp_name(buff, "RT");
	    if (!rmail_extract(article_list[current_article].real_number,
			       buff)) {
	      if (!mail_forward(buff, select_name)) {
		rmail_mark(current_article, FORWARD_MARK);
	      }
	      funlink2(buff);
	    }
	    top_position = -1;
	    break;
#endif	/* MAILSEND */
	  case 'C':		/* ޡ		*/
	    rmail_unmark(current_article, READ_MARK | FORWARD_MARK
			 | ANSWER_MARK | DELETE_MARK);
	    if (article_list[current_article].mark & MULTI_MARK) {
	      multi_mark(top_position, current_article);
	    }
	    toggle_mark(top_position, current_article, 0);
	    current_article = rmail_next_article(current_article);
	    break;
	  case 'M':		/* ޥޡ/	*/
	    multi_mark(top_position, current_article);
	    current_article = rmail_next_article(current_article);
	    break;
	  default:
	    break;
	  }
	}
	switch (last_key) {
	case 'f':
	  print_title();
	case ' ':
	case 'p':
	case 'n':
	case 'P':
	case 'N':
	case 'v':
	case 'V':
	case 'r':
	case 'R':
	  break;
	default:
	  last_key = 0;
	}
      }
      break;
    }
  }
  rmail_update(0, NULL);
  return(status);
}

/*
 * Υեֹ
 */

static int	rmail_prev_folder(current_folder)
     int	current_folder;
{
  if (--current_folder < 0) {
    current_folder = 0;
  }
  return(current_folder);
}

/*
 * Υեֹ
 */

static int	rmail_next_folder(current_folder)
     int	current_folder;
{
  if (++current_folder >= rmail_folder_number) {
    if (rmail_folder_number > 0) {
      current_folder = rmail_folder_number - 1;
    } else {
      current_folder = 0;
    }
  }
  return(current_folder);
}

/*
 * ̤ɵֹ
 */

static int	rmail_prev_unread_article(current_article)
     int	current_article;
{
  while (current_article > 0) {
    if (!(article_list[--current_article].mark & READ_MARK)) {
      break;
    }
  }
  return(current_article);
}

/*
 * ̤ɵֹ
 */

static int	rmail_next_unread_article(current_article)
     int	current_article;
{
  while (current_article < (rmail_article_number - 1)) {
    if (!(article_list[++current_article].mark & READ_MARK)) {
      break;
    }
  }
  return(current_article);
}

/*
 * εֹ
 */

static int	rmail_prev_article(current_article)
     int	current_article;
{
  if (--current_article < 0) {
    current_article = 0;
  }
  return(current_article);
}

/*
 * Υե
 */

static int	rmail_next_article(current_article)
     int	current_article;
{
  if (++current_article >= rmail_article_number) {
    if (rmail_article_number > 0) {
      current_article = rmail_article_number - 1;
    } else {
      current_article = 0;
    }
  }
  return(current_article);
}

/*
 * ե
 */

static void	rmail_search_folder()
{
  struct rmail_folder	*rmail_alloc_ptr;
  char			buff1[BUFF_SIZE];
  char			buff2[BUFF_SIZE];
  char			buff3[BUFF_SIZE];
#ifdef	HAVE_FILES
  FILES_STRUCT		dp;
#else	/* !HAVE_FILES */
  DIR_PTR		*dp;
  DIR			*dir_ptr;
  struct stat		stat_buff;
#endif	/* !HAVE_FILES */
  FILE			*fp;
  int			status;

  rmail_folder_number = rmail_alloc_number = 0;
  if (rmail_folder) {
    free(rmail_folder);
    rmail_folder = NULL;
  }
#ifdef	HAVE_FILES
  sprintf(buff1, "%s%c*.*", rmail_mbox, SLASH_CHAR);
  if (!dos_files(buff1, &dp, FILE_ATTR)) {
    do {
#ifdef	__TURBOC__
      strcpy(buff1, dp.ff_name);
#else	/* !__TURBOC__ */
      strcpy(buff1, dp.name);
#endif	/* !__TURBOC__ */
      sprintf(buff2, "%s%c%s", rmail_mbox, SLASH_CHAR, buff1);
      if (buff1[strlen(buff1) - 1] != '~') {
        {
#else	/* !HAVE_FILES */
  if (dir_ptr = opendir(rmail_mbox)) {
    while (dp = readdir(dir_ptr)) {
      strcpy(buff1, dp->d_name);
      sprintf(buff2, "%s%c%s", rmail_mbox, SLASH_CHAR, buff1);
      if ((!stat(buff2, &stat_buff))
	  && (*(buff1 + strlen(dp->d_name) - 1) != '~')) {
	if ((stat_buff.st_mode & S_IFMT) == S_IFREG) {
#endif	/* !HAVE_FILES */
	  if (fp = fopen(buff2, "r")) {
	    status = 0;
	    if (fgets(buff3, sizeof(buff3), fp)) {
	      if (!strcmp(buff3, RMAIL_FIELD2)) {
		status = 1;
	      }
	    }
	    if (status) {
	      if (rmail_alloc_number <= rmail_folder_number) {
		if (rmail_folder) {
		  rmail_alloc_ptr = (struct rmail_folder*)
		    realloc(rmail_folder,
			    (rmail_alloc_number + RMAIL_ALLOC_COUNT)
			    * sizeof(struct rmail_folder));
		} else {
		  rmail_alloc_ptr = (struct rmail_folder*)
		    malloc((rmail_alloc_number + RMAIL_ALLOC_COUNT)
			   * sizeof(struct rmail_folder));
		}
		if (!rmail_alloc_ptr) {
		  print_fatal("Can't allocate memory for RMAIL folder.");
		  fclose(fp);
		  break;
		} else {
		  rmail_folder = rmail_alloc_ptr;
		  rmail_alloc_number += RMAIL_ALLOC_COUNT;
		}
	      }
	      strcpy(rmail_folder[rmail_folder_number].folder_name,
		     buff1);
	      rmail_folder_number++;
	      rmail_count(rmail_folder_number - 1);
	    }
	    fclose(fp);
	  }
	}
      }
#ifdef	HAVE_FILES
    } while (!dos_nfiles(&dp));
#else	/* !HAVE_FILES */
    }
    closedir(dir_ptr);
#endif	/* !HAVE_FILES */
  }
  if (rmail_folder_number > 0) {
    qsort(rmail_folder, rmail_folder_number, sizeof(struct rmail_folder),
	  (int (*)())strcmp);
  }
}

/*
 * 
 */

static void	rmail_count(folder_number)
     int	folder_number;
{
  FILE		*fp;
  char		buff[BUFF_SIZE];
  int		max_number;
  int		unread_number;

  if ((folder_number < 0) || (folder_number >= rmail_folder_number)) {
    print_fatal("Illegal RMAIL folder number.");
    return;
  }
  max_number = unread_number = 0;
  sprintf(buff, "%s%c%s", rmail_mbox, SLASH_CHAR,
	  rmail_folder[folder_number].folder_name);
  if (fp = fopen(buff, "r")) {
    while (1) {
      while (fgets(buff, sizeof(buff), fp)) {
	if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
	  break;
	}
      }
      if (fgets(buff, sizeof(buff), fp)) {
	max_number++;
	if (strindex(buff, RMAIL_UNSEEN_ATTRIB)) {
	  unread_number++;
	}
      } else {
	break;
      }
    }
    fclose(fp);
  }
  rmail_folder[folder_number].max_article = max_number;
  rmail_folder[folder_number].unread_article = unread_number;
}

/*
 * 
 */

static int	rmail_read(real_number, mode)
     int	real_number;
     int	mode;
{
  char	tmp_file1[PATH_BUFF];
  char	tmp_file2[PATH_BUFF];
  char	buff[SMALL_BUFF];
  int	status;

  create_temp_name(tmp_file1, "RC");
  create_temp_name(tmp_file2, "RV");
  if (rmail_extract(real_number, tmp_file1)) {
    return(1);
  }
  sprintf(buff, "%d", real_number);
  status = exec_pager(tmp_file1, tmp_file2, mode, buff);
  funlink2(tmp_file1);
  if (status) {
    return(1);
  }
  return(0);
}

/*
 * 
 */

static int	rmail_extract(real_number, tmp_file)
     int	real_number;
     char	*tmp_file;
{
  FILE	*fp1, *fp2;
  char	buff[BUFF_SIZE];
  int	status;

  strcpy(buff, rmail_file);
  if (!(fp1 = fopen(buff, "r"))) {
    return(1);
  }
  while (1) {
    if (!fgets(buff, sizeof(buff), fp1)) {
      fclose(fp1);
      return(1);
    }
    if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
      if (--real_number <= 0) {
	break;
      }
    }
  }
  if (!fgets(buff, sizeof(buff), fp1)) {/*	Attribute ԤΤƤ	*/
    fclose(fp1);
    return(1);
  }
  if (!(fp2 = fopen2(tmp_file, "a"))) {
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  status = 1;
  while (1) {
    if (!fgets(buff, sizeof(buff), fp1)) {
      fclose(fp1);
      return(1);
    }
    if (!strncmp(buff, RMAIL_EOOH, sizeof(RMAIL_EOOH) - 1)) {
      break;
    }
    fputs(buff, fp2);
    status = 0;
  }
  while (fgets(buff, sizeof(buff), fp1)) {
    if ((buff[0] == '\n') || (buff[0] == '\0') || status) {
      if (status) {
	fputs(buff, fp2);
      }
      while (fgets(buff, sizeof(buff), fp1)) {
	if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
	  break;
	}
	fputs(buff, fp2);
      }
      break;
    }
  }
  fclose(fp1);
  fclose(fp2);
  return(0);
}

/*
 * ޡɲ
 */

static void	rmail_mark(current_article, mark)
     int	current_article;
     int	mark;
{
  if (!(article_list[current_article].mark & mark)) {
    article_list[current_article].mark |= mark;
    rmail_modify = 1;
  }
}

/*
 * ޡ
 */

static void	rmail_unmark(current_article, mark)
     int	current_article;
     int	mark;
{
  if (article_list[current_article].mark & mark) {
    article_list[current_article].mark &= ~mark;
    rmail_modify = 1;
  }
}

/*
 * ꥹȼ
 */

static int	rmail_get_list()
{
  FILE			*fp;
  char			buff[BUFF_SIZE];
  static char		from_buff[BUFF_SIZE];
  static char		date_buff[MAX_FIELD_LEN];
  static char		subject_buff[BUFF_SIZE];
  static char		x_nsubj_buff[MAX_FIELD_LEN];
#ifdef	REF_SORT
  static char		message_buff[MAX_FIELD_LEN];
  static char		reference_buff[BUFF_SIZE];
  static char		in_reply_buff[BUFF_SIZE];
#endif	/* REF_SORT */
  static struct cpy_hdr	rmail_fields[] = {
    {FROM_FIELD,	from_buff,	sizeof(from_buff)},
    {DATE_FIELD,	date_buff,	sizeof(date_buff)},
    {SUBJECT_FIELD,	subject_buff,	sizeof(subject_buff)},
    {X_NSUBJ_FIELD,	x_nsubj_buff,	sizeof(x_nsubj_buff)},
#ifdef	REF_SORT
    {MESSAGE_FIELD,	message_buff,	sizeof(message_buff)},
    {REFERENCE_FIELD,	reference_buff,	sizeof(reference_buff)},
    {IN_REPLY_FIELD,	in_reply_buff,	sizeof(in_reply_buff)},
#endif	/* REF_SORT */
  };
  char			*alloc_ptr;
#ifdef	REF_SORT
  char			*ptr;
#else	/* !REF_SORT */
  short			year;
#endif	/* !REF_SORT */
  short			day, hour, minute, second;
  int			alloc_number;
  int			mark;
  register int		lines;

  rmail_article_number = rmail_modify = multi_number = 0;
  if (article_list) {
    free(article_list);
  }
  article_list = NULL;
  alloc_number = 0;
  strcpy(buff, rmail_file);
  if (!(fp = fopen(buff, "r"))) {
    return(1);
  }
  while (fgets(buff, sizeof(buff), fp)) {
    if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
      break;
    }
  }
  while (fgets(buff, sizeof(buff), fp)) {
    mark = 0;
    if (!strindex(buff, RMAIL_UNSEEN_ATTRIB)) {
      mark |= READ_MARK;
    }
    if (strindex(buff, RMAIL_FORWARD_ATTRIB)) {
      mark |= FORWARD_MARK;
    }
    if (strindex(buff, RMAIL_ANSWER_ATTRIB)) {
      mark |= ANSWER_MARK;
    }
    if (strindex(buff, RMAIL_DELETE_ATTRIB)) {
      mark |= DELETE_MARK;
    }
    second = atoi(buff);
    if (second) {
      lines = copy_fields(fp, rmail_fields,
			  sizeof(rmail_fields)/sizeof(struct cpy_hdr),
			  CF_CLR_MASK | CF_GET_MASK | CF_SPC_MASK);
    }
    while (fgets(buff, sizeof(buff), fp)) {
      if (!strncmp(buff, RMAIL_EOOH, sizeof(RMAIL_EOOH) - 1)) {
	break;
      }
    }
    if (second) {
      copy_fields(fp, rmail_fields, 0,	/* ɤ߼ΤƤʤΤ 0 ɤ	*/
		  CF_CLR_MASK | CF_GET_MASK | CF_SPC_MASK);
    } else {
      lines = copy_fields(fp, rmail_fields,
			  sizeof(rmail_fields)/sizeof(struct cpy_hdr),
			  CF_CLR_MASK | CF_GET_MASK | CF_SPC_MASK);
    }
    while (fgets(buff, sizeof(buff), fp)) {
      if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
	break;
      }
      lines++;
    }
    if (alloc_number <= rmail_article_number) {
      if (article_list) {
	alloc_ptr = (char*)realloc(article_list,
				   sizeof(ARTICLE_LIST) *
				   (alloc_number + RMAIL_ALLOC_COUNT));
      } else {
	alloc_ptr = (char*)malloc(sizeof(ARTICLE_LIST) *
				  (alloc_number + RMAIL_ALLOC_COUNT));
      }
      if (!alloc_ptr) {
	print_fatal("Can't allocate memory for RMAIL article struct.");
	break;
      }
      article_list = (ARTICLE_LIST*)alloc_ptr;
#ifdef	REF_SORT
      if (sort_rule == 1) {
	if (message_list) {
	  alloc_ptr = (char*)realloc(message_list,
				     sizeof(MESSAGE_LIST) *
				     (alloc_number + RMAIL_ALLOC_COUNT));
	} else {
	  alloc_ptr = (char*)malloc(sizeof(MESSAGE_LIST) *
				    (alloc_number + RMAIL_ALLOC_COUNT));
	}
	if (!alloc_ptr) {
	  print_fatal("Can't allocate memory for message struct.");
	  break;
	}
	message_list = (MESSAGE_LIST*)alloc_ptr;
      }
#endif	/* REF_SORT */
      alloc_number += RMAIL_ALLOC_COUNT;
    }
    article_list[rmail_article_number].real_number = rmail_article_number + 1;
    article_list[rmail_article_number].lines = lines;
    article_list[rmail_article_number].mark = mark;
    get_real_adrs(from_buff, article_list[rmail_article_number].from);
    if (x_nsubj_mode && x_nsubj_buff[0]) {
      recover_jis(subject_buff, x_nsubj_buff);
    }
    mime_decode_func(from_buff, subject_buff, default_code);
    euc_tab_strncpy(article_list[rmail_article_number].subject, from_buff,
		    MAX_SUBJECT_LEN - 1);
#ifdef	REF_SORT
    convert_article_date(date_buff, &article_list[rmail_article_number].year,
			 &article_list[rmail_article_number].month,
			 &article_list[rmail_article_number].date,
			 &day, &hour, &minute, &second, from_buff);
    if (message_list) {
      strncpy(message_list[rmail_article_number].msg_id, message_buff,
	      MAX_FIELD_LEN - 1);
      message_list[rmail_article_number].msg_id[MAX_FIELD_LEN - 1] = '\0';
      if (ptr = strrchr(reference_buff, '<')) {
	strncpy(message_list[rmail_article_number].ref_id, ptr,
		MAX_FIELD_LEN - 1);
	message_list[rmail_article_number].ref_id[MAX_FIELD_LEN - 1] = '\0';
      } else if (ptr = strrchr(in_reply_buff, '<')) {
	strncpy(message_list[rmail_article_number].ref_id, ptr,
		MAX_FIELD_LEN - 1);
	message_list[rmail_article_number].ref_id[MAX_FIELD_LEN - 1] = '\0';
      } else {
	message_list[rmail_article_number].ref_id[0] = '\0';
      }
      if (ptr = strchr(message_list[rmail_article_number].ref_id, '>')) {
	*(ptr + 1) = '\0';
      }
    }
#else /* !REF_SORT */
    convert_article_date(date_buff, &year,
			 &article_list[rmail_article_number].month,
			 &article_list[rmail_article_number].date,
			 &day, &hour, &minute, &second, from_buff);
#endif /* !REF_SORT */
    rmail_article_number++;
  }
  fclose(fp);

  /*	Ƚ	*/

  if (sort_articles(-1, &rmail_article_number,
		    mail_thread_mode, 0,
		    NULL, NULL) < 0) {
    return(-1);
  }

  /*	ѥå	*/

#ifdef	notdef
  if (mail_article_mask) {
    pack_articles(-1, &rmail_article_number, NULL, NULL);
  }
#endif	/* notdef */
  return(0);
}

/*
 * 嵭
 */

static void	rmail_include(spool_file, rm_flag)
     char	*spool_file;
     int	rm_flag;
{
  FILE	*fp1, *fp2;
  int	status;
#ifdef	CONTENT_LENGTH
  int	length1, length2;
#endif	/* CONTENT_LENGTH */
  char	backup_file[PATH_BUFF];
  char	buff[BUFF_SIZE];

  /*	Хååץեإ͡	*/

  create_backup_name(backup_file, rmail_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  if (rename(rmail_file, backup_file) && (errno != ENOENT)) {
    print_fatal("Can't rename RMAIL folder file.");
    return;
  }
  if ((fp2 = fopen(rmail_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't save new RMAIL folder file.");
    return;
  }
  chmod(rmail_file, S_IREAD | S_IWRITE);
  print_mode_line(japanese ? "RMAIL ե򹹿Ǥ" :
		  "Updating rmail folder file.");
  fprintf(fp2, "%s", RMAIL_FIELD1);
  fprintf(fp2, RMAIL_NOTE_FIELD1, MNEWS_VERSION);
  fprintf(fp2, RMAIL_NOTE_FIELD2);
  fprintf(fp2, RMAIL_NOTE_FIELD3);
  fprintf(fp2, "%s", RMAIL_SEPARATER);
  if (fp1 = fopen(backup_file, "r")) {
    while (fgets(buff, sizeof(buff), fp1)) {
      if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
	break;
      }
    }
    status = 1;
    while (1) {
      if (!fgets(buff, sizeof(buff), fp1)) {
	if (!status) {
	  fprintf(fp2, "%s", RMAIL_SEPARATER);
	}
	break;
      }
      if (status) {
	fprintf(fp2, "%s\n", RMAIL_SEPARATER2);
	status = 0;
      }
      if (strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
	fputs(buff, fp2);
      } else {
	status = 1;
	fprintf(fp2, "%s", RMAIL_SEPARATER);
      }
    }
    fclose(fp1);
  }
  status = 0;
  if (fp1 = fopen(spool_file, "r")) {
    if ((!fgets(buff, sizeof(buff), fp1)) ||
	strncmp(buff, RMAIL_SPOOL_SEPARATER,
		sizeof(RMAIL_SPOOL_SEPARATER) - 1)) {
      status = 1;
      if (!strcmp(buff, "\n")) {
	if (fgets(buff, sizeof(buff), fp1) &&
	    (!strncmp(buff, RMAIL_SPOOL_SEPARATER,
		      sizeof(RMAIL_SPOOL_SEPARATER) - 1))) {
	  status = 0;
	}
      }
      if (status) {
	print_fatal("Unexpected spool file format.");
	fclose(fp1);
	fclose(fp2);
	return;
      }
    }
    while (1) {
      if (feof(fp1)) {
	status = 1;
	break;
      }
#ifdef	CONTENT_LENGTH
      length1 = length2 = 0;
#endif	/* CONTENT_LENGTH */
      fprintf(fp2, "%s\n0, %s,,\n", RMAIL_SEPARATER2, RMAIL_UNSEEN_ATTRIB);
      fprintf(fp2, "%s\n", RMAIL_EOOH);
      while (fgets(buff, sizeof(buff), fp1)) {
	fputs(buff, fp2);
	if ((buff[0] == '\n') || (buff[0] == '\0')) {
	  break;
	}
#ifdef	CONTENT_LENGTH
	if (!strncasecmp(buff, LENGTH_FIELD, sizeof(LENGTH_FIELD) - 1)) {
	  length1 = atoi(&buff[sizeof(LENGTH_FIELD) - 1]);
	}
#endif	/* CONTENT_LENGTH */
      }
      while (fgets(buff, sizeof(buff), fp1)) {
#ifdef	CONTENT_LENGTH
	length2 += strlen(buff);
	if ((length2 >= length1) &&
	    (!strncmp(buff, RMAIL_SPOOL_SEPARATER,
		      sizeof(RMAIL_SPOOL_SEPARATER) - 1))) {
	  break;
	}
#else	/* !CONTENT_LENGTH */
	if (!strncmp(buff, RMAIL_SPOOL_SEPARATER,
		     sizeof(RMAIL_SPOOL_SEPARATER) - 1)) {
	  break;
	}
#endif	/* !CONTENT_LENGTH */
	fputs(buff, fp2);
      }
      fprintf(fp2, "%s", RMAIL_SEPARATER);
    }
    fclose(fp1);
  }
  if (fclose(fp2)) {
    print_fatal("Can't save new RMAIL folder file.");
  } else if (status && rm_flag) {
#ifndef	DEBUG
#ifdef	notdef
    unlink(spool_file);
#else	/* !notdef */
    if (fp1 = fopen(spool_file, "w")) {
      fclose(fp1);
    } else {
      print_fatal("Can't truncate spool file.");
    }
#endif	/* !notdef */
#endif	/* !DEBUG */
  }
}

/*
 * RMAIL ե빹(ޡ)
 */

static void	rmail_update(mode, refile_folder)
     int	mode;		/* 0:ޡ 0ʳ: or ư */
     char	*refile_folder;	/* ưե */
{
  FILE		*fp1, *fp2, *fp3;
  int		article_number;
  char		backup_file[PATH_BUFF];
  char		buff[BUFF_SIZE];
  char		*ptr1, *ptr2;
  long		position;
  register int	i, j;
  int		ignore;

  /*	ɬå	*/

  if (!(mode || rmail_modify)) {
    return;
  }

  /*	Хååץեإ͡	*/

  create_backup_name(backup_file, rmail_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  if (rename(rmail_file, backup_file) && (errno != ENOENT)) {
    print_fatal("Can't rename RMAIL folder file.");
    return;
  }
  if ((fp1 = fopen(backup_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't read backup RMAIL folder file.");
    return;
  }
  if ((fp2 = fopen(rmail_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't save new RMAIL folder file.");
    fclose(fp1);
    return;
  }
  chmod(rmail_file, S_IREAD | S_IWRITE);
  fp3 = NULL;
  if (refile_folder) {
    if ((fp3 = fopen(refile_folder, "a")) == (FILE*)NULL) {
      print_fatal("Can't append RMAIL folder file.");
      fclose(fp1);
      fclose(fp2);
      rename(backup_file, rmail_file);
      return;
    }
    print_mode_line(japanese ? "եǤ" : "Refiling.");
  } else {
    if (mode) {
      print_mode_line(japanese ? "Ǥ" : "Removing.");
    } else {
      print_mode_line(japanese ? "Ǥ" : "Updating.");
    }
  }
  article_number = 0;
  while (1) {
    if (!fgets(buff, sizeof(buff), fp1)) {
      print_fatal("Unexpected RMAIL folder file format.");
      fclose(fp1);
      return;
    }
    if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
      break;
    }
    fputs(buff, fp2);
  }
  while (!feof(fp1)) {
    for (i = 0; i < rmail_article_number; i++) {
      if (article_list[i].real_number == (article_number + 1)) {
	break;
      }
    }
    if (i < rmail_article_number) {
      if (mode && (article_list[i].mark & DELETE_MARK)) {
	if (fp3) {
	  fprintf(fp3, "%s\n", RMAIL_SEPARATER2);
	}
	j = 1;
	while (fgets(buff, sizeof(buff), fp1)) {
	  if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
	    if (fp3) {
	      fprintf(fp3, "%s", RMAIL_SEPARATER);
	    }
	    break;
	  }
	  if (fp3) {
	    if (j) {
	      j = 0;
	      if (ptr1 = strindex(buff, RMAIL_DELETE_STRING)) {
		ptr2 = ptr1 + sizeof(RMAIL_DELETE_STRING) - 1;
		while (*ptr2) {
		  *ptr1++ = *ptr2++;
		};
		*ptr1 = '\0';
	      }
	    }
	    fputs(buff, fp3);
	  }
	}
	article_number++;
	continue;
      }
    }
    fprintf(fp2, "%s%s\n", RMAIL_SEPARATER, RMAIL_SEPARATER2);
    if (i < rmail_article_number) {
      if (fgets(buff, sizeof(buff), fp1)) {
	if (buff[0] == '0') {
	  if (article_list[i].mark & READ_MARK) {
	    if (fgets(buff, sizeof(buff), fp1)) {
	      fprintf(fp2, "1,");
	      if (article_list[i].mark & FORWARD_MARK) {
		fprintf(fp2, " %s,", RMAIL_FORWARD_ATTRIB);
	      }
	      if (article_list[i].mark & ANSWER_MARK) {
		fprintf(fp2, " %s,", RMAIL_ANSWER_ATTRIB);
	      }
	      if (article_list[i].mark & DELETE_MARK) {
		fprintf(fp2, " %s,", RMAIL_DELETE_ATTRIB);
	      }
	      fprintf(fp2, ",\n");
	      if (strncmp(buff, RMAIL_EOOH, sizeof(RMAIL_EOOH) - 1)) {
		print_fatal("Unexpected RMAIL folder file format.");
	      }
	      position = ftell(fp1);
	      while (fgets(buff, sizeof(buff), fp1)) {
		fputs(buff, fp2);
		if ((buff[0] == '\n') || (buff[0] == '\0')) {
		  break;
		}
	      }
	      fprintf(fp2, "%s\n", RMAIL_EOOH);
	      fseek(fp1, (long)position, 0);
	      ignore = 0;
	      while (fgets(buff, sizeof(buff), fp1)) {
		if ((buff[0] != ' ') && (buff[0] != '\t')) {
		  ignore = 0;
		  for (j = 0; j < (sizeof(rmail_ignore_field)
				   / sizeof(char*)); j++) {
		    if (!strncasecmp(buff, rmail_ignore_field[j],
				     strlen(rmail_ignore_field[j]))) {
		      ignore = 1;
		      break;
		    }
		  }
		}
		if (!ignore) {
		  fputs(buff, fp2);
		}
		if ((buff[0] == '\n') || (buff[0] == '\0')) {
		  break;
		}
	      }
	    }
	  } else {
	    fprintf(fp2, "0, %s,", RMAIL_UNSEEN_ATTRIB);
	    if (article_list[i].mark & FORWARD_MARK) {
	      fprintf(fp2, " %s,", RMAIL_FORWARD_ATTRIB);
	    }
	    if (article_list[i].mark & ANSWER_MARK) {
	      fprintf(fp2, " %s,", RMAIL_ANSWER_ATTRIB);
	    }
	    if (article_list[i].mark & DELETE_MARK) {
	      fprintf(fp2, " %s,", RMAIL_DELETE_ATTRIB);
	    }
	    fprintf(fp2, ",\n");
	  }
	} else {
	  if (article_list[i].mark & READ_MARK) {
	    fprintf(fp2, "1,");
	    if (article_list[i].mark & FORWARD_MARK) {
	      fprintf(fp2, " %s,", RMAIL_FORWARD_ATTRIB);
	    }
	    if (article_list[i].mark & ANSWER_MARK) {
	      fprintf(fp2, " %s,", RMAIL_ANSWER_ATTRIB);
	    }
	    if (article_list[i].mark & DELETE_MARK) {
	      fprintf(fp2, " %s,", RMAIL_DELETE_ATTRIB);
	    }
	    fprintf(fp2, ",\n");
	  } else {
	    fprintf(fp2, "0, %s,", RMAIL_UNSEEN_ATTRIB);
	    if (article_list[i].mark & FORWARD_MARK) {
	      fprintf(fp2, " %s,", RMAIL_FORWARD_ATTRIB);
	    }
	    if (article_list[i].mark & ANSWER_MARK) {
	      fprintf(fp2, " %s,", RMAIL_ANSWER_ATTRIB);
	    }
	    if (article_list[i].mark & DELETE_MARK) {
	      fprintf(fp2, " %s,", RMAIL_DELETE_ATTRIB);
	    }
	    fprintf(fp2, ",\n");
	    fprintf(fp2, "%s\n", RMAIL_EOOH);
	    while (fgets(buff, sizeof(buff), fp1)) {
	      if (!strncmp(buff, RMAIL_EOOH, sizeof(RMAIL_EOOH) - 1)) {
		while (fgets(buff, sizeof(buff), fp1)) {
		  if ((buff[0] == '\n') || (buff[0] == '\0')) {
		    break;
		  }
		}
		break;
	      }
	      fputs(buff, fp2);
	    }
	  }
	}
      }
    }
    while (fgets(buff, sizeof(buff), fp1)) {
      if (!strncmp(buff, RMAIL_SEPARATER, sizeof(RMAIL_SEPARATER) - 1)) {
	break;
      }
      fputs(buff, fp2);
    }
    article_number++;
  }
  fclose(fp1);
  fprintf(fp2, "%s", RMAIL_SEPARATER);
  fclose(fp2);
  if (fp3) {
    fclose(fp3);
  }
}

/*
 * ե
 */

static int	rmail_create_folder(folder_name)
     char	*folder_name;
{
  struct stat	stat_buff;
  FILE		*fp;
  char		buff[BUFF_SIZE];

  sprintf(buff, "%s%c%s", rmail_mbox, SLASH_CHAR, folder_name);
  if (stat(buff, &stat_buff)) {
    if (fp = fopen(buff, "w")) {
      chmod(buff, S_IREAD | S_IWRITE);
      fprintf(fp, "%s", RMAIL_FIELD1);
      fprintf(fp, RMAIL_NOTE_FIELD1, MNEWS_VERSION);
      fprintf(fp, RMAIL_NOTE_FIELD2);
      fprintf(fp, RMAIL_NOTE_FIELD3);
      fprintf(fp, "%s", RMAIL_SEPARATER);
      fclose(fp);
      return(0);
    }
  }
  term_bell();
  print_mode_line(japanese ? "եǤޤǤ" :
		  "Can't create folder.");
  sleep(ERROR_SLEEP);
  return(1);
}

/*
 * ե
 */

static int	rmail_delete_folder(folder_name)
     char	*folder_name;
{
  char		buff[BUFF_SIZE];

  sprintf(buff, "%s%c%s", rmail_mbox, SLASH_CHAR, folder_name);
  if (!unlink(buff)) {
    return(0);
  }
  term_bell();
  print_mode_line(japanese ? "եǤޤǤ" :
		  "Can't delete folder.");
  sleep(ERROR_SLEEP);
  return(1);
}

/*
 * ե
 */

static int	rmail_adjust_folder(folder_name)
     char	*folder_name;
{
  int	current_folder;
  int	i;

  current_folder = 0;
  for (i = 0; i < rmail_folder_number; i++) {
    if (strcmp(rmail_folder[i].folder_name, folder_name) > 0) {
      break;
    }
    current_folder = i;
  }
  return(current_folder);
}

#ifndef	SMALL
/*
 * ե̾(ʣ)
 */

static int	rmail_search_name(mode, max_folder, folder_ptr)
     int	mode;
     int	max_folder;
     int	*folder_ptr;
{
  register int	current_folder;
  char		*str;

  if (str = input_search_string(mode)) {
    if (mode) {
      for (current_folder = *folder_ptr - 1; current_folder >= 0;
	   current_folder--) {
	if (strindex(rmail_folder[current_folder].folder_name, str)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *folder_ptr = current_folder;
	  return(0);
	}
      }
    } else {
      for (current_folder = *folder_ptr + 1; current_folder < max_folder;
	   current_folder++) {
	if (strindex(rmail_folder[current_folder].folder_name, str)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *folder_ptr = current_folder;
	  return(0);
	}
      }
    }
    print_mode_line(japanese ? "ĤޤǤ" : "Search failed.");
    return(1);
  }
  return(0);
}
#endif	/* !SMALL */
#endif	/* RMAIL */
