/*
 *
 *  ü饤֥
 *
 *  Copyright 1990-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Terminal Control Library
 *  Sub system  : library define
 *  File        : termlib.h
 *  Version     : 1.38
 *  First Edit  : 1990-11/01
 *  Last  Edit  : 1995-06/30
 *  Author      : MSR24  
 *
 */

#ifndef	MSDOS
#ifdef	TERMIO
#include	<termio.h>
#else	/* !TERMIO */
#ifdef	TERMINFO
#include	<curses.h>
#include	<term.h>
#else	/* !TERMINFO */
#include	<sgtty.h>
#endif	/* !TERMINFO */
#endif	/* !TERMIO */
#include	<sys/wait.h>
#endif	/* !MSDOS */

/*
 * ץ
 */

#ifndef	TERMCAP
#define	CLEAR_ALL_STRING	"\033[H\033[2J"
#define	CLEAR_LINE_STRING	"\033[0K"
#define	CLEAR_END_STRING	"\033[0J"
#define	LOCATE_STRING		"\033[%d;%dH"
#define	INS_LINE_STRING		"\033[L"
#define	INS_CHAR_STRING		"\033[@"
#define	UP_STRING		"\033[A"
#define	DOWN_STRING		"\033[B"
#define	LEFT_STRING		"\033[D"
#define	RIGHT_STRING		"\033[C"
#define	REVERSE_STRING		"\033[7m"
#define	NORMAL_STRING		"\033[m"
#define	ATTRIB_STRING		"\033[%dm"
#define	BELL_STRING		"\007"
#endif	/* !TERMCAP */

#define	TERM_BUFF	16
#ifndef	BUFF_SIZE
#define	BUFF_SIZE	1024
#endif	/* !BUFF_SIZE */

#ifdef	X68K
#define	DEFAULT_COLUMNS	96
#define	DEFAULT_LINES	31
#else	/* !X68K */
#define	DEFAULT_COLUMNS	80
#define	DEFAULT_LINES	24
#endif	/* !X68K */

/*
 * °
 */

#define	RESET_ATTRIB		0
#define	LIGHT_ATTRIB		1
#define	LINE_ATTRIB		4
#define	BLINK_ATTRIB		5
#define	REVERSE_ATTRIB		7
#define	HIDE_ATTRIB		8
#ifdef	X68K
#define	FG_BLACK1_ATTRIB	30
#define	FG_SKYBLUE1_ATTRIB	31
#define	FG_YELLOW1_ATTRIB	32
#define	FG_WHITE1_ATTRIB	33
#define	FG_BLACK2_ATTRIB	34
#define	FG_SKYBLUE2_ATTRIB	35
#define	FG_YELLOW2_ATTRIB	36
#define	FG_WHITE2_ATTRIB	37
#define	BG_BLACK1_ATTRIB	40
#define	BG_SKYBLUE1_ATTRIB	41
#define	BG_YELLOW1_ATTRIB	42
#define	BG_WHITE1_ATTRIB	43
#define	BG_BLACK2_ATTRIB	44
#define	BG_SKYBLUE2_ATTRIB	45
#define	BG_YELLOW2_ATTRIB	46
#define	BG_WHITE2_ATTRIB	47

#define	FG_BLACK_ATTRIB		30
#define	BG_BLACK_ATTRIB		40
#else	/* !X68K */
#define	FG_BLACK_ATTRIB		30
#define	FG_RED_ATTRIB		31
#define	FG_GREEN_ATTRIB		32
#define	FG_YELLOW_ATTRIB	33
#define	FG_BLUE_ATTRIB		34
#define	FG_PURPLE_ATTRIB	35
#define	FG_SKYBLUE_ATTRIB	36
#define	FG_WHITE_ATTRIB		37
#define	BG_BLACK_ATTRIB		40
#define	BG_RED_ATTRIB		41
#define	BG_GREEN_ATTRIB		42
#define	BG_YELLOW_ATTRIB	43
#define	BG_BLUE_ATTRIB		44
#define	BG_PURPLE_ATTRIB	45
#define	BG_SKYBLUE_ATTRIB	46
#define	BG_WHITE_ATTRIB		47
#endif	/* !X68K */

extern int	term_lines;
extern int	term_columns;
extern int	term_resize_flag;

extern char	*tgetstr();
extern int	tgetnum();
extern int	tgetent();

int		term_init();		/* ü			*/
void		term_clear_all();	/* ̥ꥢ			*/
void		term_clear_line();	/* ޤǺ			*/
void		term_clear_end();	/* üޤǺ		*/
void		term_bell();		/* ٹ٥			*/
void		term_locate();		/* ư			*/
void		term_home();		/* ۡư		*/
void		term_insert();		/* 			*/
void		term_insert_char();	/* ʸ			*/
void		term_up();		/* ư		*/
void		term_down();		/* 벼ư		*/
void		term_left();		/* 뺸ư		*/
void		term_right();		/* 뱦ư		*/
void		term_top();		/* Ƭư		*/
void		term_crlf();		/* 				*/
void		term_fill_right();	/* üʸ		*/
void		term_attrib();		/* ɽ°ѹ			*/
void		term_set_raw();		/* RAW ⡼ɥå		*/
void		term_reset_raw();	/* RAW ⡼ɥꥻå		*/
void		term_set_cbreak();	/* CBREAK ⡼ɥå		*/
void		term_reset_cbreak();	/* CBREAK ⡼ɥꥻå	*/
void		term_set_echo();	/* ECHO ⡼ɥå		*/
void		term_reset_echo();	/* ECHO ⡼ɥꥻå		*/
void		term_set_nl();		/* NL ⡼ɥå		*/
void		term_reset_nl();	/* NL ⡼ɥꥻå		*/
int		term_system();		/* ü¹		*/
