/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : UCB-mail support routine
 *  File        : ucbmail.c
 *  Version     : 1.19
 *  First Edit  : 1992-07/27
 *  Last  Edit  : 1995-07/20
 *  Author      : MSR24  
 *
 */

#ifdef	UCBMAIL
#include	"compat.h"
#include	"nntplib.h"
#include	"mnews.h"
#include	"kanjilib.h"
#include	"termlib.h"
#include	"group.h"
#include	"article.h"
#include	"ucbmail.h"
#include	"pager.h"
#include	"mailsend.h"

static int	ucbmail_select_folder();/* ե			*/
static void	ucbmail_redraw_folder();/* ե̺	*/
static int	ucbmail_select_article();
					/* 			*/
static void	ucbmail_redraw_article();
					/* ̺		*/
static int	ucbmail_prev_folder();	/* Υեֹ		*/
static int	ucbmail_next_folder();	/* Υեֹ		*/
static int	ucbmail_prev_unread_article();
					/* εֹ		*/
static int	ucbmail_next_unread_article();
					/* εֹ		*/
static int	ucbmail_prev_article();	/* εֹ		*/
static int	ucbmail_next_article();	/* εֹ		*/
static void	ucbmail_search_folder();/* ե		*/
static int	ucbmail_read();		/* 			*/
static int	ucbmail_extract();	/* 			*/
static void	ucbmail_mark();		/* ޡɲ		*/
static void	ucbmail_unmark();	/* ޡ		*/
static void	ucbmail_count();	/* 		*/
static int	ucbmail_get_list();	/* ꥹȼ		*/
static void	ucbmail_include();	/* 嵭		*/
static void	ucbmail_update();	/* MBOX ե빹		*/
static int	ucbmail_create_folder();/* ե			*/
static int	ucbmail_delete_folder();/* ե			*/
static int	ucbmail_adjust_folder();/* ե		*/
static int	ucbmail_search_name();	/* ե̾		*/

/*
 * UCB-mail եꥹ
 */

static int	ucbmail_folder_number;	/* UCB-mail ե		*/
static int	ucbmail_alloc_number;	/* UCB-mail ե	*/
static char	ucbmail_file[PATH_BUFF];/* UCB-mail եե̾	*/
static struct ucbmail_folder	*ucbmail_folder = NULL;
static int	top_position;		/* ɽϰ		*/
static int	ucbmail_article_number;	/* UCB-mail 	*/
static int	ucbmail_modify;		/* UCB-mail ե饰	*/

/*
 * UCB-mail إץå
 */

static char	*ucbmail_folder_jmessage[] = {
  "UCB ᡼ե⡼\n\n",
  "\tk, ^P ޤ p  Υե˰ưޤ\n",
  "\tj, ^N ޤ n  Υե˰ưޤ\n",
  "\ti ޤ SPACE  ե򤷤ޤ\n",
  "\t^U ޤ ^B    ̤Υե˰ưޤ\n",
  "\t^D, ^F ޤ ^V\n",
  "\t                ̤Υե˰ưޤ\n",
  "\t<               ƬΥե˰ưޤ\n",
  "\t>               ǸΥե˰ưޤ\n",
  "\to, q ޤ RETURN\n",
  "\t                ե⡼ɤȴޤ\n",
#ifndef	SMALL
  "\t/               ե̾ޤ\n",
  "\t                (ʸϤƲ)\n",
  "\t\\               ե̾ޤ\n",
  "\t                (ʸϤƲ)\n",
#endif	/* !SMALL */
  "\tTAB             Υե˥פޤ\n",
  "\t                (եƥޤϥե̾ϤƲ)\n",
#ifdef	MAILSEND
  "\tm               ˥᡼Фޤ\n",
#endif	/* MAILSEND */
  "\tC               ˥եޤ\n",
  "\t                (ե̾ϤƲ)\n",
  "\tDEL ޤ BS   եޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  NULL,
  };

static char	*ucbmail_article_jmessage[] = {
  "UCB ᡼뵭⡼\n\n",
  "\tk ޤ ^P     ε˰ưޤ\n",
  "\tj ޤ ^N     ε˰ưޤ\n",
  "\tSPACE, i ޤ .\n",
  "\t                򻲾Ȥޤ\n",
  "\tv ޤ V      ƤΥإåȤȤ˵򻲾Ȥޤ\n",
#ifdef	MIME
  "\t                ('V'  MIME ǥб)\n",
#endif	/* MIME */
  "\tp               ̤ɵ򻲾Ȥޤ\n",
  "\tn               ̤ɵ򻲾Ȥޤ\n",
  "\tP               ε򻲾Ȥޤ\n",
  "\tN               ε򻲾Ȥޤ\n",
  "\t^U ޤ ^B    ̤ε˰ưޤ\n",
  "\t^D, ^F ޤ ^V\n",
  "\t                ̤ε˰ưޤ\n",
  "\t<               Ƭε˰ưޤ\n",
  "\t>               Ǹε˰ưޤ\n",
  "\tD               ޡεذưޤ\n",
  "\td               ޡεذưޤ\n",
  "\tU               ޡεذưޤ\n",
  "\tu               ޡεذưޤ\n",
  "\ts               򥻡֤ޤ\n",
  "\t                (ե̾ϤƲե뤬¸ߤ\n",
  "\t                 Y:ڥ N: O:񤭤ǲ)\n",
  "\tc               ޡޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\tTAB             ε˥פޤ\n",
  "\t                (ֹϤƲ)\n",
#ifdef	MAILSEND
  "\tm               ˥᡼Фޤ\n",
  "\tr               ֿޤ\n",
  "\tR               Ѥֿޤ\n",
  "\tf               žޤ\n",
#endif	/* MAILSEND */
  "\tM               ޥޡ/εذưޤ\n",
  "\tC               ޡεذưޤ\n",
  "\t^               ޡ줿̤Υե˰ưޤ\n",
  "\t                (ưե̾Ƥޤ)\n",
  "\tDEL ޤ BS   ޡ줿ޤ\n",
  "\t                (Y/N ǳǧƤޤ)\n",
  "\tI               ᡼ߤޤ\n",
#ifndef	SMALL
  "\tL               UCB-mail εեߤޤ\n",
  "\t                (ե̾ϤƲ)\n",
#endif	/* !SMALL */
  "\tl               /줿ɽ⡼ɤؤޤ\n",
  "\tt               åɥ⡼ɤؤޤ\n",
#ifdef	REF_SORT
  "\tT               ˡؤޤ\n",
#endif	/* REF_SORT */
  "\to, q ޤ RETURN\n",
  "\t                ⡼ɤȴޤ\n",
  NULL,
};

static char	*ucbmail_folder_message[] = {
#ifndef	SMALL
  "UCB-MAIL FOLDER SELECT MODE\n\n",
  "\tk, ^P or p   previous folder.\n",
  "\tj, ^N or n   next folder.\n",
  "\ti or SPACE   select folder.\n",
  "\t^U or ^B     previous page folder.\n",
  "\t^D, ^F or ^V next page folder.\n",
  "\t<            top folder.\n",
  "\t>            last folder.\n",
  "\to, q or RETURN\n",
  "\t             exit from folder select mode.\n",
  "\t/            forward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\t\\            backward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\tTAB          jump to specified folder.\n",
  "\t             (Please input folder name.)\n",
#ifdef	MAILSEND
  "\tm            mail.\n",
#endif	/* MAILSEND */
  "\tC            create new folder.\n",
  "\t             (Please input folder name.)\n",
  "\tDEL or BS    delete folder.\n",
  "\t             (Please make sure Y/N.)\n",
#endif	/* !SMALL */
  NULL,
  };

static char	*ucbmail_article_message[] = {
#ifndef	SMALL
  "UCB-MAIL ARTICLE SELECT MODE\n\n",
  "\tk or ^P      previous article.\n",
  "\tj or ^N      next article.\n",
  "\tSPACE, i or .\n",
  "\t             read article.\n",
  "\tv or V       read article with all header.\n",
#ifdef	MIME
  "\t             ('V' decode MIME header.)\n",
#endif	/* MIME */
  "\tp            read previous unread article.\n",
  "\tn            read next unread article.\n",
  "\tP            read previous article.\n",
  "\tN            read next article.\n",
  "\t^U or ^B     previous page article.\n",
  "\t^D, ^F or ^V next page article.\n",
  "\t<            top article.\n",
  "\t>            last article.\n",
  "\tD            mark for delete and move to previous.\n",
  "\td            mark for delete and move to next.\n",
  "\tU            clear delete mark and move to previous.\n",
  "\tu            clear delete mark and move to next.\n",
  "\ts            save article.\n",
  "\t             (Please input file name.If file exists, please select\n",
  "\t              Y:Append N:Abort or O:Overwrite.)\n",
  "\tc            mark all article for delete.\n",
  "\t             (Please make sure Y/N.)\n",
  "\tTAB          jump to specified article.\n",
  "\t             (Please input article number.)\n",
#ifdef	MAILSEND
  "\tm            mail.\n",
  "\tr            reply.\n",
  "\tR            reply with original article.\n",
  "\tf            forward.\n",
#endif	/* MAILSEND */
  "\tM            toggle multi mark and move to next.\n",
  "\tC            clear all mark and move to next.\n",
  "\t^            refile delete marked article.\n",
  "\t             (Please input folder name.)\n",
  "\tDEL or BS    remove delete marked article.\n",
  "\t             (Please make sure Y/N.)\n",
  "\tI            include new mail.\n",
  "\tL            include UCB-mail format article file.\n",
  "\t             (Please input file name.)\n",
  "\tl            toggle print read/delete article.\n",
  "\tt            toggle thread mode.\n",
#ifdef	REF_SORT
  "\tT            change sort rule.\n",
#endif	/* REF_SORT */
  "\to, q or return\n",
  "\t             exit from article select mode.\n",
#endif	/* !SMALL */
  NULL,
};

/*
 * UCB-mail ⡼ɽ
 */

int	ucbmail_init()
{
  return(ucbmail_mode);
}

/*
 * UCB-mail ˥塼
 */

int	ucbmail_menu()
{
  struct stat	stat_buff;
  int		status;

  select_name[0] = '\0';
  print_mode_line(japanese ? "Ǥ" : "Searching.");
  if ((!stat(ucbmail_mbox, &stat_buff)) && (stat_buff.st_mode & S_IFDIR)) {
    ucbmail_search_folder();
    while (1) {
      if (auto_inc_mode && auto_inc_folder[0] && check_new_mail()) {
	strcpy(jump_name, auto_inc_folder);
      }
      status = ucbmail_select_folder();
      if (!jump_name[0]) {
	break;
      }
    }
    return(status);
  } else {
    ucbmail_folder_number = 0;
    strcpy(ucbmail_file, ucbmail_mbox);
    return(ucbmail_select_article(auto_inc_mode));
  }
}

/*
 * ե̺
 */

static void	ucbmail_redraw_folder(current_folder)
     int	current_folder;
{
  register int	i, j;
  char		buff[SMALL_BUFF];
  char		jname[SMALL_BUFF];

  i = top_position;
  top_position = get_top_position(top_position, current_folder,
				  ucbmail_folder_number, mail_thread_mode,
				  buff);
  if (i == top_position) {
    return;
  }
  print_title();
  if (wide_mode) {
    term_attrib(color_code[HEADER_COLOR]);
  } else {
    term_attrib(color_code[CATEGORY_COLOR]);
  }
  strcpy(jname, select_name);
#ifdef	JNAMES
  get_jname(UCBMAIL_JN_DOMAIN, jname, 40);
#endif	/* JNAMES */
  print_full_line(japanese ?
		  "ե:%-48.48s       :%s" :
		  "Folder:%-48.48s     Position:%s",
		  jname, buff);
  if (!wide_mode) {
    term_locate(0, 2);
    term_attrib(RESET_ATTRIB);
    term_attrib(color_code[HEADER_COLOR]);
    print_full_line(japanese ?
		    "      ̤    ե̾                       [%-8.8s]" :
		    "  Max     Unread  Folder name                      [%-8.8s]",
		    newmail_string[check_new_mail()]);
  }
  term_attrib(RESET_ATTRIB);
  for (i = 0, j = top_position; i < term_lines - mode_lines; i++, j++) {
    if (j >= ucbmail_folder_number) {
      break;
    }
    term_locate(0, head_lines + i);
#ifdef	COLOR
    term_attrib(color_code[NUMBER_COLOR]);
#endif	/* COLOR */
    cprintf(" %6d  %6d", ucbmail_folder[j].max_article,
	    ucbmail_folder[j].unread_article);
    strcpy(buff, ucbmail_folder[j].folder_name);
#ifdef	JNAMES
    get_jname(UCBMAIL_JN_DOMAIN, buff, term_columns - 24);
#else	/* !JNAMES */
    buff[term_columns - 24] = '\0';
#endif	/* !JNAMES */
#ifdef	COLOR
    term_attrib(color_code[CATEGORY_COLOR]);
#endif	/* COLOR */
    kanji_printf(EUC_CODE, "   %s", buff);
  }
  term_attrib(RESET_ATTRIB);
  print_mode_line(japanese ?
		  "?:إ j,n,^N: k,p,^P: SPACE,i: o,q,RETURN: Q:λ" :
		  "?:Help j,n,^N:next k,p,^P:previous SPACE,i:select o,q,RETURN:return Q:exit");
}

/*
 * ե
 */

static int	ucbmail_select_folder()
{
  int		current_folder;		/* Υեֹ		*/
  char		buff1[BUFF_SIZE];
  int		loop;
  int		status;
  int		key;
  register int	i;

  top_position = -1;
  current_folder = 0;

  loop = 1;
  while (loop) {
    if (jump_name[0]) {
      key = 0;
      current_folder = -1;
      for (i = 0; i < ucbmail_folder_number; i++) {
	if (!strcmp(ucbmail_folder[i].folder_name, jump_name)) {
	  current_folder = i;
	  key = ' ';
	  break;
	}
	if (!strncmp(ucbmail_folder[i].folder_name, jump_name,
		     strlen(jump_name))) {
	  if (current_folder < 0) {
	    current_folder = i;
	    key = ' ';
	  } else {
	    key = 0;
	  }
	}
      }
      if (current_folder < 0) {
	current_folder = 0;
      }
      jump_name[0] = '\0';
      if (!key) {
	continue;
      }
    } else {
      ucbmail_redraw_folder(current_folder);
      term_locate(16, head_lines + current_folder - top_position);
      key = get_key(GLOBAL_MODE_MASK | GROUP_MODE_MASK);
    }
    switch (key) {
    case 0x0c:		/* ^L 		*/
      term_init(2);
      top_position = -1;
      break;
    case 0x0e:		/* ^N եư	*/
    case 'j':
    case 'n':
      current_folder = ucbmail_next_folder(current_folder);
      break;
    case 0x10:		/* ^P եư	*/
    case 'k':
    case 'p':
      current_folder = ucbmail_prev_folder(current_folder);
      break;
    case 'o':
    case 'q':
    case '\015':	/* RETURN		*/
    case '\n':
      loop = 0;
      break;
    case 0x02:		/* ^B			*/
    case 0x15:		/* ^U ڡ		*/
      if ((current_folder -= (term_lines - mode_lines)) < 0) {
	current_folder = 0;
      }
      break;
    case 0x04:		/* ^D			*/
    case 0x06:		/* ^F			*/
    case 0x16:		/* ^V ڡ		*/
      if ((current_folder += (term_lines - mode_lines)) >=
	  ucbmail_folder_number) {
	if (ucbmail_folder_number > 0) {
	  current_folder = ucbmail_folder_number - 1;
	} else {
	  current_folder = 0;
	}
      }
      break;
    case '<':		/* ǽΥե	*/
      current_folder = 0;
      break;
    case '>':		/* ǸΥե	*/
      if (ucbmail_folder_number > 0) {
	current_folder = ucbmail_folder_number - 1;
      } else {
	current_folder = 0;
      }
      break;
    case '\t':		/* TAB եإ	*/
      strcpy(buff1, ucbmail_mbox);
      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
		 "ե̾ϤƲ:",
		 "Input folder name:", buff1);
      if (buff1[0]) {
	strcpy(jump_name, buff1);
      }
      top_position = -1;
      break;
    case '?':		/* إ		*/
      help(ucbmail_folder_jmessage, ucbmail_folder_message,
	   GLOBAL_MODE_MASK | GROUP_MODE_MASK);
      top_position = -1;
      break;
    case 'Q':		/* λ			*/
      return(1);
      /* break; */
    case 'C':		/* ե		*/
      strcpy(buff1, ucbmail_mbox);
      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
		 "ե̾ϤƲ:",
		 "Input new folder name:", buff1);
      if (buff1[0]) {
	if (!ucbmail_create_folder(buff1)) {
	  if (ucbmail_folder_number > 0) {
	    strcpy(buff1, ucbmail_folder[current_folder].folder_name);
	    ucbmail_search_folder();
	    current_folder = ucbmail_adjust_folder(buff1);
	  } else {
	    ucbmail_search_folder();
	    current_folder = 0;
	  }
	}
      }
      top_position = -1;
      break;
    default:
      if (ucbmail_folder_number > 0) {
	switch (key) {
	case ' ':
	case 'i':		/* ե		*/
	  strcpy(buff1, select_name);
	  strcpy(select_name, ucbmail_folder[current_folder].folder_name);
	  sprintf(ucbmail_file, "%s%c%s", ucbmail_mbox, SLASH_CHAR,
		  ucbmail_folder[current_folder].folder_name);
	  status = ucbmail_select_article(auto_inc_mode &&
					  ((!auto_inc_folder[0]) ||
					   (!strcmp(auto_inc_folder,
			    ucbmail_folder[current_folder].folder_name))));
	  strcpy(select_name, buff1);
	  strcpy(buff1, ucbmail_folder[current_folder].folder_name);
	  current_folder = 0;
	  for (i = 0; i < ucbmail_folder_number; i++) {
	    if (!strncmp(ucbmail_folder[i].folder_name, buff1,
			 strlen(buff1))) {
	      current_folder = i;
	      break;
	    }
	  }
	  ucbmail_count(current_folder);
	  if (status) {
	    return(1);
	  }
	  top_position = -1;
	  break;
#ifndef	SMALL
	case '/':		/* 		*/
	  ucbmail_search_name(0, ucbmail_folder_number, &current_folder);
	  break;
	case '\\':		/* 		*/
	  ucbmail_search_name(1, ucbmail_folder_number, &current_folder);
	  break;
#endif	/* !SMALL */
	case 0x7f:		/* ե		*/
	case 0x08:
	  if (ucbmail_folder[current_folder].max_article) {
	    print_mode_line(japanese ?
			    "ե(%s)϶ǤϤޤ" :
			    "Folder(%s) does not empty.",
			    ucbmail_folder[current_folder].folder_name);
	    term_bell();
	    sleep(ERROR_SLEEP);
	  } else {
	    if (yes_or_no(CARE_YN_MODE, "ե(%s)ޤ?",
			  "Delete folder(%s)?",
			  ucbmail_folder[current_folder].folder_name)) {
	      if (!ucbmail_delete_folder(ucbmail_folder[current_folder].folder_name)) {
		strcpy(buff1, ucbmail_folder[current_folder].folder_name);
		ucbmail_search_folder();
		current_folder = ucbmail_adjust_folder(buff1);
	      }
	    }
	  }
	  top_position = -1;
	  break;
	default:
	  break;
	}
      }
      break;
    }
  }
  return(0);
}

/*
 * ̺
 */

static void	ucbmail_redraw_article(current_article)
     int	current_article;
{
  register int	i;
  char		buff[SMALL_BUFF];
  char		jname[SMALL_BUFF];

  i = top_position;
  top_position = get_top_position(top_position, current_article,
				  ucbmail_article_number, mail_thread_mode,
				  buff);
  if (i == top_position) {
    return;
  }
  print_title();
  if (wide_mode) {
    term_attrib(color_code[HEADER_COLOR]);
  } else {
    term_attrib(color_code[CATEGORY_COLOR]);
  }
  if ((int)strlen(ucbmail_file) > (int)strlen(ucbmail_mbox)) {
    strcpy(jname, &ucbmail_file[strlen(ucbmail_mbox) + 1]);
  } else {
    strcpy(jname, ucbmail_file);
  }
#ifdef	JNAMES
  get_jname(UCBMAIL_JN_DOMAIN, jname, 42);
#endif	/* JNAMES */
  print_full_line(japanese ?
		  "᡼ܥå:%-42.42s       :%s" :
		  "Mail box:%-42.42s         Position:%s",
		  jname, buff);
  print_articles(top_position, ucbmail_article_number, NULL, "PANIC");
  print_mode_line(japanese ?
		  "?:إ j,^N: k,^P: SPACE,i,.: o,q: Q:λ" :
		  "?:Help j,^N:next k,^P:previous SPACE,i,.:read o,q:return Q:exit");
}

/*
 * 
 */

static int	ucbmail_select_article(auto_flag)
     int	auto_flag;
{
  register int	current_folder;		/* Υեֹ		*/
  int		current_article;	/* εֹ		*/
  char		buff[BUFF_SIZE];
  char		refile_folder[BUFF_SIZE];
  int		loop;
  int		status;
  int		key;
  register int	i, j;

  current_folder = -1;
  jump_name[0] = '\0';
  for (i = 0; i < ucbmail_folder_number; i++) {
    if (!strcmp(select_name, ucbmail_folder[i].folder_name)) {
      current_folder = i;
      break;
    }
  }
  if ((current_folder < 0) && ucbmail_folder_number) {
    print_fatal("Unexpected folder selected.");
    return(0);
  }
  print_mode_line(japanese ? "Ǥ" : "Searching.");
  if (auto_flag) {	/* ưǽ		*/
    if (check_new_mail()) {
      sprintf(buff, "%s%c%s", mail_spool, SLASH_CHAR, user_name);
      ucbmail_include(buff, 1);
    }
  }
  if (ucbmail_get_list() < 0) {
    return(0);
  }

  /*
   * ǽ̤ɵޤǥȤʤ
   */

  current_article = 0;
  if (ucbmail_article_number > 0) {
    while (1) {
      if (current_article >= ucbmail_article_number - 1) {
	break;
      } else if (article_list[current_article].mark & READ_MARK) {
	current_article = ucbmail_next_unread_article(current_article);
	continue;
      } else {
	break;
      }
    }
  }
  top_position = -1;
  loop = 1;
  status = 0;
  while (loop) {
    ucbmail_redraw_article(current_article);
    term_locate(11, head_lines + current_article - top_position);
    key = get_key(GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
    switch (key) {
    case 0x0c:		/* ^L 		*/
      term_init(2);
      top_position = -1;
      break;
    case 0x0e:		/* ^N ư	*/
    case 'j':
      current_article = ucbmail_next_article(current_article);
      break;
    case 0x10:		/* ^P ư	*/
    case 'k':
      current_article = ucbmail_prev_article(current_article);
      break;
    case '\015':	/* RETURN		*/
    case '\n':
    case 'o':
    case 'q':
      loop = 0;
      break;
    case 0x02:		/* ^B 			*/
    case 0x15:		/* ^U ڡ		*/
      if ((current_article -= (term_lines - mode_lines)) < 0) {
	current_article = 0;
      }
      break;
    case 0x04:		/* ^D			*/
    case 0x06:		/* ^F			*/
    case 0x16:		/* ^V ڡ		*/
      if ((current_article += (term_lines - mode_lines)) >= ucbmail_article_number) {
	if (ucbmail_article_number > 0) {
	  current_article = ucbmail_article_number - 1;
	} else {
	  current_article = 0;
	}
      }
      break;
    case '<':		/* ǽε		*/
      current_article = 0;
      break;
    case '>':		/* Ǹε		*/
      if (ucbmail_article_number > 0) {
	current_article = ucbmail_article_number - 1;
      } else {
	current_article = 0;
      }
      break;
#ifndef	SMALL
    case 'L':		/* ե	*/
      buff[0] = '\0';
      input_line(INPUT_EXPAND_MASK | INPUT_COMP_MASK,
		 "ե̾ϤƲ:",
		 "Input file name:", buff);
      if (!buff[0]) {
	top_position = -1;
	break;
      }
      /* break 	*/
#endif	/* !SMALL */
    case 'I':		/* 嵭	*/
      ucbmail_update(0, NULL);
      if (key == 'I') {
	if (auto_inc_mode && auto_inc_folder[0]) {
	  if (check_new_mail()) {
	    strcpy(jump_name, auto_inc_folder);
	    return(1);
	  }
	  break;
	}
	sprintf(buff, "%s%c%s", mail_spool, SLASH_CHAR, user_name);
	ucbmail_include(buff, 1);
      } else {
	ucbmail_include(buff, 0);
      }
      i = ucbmail_article_number;
      ucbmail_get_list();
      current_article = i;
      if (current_article >= ucbmail_article_number) {
	if (ucbmail_article_number > 0) {
	  current_article = ucbmail_article_number - 1;
	} else {
	  current_article = 0;
	}
      }
      top_position = -1;
      break;
    case '?':		/* إ		*/
      help(ucbmail_article_jmessage, ucbmail_article_message,
	   GLOBAL_MODE_MASK | SUBJECT_MODE_MASK);
      top_position = -1;
      break;
    case 'Q':		/* λ			*/
      loop = 0;
      status = 1;
      break;
    case 'l':		/* ɵѥå/	*/
    case 't':		/* åɥ	*/
    case 'T':		/* åɥ롼	*/
      ucbmail_update(0, NULL);
      if (!change_sort_rule(-1, &ucbmail_article_number,
			    &current_article,
			    &mail_article_mask, &mail_thread_mode,
			    ucbmail_get_list, key)) {
	top_position = -1;
      }
      break;
    default:
      last_key = key;
      while (last_key) {
	key = last_key;
	last_key = 0;
	switch (key) {
	case 'p':		/* ̤ɵ	*/
	case 'P':		/* ε		*/
	  j = current_article;
	  if (ucbmail_article_number > 0) {
	    if (key == 'p') {
	      current_article = ucbmail_prev_unread_article(current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      current_article = ucbmail_prev_article(current_article);
	      status = (current_article == j);
	    }
	  } else {
	    status = 1;
	  }
	  if (status && ucbmail_folder_number) {
	    i = current_folder;
	    while (1) {
	      if (--i < 0) {
		i = current_folder;
		break;
	      }
	      if (ucbmail_folder[i].unread_article > 0) {
		break;
	      }
	    }
	    if (i != current_folder) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"̤ɥե(%s)򻲾Ȥޤ?",
				"Read previous unread folder(%s)?",
				ucbmail_folder[i].folder_name)) {
	      case 1:
		ucbmail_update(0, NULL);
		strcpy(jump_name, ucbmail_folder[i].folder_name);
		return(1);
		/* break; */
	      case 2:
		ucbmail_update(0, NULL);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
	case 'n':		/* ̤ɵ	*/
	case 'N':		/* ε		*/
	  j = current_article;
	  if (ucbmail_article_number > 0) {
	    if (key == 'n') {
	      current_article = ucbmail_next_unread_article(current_article);
	      status = article_list[current_article].mark & READ_MARK;
	    } else {
	      current_article = ucbmail_next_article(current_article);
	      status = (current_article == j);
	    }
	  } else {
	    status = 1;
	  }
	  if (status && ucbmail_folder_number) {
	    i = current_folder;
	    while (1) {
	      if (++i >= ucbmail_folder_number) {
		i = current_folder;
		break;
	      }
	      if (ucbmail_folder[i].unread_article > 0) {
		break;
	      }
	    }
	    if (i != current_folder) {
	      switch (yes_or_no(JUMP_YN_MODE,
				"̤ɥե(%s)򻲾Ȥޤ?",
				"Read next unread folder(%s)?",
				ucbmail_folder[i].folder_name)) {
	      case 1:
		ucbmail_update(0, NULL);
		strcpy(jump_name, ucbmail_folder[i].folder_name);
		return(1);
		/* break; */
	      case 2:
		ucbmail_update(0, NULL);
		return(0);
		/* break; */
	      default:
		current_article = j;
		break;
	      }
	      top_position = -1;
	    } else {
	      current_article = j;
	    }
	    key = 0;
	  }
	  status = 0;
	  break;
	default:
	  break;
	}
	if (ucbmail_article_number > 0) {
	  i = 1;
	  switch (key) {
	  case 'V':		/* 		*/
	    i = 3;
	    /* break  */
	  case 'v':
	    i--;
	    key = ' ';
	    /* break  */
	  case ' ':
	  case 'p':
	  case 'n':
	  case 'P':
	  case 'N':
	  case 'i':
	  case '.':
	    if (!ucbmail_read(article_list[current_article].real_number, i)) {
	      ucbmail_mark(current_article, READ_MARK);
	      if ((last_key == 'D') || (last_key == 'd')) {
		ucbmail_mark(current_article, DELETE_MARK);
		if (last_key == 'D') {
		  last_key = 'p';
		} else {
		  last_key = 'n';
		}
	      } else if ((last_key == 'U') || (last_key == 'u')) {
		ucbmail_unmark(current_article, DELETE_MARK);
		if (last_key == 'U') {
		  last_key = 'p';
		} else {
		  last_key = 'n';
		}
	      }
	    }
	    if (pager_mode) {
	      switch (key) {
	      case 'p':
		current_article = ucbmail_prev_unread_article(current_article);
		break;
	      case 'n':
	      case ' ':
		current_article = ucbmail_next_unread_article(current_article);
		break;
	      case 'P':
		current_article = ucbmail_prev_article(current_article);
		break;
	      case 'N':
		current_article = ucbmail_next_article(current_article);
		break;
	      default:
		break;
	      }
	    }
	    if (last_key == ' ') {
	      last_key = 'n';
	    }
	    top_position = -1;
	    break;
	  case 'D':		/* ޡư	*/
	  case 'd':		/* ޡư	*/
	    ucbmail_mark(current_article, DELETE_MARK);
	    toggle_mark(top_position, current_article, 0);
	    if (key == 'D') {
	      current_article = ucbmail_prev_article(current_article);
	    } else {
	      current_article = ucbmail_next_article(current_article);
	    }
	    break;
	  case 'U':		/* ޡư	*/
	  case 'u':		/* ޡư	*/
	    ucbmail_unmark(current_article, DELETE_MARK);
	    toggle_mark(top_position, current_article, 0);
	    if (key == 'U') {
	      current_article = ucbmail_prev_article(current_article);
	    } else {
	      current_article = ucbmail_next_article(current_article);
	    }
	    break;
	  case 'c':		/* ޡ		*/
	    if (yes_or_no(NORMAL_YN_MODE,
			  "ƥޡƤǤ?",
			  "Mark all articles.Are you sure?")) {
	      for (i = 0; i < ucbmail_article_number; i++) {
		ucbmail_mark(i, DELETE_MARK);
	      }
	    }
	    top_position = -1;
	    status = 0;
	    break;
	  case '^':		/* ޡե	*/
	    j = 0;
	    for (i = 0; i < ucbmail_article_number; i++) {
	      if (article_list[i].mark & DELETE_MARK) {
		j++;
	      }
	    }
	    if (j) {
	      strcpy(buff, ucbmail_mbox);
	      input_line(INPUT_SPCCUT_MASK | INPUT_FOLDER_MASK,
			 "ưե̾ϤƲ:",
			 "Input destination folder name:", buff);
	      if (buff[0]) {
		j = 0;
		for (i = 0; i < ucbmail_folder_number; i++) {
		  if (!strcmp(ucbmail_folder[i].folder_name, buff)) {
		    status = i;
		    j = 1;
		    break;
		  }
		}
		if (!j)  {
		  if (yes_or_no(NORMAL_YN_MODE,
				"ե(%s)򿷵ޤ?",
				"Create folder(%s).Are you sure?",
				buff)) {
		    if (!ucbmail_create_folder(buff)) {
		      j = 1;
		    }
		  }
		}
		if (j) {
		  sprintf(refile_folder, "%s%c%s", ucbmail_mbox, SLASH_CHAR,
			  buff);
		  if (!strcmp(refile_folder, ucbmail_file)) {
		    print_mode_line(japanese ?
				    "ưȰư褬ƱեǤ" :
				    "Source and destination folders are identical.");
		    term_bell();
		    sleep(ERROR_SLEEP);
		  } else {
		    ucbmail_update(0, NULL);
		    ucbmail_update(1, refile_folder);
		    ucbmail_search_folder();
		    ucbmail_get_list();
		    if (current_article >= ucbmail_article_number) {
		      if (ucbmail_article_number > 0) {
			current_article = ucbmail_article_number - 1;
		      } else {
			current_article = 0;
		      }
		    }
		  }
		}
	      }
	      status = 0;
	      top_position = -1;
	    }
	    break;
	  case 0x7f:		/* ޡ	*/
	  case 0x08:
	    j = 0;
	    for (i = 0; i < ucbmail_article_number; i++) {
	      if (article_list[i].mark & DELETE_MARK) {
		j++;
	      }
	    }
	    if (j) {
	      if (yes_or_no(CARE_YN_MODE,
			    "ޡ줿ƺƤǤ?",
			    "Delete all marked articles.Are you sure?")) {
		ucbmail_update(1, NULL);
		ucbmail_get_list();
		if (current_article >= ucbmail_article_number) {
		  if (ucbmail_article_number > 0) {
		    current_article = ucbmail_article_number - 1;
		  } else {
		    current_article = 0;
		  }
		}
	      }
	      status = 0;
	    }
	    top_position = -1;
	    break;
	  case 's':		/* 		*/
	    if (!multi_save(current_article, ucbmail_extract)) {
	      multi_add_mark(ucbmail_article_number, -1, current_article,
			     READ_MARK, ucbmail_mark);
	    }
	    top_position = -1;
	    break;
#ifndef	SMALL
	  case '/':		/* 		*/
	    search_subjects(0, ucbmail_article_number, &current_article, NULL);
	    break;
	  case '\\':		/* 		*/
	    search_subjects(1, ucbmail_article_number, &current_article, NULL);
	    break;
	  case '|':		/* ѥ׼¹		*/
	    if (!multi_pipe(current_article, ucbmail_extract)) {
	      multi_add_mark(ucbmail_article_number, -1, current_article,
			     READ_MARK, ucbmail_mark);
	    }
	    top_position = -1;
	    break;
#endif	/* !SMALL */
	  case '\t':		/* TAB 국إ	*/
	    buff[0] = '\0';
	    input_line(INPUT_SPCCUT_MASK, "ֹϤƲ:",
		       "Input article number:", buff);
	    j = atoi(buff);
	    if ((j > 0) && buff[0]) {
	      for (i = 0; i < ucbmail_article_number; i++) {
		if (article_list[i].real_number == j) {
		  current_article = i;
		  break;
		}
	      }
	    }
	    top_position = -1;
	    break;
#ifdef	MAILSEND
	  case 'r':		/* ᡼ֿ		*/
	    create_temp_name(buff, "UR");
	    if (!ucbmail_extract(article_list[current_article].real_number,
				 buff)) {
	      mail_reply(buff, 0, select_name);
	      funlink2(buff);
	    }
	    top_position = -1;
	    break;
	  case 'R':		/* ᡼ֿ		*/
	    create_temp_name(buff, "UR");
	    if (!multi_extract(current_article, buff, ucbmail_extract)) {
	      if (!mail_reply(buff, REPLY_QUOTE_MASK, select_name)) {
		multi_add_mark(ucbmail_article_number, -1, current_article,
			       READ_MARK, ucbmail_mark);
	      }
	      funlink2(buff);
	    }
	    top_position = -1;
	    break;
	  case 'f':		/* ᡼ž		*/
	    create_temp_name(buff, "UT");
	    if (!ucbmail_extract(article_list[current_article].real_number,
				 buff)) {
	      mail_forward(buff, select_name);
	      funlink2(buff);
	    }
	    top_position = -1;
	    break;
#endif	/* MAILSEND */
	  case 'C':		/* ޡ		*/
	    ucbmail_unmark(current_article, READ_MARK | FORWARD_MARK
			   | ANSWER_MARK | DELETE_MARK);
	    if (article_list[current_article].mark & MULTI_MARK) {
	      multi_mark(top_position, current_article);
	    }
	    toggle_mark(top_position, current_article, 0);
	    current_article = ucbmail_next_article(current_article);
	    break;
	  case 'M':		/* ޥޡ/	*/
	    multi_mark(top_position, current_article);
	    current_article = ucbmail_next_article(current_article);
	    break;
	  default:
	    break;
	  }
	}
	switch (last_key) {
	case 'f':
	  print_title();
	case ' ':
	case 'p':
	case 'n':
	case 'P':
	case 'N':
	case 'v':
	case 'V':
	case 'r':
	case 'R':
	  break;
	default:
	  last_key = 0;
	}
      }
      break;
    }
  }
  ucbmail_update(0, NULL);
  return(status);
}

/*
 * Υեֹ
 */

static int	ucbmail_prev_folder(current_folder)
     int	current_folder;
{
  if (--current_folder < 0) {
    current_folder = 0;
  }
  return(current_folder);
}

/*
 * Υեֹ
 */

static int	ucbmail_next_folder(current_folder)
     int	current_folder;
{
  if (++current_folder >= ucbmail_folder_number) {
    if (ucbmail_folder_number > 0) {
      current_folder = ucbmail_folder_number - 1;
    } else {
      current_folder = 0;
    }
  }
  return(current_folder);
}

/*
 * ̤ɵֹ
 */

static int	ucbmail_prev_unread_article(current_article)
     int	current_article;
{
  while (current_article > 0) {
    if (!(article_list[--current_article].mark & READ_MARK)) {
      break;
    }
  }
  return(current_article);
}

/*
 * ̤ɵֹ
 */

static int	ucbmail_next_unread_article(current_article)
     int	current_article;
{
  while (current_article < (ucbmail_article_number - 1)) {
    if (!(article_list[++current_article].mark & READ_MARK)) {
      break;
    }
  }
  return(current_article);
}

/*
 * εֹ
 */

static int	ucbmail_prev_article(current_article)
     int	current_article;
{
  if (--current_article < 0) {
    current_article = 0;
  }
  return(current_article);
}

/*
 * Υե
 */

static int	ucbmail_next_article(current_article)
     int	current_article;
{
  if (++current_article >= ucbmail_article_number) {
    if (ucbmail_article_number > 0) {
      current_article = ucbmail_article_number - 1;
    } else {
      current_article = 0;
    }
  }
  return(current_article);
}

/*
 * ե
 */

static void	ucbmail_search_folder()
{
  struct ucbmail_folder	*ucbmail_alloc_ptr;
  char			buff1[BUFF_SIZE];
  char			buff2[BUFF_SIZE];
  char			buff3[BUFF_SIZE];
#ifdef	HAVE_FILES
  FILES_STRUCT		dp;
#else	/* !HAVE_FILES */
  DIR_PTR		*dp;
  DIR			*dir_ptr;
  struct stat		stat_buff;
#endif	/* !HAVE_FILES */
  FILE			*fp;
  int			status;

  ucbmail_folder_number = ucbmail_alloc_number = 0;
  if (ucbmail_folder) {
    free(ucbmail_folder);
    ucbmail_folder = NULL;
  }
#ifdef	HAVE_FILES
  sprintf(buff1, "%s%c*.*", ucbmail_mbox, SLASH_CHAR);
  if (!dos_files(buff1, &dp, FILE_ATTR)) {
    do {
#ifdef	__TURBOC__
      strcpy(buff1, dp.ff_name);
#else	/* !__TURBOC__ */
      strcpy(buff1, dp.name);
#endif	/* !__TURBOC__ */
      sprintf(buff2, "%s%c%s", ucbmail_mbox, SLASH_CHAR, buff1);
      if (buff1[strlen(buff1) - 1] != '~') {
        {
	  if (fp = fopen(buff2, "r")) {
	    status = 0;
#ifdef	__TURBOC__
	    if (!dp.ff_fsize) {
#else	/* !__TURBOC__ */
	    if (!dp.filelen) {
#endif	/* !__TURBOC__ */
	      status = 1;
#else	/* !HAVE_FILES */
  if (dir_ptr = opendir(ucbmail_mbox)) {
    while (dp = readdir(dir_ptr)) {
      strcpy(buff1, dp->d_name);
      sprintf(buff2, "%s%c%s", ucbmail_mbox, SLASH_CHAR, buff1);
      if ((!stat(buff2, &stat_buff))
	  && (*(buff1 + strlen(dp->d_name) - 1) != '~')) {
	if ((stat_buff.st_mode & S_IFMT) == S_IFREG) {
	  if (fp = fopen(buff2, "r")) {
	    status = 0;
	    if (!stat_buff.st_size) {
	      status = 1;
#endif	/* !HAVE_FILES */
	    } else if (fgets(buff3, sizeof(buff3), fp)) {
	      if (!strncmp(buff3, UCBMAIL_SEPARATER,
			   sizeof(UCBMAIL_SEPARATER) - 1)) {
		status = 1;
	      } else if (!strcmp(buff3, "\n")) {
		if (fgets(buff3, sizeof(buff3), fp) && 
		    (!strncmp(buff3, UCBMAIL_SEPARATER,
			      sizeof(UCBMAIL_SEPARATER) - 1))) {
		  status = 1;
		}
	      }
	    }
	    if (status) {
	      if (ucbmail_alloc_number <= ucbmail_folder_number) {
		if (ucbmail_folder) {
		  ucbmail_alloc_ptr = (struct ucbmail_folder*)
		    realloc(ucbmail_folder,
			    (ucbmail_alloc_number + UCBMAIL_ALLOC_COUNT)
			    * sizeof(struct ucbmail_folder));
		} else {
		  ucbmail_alloc_ptr = (struct ucbmail_folder*)
		    malloc((ucbmail_alloc_number + UCBMAIL_ALLOC_COUNT)
			   * sizeof(struct ucbmail_folder));
		}
		if (!ucbmail_alloc_ptr) {
		  print_fatal("Can't allocate memory for UCB-mail folder.");
		  fclose(fp);
		  break;
		} else {
		  ucbmail_folder = ucbmail_alloc_ptr;
		  ucbmail_alloc_number += UCBMAIL_ALLOC_COUNT;
		}
	      }
	      strcpy(ucbmail_folder[ucbmail_folder_number].folder_name,
		     buff1);
	      ucbmail_folder_number++;
	      ucbmail_count(ucbmail_folder_number - 1);
	    }
	    fclose(fp);
	  }
	}
      }
#ifdef	HAVE_FILES
    } while (!dos_nfiles(&dp));
#else	/* !HAVE_FILES */
    }
    closedir(dir_ptr);
#endif	/* !HAVE_FILES */
  }
  if (ucbmail_folder_number > 0) {
    qsort(ucbmail_folder, ucbmail_folder_number, sizeof(struct ucbmail_folder),
	  (int (*)())strcmp);
  }
}

/*
 * 
 */

static void	ucbmail_count(folder_number)
     int	folder_number;
{
  FILE		*fp;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  int		max_number;
  int		unread_number;

  if ((folder_number < 0) || (folder_number >= ucbmail_folder_number)) {
    print_fatal("Illegal UCB-mail folder number.");
    return;
  }
  max_number = unread_number = 0;
  sprintf(buff1, "%s%c%s", ucbmail_mbox, SLASH_CHAR,
	  ucbmail_folder[folder_number].folder_name);
  if (fp = fopen(buff1, "r")) {
    if (fgets(buff1, sizeof(buff1), fp)) {
      while (1) {
	if (strncmp(buff1, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
	  if (strcmp(buff1, "\n")) {
	    break;
	  }
	  if ((!fgets(buff1, sizeof(buff1), fp)) ||
	      strncmp(buff1, UCBMAIL_SEPARATER,
		      sizeof(UCBMAIL_SEPARATER) - 1)) {
	    break;
	  }
	}
	max_number++;
	buff2[0] = '\0';
	while (fgets(buff1, sizeof(buff1), fp)) {
	  if ((!buff1[0]) || (buff1[0] == '\n')) {
	    break;
	  } else {
	    copy_field(buff1, buff2, UCBMAIL_STATUS_FIELD);
	  }
	}
	if (!strindex(buff2, UCBMAIL_READ_STATUS)) {
	  unread_number++;
	}
	while (fgets(buff1, sizeof(buff1), fp)) {
	  if (!strncmp(buff1, UCBMAIL_SEPARATER,
		       sizeof(UCBMAIL_SEPARATER) - 1)) {
	    break;
	  }
	}
      }
    }
    fclose(fp);
  }
  ucbmail_folder[folder_number].max_article = max_number;
  ucbmail_folder[folder_number].unread_article = unread_number;
}

/*
 * 
 */

static int	ucbmail_read(real_number, mode)
     int	real_number;
     int	mode;
{
  char	tmp_file1[PATH_BUFF];
  char	tmp_file2[PATH_BUFF];
  char	buff[SMALL_BUFF];
  int	status;

  create_temp_name(tmp_file1, "UC");
  create_temp_name(tmp_file2, "UV");
  if (ucbmail_extract(real_number, tmp_file1)) {
    return(1);
  }
  sprintf(buff, "%d", real_number);
  status = exec_pager(tmp_file1, tmp_file2, mode, buff);
  funlink2(tmp_file1);
  if (status) {
    return(1);
  }
  return(0);
}

/*
 * 
 */

static int	ucbmail_extract(real_number, tmp_file)
     int	real_number;
     char	*tmp_file;
{
  FILE	*fp1, *fp2;
  char	buff[BUFF_SIZE];

  if (!(fp1 = fopen(ucbmail_file, "r"))) {
    return(1);
  }
  while (1) {
    if (!fgets(buff, sizeof(buff), fp1)) {
      fclose(fp1);
      return(1);
    }
    if (!strncmp(buff, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
      if (--real_number <= 0) {
	break;
      }
    }
  }
  if (!(fp2 = fopen2(tmp_file, "a"))) {
    fclose(fp1);
    return(1);
  }
  chmod(tmp_file, S_IREAD | S_IWRITE);
  while (1) {
    fputs(buff, fp2);
    if (!fgets(buff, sizeof(buff), fp1)) {
      break;
    }
    if (!strncmp(buff, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
      break;
    }
  }
  fclose(fp1);
  fclose(fp2);
  return(0);
}

/*
 * ޡɲ
 */

static void	ucbmail_mark(current_article, mark)
     int	current_article;
     int	mark;
{
  if (!(article_list[current_article].mark & mark)) {
    article_list[current_article].mark |= mark;
    if (mark & ~DELETE_MARK) {
      ucbmail_modify = 1;
    }
  }
}

/*
 * ޡ
 */

static void	ucbmail_unmark(current_article, mark)
     int	current_article;
     int	mark;
{
  if (article_list[current_article].mark & mark) {
    article_list[current_article].mark &= ~mark;
    if (mark & ~DELETE_MARK) {
      ucbmail_modify = 1;
    }
  }
}

/*
 * ꥹȼ
 */

static int	ucbmail_get_list()
{
  FILE			*fp;
  char			buff[BUFF_SIZE];
  static char		from_buff[BUFF_SIZE];
  static char		date_buff[MAX_FIELD_LEN];
  static char		subject_buff[BUFF_SIZE];
  static char		status_buff[MAX_FIELD_LEN];
  static char		x_nsubj_buff[MAX_FIELD_LEN];
#ifdef	REF_SORT
  static char		message_buff[MAX_FIELD_LEN];
  static char		reference_buff[BUFF_SIZE];
  static char		in_reply_buff[BUFF_SIZE];
#endif	/* REF_SORT */
  static struct cpy_hdr	ucbmail_fields[] = {
    {FROM_FIELD,		from_buff,	sizeof(from_buff)},
    {DATE_FIELD,		date_buff,	sizeof(date_buff)},
    {SUBJECT_FIELD,		subject_buff,	sizeof(subject_buff)},
    {UCBMAIL_STATUS_FIELD,	status_buff,	sizeof(status_buff)},
    {X_NSUBJ_FIELD,		x_nsubj_buff,	sizeof(x_nsubj_buff)},
#ifdef	REF_SORT
    {MESSAGE_FIELD,	message_buff,	sizeof(message_buff)},
    {REFERENCE_FIELD,	reference_buff,	sizeof(reference_buff)},
    {IN_REPLY_FIELD,	in_reply_buff,	sizeof(in_reply_buff)},
#endif	/* REF_SORT */
  };
  char			*alloc_ptr;
#ifdef	REF_SORT
  char			*ptr;
#else	/* !REF_SORT */
  short			year;
#endif	/* !REF_SORT */
  short			day, hour, minute, second;
  int			alloc_number;
  register int		lines;

  ucbmail_article_number = ucbmail_modify = multi_number = 0;
  if (article_list) {
    free(article_list);
  }
  article_list = NULL;
  alloc_number = 0;
  if (!(fp = fopen(ucbmail_file, "r"))) {
    return(1);
  }
  if ((!fgets(buff, sizeof(buff), fp)) ||
      strncmp(buff, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
    if (strcmp(buff, "\n")) {
      return(1);
    }
    if ((!fgets(buff, sizeof(buff), fp)) ||
	strncmp(buff, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
      return(1);
    }
  }
  while (!feof(fp)) {
    lines = copy_fields(fp, ucbmail_fields,
			 sizeof(ucbmail_fields)/sizeof(struct cpy_hdr),
			 CF_CLR_MASK | CF_GET_MASK | CF_SPC_MASK);
    while (fgets(buff, sizeof(buff), fp)) {
      if (!strncmp(buff, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
	break;
      }
      lines++;
    }
    if (alloc_number <= ucbmail_article_number) {
      if (article_list) {
	alloc_ptr = (char*)realloc(article_list,
				   sizeof(ARTICLE_LIST) *
				   (alloc_number + UCBMAIL_ALLOC_COUNT));
      } else {
	alloc_ptr = (char*)malloc(sizeof(ARTICLE_LIST) *
				  (alloc_number + UCBMAIL_ALLOC_COUNT));
      }
      if (!alloc_ptr) {
	print_fatal("Can't allocate memory for UCB-mail article struct.");
	break;
      }
      article_list = (ARTICLE_LIST*)alloc_ptr;
#ifdef	REF_SORT
      if (sort_rule == 1) {
	if (message_list) {
	  alloc_ptr = (char*)realloc(message_list,
				     sizeof(MESSAGE_LIST) *
				     (alloc_number + UCBMAIL_ALLOC_COUNT));
	} else {
	  alloc_ptr = (char*)malloc(sizeof(MESSAGE_LIST) *
				    (alloc_number + UCBMAIL_ALLOC_COUNT));
	}
	if (!alloc_ptr) {
	  print_fatal("Can't allocate memory for message struct.");
	  break;
	}
	message_list = (MESSAGE_LIST*)alloc_ptr;
      }
#endif	/* REF_SORT */
      alloc_number += UCBMAIL_ALLOC_COUNT;
    }
    article_list[ucbmail_article_number].real_number =
      ucbmail_article_number + 1;
    article_list[ucbmail_article_number].lines = lines;
    if (strindex(status_buff, UCBMAIL_READ_STATUS)) {
      article_list[ucbmail_article_number].mark = READ_MARK;
    } else {
      article_list[ucbmail_article_number].mark = 0;
    }
    get_real_adrs(from_buff, article_list[ucbmail_article_number].from);
    if (x_nsubj_mode && x_nsubj_buff[0]) {
      recover_jis(subject_buff, x_nsubj_buff);
    }
    mime_decode_func(from_buff, subject_buff, default_code);
    euc_tab_strncpy(article_list[ucbmail_article_number].subject, from_buff,
		    MAX_SUBJECT_LEN - 1);
#ifdef	REF_SORT
    convert_article_date(date_buff, &article_list[ucbmail_article_number].year,
			 &article_list[ucbmail_article_number].month,
			 &article_list[ucbmail_article_number].date,
			 &day, &hour, &minute, &second, from_buff);
    if (message_list) {
      strncpy(message_list[ucbmail_article_number].msg_id, message_buff,
	      MAX_FIELD_LEN - 1);
      message_list[ucbmail_article_number].msg_id[MAX_FIELD_LEN - 1] = '\0';
      if (ptr = strrchr(reference_buff, '<')) {
	strncpy(message_list[ucbmail_article_number].ref_id, ptr,
		MAX_FIELD_LEN - 1);
	message_list[ucbmail_article_number].ref_id[MAX_FIELD_LEN - 1] = '\0';
      } else if (ptr = strrchr(in_reply_buff, '<')) {
	strcpy(message_list[ucbmail_article_number].ref_id, ptr);
      } else {
	message_list[ucbmail_article_number].ref_id[0] = '\0';
      }
      if (ptr = strchr(message_list[ucbmail_article_number].ref_id, '>')) {
	*(ptr + 1) = '\0';
      }
    }
#else /* !REF_SORT */
    convert_article_date(date_buff, &year,
			 &article_list[ucbmail_article_number].month,
			 &article_list[ucbmail_article_number].date,
			 &day, &hour, &minute, &second, from_buff);
#endif /* !REF_SORT */
    ucbmail_article_number++;
  }
  fclose(fp);

  /*	Ƚ	*/

  if (sort_articles(-1, &ucbmail_article_number,
		    mail_thread_mode, 0,
		    NULL, NULL) < 0) {
    return(-1);
  }

  /*	ѥå	*/

#ifdef	notdef
  if (mail_article_mask) {
    pack_articles(-1, &ucbmail_article_number, NULL, NULL);
  }
#endif	/* notdef */
  return(0);
}

/*
 * 嵭
 */

static void	ucbmail_include(spool_file, rm_flag)
     char	*spool_file;
     int	rm_flag;
{
  FILE	*fp1, *fp2;
  int	status;
  int	first;
#ifdef	CONTENT_LENGTH
  int	length1, length2;
#endif	/* CONTENT_LENGTH */
  char	backup_file[PATH_BUFF];
  char	buff[BUFF_SIZE];

  /*	Хååץեإ͡	*/

  create_backup_name(backup_file, ucbmail_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  if (rename(ucbmail_file, backup_file) && (errno != ENOENT)) {
    print_fatal("Can't rename UCB-mail folder file.");
    return;
  }
  status = first = 0;
  if ((fp2 = fopen(ucbmail_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't save new UCB-mail folder file.");
    return;
  }
  chmod(ucbmail_file, S_IREAD | S_IWRITE);
  print_mode_line(japanese ? "᡼ܥå򹹿Ǥ" :
		  "Updating UCB-mail folder file.");
  if (fp1 = fopen(backup_file, "r")) {
    while (fgets(buff, sizeof(buff), fp1)) {
      first = 1;
      fputs(buff, fp2);
    }
    fclose(fp1);
  }
  if (fp1 = fopen(spool_file, "r")) {
#ifdef	CONTENT_LENGTH
    while (!feof(fp1)) {
      length1 = length2 = 0;
      while (fgets(buff, sizeof(buff), fp1)) {
	if (first && (buff[0] != '\n') && (buff[0] != '\0')) {
	  fputc('\n', fp2);
	}
	first = 0;
	fputs(buff, fp2);
	if (!strncasecmp(buff, LENGTH_FIELD, sizeof(LENGTH_FIELD) - 1)) {
	  length1 = atoi(&buff[sizeof(LENGTH_FIELD) - 1]);
	}
	if ((buff[0] == '\n') || (buff[0] == '\0')) {
	  break;
	}
      }
      while (fgets(buff, sizeof(buff), fp1)) {
	length2 += strlen(buff);
	if (!strncmp(buff, UCBMAIL_SEPARATER,
		     sizeof(UCBMAIL_SEPARATER) - 1)) {
	  if (length2 < length1) {
	    fputc('>', fp2);
	  } else {
	    fputs(buff, fp2);
	    break;
	  }
	}
	fputs(buff, fp2);
      }
    }
#else	/* !CONTENT_LENGTH */
    while (fgets(buff, sizeof(buff), fp1)) {
      if (first && (buff[0] != '\n') && (buff[0] != '\0')) {
	fputc('\n', fp2);
      }
      first = 0;
      fputs(buff, fp2);
    }
#endif	/* !CONTENT_LENGTH */
    fclose(fp1);
    status = 1;
  }
  if (fclose(fp2)) {
    print_fatal("Can't save new UCB-mail folder file.");
  } else if (status && rm_flag) {
#ifndef	DEBUG
#ifdef	notdef
    unlink(spool_file);
#else	/* !notdef */
    if (fp1 = fopen(spool_file, "w")) {
      fclose(fp1);
    } else {
      print_fatal("Can't truncate spool file.");
    }
#endif	/* !notdef */
#endif	/* !DEBUG */
  }
}

/*
 * MBOX ե빹(ޡ or ư)
 */

static void	ucbmail_update(mode, refile_folder)
     int	mode;		/* 0:ޡ 0ʳ: or ư */
     char	*refile_folder;	/* ưե */
{
  FILE		*fp1, *fp2, *fp3;
  int		article_number;
  char		backup_file[PATH_BUFF];
  char		buff[BUFF_SIZE];
  register int	i, j;

  /*	ɬå	*/

  if (!(mode || ucbmail_modify)) {
    return;
  }

  /*	Хååץեإ͡	*/

  create_backup_name(backup_file, ucbmail_file);
#ifdef	MSDOS
  unlink(backup_file);
#endif	/* MSDOS */
  if (rename(ucbmail_file, backup_file) && (errno != ENOENT)) {
    print_fatal("Can't rename UCB-mail folder file.");
    return;
  }
  if ((fp1 = fopen(backup_file, "r")) == (FILE*)NULL) {
    print_fatal("Can't read backup UCB-mail folder file.");
    rename(backup_file, ucbmail_file);
    return;
  }
  if ((!fgets(buff, sizeof(buff), fp1)) ||
      strncmp(buff, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
    if (strcmp(buff, "\n") ||
	(!fgets(buff, sizeof(buff), fp1)) ||
	strncmp(buff, UCBMAIL_SEPARATER, sizeof(UCBMAIL_SEPARATER) - 1)) {
      print_fatal("Unexpected UCB-mail folder file format.");
      fclose(fp1);
      rename(backup_file, ucbmail_file);
      return;
    }
  }
  if ((fp2 = fopen(ucbmail_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't save new UCB-mail folder file.");
    fclose(fp1);
    rename(backup_file, ucbmail_file);
    return;
  }
  chmod(ucbmail_file, S_IREAD | S_IWRITE);
  fp3 = NULL;
  if (refile_folder) {
    if ((fp3 = fopen(refile_folder, "a")) == (FILE*)NULL) {
      print_fatal("Can't append UCB-mail folder file.");
      fclose(fp1);
      fclose(fp2);
      rename(backup_file, ucbmail_file);
      return;
    }
    print_mode_line(japanese ? "եǤ" : "Refiling.");
  } else {
    if (mode) {
      print_mode_line(japanese ? "Ǥ" : "Removing.");
    } else {
      print_mode_line(japanese ? "Ǥ" : "Updating.");
    }
  }
  article_number = 0;
  while (!feof(fp1)) {
    for (i = 0; i < ucbmail_article_number; i++) {
      if (article_list[i].real_number == (article_number + 1)) {
	break;
      }
    }
    if (i < ucbmail_article_number) {
      if (mode && (article_list[i].mark & DELETE_MARK)) {
	if (fp3) {
	  fputs(buff, fp3);
	}
	while (fgets(buff, sizeof(buff), fp1)) {
	  if (!strncmp(buff, UCBMAIL_SEPARATER,
		       sizeof(UCBMAIL_SEPARATER) - 1)) {
	    break;
	  }
	  if (fp3) {
	    fputs(buff, fp3);
	  }
	}
	article_number++;
	continue;
      }
    }
    fputs(buff, fp2);
    j = 0;
    while (fgets(buff, sizeof(buff), fp1)) {
      if (!strncasecmp(buff, UCBMAIL_STATUS_FIELD,
		       sizeof(UCBMAIL_STATUS_FIELD) - 1)) {
	continue;
      }
      if ((buff[0] == '\n') || (buff[0] == '\0')) {
	if (i < ucbmail_article_number) {
	  if (article_list[i].mark & READ_MARK) {
	    fprintf(fp2, "%s %s\n\n", UCBMAIL_STATUS_FIELD,
		    UCBMAIL_READ_STATUS);
	  } else {
	    fprintf(fp2, "%s %s\n\n", UCBMAIL_STATUS_FIELD,
		    UCBMAIL_OLD_STATUS);
	  }
	} else {
	  fputc('\n', fp2);
	}
	while (fgets(buff, sizeof(buff), fp1)) {
	  if (!strncmp(buff, UCBMAIL_SEPARATER,
		       sizeof(UCBMAIL_SEPARATER) - 1)) {
	    break;
	  }
	  fputs(buff, fp2);
	}
	break;
      }
      fputs(buff, fp2);
    }
    article_number++;
  }
  fclose(fp1);
  fclose(fp2);
  if (fp3) {
    fclose(fp3);
  }
}

/*
 * ե
 */

static int	ucbmail_create_folder(folder_name)
     char	*folder_name;
{
  struct stat	stat_buff;
  FILE		*fp;
  char		buff[BUFF_SIZE];

  sprintf(buff, "%s%c%s", ucbmail_mbox, SLASH_CHAR, folder_name);
  if (stat(buff, &stat_buff)) {
    if (fp = fopen(buff, "a")) {
      chmod(buff, S_IREAD | S_IWRITE);
      fclose(fp);
      return(0);
    }
  }
  term_bell();
  print_mode_line(japanese ? "եǤޤǤ" :
		  "Can't create folder.");
  sleep(ERROR_SLEEP);
  return(1);
}

/*
 * ե
 */

static int	ucbmail_delete_folder(folder_name)
     char	*folder_name;
{
  struct stat	stat_buff;
  char		buff[BUFF_SIZE];

  sprintf(buff, "%s%c%s", ucbmail_mbox, SLASH_CHAR, folder_name);
  if (!stat(buff, &stat_buff)) {
    if (!stat_buff.st_size) {
      unlink(buff);
      return(0);
    }
  }
  term_bell();
  print_mode_line(japanese ? "եǤޤǤ" :
		  "Can't delete folder.");
  sleep(ERROR_SLEEP);
  return(1);
}

/*
 * ե
 */

static int	ucbmail_adjust_folder(folder_name)
     char	*folder_name;
{
  int	current_folder;
  int	i;

  current_folder = 0;
  for (i = 0; i < ucbmail_folder_number; i++) {
    if (strcmp(ucbmail_folder[i].folder_name, folder_name) > 0) {
      break;
    }
    current_folder = i;
  }
  return(current_folder);
}

#ifndef	SMALL
/*
 * ե̾(ʣ)
 */

static int	ucbmail_search_name(mode, max_folder, folder_ptr)
     int	mode;
     int	max_folder;
     int	*folder_ptr;
{
  register int	current_folder;
  char		*str;

  if (str = input_search_string(mode)) {
    if (mode) {
      for (current_folder = *folder_ptr - 1; current_folder >= 0;
	   current_folder--) {
	if (strindex(ucbmail_folder[current_folder].folder_name, str)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *folder_ptr = current_folder;
	  return(0);
	}
      }
    } else {
      for (current_folder = *folder_ptr + 1; current_folder < max_folder;
	   current_folder++) {
	if (strindex(ucbmail_folder[current_folder].folder_name, str)) {
	  print_mode_line(japanese ? "Ĥޤ" : "Search succeed.");
	  *folder_ptr = current_folder;
	  return(0);
	}
      }
    }
    print_mode_line(japanese ? "ĤޤǤ" : "Search failed.");
    return(1);
  }
  return(0);
}
#endif	/* !SMALL */
#endif	/* UCBMAIL */
