#
#	Mini News Reader Ver 1.19
#	Makefile for source release [for X680x0 GCC+libc only]
#

SHELL	= fish -f
ARCH	= MSDOS
CC	= gcc
LIBS	= -ldos
CC_FLAG	= -DX68K -DSTRNCASECMP -O
BIN_DIR	= /usr/local/bin
LIB_DIR	= /usr/local/lib
MAN_DIR	= /usr/man

CONNECT_OPT = -DNSPL
CONS_OPT  = -DMH -DMIME -DPAGER
#CONS_OPT  = -DNEWSPOST -DMAILSEND -DMH -DRMAIL -DUCBMAIL -DMIME -DFCC -DJNAMES -DPAGER
CONF_OPT  = -DCTRL_L -DCOMPLETION -DSJIS_SRC
CPP_FLAG1 = -DMNEWS -DJIS_INPUT $(CONF_OPT) -D$(ARCH)
CPP_FLAG2 = $(CONS_OPT) $(CPP_FLAG1)
C_FLAG1	= $(CPP_FLAG1) $(CC_FLAG)
C_FLAG2	= $(CPP_FLAG2) $(CC_FLAG)
RM	= rm
RM_FLAG	= -f
EXE	= mnews.x


#NEWSPOST_OBJ = newspost.o
#MAILSEND_OBJ = mailsend.o
#JNAMES_OBJ = jnames.o
#JNAMES_OBJ = jnhash.o
MH_OBJ = mh.o
#UCBMAIL_OBJ = ucbmail.o
#RMAIL_OBJ = rmail.o
PAGER_OBJ = pager.o
#BOARD_OBJ = board.o
#FCC_OBJ = fcc.o
MIME_OBJ = mime.o

BASE_OBJ   = mnews.o group.o article.o mark.o compat.o \
		nntplib.o kanjilib.o termdos.o
OPTION_OBJ = $(NEWSPOST_OBJ) $(MAILSEND_OBJ) $(JNAMES_OBJ) \
		$(MH_OBJ) $(UCBMAIL_OBJ) $(RMAIL_OBJ) $(BOARD_OBJ) \
		$(PAGER_OBJ) $(FCC_OBJ) $(MIME_OBJ)
OBJ     = mnews.o group.o article.o mark.o mh.o ucbmail.o rmail.o board.o \
		newspost.o mailsend.o pager.o fcc.o mime.o compat.o \
		nntplib.o kanjilib.o termdos.o \
		jnames.o
SRC     = mnews.c group.c article.c mark.c mh.c ucbmail.c rmail.c board.c \
		newspost.c mailsend.c pager.c fcc.c mime.c compat.c \
		nntplib.c kanjilib.c termlib.c termdos.c \
		inetbios.c jnames.c jnhash.c
INC     = mnews.h group.h article.h mark.h mh.h ucbmail.h rmail.h board.h \
		newspost.h mailsend.h pager.h fcc.h mime.h compat.h \
		nntplib.h kanjilib.h termlib.h site_DOS.h site_X68.h \
		inetbios.h
C_OBJ   = config.o
C_SRC   = config.c
C_INC   = config.h
SITE    = site_dep.h
DOC1    = mnews.doc mnews.1 read1ST.doc readme.doc update.doc FAQ.doc \
		board.doc present.doc
DOC2    = prerel.doc
ETC     = board.sh board.csh combine.sh jnames.smp _mnews.smp
INFO    = inst_inf.h
MAKE1   = config.sh config.jsh Makefile.obj
MAKE2   = Makefile.src Makefile.MSC Makefile.TCC Makefile.X68
SRC_DIST= mnews_src.Lzh
OBJ_DIST= mnews_obj.Lzh
EXE_DIST= mnews_exe.Lzh

all: $(EXE)

obj: $(OBJ)

$(EXE): $(BASE_OBJ) $(OPTION_OBJ) $(C_OBJ)
	$(CC) $(CC_FLAG) -o $@ $(BASE_OBJ) $(OPTION_OBJ) $(C_OBJ) $(LIBS)
	strip $@

.c.o: $(INC)
	$(CC) $(C_FLAG2) -c $*.c

$(C_OBJ): $(C_SRC) $(C_INC) $(SITE)
	$(CC) $(C_FLAG2) $(CONNECT_OPT) -c config.c

nntplib.o: nntplib.c nntplib.h compat.h
	$(CC) $(C_FLAG1) $(CONNECT_OPT) -c $*.c

kanjilib.o: kanjilib.c kanjilib.h compat.h
	$(CC) $(C_FLAG1) -DDELETE_X0212 -c $*.c

termdos.o: termdos.c termlib.h compat.h
	$(CC) $(C_FLAG2) -c $*.c

jnames.o: jnames.c
	$(CC) $(C_FLAG2) -c $*.c

jnhash.o: jnhash.c
	$(CC) $(C_FLAG2) -c $*.c

mnews.o: mnews.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

group.o: group.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

article.o: article.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

mark.o: mark.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

mh.o: mh.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

ucbmail.o: ucbmail.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

rmail.o: rmail.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

board.o: board.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

newspost.o: newspost.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

mailsend.o: mailsend.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

pager.o: pager.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

fcc.o: fcc.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

mime.o: mime.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

compat.o: compat.c $(INC)
	$(CC) $(C_FLAG2) -c $*.c

install: all
	copy $(EXE) $(BIN_DIR)
	copy mnews.doc $(MAN_DIR)

help:
	@echo "--- Mini News Reader Makefile [Source Version] ---"
	@echo "make          --- make executable file"
	@echo "make install  --- install executable & manual file"
	@echo "make clean    --- remove backup & object file"
	@echo "make remove   --- remove object file"
	@echo "make help     --- print help message"
	@echo "make src_dist --- archive source & document file"
	@echo "make obj_dist --- archive object & document file"
	@echo "make bin_dist --- archive executable & document file"

clean:
	-$(RM) $(RM_FLAG) $(EXE) $(OBJ) $(C_OBJ) $(INFO)
	-$(RM) $(RM_FLAG) *~ \#* *\#

remove:
	-$(RM) $(RM_FLAG) $(EXE) $(OBJ) $(C_OBJ) $(INFO)

src_dist:
	-$(RM) $(RM_FLAG) $(SRC_DIST)
	lha a $(SRC_DIST) $(SRC) $(INC) $(C_SRC) $(C_INC) $(ETC) \
		$(DOC1) $(DOC2) $(MAKE1) $(MAKE2)

obj_dist: $(OBJ)
	-$(RM) $(RM_FLAG) $(OBJ_DIST)
	lha a $(OBJ_DIST) $(OBJ) $(C_SRC) $(C_INC) $(ETC) $(DOC1) $(MAKE1)

bin_dist: $(EXE)
	-$(RM) $(RM_FLAG) $(EXE_DIST)
	lha a $(EXE_DIST) $(EXE) $(ETC) $(DOC1)

touch:
	touch $(SRC) $(INC) $(C_SRC) $(C_INC) $(ETC) \
		$(DOC1) $(DOC2) $(MAKE1) $(MAKE2)
