/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1993-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : Compatible routine
 *  File        : compat.c
 *  Version     : 1.19
 *  First Edit  : 1993-12/10
 *  Last  Edit  : 1995-03/05
 *  Author      : MSR24  
 *
 */

#include	<stdio.h>
#include	<ctype.h>
#ifdef	__STDC__
#include	<stdarg.h>
#else	/* !__STDC__ */
#include	<varargs.h>
#endif	/* !__STDC__ */
#ifdef	MSC
#include	<malloc.h>
#endif	/* MSC */
#ifdef	__TURBOC__
#include	<alloc.h>
#endif	/* __TURBOC__ */

#ifndef	BUFF_SIZE
#define	BUFF_SIZE	1024
#endif	/* !BUFF_SIZE */

/*
 * ʸ(ʸʸ̤ʤ)
 * strncasecmp ʤޥ
 */

#if	defined(LUNA) || defined(SVR3) || defined(SVR4) || defined(SUNOS_40) || defined(SUNOS_3X) || defined(MSDOS)
#ifndef	STRNCASECMP
#define Toupper(c)	((unsigned char) (islower(c) ? toupper(c) : (c)))

int	strncasecmp(s1, s2, n)
	char	*s1;
	char	*s2;
	int	n;
{
  for ( ; (n > 1 &&
	   ((unsigned char)Toupper(*s1) == (unsigned char)Toupper(*s2)));
       s1++ , s2++ , n--) {
    if (*s1 == '\0') {
      return(0);
    }
  }
  return(Toupper(*s1) - Toupper(*s2));
}
#endif	/* !STRNCASECMP */
#endif	/* LUNA || SVR3 || SVR4 || SUNOS_40 || SUNOS_3X || MSDOS */

#ifdef	PRINTF_ZERO
#ifdef	__STDC__
int	printf2(char *fmt, ...)
#else	/* !__STDC__ */
int	printf2(fmt, va_alist)
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff[BUFF_SIZE];

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  vsprintf(buff, fmt, ap);
  printf("%s", buff);
  va_end(ap);
  return(strlen(buff));
}

#ifdef	__STDC__
int	fprintf2(FILE *fp, char *fmt, ...)
#else	/* !__STDC__ */
int	fprintf2(fp, fmt, va_alist)
     FILE	*fp;
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff[BUFF_SIZE];

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  vsprintf(buff, fmt, ap);
  fprintf(fp, "%s", buff);
  va_end(ap);
  return(strlen(buff));
}
#endif	/* PRINTF_ZERO */

#ifdef	SVR3
#ifndef	RENAME
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/stat.h>

int	rename(src, dist)
     char	*src;
     char	*dist;
{
  struct stat	s1,s2;
  extern int	errno;
  
  if (stat(src, &s1) < 0) {
    return(-1);
  }

  /*
   * src ϥǥ쥯ȥ꤫?
   */

  if ((s1.st_mode & S_IFMT) == S_IFDIR) {
    errno = ENOTDIR;
    return(-1);
  }

  if (stat(dist, &s2) >= 0) {

    /*
     * dist ϥǥ쥯ȥ꤫?
     */

    if ((s2.st_mode & S_IFMT) == S_IFDIR) {
      errno = EISDIR;
      return(-1);
    }
    if (unlink(dist) < 0) {
      return(-1);
    }
  }
  if (link(src, dist) < 0) {
    return(-1);
  }
  if (unlink(src) < 0) {
    return(-1);
  }
  return(0);
}
#endif	/* !RENAME */

#ifndef	MEMMOVE
int	memmove(p1, p2, l)
char *p1, *p2;
int  l;
{
    char   *bf;
    int    i, fg;

    fg = 0;
    if ((unsigned long)p1 < (unsigned long)p2) {
	if (((unsigned long)p1 + (unsigned long)l) > (unsigned long)p2) fg = 1;
    } else if ((unsigned long)p2 < (unsigned long)p1) {
	if (((unsigned long)p2 + (unsigned long)l) > (unsigned long)p1) fg = 2;
    } else {
	return((int) p1);
    }

    switch (fg) {
    case 0:	/* area is'nt overrap */
	memcpy(p1, p2, l);
	break;
    case 1:	/* dist-area is first */
    case 2:	/* src-area is first */
	bf = (char *)malloc(l);
	if (bf == NULL) {
	    printf("\r!!!! memmove: too long !!!!\n");
	    return(-1);
	}
	memcpy(bf, p2, l);
	memcpy(p1, bf, l);
	free(bf);
	break;
    }
    return((int) p1);
}
#endif	/* !MEMMOVE */

/*
 * ХååץեΥѥ̾
 * (ե̾14ʸ¤ޥ)
 */

void	create_backup_SVR3(bak, org) 
     char	*bak;
     char	*org;
{ 
  register int	i, j;

  sprintf(bak, "%s~", org); 
  j = strlen(org);
  if (j-- < 14) {
    return;
  }
  for (i = j; i >= 0 && org[i] != '/'; i--) {
  }
  if ((j - i) < 14) {
    return;
  }
  strcpy(&bak[i + 14], "~");
} 
#endif	/* SVR3 */

#ifdef	MSDOS
/*
 * ХååץեΥѥ̾
 * (ե̾8ʸ¤ޥ)
 */

void  create_backup_DOS(bak, org) 
     char *bak;
     char *org;
{ 
  register int    i, j;

  sprintf(bak, "%s~", org); 
  j = strlen(org);
  if (j-- < 8) {
    return;
  }
  for (i = j; i >= 0 && org[i] != '/' && org[i] != '\\'; i--) {
  }
  if ((j - i) < 8) {
    return;
  }
  strcpy(&bak[i + 8], "~");
} 

/*
 * getpid()  getpid ؿΥɥ쥹 % 100 Ǹⲽ
 */

int	getpid()
{
  return(((int)getpid) % 100);
}

/*
 * sleep() ñ롼פǸⲽ
 */

#ifndef	X68K
int	sleep(second)
     int	second;
{
  register int	i, j, n;

  n = 0;
  for (i = 0; i < second; i++) {
    for (j = 0; j < 0x7FFF; j++) {
      n += j;
    }
  }
  return(n);
}

#ifndef	DOS_PIPE
FILE	*popen()
{
  return(NULL);
}

int	pclose()
{
  return(1);
}
#endif	/* DOS_PIPE */

void	*large_malloc(alloc_size)
  unsigned long	alloc_size;
{
  if (alloc_size >= 65536L) {
    return(NULL);
  }
#ifdef	__TURBOC__
  return(farmalloc((unsigned long)alloc_size));
#else	/* !__TURBOC__ */
  return(malloc((size_t)alloc_size));
#endif	/* !__TURBOC__ */
}

void	*large_realloc(large_ptr, alloc_size)
  char		*large_ptr;
  unsigned long	alloc_size;
{
#ifdef	__TURBOC__
  return(farrealloc(large_ptr, (unsigned long)alloc_size));
#else	/* !__TURBOC__ */
  if (alloc_size >= 65536L) {
    return(NULL);
  }
  return(realloc(large_ptr, (size_t)alloc_size));
#endif	/* !__TURBOC__ */
}

void	large_free(large_ptr)
  char	*large_ptr;
{
#ifdef	__TURBOC__
  farfree(large_ptr);
#else	/* !__TURBOC__ */
  free(large_ptr);
#endif	/* !__TURBOC__ */
}
#endif	/* !X68K */
#endif	/* MSDOS */
