/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1996 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : Main program
 *  File        : mnews.c
 *  Version     : 1.19
 *  First Edit  : 1991-07/25
 *  Last  Edit  : 1996-01/22
 *  Author      : MSR24  
 *
 */

/*
 * Turbo-C ǥåγĥ
 * main ʤԹ礬餷Τǡ
 */

#ifdef	__TURBOC__
unsigned int	_stklen = 0x7FFF;
#endif	/* __TURBOC__ */

#include	"compat.h"
#include	"nntplib.h"
#include	"mnews.h"
#include	"kanjilib.h"
#include	"termlib.h"
#include	"group.h"
#include	"article.h"
#include	"pager.h"
#include	"mark.h"
#include	"mailsend.h"
#include	"mime.h"

#ifdef	JNAMES
int		jnOpen();	/* JNAMES ǡ١Υץ	*/
int		jnClose();	/* JNAMES ǡ١Υ	*/
unsigned char	*jnFetch();	/* JNAMES ǡ١θ		*/

short	jnames;				/* JNAMES ѥե饰	*/
#endif	/* JNAMES */
static void	get_comment();		/* ȼ		*/

char	*connect_string[] = {		/* ³⡼		*/
  "NNTP",
  "NSPL",
  "DEAD",
  "MAIL"
  };
char	*newmail_string[] = {		/* ᡼		*/
  "        ",
#ifdef	IGNORE_MSGCHK
  "--------"
#else	/* !IGNORE_MSGCHK */
  "NEW MAIL"
#endif	/* !IGNORE_MSGCHK */
  };
short	head_lines;			/* إå饤Կ	*/
short	mode_lines;			/* ⡼ɥ饤Կ	*/

static char	prog_name[PATH_BUFF];	/* ץ̾		*/
static FILE	*error_fp = NULL;	/* 顼ե	*/
static char	server_name[32];	/* NNTP ̾	*/
static char	write_file[MAX_WRITE_FILE][PATH_BUFF];
					/* 񤭹ߥե	*/
static char	emerge_file[PATH_BUFF];	/* ۵ޥޡե	*/

/*
 * 롼ץꥹ
 */

GROUP_LIST	*group_list = NULL;
BOGUS_LIST	*bogus_list = NULL;

/*
 * ѥɥե(ۡǥ쥯ȥ˻)
 */

#ifndef	MSDOS
struct passwd		*passwd;
#endif	/* !MSDOS */

char	*month_string[] = {		/* ̾			*/
  "???", "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
  };
char	*day_string[] = {		/* ̾		*/
  "???", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
  };
char	*day_jstring[] = {	/* ̾(ܸ)	*/
  "??", "", "", "", "", "", "", ""
  };

/*
 * ޥե/ץ饤Ϣ
 */

int	multi_list[MAX_MULTI_NUMBER];
int	multi_number = 0;

/*
 * ɽإå
 */

static char	*print_field[] = {
  X_NSUBJ_FIELD,		/* ΥեɤƬˤ뤳ȡ	*/
  DATE_FIELD,			/* Υեɤ 2 ܤˤ뤳ȡ	*/
  FROM_FIELD,
  TO_FIELD,
  APP_TO_FIELD,
  CC_FIELD,
  BCC_FIELD,
  REPLY_FIELD,
  IN_REPLY_FIELD,
  SUBJECT_FIELD,
  GROUP_FIELD,
  FOLLOWUP_FIELD,
  DIST_FIELD,
  ORGAN_FIELD,
};

/*
 * ѥإץå
 */

static char	*always_jmessage[] = {
  "\t^L              ɽޤ\n",
  "\t^Z              ڥɤޤ\n",
  "\tw               磻ɥ⡼ɤؤޤ\n",
  "\tx               Ѹ/ܸ⡼ɤؤޤ\n",
  "\t?               إɽޤ\n",
  "\tA               ɽ򥳡̵ѴǹԤʤޤ\n",
  "\tE               ɽ EUC ɤǹԤʤޤ\n",
  "\tJ               ɽ JIS ɤǹԤʤޤ\n",
  "\tS               ɽ SJIS ɤǹԤʤޤ\n",
  "\tQ               ƥλޤ\n\n",
  NULL,
};

static char	*group_jmessage[] = {
#ifdef	MIME
  "\tM               MIME 󥳡/ǥɽ⡼ɤؤޤ\n",
#endif	/* MIME */
  NULL,
};

static char	*subject_jmessage[] = {
#ifndef	SMALL
  "\t/               ֥Ȥޤ\n",
  "\t                (ʸϤƲ)\n",
  "\t\\               ֥Ȥޤ\n",
  "\t                (ʸϤƲ)\n",
  "\t|               ѥ׼¹Ԥޤ\n",
  "\t                (ѥ׼¹Ԥ륳ޥɤϤƲ)\n",
#endif	/* !SMALL */
  "\th               եޥåȤؤޤ\n",
  NULL,
};

static char	*always_message[] = {
#ifndef	SMALL
  "\t^L           redisplay screen.\n",
  "\t^Z           suspend.\n",
  "\tw            toggle wide mode.\n",
  "\tx            toggle English/Japanese mode.\n",
  "\t?            show help screen.\n",
  "\tA            print Japanese no conversion.\n",
  "\tE            print Japanese EUC code.\n",
  "\tJ            print Japanese JIS code.\n",
  "\tS            print Japanese SJIS code.\n",
  "\tQ            quit system.\n\n",
#endif	/* !SMALL */
  NULL,
};

static char	*group_message[] = {
#ifdef	MIME
  "\tM            change MIME encode/decode mode.\n",
#endif	/* MIME */
  NULL,
};

static char	*subject_message[] = {
#ifndef	SMALL
  "\t/            forward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\t\\            backward search pattern.\n",
  "\t             (Please input search pattern.)\n",
  "\t|            execute pipe command.\n",
  "\th            change article summary format.\n",
#endif	/* !SMALL */
  NULL,
};

/*
 * ᥤؿ
 */

int	main(argc, argv)
     int	argc;
     char	*argv[];
{
  int		i;
  int		status;
  char		*ptr;
  char		file_name[PATH_BUFF];
  KANJICODE	opt_print_code;
#ifdef	JNAMES
  char		database_file[PATH_BUFF];
#endif	/* JNAMES */

  server_name[0] = '\0';
  opt_print_code = UNKNOWN_CODE;
  
  if (ptr = (char*)strrchr(argv[0], (char)SLASH_CHAR)) {
    strcpy(prog_name, ptr + 1);
  } else {
    strcpy(prog_name, argv[0]);
  }
#ifndef	MSDOS
  if (!(passwd = (struct passwd*)getpwuid(geteuid()))) {
    fprintf(stderr, "Can't get password entry.\n");
    exit(1);
  }
#endif	/* !MSDOS */
  
  /*
   * ե졼
   */

  news_config();
  for (i = 1; i < argc; i++) {
    ptr = argv[i];
    if ((*ptr == '-') || (*ptr == '/')) {
      ptr++;
      while (*ptr) {
	if (*ptr == 'D') {
	  ptr++;
	  if (*ptr) {
	    strcpy(server_name, ptr);
	  } else {
	    if (++i >= argc) {
	      fprintf(stderr, "NNTP server not specified.\n");
	      exit(1);
	    } else {
	      strcpy(server_name, argv[i]);
	    }
	  }
	  break;
	} else if (*ptr == 'h') {
	  usage(1);
	  exit(0);
	} else if (*ptr == 'v') {
	  usage(0);
	  exit(0);
	} else if (*ptr++ == 'n') {
	  break;
	}
      }
    }
  }
  nntp_select_server(server_name);
  if (i = env_config()) {
    fprintf(stderr, "%s : Configuration error.\n", prog_name);
    fflush(stderr);
    if (i > 0) {
      exit(1);
    } else {
      sleep(ERROR_SLEEP);
    }
  }
#ifndef	MIME
  mime_format = 0;
#endif	/* !MIME */
  set_mime_decode_func();
  force_nntp = !nspl_mode;
  select_name[0] = jump_name[0] = '\0';

  /*
   * åβ
   */
  
  for (i = 1; i < argc; i++) {
    ptr = argv[i];
    if ((*ptr == '-') || (*ptr == '/')) {
      ptr++;
      while (*ptr) {
	if (*ptr == 'D') {
	  ptr++;
	  if (!*ptr) {
	    i++;
	  }
	  break;
	} else if (*ptr == 'n') {
	  ptr++;
	  if (*ptr) {
	    strcpy(jump_name, ptr);
	  } else {
	    if (++i >= argc) {
	      fprintf(stderr, "News group name not specified.\n");
	      exit(1);
	    } else {
	      strcpy(jump_name, argv[i]);
	    }
	  }
	  break;
	}
	switch (*ptr++) {
	case 'a':
	  opt_print_code = ASCII_CODE;
	  break;
	case 'b':
	  bell_mode = !bell_mode;
	  break;
#ifdef	COLOR
	case 'c':
	  color_mode = !color_mode;
	  break;
#endif	/* COLOR */
	case 'e':
	  opt_print_code = EUC_CODE;
	  break;
	case 'j':
	  opt_print_code = JIS_CODE;
	  break;
#ifdef	notdef
	case 'l':
	  news_article_mask = !news_article_mask;
	  break;
#endif	/* notdef */
	case 'm':
	  mail_mode = !mail_mode;
	  break;
	case 'p':
	  pager_mode = !pager_mode;
	  break;
	case 'q':
	  quiet_mode = !quiet_mode;
	  break;
	case 's':
	  opt_print_code = SJIS_CODE;
	  break;
	case 'w':
	  wide_mode = !wide_mode;
	  break;
	case 'x':
	  if (japanese = !japanese) {
	    x_nsubj_mode = x_nsubj_org;
	  } else {
	    x_nsubj_mode = 0;
	  }
	  break;
	case 'E':
	  error_mode = !error_mode;
	  break;
	case 'G':
	  gnus_mode = !gnus_mode;
	  break;
	case 'L':
	  group_mask = !group_mask;
	  break;
#ifdef	MH
	case 'M':
	  mh_mark_mode = !mh_mark_mode;
	  break;
#endif	/* MH */
	case 'N':
	  force_nntp = !force_nntp;
	  break;
#ifdef	notdef
	case 'T':
	  news_thread_mode = !news_thread_mode;
	  break;
#endif	/* notdef */
	default:
	  fprintf(stderr, "Bad option.\n");
	  exit(1);
	  break;
	}
      }
    } else {
      fprintf(stderr, "Bad option.\n");
      exit(1);
    }
  }

  /*
   * üν
   */

#ifdef	COLOR
  if (!color_mode) {
    setup_mono();
  }
#else	/* !COLOR */
  setup_mono();
#endif	/* !COLOR */
  head_lines = HEAD_LINES - wide_mode * 2;
  mode_lines = MODE_LINES - wide_mode * 2;
  if (term_init(0)) {
    fprintf(stderr, "Terminal initialize error.\n");
    exit(1);
  }
  if (term_lines < MODE_LINES + 4) {
    term_init(3);
    fprintf(stderr, "Too narrow screen height.\n");
    exit(1);
  }
  if (term_columns < 80) {
    term_init(3);
    fprintf(stderr, "Too narrow screen width.\n");
    exit(1);
  }
  if (opt_print_code != UNKNOWN_CODE) {
    print_code = opt_print_code;
  }

  /*
   * kill ǻ줿б
   */

  for (i = 0; i < MAX_WRITE_FILE; i++) {
    write_file[i][0] = '\0';
  }
  emerge_file[0] = '\0';
  signal(SIGTERM, force_exit);
  signal(SIGHUP, force_exit);

  if (error_mode) {
    sprintf(file_name, "%s%c%s", dot_dir, SLASH_CHAR, ERROR_FILE);
    error_fp = fopen(file_name, "w");
  }
#ifdef	YOUBIN
  youbin_init(get_mail_server());
#endif	/* YOUBIN */
  if (mail_mode) {
    status = 1;
  } else {
    if (status = nntp_open(server_name)) {
      if (status < 0) {
	print_mode_line(japanese ? "˥塼Фپ֤Ǥ" :
			"News server busy.");
      } else {
	print_mode_line(japanese ? "˥塼Ф³ǤޤǤ" :
			"Can't connect news server.");
      }
      term_bell();
      sleep(ERROR_SLEEP);
    }
  }
#ifdef	JNAMES
  if (getenv("JNAMES")) {
    strcpy(database_file, getenv("JNAMES"));
  } else {
    database_file[0] = '\0';
  }
  if ((jnames = jnOpen(database_file, jnames_file)) < 0) {
    if (jnames == -1) {
      print_warning("Can't open jnames data base.");
    }
  }
#endif	/* JNAMES */
  print_title();
#ifdef	PRINT_TITLE
  i = term_lines / 2 - 2;
  if (i + 4 >= term_lines) {
    i = 1;
  }
  term_locate(0, i);
  if (japanese) {
#ifdef	SJIS_SRC
    sjis_printf("ΥեȥˤĤơ⤷ȥ֥뤬ޤ\r\n");
    sjis_printf("ɤޤΤ餻Ƥ\r\n\r\n");
    sjis_printf("˾ոХ紿ޤǤ");
#else	/* !SJIS_SRC */
    euc_printf("ΥեȥˤĤơ⤷ȥ֥뤬ޤ\r\n");
    euc_printf("ɤޤΤ餻Ƥ\r\n\r\n");
    euc_printf("˾ոХ紿ޤǤ");
#endif	/* !SJIS_SRC */
  } else {
    printf("If you have any trouble with this software, please let me\r\n");
    printf("know. I will fix your problems in the next release.\r\n\r\n");
    printf("Comments, suggestions, and bug reports are welcome.");
  }
  fflush(stdout);
#endif	/* PRINT_TITLE */
  term_set_raw();
#ifdef	MIPS
  term_set_cbreak();
#endif	/* MIPS */
  term_reset_echo();
  term_reset_nl();
#ifdef	NNTP_AUTH
  if (!status) {
    if (nntp_auth_server()) {
      print_mode_line(japanese ? "桼ǧڤ˼Ԥޤ" :
		      "Authentication failed.");
      term_bell();
      sleep(ERROR_SLEEP);
      nntp_free();
      group_number = 0;
      status = 1;
    }
  }
#endif	/* NNTP_AUTH */
  if (!status) {
    print_mode_line(japanese ? "˥塼롼ץꥹȤǤ" :
		    "Retrieving news group list.");
    nntp_list();
    strcpy(file_name, mark_file);
    news_read_initfile(file_name);
    strcpy(mark_file, file_name);
  }
  sprintf(emerge_file, "%s.emg", mark_file);
  while (1) {
    i = news_group_menu();
    if (!jump_name[0]) {
      break;
    }
  }

  /*
   * λ
   */

  if (!status) {
    nntp_close();
  }
  if (article_list) {
    free(article_list);
  }
#ifndef	DEBUG
  term_clear_all();
#endif	/* !DEBUG */
#ifdef	JNAMES
  if (jnames >= 0) {
    jnClose();
  }
#endif	/* JNAMES */
#ifdef	YOUBIN
  youbin_end();
#endif	/* YOUBIN */
  if ((!status) && (i >= 0)) {
    news_save_initfile(mark_file);
  }
  if (error_fp != (FILE*)NULL) {
    fclose(error_fp);
  }
  term_init(3);
  fflush(stdout);
#ifdef	OLD_ANNEX
  sleep(1);
#endif	/* OLD_ANNEX */
  term_attrib(RESET_ATTRIB);
  printf("\n");
  exit(0);
}

/*
 * إɽ(ˡ)
 */

void	help(jmessage, message, mask)
     char	*jmessage[];
     char	*message[];
     int	mask;		/*
				 * GLOBAL_MODE_MASK :A,E,J,S,x,m,w,^Z
				 * GROUP_MODE_MASK  :M
				 * SUBJECT_MODE_MASK:h
				 */
{
  FILE	*fp;
  char	tmp_file[PATH_BUFF];

  create_temp_name(tmp_file, "H");
  if ((fp = fopen2(tmp_file, "w")) == (FILE*)NULL) {
    print_fatal("Can't create output file.");
    return;
  }
  if (japanese) {
    message = jmessage;
  }
  while (*message) {
#ifdef	SJIS_SRC
    sjis_fprintf(fp, "%s", *message++);
#else	/* !SJIS_SRC */
    euc_fprintf(fp, "%s", *message++);
#endif	/* !SJIS_SRC */
  }
  if (mask & GROUP_MODE_MASK) {
    if (japanese) {
      message = group_jmessage;
    } else {
      message = group_message;
    }
    while (*message) {
#ifdef	SJIS_SRC
      sjis_fprintf(fp, "%s", *message++);
#else	/* !SJIS_SRC */
      euc_fprintf(fp, "%s", *message++);
#endif	/* !SJIS_SRC */
    }
  }
  if (mask & SUBJECT_MODE_MASK) {
    if (japanese) {
      message = subject_jmessage;
    } else {
      message = subject_message;
    }
    while (*message) {
#ifdef	SJIS_SRC
      sjis_fprintf(fp, "%s", *message++);
#else	/* !SJIS_SRC */
      euc_fprintf(fp, "%s", *message++);
#endif	/* !SJIS_SRC */
    }
  }
  if (mask & GLOBAL_MODE_MASK) {
    if (japanese) {
      message = always_jmessage;
    } else {
      message = always_message;
    }
    while (*message) {
#ifdef	SJIS_SRC
      sjis_fprintf(fp, "%s", *message++);
#else	/* !SJIS_SRC */
      euc_fprintf(fp, "%s", *message++);
#endif	/* !SJIS_SRC */
    }
  }
  fclose(fp);
  exec_pager(NULL, tmp_file, 0, "HELP");
  funlink2(tmp_file);
}

/*
 * ȥɽ
 */

void	print_title()
{
  static int	connect_status = -1;
#ifdef	TERM_REGION_CLR
  register int	i;
#endif	/* TERM_REGION_CLR */

  if (mail_mode) {
    connect_status = 3;
  } else {
    if ((connect_status <= 0) || (connect_status == 2)) {
      if (!(connect_status = connect_mode)) {
	if (nntp_send("")) {
	  connect_status = 2;
	}
      }
    }
  }
#ifdef	TERM_REGION_CLR
  term_locate(0, 3 - wide_mode * 2);
  for (i = 0; i < (term_lines - mode_lines); i++) {
    term_clear_line();
    term_down();
  }
#else	/* !TERM_REGION_CLR */
  term_clear_all();
#endif	/* !TERM_REGION_CLR */
  if (!wide_mode) {
#ifdef	COLOR
    term_attrib(color_code[TITLE_COLOR]);
#else	/* !COLOR */
    term_attrib(REVERSE_ATTRIB);
#endif	/* !COLOR */
    print_full_line("Mini News Reader Version %-10.10s Copyright (C) By A.Takuma [%s]%-10.10s",
		    MNEWS_VERSION, connect_string[connect_status],
		    nntp_server);
    term_locate(0, 1);
    term_attrib(RESET_ATTRIB);
  }
}

/*
 * ⡼ɥ饤ɽ(EUC ʸ)
 */

#ifdef	DONT_HAVE_DOPRNT
void	print_mode_line(fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8;
{
  char		buff1[SMALL_BUFF];
  char		buff2[SMALL_BUFF];

  sprintf(buff1, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
#ifdef	SJIS_SRC
  sjis_strncpy2(buff2, buff1, term_columns - 1);
#else	/* !SJIS_SRC */
  euc_strncpy2(buff2, buff1, term_columns - 1);
#endif	/* !SJIS_SRC */
#ifdef	COLOR
  term_attrib(color_code[GUIDE_COLOR]);
#else	/* !COLOR */
  term_attrib(REVERSE_ATTRIB);
#endif	/* !COLOR */
  term_locate(term_columns - 2, term_lines - 1);
  term_fill_right();
  term_locate(0, term_lines - 1);
#ifdef	SJIS_SRC
  sjis_printf("%s", buff2);
#else	/* !SJIS_SRC */
  euc_printf("%s", buff2);
#endif	/* !SJIS_SRC */
  term_attrib(RESET_ATTRIB);
  fflush(stdout);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	print_mode_line(char *fmt, ...)
#else	/* !__STDC__ */
void	print_mode_line(fmt, va_alist)
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[SMALL_BUFF];
  char		buff2[SMALL_BUFF];

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  vsprintf(buff1, fmt, ap);
#ifdef	SJIS_SRC
  sjis_strncpy2(buff2, buff1, term_columns - 1);
#else	/* !SJIS_SRC */
  euc_strncpy2(buff2, buff1, term_columns - 1);
#endif	/* !SJIS_SRC */
#ifdef	COLOR
  term_attrib(color_code[GUIDE_COLOR]);
#else	/* !COLOR */
  term_attrib(REVERSE_ATTRIB);
#endif	/* !COLOR */
  term_locate(term_columns - 2, term_lines - 1);
  term_fill_right();
  term_locate(0, term_lines - 1);
#ifdef	SJIS_SRC
  sjis_printf("%s", buff2);
#else	/* !SJIS_SRC */
  euc_printf("%s", buff2);
#endif	/* !SJIS_SRC */
  term_attrib(RESET_ATTRIB);
  fflush(stdout);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * 1 ԥեɽ(EUC ʸ)
 */

#ifdef	DONT_HAVE_DOPRNT
void	print_full_line(fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8;
{
  char		buff1[SMALL_BUFF];
  char		buff2[SMALL_BUFF];

  sprintf(buff1, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
#ifdef	SJIS_SRC
  sjis_strncpy2(buff2, buff1, term_columns);
  sjis_printf("%s", buff2);
#else	/* !SJIS_SRC */
  euc_strncpy2(buff2, buff1, term_columns);
  euc_printf("%s", buff2);
#endif	/* !SJIS_SRC */
  fflush(stdout);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	print_full_line(char *fmt, ...)
#else	/* !__STDC__ */
void	print_full_line(fmt, va_alist)
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[SMALL_BUFF];
  char		buff2[SMALL_BUFF];

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  vsprintf(buff1, fmt, ap);
#ifdef	SJIS_SRC
  sjis_strncpy2(buff2, buff1, term_columns);
  sjis_printf("%s", buff2);
#else	/* !SJIS_SRC */
  euc_strncpy2(buff2, buff1, term_columns);
  euc_printf("%s", buff2);
#endif	/* !SJIS_SRC */
  fflush(stdout);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * 1 (бǡϤ EUC )
 * Υ롼Ϥޤ JIS-X0201 ʵڤбƤޤ
 */

void	input_line(mask, ptr1, ptr2, ptr3)
     int	mask;	/*
			 * 0:⤷ʤ(0:ʳʤζ)
			 * INPUT_SPCCUT_MASK:
			 * INPUT_EXPAND_MASK:~/ Ÿ/
			 * INPUT_COMP_MASK  :䴰ǽƯ
			 * INPUT_FOLDER_MASK:եȤ䴰ǽƯ
			 * INPUT_SHADOW_MASK:ʸ򱣤
			 */
     char	*ptr1;
     char	*ptr2;
     char	*ptr3;	/* ϥХåե */
{
#ifdef	SMALL
  term_locate(0, 1 - wide_mode);
#ifdef	SJIS_SRC
  sjis_printf(japanese ? ptr1 : ptr2);
#else	/* !SJIS_SRC */
  euc_printf(japanese ? ptr1 : ptr2);
#endif	/* !SJIS_SRC */
  term_clear_line();
  print_mode_line(japanese ? "RETURN:" : "RET:ok");
  term_init(1);
  term_locate(strlen(japanese ? ptr1 : ptr2), 1 - wide_mode);
  fgets(ptr3, SMALL_BUFF, stdin);
  term_init(2);
#else	/* !SMALL */
#ifdef	COMPLETION
  DIR_PTR	*dp;
  DIR		*dir_ptr;
#endif	/* COMPLETION */
  static char	hist[SMALL_BUFF] = "";	/* static ˤ뤳 */
  char		buff1[SMALL_BUFF];
  char		buff2[SMALL_BUFF];
#ifdef	COMPLETION
  char		buff3[SMALL_BUFF];
#endif	/* COMPLETION */
  char		yank[SMALL_BUFF];
  char		*ptr4;
#ifdef	COMPLETION
  char		*ptr5;
  int		completion;		/* 䴰ե饰եֹ */
#endif	/* COMPLETION */
  register int	offset, position, length, i;
  int		key, key2;
  int		refresh;
  int		kanji;

#ifdef	COMPLETION
  completion = 0;
#endif	/* COMPLETION */
  strcpy(buff1, ptr3);
  if (mask & (INPUT_FOLDER_MASK | INPUT_COMP_MASK)) {
#ifdef	COMPLETION
    completion = 1;
#endif	/* COMPLETION */
    if (mask & INPUT_FOLDER_MASK) {
      buff1[0] = '\0';
    }
  }
#ifdef	COMPLETION
  buff3[0] = '\0';
#endif	/* COMPLETION */
  offset = strlen(japanese ? ptr1 : ptr2);
  position = length = strlen(buff1);
  yank[0] = '\0';
  refresh = -1;
  while (position >= 0) {
    if (refresh) {
      if (refresh > 0) {
	print_title();
	if (!wide_mode) {
	  term_locate(0, 2);
#ifdef	COLOR
	  term_attrib(color_code[CATEGORY_COLOR]);
#else	/* !COLOR */
	  term_attrib(REVERSE_ATTRIB);
#endif	/* !COLOR */
	  print_full_line("");
	  term_attrib(RESET_ATTRIB);
	}
      }
      term_locate(0, 1 - wide_mode);
#ifdef	SJIS_SRC
      sjis_printf(japanese ? ptr1 : ptr2);
#else	/* !SJIS_SRC */
      euc_printf(japanese ? ptr1 : ptr2);
#endif	/* !SJIS_SRC */
      print_mode_line(japanese ?
		      "^B: ^F: ^A:Ƭ ^E: ^D: ^U:ꥢ ^N,^P:ľ RETURN:" :
		      "^B:backward ^F:forward ^A:top ^E:end ^D:delete ^U:clear ^N,^P:previous RET:ok");
      refresh = 0;
    }
    buff1[length] = '\0';
    term_locate(offset, 1 - wide_mode);
    if (!(mask & INPUT_SHADOW_MASK)) {
      euc_printf("%s", buff1);
    }
    term_clear_line();
    term_locate(offset + position, 1 - wide_mode);
    key = get_key(LINE_MODE_MASK);
    if ((key == '\t') || (key == ' ')) {	/* SPC or TAB	*/
#ifdef	COMPLETION
      if (completion) {

	/*
	 * ե/ե̾䴰
	 */

	if ((buff3[0] == '~') && (buff3[1] == SLASH_CHAR)) {
	  sprintf(buff2, "%s%s", home_dir, &buff3[1]);
	} else {
	  strcpy(buff2, buff3);
	  if (mask & INPUT_FOLDER_MASK) {
	    if (buff3[0] != SLASH_CHAR) {
	      sprintf(buff2, "%s%c%s", ptr3, SLASH_CHAR, buff3);
	    }
	  }
	}
	if (ptr4 = (char*)strrchr(buff2, (char)SLASH_CHAR)) {
	  if (ptr4 == buff2) {
	    buff2[0] = SLASH_CHAR;
	    buff2[1] = '\0';
	  } else {
	    *ptr4 = '\0';
	  }
	} else  {
	  strcpy(buff2, ".");
	}
	if (ptr4 = (char*)strrchr(buff1, (char)SLASH_CHAR)) {
	  ptr4++;
	} else {
	  ptr4 = buff1;
	}
	if (ptr5 = (char*)strrchr(buff3, (char)SLASH_CHAR)) {
	  ptr5++;
	} else {
	  ptr5 = buff3;
	}
	if ((dir_ptr = opendir(buff2)) != (DIR*)NULL) {
	  for (i = 0; i < completion; i++) {
	    if (readdir(dir_ptr) == (DIR_PTR*)NULL) {
	      break;
	    }
	  }
	  while ((dp = readdir(dir_ptr)) != (DIR_PTR*)NULL) {
	    i++;
	    strcpy(buff2, dp->d_name);
	    if ((mask & INPUT_FOLDER_MASK) &&
		(buff2[strlen(buff2) - 1] == '~')) {
	      continue;
	    }
	    if (strcmp(buff2, ".") && strcmp(buff2, "..")) {
#ifdef	MSDOS
	      if (!strncasecmp(ptr5, buff2, strlen(ptr5))) {
#else	/* !MSDOS */
	      if (!strncmp(ptr5, buff2, strlen(ptr5))) {
#endif	/* !MSDOS */
		completion = i;
		i = 0;
		strcpy(ptr4, buff2);
		length = strlen(buff1);
		if (length > (term_columns - offset - 1)) {
		  length = term_columns - offset - 1;
		}
		position = length;
		break;
	      }
	    }
	  }
	  if (i) {
	    term_bell();
	    completion = 1;
	  }
	  closedir(dir_ptr);
	}
	key = 0;
      } else {
	key = ' ';	/* TAB ϥڡȲ	*/
      }
#else	/* !COMPLETION */
      key = ' ';	/* TAB ϥڡȲ	*/
#endif	/* !COMPLETION */
    }
    switch (key) {
    case 0:		/* NULL			*/
      break;
    case 0x01:		/* ^A			*/
      position = 0;
      break;
    case 0x02:		/* ^B			*/
      if (position > 0) {
	if (buff1[--position] & 0x80) {
	  position--;
	}
      }
      break;
    case 0x04:		/* ^D			*/
      if ((length > 0) && (position < length)) {
	if (buff1[position] & 0x80) {
	  length -= 2;
	  for (i = position; i < length; i++) {
	    buff1[i] = buff1[i + 2];
	  }
	} else {
	  length--;
	  for (i = position; i < length; i++) {
	    buff1[i] = buff1[i + 1];
	  }
	}
      }
      break;
    case 0x05:		/* ^E			*/
      position = length;
      break;
    case 0x06:		/* ^F			*/
      if (position < length) {
	if (buff1[++position] & 0x80) {
	  position++;
	}
      }
      break;
    case 0x07:		/* ^G			*/
      *ptr3 = '\0';
      return;
      /* break  */
    case 0x7f:		/* DEL			*/
    case 0x08:		/* ^H			*/
      if (position > 0) {
	position--;
	if (buff1[position] & 0x80) {
	  position--;
	  for (i = position; i < length; i++) {
	    buff1[i] = buff1[i + 2];
	  }
	  length -= 2;
	} else {
	  for (i = position; i < length; i++) {
	    buff1[i] = buff1[i + 1];
	  }
	  length--;
	}
      }
      break;
    case 0x0b:		/* ^K			*/
      strcpy(yank, &buff1[position]);
      length = position;
      break;
    case 0x0c:		/* ^L 		*/
      term_init(2);
      refresh = 1;
      break;
    case 0x0e:		/* ^N ľιԤ	*/
    case 0x10:		/* ^P ľιԤ	*/
      strcpy(buff2, buff1);
      strcpy(buff1, hist);
      strcpy(hist, buff2);
      position = length = strlen(buff1);
      break;
    case '\015':	/* RETURN		*/
    case '\n':
      position = -1;
      break;
    case 0x15:		/* ^U			*/
      position = length = 0;
      break;
    case 0x19:		/* ^Y 		*/
      ptr4 = yank;
      while (*ptr4) {
	if (*ptr4 & 0x80) {
	  if (length < (term_columns - offset - 2)) {
	    length += 2;
	    for (i = length; i > position + 1; i--) {
	      buff1[i] = buff1[i - 2];
	    }
	    buff1[position++] = *ptr4++;
	    buff1[position++] = *ptr4++;
	  } else {
	    break;
	  }
	} else {
	  if (length < (term_columns - offset - 1)) {
	    length++;
	    for (i = length; i > position; i--) {
	      buff1[i] = buff1[i - 1];
	    }
	    buff1[position++] = *ptr4++;
	  } else {
	    break;
	  }
	}
      }
      break;
    case 0x1a:		/* ^Z ڥ	*/
      suspend();
      refresh = 1;
      break;
    default:		/* ʸ		*/
      if ((key >= ' ') && (key <= 0x7f)) {
	if (length < (term_columns - offset - 1)) {
	  length++;
	  for (i = length; i > position; i--) {
	    buff1[i] = buff1[i - 1];
	  }
	  buff1[position++] = key;
	}
      } else {
	kanji = 0;
	if (key & 0x80) {
	  key2 = get_key(LINE_MODE_MASK);
	  if (key2 & 0x80) {
	    kanji = 1;
	  }
	} else if (key == '\033') {
	  if (get_key(LINE_MODE_MASK) == '$') {
	    key = get_key(LINE_MODE_MASK);
	    if ((key == '@') || (key == 'B')) {
	      kanji = 2;
	    } else if (key == '(') {
	      if (get_key(LINE_MODE_MASK) == 'B') {
		kanji = 2;
	      }
	    }
	  }
	}
	while (kanji) {
	  if (kanji == 1) {
	    kanji = 0;
	  } else if (kanji == 2) {
	    key = get_key(LINE_MODE_MASK);
	    if (key == '\033') {
	      if (get_key(LINE_MODE_MASK) == '(') {
		key = get_key(LINE_MODE_MASK);
	      }
	      break;
	    }
	    if (key >= ' ') {
	      key |= 0x80;
	      key2 = get_key(LINE_MODE_MASK);
	      if (key2 >= ' ') {
		key2 |= 0x80;
	      } else {
		break;
	      }
	    } else {
	      break;
	    }
	  }
	  if ((length < (term_columns - offset - 2))
	      && (input_code != (int)ASCII_CODE)) {
	    length += 2;
	    for (i = length; i > position + 1; i--) {
	      buff1[i] = buff1[i - 2];
	    }
	    if ((kanji != 2) && (input_code == (int)SJIS_CODE)) {
	      sprintf(buff2, "%c%c", key, key2);
	      sjis_to_euc(&buff2[4], buff2);
	      buff1[position++] = buff2[4];
	      buff1[position++] = buff2[5];
	    } else {
	      buff1[position++] = key;
	      buff1[position++] = key2;
	    }
	  }
	}
      }
      break;
    }
#ifdef	COMPLETION
    if (key) {
      strncpy(buff3, buff1, length);
      buff3[length] = '\0';
      if (completion) {
	completion = 1;
      }
    }
#endif	/* COMPLETION */
  }
  buff1[length] = '\0';
  strcpy(hist, buff1);
  ptr4 = buff1;
  mask &= (INPUT_SPCCUT_MASK | INPUT_EXPAND_MASK);
  if (mask > 0) {
    while ((*ptr4 == ' ') || (*ptr4 == '\t') || (*ptr4 == '\n')) {
      ptr4++;
    }
  }
  if ((mask == INPUT_EXPAND_MASK) && (!strncmp(ptr4, "~/", 2))) {
    ptr4++;
    sprintf(ptr3, "%s%s", home_dir, ptr4);
  } else {
    strcpy(ptr3, ptr4);
  }
  if (mask > 0) {
    ptr4 = ptr3;
    while ((*ptr4) && (*ptr4 != ' ') && (*ptr4 != '\t') && (*ptr4 != '\n')) {
      ptr4++;
    }
    *ptr4 = '\0';
  }
  term_init(2);
#endif	/* !SMALL */
}

/*
 * Y/N ǧ(EUC ʸ)
 */

#ifdef	DONT_HAVE_DOPRNT
int	yes_or_no(mode, fmt1, fmt2, arg1, arg2, arg3, arg4, arg5, arg6,
		  arg7, arg8)
     y_n_mode	mode;
     char	*fmt1;
     char	*fmt2;
     int	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8;
{
  char		buff1[SMALL_BUFF];
  int		refresh;
  int		status;
  int		length;

  status = -1;
  refresh = -1;
  while (status < 0) {
    if (refresh) {
      if (refresh > 0) {
	print_title();
      }
      sprintf(buff1, japanese ? fmt1 : fmt2, arg1, arg2, arg3, arg4,
	      arg5, arg6, arg7, arg8);
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
int	yes_or_no(y_n_mode mode, char *fmt1, char *fmt2, ...)
#else	/* !__STDC__ */
int	yes_or_no(mode, fmt1, fmt2, va_alist)
     y_n_mode	mode;
     char	*fmt1;
     char	*fmt2;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[SMALL_BUFF];
  int		refresh;
  int		status;
  int		length;

#ifdef	__STDC__
  va_start(ap, fmt2);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  status = -1;
  refresh = -1;
  while (status < 0) {
    if (refresh) {
      if (refresh > 0) {
	print_title();
      }
      vsprintf(buff1, japanese ? fmt1 : fmt2, ap);
#endif	/* !DONT_HAVE_DOPRNT */
      switch ((int)mode) {
      case (int)NORMAL_YN_MODE:
      case (int)CARE_YN_MODE:
	strcat(buff1, " [Y/N]:");
	break;
      case (int)FILE_YN_MODE:
	strcat(buff1, " [Y/N/O(verwrite)]:");
	break;
      case (int)JUMP_YN_MODE:
	strcat(buff1, " [Y/N/Q(uit)]:");
	break;
      case (int)SEND_YN_MODE:
#ifdef	MIME
	strcat(buff1, " [Y/N/E(dit)/M(ime)]:");
#else	/* !MIME */
	strcat(buff1, " [Y/N/E(dit)]:");
#endif	/* !MIME */
	break;
      default:
	break;
      }
      length = strlen(buff1) + 1;
      if (length > (term_columns - 1)) {
	length = term_columns - 1;
      }
      print_mode_line(buff1);
      term_locate(length, term_lines - 1);
      fflush(stdout);
      refresh = 0;
    }
    switch (get_key(YN_MODE_MASK)) {
    case ' ':		/* SPACE	*/
      if ((mode != CARE_YN_MODE) && (mode != SEND_YN_MODE)) {
	status = 1;
      } else {
	term_bell();
      }
      break;
    case 'y':
    case 'Y':
      status = 1;
      break;
    case '\015':	/* RETURN	*/
    case '\n':
      if ((mode != CARE_YN_MODE) && (mode != SEND_YN_MODE)) {
	status = 0;
      } else {
	term_bell();
      }
      break;
    case 'n':
    case 'N':
    case 0x07:
      status = 0;
      break;
    case 'o':		/* Overwrite	*/
    case 'O':
      if (mode == FILE_YN_MODE) {
	status = 2;
      } else {
	term_bell();
      }
      break;
    case 'q':		/* Quit		*/
    case 'Q':
      if (mode == JUMP_YN_MODE) {
	status = 2;
      } else {
	term_bell();
      }
      break;
    case 'e':		/* Edit		*/
    case 'E':
      if (mode == SEND_YN_MODE) {
	status = 2;
      } else {
	term_bell();
      }
      break;
#ifdef	MIME
    case 'm':		/* Mime		*/
    case 'M':
      if (mode == SEND_YN_MODE) {
	if (mime_format == 2) {
	  mime_format = 1;
	} else {
	  mime_format = 2;
	}
	set_mime_decode_func();
	term_clear_all();
	status = 3;
      } else {
	term_bell();
      }
      break;
#endif	/* MIME */
    case 0x0c:		/* ^L 	*/
      term_init(2);
      refresh = 1;
      break;
    case 0x1a:		/* ^Z ڥ*/
      suspend();
      refresh = 1;
      break;
    default:
      term_bell();
      break;
    }
  }
#ifndef	DONT_HAVE_DOPRNT
  va_end(ap);
#endif	/* !DONT_HAVE_DOPRNT */
  return(status);
}

#ifndef	SMALL
/*
 * ʸ
 */

char	*input_search_string(direction)
     int	direction;
{
  static char	search_string[SMALL_BUFF] = "";

  if (!direction) {
    input_line(0, "ʸϤƲ:",
	       "Input forward search string:", search_string);
  } else {
    input_line(0, "ʸϤƲ:",
	       "Input backward search string:", search_string);
  }
  if (*search_string) {
    print_mode_line(japanese ? "Ǥ" : "Searching.");
    return(search_string);
  }
  print_mode_line(japanese ? "ߤޤ" : "Search aborted.");
  return(NULL);
}
#endif	/* !SMALL */

#if	defined(NEWSPOST) || defined(MAILSEND)
/*
 * եɥեޥåȽ
 */

void	field_fprintf(fp, fmt, from_field, subject, message_id,
		      group_name, date_field)
     FILE	*fp;
     char	*fmt;
     char	*from_field;
     char	*subject;
     char	*message_id;
     char	*group_name;
     char	*date_field;
{
  short	year, month, date, day, hour, minute, second;
  char	buff1[BUFF_SIZE];
  char	buff2[BUFF_SIZE];
  char	from[MAX_FIELD_LEN];
  char	comment[BUFF_SIZE];
  char	zone_name[MAX_FIELD_LEN];
  char	*ptr1, *ptr2;

  get_real_adrs(from_field, buff1);
  get_comment(from_field, comment);
  sprintf(buff2, "%s@%s", user_name, domain_name);
  if (!strcasecmp(buff1, buff2)) {
    *from = *comment = '\0';
  } else {
    if (japanese) {
#ifdef	JNAMES
      get_jadrs(from, buff1);
#else	/* !JNAMES */
      strcpy(from, buff1);
#endif	/* !JNAMES */
    } else {
      strcpy(from, buff1);
    }
  }
  ptr1 = buff1;
  convert_article_date(date_field, &year, &month, &date, &day, &hour,
		       &minute, &second, zone_name);
  while (*fmt) {
    switch (*fmt) {
    case '%':
      fmt++;
      ptr2 = NULL;
      switch (*fmt) {
      case 'F':
	ptr2 = from;
	break;
      case 'c':
	if (*comment) {
	  mime_decode_func(buff2, comment, default_code);
	  ptr2 = buff2;
	  break;
	}
	/* break  */
      case 'f':
	strcpy(buff2, from);
	ptr2 = buff2;
	while (*ptr2) {
	  if (*ptr2 == '@') {
	    *ptr2 = '\0';
	    break;
	  }
	  ptr2++;
	}
	ptr2 = buff2;
	break;
      case 'N':
	ptr2 = group_name;
	break;
      case 'y':
	sprintf(buff2, "%02d", year % 100);
	ptr2 = buff2;
	break;
      case 'Y':
	sprintf(buff2, "%04d", year);
	ptr2 = buff2;
	break;
      case 'm':
	sprintf(buff2, "%02d", month);
	ptr2 = buff2;
	break;
      case 'b':
	sprintf(buff2, "%s", month_string[month]);
	ptr2 = buff2;
	break;
      case 'd':
	sprintf(buff2, "%02d", date);
	ptr2 = buff2;
	break;
      case 'h':
	sprintf(buff2, "%02d", hour % 12);
	ptr2 = buff2;
	break;
      case 'H':
	sprintf(buff2, "%02d", hour);
	ptr2 = buff2;
	break;
      case 'M':
	sprintf(buff2, "%02d", minute);
	ptr2 = buff2;
	break;
      case 'S':
	sprintf(buff2, "%02d", second);
	ptr2 = buff2;
	break;
      case 'w':
	strcpy(buff2, day_string[day]);
	ptr2 = buff2;
	break;
      case 'W':
#ifdef	SJIS_SRC
	sjis_to_euc(buff2, day_jstring[day]);
#else	/* !SJIS_SRC */
	strcpy(buff2, day_jstring[day]);
#endif	/* !SJIS_SRC */
	ptr2 = buff2;
	break;
      case 's':
	mime_decode_func(buff2, subject, default_code);
	ptr2 = buff2;
	break;
      case 'I':
	ptr2 = message_id;
	break;
      case 'p':
	if (hour >= 12) {
	  ptr2 = "PM";
	} else {
	  ptr2 = "AM";
	}
	break;
      case 'P':
	if (hour >= 12) {
	  ptr2 = "";
	} else {
	  ptr2 = "";
	}
#ifdef	SJIS_SRC
	sjis_to_euc(buff2, ptr2);
	ptr2 = buff2;
#endif	/* SJIS_SRC */
	break;
      case 'z':
	ptr2 = zone_name;
	break;
      default:
	*ptr1++ = '%';
	*ptr1++ = *fmt++;
	continue;
	/* break  */
      }
      fmt++;
      if (ptr2) {
	if (*ptr2) {
	  while (*ptr2) {
	    *ptr1++ = *ptr2++;
	  }
	} else {
	  ptr2 = NULL;
	}
      }
      if (*fmt == '{') {	/* ĥեޥå */
	fmt++;
	if (ptr2) {
	  ptr2 = fmt;
	}
	while (*fmt) {
	  if (*fmt == '}') {
	    fmt++;
	    break;
	  } else if (*fmt == ',') {
	    fmt++;
	    if (!ptr2) {
	      ptr2 = fmt;
	    }
	  } else if (*fmt++ == '\\') {
	    if (*fmt) {
	      fmt++;
	    }
	  }
	}
	if (ptr2) {
	  while (*ptr2) {
	    if ((*ptr2 == '}') || (*ptr2 == ',')) {
	      break;
	    } else if (*ptr2 == '\\') {
	      ptr2++;
	      switch (*ptr2) {
	      case 'n':
		*ptr1++ = '\n';
		ptr2++;
		break;
	      case 't':
		*ptr1++ = '\t';
		ptr2++;
		break;
	      default:
		*ptr1++ = *ptr2++;
		/* break  */
	      case '\0':
		break;
	      }
	    } else {
	      *ptr1++ = *ptr2++;
	    }
	  }
	}
      }
      break;
    case '\\':
      fmt++;
      switch (*fmt) {
      case 'n':
	*ptr1++ = '\n';
	fmt++;
	break;
      case 't':
	*ptr1++ = '\t';
	fmt++;
	break;
      default:
	*ptr1++ = *fmt++;
	/* break  */
      case '\0':
	break;
      }
      break;
    default:
      *ptr1++ = *fmt++;
      break;
    }
  }
  *ptr1 = '\0';
  edit_fprintf(fp, "%s", buff1);
}

/*
 * ǥѴʸ
 */

#ifdef	DONT_HAVE_DOPRNT
void	edit_fprintf(fp, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
     FILE	*fp;
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8;
{
  char	buff1[BUFF_SIZE];
  char	buff2[BUFF_SIZE];
  
  sprintf(buff1, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
  switch (edit_code) {
  case JIS_CODE:
    to_jis(buff2, buff1, default_code);
    break;
  case SJIS_CODE:
    to_sjis(buff2, buff1, default_code);
    break;
  case EUC_CODE:
    to_euc(buff2, buff1, default_code);
    break;
  default:
    strcpy(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	edit_fprintf(FILE *fp, char *fmt, ...)
#else	/* !__STDC__ */
void	edit_fprintf(fp, fmt, va_alist)
     FILE	*fp;
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char	buff1[BUFF_SIZE];
  char	buff2[BUFF_SIZE];
  
#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  vsprintf(buff1, fmt, ap);
  switch (edit_code) {
  case JIS_CODE:
    to_jis(buff2, buff1, default_code);
    break;
  case SJIS_CODE:
    to_sjis(buff2, buff1, default_code);
    break;
  case EUC_CODE:
    to_euc(buff2, buff1, default_code);
    break;
  default:
    strcpy(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */
#endif	/* NEWSPOST || MAILSEND */

/*
 * ڥ
 */

void	suspend()
{
  term_init(1);
  term_locate(0, term_lines - 1);
  fflush(stdout);
#ifdef	MSDOS
  system("");
#else	/* !MSDOS */
#ifdef	SIGSTOP
  kill(getpid(), SIGSTOP);
#else	/* !SIGSTOP */
  term_system((char *)NULL);
#endif	/* !SIGSTOP */
  sleep(1);
#endif	/* !MSDOS */
  term_init(2);
}

/*
 * ٹ𥨥顼ɽ
 */

#ifdef	DONT_HAVE_DOPRNT
void	print_warning(fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8;
{
  char		buff[SMALL_BUFF];
  short		color;

  if (!quiet_mode) {
    sprintf(buff, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
#ifdef	COLOR
    color = color_code[GUIDE_COLOR];
    color_code[GUIDE_COLOR] = color_code[ERROR_COLOR];
#endif	/* COLOR */
    print_mode_line("%s", buff);
#ifdef	COLOR
    color_code[GUIDE_COLOR] = color;
#endif	/* COLOR */
    if (error_fp) {
      fprintf(error_fp, "%s : Warning : ", prog_name);
      fprintf(error_fp, "%s\n", buff);
      fflush(error_fp);
    }
  }
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	print_warning(char *fmt, ...)
#else	/* !__STDC__ */
void	print_warning(fmt, va_alist)
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff[SMALL_BUFF];
  short		color;

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  if (!quiet_mode) {
    vsprintf(buff, fmt, ap);
#ifdef	COLOR
    color = color_code[GUIDE_COLOR];
    color_code[GUIDE_COLOR] = color_code[ERROR_COLOR];
#endif	/* COLOR */
    print_mode_line("%s", buff);
#ifdef	COLOR
    color_code[GUIDE_COLOR] = color;
#endif	/* COLOR */
    if (error_fp) {
      fprintf(error_fp, "%s : Warning : ", prog_name);
      fprintf(error_fp, "%s\n", buff);
      fflush(error_fp);
    }
  }
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * ̿Ū顼ɽ
 */

#ifdef	DONT_HAVE_DOPRNT
void	print_fatal(fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)

     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8;
{
  char		buff[SMALL_BUFF];
  short		color;

  sprintf(buff, fmt, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
#ifdef	COLOR
  color = color_code[GUIDE_COLOR];
  color_code[GUIDE_COLOR] = color_code[ERROR_COLOR];
#endif	/* COLOR */
  print_mode_line("%s", buff);
#ifdef	COLOR
  color_code[GUIDE_COLOR] = color;
#endif	/* COLOR */
  if (error_fp) {
    fprintf(error_fp, "%s : ", prog_name);
    fprintf(error_fp, "%s\n", buff);
    fflush(error_fp);
  }
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	print_fatal(char *fmt, ...)
#else	/* !__STDC__ */
void	print_fatal(fmt, va_alist)
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff[SMALL_BUFF];
  short		color;

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
  vsprintf(buff, fmt, ap);
#ifdef	COLOR
  color = color_code[GUIDE_COLOR];
  color_code[GUIDE_COLOR] = color_code[ERROR_COLOR];
#endif	/* COLOR */
  print_mode_line("%s", buff);
#ifdef	COLOR
  color_code[GUIDE_COLOR] = color;
#endif	/* COLOR */
  if (error_fp) {
    fprintf(error_fp, "%s : ", prog_name);
    fprintf(error_fp, "%s\n", buff);
    fflush(error_fp);
  }
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * ʸ󸡺
 */

char	*strindex(str1 ,str2)
     char	*str1;
     char	*str2;
{
  int	length;

  length = strlen(str2);
  while (*str1) {
    if (!strncasecmp(str1, str2, length)) {
      return(str1);
    }
    str1++;
  }
  return(NULL);
}

/*
 * ե뤫 1 (ǸιԤ˲ԤĤƤʤղä)
 */

int	fgets2(ptr, size, fp)
     char	*ptr;
     int	size;
     FILE	*fp;
{
  register int	code;
  register int	status;
  register int	first;

  status = 1;
  first = 1;
  if (feof(fp)) {
    status = 0;
  } else {
    while (size > 0) {
      switch (code = fgetc(fp)) {
      case EOF:
	if (first) {
	  status = 0;
	} else {
	  *ptr++ = '\n';
	}
	size = 0;
	break;
      case '\n':
	*ptr++ = code;
	size = 0;
	break;
      default:
	*ptr++ = code;
	size--;
      }
      first = 0;
    }
  }
  *ptr = '\0';
  return(status);
}

/*
 * Ѵ
 */

int	convert_code(file1, file2, code, mode)
     char	*file1;
     char	*file2;
     int	code;
     int	mode;	/* 0:̵Ѵ 1:إå+Ѵ 2:Ѵ */
{
  FILE		*fp1, *fp2;
  short		year, month, date, day, hour, minute, second;
  register int	i, j;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		buff3[BUFF_SIZE];
  char		*ptr1, *ptr2;
#ifdef	MIME
  char		*ptr3, *ptr4, *ptr5;
#endif	/* MIME */

  if ((fp1 = fopen(file1, "r")) == (FILE*)NULL) {
    print_fatal("Can't read input file.");
    return(1);
  }
  if ((fp2 = fopen2(file2, "w")) == (FILE*)NULL) {
    print_fatal("Can't create output file.");
    fclose(fp1);
    return(1);
  }
  j = -1;
  buff3[0] = '\0';
  while (fgets(buff1, sizeof(buff1), fp1)) {
    if (mode) {
      ptr1 = NULL;
      if ((buff1[0] == ' ') || (buff1[0] == '\t')) {
	if (j < 0) {
	  continue;
	}
	if ((int)(strlen(buff3) + strlen(buff1)) < BUFF_SIZE) {
	  strcat(buff3, buff1);
	} else {
	  j = -1;
	}
      } else {
	if (buff3[0]) {
	  ptr1 = buff2;
	  if (!j && x_nsubj_mode) {
	    recover_jis(buff2, buff3);
	  } else if ((j == 1) && jst_mode) {
	    
	    /*
	     * Date:  GMT JST ѴƥեޥåȤ줷ɽ
	     */
	    
	    convert_article_date(&buff3[sizeof(DATE_FIELD) - 1],
				 &year, &month, &date, &day,
				 &hour, &minute, &second, buff2);
	    strcpy(buff3, buff2);
	    sprintf(buff2, "%s %s, %d %s %04d %02d:%02d:%02d %s\n",
		    DATE_FIELD, day_string[day], date, month_string[month],
		    year, hour, minute, second, buff3);
	  } else {
#ifdef	MIME
	    if ((mime_format) || (mode == 2)) {
	      i = 0;
	      ptr2 = buff3;
	      ptr3 = buff2;
	      ptr5 = ptr3;
	      while (*ptr2) {
		ptr4 = ptr2;
		while (*ptr4) {
		  if (*ptr4 == '\n') {
		    *ptr4++ = '\0';
		    while ((*ptr4 == '\t') || (*ptr4 == ' ')) {
		      ptr4++;
		    }
		    break;
		  } else {
		    ptr4++;
		  }
		}
		i |= mime_decode(ptr2, ptr3);
		if (kanji_strlen(ptr5) >= MAX_FIELD_COLUMN) {
		  if (ptr3 != buff2) {
		    *ptr3++ = '\n';
		    ptr5 = ptr3;
		    mime_decode(ptr2, ptr3);
		  }
		}
		while (*ptr3) {
		  ptr3++;
		}
		ptr2 = ptr4;
	      }
	      if (i) {
		*ptr3++ = '\n';
		*ptr3 = '\0';
	      } else {
		ptr4 = buff3;
		ptr3 = buff2;
		while (ptr2 != ptr4) {
		  if (*ptr4 == '\0') {
		    *ptr3++ = '\n';
		    ptr4++;
		  } else {
		    *ptr3++ = *ptr4++;
		  }
		}
		*ptr3 = '\0';
	      }
	    } else {
	      strcpy(buff2, buff3);
	    }
#else	/* !MIME */
	    strcpy(buff2, buff3);
#endif	/* !MIME */
	  }
	}
	if ((!buff1[0]) || (buff1[0] == '\n')) {
	  mode = 0;
	  if (ptr1) {
	    strcat(ptr1, buff1);
	  } else {
	    ptr1 = buff1;
	  }
	} else {
	  if (mode == 1) {
	    j = -1;
	    for (i = 0; i < sizeof(print_field) / sizeof(char*); i++) {
	      if (!strncasecmp(buff1, print_field[i],
			       strlen(print_field[i]))) {
		j = i;
	      }
	    }
	  } else {
	    j = 999;
	  }
	  if (j < 0) {
	    buff3[0] = '\0';
	  } else {
	    strcpy(buff3, buff1);
	  }
	}
      }
    } else {
      ptr1 = buff1;
    }
    if (ptr1) {
      if (ptr1 == buff1) {
	ptr2 = buff2;
      } else {
	ptr2 = buff1;
      }
      switch (code) {
      case JIS_CODE:
	to_jis(ptr2, ptr1, default_code);
	break;
      case SJIS_CODE:
	to_sjis(ptr2, ptr1, default_code);
	break;
      case EUC_CODE:
	to_euc(ptr2, ptr1, default_code);
	break;
      default:
	ptr2 = ptr1;
	break;
      }
      fputs(ptr2, fp2);
    }
  }
  fclose(fp1);
  fclose(fp2);
  return(0);
}

/*
 * եեޥåѴ
 */

void	convert_article_date(dates, year, month, date, day,
			     hour, minute, second, zone_name)
     char	*dates;
     short	*year;
     short	*month;
     short	*date;
     short	*day;
     short	*hour;
     short	*minute;
     short	*second;
     char	*zone_name;
{
  register short	i;
  int			offset;
  int			jst_flag;

  *year   = 0;
  *month  = 0;
  *date   = 0;
  *day    = 0;
  *hour   = 0;
  *minute = 0;
  *second = 0;

  while ((*dates == ' ') || (*dates == '\t')) {
    dates++;
  }
  if (!*dates) {
    return;
  }
  for (i = 0; i < sizeof(day_string) / sizeof(char*); i++) {
    if (!strncasecmp(dates, day_string[i], 3)) {
      *day = i;
      break;
    }
  }
  if (*day != 0) {
    dates = next_param(dates);
  }
  if (isalpha(*dates)) {	/* Date Month Year Day Time Zone */
    for (i = 0; i < sizeof(month_string) / sizeof(char*); i++) {
      if (!strncasecmp(dates, month_string[i], 3)) {
	*month = i;
	break;
      }
    }
    dates = next_param(dates);
    *date = atoi(dates);
    while (*dates) {
      if (*dates++ == ' ') {
	break;
      }
    }
    *hour = atoi(dates);
    while (*dates) {
      if (*dates++ == ':') {
	break;
      }
    }
    *minute = atoi(dates);
    while (*dates) {
      if (*dates++ == ':') {
	break;
      }
    }
    *second = atoi(dates);
    dates = next_param(dates);
    *year = atoi(dates);
    if ((*year > 0) && (*year < 1000)) {
      *year += 1900;
    }
    dates = next_param(dates);
  } else {			/* Date, Day Month Year Time Zone */
    *date = atoi(dates);
    dates = next_param(dates);
    for (i = 0; i < sizeof(month_string) / sizeof(char*); i++) {
      if (!strncasecmp(dates, month_string[i], 3)) {
	*month = i;
	break;
      }
    }
    dates = next_param(dates);
    *year = atoi(dates);
    if ((*year > 0) && (*year < 100)) {
      *year += 1900;
    }
    dates = next_param(dates);
    *hour = atoi(dates);
    while (*dates) {
      if (*dates++ == ':') {
	break;
      }
    }
    *minute = atoi(dates);
    while (*dates) {
      if (*dates++ == ':') {
	break;
      }
    }
    *second = atoi(dates);
    dates = next_param(dates);
  }
  strcpy(zone_name, dates);
  jst_flag = 0;
  if (!strncmp(dates, "GMT", 3)) {
    dates += 3;
  }
  if (*dates == '+') {
    dates++;
    offset = atoi(dates);
    if (jst_mode) {
      *hour   -= offset / 100;
      *minute -= offset % 100;
    }
    jst_flag = 1;
  } else if (*dates == '-') {
    dates++;
    offset = atoi(dates);
    if (jst_mode) {
      *hour   += offset / 100;
      *minute += offset % 100;
    }
    jst_flag = 1;
  } else if (*dates < ' ') {
    jst_flag = 1;
  }
  if (jst_flag) {
    strcpy(zone_name, "JST");
    gmt_to_jst(year, month, date, day, hour, minute, second);
  }
  dates = zone_name;
  while (*dates) {
    if (*dates == '\n') {
      *dates = '\0';
    }
    dates++;
  }
}

/*
 * GMT ֤ JST Ѵ
 */

int	gmt_to_jst(year, month, date, day, hour, minute, second)
     short	*year;
     short	*month;
     short	*date;
     short	*day;
     short	*hour;
     short	*minute;
     short	*second;
{
#ifdef	notdef
#if	defined(SUNOS_41) || defined(SUNOS_40) || defined(SUNOS_3X)
  struct tm	t1;
  struct tm	*t2;
  TIMEVALUE	gmt_time;
  
  if (!jst_mode) {
    return(0);
  }
  t1.tm_sec = *second;
  t1.tm_min = *minute;
  t1.tm_hour = *hour;
  t1.tm_year = *year - 1900;
  t1.tm_mon = *month - 1;
  t1.tm_mday = *date;
  t1.tm_wday = 0;
  t1.tm_yday = 0;
  t1.tm_isdst = 0;
  t1.tm_zone = 0;
  t1.tm_gmtoff = 0;
  gmt_time = timegm(&t1);
  t2 = localtime(&gmt_time);
  *year = t2->tm_year + 1900;
  *month = t2->tm_mon + 1;
  *date = t2->tm_mday;
  *hour = t2->tm_hour;
  *minute = t2->tm_min;
  *second = t2->tm_sec;
  *day = t2->tm_wday + 1;
#else	/* !(SUNOS_41 || SUNOS_40 || SUNOS_3X) */
  if (!jst_mode) {
    return(0);
  }
  if ((*hour = *hour + JST_OFFSET) >= 24) {
    *hour = *hour - 24;
    *date = *date + 1;
    switch (*month) {
    case 1:
    case 3:
    case 5:
    case 7:
    case 8:
    case 10:
      if (*date > 31) {
	*month = 2;
	*date = 1;
      }
      break;
    case 2:
      if ((((*year % 4) == 0) && (*year % 100)) || ((*year % 400) == 0)) {
	if (*date > 29) {
	  *month = 3;
	  *date =1;
	}
      } else if (*date > 28) {
	*month = 3;
	*date =1;
      }
      break;
    case 4:
    case 6:
    case 9:
    case 11:
      if (*date > 30) {
	*month = 2;
	*date = 1;
      }
      break;
    case 12:
      if (*date > 31) {
	*year = *year + 1;
	*month = 1;
	*date = 1;
      }
      break;
    default:
      print_fatal("Illegal GMT time.");
      break;
    }
  }
#endif	/* !(SUNOS_41 || SUNOS_40 || SUNOS_3X) */
#else	/* !notdef */
  struct tm	*t1;
  time_t	gmt_time, date_time;
  int		i;
  
  if (!jst_mode) {
    return(0);
  }
  i = (*year - 1) / 4 - 492;
  date_time = 60L * 60L * 24L;
  gmt_time = (*year - 1970) * (date_time * 365L) + i * date_time;
  for (i = 1; i < *month; i++) {
    switch (i) {
    case 1:
    case 3:
    case 5:
    case 7:
    case 8:
    case 10:
    case 12:
      gmt_time += 31L * (60L * 60L * 24L);
      break;
    case 2:
      if ((((*year % 4) == 0) && (*year % 100)) || ((*year % 400) == 0)) {
	gmt_time += 29L * date_time;
      } else {
	gmt_time += 28L * date_time;
      }
      break;
    case 4:
    case 6:
    case 9:
    case 11:
      gmt_time += 30L * date_time;
      break;
    default:
      print_fatal("Illegal GMT time.");
      break;
    }
  }
  gmt_time += (*date - 1) * date_time + *hour * (60L * 60L)
    + *minute * 60 + *second;
  t1 = localtime(&gmt_time);
  *year = t1->tm_year + 1900;
  *month = t1->tm_mon + 1;
  *date = t1->tm_mday;
  *hour = t1->tm_hour;
  *minute = t1->tm_min;
  *second = t1->tm_sec;
  *day = t1->tm_wday + 1;
#endif	/* !notdef */
  return(1);
}

/*
 * Υѥ᡼
 */

char	*next_param(ptr)
     char	*ptr;
{
  while (*ptr) {
    if ((*ptr == ' ') || (*ptr =='\t')) {
      while ((*ptr == ' ') || (*ptr =='\t')) {
	ptr++;
      }
      break;
    }
    ptr++;
  }
  return(ptr);
}

/*
 * ¥ɥ쥹
 */

char	*get_real_adrs(str1, str2)
     char	*str1;
     char	*str2;
{
  int	status;
  char	*ptr1, *ptr2;
  char	quote;

  /*
   * νϲäΤǻפ񤭴ޤ
   */

  ptr1 = ptr2 = str1;
  quote = '\0';
  status = 1;
  while (status) {
    if (quote) {
      if (*ptr1) {
	if (*ptr1++ == quote) {
	  quote = '\0';
	}
      } else {
	quote = '\0';
	print_warning("Unmatched quote found in mail address.");
      }
    } else {
      switch (*ptr1) {
      case '(':
	ptr1++;
	status = 1;
	while (status) {
	  if (!(*ptr1)) {
	    break;
	  }
	  switch (*ptr1++) {
	  case '(':
	    status++;
	    break;
	  case ')':
	    status--;
	    break;
	  default:
	    break;
	  }
	}
	if (status) {
	  print_warning("Unexpected bracket found in mail address.");
	}
	status = 1;
	break;
      case '<':
	ptr2 = ++ptr1;
	while ((*ptr2 == ' ') || (*ptr2 == '\t')) {
	  ptr2++;
	}
	status = 1;
	while (*ptr1) {
	  if (*ptr1++ == '>') {
	    break;
	  }
	}
	status = 0;
	break;
      case '\"':
	quote = *ptr1++;
	break;
      case ',':
      case '\n':
      case '\0':
	ptr2 = str1;
	status = 0;
	break;
      default:
	ptr1++;
	break;
      }
    }
  }
  while (*ptr2 && (*ptr2 != ',') && (*ptr2 != ' ') && (*ptr2 != '\t')
	 && (*ptr2 != '\n') && (*ptr2 != '>') && (*ptr2 != '(')) {
    *str2++ = *ptr2++;
  }
  *str2 = '\0';
  while ((*ptr1 == ',') || (*ptr1 == ' ') || (*ptr1 == '\t')
	 || (*ptr1 == '\n')) {
    *ptr1++ = '\0';
  }
  return(ptr1);
}

/*
 * ȼ
 */

static void	get_comment(str1, str2)
     char	*str1;
     char	*str2;
{
  int	status;
  char	*ptr1, *ptr2, *ptr3, *ptr4;

  status = 1;
  ptr1 = str1;
  ptr2 = str2;
  ptr3 = NULL;
  while (status) {
    switch (*ptr1) {
    case '(':
      ptr1++;
      status = 1;
      while (status) {
	if (!(*ptr1)) {
	  break;
	}
	switch (*ptr2++ = *ptr1++) {
	case '(':
	  status++;
	  break;
	case ')':
	  if (!--status) {
	    ptr2--;
	  }
	  break;
	default:
	  break;
	}
      }
      if (status) {
	print_warning("Unexpected bracket found in mail address.");
      }
      status = 0;
      break;
    case '<':
      ptr3 = ptr1;
      status = 0;
      break;
    case '\"':
      ptr1++;
      while (*ptr1) {
	if (*ptr1++ == '\"') {
	  break;
	}
      }
      break;
    case ',':
    case '\n':
    case '\0':
      status = 0;
      break;
    case ' ':
    case '\t':
      ptr1++;
      break;
    default:
      ptr1++;
      break;
    }
  }
  if (ptr3) {
    ptr1 = str1;
    ptr4 = NULL;
    while (ptr1 != ptr3) {
      if ((*ptr1 == ' ') || (*ptr1 == '\t')) {
	if (!ptr4) {
	  ptr4 = ptr2;
	}
      } else {
	ptr4 = NULL;
      }
      *ptr2++ = *ptr1++;
    }
    if (ptr4) {
      ptr2 = ptr4;
    }
  }
  *ptr2 = '\0';
}

/*
 * ܸ쥢ɥ쥹
 */

void	get_jadrs(ptr1, ptr2)
     char	*ptr1;
     char	*ptr2;
{
#ifdef	JNAMES
  char	buff[BUFF_SIZE];
  char	*ptr3, *ptr4;

  ptr3 = NULL;
  if ((jnames >= 0) && japanese) {
    ptr3 = (char*)jnFetch(FROM_JN_DOMAIN, ptr2);
    if (!ptr3) {
      if (ptr4 = strchr(ptr2, '@')) {
	if (strindex(ptr4, domain_name)) {
	  strcpy(buff, ptr2);
	  ptr4 = buff;
	  while (*ptr4) {
	    if (*ptr4 == '@') {
	      strcpy(ptr4 + 1, domain_name);
	      break;
	    }
	    ptr4++;
	  }
	  ptr3 = (char*)jnFetch(FROM_JN_DOMAIN, buff);
	  if (!ptr3) {
	    *ptr4 = '\0';
	    ptr3 = (char*)jnFetch(FROM_JN_DOMAIN, buff);
	  }
	}
      } else {
	sprintf(buff, "%s@%s", ptr2, domain_name);
	ptr3 = (char*)jnFetch(FROM_JN_DOMAIN, buff);
      }
    }
    if (ptr3) {
      strcpy(ptr1, ptr3);
    } else {
      strcpy(ptr1, ptr2);
    }
  } else {
    strcpy(ptr1, ptr2);
  }
#else	/* !JNAMES */
  strcpy(ptr1, ptr2);
#endif	/* !JNAMES */
}

/*
 * ܸ̾
 */

void	get_jname(domain, ptr1, number)
     char	*domain;
     char	*ptr1;
     int	number;
{
#ifdef	JNAMES
  char	*ptr2;

  if ((jnames >= 0) && japanese) {
    ptr2 = (char*)jnFetch(domain, ptr1);
    if (ptr2) {
      euc_strncpy(ptr1, ptr2, number);
    } else {
      ptr1[number] = '\0';
    }
  } else {
    ptr1[number] = '\0';
  }
#else	/* !JNAMES */
  ptr1[number] = '\0';
#endif	/* !JNAMES */
}

/*
 * 1 ʸ
 */

int	get_key(mask)
     int	mask;		/*
				 * GLOBAL_MODE_MASK :A,E,J,S,x,m,w,^Z
				 * GROUP_MODE_MASK  :M
				 * SUBJECT_MODE_MASK:h
				 * LINE_MODE_MASK   :1
				 * YN_MODE_MASK     :Y/N ǧ
				 * NEWS_MODE_MASK   :mail_send  select_name
				 *                   Ϥʤ
				 */
{
  static int	escape = 0;	/* static Ǥ뤳 */
  register int	key;

  do {
#ifdef	MSDOS
    key = getch();
#else	/* !MSDOS */
#ifdef	YOUBIN
    key = youbin_getchar();
#else	/* !YOUBIN */
    key = getchar();
#endif	/* !YOUBIN */
#endif	/* !MSDOS */
  } while ((key == '\021') || (key == '\023'));	/* XON, XOFF */
  switch (escape) {
  case 0:
    if (key == 0x1b) {	/* ESC			*/
      escape = 1;
    }
    break;
  case 1:
    if ((key == '[') || (key == 'O')) {
      key = '[';	/* O ϥХɤǻȤΤ [ Ѵ */
      escape = 2;
    } else {
      escape = 0;
    }
    break;
  case 2:
    switch (key) {
    case 'A':
    case 'a':
      if (mask & LINE_MODE_MASK) {
	key = '\020';	/* ^P	*/
      } else if (!(mask & YN_MODE_MASK)) {
	key = 'k';
      }
      break;
    case 'B':
    case 'b':
      if (mask & LINE_MODE_MASK) {
	key = '\016';	/* ^N	*/
      } else if (!(mask & YN_MODE_MASK)) {
	key = 'j';
      }
      break;
    case 'C':
    case 'c':
      if (mask & LINE_MODE_MASK) {
	key = '\015';	/* RETURN	*/
      } else if (mask & YN_MODE_MASK) {
	key = 'y';
      } else {
	key = 'i';
      }
      break;
    case 'D':
    case 'd':
      if (mask & LINE_MODE_MASK) {
	key = '\025';	/* ^U		*/
      } else if (mask & YN_MODE_MASK) {
	key = 'n';
      } else {
	key = 'o';
      }
      break;
    default:
      break;
    }
    /* break  */
  default:
    escape = 0;
    break;
  }
  if (!escape) {
    if (mask & GLOBAL_MODE_MASK) {
      switch (key) {
      case 'A':		/* ASCII ⡼		*/
	print_code = ASCII_CODE;
	key = 0x0c;
	break;
      case 'E':		/* EUC ⡼		*/
	print_code = EUC_CODE;
	key = 0x0c;
	break;
      case 'J':		/* JIS ⡼		*/
	print_code = JIS_CODE;
	key = 0x0c;
	break;
      case 'S':		/* SJIS ⡼		*/
	print_code = SJIS_CODE;
	key = 0x0c;
	break;
      case 'x':		/* Ѹ/ܸ⡼	*/
	if (japanese = !japanese) {
	  x_nsubj_mode = x_nsubj_org;
	} else {
	  x_nsubj_mode = 0;
	}
	key = 0x0c;
	break;
#ifdef	MAILSEND
      case 'm':		/* ᡼		*/
	if (mask & NEWS_MODE_MASK) {
	  mail_send("", "");
	} else {
	  mail_send("", select_name);
	}
	key = 0x0c;
	break;
#endif	/* MAILSEND */
      case 'w':		/* 磻ɥ⡼		*/
	wide_mode = !wide_mode;
	head_lines = HEAD_LINES - wide_mode * 2;
	mode_lines = MODE_LINES - wide_mode * 2;
	key = 0x0c;
	break;
      case 0x1a:	/* ^Z ڥ	*/
	suspend();
	key = 0x0c;
	break;
      default:
	break;
      }
    }
#ifdef	MIME
    if (mask & GROUP_MODE_MASK) {
      if (key == 'M') {	/* MIMEեޥåȽ	*/
	mime_format = (mime_format + 1) % 3;
	set_mime_decode_func();
	key = 0x0c;
      }
    }
#endif	/* MIME */
    if (mask & SUBJECT_MODE_MASK) {
      if (key == 'h') {	/* եޥå	*/
	article_format = (article_format + 1) % 3;
	key = 0x0c;
      }
    }
  }
  return(key);
}

/*
 * ַ׻
 */

int	get_top_position(top_position, current_position, max_position,
			 thread_mode, ptr)
     int	top_position;
     int	current_position;
     int	max_position;
     short	thread_mode;
     char	*ptr;
{
  static char	sort_mode_char[] = {'S', 'R', 'D'};	/* ȥ⡼	*/
  register int	i, j;

  i = term_lines - mode_lines;
  j = ((current_position - i / 4) / (i / 2)) * (i / 2);
  if ((current_position < top_position) ||
      (current_position >= (top_position + i)) || (top_position < 0)) {
    top_position = j;
  }
  if (max_position > 0) {
    if ((i = ((top_position + i - 1) * 100) / max_position) >= 100) {
      if (top_position == 0) {
	strcpy(ptr, "All");
      } else {
	strcpy(ptr, "Bot");
      }
    } else {
      if (top_position == 0) {
	strcpy(ptr, "Top");
      } else {
	sprintf(ptr, "%2d%%", i);
      }
    }
  } else {
    strcpy(ptr, "---");
  }
  ptr += 3;
  *ptr++ = '[';
  *ptr++ = kanji_code_string[(int)print_code][0];
  *ptr++ = ':';
  *ptr++ = mime_form_char;
  *ptr++ = ':';
  *ptr++ = thread_mode ? sort_mode_char[sort_rule] : '-';
  *ptr++ = ']';
  *ptr = '\0';
  return(top_position);
}

/*
 * ᡼å
 */

int	check_new_mail()
{
#ifdef	IGNORE_MSGCHK
  return(1);
#else	/* !IGNORE_MSGCHK */
#if	defined(MH) || defined(RMAIL) || defined(UCBMAIL)
#ifdef	MSDOS
  return(0);
#else	/* !MSDOS */
#ifdef	YOUBIN
  extern int have_mail;

  youbin_poll();
  return(have_mail);
#else	/* !YOUBIN */
  static int	new_mail = 0;
  struct stat	stat_buff;
  char		buff[SMALL_BUFF];

#ifdef	USE_MSGCHK
  if (mh_chkmsg()) {
#else	/* !USE_MSGCHK */
  sprintf(buff, "%s%c%s", mail_spool, SLASH_CHAR, user_name);
  if ((!stat(buff, &stat_buff)) && (stat_buff.st_size > 0)) {
#endif	/* !USE_MSGCHK */
    if (!new_mail) {
      if (bell_mode) {
	term_bell();
      }
      new_mail = 1;
    }
    return(1);
  }
  new_mail = 0;
  return(0);
#endif	/* !YOUBIN */
#endif	/* !MSDOS */
#else	/* !(MH || RMAIL || UCBMAIL) */
  return(0);
#endif	/* !(MH || RMAIL || UCBMAIL) */
#endif	/* !IGNORE_MSGCHK */
}

/*
 * ڡ¹
 */

int	exec_pager(show_file, conv_file, mode, str)
     char	*show_file;
     char	*conv_file;
     int	mode;	/* 0:̵Ѵ 1:إå+Ѵ 2:Ѵ */
     char	*str;
{
  register int	status;
  char		buff[BUFF_SIZE];

  strcpy(guide_message, str);
  if (show_file) {
    if (pager_mode) {
      if (convert_code(show_file, conv_file, print_code, mode)) {
	funlink2(conv_file);
	return(1);
      }
    } else {
      if (mode) {
	if (convert_code(show_file, conv_file, EUC_CODE, mode)) {
	  funlink2(conv_file);
	  return(1);
	}
      } else {
#ifdef	JIS_INPUT
	conv_file = show_file;
	show_file = NULL;
#else	/* !JIS_INPUT */
	if (convert_code(show_file, conv_file, EUC_CODE, mode)) {
	  funlink2(conv_file);
	  return(1);
	}
#endif	/* !JIS_INPUT */
      }
    }
  }
  if (pager_mode) {
    term_clear_all();
#ifdef	MSDOS
    sprintf(buff, "%s %s", pager, conv_file);
#else	/* !MSDOS */
    sprintf(buff, "exec %s %s", pager, conv_file);
#endif	/* !MSDOS */
    if (status = term_system(buff)) {
      print_fatal("Pager error.");
    }
  } else {
    status = view_file(conv_file, 0);
  }
  if (show_file) {
    funlink2(conv_file);
  }
  return(status);
}

#if	defined(NEWSPOST) || defined(MAILSEND)
/*
 * ǥư
 */

int	exec_editor(edit_file, mode)
     char	*edit_file;
     int	mode;	/* 0:åʤ 0ʳ:å */
{
  struct stat	stat_buff1, stat_buff2;
  int	status;
  char	buff[BUFF_SIZE];
#ifdef	SELECT_EDITOR
  char	buff2[BUFF_SIZE];
#endif	/* !SELECT_EDITOR */

#ifdef	SELECT_EDITOR
  strcpy(buff2, edit_command);
  input_line(0, "ǥ:", "Editor:", buff2);
#ifdef	MSDOS
  sprintf(buff, "%s %s", buff2, edit_file);
#else	/* !MSDOS */
  sprintf(buff, "exec %s %s", buff2, edit_file);
#endif	/* !MSDOS */
#else	/* !SELECT_EDITOR */
#ifdef	MSDOS
  sprintf(buff, "%s %s", edit_command, edit_file);
#else	/* !MSDOS */
  sprintf(buff, "exec %s %s", edit_command, edit_file);
#endif	/* !MSDOS */
#endif	/* !SELECT_EDITOR */
#ifdef	DEBUG
  fprintf(stderr, "execute %s\n", buff);
  status = 0;
#else	/* !DEBUG */
  if (!stat(edit_file, &stat_buff1)) {
    status = term_system(buff);
#ifndef	IGNORE_EDITOR
    if (mode && !stat(edit_file, &stat_buff2)) {
      if ((stat_buff1.st_mtime == stat_buff2.st_mtime)
	  && (stat_buff1.st_size == stat_buff2.st_size)) {
	print_mode_line(japanese ? "ԽƤޤǤ" :
			"Not modified.");
	term_bell();
	sleep(ERROR_SLEEP);
	return(-1);
      }
    }
#endif	/* IGNORE_EDITOR */
  } else {
    status = -1;
  }
#endif	/* !DEBUG */
  term_clear_all();
  if (status) {
#ifdef	IGNORE_EDITOR
    status = 0;
#else	/* !IGNORE_EDITOR */
    print_fatal("Editor error.");
#endif	/* !IGNORE_EDITOR */
  }
  if (status) {
    print_mode_line(japanese ? "ǥεư˼Ԥޤ" :
		    "Execute editor failed.");
    term_bell();
    sleep(ERROR_SLEEP);
    return(1);
  }
  return(0);	/* return(status) ȤƤޤȤƤϤʤ */
}
#endif	/* NEWSPOST || MAILSEND */

/*
 * NNTP к³
 */

int	reopen_server()
{
  if (!mail_mode) {
    return(nntp_open(server_name));
  }
  return(1);
}

/*
 * ѥץ顼ϥɥ
 * (Broken Pipe)
 */

void	pipe_error()
{
  signal(SIGPIPE, SIG_IGN);
  print_fatal("Broken pipe.");
}

/*
 * λ
 */

void	force_exit()
{
  static int	exit_lock = 0;
  register int	i;

  /*
   * ȥեκ
   */

  if (!exit_lock) {
    exit_lock = 1;
    if (emerge_file[0]) {
      news_save_initfile(emerge_file);
    }
    for (i = 0; i < MAX_WRITE_FILE; i++) {
      if (write_file[i][0]) {
	unlink(write_file[i]);
      }
    }
    term_init(1);
    exit(1);
  }
}

/*
 * ե(kill 줿κб)
 */

FILE	*fopen2(file_name, mode)
     char	*file_name;
     char	*mode;
{
  FILE		*fp;
  int		status;
  register int	i;

  status = 1;
  if ((fp = fopen(file_name, mode)) != (FILE*)NULL) {
    chmod(file_name, S_IREAD | S_IWRITE);
    for (i = 0; i < MAX_WRITE_FILE; i++) {
      if (!write_file[i][0]) {
	strcpy(write_file[i], file_name);
	status = 0;
	break;
      }
    }
    if (status) {
      print_fatal("Program error.too many open files.");
    }
  }
  return(fp);
}

/*
 * ե(kill 줿κб)
 */

int	fclose2(file_name)
     char	*file_name;
{
  register int	i;

  for (i = 0; i < MAX_WRITE_FILE; i++) {
    if (!strcmp(write_file[i], file_name)) {
      write_file[i][0] = '\0';
      return(0);
    }
  }
  print_fatal("Program error.unexpected close file.");
  return(1);
}

/*
 * ե(kill 줿κб)
 */

int	funlink2(file_name)
     char	*file_name;
{
  register int	i;
  int		status;

  status = 1;
  for (i = 0; i < MAX_WRITE_FILE; i++) {
    if (!strcmp(write_file[i], file_name)) {
      write_file[i][0] = '\0';
      status = 0;
      break;
    }
  }
  if (status) {
    print_fatal("Program error.unexpected unlink file.");
  }
  return(unlink(file_name));
}

/*
 * EUC ʸ󥳥ԡ(TAB Ÿ)
 */

void	euc_tab_strncpy(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  register int	index;

  index = 0;
  while (count > 0) {
    if (*ptr2 == '\0') {
      break;
    }
    if (*ptr2 & 0x80) {
      if (count < 2) {
	count = 0;
      } else {
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	count -= 2;
	index += 2;
      }
    } else if (*ptr2 == '\t') {
      do {
	*ptr1++ = ' ';
	count--;
      } while ((++index % 8) && (count > 0));
      ptr2++;
    } else {
      *ptr1++ = *ptr2++;
      count--;
      index++;
    }
  }
  *ptr1 = '\0';
}

/*
 * إɽ(ưˡ)
 */

void	usage(mode)
     int	mode;
{
  fprintf(stderr, "Mini News Reader Version %s Copyright (C) %s By A.Takuma\n",
	  MNEWS_VERSION, MNEWS_DATE);
  if (mode) {
    fprintf(stderr, "Usage : %s [options]\n", prog_name);
    fprintf(stderr, "-e           print EUC mode.\n");
    fprintf(stderr, "-h           print help message.\n");
    fprintf(stderr, "-j           print JIS mode.\n");
    fprintf(stderr, "-m           toggle mail only mode.\n");
    fprintf(stderr, "-n newsgroup specify news group.\n");
    fprintf(stderr, "-s           print SJIS mode.\n");
    fprintf(stderr, "-v           print version.\n");
    fprintf(stderr, "-x           toggle Japanese/English mode.\n");
    fprintf(stderr, "-D server    specify NNTP server.\n");
    fprintf(stderr, "-N           toggle always NNTP mode.\n");
    fprintf(stderr, "See manual for other options.\n");
  } else {
#ifndef	MSDOS
    fprintf(stderr, "Install host,user,date:%s,%s,%s\n", install_host,
	    install_user, install_date);
    fprintf(stderr, "Construction :%s\n", cons_opt);
    fprintf(stderr, "Configuration:%s\n", conf_opt);
    fprintf(stderr, "Architecture :%s\n", arch_opt);
#endif	/* !MSDOS */
    fprintf(stderr, "Domain name  :%s\n", domain_name);
  }
}
