/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1992-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : Pager routine
 *  File        : pager.c
 *  Version     : 1.19
 *  First Edit  : 1992-08/05
 *  Last  Edit  : 1995-09/30
 *  Author      : MSR24  
 *
 */

#ifdef	PAGER
#include	"compat.h"
#ifdef	MNEWS
#include	"nntplib.h"
#include	"mnews.h"
#endif	/* MNEWS */
#include	"pager.h"
#include	"kanjilib.h"
#include	"termlib.h"

#ifndef	BUFF_SIZE
#define	BUFF_SIZE	1024
#endif	/* !BUFF_SIZE */
#ifndef	SMALL_BUFF
#define SMALL_BUFF	64
#endif	/* SMALL_BUFF */

static int	prev_line();		/* ԰ư			*/
static int	next_line();		/* ԰ư			*/
static int	search_line();		/* ԰ư			*/
static void	count_line();		/* ԰ּ			*/
static int	prev_position();	/* Լ			*/
static int	next_position();	/* Լ			*/
static int	forward_search();	/* 			*/
static int	backward_search();	/* 			*/
static void	view_all();		/* ɽ			*/
static int	view_top();		/* ɽ			*/
static int	view_bottom();		/* ɽ			*/
static int	fread_line();		/* ե 1 		*/
static int	fgets_prev();		/* եľ 1 	*/
static int	kanji_strposcpy();	/* ʸ󥳥ԡ(ɽ)	*/
static char	*kanji_strindex();	/* ʸ󸡺			*/

extern char	tmp_dir[];		/* ȥǥ쥯ȥ		*/
extern short	japanese;		/* ܸ⡼			*/
extern int	default_code;		/* Ƚǽδ	*/

int		last_key = 0;		/* ǸϤ		*/
#if	defined(MNEWS) || defined(MANEKIN)
char		guide_message[SMALL_BUFF];
#endif	/* MNEWS || MANEKIN */

static struct show_file {
  char		*file_name;
  FILE		*fp;
  int		line_number;
  int		valid_height;
  long		top_position, end_position, search_position, max_position;
  int		kanji_flag;
#ifdef	CTRL_L
  int		stop_flag;
#endif	/* CTRL_L */
} file_struct[MAX_SHOW_FILE + 1];	/* + 1 ϥإײ	*/

static int	line_number;
static int	valid_height;
static FILE	*fp;
static long	top_position, end_position, search_position;
static int	kanji_flag;
static int	kanji_strwidth = 0;	/* ʸ		*/
#ifdef	CTRL_L
static int	stop_flag;
#endif	/* CTRL_L */

static char	*pager_jmessage[] = {
#ifdef	MNEWS
  "ڡ㡼⡼\n\n",
#else	/* !MNEWS */
  "إץ⡼\n\n",
#endif	/* !MNEWS */
  "\tb ޤ ^B     ̤ɽޤ(Կǽ)\n",
#ifdef	MNEWS
  "\t^F              ̤ɽޤ(Կǽ)\n",
#else	/* !MNEWS */
  "\tf ޤ ^F     ̤ɽޤ(Կǽ)\n",
#endif	/* !MNEWS */
  "\tSPACE           ̤ɽǸʤ齪λޤ(Կǽ)\n",
  "\tk, y ޤ ^P  ιԤɽޤ\n",
  "\te, j, ^N ޤ RETURN\n",
  "\t                ιԤɽޤ\n",
  "\tg               Ƭɽޤ(ֹǽ)\n",
  "\tG               Ǹɽޤ(ֹǽ)\n",
#ifdef	MNEWS
  "\t^U              Ⱦڡɽޤ(Կǽ)\n",
  "\t^D              Ⱦڡɽޤ(Կǽ)\n",
  "\tp               ̤ɵɽޤ\n",
  "\tn               ̤ɵɽޤ\n",
  "\tP               εɽޤ\n",
  "\tN               εɽޤ\n",
  "\tD               ޡ̤ɵɽޤ\n",
  "\td               ޡƼ̤ɵɽޤ\n",
  "\tU               ޡεɽޤ\n",
  "\tu               ޡƼεɽޤ\n",
  "\tf               ˥եޤ(˥塼⡼ɻΤ)\n",
  "\tF               Ѥƥեޤ(˥塼⡼ɻΤ)\n",
  "\tr               ֿޤ\n",
  "\tR               Ѥֿޤ\n",
  "\tv ޤ V      ƤΥإåȤȤ˵ɽޤ\n",
  "\t                ('V'  MIME ǥб)\n",
  "\t^               ե󥹤򻲾Ȥޤ(˥塼⡼ɻΤ)\n",
#else	/* !MNEWS */
  "\tu ޤ ^U     Ⱦڡɽޤ(Կǽ)\n",
  "\td ޤ ^D     Ⱦڡɽޤ(Կǽ)\n",
  "\tp                PATTERN 򼡸ޤ\n",
  "\tn                PATTERN 򼡸ޤ\n",
  "\tP               Υե򻲾Ȥޤ\n",
  "\tN               Υե򻲾Ȥޤ\n",
#endif	/* !MNEWS */
  "\t=               ֹɽޤ\n",
  "\t/PATTERN         PATTERN 򸡺ޤ\n",
  "\t\\PATTERN         PATTERN 򸡺ޤ\n",
#ifdef	MNEWS
  "\t^L              ɽޤ\n",
#else	/* !MNEWS */
  "\tR, r ޤ ^L  ɽޤ\n",
#endif	/* !MNEWS */
  "\t^Z              ڥɤޤ\n",
  "\t?               إɽޤ\n",
  "\tA               ɽ򥳡̵ѴǹԤʤޤ\n",
  "\tE               ɽ EUC ɤǹԤʤޤ\n",
  "\tJ               ɽ JIS ɤǹԤʤޤ\n",
  "\tS               ɽ SJIS ɤǹԤʤޤ\n",
  "\to, q ޤ Q   ڡλޤ\n",
  NULL,
};

static char	*pager_message[] = {
#ifndef	SMALL
#ifdef	MNEWS
  "PAGER MODE\n\n",
#else	/* !MNEWS */
  "HELP MODE\n\n",
#endif	/* !MNEWS */
  "\tb or ^B      previous page.(You can specify lines.)\n",
#ifdef	MNEWS
  "\t^F           next page.(You can specify lines.)\n",
#else	/* !MNEWS */
  "\tf or ^F      next page.(You can specify lines.)\n",
#endif	/* !MNEWS */
  "\tSPACE        next page,last then quit.(You can specify lines.)\n",
  "\tk, y, or ^P  previous line.\n",
  "\te, j, ^N or RETURN\n",
  "\t             next line.\n",
  "\tg            top screen.(You can specify line-number.)\n",
  "\tG            last screen.(You can specify line-number.)\n",
#ifdef	MNEWS
  "\t^U           show previous half page.(You can specify lines.)\n",
  "\t^D           show next half page.(You can specify lines.)\n",
  "\tp            previous unread article.\n",
  "\tn            next unread article.\n",
  "\tP            previous article.\n",
  "\tN            next article.\n",
  "\tD            mark article and move to previous unread.\n",
  "\td            mark article and move to next unread.\n",
  "\tU            unmark article and move to previous.\n",
  "\tu            unmark article and move to next.\n",
  "\tf            follow.\n",
  "\tF            follow with original article.\n",
  "\tr            reply.\n",
  "\tR            reply with original article.\n",
  "\tv or V       read article with all header.\n",
  "\t             ('V' decode MIME header.)\n",
  "\t^            read referece article.(When news mode only)\n",
#else	/* !MNEWS */
  "\tu or ^U      show previous half page.\n",
  "\td or ^D      show next half page.\n",
  "\tp            backward next search PATTERN.\n",
  "\tn            forward next search PATTERN.\n",
  "\tP            show previous file.\n",
  "\tN            show next file.\n",
#endif	/* !MNEWS */
  "\t=            show line number.\n",
  "\t\\PATTERN     backward search PATTERN.\n",
  "\t/PATTERN     forward search PATTERN.\n",
#ifdef	MNEWS
  "\t^L           redisplay screen.\n",
#else	/* !MNEWS */
  "\tR, r or ^L   redisplay screen.\n",
#endif	/* !MNEWS */
  "\t^Z           suspend.\n",
  "\t?            show help screen.\n",
  "\tA            print Japanese no conversion.\n",
  "\tE            print Japanese EUC code.\n",
  "\tJ            print Japanese JIS code.\n",
  "\tS            print Japanese SJIS code.\n",
  "\to, q or Q    quit PAGER.\n",
#endif	/* !SMALL */
  NULL,
};

/*
 * ե뻲
 */

int	view_file(file_name, offset)
     char	*file_name;
     int	offset;
{
  return(view_files(&file_name, 1, offset));
}

/*
 * ʣե뻲
 */

int	view_files(file_names, number, offset)
     char	*file_names[];
     int	number;
     int	offset;
{
  struct stat	stat_buff;
  char		key_buff[SMALL_BUFF];
  char		search_buff[SMALL_BUFF];
  char		help_file[PATH_BUFF];
  char		guide_buff[BUFF_SIZE];
  char		*file_name;
  char		*error_msg;
  char		**message;
  char		*ptr;
  int		key_code;
  int		key_index;
  int		loop;
  int		status;
  int		file;
  int		old_number;
  int		help_mode;
  long		max_position;
  int		reverse_flag;

  last_key = 0;
#ifdef	CTRL_L
  stop_flag = 0;
#endif	/* CTRL_L */
  kanji_flag = 0;
  if (number >= MAX_SHOW_FILE) {
    print_fatal("Too many files.");
    number = MAX_SHOW_FILE;
  }

  /*
   * ե륪ץ
   */

  sprintf(help_file, "%s%cmless_H.%d", tmp_dir, SLASH_CHAR, getpid());
  for (loop = file = 0; loop < number + 1; loop++) {
    if (loop == number) {
      file_name = help_file;
      fp = NULL;
    } else {
      file_name = file_names[loop];
#ifdef	MSDOS
      if ((fp = fopen(file_name, "rb")) == (FILE*)NULL) {
#else	/* !MSDOS */
      if ((fp = fopen(file_name, "r")) == (FILE*)NULL) {
#endif	/* !MSDOS */
	print_fatal("Can't open \"%s\".", file_names[loop]);
	continue;
      }
    }
    file_struct[file].fp              = fp;
    file_struct[file].file_name       = file_name;
    file_struct[file].line_number     = 0;
    file_struct[file].valid_height    = -1;
    file_struct[file].top_position    = 0L;
    file_struct[file].end_position    = 0L;
    file_struct[file].search_position = -1L;
    file_struct[file].kanji_flag      = 0;
#ifdef	CTRL_L
    file_struct[file].stop_flag       = 0;
#endif	/* CTRL_L */
    file++;
  }
  if (--file <= 0) {
    print_fatal("No valid file.");
    return(-1);
  }

  /*
   * ե뻲
   */

  number = 0;
  help_mode = 0;
  while (1) {
    old_number = number;
    file_name       = file_struct[number].file_name;
    fp              = file_struct[number].fp;
    line_number     = file_struct[number].line_number;
    valid_height    = file_struct[number].valid_height;
    top_position    = file_struct[number].top_position;
    end_position    = file_struct[number].end_position;
    search_position = file_struct[number].search_position;
    kanji_flag      = file_struct[number].kanji_flag;
    max_position    = -2L;	/* -1  end_position ӤΤԲ */
#ifdef	CTRL_L
    stop_flag       = file_struct[number].stop_flag;
#endif	/* CTRL_L */
    if ((number == file) && (!file_struct[number].fp)) {
      fp = fopen(file_name, "w");
      if (japanese) {
	message = pager_jmessage;
      } else {
	message = pager_message;
      }
      while (*message) {
	fprintf(fp, *message);
	message++;
      }
#ifdef	MSDOS
      fp = freopen(file_name, "rb", fp);
#else	/* !MSDOS */
      fp = freopen(file_name, "r", fp);
#endif	/* !MSDOS */
      if (!stat(file_name, &stat_buff)) {
	max_position = (long)stat_buff.st_size;
      }
      unlink(file_name);
      if (!(file_struct[number].fp = fp)) {
	number = 0;
	continue;
      }
    }
    error_msg = NULL;
    if (valid_height < 0) {
      valid_height = 0;
      search_line(offset);
    }
    view_all();
    loop = 1;
    key_index = 0;
    key_buff[0] = search_buff[0] = '\0';
    search_position = -1L;
    while (loop > 0) {
      term_locate(0, term_lines - 1);
      term_clear_end();
      reverse_flag = 1;
      if (error_msg) {
	strcpy(guide_buff, error_msg);
	error_msg = NULL;
      } else {
	if (key_index > 0) {
	  reverse_flag = 0;
	  strcpy(guide_buff, key_buff);
	} else {
#ifdef	DEBUG
#ifdef	CTRL_L
	  sprintf(guide_buff,
		  "(LN=%d,TP=%d,EP=%d,SF=%d,SP=%d,VH=%d,ST=%d,SB=%s)",
		  line_number, (int)top_position, (int)end_position, stop_flag,
		  (int)search_position, valid_height, status, search_buff);
#else	/* !CTRL_L */
	  sprintf(guide_buff,
		  "(LN=%d,TP=%d,EP=%d,SP=%d,VH=%d,ST=%d,SB=%s)",
		  line_number, (int)top_position, (int)end_position,
		  (int)search_position, valid_height, status, search_buff);
#endif	/* !CTRL_L */
#else	/* !DEBUG */
	  if (line_number <= 0) {
	    count_line();
	  }
	  if (end_position < 0L) {
	    next_line(0);
	  }
	  if (max_position < 0L) {
	    if (!stat(file_name, &stat_buff)) {
	      max_position = (long)stat_buff.st_size;
	    }
	  }
#if	defined(MNEWS) || defined(MANEKIN)
	  sprintf(guide_buff, "[%s] line:%d byte:%d",
		  guide_message, line_number, (int)end_position);
#else	/* !(MNEWS || MANEKIN) */
	  sprintf(guide_buff, "%s line:%d byte:%d",
		  file_name, line_number, (int)end_position);
#endif	/* !(MNEWS || MANEKIN) */
	  ptr = guide_buff;
	  while (*ptr) {
	    ptr++;
	  }
	  if (max_position > 0L) {
	    sprintf(ptr, "/%ld", (long)max_position);
	    while (*ptr) {
	      ptr++;
	    }
	  }
	  if (feof(fp) || (end_position == max_position)) {
	    strcpy(ptr, " (END)");
	  } else {
	    if (max_position <= 0L) {
	      strcpy(ptr, " (UNKNOWN)");
	    } else {
	      sprintf(ptr, " %d%%", (int)(end_position * 100L / max_position));
	    }
	  }
#endif	/* !DEBUG */
	}
      }
      guide_buff[term_columns] = '\0';
      if (reverse_flag) {
#ifdef	MNEWS
	term_attrib(color_code[GUIDE_COLOR]);
	printf("%s", guide_buff);
	term_attrib(RESET_ATTRIB);
#else	/* !MNEWS */
	term_attrib(7);
	printf("%s", guide_buff);
	term_attrib(0);
#endif	/* !MNEWS */
      } else {
	printf("%s", guide_buff);
      }
      fflush(stdout);
      last_key = key_code = get_key(0);
      if (isdigit(key_code)) {
	if (key_index < 8) {
	  key_buff[key_index++] = key_code;
	  key_buff[key_index] = '\0';
	}
      } else if (((key_code == 0x7f) ||
		  (key_code == 0x08)) && (key_index > 0)) {
	key_buff[--key_index] = '\0';
      } else {
	offset = atoi(key_buff);
	switch (key_code) {
	case 'Q':		/* λ			*/
	case 'q':
	case 'o':
#ifdef	MNEWS
	case 'p':
	case 'P':
	case 'n':
	case 'N':
	case 'd':
	case 'u':
	case 'D':
	case 'U':
	case 'v':
	case 'V':
	case '^':
	case 'F':
	case 'f':
	case 'R':
	case 'r':
#endif	/* MNEWS */
	  if (help_mode) {
	    number = help_mode - 1;
	    help_mode = 0;
	    loop = -1;
	  } else {
	    loop = 0;
	  }
	  break;
#ifndef	MNEWS
	case 'P':		/* ե뻲	*/
	  if (!help_mode) {
	    if (number > 0) {
	      number--;
	      loop = -1;
	    } else {
	      error_msg = "No previous file.";
	    }
	  }
	  break;
	case 'N':		/* ե뻲	*/
	  if (!help_mode) {
	    if (number < (file - 1)) {
	      number++;
	      loop = -1;
	    } else {
	      error_msg = "No next file.";
	    }
	  }
	  break;
#endif	/* !MNEWS */
	case 0x02:		/* ^B 			*/
	case 'b':		/* ڡư		*/
	  if (offset > 0) {
	    status = offset;
	  } else {
	    status = term_lines - 1;
	  }
	  if (status = prev_line(status)) {
	    if (status >= (term_lines - 1)) {
	      view_all();
	    } else {
	      view_top(status);
	    }
	  }
	  break;
	case ' ':		/* ڡư		*/
	  if (feof(fp) || (end_position == max_position)) {
	    if (help_mode) {
	      number = help_mode - 1;
	      help_mode = 0;
	      loop = -1;
	    } else {
	      if (number < (file - 1)) {
		number++;
		loop = -1;
	      } else {
		loop = 0;
	      }
	    }
	    break;
	  }
	  /* break  */
	case 0x06:		/* ^F			*/
#ifndef	MNEWS
	case 'f':
#endif	/* !MNEWS */
	  if (offset > 0) {
	    status = offset;
	  } else {
	    status = term_lines - 1;
	  }
	  status = view_bottom(status);
	  break;
	case 0x10:		/* ^P			*/
	case 'y':
	case 'k':
	  if (status = prev_line(1)) {
	    view_top(status);
	  }
	  break;
	case 'e':
	case 'j':
	case 0x0e:		/* ^N			*/
	case '\015':		/* RETURN		*/
	case '\n':
	  status = view_bottom(1);
	  break;
	case 'g':
	case '<':		/* Ƭ˰ư		*/
	  if (offset > 0) {
	    search_line(offset);
	  } else {
	    top_position = 0L;
	    end_position = -1L;
	    line_number = 1;
	  }
	  view_all();
	  break;
	case 'G':
	case '>':		/* Ǹ˰ư		*/
	  if (offset > 0) {
	    search_line(offset);
	    view_all();
	  } else {
	    top_position = -1L;
	    end_position = max_position;
	    line_number = -1;
	    prev_line(0);
	    view_top(term_lines - 1);
	  }
	  break;
#ifndef	MNEWS
	case 'u':
#endif	/* !MNEWS */
	case 0x15:		/* ^U Ⱦڡ	*/
	  if (offset > 0) {
	    status = offset;
	  } else {
	    status = (term_lines - 1) / 2;
	  }
	  if (status = prev_line(status)) {
	    if (status >= (term_lines - 1)) {
	      view_all();
	    } else {
	      view_top(status);
	    }
	  }
	  break;
#ifndef	MNEWS
	case 'd':
#endif	/* !MNEWS */
	case 0x04:		/* ^D Ⱦڡ	*/
	  if (offset > 0) {
	    status = offset;
	  } else {
	    status = (term_lines - 1) / 2;
	  }
	  status = view_bottom(status);
	  break;
	case '=':		/* ֹɽ		*/
	  count_line();
	  break;
	case 0x1a:		/* ^Z ڥ	*/
	  suspend();
	  
	  /* break  ^L ΤĤ³ƺ */
	  
#ifndef	MNEWS
	case 'R':
	case 'r':
#endif	/* !MNEWS */
	case 0x0c:		/* ^L 		*/
	  view_all();
	  break;
	case '\\':		/* 		*/
	case '/':		/* 		*/
	  key_index = 0;
	  key_buff[0] = '\0';
	  while (1) {
	    term_locate(0, term_lines - 1);
	    term_clear_end();
	    printf("%c%s", key_code, key_buff);
#ifdef	MSDOS
	    offset = getch();
#else	/* !MSDOS */
#ifdef	YOUBIN
	    offset = youbin_getchar();
#else	/* !YOUBIN */
	    offset = getchar();
#endif	/* !YOUBIN */
#endif	/* !MSDOS */
	    if ((offset == '\015') || (offset == '\n')) { /* RETURN	*/
	      break;
	    } else if (((offset == 0x7f) || (offset == 0x08))
		       && (key_index > 0)) {
	      key_buff[--key_index] = '\0';
	      if (key_index <= 0) {
		search_buff[0] = '\0';
		break;
	      }
	    } else if (offset >= ' ') {
	      if (key_index < term_columns - 4) {
		key_buff[key_index++] = offset;
		key_buff[key_index] = '\0';
	      }
	    }
	  }
	  if (key_index > 0) {
	    search_position = -1L;
	    strcpy(search_buff, key_buff);
	  }
	  /* break  */
#ifndef	MNEWS
	case 'p':		/* 		*/
	case 'n':		/* 		*/
#endif	/* !MNEWS */
	  if (search_buff[0]) {
	    if ((key_code == '/') || (key_code == 'n')) {
	      status = forward_search(search_buff);
	    } else {
	      status = backward_search(search_buff);
	    }
	    if (status) {
	      view_all();
	    } else {
	      error_msg = "Pattern not found.";
	    }
	  }
	  break;
	case '?':		/* إɽ		*/
	  if (!help_mode) {
	    help_mode = number + 1;
	    number = file;
	    loop = -1;
	  } else {
	    error_msg = "Already help mode.";
	  }
	  break;
	case 'A':		/* ASCII ⡼		*/
	  print_code = ASCII_CODE;
	  view_all();
	  break;
	case 'E':		/* EUC ⡼		*/
	  print_code = EUC_CODE;
	  view_all();
	  break;
	case 'J':		/* JIS ⡼		*/
	  print_code = JIS_CODE;
	  view_all();
	  break;
	case 'S':		/* SJIS ⡼		*/
	  print_code = SJIS_CODE;
	  view_all();
	  break;
	default:
	  break;
	}
	key_index = 0;
	key_buff[0] = '\0';
      }
    }
    if (!loop) {
      break;
    }
    if (old_number != file) {
      file_struct[old_number].line_number     = line_number;
      file_struct[old_number].valid_height    = valid_height;
      file_struct[old_number].top_position    = top_position;
      file_struct[old_number].end_position    = end_position;
      file_struct[old_number].search_position = search_position;
      file_struct[old_number].kanji_flag      = kanji_flag;
#ifdef	CTRL_L
      file_struct[old_number].stop_flag       = stop_flag;
#endif	/* CTRL_L */
    }
  }
  term_locate(0, term_lines - 1);
  term_clear_end();
  for (loop = 0; loop <= file; loop++) {
    if (file_struct[loop].fp) {
      fclose(file_struct[loop].fp);
    }
  }
  return(0);
}

/*
 * ԰ư
 */

static int	prev_line(number)
     int	number;
{
  int	status;

  status = 0;
  if (top_position < 0L) {
    if (end_position >= 0L) {
      fseek(fp, end_position, 0);
      prev_position(valid_height);
      top_position = ftell(fp);
    }
  } else {
    fseek(fp, top_position, 0);
  }
#ifdef	LOG_DEBUG
  print_fatal("ENTER prev_line() TOP=%d, END=%d",
	      (int)top_position, (int)end_position);
#endif	/* LOG_DEBUG */
  if (top_position >= 0L) {
    if (status = prev_position(number)) {
      top_position = ftell(fp);
      end_position = -1L;
      line_number = -1;
    }
  } else {
    print_fatal("Program error at prev_line.");
  }
#ifdef	LOG_DEBUG
  print_fatal("RETURN prev_line() TOP=%d, END=%d",
	      (int)top_position, (int)end_position);
#endif	/* LOG_DEBUG */
  return(status);
}

/*
 * ԰ư
 */

static int	next_line(number)
     int	number;
{
  int	status;

  status = 0;
  if (end_position < 0L) {
    if (top_position >= 0L) {
      fseek(fp, top_position, 0);
      next_position(valid_height);
      end_position = ftell(fp);
    }
  } else {
    fseek(fp, end_position, 0);
  }
#ifdef	LOG_DEBUG
  print_fatal("ENTER next_line() TOP=%d, END=%d",
	      (int)top_position, (int)end_position);
#endif	/* LOG_DEBUG */
  if (end_position >= 0L) {
    if (status = next_position(number)) {
      top_position = -1L;
      end_position = ftell(fp);
      line_number = -1;
    }
  } else {
    print_fatal("Program error at next_line.");
  }
#ifdef	LOG_DEBUG
  print_fatal("RETURN next_line() TOP=%d, END=%d",
	      (int)top_position, (int)end_position);
#endif	/* LOG_DEBUG */
  return(status);
}

/*
 * ԰ư
 */

static int	search_line(number)
     int	number;
{
  char	buff[BUFF_SIZE];
  int	status;

  status = 0;
  fseek(fp, 0L, 0);
  line_number = 1;
  while (--number > 0) {
    if (fread_line(buff, sizeof(buff), fp)) {
      break;
    }
    line_number++;
    status++;
  }
  top_position = ftell(fp);
  end_position = -1L;
  return(status);
}

/*
 * ԰ּ
 */

static void	count_line()
{
  char	buff[BUFF_SIZE];

  line_number = 0;
  prev_line(0);
  fseek(fp, 0L, 0);
  line_number = 0;
  while (!fread_line(buff, sizeof(buff), fp)) {
    line_number++;
    if (top_position < ftell(fp)) {
      break;
    }
  }
}

/*
 * Լ(̴ؿ)
 */

static int	prev_position(number)
     int	number;
{
  char		buff1[BUFF_SIZE + 1];
  char		buff2[BUFF_SIZE];
#ifdef	notdef
  char		*ptr1 = buff1;
  int		status;
  int		first;
  int		noread;		/* flag for no fread() */
  register int	length1, length2, length3;
  long		last_pos;	/* last position */
  long		pos_save;	/* saved position */
  register long	position;

  status = 0;
  if ((last_pos = position = ftell(fp)) <= 0L) {
    return(status);
  }

  kanji_flag = 0;
  noread = 0;
  while (number-- > 0 && position > 0L) {

    /*
     * ľιƬ򸡺롣
     */

    first = 1;
    while (position > 0L) {
      if (noread) {
	length1 = ptr1 - buff1;
	position -= length1;
	noread = 0;
      } else {
	if (position < (sizeof(buff1) - 1)) {
	  length1 = position;
	} else {
	  length1 = sizeof(buff1) - 1;
	}
	position -= length1;
	fseek(fp, position, 0);
	for (length2 = 0; length2 < length1; length2 += length3) {
	  length3 = fread(buff1 + length2, 1, length1 - length2, fp);
	  if (!length3) {
	    break;
	  }
	}
      }
      buff1[length1] = '\0';
      if (first && buff1[length1 - 1] == '\n') {
	buff1[length1 - 1] = '\0';
	last_pos--;
      }
      if ((ptr1 = strrchr(buff1, '\n'))) {
	ptr1++;				/* ptr1: top of line in buff1 */
	position += (ptr1 - buff1);	/* position: top of the line */
	break;
      }
      first = 0;
    }

    /*
     * positon = Ƭ
     */

    noread = first;	/* OPTIMIZE: use old buffer if "first" */
    if (!noread) {
      fseek(fp, position, 0);
    }

    /*
     * find the position to display
     */

    length3 = 0;
    do {
      ptr1 += length3;

      /* terminal width < 1000 ... I think.... */

      if (!noread) {		/* OPTIMIZE */
	if ((position - last_pos) <=  (sizeof(buff1) - 1)) {
	  length1 = position - last_pos;
	  noread = 1;		/* OPTIMIZE: last read */
	} else {
	  length1 = sizeof(buff1) - 1;
	}
	for (length2 = 0; length2 < length1; length2 += length3) {
	  length3 = fread(buff1 + length2, 1, length1 - length2, fp);
	  if (!length3)
	    break;
        }
	ptr1 = buff1;
	buff1[length1] = '\0';
      }				/* OPTIMIZE */
      pos_save = position;
      length3 = kanji_strposcpy(buff2, ptr1, term_columns);
      position += length3;
    } while (position < last_pos);

    /*
     * OPTIMIZE: If some bytes remain in buff1, reuse them.
     */

    noread = (ptr1 > buff1);

    /*
     * now "position" is the display position
     */

    status++;
    last_pos = position = pos_save;
  }

  /*
   * move
   */

  fseek(fp, position, 0);
#else	/* !notdef */
  char		*ptr1, *ptr2;
  int		status;
  int		first;
  register int	length1, length2, length3;
  register long	position;

  status = 0;
  if ((position = ftell(fp)) <= 0) {
    return(status);
  }

  /*
   * 鲼ν¢ڡ㡼ǺǤʬǤ
   * Լθ夫鸫뵤ⵯʤۤɤ˽Ǥͤ
   */

  kanji_flag = 0;
  while (number-- > 0) {
#ifdef	LOG_DEBUG
    print_fatal("WHILE prev_position() NUM=%d POSITION=%d",
		number, position);
#endif	/* LOG_DEBUG */
    length1 = 0;
    first = 1;
    while (1) {
      if (!length1) {
	if (position <= 0L) {
	  position = 0L;
	  number = 0;
	  status++;
	  break;
	} else if (position > (long)(sizeof(buff1) - 1)) {
	  length1 = sizeof(buff1) - 1;
	} else {
	  length1 = position;
	}
	position -= length1;
	fseek(fp, position, 0);
	length2 = 0;
	while (length2 < length1) {
	  length3 = fread(&buff1[length2], 1, length1 - length2, fp);
	  if (!length3) {
	    break;
	  }
	  length2 += length3;
	}
	if (buff1[length1 - 1] != '\n') {
	  buff1[length1] = '\0';
	  first = 0;
	}
      } else if (buff1[length1] == '\n') {	/* ̤Զ	*/
	if (first) {
	  buff1[length1] = '\0';
	  first = 0;
	  length1--;
	} else {
	  length1++;
	  number++;
	  while (number-- > 0) {
	    length2 = 0;
	    ptr1 = &buff1[length1];
	    status++;
	    while (1) {
	      ptr2 = ptr1;
	      first = kanji_strposcpy(buff2, ptr1, term_columns);
	      ptr1 += first;
	      if (!*ptr1) {
		break;
	      }
	      length2 += first;
	    }
	    *ptr2 = '\0';
	    if (!buff1[length1]) {
	      break;
	    }
	  }
	  position += (length1 + length2);
	  break;
	}
      } else {
	if (--length1 == 0) {
	  if (position == 0L) {
	    number++;
	    while (number-- > 0) {
	      length2 = 0;
	      ptr1 = &buff1[length1];
	      status++;
	      while (1) {
		ptr2 = ptr1;
		first = kanji_strposcpy(buff2, ptr1, term_columns);
		ptr1 += first;
		if (!*ptr1) {
		  break;
		}
		length2 += first;
	      }
	      *ptr2 = '\0';
	      if (!buff1[length1]) {
		break;
	      }
	    }
	    position += (length1 + length2);
	    number = 0;
	    break;
	  }
	}
      }
    }
    fseek(fp, position, 0);
#ifdef	LOG_DEBUG
    print_fatal("WEND  prev_position() NUM=%d POSITION=%d",
		number, (int)position);
#endif	/* LOG_DEBUG */
  }
#endif	/* !notdef */
  return(status);
}

/*
 * Լ(̴ؿ)
 */

static int	next_position(number)
     int	number;
{
  register int	status;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr;
  long		position;

  status = 0;
  kanji_flag = 0;
  ptr = buff1;
  *ptr = '\0';
  while (number-- > 0) {
    if (!*ptr) {
      position = ftell(fp);
      ptr = buff1;
      if (fread_line(buff1, sizeof(buff1), fp)) {
	return(status);
      }
    }
    status++;
#ifdef	LOG_DEBUG
    print_fatal("WHILE next_position() NUM=%d POSITION=%d",
		number, (int)position);
#endif	/* LOG_DEBUG */
    ptr += kanji_strposcpy(buff2, ptr, term_columns);
    if (!*ptr) {
      position++;
    }
#ifdef	LOG_DEBUG
    print_fatal("WEND  next_position() NUM=%d POSITION=%d",
		number, (int)position);
#endif	/* LOG_DEBUG */
  }
  if (status) {
    fseek(fp, (long)(position + ptr - buff1), 0);
  }
  return(status);
}

/*
 * 
 */

static int	forward_search(string)
     char	*string;
{
  char	buff[BUFF_SIZE];
  int	status;

  status = 0;
  prev_line(0);
  if (search_position == top_position) {
    next_position(1);
  }
  while (1) {
    if (fread_line(buff, sizeof(buff), fp)) {
      break;
    }
    if (kanji_strindex(buff, string)) {
      prev_position(1);
      top_position = ftell(fp);
      end_position = -1L;
      status = 1;
      break;
    }
  }
  if (status) {
    search_position = top_position;
  } else {
    prev_line(0);
  }
  return(status);
}

/*
 * 
 */

static int	backward_search(string)
     char	*string;
{
  char	buff[BUFF_SIZE];
  int	status;

  status = 0;
  prev_line(0);
  while (!fgets_prev(buff, fp)) {
    if (kanji_strindex(buff, string)) {
      top_position = ftell(fp);
      end_position = -1L;
      status = 1;
      break;
    }
  }
  if (status) {
    search_position = top_position;
  } else {
    prev_line(0);
  }
  return(status);
}

/*
 * ɽ
 */

static void	view_all()
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr1;
#ifdef	CTRL_L
  char		*ptr2;
#endif	/* CTRL_L */
  register int	i, j;

  term_clear_all();
#ifdef	CTRL_L
  stop_flag = 0;
#endif	/* CTRL_L */
  ptr1 = buff1;
  *ptr1 = '\0';
  if (top_position < 0L) {
    prev_line(0);
  }
  valid_height = 0;
  kanji_flag = 0;
  fseek(fp, top_position, 0);
  end_position = top_position;
  for (i = 0; i < term_lines - 1; i++) {
    if (!*ptr1) {
      ptr1 = buff1;
      if (fread_line(buff1, sizeof(buff1), fp)) {
	term_clear_line();
	break;
      }
    }
#ifdef	CTRL_L
    ptr2 = ptr1;
    while (*ptr2) {
      if (*ptr2++ == 0x0c) {		/* ^L 	*/
	if (!*ptr2) {
	  stop_flag = valid_height + 1;
	}
	break;
      }
    }
#endif	/* CTRL_L */
    j = kanji_strposcpy(buff2, ptr1, term_columns);
    ptr1 += j;
    end_position += j;
#ifdef	TERMCAP
#ifdef	EUC_ONLY
    printf("%s", buff2);
#else	/* !EUC_ONLY */
#ifdef	JIS_INPUT
    kanji_printf(default_code, "%s", buff2);
#else	/* !JIS_INPUT */
    euc_printf("%s", buff2);
#endif	/* !JIS_INPUT */
#endif	/* !EUC_ONLY */
    term_crlf(kanji_strwidth);
#else	/* !TERMCAP */
#ifdef	EUC_ONLY
    printf("%s\r\n", buff2);
#else	/* !EUC_ONLY */
#ifdef	JIS_INPUT
    kanji_printf(default_code, "%s\r\n", buff2);
#else	/* !JIS_INPUT */
    euc_printf("%s\r\n", buff2);
#endif	/* !JIS_INPUT */
#endif	/* !EUC_ONLY */
#endif	/* !TERMCAP */
    if (!*ptr1) {
      end_position++;
    }
    valid_height++;
#ifdef	CTRL_L
    if (stop_flag) {
      break;
    }
#endif	/* CTRL_L */
  }
#ifdef	CTRL_L
  if (stop_flag) {
    end_position = -1L;
  }
#endif	/* !CTRL_L */
}

/*
 * ɽ
 */

static int	view_top(number)
     int	number;
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr1;
#ifdef	CTRL_L
  char		*ptr2;
#endif	/* CTRL_L */
  int		status;
  register int	i;

  status = 0;
  if (top_position < 0L) {
    prev_line(0);
  }
  term_locate(0, 0);
  for (i = 0; i < number; i++) {
    term_insert();
  }
  term_locate(0, 0);
  ptr1 = buff1;
  *ptr1 = '\0';
  fseek(fp, top_position, 0);
  kanji_flag = 0;
  for (i = 0; i < number; i++) {
#ifdef	TERMCAP
    if (i) {
      term_crlf(kanji_strwidth);
    }
#endif	/* TERMCAP */
    if (valid_height < (term_lines - 1)) {
      valid_height++;
    }
#ifdef	CTRL_L
    if (stop_flag > 0) {
      if (++stop_flag > (term_lines - 1)) {
	stop_flag = 0;
      }
    }
#endif	/* CTRL_L */
    if (!*ptr1) {
      ptr1 = buff1;
      if (fread_line(buff1, sizeof(buff1), fp)) {
	term_clear_line();
#ifdef	TERMCAP
	term_top();
#else	/* !TERMCAP */
	printf("\r");
#endif	/* !TERMCAP */
	continue;
      }
    }
#ifdef	CTRL_L
    ptr2 = ptr1;
    while (*ptr2) {
      if (*ptr2++ == 0x0c) {		/* ^L 	*/
	if (!*ptr2) {
	  stop_flag = valid_height + 1;
	}
	break;
      }
    }
#endif	/* CTRL_L */
    ptr1 += kanji_strposcpy(buff2, ptr1, term_columns);
#ifdef	TERMCAP
#ifdef	EUC_ONLY
    printf("%s", buff2);
#else	/* !EUC_ONLY */
#ifdef	JIS_INPUT
    kanji_printf(default_code, "%s", buff2);
#else	/* !JIS_INPUT */
    euc_printf("%s", buff2);
#endif	/* !JIS_INPUT */
#endif	/* !EUC_ONLY */
#else	/* !TERMCAP */
#ifdef	EUC_ONLY
    printf("%s\r\n", buff2);
#else	/* !EUC_ONLY */
#ifdef	JIS_INPUT
    kanji_printf(default_code, "%s\r\n", buff2);
#else	/* !JIS_INPUT */
    euc_printf("%s\r\n", buff2);
#endif	/* !JIS_INPUT */
#endif	/* !EUC_ONLY */
#endif	/* !TERMCAP */
    status++;
  }
  return(status);
}

/*
 * ɽ
 */

static int	view_bottom(number)
     int	number;
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr1;
#ifdef	CTRL_L
  char		*ptr2;
#endif	/* CTRL_L */
  int		status;
  register int	i, j;

  ptr1 = buff1;
  *ptr1 = '\0';
  status = 0;
  kanji_flag = 0;
#ifdef	CTRL_L
  if (stop_flag) {
    line_number = -1;
    if (number < stop_flag) {
      term_locate(0, term_lines - 1);
      term_clear_line();
      if (top_position < 0L) {
	prev_line(0);
      }
      fseek(fp, top_position, 0);
      next_position(number);
      end_position = -1L;
      top_position = ftell(fp);
      for (i = 0; i < number; i++) {
#ifdef	TERMCAP
	term_crlf(0);
#else	/* !TERMCAP */
	printf("\r\n");
#endif	/* !TERMCAP */
	valid_height--;
	stop_flag--;
	status++;
      }
    } else {
      if (end_position < 0L) {
	next_line(0);
      }
      top_position = end_position;
      end_position = -1L;
      view_all();
      status = valid_height;
    }
  } else {
#endif	/* CTRL_L */
    if (end_position < 0L) {
      next_line(0);
    }
    fseek(fp, end_position, 0);
    term_locate(0, valid_height);
    term_clear_line();
    for (i = 0; i < number; i++) {
#ifdef	CTRL_L
      if (stop_flag) {
#ifdef	TERMCAP
	term_crlf(0);
#else	/* !TERMCAP */
	printf("\r\n");
#endif	/* !TERMCAP */
	valid_height--;
	stop_flag--;
	continue;
      }
#endif	/* CTRL_L */
      if (!*ptr1) {
	ptr1 = buff1;
	if (fread_line(buff1, sizeof(buff1), fp)) {
#ifdef	SCROLL_LAST
	  if (!i) {
	    return(status);
	  }
	  *ptr1 = '\0';
	  printf("\r\n");
	  valid_height--;
	  continue;
#else	/* !SCROLL_LAST */
	  return(status);
#endif	/* !SCROLL_LAST */
	}
#ifdef	CTRL_L
	ptr2 = ptr1;
	while (*ptr2) {
	  if (*ptr2++ == 0x0c) {	/* ^L 	*/
	    if (!*ptr2) {
	      stop_flag = valid_height;
	    }
	    break;
	  }
	}
#endif	/* CTRL_L */
	top_position = -1L;
	line_number = -1;
      }
      j = kanji_strposcpy(buff2, ptr1, term_columns);
      ptr1 += j;
      end_position += j;
#ifdef	TERMCAP
#ifdef	EUC_ONLY
      printf("%s", buff2);
#else	/* !EUC_ONLY */
#ifdef	JIS_INPUT
      kanji_printf(default_code, "%s", buff2);
#else	/* !JIS_INPUT */
      euc_printf("%s", buff2);
#endif	/* !JIS_INPUT */
#endif	/* !EUC_ONLY */
      term_crlf(kanji_strwidth);
#else	/* !TERMCAP */
#ifdef	EUC_ONLY
      printf("%s\r\n", buff2);
#else	/* !EUC_ONLY */
#ifdef	JIS_INPUT
      kanji_printf(default_code, "%s\r\n", buff2);
#else	/* !JIS_INPUT */
      euc_printf("%s\r\n", buff2);
#endif	/* !JIS_INPUT */
#endif	/* !EUC_ONLY */
#endif	/* !TERMCAP */
      if (!*ptr1) {
	end_position++;
      }
      status++;
    }
#ifdef	CTRL_L
  }
#endif	/* CTRL_L */
  return(status);
}

/*
 * ե 1 ( LF )
 */

static int	fread_line(ptr, size, fp)
     char	*ptr;
     int	size;
     FILE	*fp;
{
  if (!fgets(ptr, size, fp)) {
    *ptr = '\0';
    return(1);
  }
  while (*ptr) {
    if (*ptr == '\n') {
      *ptr = '\0';
      break;
    }
    ptr++;
  }
  return(0);
}

/*
 * եľ 1 
 */

static int	fgets_prev(ptr, fp)
     char	*ptr;
     FILE	*fp;
{
  char		buff1[BUFF_SIZE + 1];
  int		first;
  register int	length1, length2;
  register long	position;

  if ((position = ftell(fp)) <= 0) {
    return(1);
  }
  length1 = 0;
  first = 1;
  while (1) {
    if (!length1) {
      if (position <= 0L) {
	position = 0L;
	break;
      } else if (position > (sizeof(buff1) - 1)) {
	length1 = sizeof(buff1) - 1;
      } else {
	length1 = position;
      }
      position -= length1;
      fseek(fp, position, 0);
      length2 = 0;
      while (length2 < length1) {
	length2 = length2 + fread(&buff1[length2], 1, length1 - length2, fp);
      }
      if (buff1[length1 - 1] != '\n') {
	buff1[length1] = '\0';
	first = 0;
      }
    } else if (buff1[length1] == '\n') {
      if (first) {
	buff1[length1] = '\0';
	first = 0;
	length1--;
      } else {
	length1++;
	position += length1;
	break;
      }
    } else {
      if (--length1 == 0) {
	if (position == 0L) {
	  break;
	}
      }
    }
  }
  fseek(fp, position, 0);
  strcpy(ptr, &buff1[length1]);
  return(0);
}

/*
 * ʸ󥳥ԡ(ɽ)
 */

static int	kanji_strposcpy(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  unsigned char	*ptr3, *ptr4;
  register int	index;

  index = 0;
  ptr3 = ptr2;
  ptr4 = ptr1;
#ifdef	MSDOS
  count--;	/* MS-DOS ǲԤΤⲽ(ʤ)	*/
#endif	/* MSDOS */

  /*
   * ʬ JIS ɤ뤿˥ȥå
   * ¤ȤäƤޤ
   */

  if (kanji_flag) {
    strncpy((char*)ptr1, JIS_IN, 3);
    ptr1 += 3;
    ptr4 = NULL;
  }
  while (count > 0) {
    if (!*ptr2) {
      break;
    }
    if ((!strncmp((char*)ptr2, JIS_IN1, 3))
	|| (!strncmp((char*)ptr2, JIS_IN2, 3))) {
      if (count < 2) {
	break;
      }
      
      /*	ؼ	*/
      
      kanji_flag = 1;
      strcpy((char*)ptr1, JIS_IN);
      ptr1 += 3;
      ptr2 += 3;
      ptr4 = NULL;
    } else if (!strncmp((char*)ptr2, JIS_IN3, 4)) {
      if (count < 2) {
	break;
      }
      
      /*	ؼ	*/
      
      kanji_flag = 1;
      strcpy((char*)ptr1, JIS_IN);
      ptr1 += 3;
      ptr2 += 4;
      ptr4 = NULL;
    } else if (!strncmp((char*)ptr2, JIS_X0212, 4)) {
      if (count < 2) {
	break;
      }
      
      /*	ؼ	*/
      
      kanji_flag = 2;
      strcpy((char*)ptr1, JIS_X0212);
      ptr1 += 4;
      ptr2 += 4;
      ptr4 = NULL;
    } else if ((!strncmp((char*)ptr2, JIS_OUT1, 3)) ||
	       (!strncmp((char*)ptr2, JIS_OUT2, 3))) {

      /*	޻ؼ	*/

      if (ptr1 != ptr4) {
	if (!kanji_flag) {
	  if (ptr4) {
	    *ptr1 = '\0';
	    bcopy(ptr4, ptr4 + 3, strlen((char*)ptr4));
	    strncpy((char*)ptr4, JIS_IN, 3);
	    ptr1 += 3;
	  }
	}
	strcpy((char*)ptr1, JIS_OUT);
	ptr1 += 3;
      }
      kanji_flag = 0;
      ptr2 += 3;
      ptr4 = NULL;
    } else if (*ptr2 & 0x80) {
#ifdef	SUPPORT_X0201
      if (default_code == SJIS_CODE) {
	if ((*ptr2 >= 0xa0) && (*ptr2 < 0xe0)) {
	  *ptr1++ = *ptr2++;
	  count--;
	  index++;
	} else {
	  if (*(ptr2 + 1) >= ' ') {
	    if (count < 2) {
	      count = 0;
	    } else {
	      *ptr1++ = *ptr2++;
	      *ptr1++ = *ptr2++;
	      count -= 2;
	      index += 2;
	    }
	  } else {
	    *ptr1++ = ' ';
	    ptr2++;
	    count--;
	    index++;
	  }
	}
      } else {
	switch (*ptr2) {
	case EUC_SS2:		/* JIS-X0201 	*/
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  count--;
	  index++;
	  break;
	case EUC_SS3:		/* JIS-X0212 	*/
	  if (*(ptr2 + 1) >= ' ') {
	    if (count < 2) {
	      count = 0;
	    } else {
	      *ptr1++ = *ptr2++;
	      *ptr1++ = *ptr2++;
	      *ptr1++ = *ptr2++;
	      count -= 2;
	      index += 2;
	    }
	  } else {
	    *ptr1++ = ' ';
	    ptr2++;
	    count--;
	    index++;
	  }
	  break;
	default:
	  if (*(ptr2 + 1) >= ' ') {
	    if (count < 2) {
	      count = 0;
	    } else {
	      *ptr1++ = *ptr2++;
	      *ptr1++ = *ptr2++;
	      count -= 2;
	      index += 2;
	    }
	  } else {
	    *ptr1++ = ' ';
	    ptr2++;
	    count--;
	    index++;
	  }
	  break;
	}
      }
#else	/* !SUPPORT_X0201 */
      if (*(ptr2 + 1) >= ' ') {
	if (count < 2) {
	  count = 0;
	} else {
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  count -= 2;
	  index += 2;
	}
      } else {
	*ptr1++ = ' ';
	ptr2++;
	count--;
	index++;
      }
#endif	/* !SUPPORT_X0201 */
    } else if (kanji_flag) {
      if (count < 2) {
	count = 0;
      } else {
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	count -= 2;
	index += 2;
      }
    } else if (*ptr2 == '\t') {
      do {
	*ptr1++ = ' ';
	index++;
	if (--count <= 0) {
	  break;
	}
      } while (index % 8);
      ptr2++;
#ifdef	DISPLAY_CTRL
#ifdef	MSDOS
    } else if ((*ptr2 < ' ') && (*ptr2 != '\r')) {
				/* ȥ륳ɸ	*/
#else	/* !MSDOS */
    } else if (*ptr2 < ' ') {	/* ȥ륳ɸ	*/
#endif	/* !MSDOS */
#else	/* !DISPLAY_CTRL */
    } else if (*ptr2 == 0x0c) {	/* ^L 	*/
#endif	/* !DISPLAY_CTRL */
      if (count < 2) {
	count = 0;
      } else {
	*ptr1++ = '^';
	*ptr1++ = '@' + *ptr2++;
	count -= 2;
	index += 2;
      }
    } else {
      *ptr1++ = *ptr2++;
      count--;
      index++;
    }
  }
  if (kanji_flag) {
    if ((!strncmp((char*)ptr2, JIS_OUT1, 3))
	|| (!strncmp((char*)ptr2, JIS_OUT2, 3))) {
      kanji_flag = 0;
      ptr2 += 3;
    }
    strcpy((char*)ptr1, JIS_OUT);
    ptr1 += 3;
  }
  *ptr1 = '\0';
  kanji_strwidth = index;
  return(ptr2 - ptr3);
}

/*
 * ʸ󸡺(EUC Ѵ)
 */

static char	*kanji_strindex(str1 ,str2)
     char	*str1;
     char	*str2;
{
  char		buff[BUFF_SIZE];
  register int	length;

  to_euc(buff, str1, default_code);
  str1 = buff;
  length = strlen(str2);
  while (*str1) {
    if (!strncasecmp(str1, str2, length)) {
      return(str1);
    }
    str1++;
  }
  return(NULL);
}
#endif	/* PAGER */
