/*
 *
 *  ü饤֥
 *
 *  Copyright 1990-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Terminal Control Library
 *  Sub system  : library routine [for MS-DOS/X680x0 only]
 *  File        : termdos.c
 *  Version     : 1.38
 *  First Edit  : 1994-03/15
 *  Last  Edit  : 1995-06/30
 *  Author      : MSR24  
 *
 */

#include	"compat.h"
#include	"termlib.h"
#ifdef	MNEWS
#include	"kanjilib.h"
#endif	/* MNEWS */

static void	window_resize();/* ɥꥵ		*/

int		term_columns = DEFAULT_COLUMNS;
int		term_lines = DEFAULT_LINES;
int		term_resize_flag = 0;

static int		term_nl = 1;
static int		term_echo = 1;
static int		term_cbreak = 0;
static int		term_raw = 0;
static int		init_flag =0;
static int		ldisc_mode, ldisc_org;

/*
 * ü
 */

int	term_init(mode)
     int	mode;
{
  switch (mode) {
  case 0:
    term_columns = DEFAULT_COLUMNS;
    term_lines   = DEFAULT_LINES;
    term_resize_flag = 0;
#ifdef	SIGWINCH
    signal(SIGWINCH, window_resize);
#endif	/* SIGWINCH */
    window_resize();
    if (!init_flag) {
      init_flag = 1;
    }
    break;
  case 3:
    term_reset_raw();
    term_reset_cbreak();
    term_set_echo();
    term_set_nl();
    /* break  */
  case 1:
    if (init_flag) {
    }
    break;
  case 2:
    if (term_cbreak) {
      term_set_cbreak();
    }
    if (term_raw) {
      term_set_raw();
    }
    if (!term_nl) {
      term_reset_nl();
    }
    if (!term_echo) {
      term_reset_echo();
    }
    break;
  default:
    break;
  }
  return(0);
}

/*
 * ̥ꥢ
 */

void	term_clear_all()
{
  printf(CLEAR_ALL_STRING);
  fflush(stdout);
}

/*
 * ޤǺ
 */

void	term_clear_line()
{
  printf(CLEAR_LINE_STRING);
  fflush(stdout);
}

/*
 * üޤǺ
 */

void	term_clear_end()
{
  printf(CLEAR_END_STRING);
  fflush(stdout);
}

/*
 * ٹ٥
 */

void	term_bell()
{
  printf(BELL_STRING);
  fflush(stdout);
}

/*
 * ư
 */

void	term_locate(x, y)
     int	x;
     int	y;
{
  printf(LOCATE_STRING, y + 1, x + 1);
  fflush(stdout);
}

/*
 * ְۡư
 */

void	term_home()
{
  term_locate(0, 0);
}

/*
 * 
 */

void	term_insert()
{
  printf(INS_LINE_STRING);
  fflush(stdout);
}

/*
 * ʸ
 */

void	term_insert_char()
{
  printf(INS_CHAR_STRING);
  fflush(stdout);
}

/*
 * ư
 */

void	term_up()
{
  printf(UP_STRING);
  fflush(stdout);
}

/*
 * 벼ư
 */

void	term_down()
{
  printf(DOWN_STRING);
  fflush(stdout);
}

/*
 * 뺸ư
 */

void	term_left()
{
  printf(LEFT_STRING);
  fflush(stdout);
}

/*
 * 뱦ư
 */

void	term_right()
{
  printf(RIGHT_STRING);
  fflush(stdout);
}

/*
 * Ƭư
 */

void	term_top()
{
  putc('\r', stdout);
  fflush(stdout);
}

/*
 * 
 */

void	term_crlf(pos)
     int	pos;
{
  printf("\r\n");
  fflush(stdout);
}

/*
 * üʸ
 */

void	term_fill_right()
{
  putc(' ', stdout);
  term_left();
  term_insert_char();
}

/*
 * ɽ°ѹ
 */

void	term_attrib(attrib)
     int	attrib;
{
  printf(ATTRIB_STRING, attrib);
  fflush(stdout);
}

/*
 * RAW ⡼ɥå
 */

void	term_set_raw()
{
  term_raw = 1;
}

/*
 * RAW ⡼ɥꥻå
 */

void	term_reset_raw()
{
  term_raw = 0;
}

/*
 * CBREAK ⡼ɥå
 */

void	term_set_cbreak()
{
  term_cbreak = 1;
}

/*
 * CBREAK ⡼ɥꥻå
 */

void	term_reset_cbreak()
{
  term_cbreak = 0;
}

/*
 * ECHO ⡼ɥå
 */

void	term_set_echo()
{
  term_echo = 1;
}

/*
 * ECHO ⡼ɥꥻå
 */

void	term_reset_echo()
{
  term_echo = 0;
}

/*
 * NL ⡼ɥå
 */

void	term_set_nl()
{
  term_nl = 1;
}

/*
 * NL ⡼ɥꥻå
 */

void	term_reset_nl()
{
  term_nl = 0;
}

/*
 * ü¹
 */

int	term_system(str)
     char	*str;
{
  int		pstat;

  term_init(1);
  pstat = system(str);
  term_init(2);
  return(pstat);
}

/*
 * ɥꥵ
 */

static void	window_resize()
{
  char			*ptr;

  term_columns = DEFAULT_COLUMNS;
  term_lines = DEFAULT_LINES;
  if (ptr = getenv("LINES")) {
    term_lines = atoi(ptr);
  }
  if (ptr = getenv("COLUMNS")) {
    term_columns = atoi(ptr);
  }
}
