/*
 *
 *  ü饤֥
 *
 *  Copyright 1990-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Terminal Control Library
 *  Sub system  : library routine
 *  File        : termlib.c
 *  Version     : 1.38
 *  First Edit  : 1990-11/01
 *  Last  Edit  : 1995-06/30
 *  Author      : MSR24  
 *
 */

#include	"compat.h"
#include	"termlib.h"
#ifdef	MNEWS
#include	"kanjilib.h"
#endif	/* MNEWS */

static void	window_resize();/* ɥꥵ		*/

#ifdef	TERMCAP
static char	*term_cl;	/* Clear screen			*/
static char	*term_cd;	/* Clear to end of display	*/
static char	*term_ce;	/* Clear to end of line		*/
static char	*term_ho;	/* Home cursor			*/
static char	*term_cm;	/* Cursor motion		*/
static char	*term_so;	/* Stand out mode start		*/
static char	*term_se;	/* Stand out mode end		*/
#ifdef	notdef
static char	*term_us;	/* Underscore mode start	*/
static char	*term_ue;	/* Underscore mode end		*/
static char	*term_mr;	/* Reverse mode			*/
static char	*term_mh;	/* Half bright mode  (dim)	*/
static char	*term_md;	/* Extra bright mode (bold)	*/
static char	*term_mb;	/* Blinking mode		*/
static char	*term_me;	/* Turn off all attributes	*/
#endif	/* notdef */
static char	*term_bl;	/* Audible bell			*/
static char	*term_cr;	/* Carriage return		*/
static char	*term_do;	/* Down one line		*/
static char	*term_u;	/* Upline			*/
static char	*term_le;	/* Move cursor left		*/
static char	*term_nd;	/* Non-destructive space (right)*/
static char	*term_ic;	/* Insert character		*/
static char	*term_al;	/* Add blank line(scroll down)	*/
static char	*term_TY;	/* Terminal Kanji code		*/
int		term_xn_nam;	/* Don't wrap at end of line	*/

#undef	putchar
int	putchar();		/* putchar must be a function (not macro!) */

/*
 * termcap Хѿ
 */

#ifndef SYSV_CURSES
extern char	*UP;		/* upline		*/
extern char	*BC;		/* backspace character	*/
extern char	PC;		/* pad character	*/
extern short	ospeed;		/* terminal output speed*/
#endif	/* !SYSV_CURSES */
#endif	/* TERMCAP */

int		term_columns = DEFAULT_COLUMNS;
int		term_lines = DEFAULT_LINES;
int		term_resize_flag = 0;

#ifdef	TERMIO
static struct termio	tty_new, tty_org;
#else	/* !TERMIO */
static struct sgttyb	tty_new, tty_org;
#endif	/* !TERMIO */
#ifdef	TERMCAP
static unsigned char	tcbuf[1024];	/* 1024 ǤʤФʤʤ */
#endif	/* TERMCAP */
static int		term_nl = 1;
static int		term_echo = 1;
static int		term_cbreak = 0;
static int		term_raw = 0;
static int		init_flag =0;
static int		ldisc_mode, ldisc_org;

/*
 * ü
 */

int	term_init(mode)
     int	mode;
{
#ifdef	TERMCAP
  static char	cap[256];
  char		*cp = cap;
  char		*term_name;
#endif	/* TERMCAP */

  switch (mode) {
  case 0:
    term_columns = DEFAULT_COLUMNS;
    term_lines   = DEFAULT_LINES;
    term_resize_flag = 0;
#ifdef	SIGWINCH
    signal(SIGWINCH, window_resize);
#endif	/* SIGWINCH */
#ifdef	TERMCAP
    if ((term_name = (char*)getenv("TERM")) == NULL) {
      fprintf(stderr, "Environment variable TERM not defined.\n");
      return(1);
    }
#ifdef	TERMINFO
    if (setupterm(term_name, 0, &terr) == ERR) {
      fprintf(stderr, "Unknown terminal type %s\n", term_name);
      return(1);
    }
#else	/* !TERMINFO */
    if (tgetent(tcbuf, term_name) < 1) {
      fprintf(stderr, "Unknown terminal type %s\n", term_name);
      return(1);
    }
#endif	/* !TERMINFO */
    window_resize();
#ifdef	TERMINFO
    term_cl = clear_screen;
    term_cd = clr_eos;
    term_ce = clr_eol;
    term_ho = cursor_home;
    term_cm = cursor_address;
    term_so = enter_standout_mode;
    term_se = exit_standout_mode;
    term_us = enter_underline_mode;
    term_ue = exit_underline_mode;
    term_mr = enter_reverse_mode;
    term_mh = enter_dim_mode;
    term_md = enter_bold_mode;
    term_mb = enter_blink_mode;
    term_me = exit_attribute_mode;
    term_bl = bell;
    term_cr = carriage_return;
    term_do = cursor_down;
    term_u  = cursor_up;
    term_le = cursor_left;
    term_nd = cursor_right;
    term_ic = insert_character;
    term_al = insert_line;
#ifdef	notdef
    term_TY = tgetstr("TY", &cp);
#endif	/* notdef */
    term_xn_nam = !auto_right_margin || eat_newline_glitch;
#else	/* ! TERMINFO */
    term_cl = tgetstr("cl", &cp);
    term_cd = tgetstr("cd", &cp);
    term_ce = tgetstr("ce", &cp);
    term_ho = tgetstr("ho", &cp);
    term_cm = tgetstr("cm", &cp);
    term_so = tgetstr("so", &cp);
    term_se = tgetstr("se", &cp);
#ifdef	notdef
    term_us = tgetstr("us", &cp);
    term_ue = tgetstr("ue", &cp);
    term_mr = tgetstr("mr", &cp);
    term_mh = tgetstr("mh", &cp);
    term_md = tgetstr("md", &cp);
    term_mb = tgetstr("mb", &cp);
    term_me = tgetstr("me", &cp);
#endif	/* notdef */
    term_bl = tgetstr("bl", &cp);
    term_cr = tgetstr("cr", &cp);
    term_do = tgetstr("do", &cp);
    term_u  = tgetstr("up", &cp);
    term_le = tgetstr("le", &cp);
    term_nd = tgetstr("nd", &cp);
    term_ic = tgetstr("ic", &cp);
    term_al = tgetstr("al", &cp);
    term_TY = tgetstr("TY", &cp);
    term_xn_nam = !tgetflag("am") || tgetflag("xn");
    if (!term_al) {
      term_al = tgetstr("sr", &cp);
    }
#endif	/* ! TERMINFO */

#ifndef	SYSV_CURSES
    /*
     * Is there any termcap library which is missing in
     * these variables?
     */
#ifdef	TERMINFO
    {
      char *p;
      if (p = pad_char) {
	PC = p[0];			/* Padding character */
      } else {
	PC = '\0';
      }
    }
    BC = key_backspace;			/* Backspace string */
#else	/* ! TERMINFO */
    {
      char *p;
      if ((p = tgetstr("pc", &cp))) {
	PC = p[0];			/* Padding character */
      } else {
	PC = '\0';
      }
    }
    BC = tgetstr("bc", &cp);		/* Backspace string */
#endif	/* ! TERMINFO */
    UP = term_u;			/* Upline string */
#endif	/* !SYSV_CURSES */

    if (!(term_cl && term_cm) || !term_al) {
      fprintf(stderr, "This terminal seems not so capable as to run mnews.\n");
      return(1);
    }
    if (!term_le) {			/* ^H */
      term_le = "\010";
      }
    if (!term_u) {			/* ^K */
      term_u  = "\013";
    }
    if (!term_nd) {			/* ^L */
      term_nd = "\014";
    }
    if (!term_cr) {			/* ^M */
      term_cr = "\015";
    }
    if (!term_so || !term_se) {
      term_so = term_se = "";
    }

    /*
     * term_do (down 1 line) ϺǲԤǥ뤹ɬפ롣
     * 뤷ʤΤΤ ^J Ѥ롣
     */

    if ((!term_do) || (term_do[strlen(term_do) - 1] != '\012')) {
					/* ^J */
      term_do = "\012";
    }

#ifdef	MNEWS
#ifndef	TERMINFO
    /*
     * "TY" ȥ򻲾ȤƥǥեȤɽɤꤹ롣
     * .	TY=euc or TY=ujis	->  EUC code
     *		TY=jis			->  JIS code
     *		TY=sjis			->  SJIS code
     */

    if (term_TY) {
      if (!strcmp(term_TY, "euc") || !strcmp(term_TY, "ujis")) {
	print_code = EUC_CODE;
      } else if (!strcmp(term_TY, "jis")) {
	print_code = JIS_CODE;
      } else if (!strcmp(term_TY, "sjis")) {
	print_code = SJIS_CODE;
      }
    }
#endif	/* !TERMINFO */
#endif	/* MNEWS */
#else	/* !TERMCAP */
    window_resize();
#endif	/* !TERMCAP */
    if (!init_flag) {
#ifdef	TERMIO
      ioctl(0, TCGETA, &tty_org);
      tty_new = tty_org;
#else	/* !TERMIO */
      ioctl(0, TIOCGETP, &tty_org);
      tty_new = tty_org;
#if	defined(TERMCAP) && !defined(SYSV_CURSES)
      ospeed = tty_org.sg_ospeed;
#endif	/* TERMCAP && !SYSV_CURSES */
      ioctl(0, TIOCGETD, &ldisc_mode);
      ldisc_org = ldisc_mode;
#endif	/* !TERMIO */
      init_flag = 1;
    }
    break;
  case 3:
    term_reset_raw();
    term_reset_cbreak();
    term_set_echo();
    term_set_nl();
    /* break  */
  case 1:
    if (init_flag) {
#ifdef	TERMIO
      ioctl(0, TCSETA, &tty_org);
#else	/* !TERMIO */
      ioctl(0, TIOCSETP, &tty_org);
      ioctl(0, TIOCSETD, &ldisc_org);
#endif	/* !TERMIO */
    }
    break;
  case 2:
    if (term_cbreak) {
      term_set_cbreak();
    }
    if (term_raw) {
      term_set_raw();
    }
    if (!term_nl) {
      term_reset_nl();
    }
    if (!term_echo) {
      term_reset_echo();
    }
    break;
  default:
    break;
  }
  return(0);
}

/*
 * ̥ꥢ
 */

void	term_clear_all()
{
#ifdef	TERMCAP
  if (term_cl) {
    tputs(term_cl, term_lines, putchar);
  }
#else	/* !TERMCAP */
  printf(CLEAR_ALL_STRING);
#endif	/* !TERMCAP */
}

/*
 * ޤǺ
 */

void	term_clear_line()
{
#ifdef	TERMCAP
  register int	i;
  if (term_ce) {
    tputs(term_ce, 1, putchar);
  } else {
    term_top();
    for (i = term_columns - 1; i > 0; --i) {
      putc(' ', stdout);
    }
  }
#else	/* !TERMCAP */
  printf(CLEAR_LINE_STRING);
#endif	/* !TERMCAP */
}

/*
 * üޤǺ
 */

void	term_clear_end()
{
#ifdef	TERMCAP
  if (term_cd) {
    tputs(term_cd, 1, putchar);
  }
#else	/* !TERMCAP */
  printf(CLEAR_END_STRING);
#endif	/* !TERMCAP */
}

/*
 * ٹ٥
 */

void	term_bell()
{
#ifdef	TERMCAP
  if (term_bl) {
    tputs(term_bl, 1, putchar);
  }
#else	/* !TERMCAP */
  printf(BELL_STRING);
  fflush(stdout);
#endif	/* !TERMCAP */
}

/*
 * ư
 */

void	term_locate(x, y)
     int	x;
     int	y;
{
#ifdef	TERMCAP
  if (term_cm) {
    tputs(tgoto(term_cm, x, y), 1, putchar);
  }
#else	/* !TERMCAP */
  printf(LOCATE_STRING, y + 1, x + 1);
#endif	/* !TERMCAP */
}

/*
 * ְۡư
 */

void	term_home()
{
#ifdef	TERMCAP
  if (term_ho) {
    tputs(term_ho, 1, putchar);
  } else {
    term_locate(0, 0);
  }
#else	/* !TERMCAP */
  term_locate(0, 0);
#endif	/* !TERMCAP */
}

/*
 * 
 */

void	term_insert()
{
#ifdef	TERMCAP
  if (term_al) {
    tputs(term_al, 1, putchar);
  }
#else	/* !TERMCAP */
  printf(INS_LINE_STRING);
#endif	/* !TERMCAP */
}

/*
 * ʸ
 */

void	term_insert_char()
{
#ifdef	TERMCAP
  if (term_ic) {
    tputs(term_ic, 1, putchar);
  }
#else	/* !TERMCAP */
  printf(INS_CHAR_STRING);
#endif	/* !TERMCAP */
}

/*
 * ư
 */

void	term_up()
{
#ifdef	TERMCAP
  tputs(term_u, 1, putchar);
#else	/* !TERMCAP */
  printf(UP_STRING);
#endif	/* !TERMCAP */
}

/*
 * 벼ư
 */

void	term_down()
{
#ifdef	TERMCAP
  tputs(term_do, 1, putchar);
#else	/* !TERMCAP */
  printf(DOWN_STRING);
#endif	/* !TERMCAP */
}

/*
 * 뺸ư
 */

void	term_left()
{
#ifdef	TERMCAP
  tputs(term_le, 1, putchar);
#else	/* !TERMCAP */
  printf(LEFT_STRING);
#endif	/* !TERMCAP */
}

/*
 * 뱦ư
 */

void	term_right()
{
#ifdef	TERMCAP
  tputs(term_nd, 1, putchar);
#else	/* !TERMCAP */
  printf(RIGHT_STRING);
#endif	/* !TERMCAP */
}

/*
 * Ƭư
 */

void	term_top()
{
#ifdef	TERMCAP
  tputs(term_cr, 1, putchar);
#else	/* !TERMCAP */
  putc('\r', stdout);
#endif	/* !TERMCAP */
}

/*
 * 
 */

void	term_crlf(pos)
     int	pos;
{
#ifdef	TERMCAP
  if (pos != term_columns || term_xn_nam) {
    tputs(term_cr, 1, putchar);
    tputs(term_do, 1, putchar);
  }
#else	/* !TERMCAP */
  printf("\r\n");
#endif	/* !TERMCAP */
}

/*
 * üʸ
 */

void	term_fill_right()
{
#ifdef TERMCAP
  if (term_xn_nam) {
    putc(' ', stdout);
    putc(' ', stdout);
  } else {
    putc(' ', stdout);
    term_left();
    term_insert_char();
  }
#else	/* !TERMCAP */
  putc(' ', stdout);
  term_left();
  term_insert_char();
#endif	/* !TERMCAP */
}

/*
 * ɽ°ѹ
 */

void	term_attrib(attrib)
     int	attrib;
{
#ifdef	TERMCAP
  if (attrib) {
    if (term_so) {
      tputs(term_so, 1, putchar);
    }
  } else {
    if (term_se) {
      tputs(term_se, 1, putchar);
    }
  }
#else	/* !TERMCAP */
  printf(ATTRIB_STRING, attrib);
#endif	/* !TERMCAP */
}

/*
 * RAW ⡼ɥå
 */

void	term_set_raw()
{
  term_raw = 1;
#ifdef	TERMIO
  tty_new.c_iflag &= ~(INLCR | ICRNL | ISTRIP | IXON | BRKINT);
  tty_new.c_oflag &= ~OPOST;
  tty_new.c_lflag &= ~(ICANON | ISIG);
  tty_new.c_cc[VMIN] = 1;
  tty_new.c_cc[VTIME] = 0;
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags |= RAW;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * RAW ⡼ɥꥻå
 */

void	term_reset_raw()
{
  term_raw = 0;
#ifdef	TERMIO
  tty_new.c_iflag |= (INLCR | ICRNL | IXON | BRKINT) | (tty_org.c_iflag & ISTRIP);
  tty_new.c_oflag |= OPOST;
  tty_new.c_lflag |= (ICANON | ISIG);
  tty_new.c_cc[VMIN] = tty_org.c_cc[VMIN];
  tty_new.c_cc[VTIME] = tty_org.c_cc[VTIME];
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags &= ~RAW;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * CBREAK ⡼ɥå
 */

void	term_set_cbreak()
{
  term_cbreak = 1;
#ifdef	TERMIO
  tty_new.c_lflag &= ~ICANON;
  tty_new.c_cc[VMIN] = 1;
  tty_new.c_cc[VTIME] = 0;
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags |= CBREAK;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * CBREAK ⡼ɥꥻå
 */

void	term_reset_cbreak()
{
  term_cbreak = 0;
#ifdef	TERMIO
  tty_new.c_lflag &= ICANON;
  tty_new.c_cc[VMIN] = tty_org.c_cc[VMIN];
  tty_new.c_cc[VTIME] = tty_org.c_cc[VTIME];
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags &= ~CBREAK;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * ECHO ⡼ɥå
 */

void	term_set_echo()
{
  term_echo = 1;
#ifdef	TERMIO
  tty_new.c_lflag &= ECHO;
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags |= ECHO;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * ECHO ⡼ɥꥻå
 */

void	term_reset_echo()
{
  term_echo = 0;
#ifdef	TERMIO
  tty_new.c_lflag &= ~ECHO;
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags &= ~ECHO;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * NL ⡼ɥå
 */

void	term_set_nl()
{
  term_nl = 1;
#ifdef	TERMIO
  tty_new.c_iflag &= ~(INLCR | ICRNL);
  tty_new.c_oflag &= ~OPOST;
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags |= CRMOD;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * NL ⡼ɥꥻå
 */

void	term_reset_nl()
{
  term_nl = 0;
#ifdef	TERMIO
  tty_new.c_iflag |= (INLCR | ICRNL);
  tty_new.c_oflag |= OPOST;
  ioctl(0, TCSETAF, &tty_new);
#else	/* !TERMIO */
  tty_new.sg_flags &= ~CRMOD;
  ioctl(0, TIOCSETP, &tty_new);
#endif	/* !TERMIO */
}

/*
 * ü¹
 */

int	term_system(str)
     char	*str;
{
  int		pstat;

#ifdef	USE_SYSTEM
  term_init(1);
  pstat = system(str);
  term_init(2);
  return(pstat);
#else	/* !USE_SYSTEM */
  int		pid;
  void		(*sig_int)(), (*sig_quit)(), (*sig_term)(), (*sig_pipe)(),
		(*sig_winch)(), (*sig_hup)();
  char		*shell;
  
  sig_int  = (void (*)())signal(SIGINT, SIG_IGN);
  sig_quit = (void (*)())signal(SIGQUIT, SIG_IGN);
  sig_term = (void (*)())signal(SIGTERM, SIG_IGN);
  sig_pipe = (void (*)())signal(SIGPIPE, SIG_IGN);
  sig_hup  = (void (*)())signal(SIGHUP, SIG_IGN);
#ifdef  SIGWINCH
  sig_winch = (void (*)())signal(SIGWINCH, SIG_IGN);
#endif  /* SIGWINCH */
  term_init(1);
  pid = vfork();
  if (pid == -1) {
    return(127);
  }
  if (!pid) {
    if (str) {
      execl("/bin/sh", "sh", "-c", str, (char*)NULL);
    } else {
      if (!(shell = (char*)getenv("SHELL"))) {
	shell = "/bin/sh";
      }
      execl(shell, shell, (char*)NULL);
    }
    _exit(127);
  }
  wait((int *)&pstat);
  term_init(2);
  signal(SIGINT,  sig_int);
  signal(SIGQUIT, sig_quit);
  signal(SIGTERM, sig_term);
  signal(SIGPIPE, sig_pipe);
  signal(SIGHUP, sig_hup);
#ifdef  SIGWINCH
  signal(SIGWINCH, sig_winch);
#endif  /* SIGWINCH */
  
  return(pstat);
#endif	/* !USE_SYSTEM */
}

/*
 * ɥꥵ
 */

static void	window_resize()
{
#ifdef	TERMCAP
#ifdef	TIOCGWINSZ
  struct winsize	winsize;
#endif	/* TIOCGWINSZ */

  term_resize_flag = 1;
#ifdef	SIGWINCH
  signal(SIGWINCH, window_resize);
#endif	/* SIGWINCH */
#ifdef	TIOCGWINSZ
  if (ioctl(0, TIOCGWINSZ, &winsize) == 0) {
    if (winsize.ws_col > 0 && winsize.ws_row > 0) {
      term_columns = winsize.ws_col;
      term_lines = winsize.ws_row;
      return;
    }
  }
#endif	/* TIOCGWINSZ */
#ifdef	TERMINFO
  term_columns = columns;
  term_lines   = lines;
#else	/* !TERMINFO */
  term_columns = tgetnum("co");
  term_lines   = tgetnum("li");
#endif	/* !TERMINFO */
  if (term_columns <= 0) {
    term_columns = DEFAULT_COLUMNS;
  }
  if (term_lines <= 0) {
    term_lines = DEFAULT_LINES;
  }
#else	/* !TERMCAP */
#ifdef	TIOCGWINSZ
  struct winsize	winsize;
#endif	/* TIOCGWINSZ */
#ifndef	TIOCGWINSZ
  char			*ptr;
#endif	/* TIOCGWINSZ */

#ifdef	SIGWINCH
  signal(SIGWINCH, (void (*)())window_resize);
#endif	/* SIGWINCH */
  term_resize_flag = 1;
#ifdef	TIOCGWINSZ
  if (ioctl(0, TIOCGWINSZ, &winsize) < 0) {
    return;
  }
  if ((term_columns = winsize.ws_col) <= 0) {
    term_columns = DEFAULT_COLUMNS;
  }
  if ((term_lines   = winsize.ws_row) <= 0) {
    term_lines = DEFAULT_LINES;
  }
#else	/* !TIOCGWINSZ */
  term_columns = DEFAULT_COLUMNS;
  term_lines = DEFAULT_LINES;
  if (ptr = getenv("LINES")) {
    term_lines = atoi(ptr);
  }
  if (ptr = getenv("COLUMNS")) {
    term_columns = atoi(ptr);
  }
#endif	/* !TIOCGWINSZ */
#endif	/* !TERMCAP */
}
