#
#	Mini News Reader Ver 1.19
#	Makefile for source release [for MS-DOS Turbo-C/Borland-C only]
#

#SHELL	= command.com
ARCH	= MSDOS
# for Turbo-C++
CC	= tcc -O -A -mh -G -Z -a -d -f- -N
# for Borland-C++ 3.1
#CC	= bcc -O2 -mh -Z -a -d -w-pro
LIBS	= 
#LIBS	= /usr/lib/libh.lib
#LD	= tlink
LD_FLAG	= 
BIN_DIR	= \usr\local\bin
LIB_DIR	= \usr\local\lib
MAN_DIR	= \usr\man

OPTCFG    = mnews.opt
CONNECT_OPT = -DNNTP
#CONNECT_OPT = -DNSPL
CONS_OPT  = -DNEWSPOST -DPAGER
#CONS_OPT  = -DNEWSPOST -DMH -DMIME -DPAGER -DJNAMES
CONF_OPT  = -DCTRL_L -DDISPLAY_CTRL -DSJIS_SRC -DSMALL
BASE_OPT  = -DMNEWS -DJIS_INPUT -D$(ARCH)
CC_FLAG   = @$(OPTCFG) -c
EXE       = mnews.exe


NEWSPOST_OBJ = newspost.obj
#MAILSEND_OBJ = mailsend.obj
#JNAMES_OBJ = jnames.obj
#JNAMES_OBJ = jnhash.obj
#MH_OBJ = mh.obj
#UCBMAIL_OBJ = ucbmail.obj
#RMAIL_OBJ = rmail.obj
PAGER_OBJ = pager.obj
#BOARD_OBJ = board.obj
#FCC_OBJ = fcc.obj
MIME_OBJ = mime.obj

BASE_OBJ   = mnews.obj group.obj article.obj mark.obj compat.obj \
		nntplib.obj kanjilib.obj termdos.obj inetbios.obj
#		msd_dir.obj
OPTION_OBJ = $(NEWSPOST_OBJ) $(MAILSEND_OBJ) $(JNAMES_OBJ) \
		$(MH_OBJ) $(UCBMAIL_OBJ) $(RMAIL_OBJ) $(BOARD_OBJ) \
		$(PAGER_OBJ) $(FCC_OBJ) $(MIME_OBJ)
OBJ     = mnews.obj group.obj article.obj mark.obj mh.obj ucbmail.obj \
		rmail.obj board.obj newspost.obj mailsend.obj pager.obj \
		fcc.obj mime.obj compat.obj nntplib.obj kanjilib.obj \
		termdos.obj inetbios.obj jnames.obj jnhash.obj
#		msd_dir.obj
SRC     = mnews.c group.c article.c mark.c mh.c ucbmail.c rmail.c board.c \
		newspost.c mailsend.c pager.c fcc.c mime.c compat.c \
		nntplib.c kanjilib.c termlib.c termdos.c \
		inetbios.c jnames.c jnhash.c
#		msd_dir.c
INC     = mnews.h group.h article.h mark.h mh.h ucbmail.h rmail.h board.h \
		newspost.h mailsend.h pager.h fcc.h mime.h compat.h \
		nntplib.h kanjilib.h termlib.h site_DOS.h site_X68.h \
		inetbios.h
#		msd_dir.h
C_OBJ   = config.obj
C_SRC   = config.c
C_INC   = config.h
SITE    = site_dep.h
DOC1    = mnews.doc mnews.1 read1ST.doc readme.doc update.doc FAQ.doc \
		board.doc present.doc
DOC2    = prerel.doc
ETC     = board.sh board.csh combine.sh jnames.smp _mnews.smp
MAKE1   = config.sh config.jsh Makefile.obj
MAKE2   = Makefile.src Makefile.MSC Makefile.TCC Makefile.X68
SRC_DIST = mnews_src.Lzh
OBJ_DIST = mnews_obj.Lzh
EXE_DIST = mnews_exe.Lzh

all: $(EXE)

obj: $(OBJ)

$(OPTCFG): Makefile
	echo $(BASE_OPT) > $(OPTCFG)
	echo $(CONS_OPT) >>$(OPTCFG)
	echo $(CONF_OPT) >>$(OPTCFG)

$(EXE): $(BASE_OBJ) $(OPTION_OBJ) $(C_OBJ)
	echo $(BASE_OBJ)	>  objs
	echo $(OPTION_OBJ)	>> objs
	echo $(C_OBJ)		>> objs
	$(CC) -e$(EXE) $(LD_FLAG) @objs $(LIBS)
#	tdstrip $@

$(C_OBJ): $(C_SRC) $(C_INC) $(SITE)  $(OPTCFG)
	$(CC) $(CC_FLAG) $(CONNECT_OPT) config.c

compat.obj: compat.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) compat.c

nntplib.obj: nntplib.c nntplib.h compat.h  $(OPTCFG)
	$(CC) $(CC_FLAG) $(CONNECT_OPT) -DINETBIOS nntplib.c

inetbios.obj: inetbios.c inetbios.h
	$(CC) -c -A- -DMNEWS -DMSDOS -DINETBIOS inetbios.c

kanjilib.obj: kanjilib.c kanjilib.h compat.h  $(OPTCFG)
	$(CC) $(CC_FLAG) kanjilib.c

mark.obj: mark.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) mark.c

mnews.obj: mnews.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) mnews.c

group.obj: group.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) group.c

article.obj: article.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) article.c

jnames.obj: jnames.c  $(OPTCFG)
	$(CC) $(CC_FLAG) jnames.c

jnhash.obj: jnhash.c kanjilib.h compat.h  $(OPTCFG)
	$(CC) $(CC_FLAG) jnhash.c

mime.obj: mime.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) mime.c

fcc.obj: fcc.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) fcc.c

board.obj: board.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) board.c

mh.obj: mh.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) mh.c

ucbmail.obj: ucbmail.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) ucbmail.c

rmail.obj: rmail.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) rmail.c

mailsend.obj: mailsend.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) mailsend.c

newspost.obj:  newspost.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) newspost.c

pager.obj:     pager.c $(INC)  $(OPTCFG)
	$(CC) $(CC_FLAG) pager.c

termdos.obj:   termdos.c termlib.h compat.h  $(OPTCFG)
	$(CC) $(CC_FLAG) termdos.c

termlib.obj:  termlib.c termlib.h compat.h  $(OPTCFG)
	$(CC) $(CC_FLAG) termlib.c

msd_dir.obj: msd_dir.c msd_dir.h
	$(CC) -c msd_dir.c

install: all
	copy $(EXE) $(BIN_DIR)
	copy mnews.doc $(MAN_DIR)

help:
	@echo "--- Mini News Reader Makefile [Source Version] ---"
	@echo "make          --- make executable file"
	@echo "make install  --- install executable & manual file"
	@echo "make clean    --- remove backup & object file"
	@echo "make remove   --- remove object file"
	@echo "make help     --- print help message"
	@echo "make src_dist --- archive source & document file"
	@echo "make obj_dist --- archive object & document file"
	@echo "make bin_dist --- archive executable & document file"

clean:
	-DEL *.exe
	-DEL *.obj
	-DEL *.bak

remove:
	-DEL *.exe
	-DEL *.obj

src_dist:
	-DEL $(SRC_DIST)
	lha a $(SRC_DIST) *.c *.h $(ETC) \
		$(DOC1) $(DOC2) $(MAKE1) $(MAKE2)

obj_dist: $(OBJ)
	-DEL $(OBJ_DIST)
	lha a $(OBJ_DIST) *.obj \
		$(C_SRC) $(C_INC) $(ETC) $(DOC1) $(MAKE1)

bin_dist: $(EXE)
	-DEL $(EXE_DIST)
	lha a $(EXE_DIST) $(EXE) $(ETC) $(DOC1)

touch:
	touch *.c *.h $(ETC) \
		$(DOC1) $(DOC2) $(MAKE1) $(MAKE2)
