#!/bin/sh
# Mini News Reader Ver 1.19
# ưե졼󥹥ץ for source/object release
#
VERSION="1.19"
PATH=.:$PATH

DEFAULT_CC="/bin/cc"
DEFAULT_INSTALL="/bin/install"
AWK=awk
SED=sed
LIB=""
RANLIB=ranlib
DEFAULT_CPP=""
DEFAULT_BIN_DIR="/usr/local/bin"
DEFAULT_LIB_DIR="/usr/local/lib"
DEFAULT_MAN_DIR="/usr/local/man"
DEFAULT_TMP_DIR="/tmp"
DEFAULT_CONF_OPT="-DCTRL_L -DCOMPLETION -DXOVER -DREF_SORT"
DEFAULT_CFLAGS="-O"
DEFAULT_POSTNEWS="/usr/lib/news/inews -h"
DEFAULT_SENDMAIL="/usr/lib/sendmail -t -om -oi"
DEFAULT_EDITOR="/usr/local/bin/emacs -nw"
DEFAULT_PAGER="/usr/local/bin/less"
DEFAULT_MH_PATH="/usr/local/bin/mh"
DEFAULT_MAIL_SPOOL="/var/spool/mail"
DEFAULT_BOARD_SPOOL="/var/spool/board"
DEFAULT_NEWS_SPOOL="/usr/spool/news"
DEFAULT_NEWS_LIB="/usr/lib/news"

SITE_DEPEND="site_dep.h"
MAKEFILE="Makefile"
K_STRING="ASCII_CODE JIS_CODE SJIS_CODE EUC_CODE UNKNOWN_CODE"

rm -f Y_or_n y_or_N K_code echotmp

echo "--- Mini News Reader ե졼ġ ---"
echo "줫ĤμƲ"
echo "㤨С'([y]/n)' ǽñ˥꥿áХǥեȤȤ 'y' Ȥʤޤ"
echo ""

# for echo without line-feed
echo "ԥɤΰĴ٤Ƥޤ..."
(echo "12345\c" ; echo " ") > echotmp
if grep c echotmp >/dev/null 2>&1 ; then
	n='-n'
	c=''
else
	n=''
	c='\c'
fi
\rm -f echotmp
echo $n "CR(RETURN)򲡤³˿ʤߤޤ˥뤬-->$c"
read ANS

$SED -e  's/@/$/g' > Y_or_n <<EOF
#!/bin/sh
while true
do
	echo $n "@1 ([y]/n):$c"
	read INPUT
	if [ "@INPUT" = "" ] ; then
		exit 1
	fi
	if [ "@INPUT" = "y" ] ; then
		exit 1
	fi
	if [ "@INPUT" = "n" ] ; then
		exit 0
	fi
done
EOF
$SED -e  's/@/$/g' > y_or_N <<EOF
#!/bin/sh
while true
do
	echo $n "@1 (y/[n]):$c"
	read INPUT
	if [ "@INPUT" = "" ] ; then
		exit 0
	fi
	if [ "@INPUT" = "y" ] ; then
		exit 1
	fi
	if [ "@INPUT" = "n" ] ; then
		exit 0
	fi
done
EOF
$SED -e  's/@/$/g' > K_code <<EOF
#!/bin/sh
while true
do
	echo "@1"
	echo "1:̵Ѵ"
	echo "2:JIS "
	echo "3:SJIS "
	echo "4:EUC "
	echo $n "Kanji code ? (ǥե:@2):$c"
	read INPUT
	if [ "@INPUT" = "" ] ; then
		INPUT="@2"
	fi
	case "@INPUT" in
		"1" | "2" | "3" | "4")
			exit @INPUT
			;;
		*)
			;;
	esac
done
EOF
$SED -e  's/@/$/g' > whoami.sh <<EOF
#!/bin/sh
echo \`id | sed -e 'y/()/  /' -e 's/uid=[0-9]* *//' -e 's/ *gid=[0-9]*.*//'\`
EOF

chmod 755 Y_or_n y_or_N K_code whoami.sh

ARCH=""
CONS_OPT=""
MOD_OPT=""
DATE="date"

while [ "$ARCH" = "" ]
do
	echo "ѤΥƥΥƥϲǤ?"
	echo "ֹǲ"
	echo ""
	echo "1.SUN 4.X for SUN SUN-OS 4.X(Solaris 1.X)"
	echo "              Solbourne OS-MP 4.X, Panasonic P-Series PanaOS/S 1.X"
	echo "              Toshiba AS-Series OS/AS V4.X"
	echo "2.SUN 3.X for SUN SUN-OS 3.X, Toshiba AS-Series OS/AS V3.X"
	echo "3.DEC     for DECstation.(Ultrix 4.X)"
	echo "4.NeXT    for NeXT series.(NeXT STEP 2.X)"
	echo "5.NEWS    for NEWS series.(NEWS-OS 4.X)"
	echo "6.BSD     for 386BSD, NetBSD, FreeBSD on PC-AT/PC-9801."
	echo "7.Linux   for Linux"
	echo "8.LUNA    for LUNA series.(UNIOS-B 1.X/2.X/3.X/MACH 2.X),BSD 4.3"
	echo "9.RS6000  for IBM RS6000(AIX 3.X)"
	echo "10.HP     for HP-UX 8.X/9.X"
	echo "11.ALPHA  for DEC ALPHA-AXP"
	echo "12.SGI    for SGI IRIS Crimson,Indigo2,Indy IRIX 4.X/5.X"
	echo "13.SVR4   for other System-V Release4."
	echo "              NEC EWS4800(EWS UX/V Rel4.X), UP4800(UP-UX/V)"
	echo "              OKIstation, SUN SUN-OS 5.X(Solaris 2.X)..."
#	echo "14.SVR3   for System-V Release3."
#	echo "              FACOM A-100 (compact-A/Astation) SX/A E60b"
#	echo "              NEC EWS4800/30 (CISC) EWS-UX/V (EWOS21) rel 8.1"
#	echo "              Mitsubishi ME (CISC) series.(ME/UX)..."
#	echo "15.MS-DOS for MS-DOS with socket library"
	echo "Q.quit"
	echo ""

	echo $n "ƥֹ:$c" ; read INPUT
	case "$INPUT" in
		"1")	ARCH="SUNOS_41"
			DATE="date +'%y-%m/%d(%a) %H:%M:%S'"
			DEFAULT_CC="/usr/ucb/cc"
			DEFAULT_CFLAGS="-O -target `arch`"
			DEFAULT_TMP_DIR="/var/tmp"
			Y_or_n "ѤΥƥ SUN-OS 4.1.X Ǥ?"
			if [ $? -eq 0 ] ; then
				ARCH="SUNOS_40"
			fi
			;;
		"2")	ARCH="SUNOS_3X"
			DATE="date +'%y-%m/%d(%a) %H:%M:%S'"
			DEFAULT_CC="/bin/cc"
			DEFAULT_CFLAGS="-O"
			DEFAULT_INSTALL="/usr/bin/install"
			DEFAULT_MAIL_SPOOL="/usr/spool/mail"
			DEFAULT_BOARD_SPOOL="/usr/spool/board"
			;;
		"3")	ARCH="DEC"
			;;
		"4")	ARCH="NEXT"
			DEFAULT_CFLAGS="-O -DPRINTF_ZERO"
			DEFAULT_INSTALL="/usr/bin/install"
			DEFAULT_MAIL_SPOOL="/usr/spool/mail"
			Y_or_n "ѤΥƥ Next Step 3.X Ǥ?"
			if [ $? -ne 0 ] ; then
				DEFAULT_CPP="/lib/cpp"
			fi
			;;
		"5")	ARCH="NEWS"
			DEFAULT_MH_PATH="/usr/new/mh"
			;;
		"6")	ARCH="_386BSD"
			DEFAULT_CFLAGS="-O -DDONT_HAVE_FTIME"
			DEFAULT_SENDMAIL="/usr/sbin/sendmail -t -om -oi"
			DEFAULT_CC="/usr/bin/cc"
			DEFAULT_INSTALL="/usr/bin/install"
			DEFAULT_MAIL_SPOOL="/var/mail"
			DEFAULT_BOARD_SPOOL="/var/board"
			;;
		"7")	ARCH="LINUX"
			DEFAULT_CFLAGS="-O -DTERMIO"
			DEFAULT_SENDMAIL="/usr/lib/sendmail -t -om -oi"
			DEFAULT_CC="/usr/bin/cc"
			DEFAULT_INSTALL="/usr/bin/install"
			DEFAULT_MAIL_SPOOL="/usr/spool/mail"
			DEFAULT_BOARD_SPOOL="/usr/spool/board"
			;;
		"8")	ARCH="LUNA"
			DEFAULT_CFLAGS="-O -DPRINTF_ZERO -DDONT_HAVE_VSPRINTF"
			DEFAULT_INSTALL="/usr/bin/install"
			DEFAULT_MAIL_SPOOL="/usr/spool/mail"
			DEFAULT_MH_PATH="/usr/new/mh"
			Y_or_n "ѤΥƥ UNI-OS 3.X Ǥ?"
			if [ $? -eq 1 ] ; then
				DEFAULT_CFLAGS="$DEFAULT_CFLAGS -DSTRNCASECMP"
			fi
			;;
		"9")	ARCH="SVR4"
			DEFAULT_CFLAGS="-O -DDONT_HAVE_FTIME -DUSE_TZNAME"
			DEFAULT_CC="/bin/cc"
			DEFAULT_INSTALL="/usr/ucb/install"
			RANLIB=true
			DEFAULT_TMP_DIR="/var/tmp"
			DEFAULT_MAIL_SPOOL="/usr/spool/mail"
			DEFAULT_BOARD_SPOOL="/var/board"
			LIB="-lbsd"
			;;
		"10")	ARCH="SVR4"
			DEFAULT_CFLAGS="-O -DDONT_HAVE_FTIME -DUSE_TZNAME"
			DEFAULT_CC="/bin/cc"
			DEFAULT_INSTALL="/etc/install"
			RANLIB=true
			DEFAULT_TMP_DIR="/tmp"
			DEFAULT_MAIL_SPOOL="/usr/mail"
			DEFAULT_BOARD_SPOOL="/var/board"
			;;
		"11")	ARCH="DEC"
			DEFAULT_CFLAGS="-O -DALPHA -DPRINTF_ZERO"
			DEFAULT_INSTALL="/usr/bin/install"
			DEFAULT_MAIL_SPOOL="/usr/spool/mail"
			LIB="-lbsd"
			;;
		"12")	ARCH="SVR4"
			DEFAULT_CFLAGS="-cckr -O -DDONT_HAVE_FTIME -DUSE_TZNAME -DSTRNCASECMP -DIRIX -USVR3"
			DEFAULT_CC="/usr/bin/cc"
			DEFAULT_INSTALL="/usr/ucb/install"
			RANLIB=true
			DEFAULT_TMP_DIR="/usr/tmp"
			DEFAULT_MAIL_SPOOL="/usr/mail"
			DEFAULT_BOARD_SPOOL="/var/board"
			LIB=""
			Y_or_n "ѤΥƥ IRIX 5.X Ǥ?"
			if [ $? -eq 0 ] ; then
				Y_or_n "NIS ѤƤޤ?"
				if [ $? -eq 1 ] ; then
					LIB="$LIB -lsun"
				fi
				DEFAULT_INSTALL="/usr/bin/X11/bsdinst.sh"
			else
				DEFAULT_INSTALL="/usr/bin/X11/bsdinst"
			fi
			;;
		"13")	ARCH="SVR4"
			DEFAULT_CFLAGS="-O -DDONT_HAVE_FTIME -DUSE_TZNAME"
			DEFAULT_CC="/bin/cc"
			DEFAULT_INSTALL="/usr/ucb/install"
			RANLIB=true
			DEFAULT_TMP_DIR="/var/tmp"
			DEFAULT_MAIL_SPOOL="/var/mail"
			DEFAULT_BOARD_SPOOL="/var/board"
			LIB="-lsocket -lnsl"
			;;
		"14")	ARCH="SVR3"
			DEFAULT_CFLAGS="-O -DDONT_HAVE_FTIME -DUSE_TZNAME"
			DEFAULT_CC="/bin/cc"
			DEFAULT_INSTALL="/etc/install"
			RANLIB=true
			DEFAULT_TMP_DIR="/tmp"
			DEFAULT_MAIL_SPOOL="/usr/mail"
			DEFAULT_BOARD_SPOOL="/usr/board"
			;;
		"15")	ARCH="MSDOS"
			DEFAULT_CFLAGS="-O"
			;;
		"Q")	exit 0
			;;
		*)	echo "ֹ椬Ǥ"
			;;
	esac
done
echo ""

BIN_DIR=""
while [ "$BIN_DIR" = "" ]
do
	echo "¹ԥե륤󥹥ȡǥ쥯ȥ̾ϤƲ"
	echo $n "¹ԥե륤󥹥ȡǥ쥯ȥ(ǥե:$DEFAULT_BIN_DIR):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT=$DEFAULT_BIN_DIR
	fi
	if [ -d "$INPUT" ] ; then
		BIN_DIR="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
	fi
done
echo ""

LIB_DIR=""
while [ "$LIB_DIR" = "" ]
do
	echo "饤֥ꥤ󥹥ȡǥ쥯ȥ̾ϤƲ"
	echo $n "饤֥ꥤ󥹥ȡǥ쥯ȥ(ǥե:$DEFAULT_LIB_DIR):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT=$DEFAULT_LIB_DIR
	fi
	if [ -d "$INPUT" ] ; then
		LIB_DIR="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
	fi
done
echo ""
JNAMES_DB="$LIB_DIR/jnames"
DOMAIN_FILE="$LIB_DIR/default-domain"
SERVER_FILE="$LIB_DIR/default-server"
MAIL_SERVER_FILE="$LIB_DIR/default-mailsv"

MAN_DIR=""
while [ "$MAN_DIR" = "" ]
do
	echo "ޥ˥奢륤󥹥ȡǥ쥯ȥ̾ϤƲ"
	echo $n "ޥ˥奢륤󥹥ȡǥ쥯ȥ(ǥե:$DEFAULT_MAN_DIR):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT=$DEFAULT_MAN_DIR
	fi
	if [ -d "$INPUT" ] ; then
		MAN_DIR="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
	fi
done
echo ""

TMP_DIR=""
while [ "$TMP_DIR" = "" ]
do
	echo "ȥǥ쥯ȥ̾ϤƲ"
	echo $n "ȥǥ쥯ȥ(ǥե:$DEFAULT_TMP_DIR):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT=$DEFAULT_TMP_DIR
	fi
	if [ -d "$INPUT" ] ; then
		TMP_DIR="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
	fi
done
echo ""

NEWS_SPOOL=""
while [ "$NEWS_SPOOL" = "" ]
do
	echo "˥塼סǥ쥯ȥ̾ϤƲ"
	echo $n "˥塼סǥ쥯ȥ(ǥե:$DEFAULT_NEWS_SPOOL):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT="$DEFAULT_NEWS_SPOOL"
	fi
	if [ -d "$INPUT" ] ; then
		NEWS_SPOOL="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
		Y_or_n "Υ顼̵뤷ޤ?"
		if [ $? -ne 0 ] ; then
			NEWS_SPOOL="$INPUT"
		fi
	fi
done
echo ""

NEWS_LIB=""
while [ "$NEWS_LIB" = "" ]
do
	echo "˥塼饤֥ǥ쥯ȥ̾ϤƲ"
	echo $n "˥塼饤֥ǥ쥯ȥ(ǥե:$DEFAULT_NEWS_LIB):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT="$DEFAULT_NEWS_LIB"
	fi
	if [ -d "$INPUT" ] ; then
		NEWS_LIB="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
		Y_or_n "Υ顼̵뤷ޤ?"
		if [ $? -ne 0 ] ; then
			NEWS_LIB="$INPUT"
		fi
	fi
done
echo ""

MAIL_SPOOL=""
while [ "$MAIL_SPOOL" = "" ]
do
	echo "᡼륹סǥ쥯ȥ̾ϤƲ"
	echo $n "᡼륹סǥ쥯ȥ(ǥե:$DEFAULT_MAIL_SPOOL):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT="$DEFAULT_MAIL_SPOOL"
	fi
	if [ -d "$INPUT" ] ; then
		MAIL_SPOOL="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
	fi
done
echo ""

POSTNEWS="$DEFAULT_POSTNEWS"
Y_or_n "˥塼Ƥ뵡ǽ(NEWSPOST)Ȥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DNEWSPOST"
	POSTNEWS=""
	while [ "$POSTNEWS" = "" ]
	do
		echo "˥塼ƤץȥץϤƲ"
		echo "⤷˥塼оǻѤʤʤ̵뤷ƥ꥿򲡤Ʋ"
		echo $n "˥塼ƥץȥץ(ǥե:$DEFAULT_POSTNEWS):$c"
		read INPUT
		if [ "$INPUT" = "" ] ; then
			INPUT="$DEFAULT_POSTNEWS"
		fi
		if [ -f `echo "$INPUT" | $AWK '{print $1}'` ] ; then
			POSTNEWS="$INPUT"
		else
			echo "ٹ:\"`echo "$INPUT" | $AWK '{print $1}'`\" Ĥޤ"
			POSTNEWS="$INPUT"
			Y_or_n "Υ顼̵뤷ޤ?"
			if [ $? -ne 1 ] ; then
				POSTNEWS=""
			fi
		fi
	done
fi
echo ""

INPUT=""
SENDMAIL="$DEFAULT_SENDMAIL"
Y_or_n "᡼뵡ǽ(MAILSEND)Ȥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DMAILSEND"
	SENDMAIL=""
	while [ "$SENDMAIL" = "" ]
	do
		echo "᡼ץȥץϤƲ"
		echo $n "᡼ץȥץ(ǥե:$DEFAULT_SENDMAIL):$c"
		read INPUT
		if [ "$INPUT" = "" ] ; then
			INPUT="$DEFAULT_SENDMAIL"
		fi
		if [ -f `echo "$INPUT" | $AWK '{print $1}'` ] ; then
			SENDMAIL="$INPUT"
		else
			echo "\"`echo "$INPUT" | $AWK '{print $1}'`\" Ĥޤ"
		fi
	done
fi
echo ""

Y_or_n "ǡ١ˤܸѴǽ(JNAMES)Ȥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DJNAMES"
	echo "ϥå奢르ꥺ JNAMES ⥸塼Ϲ®Ǥ̾⥸塼"
	echo "̤Υ񤷤ޤ"
	y_or_N "ϥå奢르ꥺ⥸塼(JNHASH)Ѥޤ?"
	if [ $? -eq 1 ] ; then
		MOD_OPT="$MOD_OPT -DJNHASH"
	fi
	if [ ! -f "$JNAMES_DB" ] ; then
		echo "ٹ:JNAMES ǡ١ \"$JNAMES_DB\" Ĥޤ"
	fi
fi
echo ""

MH_PATH="$DEFAULT_MH_PATH"
Y_or_n "MH ⡼(MH)Ȥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DMH"
	MH_PATH=""
	while [ "$MH_PATH" = "" ]
	do
		echo "MH ޥɥǥ쥯ȥϤƲ"
		echo $n "MH ޥɥǥ쥯ȥ(ǥե:$DEFAULT_MH_PATH):$c"
		read INPUT
		if [ "$INPUT" = "" ] ; then
			INPUT="$DEFAULT_MH_PATH"
		fi
		if [ -d "$INPUT" ] ; then
			MH_PATH="$INPUT"
		else
			echo "\"$INPUT\" Ĥޤ"
		fi
	done
fi
echo ""

Y_or_n "UCB-mail ⡼(UCBMAIL)Ȥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DUCBMAIL"
fi
echo ""

Y_or_n "RMAIL ⡼(RMAIL)Ȥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DRMAIL"
fi
echo ""

BOARD_SPOOL="$DEFAULT_BOARD_SPOOL"
y_or_N "BOARD (ŻҷǼ)⡼(BOARD)Ȥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DBOARD"
	BOARD_SPOOL=""
	while [ "$BOARD_SPOOL" = "" ]
	do
		echo "BOARD סǥ쥯ȥϤƲ"
		echo $n "ܡɥסǥ쥯ȥ(ǥե:$DEFAULT_BOARD_SPOOL):$c"
		read INPUT
		if [ "$INPUT" = "" ] ; then
			INPUT="$DEFAULT_BOARD_SPOOL"
		fi
		if [ -d "$INPUT" ] ; then
			BOARD_SPOOL="$INPUT"
		else
			echo "\"$INPUT\" Ĥޤ"
			BOARD_SPOOL="$INPUT"
			Y_or_n "Υ顼̵뤷ޤ?"
			if [ $? -ne 1 ] ; then
				BOARD_SPOOL=""
			fi
		fi
	done
fi
echo ""

echo "⤷ MIME 򥵥ݡȤм㴳®٤㲼ޤ"
Y_or_n "MIME ISO-2022-JP إå(MIME)򥵥ݡȤޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DMIME"
fi
echo ""

Y_or_n "¢ڡ㡼(PAGER)Ѥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DPAGER"
#	echo "®ڡ㡼̾ڡ㡼̤Υ񤷤ޤ"
#	y_or_N "®ڡ㡼(HPAGER)Ѥޤ?"
#	if [ $? -eq 1 ] ; then
#		MOD_OPT="$MOD_OPT -DHPAGER"
#	fi
fi
echo ""

PAGER=""
while [ "$PAGER" = "" ]
do
	echo "¢ڡ㡼Ȥ߹ -p ץ⤷"
	echo "եǻꤷΤ߳ڡ㡼Ѥޤ"
	echo "ڡ㡼ץȥץϤƲ"
	echo $n "ڡ㡼ץȥץ(ǥե:$DEFAULT_PAGER):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT="$DEFAULT_PAGER"
	fi
	if [ -f `echo "$INPUT" | $AWK '{print $1}'` ] ; then
		PAGER="$INPUT"
	else
		echo "ٹ:\"`echo "$INPUT" | $AWK '{print $1}'`\" Ĥޤ"
		PAGER="$INPUT"
		Y_or_n "Υ顼̵뤷ޤ?"
		if [ $? -ne 1 ] ; then
			PAGER=""
		fi
	fi
done
echo ""

Y_or_n "File carbon copy (FCC)ǽѤޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DFCC"
fi
echo ""

#y_or_N "᡼Υå͹(YOUBIN)Ѥޤ?"
#if [ $? -eq 1 ] ; then
#	CONS_OPT="$CONS_OPT -DYOUBIN"
#fi
#echo ""

echo "⤷ termcap 򥵥ݡȤм㴳®٤㲼ޤ"
y_or_N "termcap (TERMCAP)Ѥޤ?"
if [ $? -eq 1 ] ; then
	CONS_OPT="$CONS_OPT -DTERMCAP"
	LIB="$LIB -ltermcap"
fi
echo ""

INPUT=""
while [ "$INPUT" = "" ]
do
	echo "ե졼󥪥ץϤƲ"
	echo "-DCTRL_L            ^L ˤڡ򥵥ݡȤ롣"
	echo "-DCOMPLETION        եȥե̾䴰򥵥ݡȤ롣"
	echo "-DREF_SORT          ե󥹥Ȥ򥵥ݡȤ롣"
	echo "-DXOVER             NNTP  XOVER Ѥƹ®롣"
	echo "-DCOLOR             顼ɽ򥵥ݡȤ롣"
	echo "-DADD_HOSTNAME      ۥ̾ɥᥤ̾ɲä롣"
	echo "-DADD_HOSTPATH      ۥ̾ѥեɤɲä롣"
	echo "-DADD_MESSAGE_ID    Message-ID  mnews ɲä롣"
	echo "-DIGNORE_EDITOR     ǥλɤ̵뤹롣"
	echo "-DSELECT_EDITOR     񤯻˥ǥ򤹤롣"
	echo "-DUSE_NLINK         MH/BOARD ⡼ɤǥ󥯿Ѥƹ®롣"
	echo "-DDISPLAY_CTRL      ̵ʥȥ륳ɤ '^'+ʸȤƲĻ벽롣"
	echo "-DRESOLVE           쥾ФѤ롣"
	echo "-DLOCAL_POST         inews ѤƤ롣"
	echo "-DTRI               TRI õڥ르ꥺѤƹ®롣"
	echo "-DNNTP_AUTH         INN ǧڵǽб롣"
	echo "-DSEND_CONFIRM      ˥塼/᡼˳ǧ롣"
	echo "-DUSE_MSGCHK        ᡼Υå MH  msgchk Ѥ롣"
	echo "-DSCROLL_LAST       κǸǤ1ڡñ̤ǥ뤹롣"
	echo "-DSUPPORT_X0201     JIS-X0201 ʸ򥵥ݡȤ롣"
	echo $n "ץ(ǥե:$DEFAULT_CONF_OPT):$c" ; read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT="$DEFAULT_CONF_OPT"
	fi
	CONF_OPT="$INPUT"
done
echo ""
echo "$CONF_OPT" | grep 'RESOLVE' > /dev/null
if [ $? -eq 0 ] ; then
	DOMAINNAME=""
	y_or_N "Ѥ C ɸ饤֥ name resolver ޤǤޤ?"
	if [ $? -eq 0 ] ; then
		LIB="$LIB -lresolv"
	fi
	echo ""
else
	INPUT=""
	while [ "$INPUT" = "" ]
	do
		echo "ɥᥤ̾ϤƲ(:msr.mei.co.jp)"
		if [ "$DOMAINNAME" != "" ] ; then
			echo $n "ɥᥤ̾(ǥե:$DOMAINNAME):$c"
		else
			echo $n "ɥᥤ̾:$c"
			DOMAINNAME=""
		fi
		read INPUT
		if [ "$INPUT" = "" ]; then
			INPUT=$DOMAINNAME
		fi
		DOMAINNAME=$INPUT
	done
echo ""
fi

K_code "ǥեȤɽɤǲ" 4
AWK_FLAG="{ print \$$? }"
DISPLAY_CODE=`echo "$K_STRING" | $AWK "$AWK_FLAG"`
echo ""

K_code "ǥեȤȽǽɤǲ(פǤϤʤǤ)" 4
AWK_FLAG="{ print \$$? }"
UNKNOWN_CODE=`echo "$K_STRING" | $AWK "$AWK_FLAG"`
echo ""

K_code "ǥեȤΥ֥ɤǲ" 1
AWK_FLAG="{ print \$$? }"
SAVE_CODE=`echo "$K_STRING" | $AWK "$AWK_FLAG"`
echo ""

K_code "ǥեȤΥǥåȥɤǲ" 4
AWK_FLAG="{ print \$$? }"
EDIT_CODE=`echo "$K_STRING" | $AWK "$AWK_FLAG"`
echo ""

echo "⤷ܸ쥵֥ȤƤƤʤȤʤ\"̵Ѵ\"ǲ"
K_code "ǥեȤΥ֥ϥɤǲ" 1
AWK_FLAG="{ print \$$? }"
INPUT_CODE=`echo "$K_STRING" | $AWK "$AWK_FLAG"`
echo ""

K_code "ǥեȤ FCC ɤǲ" 1
AWK_FLAG="{ print \$$? }"
FCC_CODE=`echo "$K_STRING" | $AWK "$AWK_FLAG"`
echo ""

K_code "ǥեȤΥѥץɤǲ" 1
AWK_FLAG="{ print \$$? }"
PIPE_CODE=`echo "$K_STRING" | $AWK "$AWK_FLAG"`
echo ""

echo "NSPL ⡼ɤ NNTP Ѥ˥˥塼ǥ쥯ȥ򸫤뤳Ȥ̣Ƥޤ"
echo "ϥ˥塼оǼ¹ԤΤ̣߰Ǥ"
Y_or_n "ǥեȤǤϡNSPL ⡼(NSPL_MODE)Ȥޤ?"
NSPL_MODE=$?
echo ""

Y_or_n "ǥեȤǤϡܸå(JAPANESE_MODE)⡼ɤˤޤ?"
JAPANESE_MODE=$?
echo ""

echo "⤷ X-Nsubject եбˤܸ쥵֥Ȥ˥塼᡼륷ƥѹʤǤޤ"
y_or_N "ǥեȤǤϡX-Nsubject ե(X_NSUBJ_MODE)бˤޤ?"
X_NSUBJ_MODE=$?
echo ""

echo "NSPL ⡼ɤǤ mnews  inews ѤƵƤԤʤޤ"
echo "⤷ inews ưŪ signature ɲäʤ mnews ¦ signature ĤƤϤޤ"
Y_or_n "˥塼ƥץ(inews)ϡưŪ signature ɲ(INEWS_SIG_MODE)ޤ?"
INEWS_SIG_MODE=$?
echo ""

Y_or_n "ǥեȤǤϡդܻ֤ɽޤ?"
JST_MODE=$?
echo ""

echo "DNAS ⡼ɤǤ mnews ̵ʥ˥塼롼פưޤ"
y_or_N "ǥեȤǤϡDNAS ⡼ɤ򥵥ݡȤޤ?"
DNAS_MODE=$?
echo ""

echo "åɥ⡼ɤǤ mnews ϵ򥵥֥Ƚ˥Ȥޤ®٤㴳ޤ"
Y_or_n "ǥեȤǤϡåɥ⡼ɤǥ˥塼ɽޤ?"
NEWS_THREAD_MODE=$?
echo ""

y_or_N "ǥեȤǤϡåɥ⡼ɤǥ᡼뵭ɽޤ?"
MAIL_THREAD_MODE=$?
echo ""

CC=""
while [ "$CC" = "" ]
do
	echo "ѥץϤƲ"
	echo $n "ѥ(ǥե:$DEFAULT_CC):$c" ; read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT=$DEFAULT_CC
	fi
	if [ -f "$INPUT" ] ; then
		CC="$INPUT"
	else
		echo "\"$INPUT\" Ĥޤ"
	fi
done
echo ""

if [ "$DEFAULT_CPP" = "" ] ; then
	DEFAULT_CPP="$CC -E"
fi
CPP="$DEFAULT_CPP"
#CPP=""
#while [ "$CPP" = "" ]
#do
#	echo "ץꡦץåץ̾ϤƲ"
#	echo "⤷ 'cc -E' Ԥʤ 'cc -E'  'cpp' Ʋ"
#	echo $n "ץꡦץå(ǥե:$DEFAULT_CPP):$c" ; read INPUT
#	if [ "$INPUT" = "" ] ; then
#		INPUT=$DEFAULT_CPP
#	fi
#	if [ -f `echo "$INPUT" | $AWK '{print $1}'` ] ; then
#		CPP="$INPUT"
#	else
#		echo "\"$INPUT\" Ĥޤ"
#	fi
#done
#echo ""

echo "ѥ(Ŭ)ץϤƲ"
echo $n "ץ(ǥե:$DEFAULT_CFLAGS):$c" ; read INPUT
if [ "$INPUT" = "" ] ; then
	CFLAGS=$DEFAULT_CFLAGS
else
	CFLAGS="$INPUT"
fi
echo ""

EDITOR=""
while [ "$EDITOR" = "" ]
do
	echo "ǥեȤǻѤ륨ǥȥץϤƲ"
	echo $n "ǥȥץ(ǥե:$DEFAULT_EDITOR):$c"
	read INPUT
	if [ "$INPUT" = "" ] ; then
		INPUT="$DEFAULT_EDITOR"
	fi
	if [ -f `echo "$INPUT" | $AWK '{print $1}'` ] ; then
		EDITOR="$INPUT"
	else
		echo "\"`echo "$INPUT" | $AWK '{print $1}'`\" Ĥޤ"
	fi
done
echo ""

#INSTALL=""
#while [ "$INSTALL" = "" ]
#do
#	echo "󥹥ȡץϤƲ"
#	echo $n "󥹥ȡ(ǥե:$DEFAULT_INSTALL):$c" ; read INPUT
#	if [ "$INPUT" = "" ] ; then
#		INPUT=$DEFAULT_INSTALL
#	fi
#	if [ -f "$INPUT" ] ; then
#		INSTALL="$INPUT"
#	else
#		echo "\"$INPUT\" Ĥޤ"
#	fi
#done
#echo ""

rm -f default-domain

CONS_OPT=`echo $CONS_OPT | $SED -e "s/XXX //"`
echo "åȥƥ = $ARCH"
echo "åȹץ = $CONS_OPT"
echo "åꥪץ = $CONF_OPT"
echo "®⥸塼륪ץ = $MOD_OPT"

if [ "$DOMAINNAME" = "" ] ; then
	echo "ɥᥤ̾꥾Фޤ"
else
	echo "ɥᥤ̾            = \"$DOMAINNAME\""
	echo $DOMAINNAME > default-domain
fi
Y_or_n "ʾǤäƤޤ?"
if [ $? -eq 0 ] ; then
	exit 0
fi
echo ""

echo "ե졼եƤޤ"

cp /dev/null "$SITE_DEPEND"
echo "/*"							>> $SITE_DEPEND
echo " *"							>> $SITE_DEPEND
echo " *  System      : Mini News Reader"			>> $SITE_DEPEND
echo " *  Sub system  : Site depend define"			>> $SITE_DEPEND
echo " *  File        : $SITE_DEPEND"				>> $SITE_DEPEND
echo " *  Version     : $VERSION"				>> $SITE_DEPEND
echo " *"							>> $SITE_DEPEND
echo " *  NOTE:"						>> $SITE_DEPEND
echo " *   This file made by config.sh program."		>> $SITE_DEPEND
echo " *   If you want to change this file, please execute"	>> $SITE_DEPEND
echo " *   config.sh program again."				>> $SITE_DEPEND
echo " *"                                         		>> $SITE_DEPEND
echo " */"                                         		>> $SITE_DEPEND
echo ""								>> $SITE_DEPEND
echo "/*"							>> $SITE_DEPEND
echo " * If you define DOMAIN_NAME, DOMAIN_NAME used in"	>> $SITE_DEPEND
echo " * executable file, and DOMAIN_FILE does not need."	>> $SITE_DEPEND
echo " */"							>> $SITE_DEPEND
echo "/*"                                          		>> $SITE_DEPEND
echo "#define	DOMAIN_NAME	\"$DOMAINNAME\""	 	>> $SITE_DEPEND
echo "*/"                                          		>> $SITE_DEPEND
echo "#define	DOMAIN_FILE	\"$DOMAIN_FILE\""		>> $SITE_DEPEND
echo "#define	SERVER_FILE	\"$SERVER_FILE\""		>> $SITE_DEPEND
echo "#define	MAIL_SERVER_FILE \"$MAIL_SERVER_FILE\""		>> $SITE_DEPEND
echo "#define	EXT_PAGER	\"$PAGER\""			>> $SITE_DEPEND
echo "#define	PRINT_CODE	$DISPLAY_CODE"		 	>> $SITE_DEPEND
echo "#define	DEFAULT_CODE	$UNKNOWN_CODE"		 	>> $SITE_DEPEND
echo "#define	SAVE_CODE	$SAVE_CODE"			>> $SITE_DEPEND
echo "#define	EDIT_CODE	$EDIT_CODE"			>> $SITE_DEPEND
echo "#define	INPUT_CODE	$INPUT_CODE"			>> $SITE_DEPEND
echo "#define	FCC_CODE	$FCC_CODE"			>> $SITE_DEPEND
echo "#define	PIPE_CODE	$PIPE_CODE"			>> $SITE_DEPEND
echo "#define	EDITOR_COMMAND	\"$EDITOR\""			>> $SITE_DEPEND
echo "#define	SEND_COMMAND	\"$SENDMAIL\""		 	>> $SITE_DEPEND
echo "#define	POST_COMMAND	\"$POSTNEWS\""		 	>> $SITE_DEPEND
echo "#define	MH_COMMAND_PATH	\"$MH_PATH\""			>> $SITE_DEPEND
echo "#define	JNAMES_DB	\"$JNAMES_DB\""			>> $SITE_DEPEND
echo "#define	NEWS_SPOOL	\"$NEWS_SPOOL\""	 	>> $SITE_DEPEND
echo "#define	NEWS_LIB	\"$NEWS_LIB\""		 	>> $SITE_DEPEND
echo "#define	MAIL_SPOOL	\"$MAIL_SPOOL\""	 	>> $SITE_DEPEND
echo "#define	BOARD_SPOOL	\"$BOARD_SPOOL\""		>> $SITE_DEPEND
echo "#define	TMP_DIR		\"$TMP_DIR\""			>> $SITE_DEPEND
echo ""								>> $SITE_DEPEND
echo "#define	NSPL_MODE	$NSPL_MODE"			>> $SITE_DEPEND
echo "#define	JAPANESE	$JAPANESE_MODE"			>> $SITE_DEPEND
echo "#define	X_NSUBJ_MODE	$X_NSUBJ_MODE"		 	>> $SITE_DEPEND
echo "#define	INEWS_SIG_MODE	$INEWS_SIG_MODE"	 	>> $SITE_DEPEND
echo "#define	JST_MODE	$JST_MODE"			>> $SITE_DEPEND
echo "#define	DNAS_MODE	$DNAS_MODE"			>> $SITE_DEPEND
echo "#define	NEWS_THREAD_MODE	$NEWS_THREAD_MODE" 	>> $SITE_DEPEND
echo "#define	MAIL_THREAD_MODE	$MAIL_THREAD_MODE" 	>> $SITE_DEPEND

rm -f $MAKEFILE temp.c

MAKESRC=""
if [ -f Makefile.obj ] ; then
	MAKESRC="Makefile.obj"
fi
if [ -f makefile.obj ] ; then
	MAKESRC="makefile.obj"
fi
if [ -f Makefile.src ] ; then
	MAKESRC="Makefile.src"
fi
if [ -f makefile.src ] ; then
	MAKESRC="makefile.src"
fi
if [ "$MAKESRC" != "" ] ; then
	echo "\"$MAKESRC\" Ȥޤ"
	cp "$MAKESRC" temp.c
else
	echo "Makefile.src  Makefile.obj Ĥޤ"
	exit 1
fi

$CPP -D$ARCH $CONS_OPT $MOD_OPT temp.c | $SED -e "s/_CONS_OPT_/$CONS_OPT/g" \
	-e "s/_CONF_OPT_/$CONF_OPT/g" -e "s/_MOD_OPT_/$MOD_OPT/g" \
	-e "s/_ARCH_/$ARCH/g" \
	-e "s@_CC_@$CC@g" -e "s@_CC2_@$CC2@g" \
	-e "s@_BIN_DIR_@$BIN_DIR@g" -e "s@_MAN_DIR_@$MAN_DIR@g" \
	-e "s@_LIB_DIR_@$LIB_DIR@g" -e "s@_CFLAGS_@$CFLAGS@g" \
	-e "s@_LIB_@$LIB@g" -e "s@_RANLIB_@$RANLIB@g" \
	-e "s@_DATE_@$DATE@g" \
	-e "s@_INSTALL_@$INSTALL@g" > $MAKEFILE
\rm -f temp.c

echo "Ͻλޤ\"$MAKEFILE\"  \"$SITE_DEPEND\" ΤƲ"
echo "ΤὪä¹ԥե뤿 \"make\" ȥפƲ"

exit 0
