/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1991-1994 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : File carbon copy routine
 *  File        : fcc.c
 *  Version     : 1.19
 *  First Edit  : 1993-05/07
 *  Last  Edit  : 1995-09/30
 *  Author      : MSR24  
 *
 */

#ifdef	FCC
#include	"compat.h"
#include	"nntplib.h"
#include	"kanjilib.h"
#include	"mnews.h"
#include	"fcc.h"

int	fcc_save(file_name, from, date, fcc)
     char	*file_name;
     char	*from;
     char	*date;
     char	*fcc;
{
  FILE	*fp1;
  DIR_PTR	*dp;
  struct stat	stat_buff;
  FILE		*fp2;
  DIR		*dir_ptr;
  struct tm	*tm;
#ifndef	DONT_HAVE_FTIME
  struct timeb	timeb;
#endif	/* !DONT_HAVE_FTIME */
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  char		*ptr;
  time_t	now_time;
  int		i, j;
  int		status;

  if ((fp1 = fopen(file_name, "r")) == (FILE*)NULL) {
    return(1);
  }
  j = 1;
  fp2 = NULL;
  if (fcc) {
    ptr = fcc;
    while (((unsigned char)*ptr) >= ' ') {
      ptr++;
    }
    *ptr = '\0';
    if (fcc[0] == SLASH_CHAR) {
      strcpy(buff1, fcc);
    } else if (!strncmp(fcc, "~/", 2)) {
      sprintf(buff1, "%s%c%s", home_dir, SLASH_CHAR, &fcc[2]);
    } else {
      sprintf(buff1, "%s%c%s", home_dir, SLASH_CHAR, fcc);
    }
    if ((!stat(buff1, &stat_buff)) && (stat_buff.st_mode & S_IFDIR)) {
      if ((dir_ptr = opendir(buff1)) != (DIR*)NULL) {
	status = 0;
	while ((dp = readdir(dir_ptr)) != (DIR_PTR*)NULL) {
	  ptr = buff2;
	  strcpy(ptr, dp->d_name);
	  i = 0;
	  while (1) {
	    j = *ptr++ - '0';
	    if ((j >= 0) && (j < 10)) {
	      i = i * 10 + j;
	    } else {
	      ptr--;
	      break;
	    }
	  }
	  if (!(*ptr) && i) {
	    if (status < i) {
	      status = i;
	    }
	  }
	}
	closedir(dir_ptr);
	sprintf(buff2, "%s%c%d", buff1, SLASH_CHAR, status + 1);
	fp2 = fopen(buff2, "w");
	chmod(buff2, S_IREAD | S_IWRITE);
	j = 0;	/* MH 		*/
      }
    } else {
      if ((fp2 = fopen(buff1, "a")) != (FILE*)NULL) {
	if (!ftell(fp2)) {
	  fputc('\n', fp2);
	}
      }
      chmod(buff1, S_IREAD | S_IWRITE);
      j = 1;	/* UCB-mail 	*/
    }
  }
  if (fp2 != (FILE*)NULL) {
    fclose(fp1);
    return(1);
  }
  now_time = time(NULL);
  tm = localtime(&now_time);
  if (j) {
    fprintf(fp2, "%s%s %s %s %2d %02d:%02d:%02d 19%d\n", FCC_FROM_FIELD, from,
	    day_string[tm->tm_wday + 1], month_string[tm->tm_mon + 1],
	    tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec, tm->tm_year);
  }
  if (!date[0]) {
    fprintf(fp2, "%s %s, %d %s %d %02d:%02d:%02d ", DATE_FIELD,
	    day_string[tm->tm_wday + 1],
	    tm->tm_mday,
	    month_string[tm->tm_mon + 1],
	    tm->tm_year,
	    tm->tm_hour,
	    tm->tm_min,
	    tm->tm_sec);
#ifdef	USE_TZNAME
#if	notdef
    fprintf(fp2, "%s\n", tm->tm_zone);
#else	/* !notdef */
    tzset();
    if (tm->tm_isdst > 0) {
      fprintf(fp2, "%s\n", tzname[1]);
    } else {
      fprintf(fp2, "%s\n", tzname[0]);
    }
#endif	/* !notdef */
#else	/* !USE_TZNAME */
#ifdef	DONT_HAVE_FTIME
#ifdef  SVR3
    status = timezone / 60;
#else	/* !SVR3 */
    status = (tm->tm_gmtoff) / 60;
#endif	/* !SVR3 */
#else	/* !DONT_HAVE_FTIME */
    ftime(&timeb);
    status = -timeb.timezone;
#endif	/* !DONT_HAVE_FTIME */
    if (status > 0) {
      fprintf(fp2, "+%02d%02d\n", status / 60, status % 60);
    } else if (status < 0) {
      status = -status;
      fprintf(fp2, "-%02d%02d\n", status / 60, status % 60);
    } else {
      fprintf(fp2, "GMT\n");
    }
#endif	/* !USE_TZNAME */
  }
  while (fgets(buff1, sizeof(buff1), fp1)) {
    switch (fcc_code) {
    case JIS_CODE:
      to_jis(buff2, buff1, default_code);
      break;
    case SJIS_CODE:
      to_sjis(buff2, buff1, default_code);
      break;
    case EUC_CODE:
      to_euc(buff2, buff1, default_code);
      break;
    default:
      strcpy(buff2, buff1);
      break;
    }
    if ((!strncmp(buff2, FCC_FROM_FIELD, sizeof(FCC_FROM_FIELD) - 1))
	& j) {
      fputc('>', fp2);
      fputs(buff2, fp2);
    } else {
      fputs(buff2, fp2);
    }
  }
  if (j) {
    fputc('\n', fp2);
  }
  fclose(fp2);
  fclose(fp1);
  return(0);
}
#endif	/* FCC */
