/*
 *
 *  Ѵ饤֥
 *
 *  Copyright 1990-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Kanji Convert Library
 *  Sub system  : library routine
 *  File        : kanjilib.c
 *  Version     : 2.08
 *  First Edit  : 1990-11/01
 *  Last  Edit  : 1995-08/21
 *  Author      : MSR24  
 *
 */

#include	<stdio.h>
#include	<ctype.h>
#ifdef	__STDC__
#include	<stdarg.h>
#else	/* !__STDC__ */
#include	<varargs.h>
#endif	/* !__STDC__ */
#include	"kanjilib.h"

#ifdef	notdef
static int	bsprintf();		/* եޥåȽ	*/
#endif	/* notdef */
#ifdef	DISPLAY_CTRL
static void	strcpy2();
#else	/* !DISPLAY_CTRL */
#define	strcpy2(s1, s2)	strcpy(s1, s2)
#endif	/* !DISPLAY_CTRL */

KANJICODE	print_code;		/* 		*/

char	jis_in[8]   = JIS_IN;		/* ؼ	*/
char	jis_out[8]  = JIS_OUT;		/* ޻ؼ	*/
int	jis_in_len  = sizeof(JIS_IN) - 1;
int	jis_out_len = sizeof(JIS_OUT) - 1;

char	*kanji_code_string[] = {	/* ̾		*/
  "ASCII",
  "JIS",
  "SJIS",
  "EUC",
  "UNKNOWN",
};

#ifdef	notdef
static char	small_hex_char[] = "0123456789abcdef";
static char	large_hex_char[] = "0123456789ABCDEF";
#endif	/* notdef */

/*
 * 饤֥
 */

void	jis_mode(mode)
     int	mode;	/* 0:JIS, 0ʳ:JIS */
{
  if (mode) {
    strcpy(jis_in, JIS_IN2);
    strcpy(jis_out, JIS_OUT2);
  } else {
    strcpy(jis_in, JIS_IN1);
    strcpy(jis_out, JIS_OUT1);
  }
}

/*
 * JISSJIS Ѵ
 */

void	jis_to_sjis(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  register CHARSET	charset = ROMAN_CHAR;
  
  while (*ptr2) {
    if (*ptr2 == ESC_CODE) {
      if ((!strncmp(ptr2, JIS_IN1, 3)) || (!strncmp(ptr2, JIS_IN2, 3))) {
	
	/*	ؼ	*/
	
	charset = KANJI_CHAR;
	ptr2 += 3;
      } else if (!strncmp(ptr2, JIS_IN3, 4)) {
	
	/*	ؼ	*/
	
	charset = KANJI_CHAR;
	ptr2 += 4;
      } else if ((!strncmp(ptr2, JIS_OUT1, 3))
		 || (!strncmp(ptr2, JIS_OUT2, 3))) {
	
	/*	޻ؼ	*/
	
	charset = ROMAN_CHAR;
	ptr2 += 3;
#ifdef	SUPPORT_X0201
      } else if (!strncmp(ptr2, JIS_X0201, 3)) {

	/*	Ҳ̾ؼ	*/

	charset = KANA_CHAR;
	ptr2 += 3;
#endif	/* SUPPORT_X0201 */
      } else if (!strncmp(ptr2, JIS_X0212, 4)) {
	
	/*	ؼ	*/
	
#ifdef	DELETE_X0212
	charset = ROMAN_CHAR;
#else	/* !DELETE_X0212 */
	charset = HOJO_CHAR;
#endif	/* !DELETE_X0212 */
	ptr2 += 4;
      } else {
#ifdef	DISPLAY_CTRL
	*ptr1++ = '^';
	*ptr1++ = '[';
	ptr2++;
#else	/* !DISPLAY_CTRL */
	*ptr1++ = *ptr2++;
#endif	/* !DISPLAY_CTRL */
	while (*ptr2) {
	  if ((*ptr2 < 0x30) || (*ptr2 > 0x7e)) {
	    *ptr1++ = *ptr2++;
	  } else {
	    *ptr1++ = *ptr2++;
	    break;
	  }
	}
      }
    } else {
      switch (charset) {
      case KANA_CHAR:
	*ptr1++ = (*ptr2++) | 0x80;
	break;
      case KANJI_CHAR:
	*ptr1++ = *ptr2++;
	*ptr1   = *ptr2++;
	if (!(*(ptr1 - 1) % 2)) {
	  (*ptr1) += 0x7d;
	} else {
	  (*ptr1) += 0x1f;
	}
	if (*ptr1 >= 0x7f) {
	  (*ptr1) += 1;
	}
	*(ptr1 - 1) = ((unsigned int)(*(ptr1 - 1) - 0x21)) / 2 + 0x81;
	if (*(ptr1 - 1) > 0x9f) {
	  (*(ptr1 - 1)) += 0x40;
	}
	ptr1++;
	break;
      case HOJO_CHAR:		/* ݡȤǤƤޤ	*/
	*ptr1++ = *ptr2++;
	break;
      case ROMAN_CHAR:
      default:
	*ptr1++ = *ptr2++;
	break;
      }
    }
  }
  *ptr1 = '\0';
}

/*
 * JISEUC Ѵ
 */

void	jis_to_euc(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  register CHARSET	charset = ROMAN_CHAR;
  
  while (*ptr2) {
    if (*ptr2 == ESC_CODE) {
      if ((!strncmp(ptr2, JIS_IN1, 3)) || (!strncmp(ptr2, JIS_IN2, 3))) {
	
	/*	ؼ	*/
	
	charset = KANJI_CHAR;
	ptr2 += 3;
      } else if (!strncmp(ptr2, JIS_IN3, 4)) {
	
	/*	ؼ	*/
	
	charset = KANJI_CHAR;
	ptr2 += 4;
      } else if ((!strncmp(ptr2, JIS_OUT1, 3))
		 || (!strncmp(ptr2, JIS_OUT2, 3))) {
	
	/*	޻ؼ	*/
	
	charset = ROMAN_CHAR;
	ptr2 += 3;
#ifdef	SUPPORT_X0201
      } else if (!strncmp(ptr2, JIS_X0201, 3)) {

	/*	Ҳ̾ؼ	*/

	charset = KANA_CHAR;
	ptr2 += 3;
#endif	/* SUPPORT_X0201 */
      } else if (!strncmp(ptr2, JIS_X0212, 4)) {
	
	/*	ؼ	*/
	
#ifdef	DELETE_X0212
	charset = ROMAN_CHAR;
#else	/* !DELETE_X0212 */
	charset = HOJO_CHAR;
#endif	/* !DELETE_X0212 */
	ptr2 += 4;
      } else {
#ifdef	DISPLAY_CTRL
	*ptr1++ = '^';
	*ptr1++ = '[';
	ptr2++;
#else	/* !DISPLAY_CTRL */
	*ptr1++ = *ptr2++;
#endif	/* !DISPLAY_CTRL */
	while (*ptr2) {
	  if ((*ptr2 < 0x30) || (*ptr2 > 0x7e)) {
	    *ptr1++ = *ptr2++;
	  } else {
	    *ptr1++ = *ptr2++;
	    break;
	  }
	}
      }
    } else {
      switch (charset) {
      case KANA_CHAR:
	*ptr1++ = EUC_SS2;
	*ptr1++ = (*ptr2++) | 0x80;
	break;
      case HOJO_CHAR:
	*ptr1++ = EUC_SS3;
      case KANJI_CHAR:
	*ptr1++ = (*ptr2++ | 0x80);
	*ptr1++ = (*ptr2++ | 0x80);
	break;
      case ROMAN_CHAR:
      default:
	*ptr1++ = *ptr2++;
	break;
      }
    }
  }
  *ptr1 = '\0';
}

/*
 * EUCJIS Ѵ
 */

void	euc_to_jis(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  register CHARSET	charset = ROMAN_CHAR;

  while (*ptr2) {
    if (*ptr2 & 0x80) {
#ifdef	SUPPORT_X0201
      if (*ptr2 == EUC_SS2) {
	if (charset != KANA_CHAR) {

	  /*	Ҳ̾ؼ	*/

	  charset = KANA_CHAR;
	  strcpy(ptr1, JIS_X0201);
	  ptr1 += 3;
	}
	ptr2++;
	*ptr1++ = *ptr2++ & 0x7f;
	continue;
      }
#endif	/* SUPPORT_X0201 */
      if (*ptr2 == EUC_SS3) {
#ifdef	DELETE_X0212
	ptr2 += 4;
#else	/* !DELETE_X0212 */
	if (charset != HOJO_CHAR) {

	  /*	ؼ	*/

	  charset = HOJO_CHAR;
	  strcpy(ptr1, JIS_X0212);
	  ptr1 += 4;
	}
	ptr2++;
	*ptr1++ = *ptr2++ & 0x7f;
	*ptr1++ = *ptr2++ & 0x7f;
#endif	/* !DELETE_X0212 */
	continue;
      }
      if (charset != KANJI_CHAR) {
	
	/*	ؼ	*/

	charset = KANJI_CHAR;
	strcpy(ptr1, jis_in);
	ptr1 += jis_in_len;
      }
      *ptr1++ = *ptr2++ & 0x7f;
      *ptr1++ = *ptr2++ & 0x7f;
    } else {
      if (charset) {

	/*	޻ؼ	*/

	charset = ROMAN_CHAR;
	strcpy(ptr1, jis_out);
	ptr1 += jis_out_len;
      }
      *ptr1++ = *ptr2++;
    }
  }
  if (charset) {

    /*	޻ؼ	*/

    strcpy(ptr1, jis_out);
  } else {
    *ptr1 = '\0';
  }
}

/*
 * EUCSJIS Ѵ
 */

void	euc_to_sjis(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  while (*ptr2) {
    if (*ptr2 & 0x80) {
#ifdef	SUPPORT_X0201
      if (*ptr2 == EUC_SS2) {

	/*	Ҳ̾	*/

	ptr2++;
	*ptr1++ = *ptr2++;
	continue;
      }
#endif	/* SUPPORT_X0201 */

      /*		*/

      *ptr1++ = *ptr2++ & 0x7f;
      *ptr1   = *ptr2++ & 0x7f;
      if (*(ptr1 - 1) & 1) {
	*ptr1 += 0x1f;
      } else {
	*ptr1 += 0x7d;
      }
      if (*ptr1 >= 0x7f) {
	*ptr1 += 1;
      }
      ptr1--;
      *ptr1 = ((unsigned int)(*ptr1 - 0x21)) / 2 + 0x81;
      if (*ptr1 > 0x9f) {
	*ptr1 += 0x40;
      }
      ptr1 += 2;
    } else {

      /*		*/

      *ptr1++ = *ptr2++;
    }
  }
  *ptr1 = '\0';
}

/*
 * SJISJIS Ѵ
 */

void	sjis_to_jis(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  register CHARSET	charset = ROMAN_CHAR;
  
  while (*ptr2) {
    if (*ptr2 & 0x80) {
#ifdef	SUPPORT_X0201
      if ((*ptr2 >= 0xa0) && (*ptr2 < 0xe0)) {
	if (charset != KANA_CHAR) {

	  /*	Ҳ̾ؼ	*/

	  charset = KANA_CHAR;
	  strcpy(ptr1, JIS_X0201);
	  ptr1 += 3;
	}
	*ptr1++ = *ptr2++ & 0x7f;
	continue;
      }
#endif	/* SUPPORT_X0201 */
      if (charset != KANJI_CHAR) {

	/*	ؼ	*/

	charset = KANJI_CHAR;
	strcpy(ptr1, jis_in);
	ptr1 += jis_in_len;
      }
      if (*ptr2 <= 0x9f) {
	*ptr1++ = ((*ptr2++) - 0x71) * 2 + 1;
      } else {
	*ptr1++ = ((*ptr2++) - 0xb1) * 2 + 1;
      }
      if (*ptr2 > 0x7f) {
	*ptr1 = (*ptr2++) - 1;
      } else {
	*ptr1 = *ptr2++;
      }
      if (*ptr1 >= 0x9e) {
	*(ptr1) -= 0x7d;
	*(ptr1 - 1) += 1;
      } else {
	*(ptr1) -= 0x1f;
      }
      ptr1++;
    } else {
      if (charset) {

	/*	޻ؼ	*/

	charset = ROMAN_CHAR;
	strcpy(ptr1, jis_out);
	ptr1 += jis_out_len;
      }
      *ptr1++ = *ptr2++;
    }
  }
  if (charset) {

    /*	޻ؼ	*/

    strcpy(ptr1, jis_out);
    ptr1 += jis_out_len;
  }
  *ptr1 = '\0';
}

/*
 * SJISEUC Ѵ
 */

void	sjis_to_euc(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  while (*ptr2) {
    if (*ptr2 & 0x80) {
#ifdef	SUPPORT_X0201
      if ((*ptr2 >= 0xa0) && (*ptr2 < 0xe0)) {
	*ptr1++ = EUC_SS2;
	*ptr1++ = *ptr2++;
	continue;
      }
#endif	/* SUPPORT_X0201 */
      if (*ptr2 <= 0x9f) {
	*ptr1++ = ((*ptr2++) - 0x71) * 2 + 1;
      } else {
	*ptr1++ = ((*ptr2++) - 0xb1) * 2 + 1;
      }
      if (*ptr2 > 0x7f) {
	*ptr1 = (*ptr2++) - 1;
      } else {
	*ptr1 = *ptr2++;
      }
      if (*ptr1 >= 0x9e) {
	*(ptr1) -= 0x7d;
	*(ptr1 - 1) += 1;
      } else {
	*(ptr1) -= 0x1f;
      }
      *(ptr1 - 1) |= 0x80;
      *(ptr1) |= 0x80;
      ptr1++;
    } else {
      *ptr1++ = *ptr2++;
    }
  }
  *ptr1 = '\0';
}

/*
 * JISJIS Ѵ(ץ)
 */

void	jis_to_jis(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  register CHARSET	charset1 = ROMAN_CHAR;
  register CHARSET	charset2 = ROMAN_CHAR;
  
  while (*ptr2) {
    if (*ptr2 == ESC_CODE) {
      if ((!strncmp(ptr2, JIS_IN1, 3)) || (!strncmp(ptr2, JIS_IN2, 3))) {
	
	/*	ؼ	*/
	
	charset1 = KANJI_CHAR;
	ptr2 += 3;
      } else if (!strncmp(ptr2, JIS_IN3, 4)) {
	
	/*	ؼ	*/
	
	charset1 = KANJI_CHAR;
	ptr2 += 4;
      } else if ((!strncmp(ptr2, JIS_OUT1, 3))
		 || (!strncmp(ptr2, JIS_OUT2, 3))) {
	
	/*	޻ؼ	*/
	
	charset1 = ROMAN_CHAR;
	ptr2 += 3;
#ifdef	SUPPORT_X0201
      } else if (!strncmp(ptr2, JIS_X0201, 3)) {

	/*	Ҳ̾ؼ	*/

	charset1 = KANA_CHAR;
	ptr2 += 3;
#endif	/* SUPPORT_X0201 */
      } else if (!strncmp(ptr2, JIS_X0212, 4)) {
	
	/*	ؼ	*/
	
#ifdef	DELETE_X0212
	charset1 = ROMAN_CHAR;
#else	/* !DELETE_X0212 */
	charset1 = HOJO_CHAR;
#endif	/* !DELETE_X0212 */
	ptr2 += 4;
      } else {
#ifdef	DISPLAY_CTRL
	*ptr1++ = '^';
	*ptr1++ = '[';
	ptr2++;
#else	/* !DISPLAY_CTRL */
	*ptr1++ = *ptr2++;
#endif	/* !DISPLAY_CTRL */
	while (*ptr2) {
	  if ((*ptr2 < 0x30) || (*ptr2 > 0x7e)) {
	    *ptr1++ = *ptr2++;
	  } else {
	    *ptr1++ = *ptr2++;
	    break;
	  }
	}
      }
    } else {
      if (charset1) {
	if (charset1 != charset2) {
	  switch (charset1) {
	  case KANA_CHAR:
	    strcpy(ptr1, JIS_X0201);
	    ptr1 += 3;
	    break;
	  case KANJI_CHAR:
	    strcpy(ptr1, jis_in);
	    ptr1 += jis_in_len;
	    break;
	  case HOJO_CHAR:
	    strcpy(ptr1, JIS_X0212);
	    ptr1 += 4;
	    break;
	  default:
	    break;
	  }
	  charset2 = charset1;
	}
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
      } else {
	if (charset2) {
	  strcpy(ptr1, jis_out);
	  ptr1 += jis_out_len;
	  charset2 = ROMAN_CHAR;
	}
	*ptr1++ = *ptr2++;
      }
    }
  }
  if (charset2) {
    strcpy(ptr1, jis_out);
  } else {
    *ptr1 = '\0';
  }
}

/*
 * JIS ʸ󥳥ԡ()
 */

int	jis_strncpy(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  return(kanji_strncpy(ptr1, ptr2, count));
}

/*
 * EUC ʸ󥳥ԡ()
 */

int	euc_strncpy(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  unsigned char	*ptr3;
  
  ptr3 = ptr2;
  while (count > 0) {
    if (!*ptr2) {
      break;
    } else if (*ptr2 & 0x80) {
      if (*ptr2 == EUC_SS3) {
#ifdef	DELETE_X0212
	ptr2++;
	if (*ptr2) {
	  ptr2++;
	  if (*ptr2) {
	    ptr2++;
	  }
	}
#else	/* !DELETE_X0212 */
	if (count < 3) {
	  count = 0;
	} else {
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  count -= 3;
	}
#endif	/* !DELETE_X0212 */
      } else {
	if (count < 2) {
	  count = 0;
	} else {
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  count -= 2;
	}
      }
    } else {
      *ptr1++ = *ptr2++;
      count--;
    }
  }
  *ptr1 = '\0';
  return(ptr2 - ptr3);
}

/*
 * SJIS ʸ󥳥ԡ()
 */

int	sjis_strncpy(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  unsigned char	*ptr3;
  
  ptr3 = ptr2;
  while (count > 0) {
    if (!*ptr2) {
      break;
    } else if (*ptr2 & 0x80) {
      if (count < 2) {
	count = 0;
      } else {
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	count -= 2;
      }
    } else {
      *ptr1++ = *ptr2++;
      count--;
    }
  }
  *ptr1 = '\0';
  return(ptr2 - ptr3);
}

/*
 * JIS ʸ󥳥ԡ(ѥǥͭ)
 */

int	jis_strncpy2(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  return(kanji_strncpy2(ptr1, ptr2, count));
}

/*
 * EUC ʸ󥳥ԡ(ѥǥͭ)
 */

int	euc_strncpy2(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  unsigned char	*ptr3;
  
  ptr3 = ptr2;
  while (count > 0) {
    if (!*ptr2) {
      break;
    } else if (*ptr2 & 0x80) {
      if (*ptr2 == EUC_SS3) {
#ifdef	DELETE_X0212
	ptr2++;
	if (*ptr2) {
	  ptr2++;
	  if (*ptr2) {
	    ptr2++;
	  }
	}
#else	/* !DELETE_X0212 */
	if (count < 3) {
	  break;
	} else {
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  count -= 3;
	}
#endif	/* !DELETE_X0212 */
      } else {
	if (count < 2) {
	  break;
	} else {
	  *ptr1++ = *ptr2++;
	  *ptr1++ = *ptr2++;
	  count -= 2;
	}
      }
    } else {
      *ptr1++ = *ptr2++;
      count--;
    }
  }
  while (count-- > 0) {
    *ptr1++ = ' ';
  }
  *ptr1 = '\0';
  return(ptr2 - ptr3);
}

/*
 * SJIS ʸ󥳥ԡ(ѥǥͭ)
 */

int	sjis_strncpy2(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  unsigned char	*ptr3;
  
  ptr3 = ptr2;
  while (count > 0) {
    if (!*ptr2) {
      break;
    } else if (*ptr2 & 0x80) {
      if (count < 2) {
	break;
      } else {
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	count -= 2;
      }
    } else {
      *ptr1++ = *ptr2++;
      count--;
    }
  }
  while (count-- > 0) {
    *ptr1++ = ' ';
  }
  *ptr1 = '\0';
  return(ptr2 - ptr3);
}

/*
 * JIS ʸɽ
 */

#ifdef	DONT_HAVE_DOPRNT
void	jis_printf(fmt, arg1, arg2, arg3, arg4, arg5, arg6)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  jis_fprintf(stdout, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	jis_printf(char *fmt, ...)
#else	/* __STDC__ */
void	jis_printf(fmt, va_alist)
     char	*fmt;
#endif	/* __STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    jis_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    jis_to_sjis(buff2, buff1);
    break;
  case EUC_CODE:
    jis_to_euc(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  printf("%s", buff2);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * EUC ʸɽ
 */

#ifdef	DONT_HAVE_DOPRNT
void	euc_printf(fmt, arg1, arg2, arg3, arg4, arg5, arg6)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  euc_fprintf(stdout, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	euc_printf(char *fmt, ...)
#else	/* !__STDC__ */
void	euc_printf(fmt, va_alist)
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    euc_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    euc_to_sjis(buff2, buff1);
    break;
  case EUC_CODE:
    strcpy2(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  printf("%s", buff2);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * SJIS ʸɽ
 */

#ifdef	DONT_HAVE_DOPRNT
void	sjis_printf(fmt, arg1, arg2, arg3, arg4, arg5, arg6)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  euc_fprintf(stdout, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	sjis_printf(char *fmt, ...)
#else	/* !__STDC__ */
void	sjis_printf(fmt, va_alist)
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];

#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    sjis_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    strcpy2(buff2, buff1);
    break;
  case EUC_CODE:
    sjis_to_euc(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  printf("%s", buff2);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * JIS ʸ
 */

#ifdef	DONT_HAVE_DOPRNT
void	jis_fprintf(fp, fmt, arg1, arg2, arg3, arg4, arg5, arg6)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
  sprintf(buff1, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
  switch (print_code) {
  case JIS_CODE:
    jis_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    jis_to_sjis(buff2, buff1);
    break;
  case EUC_CODE:
    jis_to_euc(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
}
#else	/* DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	jis_fprintf(FILE *fp, char *fmt, ...)
#else	/* !__STDC__ */
void	jis_fprintf(fp, fmt, va_alist)
     FILE	*fp;
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    jis_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    jis_to_sjis(buff2, buff1);
    break;
  case EUC_CODE:
    jis_to_euc(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
  va_end(ap);
}
#endif	/* DONT_HAVE_DOPRNT */

/*
 * EUC ʸ
 */

#ifdef	DONT_HAVE_DOPRNT
void	euc_fprintf(fp, fmt, arg1, arg2, arg3, arg4, arg5, arg6)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
  sprintf(buff1, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
  switch (print_code) {
  case JIS_CODE:
    euc_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    euc_to_sjis(buff2, buff1);
    break;
  case EUC_CODE:
    strcpy2(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
}
#else	/* DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	euc_fprintf(FILE *fp, char *fmt, ...)
#else	/* !__STDC__ */
void	euc_fprintf(fp, fmt, va_alist)
     FILE	*fp;
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    euc_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    euc_to_sjis(buff2, buff1);
    break;
  case EUC_CODE:
    strcpy2(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
  va_end(ap);
}
#endif	/* DONT_HAVE_DOPRNT */

/*
 * SJIS ʸ
 */

#ifdef	DONT_HAVE_DOPRNT
void	sjis_fprintf(fp, fmt, arg1, arg2, arg3, arg4, arg5, arg6)
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
  sprintf(buff1, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
  switch (print_code) {
  case JIS_CODE:
    sjis_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    strcpy2(buff2, buff1);
    break;
  case EUC_CODE:
    sjis_to_euc(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
}
#else	/* DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	sjis_fprintf(FILE *fp, char *fmt, ...)
#else	/* !__STDC__ */
void	sjis_fprintf(fp, fmt, va_alist)
     FILE	*fp;
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    sjis_to_jis(buff2, buff1);
    break;
  case SJIS_CODE:
    strcpy2(buff2, buff1);
    break;
  case EUC_CODE:
    sjis_to_euc(buff2, buff1);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
  va_end(ap);
}
#endif	/* DONT_HAVE_DOPRNT */

#ifdef	notdef
/*
 * եޥåȽ
 */

static int	bsprintf(ptr, fmt, ap)
     char	*ptr;
     char	*fmt;
     int	*ap;
{
  static char	buff[16];
  int		length;
  unsigned int	number;
  char		*top;
  char		*str;
  char		pad_char;

  top = ptr;
  while (*fmt) {
    switch (*fmt) {
    case '%':
      pad_char = ' ';
      fmt++;
      length = 0;
      if (*fmt == '0') {
	fmt++;
	pad_char = '0';
      }
      while (isdigit(*fmt)) {
	length = length * 10 + (*fmt++) - '0';
      }
      if (length > 10) {
	length = 10;
      }
      switch (*fmt) {
      case 0:
	fmt--;
	break;
      case 'c':		/* ʸ		*/
      case 'C':
	*ptr++ = (char)(*ap++);
	break;
      case 'd':
      case 'i':
      case 'D':
      case 'I':		/* 10Ĥ	*/
      case 'u':
      case 'U':		/* 10ʤ	*/
	str = buff;
	number = (unsigned int)*ap++;
	if ((*fmt != 'U') && (*fmt != 'u')) {
	  if ((int)number < 0) {
	    *ptr++ = '-';
	    number = -((int)number);
	    length--;
	  }
	}
	do {
	  *str++ = (number % 10) + '0';
	  number /= 10;
	  length--;
	} while (number);
	while (length-- > 0) {
	  *str++ = pad_char;
	}
	do {
	  *ptr++ = *--str;
	} while (str != buff);
	break;
      case 'x':
      case 'X':		/* 16		*/
	str = buff;
	number = (unsigned int)*ap++;
	if (*fmt == 'X') {
	  do {
	    *str++ = large_hex_char[number % 0x10];
	    number >>= 4;
	    length--;
	  } while (number);
	} else {
	  do {
	    *str++ = small_hex_char[number % 0x10];
	    number >>= 4;
	    length--;
	  } while (number);
	}
	while (length-- > 0) {
	  *str++ = pad_char;
	}
	do {
	  *ptr++ = *--str;
	} while (str != buff);
	break;
      case 's':		/* ʸ	*/
      case 'S':
	str = (char*)*ap++;
	if (length) {
	  length -= strlen(str);
	  while (length-- > 0) {
	    *ptr++ = pad_char;
	  }
	}
	while (*str) {
	  *ptr++ = *str++;
	}
	break;
      default:
	*ptr++ = *fmt;
	break;
      }
      fmt++;
      break;
    case '\\':
      switch (*(++fmt)) {
      case 'n':
	*ptr++ = '\n';
	break;
      case 'r':
	*ptr++ = '\r';
	break;
      case 't':
	*ptr++ = '\t';
	break;
      default:
	*ptr++ = *fmt;
	break;
      }
      fmt++;
      break;
    default:
      *ptr++ = *fmt++;
      break;
    }
  }
  *ptr = '\0';
  return((int)(ptr - top));
}
#endif	/* notdef */

#ifdef	DONT_HAVE_VSPRINTF
int	vsprintf(str, fmt, ap)
     char *str;
     char *fmt;
     va_list ap;
{
  FILE	ff;
  int	length;
  
  ff._ptr = str;
  ff._flag = _IOSTRG | _IOWRT;
  ff._cnt = 32767;
  length = _doprnt(fmt, ap, &ff);
  *ff._ptr = 0;
  return(length);
}
#endif	/* DONT_HAVE_VSPRINTF */

/*
 * Ƚ
 * (JIS-X0201 θʤ)
 */

KANJICODE	discriminate_code(ptr)
     unsigned char	*ptr;
{
  register int	status = 0;

  while (*ptr) {
    if (*ptr == ESC_CODE) {
      if ((!strncmp(ptr, JIS_IN1, 3)) || (!strncmp(ptr, JIS_IN2, 3)) ||
	  (!strncmp(ptr, JIS_IN3, 4)) ||
#ifdef	SUPPORT_X0201
	  (!strncmp(ptr, JIS_X0201, 3)) ||
#endif	/* SUPPORT_X0201 */
	  (!strncmp(ptr, JIS_X0212, 4))) {
	return(JIS_CODE);
      } else {
	ptr++;
      }
    } else if (*ptr > 0x80) {
      if ((*ptr > 0xa0 && *ptr < 0xe0) || (*ptr > 0xfc)) {
	return(EUC_CODE);
      } else if (*ptr >= 0xe0) {
	ptr++;
	if (*ptr <= 0xa0) {
	  if ((*(ptr + 1) < 0x40) || (*(ptr + 1) == 0x7f) ||
	      (*(ptr + 1) > 0xfc)) {
	    return(UNKNOWN_CODE);
	  } else {
	    return(SJIS_CODE);
	  }
	} else if (*ptr > 0xfc) {
	  return(EUC_CODE);
	} else {
	  ptr++;
	  status = (int)UNKNOWN_CODE;
	}
      } else {
	if ((*(ptr + 1) < 0x40) || (*(ptr + 1) == 0x7f) ||
	    (*(ptr + 1) > 0xfc)) {
	  return(UNKNOWN_CODE);
	} else {
	  return(SJIS_CODE);
	}
      }
    } else {
      ptr++;
    }
  }
  if (status) {
    return((KANJICODE)status);
  }
  return(ASCII_CODE);
}

/*
 * Ƚ
 * (JIS-X0201 θ)
 */

KANJICODE	discriminate_code2(ptr)
     unsigned char	*ptr;
{
  register int	status = 0;

  while (*ptr) {
    if (*ptr == ESC_CODE) {
      if ((!strncmp(ptr, JIS_IN1, 3)) || (!strncmp(ptr, JIS_IN2, 3)) ||
	  (!strncmp(ptr, JIS_IN3, 4)) ||
#ifdef	SUPPORT_X0201
	  (!strncmp(ptr, JIS_X0201, 3)) ||
#endif	/* SUPPORT_X0201 */
	  (!strncmp(ptr, JIS_X0212, 4))) {
	return(JIS_CODE);
      } else {
	ptr++;
      }
    } else if (*ptr > 0x80) {
#ifdef	SUPPORT_X0201
      if (*ptr == EUC_SS2) {
	if ((*(ptr + 1) > 0xa0) && (*(ptr + 1) < 0xe0)) {
	  status = UNKNOWN_CODE;
	  ptr += 2;
	  continue;
	}
      } else if ((*ptr > 0xa0) && (*ptr < 0xe0)) {
	if (*(ptr + 1) <= 0xa0) {
	  return(SJIS_CODE);
	} else if (*(ptr + 1) > 0xfc) {
	  return(EUC_CODE);
	} else {
	  status = UNKNOWN_CODE;
	  ptr += 2;
	  continue;
	}
      }
#endif	/* SUPPORT_X0201 */
      if ((*ptr > 0xa0 && *ptr < 0xe0) || (*ptr > 0xfc)) {
	return(EUC_CODE);
      } else if (*ptr >= 0xe0) {
	ptr++;
	if (*ptr <= 0xa0) {
	  if ((*(ptr + 1) < 0x40) || (*(ptr + 1) == 0x7f) ||
	      (*(ptr + 1) > 0xfc)) {
	    return(UNKNOWN_CODE);
	  } else {
	    return(SJIS_CODE);
	  }
	} else if (*ptr > 0xfc) {
	  return(EUC_CODE);
	} else {
	  ptr++;
	  status = (int)UNKNOWN_CODE;
	}
      } else {
	if ((*(ptr + 1) < 0x40) || (*(ptr + 1) == 0x7f) ||
	    (*(ptr + 1) > 0xfc)) {
	  return(UNKNOWN_CODE);
	} else {
	  return(SJIS_CODE);
	}
      }
    } else {
      ptr++;
    }
  }
  if (status) {
    return((KANJICODE)status);
  }
  return(ASCII_CODE);
}

/*
 * ɼưȽ̢JIS ʸѴ
 */

KANJICODE	to_jis(ptr1, ptr2, default_code)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     KANJICODE		default_code;
{
  switch (discriminate_code(ptr2)) {
  case ASCII_CODE:
    strcpy2(ptr1, ptr2);
    return(ASCII_CODE);
    break;
  case JIS_CODE:
    jis_to_jis(ptr1, ptr2);
    return(JIS_CODE);
    break;
  case SJIS_CODE:
    sjis_to_jis(ptr1, ptr2);
    return(SJIS_CODE);
    break;
  case EUC_CODE:
    euc_to_jis(ptr1, ptr2);
    return(EUC_CODE);
    break;
  default:
    break;
  }
  switch (default_code) {
  case ASCII_CODE:
    strcpy2(ptr1, ptr2);
    return(ASCII_CODE);
    break;
  case JIS_CODE:
    jis_to_jis(ptr1, ptr2);
    return(JIS_CODE);
    break;
  case SJIS_CODE:
    sjis_to_jis(ptr1, ptr2);
    return(SJIS_CODE);
    break;
  case EUC_CODE:
    euc_to_jis(ptr1, ptr2);
    return(EUC_CODE);
    break;
  default:
    break;
  }
  strcpy2(ptr1, ptr2);
  return(UNKNOWN_CODE);
}

/*
 * ɼưȽ̢SJIS ʸѴ
 */

KANJICODE	to_sjis(ptr1, ptr2, default_code)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     KANJICODE		default_code;
{
  switch (discriminate_code(ptr2)) {
  case ASCII_CODE:
    strcpy2(ptr1, ptr2);
    return(ASCII_CODE);
    break;
  case JIS_CODE:
    jis_to_sjis(ptr1, ptr2);
    return(JIS_CODE);
    break;
  case SJIS_CODE:
    strcpy2(ptr1, ptr2);
    return(SJIS_CODE);
    break;
  case EUC_CODE:
    euc_to_sjis(ptr1, ptr2);
    return(EUC_CODE);
    break;
  default:
    break;
  }
  switch (default_code) {
  case ASCII_CODE:
    strcpy2(ptr1, ptr2);
    return(ASCII_CODE);
    break;
  case JIS_CODE:
    jis_to_sjis(ptr1, ptr2);
    return(JIS_CODE);
    break;
  case SJIS_CODE:
    strcpy2(ptr1, ptr2);
    return(SJIS_CODE);
    break;
  case EUC_CODE:
    euc_to_sjis(ptr1, ptr2);
    return(EUC_CODE);
    break;
  default:
    break;
  }
  strcpy2(ptr1, ptr2);
  return(UNKNOWN_CODE);
}

/*
 * ɼưȽ̢EUC ʸѴ
 */

KANJICODE	to_euc(ptr1, ptr2, default_code)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     KANJICODE		default_code;
{
  switch (discriminate_code(ptr2)) {
  case ASCII_CODE:
    strcpy2(ptr1, ptr2);
    return(ASCII_CODE);
    break;
  case JIS_CODE:
    jis_to_euc(ptr1, ptr2);
    return(JIS_CODE);
    break;
  case SJIS_CODE:
    sjis_to_euc(ptr1, ptr2);
    return(SJIS_CODE);
    break;
  case EUC_CODE:
    strcpy2(ptr1, ptr2);
    return(EUC_CODE);
    break;
  default:
    break;
  }
  switch (default_code) {
  case ASCII_CODE:
    strcpy2(ptr1, ptr2);
    return(ASCII_CODE);
    break;
  case JIS_CODE:
    jis_to_euc(ptr1, ptr2);
    return(JIS_CODE);
    break;
  case SJIS_CODE:
    sjis_to_euc(ptr1, ptr2);
    return(SJIS_CODE);
    break;
  case EUC_CODE:
    strcpy2(ptr1, ptr2);
    return(EUC_CODE);
    break;
  default:
    break;
  }
  strcpy2(ptr1, ptr2);
  return(UNKNOWN_CODE);
}

/*
 * ʸ󥳥ԡ()
 */

int	kanji_strncpy(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  register int	kanji = 0;
  unsigned char	*ptr3;
  
  ptr3 = ptr2;
  while (count > 0) {
    if (!*ptr2) {
      break;
    } else if (*ptr2 == ESC_CODE) {
      if ((!strncmp(ptr2, JIS_IN1, 3)) || (!strncmp(ptr2, JIS_IN2, 3))) {
	
	/*	ؼ	*/
	
	kanji = 1;
	strcpy(ptr1, jis_in);
	ptr1 += jis_in_len;
	ptr2 += 3;
      } else if (!strncmp(ptr2, JIS_IN3, 4)) {
	
	/*	ؼ	*/
	
	kanji = 1;
	strcpy(ptr1, jis_in);
	ptr1 += jis_in_len;
	ptr2 += 4;
      } else if ((!strncmp(ptr2, JIS_OUT1, 3))
		 || (!strncmp(ptr2, JIS_OUT2, 3))) {
	
	/*	޻ؼ	*/
	
	kanji = 0;
	strcpy(ptr1, jis_out);
	ptr1 += jis_out_len;
	ptr2 += 3;
      } else if (!strncmp(ptr2, JIS_X0212, 4)) {
	
	/*	ؼ	*/
	
	kanji = 2;
	strcpy(ptr1, JIS_X0212);
	ptr1 += 4;
	ptr2 += 4;
      } else {
	*ptr1++ = *ptr2++;
	count--;
      }
    } else if (kanji || (*ptr2 & 0x80)) {
      if (count < 2) {
	count = 0;
      } else {
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	count -= 2;
      }
    } else {
      *ptr1++ = *ptr2++;
      count--;
    }
  }
  if (kanji) {
    strcpy(ptr1, jis_out);
    ptr1 += jis_out_len;
  }
  *ptr1 = '\0';
  return(ptr2 - ptr3);
}

/*
 * ʸ󥳥ԡ(ѥǥͭ)
 */

int	kanji_strncpy2(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  register int	kanji = 0;
  unsigned char	*ptr3;

  ptr3 = ptr2;
  while (count > 0) {
    if (!*ptr2) {
      break;
    } else if (*ptr2 == ESC_CODE) {
      if ((!strncmp(ptr2, JIS_IN1, 3)) || (!strncmp(ptr2, JIS_IN2, 3))) {
	
	/*	ؼ	*/
	
	kanji = 1;
	strcpy(ptr1, jis_in);
	ptr1 += jis_in_len;
	ptr2 += 3;
      } else if (!strncmp(ptr2, JIS_IN3, 4)) {
	
	/*	ؼ	*/
	
	kanji = 1;
	strcpy(ptr1, jis_in);
	ptr1 += jis_in_len;
	ptr2 += 4;
      } else if ((!strncmp(ptr2, JIS_OUT1, 3))
		 || (!strncmp(ptr2, JIS_OUT2, 3))) {
	
	/*	޻ؼ	*/
	
	kanji = 0;
	strcpy(ptr1, jis_out);
	ptr1 += jis_out_len;
	ptr2 += 3;
      } else if (!strncmp(ptr2, JIS_X0212, 4)) {
	
	/*	ؼ	*/
	
	kanji = 2;
	strcpy(ptr1, JIS_X0212);
	ptr1 += 4;
	ptr2 += 4;
      } else {
	*ptr1++ = *ptr2++;
	count--;
      }
    } else if (kanji || (*ptr2 & 0x80)) {
      if (count < 2) {
	break;
      } else {
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	count -= 2;
      }
    } else {
      *ptr1++ = *ptr2++;
      count--;
    }
  }
  if (kanji) {
    strcpy(ptr1, jis_out);
    ptr1 += jis_out_len;
  }
  while (count-- > 0) {
    *ptr1++ = ' ';
  }
  *ptr1 = '\0';
  return(ptr2 - ptr3);
}

/*
 * ʸ󥳥ԡ()
 */

int	kanji_strcpy2(ptr1, ptr2, count)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		count;
{
  register int	kanji = 0;

  while (count > 0) {
    while (*ptr2) {
      if (*ptr2 == ESC_CODE) {
	if ((!strncmp(ptr2, JIS_IN1, 3)) || (!strncmp(ptr2, JIS_IN2, 3))) {
	  kanji = 1;
	  ptr2 += 3;
	} else if (!strncmp(ptr2, JIS_IN3, 4)) {
	  ptr2 += 4;
	  kanji = 1;
	} else if ((!strncmp(ptr2, JIS_OUT1, 3))
		   || (!strncmp(ptr2, JIS_OUT2, 3))) {
	  ptr2 += 3;
	  kanji = 0;
	} else if (!strncmp(ptr2, JIS_X0212, 4)) {
	  ptr2 += 4;
	  kanji = 2;
	} else {
	  ptr2++;
	  count--;
	}
      } else if (kanji || (*ptr2 & 0x80)) {
	ptr2 += 2;
	count -= 2;
      } else {
	ptr2++;
	count--;
      }
    }
  }
  switch (kanji) {
  case 1:
    sprintf((char*)ptr1, "%s%s", jis_in, ptr2);
    break;
  case 2:
#ifdef	DELETE_X0212
    strcpy(ptr1, ptr2);
#else	/* !DELETE_X0212 */
    sprintf((char*)ptr1, "%s%s", JIS_X0212, ptr2);
#endif	/* !DELETE_X0212 */
    break;
  default:
    strcpy(ptr1, ptr2);
    break;
  }
  return(strlen(ptr2));
}

/*
 * ʸ󥫥
 */

int	kanji_strlen(ptr)
     unsigned char	*ptr;
{
  
  register int	count = 0;

  while (*ptr) {
    if (*ptr == ESC_CODE) {
      if ((!strncmp(ptr, JIS_IN1, 3)) || (!strncmp(ptr, JIS_IN2, 3))) {
	ptr += 3;
#ifdef	SUPPORT_X0201
      } else if (!strncmp(ptr, JIS_X0201, 3)) {
	ptr += 3;
#endif	/* SUPPORT_X0201 */
      } else if ((!strncmp(ptr, JIS_IN3, 4))
		 || (!strncmp(ptr, JIS_X0212, 4))) {
	ptr += 4;
      } else if ((!strncmp(ptr, JIS_OUT1, 3))
		 || (!strncmp(ptr, JIS_OUT2, 3))) {
	ptr += 3;
      } else {
	ptr++;
	count++;
      }
    } else {
      ptr++;
      count++;
    }
  }
  return(count);
}

/*
 * ʸɽ
 */

#ifdef	DONT_HAVE_DOPRNT
void	kanji_printf(default_code, fmt,
		     arg1, arg2, arg3, arg4, arg5, arg6)
     int	default_code;
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  kanji_fprintf(default_code, stdout, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	kanji_printf(int default_code, char *fmt, ...)
#else	/* !__STDC__ */
void	kanji_printf(default_code, fmt, va_alist)
     int	default_code;
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    to_jis(buff2, buff1, default_code);
    break;
  case SJIS_CODE:
    to_sjis(buff2, buff1, default_code);
    break;
  case EUC_CODE:
    to_euc(buff2, buff1, default_code);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  printf("%s", buff2);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

/*
 * ʸ
 */

#ifdef	DONT_HAVE_DOPRNT
void	kanji_fprintf(default_code, fp, fmt,
		      arg1, arg2, arg3, arg4, arg5, arg6)
     int	default_code;
     FILE	*fp;
     char	*fmt;
     int	arg1, arg2, arg3, arg4, arg5, arg6;
{
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];

  sprintf(buff1, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
  switch (print_code) {
  case JIS_CODE:
    to_jis(buff2, buff1, default_code);
    break;
  case SJIS_CODE:
    to_sjis(buff2, buff1, default_code);
    break;
  case EUC_CODE:
    to_euc(buff2, buff1, default_code);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
}
#else	/* !DONT_HAVE_DOPRNT */
#ifdef	__STDC__
void	kanji_fprintf(int default_code, FILE *fp, char *fmt, ...)
#else	/* !__STDC__ */
void	kanji_fprintf(default_code, fp, fmt, va_alist)
     int	default_code;
     FILE	*fp;
     char	*fmt;
#endif	/* !__STDC__ */
{
  va_list	ap;
  char		buff1[BUFF_SIZE];
  char		buff2[BUFF_SIZE];
  
#ifdef	__STDC__
  va_start(ap, fmt);
#else	/* !__STDC__ */
  va_start(ap);
#endif	/* !__STDC__ */
#ifdef	notdef
  bsprintf(buff1, fmt, ap);
#else	/* !notdef */
  vsprintf(buff1, fmt, ap);
#endif	/* !notdef */
  switch (print_code) {
  case JIS_CODE:
    to_jis(buff2, buff1, default_code);
    break;
  case SJIS_CODE:
    to_sjis(buff2, buff1, default_code);
    break;
  case EUC_CODE:
    to_euc(buff2, buff1, default_code);
    break;
  default:
    strcpy2(buff2, buff1);
    break;
  }
  fprintf(fp, "%s", buff2);
  va_end(ap);
}
#endif	/* !DONT_HAVE_DOPRNT */

#ifdef	MNEWS
/*
 * ESC  JIS ʸ
 */

void	recover_jis(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  unsigned char		*ptr3;
  unsigned char		*ptr4;
  register CHARSET	charset = ROMAN_CHAR;

  if ((!ptr1) || (!ptr2)) {
    return;
  }
  ptr3 = ptr1;
  ptr4 = ptr2;
  while (*ptr2) {
#ifdef	notdef
    if (charset &&
	((!strncmp(ptr2, DJIS_OUT1, 2)) || (!strncmp(ptr2, DJIS_OUT2, 2)))) {
      strcpy(ptr1, jis_out);
      charset = ROMAN_CHAR;
      ptr1 += jis_out_len;
      ptr2 += 2;
      continue;
    }
    if ((!strncmp(ptr2, DJIS_IN1, 2)) || (!strncmp(ptr2, DJIS_IN2, 2))) {
      charset = KANJI_CHAR;
      strcpy(ptr1, jis_in);
      ptr1 += jis_in_len;
      ptr2 += 2;
    } else if (!strncmp(ptr2, DJIS_IN3, 3)) {
      charset = KANJI_CHAR;
      strcpy(ptr1, jis_in);
      ptr1 += jis_in_len;
      ptr2 += 3;
#ifdef	SUPPORT_X0201
    } else if (!strncmp(ptr2, DJIS_X0201, 2)) {
      charset = KANA_CHAR;
      strcpy(ptr1, JIS_X0201);
      ptr1 += 3;
      ptr2 += 2;
#endif	/* SUPPORT_X0201 */
    } else if (!strncmp(ptr2, DJIS_X0212, 3)) {
      charset = HOJO_CHAR;
      strcpy(ptr1, JIS_X0212);
      ptr1 += 4;
      ptr2 += 3;
    } else if (*ptr2 == ESC_CODE) {
      strcpy(ptr3, ptr4);
      return;
    } else {
      switch (charset) {
      case KANJI_CHAR:
      case HOJO_CHAR:
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	break;
      case ROMAN_CHAR:
      case KANA_CHAR:
      default:
	*ptr1++ = *ptr2++;
	break;
      }
    }
#else	/* !notdef */
    if (charset &&
	((!strncmp(ptr2, DJIS_OUT1, 2)) || (!strncmp(ptr2, DJIS_OUT2, 2)))) {
      strcpy(ptr1, jis_out);
      charset = ROMAN_CHAR;
      ptr1 += jis_out_len;
      ptr2 += 2;
      continue;
    } else if ((charset != KANJI_CHAR) &&
	       ((!strncmp(ptr2, DJIS_IN1, 2))
		|| (!strncmp(ptr2, DJIS_IN2, 2)))) {
      charset = KANJI_CHAR;
      strcpy(ptr1, jis_in);
      ptr1 += jis_in_len;
      ptr2 += 2;
    } else if ((charset != KANJI_CHAR) && (!strncmp(ptr2, DJIS_IN3, 3))) {
      charset = KANJI_CHAR;
      strcpy(ptr1, jis_in);
      ptr1 += jis_in_len;
      ptr2 += 3;
#ifdef	SUPPORT_X0201
    } else if ((charset != KANA_CHAR) && (!strncmp(ptr2, DJIS_X0201, 2))) {
      charset = KANA_CHAR;
      strcpy(ptr1, JIS_X0201);
      ptr1 += 3;
      ptr2 += 2;
#endif	/* SUPPORT_X0201 */
    } else if ((charset != HOJO_CHAR) && (!strncmp(ptr2, DJIS_X0212, 3))) {
      charset = HOJO_CHAR;
      strcpy(ptr1, JIS_X0212);
      ptr1 += 4;
      ptr2 += 3;
    } else if (*ptr2 == ESC_CODE) {
      strcpy(ptr3, ptr4);
      return;
    } else {
      switch (charset) {
      case KANJI_CHAR:
      case HOJO_CHAR:
	*ptr1++ = *ptr2++;
	*ptr1++ = *ptr2++;
	break;
      case ROMAN_CHAR:
      case KANA_CHAR:
      default:
	*ptr1++ = *ptr2++;
	break;
      }
    }
#endif	/* !notdef */
  }
  if (charset) {
    strcpy(ptr1, jis_out);
  } else {
    *ptr1 = '\0';
  }
}
#endif	/* MNEWS */

#ifdef	DISPLAY_CTRL
static void	strcpy2(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  while (*ptr2) {
    if (*ptr2 == ESC_CODE) {
      *ptr1++ = '^';
      *ptr1++ = '[';
      ptr2++;
    } else {
      *ptr1++ = *ptr2++;
    }
  }
  *ptr1 = '\0';
}
#endif	/* DISPLAY_CTRL */
