/*
 *
 *  ߥˡ˥塼꡼
 *
 *  Copyright 1993-1995 Matsushita Soft Research, INC. A.Takuma
 *
 *  System      : Mini News Reader
 *  Sub system  : MIME encode/decode routine
 *  File        : mime.c
 *  Version     : 1.19
 *  First Edit  : 1993-08/09
 *  Last  Edit  : 1995-06/14
 *  Author      : MSR24  
 *
 */

#include	"compat.h"
#include	"kanjilib.h"
#ifdef	MNEWS
#include	"nntplib.h"
#include	"mnews.h"
#endif	/* MNEWS */
#include	"mime.h"

#ifdef	MIME
#define mime_charB64(c)  (((c) < 0 || (c) > 0x7f) ? -1 : \
			  mime_base64_index[(c)])

static char	mime_base64_index[] = {
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,
  52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1,
  -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,
  15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,
  -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
  41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1,
};

#ifdef	notdef
#define mime_charB16(c)  (((c) < 0 || (c) > 0x7f) ? -1 : \
			  mime_base16_index[(c)])

static char	mime_base16_index[] = {
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
     0,  1,  2,  3,  4,  5,  6,  7,  8,  9, -1, -1, -1, -1, -1, -1,
    -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
};
#endif	/* notdef */

static char	mime_base64_basis[] =
  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
#ifdef	SUPPORT_QP_ENCODE
static char	mime_base16_basis[] = "0123456789ABCDEF";
#endif	/* SUPPORT_QP_ENCODE */

static char	mime_especials[] = "()<>@,;:\\/[]?.=";

#ifdef	SUPPORT_QP_ENCODE
static char	*mime_encodeQ();
#endif	/* SUPPORT_QP_ENCODE */
static char	*mime_decodeQ();
static char	*mime_encodeB64();
static char	*mime_decodeB64();
static char	*mime_outputB64();
static int	mime_boundaryB64();
static char	*strcheck();
static char	*strcasecheck();

#ifdef	MNEWS
/*
 * MIME 󥳡(EUC )
 */

int	mime_encode_jis(ptr1, ptr2, hint_code)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		hint_code;
{
  char	buff[BUFF_SIZE];

  to_jis(buff, ptr2, hint_code);
  return(mime_encode(buff, ptr1));
}

/*
 * MIME ǥ(EUC )
 */

int	mime_decode_euc(ptr1, ptr2, hint_code)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
     int		hint_code;
{
  int	mime;
  char	buff[BUFF_SIZE];

  mime = mime_decode(ptr2, buff);
  to_euc(ptr1, buff, hint_code);
  return(mime);
}
#endif	/* MNEWS */

/*
 * MIME 󥳡
 * (ISO-2022-JP2 бԴ)
 */

int	mime_encode(ptr1, ptr2)
     char	*ptr1;
     char	*ptr2;
{
  static char	*sequence[] = {
    JIS_OUT1,
    JIS_OUT2,
    JIS_IN1,
    JIS_IN2,
    JIS_IN3,
#ifdef	SUPPORT_JP2
    JIS_X0212,			/* JIS-X0212()	*/
    "\033$A",			/* GB2312-1980(Chinese)	*/
    "\033$(C",			/* KSC5601-1987(Korean)	*/
    "\033.A",			/* ISO-8859-1(Latin-1)	*/
    "\033.B",			/* ISO-8859-2(Latin-2)	*/
    "\033.C",			/* ISO-8859-3(Latin-3)	*/
    "\033.D",			/* ISO-8859-4(Latin-4)	*/
    "\033.E",			/* ISO-8859-5(Yawerty?)	*/
    "\033.F",			/* ISO-8859-6(Unknown)	*/
    "\033.G",			/* ISO-8859-7(Greek)	*/
    "\033.H",			/* ISO-8859-8(Unknown)	*/
    "\033.I",			/* ISO-8859-9(Latin-5)	*/
#endif	/* SUPPORT_JP2 */
  };
  int		mime;
  register int	count, i, j;
  int		lastchar;
  char		*ptr3, *ptr4;
  char		*kanji;
  char		buff[BUFF_SIZE];

  mime = count = lastchar = 0;
  ptr3 = ptr4 = NULL;
  while (*ptr1) {
    if ((*ptr1 == ' ') || (*ptr1 == '\t')) {

      /*
       * Υեǥ󥰽ϤäȤø᤮뤫⡣
       */

      if (count >= MAX_ENCODE_COLUMN) {
	*ptr2++ = '\n';
	*ptr2++ = '\t';
	lastchar = 0;
	count = 8;
      }
#ifdef	ENCODE_SPACE
      if (!ptr3) {
	ptr3 = ptr1;
	ptr4 = ptr2;
      }
#else	/* !ENCODE_SPACE */
      ptr3 = ptr4 = NULL;
#endif	/* !ENCODE_SPACE */
      lastchar = 0;
      *ptr2++ = *ptr1++;
      count++;
    } else if (*ptr1 == '\n') {
      lastchar = *ptr1;
      *ptr2++ = *ptr1++;
      ptr3 = NULL;
      count = 0;
    } else if (((unsigned char)*ptr1 >= ' ') &&
	       ((unsigned char)*ptr1 <= 0x7f)) {
      lastchar = *ptr1;
      *ptr2++ = *ptr1++;
      ptr3 = NULL;
      count++;
    } else {
      mime = 1;
      if (ptr3) {
	ptr2 = ptr4;
      } else {
	ptr3 = ptr1;
      }
      kanji = NULL;

      /*
       * եǥ󥰤θĤĥ󥳡ɤ뤤øʥ롼
       */

      while (*ptr1) {
	if (count >
	    (MAX_ENCODE_COLUMN - MIME_SEP_SIZE1 - MIME_SEP_SIZE2 - 12)) {
	  *ptr2++ = '\n';
	  *ptr2++ = '\t';
	  lastchar = 0;
	  count = 8;
	}
	if (lastchar) {
	  if (!strchr(mime_especials, lastchar)) {
	    *ptr2++ = ' ';
	    count++;
	  }
	  lastchar = 0;
	}
	sprintf(ptr2, "%s%s%c%c%c", MIME_ENCODE_START, MIME_CHARSET_ISO2022_1,
		MIME_SEPARATER, MIME_ENCODE_BASE64, MIME_SEPARATER);
	while (*ptr2) {
	  ptr2++;
	  count++;
	}
	ptr3 = buff;
	if (kanji) {
	  strcpy(ptr3, kanji);
	  ptr3 += strlen(kanji);
	}
	while (*ptr1) {
	  if ((count + ((int)(ptr3 - buff) * 4) / 3) >
	      (MAX_ENCODE_COLUMN - MIME_SEP_SIZE2 - 12)) {
	    break;
	  }
	  while (*ptr1 == ESC_CODE) {	/*  if ǽʬ while ʸ */
	    for (i = 0; i < sizeof(sequence)/sizeof(char*); i++) {
	      j = strlen(sequence[i]);
	      if (!strncmp(ptr1, sequence[i], j)) {
		strncpy(ptr3, ptr1, j);
		ptr1 += j;
		ptr3 += j;
		if (i < 2) {
		  kanji = NULL;
		} else {
		  kanji = sequence[i];
		}
		i = -1;
		break;
	      }
	    }
	    if (i >= 0) {
	      break;
	    }
	  }
	  if (kanji) {			/*  ISO-2022-JP-2 Τ̤θ */
	    *ptr3++ = *ptr1++;
	    *ptr3++ = *ptr1++;
	  } else {
	    if ((unsigned char)*ptr1 > 0x7f) {
	      *ptr3++ = *ptr1++;	/* ͽ̥ */
	    } else if ((*ptr1 == ' ') || (*ptr1 == '\t')) {
#ifdef	ENCODE_SPACE
	      while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
		*ptr3++ = ptr1++;
	      }
#else	/* !ENCODE_SPACE */
	      break;
#endif	/* !ENCODE_SPACE */
	    } else {
	      break;			/* ͽ̥ */
	    }
	  }
	}
	if (kanji) {
	  strcpy(ptr3, JIS_OUT);
	} else {
	  *ptr3 = '\0';
	}
	ptr3 = ptr2;
	ptr2 = mime_encodeB64(buff, ptr2);
	strcpy(ptr2, MIME_ENCODE_END);
	while (*ptr2) {
	  ptr2++;
	}
	count += strlen(ptr3);
	if (!kanji) {
	  break;
	}
      }
      if (*ptr1 && (*ptr1 != ' ') && (*ptr1 != '\t')
	  && (!strchr(mime_especials, *ptr1))) {
	*ptr2++ = ' ';
	count++;
      }
      ptr3 = NULL;
    }
  }
  *ptr2 = '\0';
  return(mime);
}

/*
 * MIME ǥ
 * (ISO-2022-JP2 бԴ)
 */

int	mime_decode(ptr1, ptr2)
     char	*ptr1;
     char	*ptr2;
{
  int	mime;
  int	encode;
  char	*ptr3, *ptr4, *ptr5;
  char	buff[BUFF_SIZE];

  mime = 0;
  ptr4 = NULL;
  while (*ptr1) {
    if (ptr3 = strcheck(ptr1, MIME_ENCODE_START)) {
      ptr5 = ptr3;
#ifdef	SUPPORT_JP2
      if ((!(ptr3 = strcasecheck(ptr5, MIME_CHARSET_ISO2022_1))) &&
	  (!(ptr3 = strcasecheck(ptr5, MIME_CHARSET_ISO2022_2)))) {
	if (!(ptr3 = strcasecheck(ptr5, MIME_CHARSET_ASCII))) {
	  ptr3 = strcasecheck(ptr5, MIME_CHARSET_ISO8859);
	  if (ptr3) {
	    if (isdigit(*ptr3)) {	/* øʥå */
	      ptr3++;
	    } else {
	      ptr3 = NULL;
	    }
	  }
	}
#else	/* !SUPPORT_JP2 */
      if (!(ptr3 = strcasecheck(ptr5, MIME_CHARSET_ISO2022_1))) {
	ptr3 = strcasecheck(ptr5, MIME_CHARSET_ASCII);
#endif	/* !SUPPORT_JP2 */
      }
      if (ptr3) {
	if (*ptr3++ == MIME_SEPARATER) {
	  switch (*ptr3++) {
	  case MIME_ENCODE_QP:
	    encode = 1;
	    break;
	  case MIME_ENCODE_BASE64:
	    encode = 2;
	    break;
	  default:
	    encode = 0;
	    break;
	  }
	  if (encode) {
	    if (*ptr3++ == MIME_SEPARATER) {
	      ptr1 = ptr3;
	      if (ptr3 = strindex(ptr1, MIME_ENCODE_END)) {
		strcpy(buff, ptr1);
		buff[ptr3 - ptr1] = '\0';
		mime = 1;
		if (ptr4) {
		  ptr2 = ptr4;
		  ptr4 = NULL;
		}
		if (encode == 1) {
		  ptr2 = mime_decodeQ(buff, ptr2);
		} else {
		  ptr2 = mime_decodeB64(buff, ptr2, NULL, 0);
		}
		ptr1 = ptr3 + sizeof(MIME_ENCODE_END) - 1;
#ifdef	ENCODE_SPACE
		while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
		  ptr1++;
		}
#endif	/* ENCODE_SPACE */
		continue;
	      }
	    }
	  }
	}
      }
    }
#ifdef	ENCODE_SPACE
    if ((*ptr1 == ' ') || (*ptr1 == '\t')) {
      ptr4 = ptr2;
      while ((*ptr1 == ' ') || (*ptr1 == '\t')) {
	*ptr2++ = *ptr1++;
      }
    } else {
      ptr4 = NULL;
      *ptr2++ = *ptr1++;
    }
#else	/* !ENCODE_SPACE */
    ptr4 = NULL;
    *ptr2++ = *ptr1++;
#endif	/* !ENCODE_SPACE */
  }
  *ptr2 = '\0';
  return(mime);
}

/*
 * MIME QP 󥳡
 */

#ifdef	SUPPORT_QP_ENCODE
static char	*mime_encodeQ(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  int	count = 0;

  while (*ptr1) {
    if (((*ptr1 >= ' ') && (*ptr1 < 0x7f)) || (*ptr1 == '\t')) {
      *ptr2++ = *ptr1++;
      count++;
    } else if (*ptr1 == '\n') {
      *ptr2 = '\n';
      count = 0;
    } else {
      *ptr2++ = MIME_PAD_CHAR;
      *ptr2++ = mime_base16_basis[*ptr1 >> 4];
      *ptr2++ = mime_base16_basis[*ptr1 & 0x0f];
      count += 3;
    }
    if (count > (MAX_ENCODE_COLUMN - 3)) {
      *ptr2++ = '\n';
      count = 0;
    }
  }
  *ptr2 = '\0';
  return((char*)ptr2);
}
#endif	/* SUPPORT_QP_ENCODE */

/*
 * MIME QP ǥ
 */

static char	*mime_decodeQ(ptr1, ptr2)
     unsigned char	*ptr1;
     unsigned char	*ptr2;
{
  while (*ptr1) {
    if (*ptr1 == MIME_PAD_CHAR) {
      ptr1++;
      if (isdigit(*ptr1)) {
	*ptr2 = *ptr1++ - '0';
      } else if ((*ptr1 >= 'A') && (*ptr1 <= 'F')) {
	*ptr2 = *ptr1++ - 'A'+ 0xa;
      } else if ((*ptr1 >= 'a') && (*ptr1 <= 'f')) {
	*ptr2 = *ptr1++ - 'a'+ 0xa;
      } else {
	print_warning("Ignoring unrecognized code in MIME-QP.");
	continue;
      }
      *ptr2 = (*ptr2) << 4;
      if (isdigit(*ptr1)) {
	*ptr2 |= *ptr1++ - '0';
	ptr2++;
      } else if ((*ptr1 >= 'A') && (*ptr1 <= 'F')) {
	*ptr2 |= *ptr1++ - 'A'+ 0xa;
	ptr2++;
      } else if ((*ptr1 >= 'a') && (*ptr1 <= 'f')) {
	*ptr2 |= *ptr1++ - 'a'+ 0xa;
	ptr2++;
      } else {
	print_warning("Ignoring unrecognized code in MIME-QP.");
	continue;
      }
    } else {
      *ptr2++ = *ptr1++;
    }
  }
  return((char*)ptr2);
}

/*
 * MIME BASE64 󥳡
 */

static char	*mime_encodeB64(ptr1, ptr2)
     char	*ptr1;
     char	*ptr2;
{
  int	code1, code2, code3;

  while (code1 = *ptr1++) {
    if (code2 = *ptr1++) {
      if (code3 = *ptr1++) {
	ptr2 = mime_outputB64(code1, code2, code3, 0, ptr2);
      } else {
	ptr2 = mime_outputB64(code1, code2, 0, 1, ptr2);
	break;
      }
    } else {
      ptr2 = mime_outputB64(code1, 0, 0, 2, ptr2);
      break;
    }
  }
  *ptr2 = '\0';
  return(ptr2);
}

/*
 * MIME BASE64 ǥ
 */

static char	*mime_decodeB64(ptr1, ptr2, boundaries, boundaryct)
     char	*ptr1;
     char	*ptr2;
     char	**boundaries;
     int	*boundaryct;
{
  char	buff[BUFF_SIZE];
  char	*ptr3;
  int	code1, code2, code3, code4;
  int	newline = 1;
  int	finish = 0;

  while (code1 = *ptr1++) {
    if (isspace(code1)) {
      if (code1 == '\n') {
	newline = 1;
      } else {
	newline = 0;
      }
      continue;
    }
    if (newline && boundaries && (code1 == '-')) {
      ptr1--;
      ptr3 = buff;
      while (*ptr1) {
	*ptr3++ = *ptr1;
	if (*ptr1++ == '\n') {
	  break;
	}
      };
      *ptr3 = '\0';
      if (boundaries && (buff[0] == '-') && (buff[1] == '-')
	  && mime_boundaryB64(buff, boundaries, boundaryct)) {
	*ptr2 = '\0';
	return(ptr2);
      }
      print_warning("Ignoring unrecognized boundary line in MIME-B64.");
      continue;
    }
    if (finish) {
      continue;
    }
    newline = 0;
    do {
      code2 = *ptr1++;
    } while (code2 && isspace(code2));
    if (code2) {
      do {
	code3 = *ptr1++;
      } while (code3 && isspace(code3));
      if (code3) {
	do {
	  code4 = *ptr1++;
	} while (code4 && isspace(code4));
	if (code4) {
	  if ((code1 == MIME_PAD_CHAR) || (code2 == MIME_PAD_CHAR)) {
	    finish = 1;
	    continue;
	  }
	  code1 = mime_charB64(code1);
	  code2 = mime_charB64(code2);
	  *ptr2++ = ((code1 << 2) | ((code2 & 0x30) >> 4));
	  if (code3 == MIME_PAD_CHAR) {
	    finish = 1;
	  } else {
	    code3 = mime_charB64(code3);
	    *ptr2++ = (((code2 & 0x0f) << 4) | ((code3 & 0x3c) >> 2));
	    if (code4 == MIME_PAD_CHAR) {
	      finish = 1;
	    } else {
	      code4 = mime_charB64(code4);
	      *ptr2++ = (((code3 & 0x03) << 6) | code4);
	    }
	  }
	  continue;
	}
      }
    }
    print_warning("Unexpected EOL in MIME-B64.");
    break;
  }
  *ptr2 = '\0';
  return(ptr2);
}

static char	*mime_outputB64(code1, code2, code3, pad, ptr)
     int	code1, code2, code3;
     int	pad;
     char	*ptr;
{
  *ptr++ = mime_base64_basis[code1 >> 2];
  *ptr++ = mime_base64_basis[((code1 & 0x3) << 4) | ((code2 & 0xF0) >> 4)];
  switch (pad) {
  case 2:
    *ptr++ = MIME_PAD_CHAR;
    *ptr++ = MIME_PAD_CHAR;
    break;
  case 1:
    *ptr++ = mime_base64_basis[((code2 & 0xF) << 2) | ((code3 & 0xC0) >> 6)];
    *ptr++ = MIME_PAD_CHAR;
    break;
  case 0:
  default:
    *ptr++ = mime_base64_basis[((code2 & 0xF) << 2) | ((code3 & 0xC0) >> 6)];
    *ptr++ = mime_base64_basis[code3 & 0x3F];
    break;
  }
  return(ptr);
}

static int	mime_boundaryB64(ptr, boundaries, boundaryct)
     char	*ptr;
     char	**boundaries;
     int	*boundaryct;
{
  char		buff[2048];
  register int	i;

  for (i = 0; i < *boundaryct; ++i) {
    if (!strncmp(ptr, boundaries[i], strlen(boundaries[i]))) {
      strcpy(buff, boundaries[i]);
      strcat(buff, "--\n");
      if (!strcmp(buff, ptr)) {
	*boundaryct = i;
      }
      return(1);
    }
  }
  return(0);
}

/*
 * ʸӡܥݥ󥿰ư(ʸʸ)
 */

static char	*strcheck(ptr1, ptr2)
     char	*ptr1;
     char	*ptr2;
{
  register int	n;

  n = strlen(ptr2);
  if (strncmp(ptr1, ptr2, n)) {
    return(NULL);
  }
  return(ptr1 + n);
}

/*
 * ʸӡܥݥ󥿰ư(ʸʸ̤ʤ)
 */

static char	*strcasecheck(ptr1, ptr2)
     char	*ptr1;
     char	*ptr2;
{
  register int	n;

  n = strlen(ptr2);
  if (strncasecmp(ptr1, ptr2, n)) {
    return(NULL);
  }
  return(ptr1 + n);
}
#endif	/* MIME */
